# This script takes the preprepared data files and produces the
# the masked comparison between the buoy record and ERSSTv3/4

# prepare the mask
python maskNxN.py v3.dat v4.dat > mask_ersst.dat
python maskNxN.py icoads1x1.dat mask_ersst.dat > mask.dat

# generate the masked temperature series
foreach name (v3 v4 icoads1x1)
python maskNxN.py $name.dat mask.dat > 1.dat
python mapbaselineNxN.py 1.dat 2001 2011 5 > 2.dat
python tempNxN.py 2.dat > $name.temp
end

# gather them in one file and convert to annual
python collect.py v3.temp v4.temp icoads1x1.temp > all.temp
python annual.py < all.temp > all_annual.temp

# now generate coverage statistics
python cvgNxN.py mask.dat > mask.cvg
python cvgNxN.py mask_ersst.dat > mask_ersst.cvg
python collect.py mask.cvg mask_ersst.cvg | awk '{print $1,$2,$3,$2/$3}' > all.cvg
python annual.py < all.cvg > all_annual.cvg

# The research question is whether the trends differ between the datasets
# To visualize the result we need to baseline on one end of the data, so
# that a difference in trend shows up as separation at the other end.
# However baselining on a short period can produce misleading results.
# So baseline on the first half of the data: 1995-2004 inclusive.
python baseline.py 1994.9 2004.9 < all_annual.temp | awk '/^1995/,/^2014/' > graph.temp
