import math, numpy, sys


# write a month of map data
def write_map( year, month, smap ):
  tmap = reversed( smap )
  lines = ["%4d %2d\n"%(year,month)]
  for row in tmap:
    s = ""
    for val in row:
      if not numpy.isnan(val):
        s += "%7.3f "%(val)
      else:
        s += "-99.9 "
    lines.append( s[:-1] + "\n" )
  return lines


# area of a latitude band by index
def areas( grid ):
  area = grid*[0.0]
  for i in range(grid):
    area[i] = ( ( math.sin(math.radians(180.0*(i+1)/grid-90.0)) -
                  math.sin(math.radians(180.0*(i  )/grid-90.0)) ) /
                math.sin(math.radians(180.0/grid)) )
    #area[i] = math.cos(math.radians(180.0*(i+0.5)/grid-90.0))
  return area


# read data
ids = {}
for l in open(sys.argv[1]):
  #      date,  lat,     lon,     type,    id,      pres,    mat,     wbt,     dpt,     ssttype, sst
  #print l[:12],l[12:17],l[17:23],l[32:34],l[34:43],l[59:64],l[69:73],l[74:78],l[79:83],l[83:85],l[85:89]
  type = l[32:34]
  if type == " 3":
    try:
      yr  = int(l[0:4])
      mn  = int(l[4:6])
      day =      int(l[6:8])
      hr  = 0.01*int(l[8:12])
      lat = 0.01*int(l[12:17])
      lon = 0.01*int(l[17:23])
      sst = 0.1 *int(l[85:89])
      id = l[34:43]
      if not id in ids: ids[id] = {"raw":[]}
      ids[id]["raw"].append( [day,hr,lat,lon,sst] )
    except:
      pass

# make a grid
grid = 5
area = areas( 180/grid )
#sstmap = [[ [] for i in range(360/grid) ]
#               for j in range(180/grid) ]
sstmap = [[ [] for i in range(int(area[j]*360/grid+0.5)) ]
               for j in range(            180/grid     ) ]

# covert to days and filter
for id in ids:
  raw = ids[id]["raw"]
  # extract data
  days = {}
  for rec in raw:
    day,hr,lat,lon,sst = rec
    if not day in days: days[day] = []
    days[day].append([lat,lon,sst])
  # reduce to means
  for day in days:
    data = numpy.array( days[day] )
    # average each day
    mns = numpy.mean(data,axis=0)
    # screen out buoys with excessive variation in a month
    sds = numpy.std (data,axis=0)
    if sds[0]>0.5 or sds[1]>0.5 or sds[2]>1.0:
      days = {}
      break
    days[day] = mns
  # add to grid
  for day in days:
    lat,lon,sst = days[day]
    j = int(math.floor((lat+ 90.0)*len(sstmap)/180.0))
    i = int(math.floor((lon+180.0)%360.0*len(sstmap[j])/360.0))
    sstmap[j][i].append(sst)

# output
t = ".123456789#"
s = ""
for i in reversed(range(36)):
  for j in range(72):
    j1 = j*len(sstmap[i])//72
    k = len(sstmap[i][j1])
    s += t[min(k,10)]
  s += "\n"
print >> sys.stderr, s

# average cells
for i in range(len(sstmap)):
  for j in range(len(sstmap[i])):
    if len(sstmap[i][j])>0:
      sstmap[i][j] = numpy.mean(sstmap[i][j])
    else:
      sstmap[i][j] = numpy.nan

# output map
for l in write_map(yr,mn,sstmap): print l,
