# This program reads a map series sets the baseline for each cell to zero
# on the period date1, date2 for each month of the year. Cells with
# fewer than nmin non-missing values are set to missing for the whole
# series.
# Usage:
#  python mapbaseline.py map.dat 1981 2011 15 > new.map


import sys, math, numpy


# read map data
def read_map( lines ):
  # get latitude
  nlat = len(lines)-1
  for i in range(1,len(lines)):
    if len(lines[i].split()) == len(lines[0].split()):
      nlat = i-1
      break
  print >> sys.stderr, "Lat ", nlat
  # get data
  data = []
  for k in range(0,len(lines),nlat+1):
    w = lines[k].split()
    month,year = sorted( [int(w[0]),int(w[1])] )
    date = year+month/12.0-1.0/24.0
    smap = []
    for j in range(nlat):
      row = []
      w = lines[j+k+1].split()
      for i in range(len(w)):
        if not '.' in w[i]:
          t = 0.01*float(w[i])
        else:
          t = float(w[i])
        if t <= -99.0: t = numpy.nan
        row.append(t)
      smap.append(row)
    smap.reverse()
    data.append( ( year, month, smap ) )
  return data


# write a month of map data
def write_map( year, month, smap ):
  tmap = reversed( smap )
  lines = ["%4d %2d\n"%(year,month)]
  for row in tmap:
    s = ""
    for val in row:
      if not numpy.isnan(val):
        s += "%7.3f "%(val)
      else:
        s += "-99.9 "
    lines.append( s[:-1] + "\n" )
  return lines


# calculate anomaly
def baseline( maps, date1, date2, nmin ):
  for m in range(1,13):
    # calculate baseline
    year,month,tmap = maps[0]
    smap = [ [ 0.0 for j in range(len(tmap[i])) ] for i in range(len(tmap)) ]
    nmap = [ [   0 for j in range(len(tmap[i])) ] for i in range(len(tmap)) ]
    for year,month,tmap in maps:
      if month == m:
        date = year+month/12.0-1.0/24.0
        if date1 < date < date2:
          for i in range(len(smap)):
            for j in range(len(smap[i])):
              if not numpy.isnan(tmap[i][j]):
                smap[i][j] += tmap[i][j]
                nmap[i][j] += 1
    for i in range(len(smap)):
      for j in range(len(smap[i])):
        if nmap[i][j] >= nmin:
          smap[i][j] /= nmap[i][j]
        else:
          smap[i][j] = numpy.nan
    # apply baseline
    for year,month,tmap in maps:
      if month == m:
        for i in range(len(smap)):
          for j in range(len(smap[i])):
            if (not numpy.isnan(tmap[i][j])) and (not numpy.isnan(smap[i][j])):
              tmap[i][j] -= smap[i][j]
            else:
              tmap[i][j] = numpy.nan

# MAIN PROGRAM
# default values
datafile = sys.argv[1]
date11 = float(sys.argv[2])
date21 = float(sys.argv[3])
nmin1 = int(sys.argv[4])

# read data
maps = read_map( open(datafile).readlines() )
nmonths = len(maps)

baseline( maps, date11, date21, nmin1 )
map1 = maps[-1][2]

# text output of maps
t = '.123456789'
opmap = [ [ 0 for j in range(72) ] for i in range(36) ]
for j0 in range(len(map1)):
  j1 = int((j0+0.5)*len(opmap)/len(map1))
  for i0 in range(len(map1[j0])):
    i1 = int((i0+0.5)*len(opmap[j1])/len(map1[j0]))
    if not numpy.isnan(map1[j0][i0]):
      opmap[j1][i1] += 1
s = ""
for j in range(len(opmap)-1,-1,-1):
  for i in range(len(opmap[j])):
    s += t[min(opmap[j][i],9)]
  s += "\n"
print >> sys.stderr, s

for year,month,tmap in maps:
  for l in write_map( year, month, tmap ):
    print l,

