# This program reads two map series and subtracts the second from the first.
# Any cell which is missing in either series is missing in the sum
# Usage:
#  python sub.py map1.dat map2.dat > new.map


import sys, math, numpy


# read map data
def read_map( lines ):
  # get latitude
  nlat = len(lines)-1
  for i in range(1,len(lines)):
    if len(lines[i].split()) == len(lines[0].split()):
      nlat = i-1
      break
  print >> sys.stderr, "Lat ", nlat
  # get data
  data = []
  for k in range(0,len(lines),nlat+1):
    w = lines[k].split()
    month,year = sorted( [int(w[0]),int(w[1])] )
    date = year+month/12.0-1.0/24.0
    smap = []
    for j in range(nlat):
      row = []
      w = lines[j+k+1].split()
      for i in range(len(w)):
        if not '.' in w[i]:
          t = 0.01*float(w[i])
        else:
          t = float(w[i])
        if t <= -99.0: t = numpy.nan
        row.append(t)
      smap.append(row)
    smap.reverse()
    data.append( ( year, month, smap ) )
  return data


# write a month of map data
def write_map( year, month, smap ):
  tmap = reversed( smap )
  lines = ["%4d %2d\n"%(year,month)]
  for row in tmap:
    s = ""
    for val in row:
      if not numpy.isnan(val):
        s += "%7.3f "%(val)
      else:
        s += "-99.9 "
    lines.append( s[:-1] + "\n" )
  return lines


# MAIN PROGRAM
# default values
datafile1 = None
if len(sys.argv) > 1:
  datafile1 = sys.argv[1]

# read data
nmonths = 9999
maps1 = read_map( open(datafile1).readlines() )
nmonths = min(nmonths,len(maps1))

# calculate maps
maps = []
for m in range(nmonths):
  year1,month1,tmap1 = maps1[m]

  tmap2 = [[numpy.nan for i in range(360)] for j in range(180)]
  for i2 in range(len(tmap2)):
    for j2 in range(len(tmap2[i2])):
      i1 = (len(tmap1    )*i2) // len(tmap2    )
      j1 = (len(tmap1[i1])*j2) // len(tmap2[i2])
      tmap2[i2][j2] = tmap1[i1][j1]

  for l in write_map( year1, month1, tmap2 ):
    print l,

