# Calculate area weighted monthly temperatures from map data
# Usage:
#  python temp.py my.dat > my.temp


import sys, math, numpy


# read map data
def read_map( lines ):
  # get latitude
  nlat = len(lines)-1
  for i in range(1,len(lines)):
    if len(lines[i].split()) == len(lines[0].split()):
      nlat = i-1
      break
  print >> sys.stderr, "Lat ", nlat
  # get data
  data = []
  for k in range(0,len(lines),nlat+1):
    w = lines[k].split()
    month,year = sorted( [int(w[0]),int(w[1])] )
    date = year+month/12.0-1.0/24.0
    smap = []
    for j in range(nlat):
      row = []
      w = lines[j+k+1].split()
      for i in range(len(w)):
        if not '.' in w[i]:
          t = 0.01*float(w[i])
        else:
          t = float(w[i])
        if t <= -99.0: t = numpy.nan
        row.append(t)
      smap.append(row)
    smap.reverse()
    data.append( ( year, month, smap ) )
  return data


# write a month of map data
def write_map( year, month, smap ):
  tmap = reversed( smap )
  lines = ["%4d %2d\n"%(year,month)]
  for row in tmap:
    s = ""
    for val in row:
      if not numpy.isnan(val):
        s += "%7.3f "%(val)
      else:
        s += "-99.9 "
    lines.append( s[:-1] + "\n" )
  return lines


# area of a latitude band by index
def areas( grid ):
  area = grid*[0.0]
  for i in range(grid):
    area[i] = ( ( math.sin(math.radians(180.0*(i+1)/grid-90.0)) -
                  math.sin(math.radians(180.0*(i  )/grid-90.0)) ) /
                math.sin(math.radians(180.0/grid)) )
  return area


def mean( tmap ):
  # average over the cells
  area = areas( len(tmap) )
  s0, s1 = 0.0, 0.0
  for lati in range(len(tmap)):
    a = area[lati]/len(tmap[lati])
    for lngi in range(len(tmap[lati])):
      if not numpy.isnan(tmap[lati][lngi]):
        s0 += a
        s1 += a*tmap[lati][lngi]
  return s1/s0


# MAIN PROGRAM
# default values
datafile = None
if len(sys.argv) > 1:
  datafile = sys.argv[1]

# read data
maps = read_map( open(datafile).readlines() )
nmonths = len(maps)

# calculate maps
for year1,month1,tmap1 in maps:
  print year1+month1/12.0-1.0/24.0, mean(tmap1)

