/*
 * Decompiled with CFR 0.152.
 */
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.Writer;

class CharArray
implements CharSequence {
    char[] buf;
    int count = 0;

    private char[] ArraysCopyOf(char[] cArray, int n) {
        char[] cArray2 = new char[n];
        int n2 = Math.min(cArray.length, n);
        for (int i = 0; i < n2; ++i) {
            cArray2[i] = cArray[i];
        }
        return cArray2;
    }

    public CharArray() {
        this.buf = new char[0];
    }

    public CharArray(CharSequence charSequence) {
        int n = charSequence.length();
        this.buf = new char[n];
        this.append(charSequence);
    }

    public CharArray append(CharSequence charSequence) {
        int n = charSequence.length();
        if (this.count + n > this.buf.length) {
            this.buf = this.ArraysCopyOf(this.buf, this.count + n + this.buf.length);
        }
        for (int i = 0; i < n; ++i) {
            this.buf[this.count + i] = charSequence.charAt(i);
        }
        this.count += n;
        return this;
    }

    public CharArray(File file) {
        int n = (int)file.length();
        this.buf = new char[n];
        this.append(file);
    }

    public CharArray append(File file) {
        int n = (int)file.length();
        if (this.count + n > this.buf.length) {
            this.buf = this.ArraysCopyOf(this.buf, this.count + n);
        }
        try {
            FileReader fileReader = new FileReader(file);
            int n2 = ((Reader)fileReader).read(this.buf, this.count, n);
            if (n2 != n) {
                throw new NullPointerException();
            }
            ((Reader)fileReader).close();
        }
        catch (Exception exception) {
            throw new NullPointerException();
        }
        this.count += n;
        return this;
    }

    public CharArray(InputStream inputStream) {
        this.buf = new char[512];
        this.append(inputStream);
    }

    public CharArray append(InputStream inputStream) {
        InputStreamReader inputStreamReader = new InputStreamReader(inputStream);
        try {
            int n = 0;
            while (n >= 0) {
                this.count += n;
                if (this.count > 1000000) {
                    throw new NullPointerException();
                }
                if (this.count == this.buf.length) {
                    this.buf = this.ArraysCopyOf(this.buf, this.buf.length * 2);
                }
                n = inputStreamReader.read(this.buf, this.count, this.buf.length - this.count);
            }
        }
        catch (Exception exception) {
            throw new NullPointerException();
        }
        return this;
    }

    public void writeTo(File file) {
        try {
            FileWriter fileWriter = new FileWriter(file);
            fileWriter.write(new String(this.buf, 0, this.count));
            ((Writer)fileWriter).close();
        }
        catch (Exception exception) {
            throw new NullPointerException();
        }
    }

    public int length() {
        return this.count;
    }

    public char charAt(int n) {
        return this.buf[n];
    }

    public String toString() {
        return new String(this.buf, 0, this.count);
    }

    public CharSequence subSequence(int n, int n2) {
        return new String(this.buf, n, n2 - n);
    }
}

