/*
 * Decompiled with CFR 0.152.
 */
import java.util.ArrayList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class CheckChemistry {
    CheckChemistry() {
    }

    /*
     * WARNING - void declaration
     */
    static String checkValencies(List<Atom> list, String string) {
        void var6_16;
        ArrayList<Bond> arrayList2 = new ArrayList<Bond>();
        for (Atom arrayList3 : list) {
            for (Bond bond : arrayList3) {
                if (bond.atom1 != arrayList3) continue;
                arrayList2.add(bond);
            }
        }
        for (Bond bond : arrayList2) {
            if (bond.type.equals("metal")) {
                bond.atom1.remove(bond);
                bond.atom2.remove(bond);
                continue;
            }
            if (!string.equals("nonRestrictive")) continue;
            if (bond.atom1.symbol.equals("H")) {
                bond.atom2.remove(bond);
            }
            if (!bond.atom2.symbol.equals("H")) continue;
            bond.atom1.remove(bond);
        }
        float f = 0.26f;
        ArrayList<Atom> arrayList = new ArrayList<Atom>();
        for (Atom atom : list) {
            float f2 = 0.0f;
            for (Bond bond : atom) {
                f2 += CheckChemistry.getBondOrder(bond);
            }
            f2 -= atom.charge.floatValue();
            if (atom.symbol.equals("H")) {
                if (f2 == 1.0f && atom.size() <= 1) continue;
                arrayList.add(atom);
                continue;
            }
            if (atom.symbol.equals("F") || atom.symbol.equals("Cl") || atom.symbol.equals("Br") || atom.symbol.equals("I")) {
                if (!(f2 > 7.0f) && atom.size() <= 7) continue;
                arrayList.add(atom);
                continue;
            }
            if (atom.symbol.equals("O")) {
                float f3 = 2.5f;
                if (string.equals("restrictive")) {
                    f3 = 2.0f;
                }
                if (!(f2 > (f3 += f)) && atom.size() <= 2) continue;
                arrayList.add(atom);
                continue;
            }
            if (atom.symbol.equals("C")) {
                float f4 = 5.0f;
                if (string.equals("restrictive")) {
                    f4 = 4.5f;
                }
                if (!(f2 > (f4 += f)) && atom.size() <= 4) continue;
                arrayList.add(atom);
                continue;
            }
            if (atom.symbol.equals("N")) {
                if (!(f2 > 5.0f + f) && atom.size() <= 4) continue;
                arrayList.add(atom);
                continue;
            }
            if (atom.symbol.equals("P")) {
                float f5 = 6.0f;
                if (string.equals("restrictive")) {
                    f5 = 5.0f;
                }
                if (!(f2 > (f5 += f)) && atom.size() <= 4) continue;
                arrayList.add(atom);
                continue;
            }
            if (atom.symbol.equals("S")) {
                float f6 = 7.0f;
                if (string.equals("restrictive")) {
                    f6 = 6.0f;
                }
                if (!(f2 > (f6 += f)) && atom.size() <= 4) continue;
                arrayList.add(atom);
                continue;
            }
            if (!atom.symbol.equals("Se") || !(f2 > 6.0f) && atom.size() <= 4) continue;
            arrayList.add(atom);
        }
        for (Bond bond : arrayList2) {
            if (bond.type.equals("metal")) {
                bond.atom1.add(bond);
                bond.atom2.add(bond);
                continue;
            }
            if (!string.equals("nonRestrictive")) continue;
            if (bond.atom1.symbol.equals("H")) {
                bond.atom2.add(bond);
            }
            if (!bond.atom2.symbol.equals("H")) continue;
            bond.atom1.add(bond);
        }
        if (arrayList.size() == 0) {
            return null;
        }
        String string2 = System.getProperty("line.separator");
        String string3 = "";
        for (Object object : arrayList) {
            String string4 = (String)var6_16 + (String)string2 + ((Atom)object).key4 + " has incorrect valency";
        }
        return var6_16;
    }

    static float getBondOrder(Bond bond) {
        float f = 0.0f;
        if (bond.type.equals("single")) {
            f = 1.0f;
        } else if (bond.type.equals("double")) {
            f = 2.0f;
        } else if (bond.type.equals("triple")) {
            f = 3.0f;
        } else if (bond.type.startsWith("delo") || bond.type.startsWith("arom")) {
            float f2 = 0.0f;
            f2 = bond.atom1.symbol.equals("O") ? bond.atom1.charge.floatValue() : (bond.atom2.symbol.equals("O") ? bond.atom2.charge.floatValue() : bond.atom1.charge.floatValue());
            f = f2 < 0.0f && f2 > -1.0f ? 2.0f + f2 : (f2 > 0.0f && f2 < 1.0f ? (f += 1.0f + f2) : (f += 1.5f + f2));
        }
        return f;
    }
}

