/*
 * Decompiled with CFR 0.152.
 */
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class CifLib {
    private Set<String> usedCompSet = new LinkedHashSet<String>();
    private Set<String> usedModSet = new LinkedHashSet<String>();
    private Set<String> stdCompSet = new LinkedHashSet<String>();
    private Map<String, Monomer> compMap = new LinkedHashMap<String, Monomer>();
    private Map<String, Molecule> modMap = new LinkedHashMap<String, Molecule>();
    private Map<String, Molecule> linkMap = new LinkedHashMap<String, Molecule>();
    private AtomMethods atomMethods = new AtomMethods();
    private List<CifRestraint> rstTemplates = new ArrayList<CifRestraint>(5);

    public String toString() {
        throw new NullPointerException();
    }

    public CifLib() {
        this.rstTemplates.add(new CifBond());
        this.rstTemplates.add(new CifAngle());
        this.rstTemplates.add(new CifTor());
        this.rstTemplates.add(new CifChir());
        this.rstTemplates.add(new CifPlane());
    }

    public CifLib(File file) {
        this.rstTemplates.add(new CifBond());
        this.rstTemplates.add(new CifAngle());
        this.rstTemplates.add(new CifTor());
        this.rstTemplates.add(new CifChir());
        this.rstTemplates.add(new CifPlane());
        CifFile cifFile = new CifFile(new CharArray(file));
        CifLibReader cifLibReader = new CifLibReader();
        cifLibReader.fromCif(cifFile, "comp", new CifCompReader());
        cifLibReader.fromCif(cifFile, "mod", new CifModReader());
        cifLibReader.fromCif(cifFile, "link", new CifLinkReader());
        if (!((Object)this.usedModSet).equals(this.modMap.keySet())) {
            throw new NullPointerException();
        }
    }

    public List<Molecule> polymerView() {
        ArrayList<Molecule> arrayList = new ArrayList<Molecule>();
        for (Monomer monomer : this.compMap.values()) {
            if (this.usedCompSet.contains(monomer.key8)) continue;
            arrayList.add(new Molecule(monomer));
        }
        arrayList.addAll(this.linkMap.values());
        return arrayList;
    }

    public List<Monomer> monomerView() {
        return new ArrayList<Monomer>(this.compMap.values());
    }

    public Monomer getMonomer() {
        int n = this.modMap.size() + this.linkMap.size();
        int n2 = this.compMap.size();
        if (n != 0 || n2 != 1) {
            throw new NullPointerException();
        }
        return this.compMap.values().iterator().next();
    }

    public Monomer getMonomer(String string) {
        return this.compMap.get(string);
    }

    public CharArray toBuffer() {
        return new CifLibWriter().headerBuffer;
    }

    public void add(Monomer monomer) {
        if (this.compMap.get(monomer.key8) != null) {
            throw new NullPointerException();
        }
        if (this.stdCompSet.contains(monomer.key8)) {
            throw new NullPointerException();
        }
        this.compMap.put(monomer.key8, monomer);
        for (int i = 0; i < 5; ++i) {
            Collections.sort((List)monomer.restraints.get(i));
        }
    }

    public String add(Molecule molecule) {
        if (molecule.restraints == null) {
            throw new NullPointerException();
        }
        String string = "";
        String string2 = "";
        Collections.sort(molecule.atoms, Atom.originComparator);
        Map<Residue, Molecule> map = molecule.residueView();
        if (map.size() == 2) {
            if (this.linkMap.put(molecule.key8, molecule) != null) {
                throw new NullPointerException();
            }
            for (Map.Entry<Residue, Molecule> entry : map.entrySet()) {
                Residue residue = entry.getKey();
                Monomer monomer = residue.mono;
                if (this.compMap.get(monomer.key8) != null) {
                    throw new NullPointerException();
                }
                if (monomer.isStandard()) {
                    this.stdCompSet.add(monomer.key8);
                } else {
                    if (this.stdCompSet.contains(monomer.key8)) {
                        throw new NullPointerException();
                    }
                    if (this.compMap.get(monomer.key8) != null) {
                        throw new NullPointerException();
                    }
                    this.compMap.put(monomer.key8, monomer);
                    string = string + Env.bsn + "new monomer '" + monomer.key8 + "' has been added to the library file";
                    if (StdLib.compHeaderMap.get(monomer.key8) != null) {
                        string2 = string2 + Env.bsn + "'" + monomer.key8;
                        string2 = string2 + "' will override the standard library entry with the same ID";
                    }
                }
                int n = 0;
                do {
                    residue.key8 = residue.mono.key3 + "mod" + ++n;
                } while (n < 100 && this.modMap.get(residue.key8) != null);
                if (n > 99) {
                    throw new NullPointerException();
                }
                Molecule molecule2 = entry.getValue();
                molecule2.name = residue.name;
                molecule2.key8 = residue.key8;
                this.modMap.put(molecule2.key8, molecule2);
                this.usedModSet.add(molecule2.key8);
            }
        } else {
            throw new NullPointerException();
        }
        Collections.sort(molecule.atoms, Atom.zComparator);
        if (!string.equals("")) {
            string = Env.bsn + Env.bsn + "In addition:" + string;
            if (!string2.equals("")) {
                string = string + Env.bsn + Env.bsn + "WARNING:" + Env.bsn;
                string = string + Env.bsn + "If this library will be used then:" + string2 + Env.bsn;
            }
        }
        return string;
    }

    private class CifPlane
    extends CifRestraint {
        String key_new;
        String fun_new;

        private CifPlane() {
        }

        GenericRestraint fromCif(CifLoop cifLoop, RestraintAtomReader restraintAtomReader) {
            if (this.key_new == null) {
                restraintAtomReader.readFun(cifLoop);
                this.fun_new = restraintAtomReader.function;
                this.key_new = (String)cifLoop.next();
            }
            GenericRestraint genericRestraint = new GenericRestraint(6);
            String string = this.fun_new;
            String string2 = this.key_new;
            Float f = new Float(0.0f);
            while (string.equals(this.fun_new) && string2.equals(this.key_new)) {
                Object object;
                Atom atom = restraintAtomReader.readAtom(cifLoop, false);
                if (genericRestraint.atoms.contains(atom)) {
                    if (Env.vbPrint) {
                        System.err.println("WARNING: duplicated atom in " + string2);
                    }
                } else {
                    genericRestraint.atoms.add(atom);
                }
                if ((object = cifLoop.next()) == null) {
                    f = null;
                }
                if (f != null) {
                    f = Float.valueOf(Math.max(f.floatValue(), ((Float)object).floatValue()));
                }
                if (!cifLoop.hasNextNoCycle()) break;
                restraintAtomReader.readFun(cifLoop);
                this.fun_new = restraintAtomReader.function;
                this.key_new = (String)cifLoop.next();
            }
            if (!cifLoop.hasNextNoCycle()) {
                this.fun_new = null;
                this.key_new = null;
            }
            if (string2.equals(this.key_new) && Env.vbPrint) {
                System.err.println("WARNING: CifPlane: identical key_new " + this.key_new);
            }
            restraintAtomReader.function = string;
            if (genericRestraint.atoms.size() < 4 && Env.vbPrint) {
                System.err.println("WARNING: plane size < 4");
            }
            genericRestraint.key = string2;
            genericRestraint.sigma = f == null ? null : new Sigma(f.floatValue());
            genericRestraint.sorter = GenericRestraint.sortPlane;
            genericRestraint.sort();
            return genericRestraint;
        }

        void toCif(CifLoop cifLoop, RestraintAtomWriter restraintAtomWriter, GenericRestraint genericRestraint) {
            for (Atom atom : genericRestraint.atoms) {
                restraintAtomWriter.writeFun(cifLoop);
                cifLoop.add(genericRestraint.key);
                restraintAtomWriter.writeAtom(atom, cifLoop);
                if (genericRestraint.sigma == null) {
                    cifLoop.add(null);
                    continue;
                }
                cifLoop.add(Float.valueOf(genericRestraint.sigma.sd));
            }
        }
    }

    private class CifChir
    extends CifRestraint {
        private CifChir() {
        }

        GenericRestraint fromCif(CifLoop cifLoop, RestraintAtomReader restraintAtomReader) {
            int n;
            restraintAtomReader.readFun(cifLoop);
            GenericRestraint genericRestraint = new GenericRestraint(9);
            genericRestraint.key = (String)cifLoop.next();
            for (n = 0; n < 4; ++n) {
                genericRestraint.atoms.add(restraintAtomReader.readAtom(cifLoop, true));
            }
            genericRestraint.type = (String)cifLoop.next();
            for (n = 0; n < 5; ++n) {
                genericRestraint.atoms.add(restraintAtomReader.readAtom(cifLoop, true));
            }
            String string = GenericRestraint.getChirType(genericRestraint.type);
            if (!string.equals("/ void /")) {
                genericRestraint.type = string;
                genericRestraint.sorter = GenericRestraint.sortChir;
            } else if (genericRestraint.type.equals("cross0")) {
                genericRestraint.sorter = GenericRestraint.sortCross0;
            } else if (genericRestraint.type.equals("cross1")) {
                genericRestraint.sorter = GenericRestraint.sortCross1;
            } else if (genericRestraint.type.equals("cross2")) {
                genericRestraint.sorter = GenericRestraint.sortCross2;
            } else if (genericRestraint.type.equals("cross3")) {
                genericRestraint.sorter = GenericRestraint.sortCross3;
            } else if (genericRestraint.type.equals("cross4")) {
                genericRestraint.sorter = GenericRestraint.sortCross4;
            } else if (genericRestraint.type.equals("cross5")) {
                genericRestraint.sorter = GenericRestraint.sortCross5;
            } else if (genericRestraint.type.equals("cross6")) {
                genericRestraint.sorter = GenericRestraint.sortCross6;
            } else {
                throw new NullPointerException("rst.type " + genericRestraint.type);
            }
            if (genericRestraint.type.equals("cross1") && Env.vbPrint) {
                System.err.println("WARNING: chir cross1");
            }
            if (genericRestraint.type.equals("cross5") && Env.vbPrint) {
                System.err.println("WARNING: chir cross5");
            }
            genericRestraint.sort();
            genericRestraint.initBothAndSign();
            return genericRestraint;
        }

        void toCif(CifLoop cifLoop, RestraintAtomWriter restraintAtomWriter, GenericRestraint genericRestraint) {
            int n;
            restraintAtomWriter.writeFun(cifLoop);
            cifLoop.add(genericRestraint.key);
            for (n = 0; n < 4; ++n) {
                restraintAtomWriter.writeAtom(genericRestraint.atoms.get(n), cifLoop);
            }
            cifLoop.add(genericRestraint.type);
            for (n = 4; n < 9; ++n) {
                restraintAtomWriter.writeAtom(genericRestraint.atoms.get(n), cifLoop);
            }
        }
    }

    private class CifTor
    extends CifRestraint {
        private CifTor() {
        }

        GenericRestraint fromCif(CifLoop cifLoop, RestraintAtomReader restraintAtomReader) {
            restraintAtomReader.readFun(cifLoop);
            GenericRestraint genericRestraint = new GenericRestraint(4);
            genericRestraint.key = (String)cifLoop.next();
            for (int i = 0; i < 4; ++i) {
                genericRestraint.atoms.add(restraintAtomReader.readAtom(cifLoop, false));
            }
            Object object = cifLoop.next();
            genericRestraint.setValue(object, cifLoop.next());
            genericRestraint.period = (Integer)cifLoop.next();
            genericRestraint.sorter = GenericRestraint.sortTor;
            genericRestraint.sort();
            return genericRestraint;
        }

        void toCif(CifLoop cifLoop, RestraintAtomWriter restraintAtomWriter, GenericRestraint genericRestraint) {
            restraintAtomWriter.writeFun(cifLoop);
            cifLoop.add(genericRestraint.key);
            for (Atom atom : genericRestraint.atoms) {
                restraintAtomWriter.writeAtom(atom, cifLoop);
            }
            if (genericRestraint.value == null) {
                cifLoop.add(null);
                cifLoop.add(null);
            } else {
                cifLoop.add(Float.valueOf(genericRestraint.value.mean));
                cifLoop.add(Float.valueOf(genericRestraint.value.sd));
            }
            cifLoop.add(genericRestraint.period);
        }
    }

    private class CifAngle
    extends CifRestraint {
        private CifAngle() {
        }

        GenericRestraint fromCif(CifLoop cifLoop, RestraintAtomReader restraintAtomReader) {
            restraintAtomReader.readFun(cifLoop);
            GenericRestraint genericRestraint = new GenericRestraint(3);
            for (int i = 0; i < 3; ++i) {
                genericRestraint.atoms.add(restraintAtomReader.readAtom(cifLoop, false));
            }
            Object object = cifLoop.next();
            genericRestraint.setValue(object, cifLoop.next());
            genericRestraint.sorter = GenericRestraint.sortAngle;
            genericRestraint.sort();
            return genericRestraint;
        }

        void toCif(CifLoop cifLoop, RestraintAtomWriter restraintAtomWriter, GenericRestraint genericRestraint) {
            restraintAtomWriter.writeFun(cifLoop);
            for (Atom atom : genericRestraint.atoms) {
                restraintAtomWriter.writeAtom(atom, cifLoop);
            }
            if (genericRestraint.value == null) {
                cifLoop.add(null);
                cifLoop.add(null);
            } else {
                cifLoop.add(Float.valueOf(genericRestraint.value.mean));
                cifLoop.add(Float.valueOf(genericRestraint.value.sd));
            }
        }
    }

    private class CifBond
    extends CifRestraint {
        private CifBond() {
        }

        GenericRestraint fromCif(CifLoop cifLoop, RestraintAtomReader restraintAtomReader) {
            restraintAtomReader.readFun(cifLoop);
            GenericRestraint genericRestraint = new GenericRestraint(2);
            for (int i = 0; i < 2; ++i) {
                genericRestraint.atoms.add(restraintAtomReader.readAtom(cifLoop, false));
            }
            genericRestraint.type = (String)cifLoop.next();
            if (genericRestraint.type != null && "aromatic".startsWith(genericRestraint.type)) {
                genericRestraint.type = "aromatic";
            }
            Object object = cifLoop.next();
            genericRestraint.setValue(object, cifLoop.next());
            genericRestraint.sorter = GenericRestraint.sortBond;
            genericRestraint.sort();
            return genericRestraint;
        }

        void toCif(CifLoop cifLoop, RestraintAtomWriter restraintAtomWriter, GenericRestraint genericRestraint) {
            restraintAtomWriter.writeFun(cifLoop);
            for (Atom atom : genericRestraint.atoms) {
                restraintAtomWriter.writeAtom(atom, cifLoop);
            }
            cifLoop.add(genericRestraint.type);
            if (genericRestraint.value == null) {
                cifLoop.add(null);
                cifLoop.add(null);
            } else {
                cifLoop.add(Float.valueOf(genericRestraint.value.mean));
                cifLoop.add(Float.valueOf(genericRestraint.value.sd));
            }
        }
    }

    private abstract class RestraintAtomWriter {
        String function = "";

        private RestraintAtomWriter() {
        }

        abstract void writeFun(CifLoop var1);

        abstract void writeAtom(Atom var1, CifLoop var2);
    }

    private abstract class RestraintAtomReader {
        String function = "";

        private RestraintAtomReader() {
        }

        abstract void readFun(CifLoop var1);

        abstract Atom readAtom(CifLoop var1, boolean var2);
    }

    private abstract class CifRestraint {
        private CifRestraint() {
        }

        abstract GenericRestraint fromCif(CifLoop var1, RestraintAtomReader var2);

        abstract void toCif(CifLoop var1, RestraintAtomWriter var2, GenericRestraint var3);
    }

    private class AtomMethods {
        private AtomMethods() {
        }

        void diffFromCif(CifLoop cifLoop, Atom atom, Atom atom2) {
            Object object = cifLoop.next();
            atom2.key4 = object == null ? atom.key4 : (String)object;
            object = cifLoop.next();
            atom2.symbol = object == null ? atom.symbol : (String)object;
            object = cifLoop.next();
            atom2.energy = object == null ? atom.energy : (String)object;
            object = cifLoop.next();
            atom2.charge = object == null ? atom.charge : (Float)object;
            String string = atom2.symbol;
            if (string != null) {
                atom2.symbol = string.substring(0, 1) + string.substring(1).toLowerCase();
            }
        }

        boolean diff(Atom atom, Atom atom2) {
            boolean bl = true;
            bl &= atom2.key4 == null ? atom.key4 == null : atom2.key4.equals(atom.key4);
            bl &= atom2.symbol == null ? atom.symbol == null : atom2.symbol.equals(atom.symbol);
            bl &= atom2.energy == null ? atom.energy == null : atom2.energy.equals(atom.energy);
            return !(bl &= atom2.charge == null ? atom.charge == null : atom2.charge.equals(atom.charge));
        }

        void diffToCif(CifLoop cifLoop, Atom atom, Atom atom2) {
            cifLoop.add(atom2.key4 != null && atom2.key4.equals(atom.key4) ? null : atom2.key4);
            cifLoop.add(atom2.symbol != null && atom2.symbol.equals(atom.symbol) ? null : atom2.symbol);
            cifLoop.add(atom2.energy != null && atom2.energy.equals(atom.energy) ? null : atom2.energy);
            cifLoop.add(atom2.charge != null && atom2.charge.equals(atom.charge) ? null : atom2.charge);
        }

        void fromCif(CifLoop cifLoop, Atom atom, boolean bl) {
            atom.key4 = (String)cifLoop.next();
            atom.symbol = (String)cifLoop.next();
            atom.energy = (String)cifLoop.next();
            atom.charge = (Float)cifLoop.next();
            String string = atom.symbol;
            if (string != null) {
                atom.symbol = string.substring(0, 1) + string.substring(1).toLowerCase();
            }
            if (bl) {
                return;
            }
            Float f = (Float)cifLoop.next();
            Float f2 = (Float)cifLoop.next();
            Float f3 = (Float)cifLoop.next();
            if (f != null && f2 != null && f3 != null) {
                atom.xyz[0] = f.doubleValue();
                atom.xyz[1] = f2.doubleValue();
                atom.xyz[2] = f3.doubleValue();
            }
        }

        void toCif(CifLoop cifLoop, Atom atom, boolean bl) {
            cifLoop.add(atom.key4);
            cifLoop.add(atom.symbol);
            cifLoop.add(atom.energy);
            cifLoop.add(atom.charge);
            if (bl) {
                return;
            }
            if (atom.xyz == null) {
                cifLoop.add(null);
                cifLoop.add(null);
                cifLoop.add(null);
                return;
            }
            cifLoop.add(new Float(atom.xyz[0]));
            cifLoop.add(new Float(atom.xyz[1]));
            cifLoop.add(new Float(atom.xyz[2]));
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class AtomMap
    extends LinkedHashMap<String, Atom> {
        AtomMap() {
        }

        AtomMap(List<Atom> list) {
            super(list.size());
            for (Atom atom : list) {
                this.put(atom.key4, atom);
            }
        }

        @Override
        public Atom put(String string, Atom atom) {
            if (super.put(string, atom) != null) {
                throw new NullPointerException();
            }
            return null;
        }
    }

    private class CifLinkWriter
    extends CifEntryWriter {
        Iterator<Molecule> iterator;

        CifLinkWriter() {
            this.iterator = CifLib.this.linkMap.values().iterator();
        }

        boolean hasNext() {
            return this.iterator.hasNext();
        }

        String toCif(CifLoop cifLoop, CifData cifData) {
            final Molecule molecule = this.iterator.next();
            final List<Residue> list = molecule.residueList();
            cifLoop.add(molecule.key8);
            for (Residue object2 : list) {
                cifLoop.add(object2.mono.key8);
                cifLoop.add(object2.key8);
                cifLoop.add(null);
            }
            cifLoop.add(molecule.name);
            RestraintAtomWriter restraintAtomWriter = new RestraintAtomWriter(){

                void writeFun(CifLoop cifLoop) {
                    cifLoop.add(molecule.key8);
                }

                void writeAtom(Atom atom, CifLoop cifLoop) {
                    if (atom == Atom.NULL) {
                        cifLoop.add(null);
                        cifLoop.add(null);
                    } else {
                        cifLoop.add(new Integer(1 + list.indexOf(atom.residue)));
                        cifLoop.add(atom.key4);
                    }
                }
            };
            Iterator<CifLoop> iterator = cifData.iterator();
            for (Object object : (List)molecule.restraints.get(0)) {
                if (((GenericRestraint)object).atoms.size() != 2) {
                    throw new NullPointerException();
                }
                int list2 = list.indexOf(((GenericRestraint)object).atoms.get((int)0).residue);
                int cifRestraint = list.indexOf(((GenericRestraint)object).atoms.get((int)1).residue);
                if (cifRestraint >= list2) continue;
                ((GenericRestraint)object).atoms.add(((GenericRestraint)object).atoms.remove(0));
                ((GenericRestraint)object).reordered = true;
            }
            for (int i = 0; i < 5; ++i) {
                Object object;
                object = iterator.next();
                if (i == 2 && !Env.keepTor) continue;
                List list2 = (List)molecule.restraints.get(i);
                CifRestraint cifRestraint = (CifRestraint)CifLib.this.rstTemplates.get(i);
                for (GenericRestraint genericRestraint : list2) {
                    if (genericRestraint.getResidue() != null) continue;
                    cifRestraint.toCif((CifLoop)object, restraintAtomWriter, genericRestraint);
                }
            }
            for (Object object : (List)molecule.restraints.get(0)) {
                if (!((GenericRestraint)object).reordered) continue;
                ((GenericRestraint)object).atoms.add(((GenericRestraint)object).atoms.remove(0));
                ((GenericRestraint)object).reordered = false;
            }
            return molecule.key8;
        }
    }

    private class CifLinkReader
    extends CifEntryReader {
        private CifLinkReader() {
        }

        void fromCif(final String string, CifLoop cifLoop, CifData cifData) {
            Object object;
            Object object2;
            Object object4;
            if (CifLib.this.linkMap.containsKey(string)) {
                throw new NullPointerException();
            }
            Molecule molecule = new Molecule();
            molecule.key8 = string;
            final ArrayList<AtomMap> arrayList = new ArrayList<AtomMap>(2);
            ArrayList<Restraints> arrayList2 = new ArrayList<Restraints>();
            for (int i = 0; i < 2; ++i) {
                object4 = (String)cifLoop.next();
                String string2 = (String)cifLoop.next();
                if (CifLib.this.usedModSet.contains(string2)) {
                    throw new NullPointerException();
                }
                CifLib.this.usedModSet.add(string2);
                Molecule object32 = (Molecule)CifLib.this.modMap.get(string2);
                if (object32 == null) {
                    throw new NullPointerException();
                }
                object2 = object32.atoms.get((int)0).residue;
                ((Residue)object2).isFirst = i == 0;
                for (Atom atom : object32.atoms) {
                    if (atom.residue == object2) continue;
                    throw new NullPointerException();
                }
                if (!((String)object4).equals(((Residue)object2).mono.key8)) {
                    throw new NullPointerException();
                }
                object = (String)cifLoop.next();
                if (object != null && !((String)object).equals(((Residue)object2).group)) {
                    throw new NullPointerException();
                }
                molecule.atoms.addAll(object32.atoms);
                arrayList.add(new AtomMap(object32.atoms));
                arrayList2.add(object32.restraints);
            }
            molecule.name = (String)cifLoop.next();
            RestraintAtomReader restraintAtomReader = new RestraintAtomReader(){

                void readFun(CifLoop cifLoop) {
                    if (!string.equals((String)cifLoop.next())) {
                        throw new NullPointerException();
                    }
                }

                Atom readAtom(CifLoop cifLoop, boolean bl) {
                    Object object = cifLoop.next();
                    Object object2 = cifLoop.next();
                    Atom atom = null;
                    if (object != null && object2 != null) {
                        Integer n = (Integer)object;
                        atom = (Atom)((AtomMap)arrayList.get(n - 1)).get(object2);
                    } else if (object == null && object2 == null && bl) {
                        atom = Atom.NULL;
                    }
                    if (atom == null) {
                        throw new NullPointerException();
                    }
                    return atom;
                }
            };
            molecule.restraints = new Restraints();
            object4 = cifData.iterator();
            for (int i = 0; i < 5; ++i) {
                CifLoop cifLoop2 = (CifLoop)object4.next();
                object2 = (List)molecule.restraints.get(i);
                object = (CifRestraint)CifLib.this.rstTemplates.get(i);
                while (cifLoop2.hasNext()) {
                    object2.add(((CifRestraint)object).fromCif(cifLoop2, restraintAtomReader));
                }
            }
            for (GenericRestraint genericRestraint : (List)molecule.restraints.get(0)) {
                object2 = new Bond(genericRestraint);
                ((Bond)object2).atom1.add(object2);
                ((Bond)object2).atom2.add(object2);
            }
            Iterator iterator = ((List)molecule.restraints.get(3)).iterator();
            while (iterator.hasNext()) {
                GenericRestraint genericRestraint;
                genericRestraint.atoms.get((int)0).chir = genericRestraint = (GenericRestraint)iterator.next();
            }
            for (Restraints restraints : arrayList2) {
                for (int i = 0; i < 5; ++i) {
                    ((List)molecule.restraints.get(i)).addAll((Collection)restraints.get(i));
                }
            }
            CifLib.this.linkMap.put(string, molecule);
        }
    }

    private class CifModWriter
    extends CifEntryWriter {
        private Iterator<Molecule> iterator;

        private CifModWriter() {
            this.iterator = CifLib.this.modMap.values().iterator();
        }

        boolean hasNext() {
            return this.iterator.hasNext();
        }

        String toCif(CifLoop cifLoop, CifData cifData) {
            List<Bond> list;
            Molecule molecule = this.iterator.next();
            final Residue residue = molecule.atoms.get((int)0).residue;
            for (Atom cloneable2 : molecule.atoms) {
                if (cloneable2.residue == residue) continue;
                throw new NullPointerException();
            }
            Iterator<Cloneable> iterator = cifData.iterator();
            CifLoop cifLoop2 = (CifLoop)iterator.next();
            ArrayList<Atom> arrayList = new ArrayList<Atom>();
            for (Atom atom : residue.mono.atoms) {
                arrayList.add(atom);
            }
            Collections.sort(arrayList, Atom.originComparator);
            for (Atom atom : molecule.atoms) {
                int n = Collections.binarySearch(arrayList, atom, Atom.originComparator);
                list = null;
                if (n >= 0) {
                    list = (Atom)arrayList.remove(n);
                }
                if (list == null) {
                    cifLoop2.add(residue.key8);
                    cifLoop2.add("add");
                    cifLoop2.add(null);
                    CifLib.this.atomMethods.toCif(cifLoop2, atom, true);
                    continue;
                }
                if (!CifLib.this.atomMethods.diff((Atom)list, atom)) continue;
                cifLoop2.add(residue.key8);
                cifLoop2.add("change");
                cifLoop2.add(((Atom)list).key4);
                CifLib.this.atomMethods.diffToCif(cifLoop2, (Atom)list, atom);
            }
            for (Atom atom : arrayList) {
                cifLoop2.add(residue.key8);
                cifLoop2.add("delete");
                cifLoop2.add(atom.key4);
                Atom atom2 = new Atom(residue);
                CifLib.this.atomMethods.toCif(cifLoop2, atom2, true);
            }
            RestraintAtomWriter restraintAtomWriter = new RestraintAtomWriter(){

                void writeFun(CifLoop cifLoop) {
                    cifLoop.add(residue.key8);
                    cifLoop.add(this.function);
                }

                void writeAtom(Atom atom, CifLoop cifLoop) {
                    cifLoop.add(atom.key4);
                }
            };
            for (int i = 0; i < 5; ++i) {
                int n;
                CifLoop cifLoop3 = (CifLoop)iterator.next();
                if (i == 2 && !Env.keepTor) continue;
                List list2 = (List)residue.mono.restraints.get(i);
                list = (List)molecule.restraints.get(i);
                CifRestraint cifRestraint = (CifRestraint)CifLib.this.rstTemplates.get(i);
                for (GenericRestraint genericRestraint : list2) {
                    GenericRestraint genericRestraint2;
                    n = list.indexOf(genericRestraint);
                    if (n < 0) {
                        restraintAtomWriter.function = "delete";
                        genericRestraint2 = genericRestraint.asDeleted();
                        cifRestraint.toCif(cifLoop3, restraintAtomWriter, genericRestraint2);
                        continue;
                    }
                    genericRestraint2 = (GenericRestraint)((Object)list.remove(n));
                    if (genericRestraint2.getResidue() != residue) {
                        throw new NullPointerException();
                    }
                    if (!genericRestraint.diff(genericRestraint2)) continue;
                    restraintAtomWriter.function = "change";
                    GenericRestraint genericRestraint3 = genericRestraint.deriveDiff(genericRestraint2);
                    cifRestraint.toCif(cifLoop3, restraintAtomWriter, genericRestraint3);
                }
                for (GenericRestraint genericRestraint : list) {
                    if (genericRestraint.getResidue() != residue) {
                        throw new NullPointerException();
                    }
                    n = list2.indexOf(genericRestraint);
                    if (n < 0) {
                        restraintAtomWriter.function = "add";
                        cifRestraint.toCif(cifLoop3, restraintAtomWriter, genericRestraint);
                        continue;
                    }
                    throw new NullPointerException();
                }
            }
            if (cifData.isVoid()) {
                return null;
            }
            cifLoop.add(residue.key8);
            cifLoop.add(residue.name);
            cifLoop.add(residue.mono.key8);
            cifLoop.add(null);
            return residue.key8;
        }
    }

    private class CifModReader
    extends CifEntryReader {
        private CifModReader() {
        }

        void fromCif(String string, CifLoop cifLoop, CifData cifData) {
            Object object;
            Iterator<Atom> iterator22;
            Object object3;
            if (CifLib.this.modMap.containsKey(string)) {
                throw new NullPointerException();
            }
            final Residue residue = new Residue();
            residue.key8 = string;
            residue.name = (String)cifLoop.next();
            String string2 = (String)cifLoop.next();
            residue.group = (String)cifLoop.next();
            residue.mono = (Monomer)CifLib.this.compMap.get(string2);
            if (residue.mono == null) {
                boolean bl = false;
                residue.mono = StdLib.get(string2, bl);
                if (residue.mono == null) {
                    throw new NullPointerException();
                }
                CifLib.this.stdCompSet.add(string2);
            } else {
                CifLib.this.usedCompSet.add(string2);
            }
            if (!residue.mono.key8.equals(string2)) {
                throw new NullPointerException();
            }
            Molecule molecule = new Molecule();
            molecule.key8 = residue.key8;
            molecule.name = residue.name;
            CifLib.this.modMap.put(string, molecule);
            Iterator<CifLoop> iterator = cifData.iterator();
            CifLoop cifLoop2 = iterator.next();
            AtomMap atomMap = new AtomMap(residue.mono.atoms);
            final AtomMap atomMap2 = new AtomMap();
            final AtomMap atomMap3 = new AtomMap();
            while (cifLoop2.hasNext()) {
                if (!residue.key8.equals(cifLoop2.next())) {
                    throw new NullPointerException();
                }
                object3 = (String)cifLoop2.next();
                iterator22 = (String)cifLoop2.next();
                if (((String)object3).equals("add")) {
                    Atom atom = new Atom(residue);
                    CifLib.this.atomMethods.fromCif(cifLoop2, atom, true);
                    atomMap3.put(atom.key4, atom);
                    molecule.atoms.add(atom);
                    continue;
                }
                if (((String)object3).equals("delete")) {
                    Atom atom = (Atom)atomMap.remove(iterator22);
                    object = new Atom(null, atom);
                    CifLib.this.atomMethods.fromCif(cifLoop2, (Atom)object, true);
                    atom.coupled = object;
                    atomMap2.put((String)((Object)iterator22), (Atom)object);
                    continue;
                }
                if (!((String)object3).equals("change")) continue;
                Atom atom = (Atom)atomMap.remove(iterator22);
                object = new Atom(residue, atom);
                CifLib.this.atomMethods.diffFromCif(cifLoop2, atom, (Atom)object);
                atom.coupled = object;
                atomMap2.put((String)((Object)iterator22), (Atom)object);
                atomMap3.put(((Atom)object).key4, (Atom)object);
                molecule.atoms.add((Atom)object);
            }
            for (Iterator<Atom> iterator22 : atomMap.values()) {
                Atom atom;
                ((Atom)((Object)iterator22)).coupled = atom = new Atom(residue, (Atom)((Object)iterator22));
                atomMap2.put(atom.key4, atom);
                atomMap3.put(atom.key4, atom);
                molecule.atoms.add(atom);
            }
            object3 = new RestraintAtomReader(){

                void readFun(CifLoop cifLoop) {
                    if (!residue.key8.equals((String)cifLoop.next())) {
                        throw new NullPointerException();
                    }
                    this.function = (String)cifLoop.next();
                }

                Atom readAtom(CifLoop cifLoop, boolean bl) {
                    if (this.function == null) {
                        throw new NullPointerException();
                    }
                    Object object = cifLoop.next();
                    Atom atom = null;
                    if (bl && object == null) {
                        atom = Atom.NULL;
                    } else if (this.function.equals("add")) {
                        atom = (Atom)atomMap3.get(object);
                    } else if (this.function.equals("delete")) {
                        atom = (Atom)atomMap2.get(object);
                    } else if (this.function.equals("change")) {
                        atom = (Atom)atomMap3.get(object);
                    } else {
                        throw new NullPointerException();
                    }
                    if (atom == null) {
                        throw new NullPointerException();
                    }
                    return atom;
                }
            };
            molecule.restraints = new Restraints(residue.mono.restraints);
            iterator22 = residue.mono.atoms.iterator();
            while (iterator22.hasNext()) {
                Atom atom;
                atom.coupled = atom = iterator22.next();
            }
            for (int i = 0; i < 5; ++i) {
                Object object2;
                cifLoop2 = iterator.next();
                List list = (List)molecule.restraints.get(i);
                object = (CifRestraint)CifLib.this.rstTemplates.get(i);
                while (cifLoop2.hasNext()) {
                    object2 = ((CifRestraint)object).fromCif(cifLoop2, (RestraintAtomReader)object3);
                    int n = list.indexOf(object2);
                    if (((RestraintAtomReader)object3).function.equals("add")) {
                        if (n >= 0) {
                            throw new NullPointerException();
                        }
                        list.add(object2);
                        continue;
                    }
                    if (((RestraintAtomReader)object3).function.equals("delete")) {
                        if (n < 0) {
                            throw new NullPointerException();
                        }
                        list.remove(n);
                        continue;
                    }
                    if (!((RestraintAtomReader)object3).function.equals("change")) continue;
                    if (n < 0) {
                        throw new NullPointerException();
                    }
                    GenericRestraint genericRestraint = (GenericRestraint)list.get(n);
                    GenericRestraint genericRestraint2 = genericRestraint.applyDiff((GenericRestraint)object2);
                    list.set(n, genericRestraint2);
                }
                object2 = list.iterator();
                while (object2.hasNext()) {
                    GenericRestraint genericRestraint = (GenericRestraint)object2.next();
                    if (genericRestraint.getResidue() != null) continue;
                    object2.remove();
                }
            }
            for (GenericRestraint genericRestraint : (List)molecule.restraints.get(0)) {
                object = new Bond(genericRestraint);
                ((Bond)object).atom1.add(object);
                ((Bond)object).atom2.add(object);
            }
            Iterator iterator3 = ((List)molecule.restraints.get(3)).iterator();
            while (iterator3.hasNext()) {
                GenericRestraint genericRestraint;
                genericRestraint.atoms.get((int)0).chir = genericRestraint = (GenericRestraint)iterator3.next();
            }
        }
    }

    private class CifCompWriter
    extends CifEntryWriter {
        private Iterator<Monomer> iterator;

        private CifCompWriter() {
            this.iterator = CifLib.this.compMap.values().iterator();
        }

        boolean hasNext() {
            return this.iterator.hasNext();
        }

        String toCif(CifLoop cifLoop, CifData cifData) {
            final Monomer monomer = this.iterator.next();
            for (Atom iterator2 : monomer.atoms) {
                if (iterator2.residue == null) continue;
                throw new NullPointerException();
            }
            cifLoop.add(monomer.key8);
            cifLoop.add(monomer.key3);
            cifLoop.add(monomer.name);
            cifLoop.add(null);
            int n = 0;
            for (Atom atom : monomer.atoms) {
                if (atom.symbol.equals("H")) continue;
                ++n;
            }
            cifLoop.add(new Integer(monomer.atoms.size()));
            cifLoop.add(new Integer(n));
            cifLoop.add(((List)monomer.restraints.get(1)).size() == 0 ? "M" : null);
            Iterator<CifLoop> iterator = cifData.iterator();
            CifLoop cifLoop2 = iterator.next();
            for (Atom atom : monomer.atoms) {
                cifLoop2.add(monomer.key8);
                CifLib.this.atomMethods.toCif(cifLoop2, atom, false);
            }
            RestraintAtomWriter restraintAtomWriter = new RestraintAtomWriter(){

                void writeFun(CifLoop cifLoop) {
                    cifLoop.add(monomer.key8);
                }

                void writeAtom(Atom atom, CifLoop cifLoop) {
                    cifLoop.add(atom.key4);
                }
            };
            for (int i = 0; i < 5; ++i) {
                CifLoop cifLoop3 = iterator.next();
                List list = (List)monomer.restraints.get(i);
                CifRestraint cifRestraint = (CifRestraint)CifLib.this.rstTemplates.get(i);
                for (GenericRestraint genericRestraint : list) {
                    cifRestraint.toCif(cifLoop3, restraintAtomWriter, genericRestraint);
                }
            }
            return monomer.key8;
        }
    }

    private class CifCompReader
    extends CifEntryReader {
        private CifCompReader() {
        }

        void fromCif(String string, CifLoop cifLoop, CifData cifData) {
            Object object;
            Object object22;
            Object object3;
            if (CifLib.this.compMap.containsKey(string)) {
                throw new NullPointerException();
            }
            final Monomer monomer = new Monomer();
            monomer.key8 = string;
            monomer.key3 = (String)cifLoop.next();
            monomer.name = (String)cifLoop.next();
            monomer.group = (String)cifLoop.next();
            cifLoop.next();
            cifLoop.next();
            cifLoop.next();
            CifLib.this.compMap.put(string, monomer);
            Iterator<CifLoop> iterator = cifData.iterator();
            CifLoop cifLoop2 = iterator.next();
            final AtomMap atomMap = new AtomMap();
            while (cifLoop2.hasNext()) {
                if (!monomer.key8.equals(cifLoop2.next())) {
                    throw new NullPointerException();
                }
                object3 = new Atom((Residue)null);
                CifLib.this.atomMethods.fromCif(cifLoop2, (Atom)object3, false);
                atomMap.put(((Atom)object3).key4, (Atom)object3);
                monomer.atoms.add((Atom)object3);
            }
            object3 = new RestraintAtomReader(){

                void readFun(CifLoop cifLoop) {
                    if (!monomer.key8.equals((String)cifLoop.next())) {
                        throw new NullPointerException();
                    }
                }

                Atom readAtom(CifLoop cifLoop, boolean bl) {
                    Object object = cifLoop.next();
                    Atom atom = null;
                    atom = bl && object == null ? Atom.NULL : (Atom)atomMap.get(object);
                    if (atom == null) {
                        throw new NullPointerException(object.toString());
                    }
                    return atom;
                }
            };
            monomer.restraints = new Restraints();
            for (int i = 0; i < 5; ++i) {
                cifLoop2 = iterator.next();
                object22 = (List)monomer.restraints.get(i);
                object = (CifRestraint)CifLib.this.rstTemplates.get(i);
                while (cifLoop2.hasNext()) {
                    object22.add(((CifRestraint)object).fromCif(cifLoop2, (RestraintAtomReader)object3));
                }
            }
            for (Object object22 : (List)monomer.restraints.get(0)) {
                object = new Bond((GenericRestraint)object22);
                ((Bond)object).atom1.add(object);
                ((Bond)object).atom2.add(object);
            }
            Iterator iterator2 = ((List)monomer.restraints.get(3)).iterator();
            while (iterator2.hasNext()) {
                ((GenericRestraint)object22).atoms.get((int)0).chir = object22 = (GenericRestraint)iterator2.next();
            }
        }
    }

    private abstract class CifEntryWriter {
        private CifEntryWriter() {
        }

        abstract boolean hasNext();

        abstract String toCif(CifLoop var1, CifData var2);
    }

    private class CifLibWriter {
        private final String bsn = Env.bsn;
        private CharArray headerBuffer = new CharArray();
        private CharArray dataBuffer = new CharArray();

        CifLibWriter() {
            this.headerBuffer.append(Versions.cifHeaderInfo());
            this.append("comp", new CifCompWriter());
            this.append("mod", new CifModWriter());
            this.append("link", new CifLinkWriter());
            this.headerBuffer.append(this.dataBuffer);
        }

        void append(String string, CifEntryWriter cifEntryWriter) {
            String string2 = "data_" + string + "_";
            CifData cifData = (CifData)CifFile.template.get(string2 + "list");
            CifLoop cifLoop = cifData.iterator().next();
            CifData cifData2 = (CifData)CifFile.template.get(string2);
            int n = 0;
            while (cifEntryWriter.hasNext()) {
                String string3 = cifEntryWriter.toCif(cifLoop, cifData2);
                if (string3 == null) continue;
                ++n;
                this.dataBuffer.append(string2 + string3 + this.bsn);
                cifData2.appendTo(this.dataBuffer);
                cifData2.clear();
                this.dataBuffer.append(this.bsn);
            }
            if (n > 0) {
                this.headerBuffer.append(string2 + "list" + this.bsn);
                cifData.appendTo(this.headerBuffer);
                cifData.clear();
                this.headerBuffer.append(this.bsn);
            }
        }

        public String toString() {
            return this.headerBuffer.toString();
        }
    }

    private abstract class CifEntryReader {
        private CifEntryReader() {
        }

        abstract void fromCif(String var1, CifLoop var2, CifData var3);
    }

    private class CifLibReader {
        private CifLibReader() {
        }

        void fromCif(CifFile cifFile, String string, CifEntryReader cifEntryReader) {
            String string2 = "data_" + string + "_";
            CifData cifData = (CifData)cifFile.get(string2 + "list");
            if (cifData == null) {
                return;
            }
            Iterator<CifLoop> iterator = cifData.iterator();
            if (!iterator.hasNext()) {
                return;
            }
            CifLoop cifLoop = iterator.next();
            while (cifLoop.hasNext()) {
                String string3 = (String)cifLoop.next();
                CifData cifData2 = (CifData)cifFile.get(string2 + string3);
                cifEntryReader.fromCif(string3, cifLoop, cifData2);
            }
        }
    }
}

