/*
 * Decompiled with CFR 0.152.
 */
import java.util.LinkedHashMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class CifParser
extends LinkedHashMap<String, CifData> {
    protected CifData data;
    protected String dataKey;
    protected String loopKey;
    protected String clmnKey;
    protected String item;
    protected int ic;
    protected int nc;
    protected int nr;
    protected int current;

    CifParser() {
    }

    protected void dataTag() {
        this.dataKey = this.item;
        if (this.data != null) {
            this.data.first = this.current;
        }
    }

    protected void loopTag() {
        int n = this.item.indexOf(".");
        if (n < 2) {
            throw new NullPointerException();
        }
        this.loopKey = this.item.substring(0, n + 1);
        this.nr = 0;
        this.nc = 0;
    }

    protected void clmnTag() {
        if (!this.item.startsWith(this.loopKey)) {
            throw new NullPointerException();
        }
        this.clmnKey = this.item.substring(this.loopKey.length());
        this.ic = this.nc++;
    }

    protected void value() {
        if (++this.ic == this.nc) {
            this.ic = 0;
            ++this.nr;
        }
        this.clmnKey = null;
    }

    protected void loopEnd() {
        if (this.ic != this.nc - 1) {
            throw new NullPointerException();
        }
    }

    protected void dataEnd() {
        if (this.data != null) {
            this.data.last = this.current;
            this.put(this.dataKey, this.data);
            this.data = null;
        }
        this.dataKey = null;
        this.loopKey = null;
    }

    public void parse(CharArray charArray) {
        CifTokenizer cifTokenizer = new CifTokenizer(charArray);
        int n = 0;
        while (true) {
            this.item = cifTokenizer.nextToken();
            int n2 = this.current = this.item == null ? cifTokenizer.j : cifTokenizer.j - this.item.length();
            if (this.item == null) {
                switch (n) {
                    case 0: {
                        throw new NullPointerException();
                    }
                    case 1: {
                        throw new NullPointerException();
                    }
                    case 2: {
                        throw new NullPointerException();
                    }
                    case 3: {
                        throw new NullPointerException();
                    }
                    case 4: {
                        this.loopEnd();
                        this.dataEnd();
                        return;
                    }
                }
                continue;
            }
            if (this.item.startsWith("data_")) {
                switch (n) {
                    case 0: {
                        n = 1;
                        this.dataTag();
                        break;
                    }
                    case 1: {
                        n = 1;
                        this.dataTag();
                        break;
                    }
                    case 2: {
                        throw new NullPointerException();
                    }
                    case 3: {
                        throw new NullPointerException();
                    }
                    case 4: {
                        n = 1;
                        this.loopEnd();
                        this.dataEnd();
                        this.dataTag();
                    }
                }
                continue;
            }
            if (this.item.equals("loop_")) {
                switch (n) {
                    case 0: {
                        n = 2;
                        break;
                    }
                    case 1: {
                        n = 2;
                        break;
                    }
                    case 2: {
                        throw new NullPointerException();
                    }
                    case 3: {
                        n = 2;
                        this.loopEnd();
                        break;
                    }
                    case 4: {
                        n = 2;
                        this.loopEnd();
                    }
                }
                continue;
            }
            if (this.item.startsWith("_")) {
                switch (n) {
                    case 0: {
                        break;
                    }
                    case 1: {
                        throw new NullPointerException();
                    }
                    case 2: {
                        n = 3;
                        this.loopTag();
                        this.clmnTag();
                        break;
                    }
                    case 3: {
                        this.clmnTag();
                        break;
                    }
                    case 4: {
                        throw new NullPointerException();
                    }
                }
                continue;
            }
            switch (n) {
                case 0: {
                    break;
                }
                case 1: {
                    throw new NullPointerException();
                }
                case 2: {
                    throw new NullPointerException();
                }
                case 3: {
                    n = 4;
                    this.value();
                    break;
                }
                case 4: {
                    this.value();
                }
            }
        }
    }
}

