/*
 * Decompiled with CFR 0.152.
 */
import java.io.FileWriter;
import javax.swing.SwingUtilities;

class CootListener
extends Thread {
    private final long timeInterval = 500L;
    private long modificationTime;
    private static int cootId = 0;

    CootListener() {
        try {
            FileWriter fileWriter = new FileWriter(JLMain.toCoot);
            fileWriter.write("READY" + Env.bsn);
            fileWriter.close();
            this.modificationTime = JLMain.toCoot.lastModified();
        }
        catch (Exception exception) {
            if (Env.vbPrint) {
                exception.printStackTrace(System.err);
            }
            DialogWindows.showErrorDialog("Error writing message to Coot");
        }
        this.modificationTime -= 5L;
    }

    public void run() {
        while (true) {
            if (!JLMain.fromCoot.isFile()) {
                continue;
            }
            long l = JLMain.fromCoot.lastModified();
            if (this.modificationTime < l) {
                this.modificationTime = l;
                try {
                    CootInfoReader cootInfoReader = new CootInfoReader(JLMain.fromCoot);
                    ++cootId;
                    for (final OneLigandInfo oneLigandInfo : cootInfoReader) {
                        System.err.println(oneLigandInfo);
                        SwingUtilities.invokeAndWait(new Runnable(){

                            public void run() {
                                Molecule molecule = null;
                                molecule = oneLigandInfo.file == null ? JLMain.actionLoadLigand(oneLigandInfo.key3) : JLMain.actionReadFromLib(oneLigandInfo.file, oneLigandInfo.key3);
                                if (molecule == null) {
                                    throw new NullPointerException();
                                }
                                Residue residue = molecule.getResidue();
                                if (residue == null) {
                                    throw new NullPointerException();
                                }
                                residue.setCootInfo(oneLigandInfo.chainId, oneLigandInfo.residueNo, cootId);
                                JLMain.currentPanel.resetPanel();
                            }
                        });
                    }
                    System.err.println();
                }
                catch (Exception exception) {
                    if (Env.vbPrint) {
                        exception.printStackTrace(System.err);
                    }
                    DialogWindows.showErrorDialog("Error reading message from Coot");
                }
            }
            try {
                Thread.sleep(500L);
                continue;
            }
            catch (InterruptedException interruptedException) {
                System.err.println("x3");
                continue;
            }
            break;
        }
    }
}

