/*
 * Decompiled with CFR 0.152.
 */
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class CorrectBonds {
    static boolean isChange;

    CorrectBonds() {
    }

    static String compare(List<Atom> list, List<Atom> list2) {
        Object object;
        Atom atom2;
        String string = "";
        Iterator<Atom> iterator = list2.iterator();
        while (iterator.hasNext()) {
            atom2.coupled = atom2 = iterator.next();
        }
        iterator = list.iterator();
        while (iterator.hasNext()) {
            object = atom2.coupled;
            atom2 = iterator.next();
            if (object == atom2) {
                throw new NullPointerException();
            }
            ((Atom)object).coupled = atom2;
        }
        iterator = list2.iterator();
        while (iterator.hasNext()) {
            object = atom2.coupled;
            atom2 = iterator.next();
            if (object != atom2) continue;
            throw new NullPointerException();
        }
        for (Atom atom2 : list2) {
            object = atom2.coupled;
            if (((Atom)object).charge.equals(atom2.charge)) continue;
            string = string + String.format("Atom %-4s    charge changed from %7.2f to %7.2f", atom2.key4, ((Atom)object).charge, atom2.charge);
            string = string + Env.bsn;
        }
        for (Atom atom2 : list2) {
            for (Bond bond : atom2) {
                Bond bond2;
                if (bond.atom1 != atom2) continue;
                Atom atom3 = bond.another(atom2);
                Atom atom4 = atom2.coupled;
                Atom atom5 = atom3.coupled;
                Bond bond3 = null;
                Iterator iterator2 = atom4.iterator();
                while (iterator2.hasNext() && (bond3 = (bond2 = (Bond)iterator2.next())).another(atom4) != atom5) {
                    bond3 = null;
                }
                if (bond3 == null) {
                    throw new NullPointerException();
                }
                if (bond3.type.equals(bond.type)) continue;
                string = string + String.format("Bond %-4s-%-4s type changed from %7s to %7s", atom2.key4, atom3.key4, bond3.type, bond.type);
                string = string + Env.bsn;
            }
        }
        return string;
    }

    /*
     * WARNING - void declaration
     */
    static boolean correctBondOrders(List<Atom> list) {
        void var3_8;
        ArrayList<Bond> arrayList = new ArrayList<Bond>();
        for (Atom object : list) {
            for (Bond bond : object) {
                if (bond.atom1 != object) continue;
                arrayList.add(bond);
            }
        }
        for (Bond bond : arrayList) {
            if (!bond.type.equals("metal")) continue;
            bond.atom1.remove(bond);
            bond.atom2.remove(bond);
        }
        boolean bl = false;
        isChange = true;
        boolean bl2 = false;
        while (var3_8 < 100 && isChange) {
            isChange = false;
            for (Atom atom : list) {
                if (atom.symbol.equals("H") || atom.symbol.equals("F") || atom.symbol.equals("Cl") || atom.symbol.equals("Br") || atom.symbol.equals("I")) {
                    for (Bond bond : atom) {
                        if (bond.type.equals("single")) continue;
                        bond.type = "single";
                        isChange = true;
                    }
                    continue;
                }
                if (atom.symbol.equals("O")) {
                    CorrectBonds.sortOxygens(atom);
                    continue;
                }
                if (atom.symbol.equals("C")) {
                    CorrectBonds.sortCarbons(atom);
                    continue;
                }
                if (atom.symbol.equals("N")) {
                    CorrectBonds.sortNitrogens(atom);
                    continue;
                }
                if (atom.symbol.equals("P")) {
                    CorrectBonds.sortPhosphors(atom);
                    continue;
                }
                if (!atom.symbol.equals("S")) continue;
                CorrectBonds.sortSulphurs(atom);
            }
            bl = bl || isChange;
            ++var3_8;
        }
        for (Bond bond : arrayList) {
            if (!bond.type.equals("metal")) continue;
            bond.atom1.add(bond);
            bond.atom2.add(bond);
        }
        return bl;
    }

    static void sortOxygens(Atom atom) {
        int n = atom.size();
        if (n != 1 && n == 2) {
            for (Bond bond : atom) {
                if (bond.type.equals("single")) continue;
                bond.type = "single";
                isChange = true;
            }
        }
    }

    static void sortCarbons(Atom atom) {
        block24: {
            int n;
            block25: {
                Atom atom2;
                Object object3;
                n = atom.size();
                if (n == 1 || n == 2) break block24;
                if (n != 3) break block25;
                int n2 = 0;
                int n3 = 0;
                int n4 = 0;
                for (Bond bond : atom) {
                    if (bond.type.equals("single")) {
                        ++n2;
                        continue;
                    }
                    if (bond.type.startsWith("delo") || bond.type.startsWith("arom")) {
                        ++n3;
                        continue;
                    }
                    if (!bond.type.equals("double")) continue;
                    ++n4;
                }
                if (n2 == 1) {
                    for (Bond bond : atom) {
                        if (!bond.type.startsWith("double")) continue;
                        bond.type = "deloc";
                        isChange = true;
                    }
                } else if (n2 == 2 && n3 == 1) {
                    for (Bond bond : atom) {
                        if (!bond.type.startsWith("delo") && !bond.type.startsWith("arom")) continue;
                        bond.type = "double";
                        isChange = true;
                    }
                }
                if (n3 + n4 <= 1) break block24;
                int n5 = 0;
                int n6 = 0;
                for (Object object2 : atom) {
                    object3 = ((Bond)object2).another(atom);
                    if (!((Atom)object3).symbol.equals("O") || ((ArrayList)object3).size() != 1) continue;
                    ++n5;
                    if (!((Bond)object2).type.equals("double") && !((Bond)object2).type.startsWith("delo") && !((Bond)object2).type.startsWith("arom")) continue;
                    ++n6;
                }
                if (n5 != 1) {
                    if (n5 == 2) {
                        if (n6 > 0) {
                            for (Object object2 : atom) {
                                object3 = ((Bond)object2).another(atom);
                                if (!((Atom)object3).symbol.equals("O")) continue;
                                if (!((Bond)object2).type.startsWith("delo")) {
                                    ((Bond)object2).type = "deloc";
                                    isChange = true;
                                }
                                if (((Atom)object3).charge.floatValue() == -0.5f) continue;
                                ((Atom)object3).charge = Float.valueOf(-0.5f);
                                isChange = true;
                            }
                        }
                    } else if (n5 == 3) {
                        for (Object object2 : atom) {
                            object3 = ((Bond)object2).another(atom);
                            if (!((Bond)object2).type.startsWith("delo")) {
                                ((Bond)object2).type = "deloc";
                                isChange = true;
                            }
                            if (((Atom)object3).charge.floatValue() == -0.66f) continue;
                            ((Atom)object3).charge = Float.valueOf(-0.66f);
                            isChange = true;
                        }
                    }
                }
                int n7 = 0;
                for (Object object3 : atom) {
                    atom2 = ((Bond)object3).another(atom);
                    if (!atom2.symbol.equals("N") || atom2.size() != 1 || !((Bond)object3).type.equals("double")) continue;
                    ++n7;
                }
                if (n7 == 2) {
                    for (Object object3 : atom) {
                        atom2 = ((Bond)object3).another(atom);
                        if (!atom2.symbol.equals("N")) continue;
                        if (!((Bond)object3).type.startsWith("delo")) {
                            ((Bond)object3).type = "deloc";
                            isChange = true;
                        }
                        if (atom2.charge.floatValue() == 0.5f) continue;
                        atom2.charge = Float.valueOf(0.5f);
                        isChange = true;
                    }
                }
                break block24;
            }
            if (n == 4) {
                for (Bond bond : atom) {
                    if (bond.type.equals("single")) continue;
                    bond.type = "single";
                    isChange = true;
                }
            }
        }
    }

    static void sortNitrogens(Atom atom) {
        int n = atom.size();
        if (n == 1) {
            for (Bond bond : atom) {
                Atom atom2 = bond.another(atom);
                if (!atom2.symbol.equals("C") || !bond.type.equals("single") || atom.charge.floatValue() == 1.0f) continue;
                atom.charge = Float.valueOf(1.0f);
                isChange = true;
            }
        } else if (n == 2) {
            Bond bond = (Bond)atom.get(0);
            Bond bond2 = (Bond)atom.get(1);
            if (bond.type.equals("single") && bond2.type.equals("deloc")) {
                bond2.type = "double";
                isChange = true;
            }
            if (bond2.type.equals("single") && bond.type.equals("deloc")) {
                bond.type = "double";
                isChange = true;
            }
            if (bond.type.equals("double") && bond2.type.equals("double")) {
                atom.charge = Float.valueOf(1.0f);
                isChange = true;
            }
        } else if (n == 3) {
            if ((double)atom.charge.floatValue() <= 0.5) {
                for (Bond bond : atom) {
                    if (bond.type.equals("single")) continue;
                    bond.type = "single";
                    isChange = true;
                }
                if ((double)atom.charge.floatValue() != 0.0) {
                    atom.charge = Float.valueOf(0.0f);
                    isChange = true;
                }
            } else if ((double)atom.charge.floatValue() > 0.5) {
                if ((double)atom.charge.floatValue() != 1.0) {
                    atom.charge = Float.valueOf(1.0f);
                    isChange = true;
                }
                int n2 = 0;
                int n3 = 0;
                int n4 = 0;
                for (Bond bond : atom) {
                    if (bond.type.equals("single")) {
                        ++n2;
                        continue;
                    }
                    if (bond.type.startsWith("delo") || bond.type.startsWith("arom")) {
                        ++n3;
                        continue;
                    }
                    if (!bond.type.equals("double")) continue;
                    ++n4;
                }
                if (n2 == 2 && n3 == 1) {
                    for (Bond bond : atom) {
                        if (!bond.type.startsWith("delo") && !bond.type.startsWith("arom") || bond.type.equals("double")) continue;
                        bond.type = "double";
                        isChange = true;
                    }
                } else if (n2 == 1 && n4 == 2) {
                    for (Bond bond : atom) {
                        if (!bond.type.equals("double")) continue;
                        bond.type = "deloc";
                        isChange = true;
                    }
                }
            }
        } else if (n == 4) {
            for (Bond bond : atom) {
                if (bond.type.equals("single")) continue;
                bond.type = "single";
                isChange = true;
            }
            if (atom.charge.floatValue() != 1.0f) {
                atom.charge = Float.valueOf(1.0f);
                isChange = true;
            }
        }
    }

    static void sortPhosphors(Atom atom) {
        block16: {
            Atom atom2;
            int n;
            block17: {
                n = atom.size();
                if (n == 1 || n == 2) break block16;
                if (n != 3) break block17;
                for (Bond bond : atom) {
                    if (bond.type.equals("single")) continue;
                    bond.type = "single";
                    isChange = true;
                }
                break block16;
            }
            if (n != 4) break block16;
            int n2 = 0;
            for (Bond bond : atom) {
                atom2 = bond.another(atom);
                if (!atom2.symbol.equals("O") || atom2.size() != 1) continue;
                ++n2;
            }
            for (Bond bond : atom) {
                atom2 = bond.another(atom);
                if (n2 == 1) {
                    if (atom2.symbol.equals("O") && atom2.size() == 1) {
                        if (!bond.type.equals("double")) {
                            bond.type = "double";
                            isChange = true;
                        }
                        if (atom2.charge.floatValue() == 0.0f) continue;
                        atom2.charge = Float.valueOf(0.0f);
                        isChange = true;
                        continue;
                    }
                    if (!bond.type.equals("single")) {
                        bond.type = "single";
                        isChange = true;
                    }
                    if (atom2.charge.floatValue() == 0.0f) continue;
                    atom2.charge = Float.valueOf(0.0f);
                    isChange = true;
                    continue;
                }
                if (n2 == 2) {
                    if (atom2.symbol.equals("O") && atom2.size() == 1) {
                        if (!bond.type.equals("deloc")) {
                            bond.type = "deloc";
                            isChange = true;
                        }
                        if (atom2.charge.floatValue() == -0.5f) continue;
                        atom2.charge = Float.valueOf(-0.5f);
                        isChange = true;
                        continue;
                    }
                    if (!bond.type.equals("single")) {
                        bond.type = "single";
                        isChange = true;
                    }
                    if (atom2.charge.floatValue() == 0.0f) continue;
                    atom2.charge = Float.valueOf(0.0f);
                    isChange = true;
                    continue;
                }
                if (n2 == 3) {
                    if (atom2.symbol.equals("O") && atom2.size() == 1) {
                        if (!bond.type.startsWith("delo")) {
                            bond.type = "deloc";
                            isChange = true;
                        }
                        if (atom2.charge.floatValue() == -0.66f) continue;
                        atom2.charge = Float.valueOf(-0.66f);
                        isChange = true;
                        continue;
                    }
                    if (!bond.type.equals("single")) {
                        bond.type = "single";
                        isChange = true;
                    }
                    if (atom2.charge.floatValue() == 0.0f) continue;
                    atom2.charge = Float.valueOf(0.0f);
                    isChange = true;
                    continue;
                }
                if (n2 != 4) continue;
                if (!bond.type.startsWith("delo")) {
                    bond.type = "deloc";
                    isChange = true;
                }
                if (atom2.charge.floatValue() == -0.75f) continue;
                atom2.charge = Float.valueOf(-0.75f);
                isChange = true;
            }
        }
    }

    static void sortSulphurs(Atom atom) {
        block15: {
            int n;
            block17: {
                block16: {
                    n = atom.size();
                    if (n == 1) break block15;
                    if (n != 2) break block16;
                    for (Bond bond : atom) {
                        if (bond.type.equals("single")) continue;
                        bond.type = "single";
                        isChange = true;
                    }
                    break block15;
                }
                if (n != 3) break block17;
                if (atom.charge.floatValue() != 1.0f) break block15;
                for (Bond bond : atom) {
                    if (bond.type.equals("single")) continue;
                    bond.type = "single";
                    isChange = true;
                }
                break block15;
            }
            if (n == 4) {
                Atom atom2;
                int n2 = 0;
                for (Bond bond : atom) {
                    atom2 = bond.another(atom);
                    if (!atom2.symbol.equals("O") || atom2.size() != 1) continue;
                    ++n2;
                }
                for (Bond bond : atom) {
                    atom2 = bond.another(atom);
                    if (n2 == 1) {
                        if (atom2.symbol.equals("O") && atom2.size() == 1) {
                            if (!bond.type.equals("double")) {
                                bond.type = "double";
                                isChange = true;
                            }
                            if (atom2.charge.floatValue() == 0.0f) continue;
                            atom2.charge = Float.valueOf(0.0f);
                            isChange = true;
                            continue;
                        }
                        if (atom2.charge.floatValue() == 0.0f) continue;
                        atom2.charge = Float.valueOf(0.0f);
                        isChange = true;
                        continue;
                    }
                    if (n2 == 2) {
                        if (atom2.symbol.equals("O") && atom2.size() == 1) {
                            if (!bond.type.equals("double")) {
                                bond.type = "double";
                                isChange = true;
                            }
                            if (atom2.charge.floatValue() == 0.0f) continue;
                            atom2.charge = Float.valueOf(0.0f);
                            isChange = true;
                            continue;
                        }
                        if (!bond.type.equals("single")) {
                            bond.type = "single";
                            isChange = true;
                        }
                        if (atom2.charge.floatValue() == 0.0f) continue;
                        atom2.charge = Float.valueOf(0.0f);
                        isChange = true;
                        continue;
                    }
                    if (n2 == 3) {
                        if (!atom2.symbol.equals("O") || atom2.size() != 1) continue;
                        if (!bond.type.startsWith("delo")) {
                            bond.type = "deloc";
                            isChange = true;
                        }
                        if (atom2.charge.floatValue() == -0.33f) continue;
                        atom2.charge = Float.valueOf(-0.33f);
                        isChange = true;
                        continue;
                    }
                    if (n2 != 4) continue;
                    if (!bond.type.startsWith("delo")) {
                        bond.type = "deloc";
                        isChange = true;
                    }
                    if (atom2.charge.floatValue() == -0.5f) continue;
                    atom2.charge = Float.valueOf(-0.5f);
                    isChange = true;
                }
            }
        }
    }
}

