/*
 * Decompiled with CFR 0.152.
 */
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class GenericRestraint
implements Comparable<GenericRestraint> {
    int sign = 0;
    static final String VOID_TYPE = "/ void /";
    static final List<String> typeList = Arrays.asList("positiv", "both", "negativ");
    boolean reordered = false;
    static final PermGrp sortBond = new PermGrp(2, new int[][]{{1, 0}});
    static final PermGrp sortAngle = new PermGrp(2, new int[][]{{2, 1, 0}});
    static final PermGrp sortTor = new PermGrp(2, new int[][]{{3, 2, 1, 0}});
    static final PermGrp sortChir = new PermGrp(3, new int[][]{{0, 2, 3, 1}});
    static final PermGrp sortPlane = null;
    static final PermGrp sortCross0 = new PermGrp(2, new int[][]{{0, 2, 1}});
    static final PermGrp sortCross1 = new PermGrp(2, new int[][]{{0, 2, 1}});
    static final PermGrp sortCross2 = new PermGrp(8, new int[][]{{0, 4, 3, 2, 1}, {0, 1, 2, 4, 3}});
    static final PermGrp sortCross3 = new PermGrp(6, new int[][]{{0, 1, 2, 4, 5, 3}, {0, 2, 1, 5, 4, 3}});
    static final PermGrp sortCross4 = new PermGrp(24, new int[][]{{0, 1, 2, 4, 5, 6, 3}, {0, 2, 1, 6, 5, 4, 3}, {0, 3, 5, 1, 6, 2, 4}});
    static final PermGrp sortCross5 = new PermGrp(10, new int[][]{{0, 1, 2, 4, 5, 6, 7, 3}, {0, 2, 1, 7, 6, 5, 4, 3}});
    static final PermGrp sortCross6 = new PermGrp(12, new int[][]{{0, 1, 2, 4, 5, 6, 7, 8, 3}, {0, 2, 1, 8, 7, 6, 5, 4, 3}});
    List<Atom> atoms;
    String key;
    String type;
    Value value;
    Sigma sigma;
    Integer period;
    PermGrp sorter;

    static String getChirType(String string) {
        String string2 = string.toLowerCase();
        for (String string3 : typeList) {
            if (!string3.startsWith(string2) && !string2.startsWith(string3)) continue;
            return string3;
        }
        return VOID_TYPE;
    }

    void initBothAndSign() {
        if (typeList.contains(this.type)) {
            this.sign = 1;
        }
    }

    GenericRestraint setSign() {
        if (this.sign != 0) {
            int n = Atom.sign(this.atoms);
            if (Math.abs(n) != 1) {
                throw new NullPointerException();
            }
            this.sign = n;
        }
        return this;
    }

    boolean isConsistent() {
        return this.sign == 0 || this.type.equals("both") || this.type.equals(typeList.get(1 - this.sign));
    }

    void checkType() {
        if (!this.isConsistent() && Env.vbPrint) {
            String string = "WARNING: actual (" + this.sign + ") and intended (" + this.type + ") chirality differ for";
            String string2 = " ";
            for (int i = 0; i < 4; ++i) {
                string = string + string2 + this.atoms.get((int)i).key4;
                string2 = "-";
            }
            System.err.println(string);
        }
    }

    void setType() {
        if (this.sign == 0 || this.type.equals("both")) {
            return;
        }
        this.type = typeList.get(1 - this.sign);
    }

    String getType(int n) {
        if (0 > n || n > 2) {
            return VOID_TYPE;
        }
        return typeList.get(n);
    }

    int getIndex() {
        if (this.sign == 0) {
            return -1;
        }
        return typeList.indexOf(this.type);
    }

    String[] getOptions() {
        String[] stringArray = new String[3];
        if (this.sign == 0) {
            throw new NullPointerException();
        }
        if (this.sign > 0) {
            stringArray[0] = "keep \"positive\"";
            stringArray[2] = "make \"negative\"";
        } else if (this.sign < 0) {
            stringArray[0] = "make \"positive\"";
            stringArray[2] = "keep \"negative\"";
        }
        stringArray[1] = "allow \"both\"";
        return stringArray;
    }

    public boolean equals(Object object) {
        return this.compareTo((GenericRestraint)object) == 0;
    }

    public String toString() {
        return this.atoms.toString();
    }

    @Override
    public int compareTo(GenericRestraint genericRestraint) {
        int n = this.atoms.size();
        int n2 = n - genericRestraint.atoms.size();
        for (int i = 0; i < n; ++i) {
            if (n2 != 0) {
                return n2;
            }
            n2 = Atom.originComparator.compare(this.atoms.get(i), genericRestraint.atoms.get(i));
        }
        return n2;
    }

    GenericRestraint(int n) {
        this.atoms = new ArrayList<Atom>(n);
    }

    GenericRestraint(Bond bond) {
        this.atoms = new ArrayList<Atom>(2);
        this.atoms.add(bond.atom1);
        this.atoms.add(bond.atom2);
        this.type = bond.type;
        this.value = bond.value;
        this.sorter = sortBond;
        this.sort();
    }

    GenericRestraint emptyInstance() {
        GenericRestraint genericRestraint = new GenericRestraint(this.atoms.size());
        genericRestraint.sorter = this.sorter;
        return genericRestraint;
    }

    void sort() {
        if (this.sorter == null) {
            Collections.sort(this.atoms, Atom.originComparator);
        } else {
            this.sorter.sort(this.atoms, Atom.originComparator);
        }
    }

    GenericRestraint duplicatePart() {
        return this.duplicate(false);
    }

    GenericRestraint duplicate() {
        return this.duplicate(true);
    }

    private GenericRestraint duplicate(boolean bl) {
        GenericRestraint genericRestraint = this.emptyInstance();
        genericRestraint.atoms = new ArrayList<Atom>(this.atoms.size());
        for (Atom atom : this.atoms) {
            if (atom == Atom.NULL) {
                genericRestraint.atoms.add(Atom.NULL);
                continue;
            }
            if (atom == atom.coupled) {
                if (bl) {
                    throw new NullPointerException();
                }
                genericRestraint.atoms.add(atom.coupled);
                continue;
            }
            genericRestraint.atoms.add(atom.coupled);
        }
        genericRestraint.sort();
        genericRestraint.key = this.key;
        genericRestraint.type = this.type;
        genericRestraint.value = this.value;
        genericRestraint.sigma = this.sigma;
        genericRestraint.period = this.period;
        genericRestraint.sign = this.sign;
        return genericRestraint;
    }

    GenericRestraint applyDiff(GenericRestraint genericRestraint) {
        GenericRestraint genericRestraint2 = genericRestraint.emptyInstance();
        genericRestraint2.atoms = new ArrayList<Atom>(genericRestraint.atoms);
        genericRestraint2.key = this.key;
        genericRestraint2.type = genericRestraint.type == null ? this.type : genericRestraint.type;
        genericRestraint2.value = genericRestraint.value == null ? this.value : genericRestraint.value;
        genericRestraint2.sigma = genericRestraint.sigma == null ? this.sigma : genericRestraint.sigma;
        genericRestraint2.period = genericRestraint.period == null ? this.period : genericRestraint.period;
        return genericRestraint2;
    }

    boolean diff(GenericRestraint genericRestraint) {
        boolean bl = this.equals(genericRestraint);
        bl &= genericRestraint.type == null ? this.type == null : genericRestraint.type.equals(this.type);
        bl &= genericRestraint.value == null ? this.value == null : genericRestraint.value.similar(this.value);
        bl &= genericRestraint.sigma == null ? this.sigma == null : genericRestraint.sigma.similar(this.sigma);
        return !(bl &= genericRestraint.period == null ? this.period == null : genericRestraint.period.equals(this.period));
    }

    GenericRestraint deriveDiff(GenericRestraint genericRestraint) {
        GenericRestraint genericRestraint2 = genericRestraint.emptyInstance();
        genericRestraint2.atoms = new ArrayList<Atom>(genericRestraint.atoms);
        genericRestraint2.key = this.key;
        genericRestraint2.type = genericRestraint.type != null && genericRestraint.type.equals(this.type) ? null : genericRestraint.type;
        genericRestraint2.value = genericRestraint.value != null && genericRestraint.value.similar(this.value) ? null : genericRestraint.value;
        genericRestraint2.sigma = genericRestraint.sigma != null && genericRestraint.sigma.similar(this.sigma) ? null : genericRestraint.sigma;
        genericRestraint2.sigma = genericRestraint.sigma != null && genericRestraint.sigma.similar(this.sigma) ? null : genericRestraint.sigma;
        genericRestraint2.period = genericRestraint.period != null && genericRestraint.period.equals(this.period) ? null : genericRestraint.period;
        return genericRestraint2;
    }

    GenericRestraint asDeleted() {
        GenericRestraint genericRestraint = this.emptyInstance();
        genericRestraint.atoms = new ArrayList<Atom>(this.atoms);
        genericRestraint.key = this.key;
        genericRestraint.type = this.type;
        return genericRestraint;
    }

    Residue getResidue() {
        Residue residue = this.atoms.get((int)0).residue;
        for (Atom atom : this.atoms) {
            if (atom == Atom.NULL || atom.residue == residue) continue;
            return null;
        }
        return residue;
    }

    void setValue(Object object, Object object2) {
        if (object == null != (object2 == null)) {
            throw new NullPointerException();
        }
        this.value = object == null ? null : new Value(((Float)object).floatValue(), ((Float)object2).floatValue());
    }

    class UndoableEditType
    extends Backup {
        String valueOld;
        String valueNew;

        UndoableEditType(String string) {
            this.valueOld = GenericRestraint.this.type;
            this.valueNew = string;
            GenericRestraint.this.type = string;
            if (Env.vbPrint) {
                System.out.println(":::: " + GenericRestraint.this.type + " chir.type");
            }
        }

        void undo() {
            GenericRestraint.this.type = this.valueOld;
        }

        void redo() {
            GenericRestraint.this.type = this.valueNew;
        }
    }
}

