/*
 * Decompiled with CFR 0.152.
 */
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Shape;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import java.awt.font.FontRenderContext;
import java.awt.geom.Ellipse2D;
import java.awt.geom.Line2D;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RectangularShape;
import java.util.Collections;
import javax.swing.JPanel;

class JLGPanel
extends JPanel
implements MouseListener,
MouseMotionListener,
MouseWheelListener {
    GLib gLib = new GLib();
    Molecule selectedLink;
    Molecule storedLink;
    Atom selectedAtom;
    Atom storedAtom;
    Bond selectedBond;
    Molecule selectedBoxLink;
    boolean selectLink = true;
    boolean selectAtom = true;
    boolean selectBond = true;
    boolean dialogBlocked = false;
    MouseAdapter currentMode;
    Point2D cursorNew = new Point2D.Double(0.0, 0.0);
    Point2D cursorOld = new Point2D.Double(0.0, 0.0);
    double centreX;
    double centreY;
    double scale = 25.0;
    double[] rAo = new double[2];
    double[] rAn = new double[2];
    double[] rAd = new double[2];
    double coef = 0.08f;
    Atom movingAtom = null;
    Molecule movingLink = null;
    Font f1 = new Font("serif", 1, 14);
    Font f2 = new Font("serif", 1, 10);
    float[] dash1 = new float[]{3.0f};
    BasicStroke line = new BasicStroke(1.0f);
    BasicStroke dashed = new BasicStroke(1.0f, 0, 0, 10.0f, this.dash1, 0.0f);
    BasicStroke line2 = new BasicStroke(2.0f);
    BasicStroke dashed2 = new BasicStroke(2.0f, 0, 0, 10.0f, this.dash1, 0.0f);

    JLGPanel(Dimension dimension, MouseListener mouseListener) {
        this.setName("JLigand Panel");
        this.setBackground(Color.WHITE);
        this.setFocusable(true);
        this.setPreferredSize(dimension);
        this.centreX = dimension.getWidth() / 2.0;
        this.centreY = dimension.getHeight() / 2.0;
        this.addMouseMotionListener(this);
        this.addMouseWheelListener(this);
        this.addMouseListener(mouseListener);
        this.addMouseListener(this);
        if (Env.showLys) {
            String string = "LYS";
            boolean bl = false;
            Monomer monomer = StdLib.get(string, bl);
            monomer.recentre();
            this.gLib.undoableAddMolecule(string, monomer);
        }
    }

    void drawMessage(String string) {
        this.getGraphics().drawString(string, (this.getWidth() - this.getRootPane().getWidth()) / 2 + 44, 20);
    }

    public void resetPanel() {
        this.storedLink = null;
        this.storedAtom = null;
        this.selectedLink = null;
        this.selectedAtom = null;
        this.selectedBond = null;
        this.selectedBoxLink = null;
        this.selectLink = true;
        this.selectAtom = true;
        this.selectBond = true;
        this.dialogBlocked = false;
        this.removeMouseListener(this.currentMode);
        this.currentMode = JLMain.option.equals("DELETE") ? new ModeDelete() : (JLMain.option.equals("LINK") ? new ModeLink() : new ModeAdd());
        this.addMouseListener(this.currentMode);
        this.requestFocusInWindow();
        this.repaint();
    }

    public void setCoordinates(Point2D point2D) {
        this.cursorOld.setLocation(this.cursorNew);
        this.cursorNew.setLocation(point2D);
        this.rAo[0] = (this.cursorOld.getX() - this.centreX) / this.scale;
        this.rAo[1] = (this.cursorOld.getY() - this.centreY) / this.scale;
        this.rAn[0] = (this.cursorNew.getX() - this.centreX) / this.scale;
        this.rAn[1] = (this.cursorNew.getY() - this.centreY) / this.scale;
        this.rAd[0] = (this.cursorNew.getX() - this.cursorOld.getX()) / this.scale;
        this.rAd[1] = (this.cursorNew.getY() - this.cursorOld.getY()) / this.scale;
    }

    public void mousePressed(MouseEvent mouseEvent) {
        this.setCoordinates(mouseEvent.getPoint());
        this.setCoordinates(mouseEvent.getPoint());
        this.selectLink = false;
        this.selectAtom = false;
        this.selectBond = false;
        this.stopMoving();
        if (JLMain.buttonsMask == 1088 && this.selectedLink != null && this.selectedAtom != null) {
            this.movingAtom = this.selectedAtom = this.gLib.undoableReplaceAtom(this.selectedLink, this.selectedAtom);
            this.movingLink = this.selectedLink;
        }
        this.repaint();
    }

    public void mouseReleased(MouseEvent mouseEvent) {
        this.setCoordinates(mouseEvent.getPoint());
        this.setCoordinates(mouseEvent.getPoint());
        this.selectLink = true;
        this.selectAtom = true;
        this.selectBond = true;
        this.stopMoving();
        this.repaint();
    }

    public void mouseClicked(MouseEvent mouseEvent) {
        this.stopMoving();
    }

    public void mouseEntered(MouseEvent mouseEvent) {
        this.setCoordinates(mouseEvent.getPoint());
        this.setCoordinates(mouseEvent.getPoint());
        this.selectLink = true;
        this.selectAtom = true;
        this.selectBond = true;
        this.stopMoving();
    }

    public void mouseExited(MouseEvent mouseEvent) {
        this.stopMoving();
    }

    public void stopMoving() {
        if (this.movingLink != null && this.movingAtom != null) {
            this.gLib.movingAtomStopped(this.movingLink, this.movingAtom);
        }
        this.movingAtom = null;
        this.movingLink = null;
    }

    public void mouseMoved(MouseEvent mouseEvent) {
        this.mouseDragged(mouseEvent);
    }

    public void mouseDragged(MouseEvent mouseEvent) {
        this.setCoordinates(mouseEvent.getPoint());
        if (this.movingLink != null && this.movingAtom != null) {
            this.gLib.moveAtom(this.movingLink, this.movingAtom, this.rAd);
        } else if (JLMain.buttonsMask == 1536) {
            double d = 2.0 * this.centreY * this.coef;
            double d2 = Math.max(0.0, this.cursorNew.getY());
            double d3 = Math.max(0.0, this.cursorOld.getY());
            double d4 = (d + d2) / (d + d3);
            this.scale *= d4;
        } else if (JLMain.buttonsMask == 1152) {
            if (this.selectedLink != null) {
                this.gLib.moveMol(this.selectedLink, this.rAd);
            }
        } else if (JLMain.buttonsMask == 1024) {
            if (this.selectedLink != null) {
                this.gLib.rotateMol(this.selectedLink, this.rAo, this.rAn);
            }
        } else if (JLMain.buttonsMask == 4096 && this.selectedLink != null) {
            this.gLib.moveMol(this.selectedLink, this.rAd);
        }
        this.repaint();
    }

    public void mouseWheelMoved(MouseWheelEvent mouseWheelEvent) {
        double d = this.centreY * this.coef;
        double d2 = Math.max(d / 2.0, d + (double)mouseWheelEvent.getWheelRotation());
        double d3 = d2 / d;
        this.scale *= d3;
        this.repaint();
    }

    void checkVisited() {
        for (Molecule molecule : this.gLib) {
            for (Atom atom : molecule.atoms) {
                for (Bond bond : atom) {
                    if (!bond.visited) continue;
                    throw new NullPointerException();
                }
            }
        }
    }

    public void paintComponent(Graphics graphics) {
        Cloneable cloneable;
        double d;
        Object object222;
        super.paintComponent(graphics);
        for (Object object222 : this.gLib) {
            Collections.sort(((Molecule)object222).atoms, Atom.zComparator);
        }
        this.checkVisited();
        Graphics2D graphics2D = (Graphics2D)graphics;
        object222 = new Ellipse2D.Double();
        Line2D.Double double_ = new Line2D.Double();
        Point2D.Double double_2 = new Point2D.Double();
        Point2D.Double double_3 = new Point2D.Double();
        Molecule molecule = null;
        Atom object3 = null;
        Object object4 = null;
        double d2 = 4.0;
        double d3 = 5.0;
        double d4 = 1.0E7;
        for (Molecule molecule2 : this.gLib) {
            d = d4 * 2.0;
            for (Atom object5 : molecule2.atoms) {
                boolean bl = JLMain.showHydrogens || !object5.symbol.equals("H");
                ((Point2D)double_2).setLocation(object5.xyz[0] * this.scale + this.centreX, object5.xyz[1] * this.scale + this.centreY);
                for (Object object : object5) {
                    boolean bl2;
                    if (((Bond)object).visited) {
                        ((Bond)object).visited = false;
                        continue;
                    }
                    ((Bond)object).visited = true;
                    cloneable = ((Bond)object).another(object5);
                    boolean bl3 = bl2 = JLMain.showHydrogens || !((Atom)cloneable).symbol.equals("H");
                    if (!bl || !bl2) continue;
                    ((Point2D)double_3).setLocation(((Atom)cloneable).xyz[0] * this.scale + this.centreX, ((Atom)cloneable).xyz[1] * this.scale + this.centreY);
                    double_.setLine(double_3, double_2);
                    double d5 = double_.ptSegDist(this.cursorNew);
                    if (d5 < d2) {
                        object3 = null;
                        object4 = object;
                    }
                    if (!(d5 < d)) continue;
                    d = d5;
                }
                if (!bl) continue;
                double d6 = double_2.distance(this.cursorNew);
                if (d6 < d3) {
                    object3 = object5;
                    object4 = null;
                }
                if (!(d6 < d)) continue;
                d = d6;
            }
            if (object3 != null || object4 != null) {
                molecule = molecule2;
                break;
            }
            if (!(d < d4)) continue;
            d4 = d;
            molecule = molecule2;
        }
        this.checkVisited();
        if (this.selectLink) {
            this.selectedLink = molecule;
        }
        if (this.selectAtom) {
            this.selectedAtom = object3;
        }
        if (this.selectBond) {
            this.selectedBond = object4;
        }
        this.selectedBoxLink = null;
        for (Molecule molecule2 : this.gLib) {
            Object object;
            d = molecule2.xyz[0] * this.scale + this.centreX;
            double d7 = molecule2.xyz[1] * this.scale + this.centreY;
            double d8 = molecule2.radius * this.scale;
            graphics.setColor(Color.LIGHT_GRAY);
            if (Env.vbGraphics) {
                ((RectangularShape)object222).setFrame(d - d8, d7 - d8, 2.0 * d8, 2.0 * d8);
                graphics2D.draw((Shape)object222);
                graphics2D.drawLine((int)d, (int)d7, (int)d, (int)d7 + (int)d8);
            }
            object = graphics2D.getFontRenderContext();
            cloneable = this.f1.getStringBounds(molecule2.key8, (FontRenderContext)object);
            double d9 = d;
            double d10 = d7 + d8 + 17.0;
            double d11 = ((RectangularShape)cloneable).getWidth() / 2.0;
            double d12 = ((RectangularShape)cloneable).getHeight() / 2.0;
            double d13 = 3.0;
            double d14 = 3.0;
            Point2D.Double double_4 = new Point2D.Double(d9 - d11, d10 + d12);
            Point2D.Double double_5 = new Point2D.Double(d9 - d11 - d13, d10 - d12 - d14 + 5.0);
            Point2D.Double double_6 = new Point2D.Double(d9 + d11 + d13, d10 + d12 + d14 + 0.0);
            Rectangle2D.Double double_7 = new Rectangle2D.Double();
            double_7.setFrameFromDiagonal(double_5, double_6);
            graphics2D.setStroke(this.line);
            if (Env.vbGraphics) {
                graphics2D.draw(double_7);
            }
            graphics.setFont(this.f1);
            graphics.setColor(Color.BLACK);
            if (molecule2.restraints == null) {
                graphics.setColor(Color.RED);
            }
            graphics2D.drawString(molecule2.key8, (float)((Point2D)double_4).getX(), (float)((Point2D)double_4).getY());
            graphics.setColor(Color.BLACK);
            if (this.selectedAtom != null || this.selectedBond != null || this.selectedBoxLink != null || !double_7.contains(this.cursorNew)) continue;
            this.selectedBoxLink = molecule2;
        }
        for (Molecule molecule2 : this.gLib) {
            for (Atom atom : molecule2.atoms) {
                for (Bond bond : atom) {
                    if (bond.visited) {
                        bond.visited = false;
                        continue;
                    }
                    bond.visited = true;
                    this.drawBond(graphics, graphics2D, bond);
                }
                this.drawAtom(graphics, graphics2D, atom);
            }
        }
        this.checkVisited();
    }

    public void drawAtom(Graphics graphics, Graphics2D graphics2D, Atom atom) {
        int n;
        if (!JLMain.showHydrogens && atom.symbol.equals("H")) {
            return;
        }
        AtomDisplay atomDisplay = new AtomDisplay(atom.symbol);
        graphics.setFont(this.f1);
        graphics.setColor(Color.BLACK);
        graphics2D.setStroke(this.line);
        int n2 = (int)(atom.xyz[0] * this.scale + this.centreX);
        int n3 = (int)(atom.xyz[1] * this.scale + this.centreY);
        int n4 = atomDisplay.xOffset;
        int n5 = atomDisplay.yOffset;
        int n6 = atomDisplay.ovalRadius;
        graphics.setColor(Color.WHITE);
        graphics.fillOval(n2 - n6, n3 - n6, n6 * 2, n6 * 2);
        if (Env.vbGraphics && atom.isHidden()) {
            n = n6 * 2;
            graphics.setColor(Color.RED);
            graphics.drawOval(n2 - n, n3 - n, n * 2, n * 2);
        }
        if (Env.vbGraphics && atom.hasChangedCharge()) {
            n = n6 * 2 + 2;
            graphics.setColor(Color.GREEN);
            graphics.drawOval(n2 - n, n3 - n, n * 2, n * 2);
        }
        graphics.setColor(atomDisplay.color);
        String string = atom.symbol;
        if (JLMain.showNames) {
            string = atom.key4;
        }
        graphics.drawString(string, n2 + n4, n3 + n5);
        if (JLMain.showCharges) {
            String string2 = "";
            if (atom.charge.floatValue() > 0.0f) {
                string2 = "+" + atom.charge;
            } else if (atom.charge.floatValue() < 0.0f) {
                string2 = "" + atom.charge;
            }
            graphics.setFont(this.f2);
            graphics.drawString(string2, n2 - n4, n3 - n5);
            graphics.setFont(this.f1);
        }
        if (atom == this.storedAtom || atom == this.selectedAtom) {
            if (JLMain.option.equals("DELETE")) {
                graphics.setColor(Color.RED);
            } else if (JLMain.option.equals("LINK")) {
                graphics.setColor(Color.MAGENTA);
            } else {
                graphics.setColor(Color.BLUE);
            }
            int n7 = atomDisplay.focusLineX;
            int n8 = n5 + 2;
            graphics.drawRect(n2 - n7, n3 + n8, 2 * n7, 1);
        }
    }

    public void drawBond(Graphics graphics, Graphics2D graphics2D, Bond bond) {
        if (!JLMain.showHydrogens && (bond.atom1.symbol.equals("H") || bond.atom2.symbol.equals("H"))) {
            return;
        }
        int n = (int)(bond.atom1.xyz[0] * this.scale + this.centreX);
        int n2 = (int)(bond.atom1.xyz[1] * this.scale + this.centreY);
        int n3 = (int)(bond.atom2.xyz[0] * this.scale + this.centreX);
        int n4 = (int)(bond.atom2.xyz[1] * this.scale + this.centreY);
        int n5 = 0;
        int n6 = 0;
        double d = ((double)n4 - (double)n2) / ((double)n3 - (double)n);
        double d2 = Math.abs(Math.atan(d));
        if (d2 >= 0.0 && d2 <= 0.39269908169872414) {
            n5 = 0;
            n6 = 3;
        } else if (d2 > 0.39269908169872414 && d2 <= 1.1780972450961724) {
            n5 = 2;
            n6 = 2;
        } else if (d2 > 1.1780972450961724 && d2 <= 1.5707963267948966) {
            n5 = 3;
            n6 = 0;
        }
        if (n6 == 2 && d > 0.0) {
            n6 *= -1;
        }
        graphics.setColor(Color.BLACK);
        if (bond.atom1.residue != bond.atom2.residue) {
            graphics.setColor(Color.MAGENTA);
        }
        boolean bl = false;
        graphics2D.setStroke(this.line);
        if (bond == this.selectedBond && JLMain.option.equals("DELETE")) {
            bl = true;
            graphics2D.setStroke(this.line2);
            graphics.setColor(Color.RED);
        }
        if (bond.type.equals("single")) {
            graphics2D.draw(new Line2D.Double(n, n2, n3, n4));
        } else if (bond.type.equals("double")) {
            graphics2D.draw(new Line2D.Double(n - n5, n2 - n6, n3 - n5, n4 - n6));
            graphics2D.draw(new Line2D.Double(n + n5, n2 + n6, n3 + n5, n4 + n6));
        } else if (bond.type.equals("triple")) {
            graphics2D.draw(new Line2D.Double(n - n5, n2 - n6, n3 - n5, n4 - n6));
            graphics2D.draw(new Line2D.Double(n, n2, n3, n4));
            graphics2D.draw(new Line2D.Double(n + n5, n2 + n6, n3 + n5, n4 + n6));
        } else if (bond.type.equals("aromatic") || bond.type.equals("deloc")) {
            graphics2D.setStroke(this.dashed);
            if (bl) {
                graphics2D.setStroke(this.dashed2);
            }
            graphics2D.draw(new Line2D.Double(n - n5, n2 - n6, n3 - n5, n4 - n6));
            graphics2D.draw(new Line2D.Double(n + n5, n2 + n6, n3 + n5, n4 + n6));
        } else if (bond.type.equals("metal")) {
            graphics2D.setStroke(this.dashed);
            if (bl) {
                graphics2D.setStroke(this.dashed2);
            }
            graphics2D.draw(new Line2D.Double(n, n2, n3, n4));
        }
    }

    public class AtomDisplay {
        private Color color = null;
        private int xOffset = 0;
        private int yOffset = 0;
        private int ovalRadius = 0;
        private int focusLineX = 0;

        public AtomDisplay(String string) {
            int n = 0;
            int n2 = 0;
            if (string.equals("C")) {
                this.color = Color.BLACK;
                n = 8;
                n2 = 10;
                this.focusLineX = 6;
            } else if (string.equals("O")) {
                this.color = Color.RED;
                n = 10;
                n2 = 10;
                this.focusLineX = 6;
            } else if (string.equals("N")) {
                this.color = Color.BLUE;
                n = 11;
                n2 = 10;
                this.focusLineX = 6;
            } else if (string.equals("S")) {
                this.color = Color.ORANGE;
                n = 6;
                n2 = 10;
                this.focusLineX = 5;
            } else if (string.equals("F")) {
                this.color = Color.MAGENTA;
                n = 8;
                n2 = 10;
                this.focusLineX = 5;
            } else if (string.equals("Cl")) {
                this.color = Color.MAGENTA;
                n = 14;
                n2 = 11;
                this.focusLineX = 7;
            } else if (string.equals("Br")) {
                this.color = Color.MAGENTA;
                n = 15;
                n2 = 10;
                this.focusLineX = 7;
            } else if (string.equals("I")) {
                this.color = Color.MAGENTA;
                n = 4;
                n2 = 10;
                this.focusLineX = 5;
            } else if (string.equals("P")) {
                this.color = Color.CYAN;
                n = 8;
                n2 = 10;
                this.focusLineX = 5;
            } else if (string.equals("H")) {
                this.color = Color.BLACK;
                n = 11;
                n2 = 10;
                this.focusLineX = 6;
            } else {
                this.color = Color.BLUE;
                n = 11;
                n2 = 10;
                this.focusLineX = 6;
            }
            this.ovalRadius = n > n2 ? n : n2;
            this.ovalRadius = (this.ovalRadius + 2) / 2;
            this.xOffset = -n / 2;
            this.yOffset = n2 / 2;
        }
    }

    class ModeAdd
    extends ModeDialogs {
        ModeAdd() {
        }

        public void mouseClicked(MouseEvent mouseEvent) {
            boolean bl;
            super.mouseClicked(mouseEvent);
            boolean bl2 = bl = JLMain.buttonsMask == 64;
            if (JLGPanel.this.storedAtom != null && JLGPanel.this.selectedAtom == null && bl) {
                if (JLGPanel.this.selectedLink == null) {
                    throw new NullPointerException();
                }
                if (JLGPanel.this.selectedLink.getResidue() == null) {
                    String string = "Cannot edit a linked ligand (except to change the link bond type) - ";
                    string = string + "please undo the link, then edit";
                    DialogWindows.showWarningDialog(string);
                } else {
                    JLGPanel.this.storedAtom = JLGPanel.this.gLib.undoableAddAtom(JLGPanel.this.storedLink, JLGPanel.this.storedAtom, JLMain.option, JLGPanel.this.rAn);
                }
            } else if (JLGPanel.this.selectedAtom != null) {
                JLGPanel.this.storedLink = JLGPanel.this.selectedLink;
                JLGPanel.this.storedAtom = JLGPanel.this.selectedAtom;
            }
            JLGPanel.this.repaint();
        }
    }

    class ModeLink
    extends ModeDialogs {
        ModeLink() {
        }

        public void mouseClicked(MouseEvent mouseEvent) {
            if (mouseEvent.getClickCount() == 2) {
                if (!JLGPanel.this.dialogBlocked) {
                    super.mouseClicked(mouseEvent);
                }
                return;
            }
            JLGPanel.this.dialogBlocked = false;
            if (JLGPanel.this.selectedAtom == JLGPanel.this.storedAtom) {
                return;
            }
            if (JLGPanel.this.selectedAtom == null && JLGPanel.this.storedAtom != null) {
                JLGPanel.this.storedLink = null;
                JLGPanel.this.storedAtom = null;
            } else if (JLGPanel.this.selectedAtom != null && JLGPanel.this.storedAtom == null) {
                JLGPanel.this.storedLink = JLGPanel.this.selectedLink;
                JLGPanel.this.storedAtom = JLGPanel.this.selectedAtom;
            } else if (JLGPanel.this.storedAtom != null) {
                Object object;
                boolean bl = false;
                for (Object object2 : JLGPanel.this.storedAtom) {
                    bl |= JLGPanel.this.selectedAtom == ((Bond)object2).another(JLGPanel.this.storedAtom);
                }
                if (bl) {
                    object = "Error - cannot join atoms which are already joined";
                    DialogWindows.showErrorDialog((String)object);
                } else if (JLGPanel.this.selectedLink == JLGPanel.this.storedLink) {
                    if (JLGPanel.this.selectedLink.getResidue() == null) {
                        object = "Cannot edit a linked ligand (except to change the link bond type) - ";
                        object = (String)object + "please undo the link, then edit";
                        DialogWindows.showWarningDialog((String)object);
                    } else {
                        JLGPanel.this.gLib.undoableAddBond(JLGPanel.this.selectedLink, JLGPanel.this.storedAtom, JLGPanel.this.selectedAtom, "single");
                    }
                } else {
                    Object object2;
                    object = JLGPanel.this.storedLink.getResidue();
                    object2 = JLGPanel.this.selectedLink.getResidue();
                    if (object == null || object2 == null) {
                        String string = object == null ? JLGPanel.this.storedLink.key8 : null;
                        String string2 = object2 == null ? JLGPanel.this.selectedLink.key8 : null;
                        this.cannot2Dialog("Cannot link linked ligand", string, string2, "");
                    } else if (((Residue)object).cootId != ((Residue)object2).cootId) {
                        String string = JLGPanel.this.storedLink.key8;
                        String string3 = JLGPanel.this.selectedLink.key8;
                        this.cannot2Dialog("Link between", string, string3, " is not the one requested by Coot");
                    } else if (((Residue)object).mono == null || ((Residue)object2).mono == null) {
                        String string = ((Residue)object).mono == null ? ((Residue)object).key8 : null;
                        String string4 = ((Residue)object2).mono == null ? ((Residue)object2).key8 : null;
                        this.cannot2Dialog("Please regularise ligand", string, string4, " before linking");
                    } else {
                        String string = JLGPanel.this.storedLink.key8 + "-" + JLGPanel.this.selectedLink.key8;
                        CorrectLinkIdDialog correctLinkIdDialog = new CorrectLinkIdDialog("The", JLGPanel.this.gLib, string);
                        string = correctLinkIdDialog.newKey8;
                        if (string != null) {
                            JLGPanel.this.gLib.undoableAddBond(string, JLGPanel.this.storedLink, JLGPanel.this.storedAtom, JLGPanel.this.selectedLink, JLGPanel.this.selectedAtom, "single");
                        }
                    }
                }
                JLGPanel.this.selectedLink = null;
                JLGPanel.this.selectedAtom = null;
                JLGPanel.this.storedLink = null;
                JLGPanel.this.storedAtom = null;
                JLGPanel.this.dialogBlocked = true;
            }
            JLGPanel.this.repaint();
        }

        void cannot2Dialog(String string, String string2, String string3, String string4) {
            String string5 = string;
            if (string2 == null && string3 == null) {
                throw new NullPointerException();
            }
            string5 = string2 == null ? string5 + " " + string3 + string4 : (string3 == null ? string5 + " " + string2 + string4 : string5 + "s " + string2 + " and " + string3 + string4);
            DialogWindows.showWarningDialog(string5);
        }
    }

    abstract class ModeDialogs
    extends MouseAdapter {
        ModeDialogs() {
        }

        public void mouseClicked(MouseEvent mouseEvent) {
            boolean bl;
            if (mouseEvent.getClickCount() != 2 || mouseEvent.getButton() != 1) {
                return;
            }
            if (JLGPanel.this.selectedAtom == null && JLGPanel.this.selectedBoxLink == null && JLGPanel.this.selectedBond == null) {
                return;
            }
            if (JLGPanel.this.selectedLink == null) {
                throw new NullPointerException();
            }
            JLGPanel.this.storedLink = null;
            JLGPanel.this.storedAtom = null;
            JLGPanel.this.repaint();
            boolean bl2 = bl = JLGPanel.this.selectedLink.getResidue() == null;
            if (JLGPanel.this.selectedAtom != null) {
                new ChangeAtomDialog(JLGPanel.this.selectedLink, JLGPanel.this.selectedAtom);
            } else if (JLGPanel.this.selectedBond != null) {
                new ChangeBondDialog(JLGPanel.this.selectedLink, JLGPanel.this.selectedBond).showDialog();
            } else if (JLGPanel.this.selectedBoxLink != null) {
                ChangeLigandIdDialog changeLigandIdDialog = new ChangeLigandIdDialog(JLGPanel.this.gLib, JLGPanel.this.selectedBoxLink.key8);
                changeLigandIdDialog.showDialog();
                if (changeLigandIdDialog.newKey8 != null) {
                    JLGPanel.this.gLib.undoableRenameMolecule(JLGPanel.this.selectedBoxLink, changeLigandIdDialog.newKey8, changeLigandIdDialog.newKey8);
                }
            } else {
                throw new NullPointerException();
            }
            JLGPanel.this.selectedLink = null;
            JLGPanel.this.selectedAtom = null;
            JLGPanel.this.selectedBond = null;
            JLGPanel.this.repaint();
        }

        void cannotDialog() {
            String string = "Cannot edit a linked ligand (except to change the link bond type) - ";
            string = string + "please undo the link, then edit";
            DialogWindows.showWarningDialog(string);
        }
    }

    class ModeDelete
    extends MouseAdapter {
        ModeDelete() {
        }

        public void mouseClicked(MouseEvent mouseEvent) {
            if (mouseEvent.getButton() == 1) {
                if (JLGPanel.this.selectedAtom == null && JLGPanel.this.selectedBond == null) {
                    return;
                }
                if (JLGPanel.this.selectedLink == null) {
                    throw new NullPointerException();
                }
                if (JLGPanel.this.selectedLink.getResidue() == null) {
                    String string = "Cannot edit a linked ligand (except to change atom and bond types) - ";
                    string = string + "please undo the link, then edit";
                    DialogWindows.showWarningDialog(string);
                } else if (JLGPanel.this.selectedAtom != null) {
                    JLGPanel.this.gLib.undoableRemoveAtom(JLGPanel.this.selectedLink, JLGPanel.this.selectedAtom);
                } else if (JLGPanel.this.selectedBond != null) {
                    JLGPanel.this.gLib.undoableRemoveBond(JLGPanel.this.selectedLink, JLGPanel.this.selectedBond);
                }
                JLGPanel.this.repaint();
            }
        }
    }
}

