/*
 * Decompiled with CFR 0.152.
 */
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.FilenameFilter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class Libcheck {
    private static final String libout = "libcheck.lib";
    private static final String comName = "com";
    private static final String logName = "libcheck.log";

    Libcheck() {
    }

    static Version getVersion() {
        File file = Scratch.getWrkDir();
        ProcessWrapper processWrapper = new ProcessWrapper("libcheck");
        processWrapper.args("-i");
        try {
            processWrapper.execute(file, comName, logName);
            return new Version(new CharArray(new File(file, logName)).toString());
        }
        catch (Exception exception) {
            if (Env.vbPrint) {
                exception.printStackTrace(System.err);
            }
            throw new NullPointerException("cannot run libcheck");
        }
    }

    Monomer regularise(Monomer monomer, boolean bl, boolean bl2) {
        File file;
        CifLib cifLib = new CifLib();
        cifLib.add(monomer);
        if (bl2) {
            file = Libmol.execute(cifLib.toBuffer(), monomer.key8);
        } else {
            boolean bl3 = true;
            file = this.runLibcheckOnly(cifLib.toBuffer(), "L", monomer.key8, bl, bl3);
        }
        cifLib = new CifLib(file);
        return cifLib.getMonomer();
    }

    File runLibcheckOnly(CharArray charArray, String string, String string2, boolean bl, boolean bl2) {
        File file = Scratch.getWrkDir();
        ProcessWrapper processWrapper = new ProcessWrapper("libcheck");
        String string3 = "input." + (string.equals("L") ? "lib" : string.toLowerCase());
        charArray.writeTo(new File(file, string3));
        processWrapper.keywords("N");
        if (!string.equals("PDB")) {
            processWrapper.keywords("NODIST", "Y");
        }
        processWrapper.keywords("REF", "0");
        if (!bl2) {
            processWrapper.keywords("COOR", "Y");
        }
        if (bl) {
            processWrapper.keywords("LCOOR", "N");
        }
        processWrapper.keywords("FILE_" + string.toUpperCase(), string3);
        if (string2 != null) {
            processWrapper.keywords("MON", string2);
        }
        processWrapper.keywords("");
        processWrapper.setenv("CLIBD_MON", StdLib.shortHeaderMap.CLIBD_MON);
        String string4 = "   Libcheck: %-4s %-11s ...  %-3s  ...  ";
        processWrapper.setInfo(string4, file.getName(), string3, string2 == null ? "" : string2);
        processWrapper.execute(file, comName, logName);
        this.cleanWrkdir(file);
        File file2 = new File(file, libout);
        if (!file2.isFile()) {
            throw new NullPointerException();
        }
        return file2;
    }

    File getEntry(String string, boolean bl) {
        File file = Scratch.getWrkDir();
        ProcessWrapper processWrapper = new ProcessWrapper("libcheck");
        processWrapper.keywords("N");
        processWrapper.keywords("REF", "0");
        if (bl) {
            processWrapper.keywords("LCOOR", "N");
        }
        processWrapper.keywords("MON", string);
        processWrapper.keywords("");
        processWrapper.setenv("CLIBD_MON", StdLib.shortHeaderMap.CLIBD_MON);
        processWrapper.setInfo("   Libcheck: %-4s %-11s ...  %-3s  ...  ", file.getName(), "STD_LIB", string);
        processWrapper.execute(file, comName, logName);
        this.cleanWrkdir(file);
        File file2 = new File(file, libout);
        if (!file2.isFile()) {
            throw new NullPointerException();
        }
        return file2;
    }

    List<String> getMatches(Molecule molecule) {
        String string;
        File file = Scratch.getWrkDir();
        ProcessWrapper processWrapper = new ProcessWrapper("libcheck");
        Monomer monomer = new Monomer(molecule);
        monomer.key3 = string = StdLib.getWrkKey();
        monomer.key8 = string;
        monomer.name = string;
        String string2 = "input.pdb";
        new PdbWriter().write(monomer, new File(file, string2), true);
        processWrapper.keywords("N");
        processWrapper.keywords("FILE_PDB", string2);
        processWrapper.keywords("SRCH", "Y");
        processWrapper.keywords("MON", string);
        processWrapper.keywords("");
        processWrapper.setenv("CLIBD_MON", StdLib.compHeaderMap.CLIBD_MON);
        processWrapper.setInfo("   Libcheck: %-4s %-11s ...  %-3s  ...  ", file.getName(), string2, string);
        processWrapper.execute(file, comName, logName);
        this.cleanWrkdir(file);
        ArrayList<String> arrayList = new ArrayList<String>();
        try {
            BufferedReader bufferedReader = new BufferedReader(new FileReader(new File(file, logName)));
            String string3 = bufferedReader.readLine();
            while (string3 != null) {
                if (string3.startsWith("  WARNING : monomer looks like")) {
                    arrayList.add(string3.substring(30, 39).trim());
                }
                string3 = bufferedReader.readLine();
            }
            bufferedReader.close();
        }
        catch (IOException iOException) {
            throw new NullPointerException();
        }
        return arrayList;
    }

    void cleanWrkdir(File file) {
        List<File> list = Arrays.asList(file.listFiles(new FilenameFilter(){

            public boolean accept(File file, String string) {
                boolean bl = string.startsWith("libcheck_") && !string.endsWith(".pdb");
                return bl |= string.equals("libcheck.odb");
            }
        }));
        for (File file2 : list) {
            file2.delete();
        }
    }
}

