/*
 * Decompiled with CFR 0.152.
 */
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class Molecule {
    List<Atom> atoms = new ArrayList<Atom>();
    private static int counter = 0;
    private final int cou = counter++;
    String key8;
    String name;
    Restraints restraints;
    static double minRadius = 0.5;
    double radius;
    double[] xyz = new double[]{0.0, 0.0, 0.0};
    private List<Atom> hiddenAtoms = new ArrayList<Atom>();

    public int hashCode() {
        return this.cou;
    }

    public boolean equals(Object object) {
        return this.compareTo((Molecule)object) == 0;
    }

    public int compareTo(Molecule molecule) {
        return this.cou - molecule.cou;
    }

    public Iterator<Atom> iterator() {
        return this.atoms.iterator();
    }

    void updateSphere() {
        this.xyz = new double[]{0.0, 0.0, 0.0};
        for (Atom atom : this.atoms) {
            for (int i = 0; i < 3; ++i) {
                int n = i;
                this.xyz[n] = this.xyz[n] + atom.xyz[i];
            }
        }
        for (int i = 0; i < 3; ++i) {
            this.xyz[i] = this.xyz[i] / (double)this.atoms.size();
        }
        double d = minRadius * minRadius;
        for (Atom atom : this.atoms) {
            double d2 = 0.0;
            for (int i = 0; i < 3; ++i) {
                double d3 = atom.xyz[i] - this.xyz[i];
                d2 += d3 * d3;
            }
            if (!(d < d2)) continue;
            d = d2;
        }
        this.radius = Math.sqrt(d);
    }

    void saveBaseline(double[] dArray) {
        dArray[0] = this.xyz[0];
        dArray[1] = this.xyz[1] + this.radius;
        dArray[2] = this.xyz[2];
    }

    void restoreBaseline(double[] dArray) {
        double[] dArray2 = new double[]{dArray[0] - this.xyz[0], dArray[1] - this.xyz[1] - this.radius, dArray[2] - this.xyz[2]};
        this.xyz[0] = dArray[0];
        this.xyz[1] = dArray[1] - this.radius;
        this.xyz[2] = dArray[2];
        for (Atom atom : this.atoms) {
            for (int i = 0; i < 3; ++i) {
                int n = i;
                atom.xyz[n] = atom.xyz[n] + dArray2[i];
            }
        }
    }

    Molecule() {
    }

    Molecule(Molecule molecule, boolean bl) {
        Object object;
        Object object2;
        Collections.sort(molecule.atoms, Atom.originComparator);
        LinkedHashMap<Residue, Residue> linkedHashMap = null;
        if (bl) {
            linkedHashMap = new LinkedHashMap<Residue, Residue>();
            for (Residue object3 : molecule.residueList()) {
                linkedHashMap.put(object3, object3.duplicate());
            }
        }
        this.key8 = molecule.key8;
        this.name = molecule.name;
        this.xyz = new double[]{molecule.xyz[0], molecule.xyz[1], molecule.xyz[2]};
        this.radius = molecule.radius;
        this.restraints = null;
        for (Atom atom : molecule.atoms) {
            object2 = atom.residue;
            if (bl) {
                object2 = (Residue)linkedHashMap.get(object2);
            }
            object = new Atom((Residue)object2, atom);
            atom.coupled = object;
            this.atoms.add((Atom)object);
        }
        for (Atom atom : molecule.atoms) {
            object2 = atom.iterator();
            while (object2.hasNext()) {
                object = (Bond)object2.next();
                Atom atom2 = ((Bond)object).another(atom);
                if (Atom.timeComparator.compare(atom, atom2) >= 0) continue;
                Atom atom3 = atom.coupled;
                Atom atom4 = atom2.coupled;
                Bond bond = new Bond(atom3, atom4, (Bond)object);
                atom3.add(bond);
                atom4.add(bond);
            }
        }
        for (Atom atom : molecule.atoms) {
            if (atom.chir == null) continue;
            ((GenericRestraint)object2).atoms.get((int)0).chir = object2 = atom.chir.duplicate();
        }
    }

    Molecule(String string) {
        this.name = string;
        this.key8 = string;
    }

    Molecule(String string, String string2) {
        this.name = string;
        this.key8 = string;
        Residue residue = new Residue();
        residue.name = string;
        residue.key8 = string;
        this.atoms.add(new Atom(residue, string2, string2 + "1", 0.0, 0.0, 0.0));
    }

    Molecule(Monomer monomer) {
        Object object;
        if (monomer.restraints == null) {
            throw new NullPointerException();
        }
        this.name = monomer.name;
        this.key8 = monomer.key8;
        Residue residue = new Residue(monomer);
        for (Atom object22 : monomer.atoms) {
            object = new Atom(residue, object22);
            this.atoms.add((Atom)object);
            object22.coupled = object;
        }
        this.restraints = new Restraints(monomer.restraints);
        for (GenericRestraint genericRestraint : (List)this.restraints.get(0)) {
            object = new Bond(genericRestraint);
            ((Bond)object).atom1.add(object);
            ((Bond)object).atom2.add(object);
        }
        Iterator<Atom> iterator = ((List)this.restraints.get(3)).iterator();
        while (iterator.hasNext()) {
            GenericRestraint genericRestraint;
            genericRestraint.atoms.get((int)0).chir = genericRestraint = (GenericRestraint)((Object)iterator.next());
        }
        iterator = monomer.atoms.iterator();
        while (iterator.hasNext()) {
            Atom atom;
            atom.coupled = atom = iterator.next();
        }
    }

    Residue getResidue() {
        Residue residue = this.atoms.get((int)0).residue;
        for (Atom atom : this.atoms) {
            if (atom.residue == residue) continue;
            return null;
        }
        return residue;
    }

    List<Residue> residueList() {
        LinkedHashSet<Residue> linkedHashSet = new LinkedHashSet<Residue>();
        for (Atom atom : this.atoms) {
            linkedHashSet.add(atom.residue);
        }
        ArrayList arrayList = new ArrayList(linkedHashSet);
        Collections.sort(arrayList);
        return arrayList;
    }

    String linkRecordPDB() {
        Object object;
        Object object2;
        Object object3;
        Object object42;
        Atom atom2;
        ArrayList<Object> arrayList = new ArrayList<Object>();
        for (Atom atom2 : this.atoms) {
            for (Object object42 : atom2) {
                object3 = ((Bond)object42).another(atom2);
                object2 = atom2.residue;
                object = ((Atom)object3).residue;
                if (((Residue)object2).compareTo((Residue)object) >= 0) continue;
                if (((Residue)object2).isFirst == ((Residue)object).isFirst) {
                    throw new NullPointerException();
                }
                arrayList.add(atom2);
                arrayList.add(object3);
            }
        }
        if (arrayList.size() != 2) {
            throw new NullPointerException();
        }
        Atom atom3 = (Atom)arrayList.get(0);
        atom2 = (Atom)arrayList.get(1);
        String string = atom3.residue.mono.key3;
        object42 = atom2.residue.mono.key3;
        object3 = atom3.symbol.length() > 1 || atom3.key4.length() > 3 ? atom3.key4 : " " + atom3.key4;
        object2 = atom2.symbol.length() > 1 || atom2.key4.length() > 3 ? atom2.key4 : " " + atom2.key4;
        object = "A 111";
        String string2 = "B 222";
        if (atom3.residue.cootId != atom2.residue.cootId) {
            throw new NullPointerException();
        }
        if (atom3.residue.cootId > 0) {
            object = atom3.residue.residueId;
            string2 = atom2.residue.residueId;
        }
        String string3 = "LINK        %-4s %-3s %5s                %-4s %-3s %5s                %s";
        return String.format(string3, object3, string, object, object2, object42, string2, this.key8);
    }

    Map<String, Atom> atomView(Atom atom) {
        LinkedHashMap<String, Atom> linkedHashMap = new LinkedHashMap<String, Atom>();
        for (Atom atom2 : this.atoms) {
            if (atom2.residue != atom.residue || linkedHashMap.put(atom2.key4, atom2) == null) continue;
            throw new NullPointerException();
        }
        return linkedHashMap;
    }

    Map<Residue, Molecule> residueView() {
        TreeMap<Residue, Molecule> treeMap = new TreeMap<Residue, Molecule>();
        for (Atom atom : this.atoms) {
            Residue residue = atom.residue;
            Molecule molecule = (Molecule)treeMap.get(residue);
            if (molecule == null) {
                molecule = new Molecule();
                molecule.key8 = residue.key8;
                molecule.name = residue.name;
                if (this.restraints != null) {
                    molecule.restraints = new Restraints();
                    for (int i = 0; i < 5; ++i) {
                        List list = (List)this.restraints.get(i);
                        List list2 = (List)molecule.restraints.get(i);
                        for (GenericRestraint genericRestraint : list) {
                            if (genericRestraint.getResidue() != residue) continue;
                            list2.add(genericRestraint);
                        }
                        Collections.sort(list2);
                    }
                }
                treeMap.put(residue, molecule);
            }
            molecule.atoms.add(atom);
        }
        return treeMap;
    }

    void restoreHydrogenKeys() {
        LinkedHashSet<String> linkedHashSet = new LinkedHashSet<String>();
        for (Atom atom : this.atoms) {
            if (atom.key4 == null || linkedHashSet.add(atom.key4)) continue;
            throw new NullPointerException();
        }
        for (Atom atom : this.atoms) {
            if (atom.key4 != null) continue;
            if (!atom.symbol.equals("H") || atom.size() != 1) {
                throw new NullPointerException();
            }
            Atom atom2 = ((Bond)atom.get(0)).another(atom);
            atom.key4 = "H";
            atom.key4 = atom2.symbol.equals("C") && atom2.key4.toUpperCase().startsWith("C") ? atom.key4 + atom2.key4.substring(1) : atom.key4 + atom2.key4;
            if (atom.key4.length() > 3) {
                atom.key4 = atom.key4.substring(0, 4);
            }
            atom.resetKey(linkedHashSet);
        }
    }

    void excludeHidden() {
        ArrayList<Atom> arrayList = new ArrayList<Atom>();
        for (Atom atom : this.atoms) {
            if (atom.isHidden()) {
                this.hiddenAtoms.add(atom);
                for (Bond bond : atom) {
                    bond.another(atom).remove(bond);
                }
                continue;
            }
            arrayList.add(atom);
        }
        this.atoms.clear();
        this.atoms.addAll(arrayList);
    }

    void includeHidden() {
        int n = this.hiddenAtoms.size();
        while (n-- > 0) {
            Atom atom = this.hiddenAtoms.get(n);
            for (Bond bond : atom) {
                bond.another(atom).add(bond);
            }
        }
        this.atoms.addAll(this.hiddenAtoms);
    }

    Molecule regularise(boolean bl, boolean bl2, boolean bl3) {
        Bond bond;
        Object object;
        Object object2;
        Object object7;
        Object object8;
        if (bl && this.restraints != null) {
            throw new NullPointerException();
        }
        if (bl3) {
            object8 = this.atoms.iterator();
            while (object8.hasNext()) {
                object7 = (Atom)object8.next();
                ((Atom)object7).resetHidden();
            }
        }
        object8 = new double[3];
        this.updateSphere();
        this.saveBaseline((double[])object8);
        object7 = new Molecule(this, bl);
        if (!bl3) {
            for (Atom linkedHashMap2 : ((Molecule)object7).atoms) {
                linkedHashMap2.resetCharge();
            }
        }
        ((Molecule)object7).excludeHidden();
        boolean bl4 = CorrectBonds.correctBondOrders(((Molecule)object7).atoms);
        if (Env.vbPrint) {
            System.out.println("   ----- changed " + bl4);
        }
        if (!bl) {
            ((Molecule)object7).includeHidden();
            return bl4 ? object7 : null;
        }
        Iterator<Atom> iterator = this.atoms.iterator();
        while (iterator.hasNext()) {
            Atom atom;
            atom.coupled = atom = iterator.next();
        }
        LinkedHashMap<String, Atom> linkedHashMap = new LinkedHashMap<String, Atom>();
        String string = "JNK";
        Monomer monomer = new Monomer();
        monomer.key3 = string;
        monomer.key8 = string;
        monomer.name = string;
        int n = 0;
        for (Atom atom : ((Molecule)object7).atoms) {
            Atom atom2 = new Atom(null, atom);
            monomer.atoms.add(atom2);
            atom.coupled = atom2;
            while (linkedHashMap.get(atom2.key4) != null) {
                if (n > 999) {
                    throw new NullPointerException();
                }
                atom2.key4 = atom2.symbol + ++n;
            }
            linkedHashMap.put(atom2.key4, atom);
        }
        for (Atom atom : ((Molecule)object7).atoms) {
            for (Bond bond2 : atom) {
                Atom atom3 = bond2.another(atom);
                if (Atom.timeComparator.compare(atom, atom3) >= 0) continue;
                object2 = atom.coupled;
                object = atom3.coupled;
                bond = new Bond((Atom)object2, (Atom)object, bond2);
                ((ArrayList)object2).add(bond);
                ((ArrayList)object).add(bond);
            }
        }
        for (Atom atom : ((Molecule)object7).atoms) {
            GenericRestraint genericRestraint;
            if (atom.chir == null) continue;
            genericRestraint.atoms.get((int)0).chir = genericRestraint = atom.chir.duplicate();
        }
        ((Molecule)object7).includeHidden();
        if (!bl3) {
            for (Atom atom : ((Molecule)object7).atoms) {
                atom.resetChanged();
            }
        }
        Object object3 = ((Molecule)object7).atoms.iterator();
        while (object3.hasNext()) {
            Atom atom;
            atom.coupled = atom = object3.next();
        }
        monomer.restraints = new Restraints();
        object3 = (List)monomer.restraints.get(0);
        for (Atom atom : monomer.atoms) {
            for (Bond bond3 : atom) {
                object2 = bond3.another(atom);
                if (Atom.timeComparator.compare(atom, (Atom)object2) >= 0) continue;
                object3.add(new GenericRestraint(bond3));
            }
        }
        object3 = (List)monomer.restraints.get(3);
        for (Atom atom : monomer.atoms) {
            if (atom.chir == null) continue;
            object3.add(atom.chir);
        }
        monomer = new Libcheck().regularise(monomer, bl2, bl3);
        if (!monomer.key8.equals(string)) {
            throw new NullPointerException();
        }
        if (monomer.atoms.size() == 1 && ((Molecule)object7).atoms.size() == 1) {
            return object7;
        }
        Iterator<Atom> iterator2 = monomer.atoms.iterator();
        while (iterator2.hasNext()) {
            Atom atom;
            atom.coupled = atom = iterator2.next();
            Atom atom4 = (Atom)linkedHashMap.get(atom.key4);
            if (atom.symbol.equals("H")) continue;
            if (atom4 == null) {
                throw new NullPointerException();
            }
            atom.coupled = atom4;
            atom4.coupled = atom;
        }
        for (Atom atom : monomer.atoms) {
            Atom atom5;
            if (atom.coupled != atom) continue;
            if (!atom.symbol.equals("H")) {
                throw new NullPointerException();
            }
            Atom atom6 = atom5.coupled;
            atom5 = ((Bond)atom.get(0)).another(atom);
            if (atom6 == atom5) {
                throw new NullPointerException();
            }
            object2 = null;
            object = atom6.iterator();
            while (object.hasNext() && ((Atom)object2).coupled != (object2 = (bond = (Bond)object.next()).another(atom6))) {
                object2 = null;
            }
            if (object2 == null) {
                object2 = new Atom(atom6.residue, atom);
                ((Atom)object2).key4 = null;
                ((Molecule)object7).atoms.add((Atom)object2);
            }
            if (!((Atom)object2).symbol.equals("H")) {
                throw new NullPointerException();
            }
            atom.coupled = object2;
            ((Atom)object2).coupled = atom;
        }
        for (Atom atom : monomer.atoms) {
            if (atom.coupled != atom) continue;
            throw new NullPointerException();
        }
        Iterator<Atom> iterator3 = ((Molecule)object7).iterator();
        while (iterator3.hasNext()) {
            Atom atom = iterator3.next();
            if (atom.coupled != atom) continue;
            if (!atom.symbol.equals("H")) {
                throw new NullPointerException();
            }
            Atom atom7 = ((Bond)atom.get(0)).another(atom);
            if (atom7.coupled == atom7) {
                throw new NullPointerException();
            }
            iterator3.remove();
        }
        for (Atom atom : monomer.atoms) {
            if (atom.coupled != atom) continue;
            throw new NullPointerException();
        }
        for (Atom atom : ((Molecule)object7).atoms) {
            if (atom.coupled != atom) continue;
            throw new NullPointerException();
        }
        Iterator<Atom> iterator4 = ((Molecule)object7).atoms.iterator();
        while (iterator4.hasNext()) {
            Atom atom;
            atom.coupled = atom = iterator4.next();
        }
        for (Atom atom : ((Molecule)object7).atoms) {
            atom.clear();
        }
        Restraints restraints = new Restraints(monomer.restraints);
        for (GenericRestraint genericRestraint : (List)restraints.get(0)) {
            object2 = new Bond(genericRestraint);
            ((Bond)object2).atom1.add(object2);
            ((Bond)object2).atom2.add(object2);
        }
        for (GenericRestraint genericRestraint : (List)restraints.get(3)) {
            object2 = genericRestraint.atoms.get(0);
            if (((Atom)object2).chir != null && !((Atom)object2).chir.equals(genericRestraint)) {
                throw new NullPointerException();
            }
            ((Atom)object2).chir = genericRestraint;
        }
        ((Molecule)object7).restraints = null;
        for (Molecule molecule : ((Molecule)object7).residueView().values()) {
            molecule.restoreHydrogenKeys();
        }
        ((Molecule)object7).restraints = restraints;
        for (Atom atom : monomer.atoms) {
            object2 = atom.coupled;
            ((Atom)object2).symbol = atom.symbol;
            ((Atom)object2).energy = atom.energy;
            ((Atom)object2).charge = atom.charge;
        }
        if (Env.coordinates == 2 || bl3) {
            for (Atom atom : monomer.atoms) {
                atom.xyz = atom.coupled.xyz;
            }
        }
        if (Env.coordinates != 1) {
            new Refmac().refine(monomer);
        }
        for (Atom atom : monomer.atoms) {
            atom.coupled.xyz = atom.xyz;
        }
        Iterator<Atom> iterator5 = monomer.atoms.iterator();
        while (iterator5.hasNext()) {
            Atom atom;
            atom.coupled = atom = iterator5.next();
        }
        for (GenericRestraint genericRestraint : (List)((Molecule)object7).restraints.get(3)) {
            genericRestraint.setSign().checkType();
        }
        Collections.sort(((Molecule)object7).atoms, Atom.zComparator);
        ((Molecule)object7).updateSphere();
        if (Env.coordinates != 2) {
            ((Molecule)object7).restoreBaseline((double[])object8);
        }
        return object7;
    }

    class UndoableRemoveAtom
    extends Backup {
        Atom atom;

        UndoableRemoveAtom(Atom atom) {
            this.atom = atom;
            Molecule.this.atoms.remove(this.atom);
            this.atom.residue.transform.backward(this.atom.xyz);
            Molecule.this.updateSphere();
            if (Env.vbPrint) {
                System.out.println(":::: " + Molecule.this.key8 + " remove atom " + this.atom.key4);
            }
        }

        void undo() {
            Molecule.this.atoms.add(this.atom);
            this.atom.residue.transform.forward(this.atom.xyz);
            Molecule.this.updateSphere();
        }

        void redo() {
            Molecule.this.atoms.remove(this.atom);
            this.atom.residue.transform.backward(this.atom.xyz);
            Molecule.this.updateSphere();
        }
    }

    class UndoableAddAtom
    extends Backup {
        Atom atom;

        UndoableAddAtom(Atom atom) {
            this.atom = atom;
            Molecule.this.atoms.add(this.atom);
            Molecule.this.updateSphere();
            if (Env.vbPrint) {
                System.out.println(":::: " + Molecule.this.key8 + " add atom " + this.atom.key4);
            }
        }

        void undo() {
            Molecule.this.atoms.remove(this.atom);
            this.atom.residue.transform.backward(this.atom.xyz);
            Molecule.this.updateSphere();
        }

        void redo() {
            Molecule.this.atoms.add(this.atom);
            this.atom.residue.transform.forward(this.atom.xyz);
            Molecule.this.updateSphere();
        }
    }

    class UndoableClearRestraints
    extends Backup {
        Restraints valueOld;

        UndoableClearRestraints() {
            this.valueOld = Molecule.this.restraints;
            Molecule.this.restraints = null;
            if (Env.vbPrint) {
                System.out.println(":::: " + Molecule.this.key8 + " clear restraints");
            }
        }

        void undo() {
            Molecule.this.restraints = this.valueOld;
        }

        void redo() {
            Molecule.this.restraints = null;
        }
    }

    class UndoableEditKey8
    extends Backup {
        String valueOld;
        String valueNew;

        UndoableEditKey8(String string) {
            this.valueOld = Molecule.this.key8;
            this.valueNew = string;
            Molecule.this.key8 = string;
            if (Env.vbPrint) {
                System.out.println(":::: " + Molecule.this.key8 + " key8");
            }
        }

        void undo() {
            Molecule.this.key8 = this.valueOld;
        }

        void redo() {
            Molecule.this.key8 = this.valueNew;
        }
    }

    class UndoableEditName
    extends Backup {
        String valueOld;
        String valueNew;

        UndoableEditName(String string) {
            this.valueOld = Molecule.this.name;
            this.valueNew = string;
            Molecule.this.name = string;
            if (Env.vbPrint) {
                System.out.println(":::: " + Molecule.this.key8 + " name " + Molecule.this.name);
            }
        }

        void undo() {
            Molecule.this.name = this.valueOld;
        }

        void redo() {
            Molecule.this.name = this.valueNew;
        }
    }
}

