/*
 * Decompiled with CFR 0.152.
 */
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;

class Monomer {
    List<Atom> atoms = new ArrayList<Atom>();
    String key3;
    String key8;
    String name;
    String group;
    Restraints restraints;

    public String toString() {
        return this.atoms.toString();
    }

    boolean isStandard() {
        boolean bl = true;
        return StdLib.hasReady(this.key8) && this == StdLib.get(this.key8, bl);
    }

    void recentre() {
        int n;
        double[] dArray = new double[]{0.0, 0.0, 0.0};
        for (Atom atom : this.atoms) {
            for (n = 0; n < 3; ++n) {
                int n2 = n;
                dArray[n2] = dArray[n2] + atom.xyz[n];
            }
        }
        for (int i = 0; i < 3; ++i) {
            dArray[i] = dArray[i] / (double)this.atoms.size();
        }
        for (Atom atom : this.atoms) {
            for (n = 0; n < 3; ++n) {
                int n3 = n;
                atom.xyz[n3] = atom.xyz[n3] - dArray[n];
            }
        }
    }

    Monomer() {
    }

    Monomer(Molecule molecule) {
        Object object;
        this.key8 = molecule.key8;
        this.key3 = this.key8.substring(0, Math.min(3, this.key8.length()));
        this.name = molecule.name;
        this.group = null;
        Collections.sort(molecule.atoms, Atom.originComparator);
        for (Atom iterator : molecule.atoms) {
            Atom atom = new Atom(null, iterator);
            this.atoms.add(atom);
            iterator.coupled = atom;
        }
        if (molecule.restraints != null) {
            this.restraints = new Restraints(molecule.restraints);
        } else {
            Object object2;
            this.restraints = new Restraints();
            object = (List)this.restraints.get(0);
            for (Atom atom : molecule.atoms) {
                object2 = atom.iterator();
                while (object2.hasNext()) {
                    Bond bond = (Bond)object2.next();
                    Atom atom2 = bond.another(atom);
                    if (Atom.timeComparator.compare(atom, atom2) >= 0) continue;
                    object.add(new GenericRestraint(new Bond(atom.coupled, atom2.coupled, bond)));
                }
            }
            object = (List)this.restraints.get(3);
            for (Atom atom : molecule.atoms) {
                if (atom.chir == null) continue;
                ((GenericRestraint)object2).atoms.get((int)0).chir = object2 = atom.chir.duplicate();
                object.add(object2);
            }
        }
        object = molecule.atoms.iterator();
        while (object.hasNext()) {
            Atom atom;
            atom.coupled = atom = object.next();
        }
        Collections.sort(molecule.atoms, Atom.zComparator);
        object = new LinkedHashSet();
        for (Atom atom : this.atoms) {
            atom.resetKey((Set<String>)object);
        }
    }

    class UndoableEditKey8
    extends Backup {
        String valueOld;
        String valueNew;

        UndoableEditKey8(String string) {
            this.valueOld = Monomer.this.key8;
            this.valueNew = string;
            Monomer.this.key8 = string;
            if (Env.vbPrint) {
                System.out.println(":::: " + Monomer.this.key8 + " key8");
            }
        }

        void undo() {
            Monomer.this.key8 = this.valueOld;
        }

        void redo() {
            Monomer.this.key8 = this.valueNew;
        }
    }

    class UndoableEditKey3
    extends Backup {
        String valueOld;
        String valueNew;

        UndoableEditKey3(String string) {
            this.valueOld = Monomer.this.key3;
            this.valueNew = string;
            Monomer.this.key3 = string;
            if (Env.vbPrint) {
                System.out.println(":::: " + Monomer.this.key3 + " key3");
            }
        }

        void undo() {
            Monomer.this.key3 = this.valueOld;
        }

        void redo() {
            Monomer.this.key3 = this.valueNew;
        }
    }

    class UndoableEditName
    extends Backup {
        String valueOld;
        String valueNew;

        UndoableEditName(String string) {
            this.valueOld = Monomer.this.name;
            this.valueNew = string;
            Monomer.this.name = string;
            if (Env.vbPrint) {
                System.out.println(":::: " + Monomer.this.key8 + " name " + Monomer.this.name);
            }
        }

        void undo() {
            Monomer.this.name = this.valueOld;
        }

        void redo() {
            Monomer.this.name = this.valueNew;
        }
    }
}

