/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;

class NewLigandDialog
implements ActionListener {
    private JDialog dialog;
    private JLabel label1;
    private JLabel label2;
    private JTextField textField1;
    private JButton submitButton;
    private JButton cancelButton;
    private JComboBox atomTypeList;
    private String[] atomTypeArray = new String[]{"C", "N", "O", "H", "S", "F", "Cl", "Br", "I", "P", "n=3", "n=4", "n=5", "n=6", "benzene", "n=7"};
    private GLib targetLib;
    String ligandId;
    String atomType;

    NewLigandDialog(GLib gLib) {
        this.targetLib = gLib;
    }

    public void showDialog() {
        this.dialog = new JDialog((Frame)JLMain.mainFrame, true);
        this.dialog.setTitle("Create New Ligand");
        this.label1 = new JLabel("Ligand Id");
        this.textField1 = new JTextField(10);
        this.textField1.addActionListener(this);
        this.label2 = new JLabel("Atom Type");
        this.submitButton = new JButton("Submit");
        this.submitButton.addActionListener(this);
        this.cancelButton = new JButton("Cancel");
        this.cancelButton.addActionListener(this);
        JButton jButton = new JButton("Cancel");
        jButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                NewLigandDialog.this.dialog.setVisible(false);
                NewLigandDialog.this.dialog.dispose();
            }
        });
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BoxLayout(jPanel, 0));
        jPanel.add(new JLabel("Please enter a Ligand Id (1 - 8 characters) and initial Atom Type:"));
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout(new BoxLayout(jPanel2, 0));
        jPanel2.add(this.label1);
        jPanel2.add(Box.createRigidArea(new Dimension(20, 0)));
        this.setComponentSize(this.textField1, 150, 25);
        jPanel2.add(this.textField1);
        JPanel jPanel3 = new JPanel();
        jPanel3.setLayout(new BoxLayout(jPanel3, 2));
        jPanel3.add(this.label2);
        jPanel3.add(Box.createRigidArea(new Dimension(10, 0)));
        this.atomTypeList = new JComboBox<String>(this.atomTypeArray);
        this.atomTypeList.setSelectedIndex(0);
        this.setComponentSize(this.atomTypeList, 150, 30);
        jPanel3.add(this.atomTypeList);
        JPanel jPanel4 = new JPanel();
        jPanel4.setLayout(new BoxLayout(jPanel4, 2));
        jPanel4.add(this.submitButton);
        jPanel4.add(Box.createRigidArea(new Dimension(10, 0)));
        jPanel4.add(this.cancelButton);
        JPanel jPanel5 = new JPanel();
        jPanel5.setLayout(new BoxLayout(jPanel5, 3));
        jPanel5.add(Box.createRigidArea(new Dimension(0, 30)));
        jPanel5.add(jPanel);
        jPanel5.add(Box.createRigidArea(new Dimension(0, 20)));
        jPanel5.add(jPanel2);
        jPanel5.add(Box.createRigidArea(new Dimension(0, 5)));
        jPanel5.add(jPanel3);
        jPanel5.add(Box.createRigidArea(new Dimension(0, 20)));
        jPanel5.add(jPanel4);
        jPanel5.setOpaque(true);
        this.dialog.setContentPane(jPanel5);
        int n = 500;
        int n2 = 400;
        this.dialog.setSize(new Dimension(n, n2));
        this.dialog.setLocation(DialogWindows.screenWidth / 2 - n / 2, DialogWindows.locationTop2);
        this.dialog.setVisible(true);
        this.dialog.addWindowListener(new WindowAdapter(){

            public void windowOpened(WindowEvent windowEvent) {
                SwingUtilities.invokeLater(new Runnable(){

                    public void run() {
                        NewLigandDialog.this.textField1.requestFocusInWindow();
                    }
                });
            }
        });
    }

    public void setComponentSize(JComponent jComponent, int n, int n2) {
        Dimension dimension = new Dimension(n, n2);
        jComponent.setPreferredSize(dimension);
        jComponent.setMinimumSize(dimension);
        jComponent.setMaximumSize(dimension);
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getSource() == this.cancelButton) {
            this.dialog.setVisible(false);
            this.dialog.dispose();
        } else if (actionEvent.getSource() == this.textField1 || actionEvent.getSource() == this.submitButton) {
            this.ligandId = this.textField1.getText();
            this.atomType = (String)this.atomTypeList.getSelectedItem();
            if (this.ligandId.length() == 0 || this.ligandId.length() > 8) {
                DialogWindows.showWarningDialog("Ligand Id must be 1 - 8 characters - please try again");
            } else if (!this.ligandId.matches("[a-zA-Z0-9-_]+")) {
                DialogWindows.showWarningDialog("Ligand Id must consist of these characters: A-Z, a-z, 1-9, -, _ (no spaces allowed) - please try again");
            } else if (this.targetLib.contains(this.ligandId)) {
                DialogWindows.showWarningDialog("This Ligand Id already exists - please enter a new Ligand Id");
            } else {
                this.dialog.setVisible(false);
                this.dialog.dispose();
            }
        }
    }

    String getLigandId() {
        return this.ligandId;
    }

    String getAtomType() {
        if (this.atomType == null) {
            return null;
        }
        if (this.atomType.equals("benzene")) {
            return "n6B";
        }
        if (this.atomType.startsWith("n=")) {
            return "n" + this.atomType.charAt(2);
        }
        return this.atomType;
    }
}

