/*
 * Decompiled with CFR 0.152.
 */
import java.util.LinkedHashSet;

class Ring {
    double[] xo;
    double[] yo;
    String atomType;
    Bond templateBond;

    Ring(int n, String string, Bond bond) {
        this.atomType = string;
        this.templateBond = bond;
        this.xo = new double[n];
        this.yo = new double[n];
        double d = this.templateBond.value.mean;
        double d2 = Math.PI / (double)n;
        double d3 = 2.0 * d2;
        this.yo[0] = 0.0;
        this.xo[0] = 0.0;
        for (int i = 1; i < n; ++i) {
            this.xo[i] = this.xo[i - 1] + Math.sin(d2) * d;
            this.yo[i] = this.yo[i - 1] + Math.cos(d2) * d;
            d2 += d3;
        }
    }

    void undoableAddTo(UndoRedo undoRedo, Molecule molecule, Atom atom, double[] dArray) {
        Object object;
        double d;
        double d2;
        double d3;
        int n;
        int n2 = this.xo.length;
        Atom[] atomArray = new Atom[n2];
        double[] dArray2 = new double[3];
        double[] dArray3 = new double[3];
        Residue residue = null;
        LinkedHashSet<String> linkedHashSet = null;
        if (atom == null) {
            linkedHashSet = new LinkedHashSet(this.xo.length);
            residue = new Residue();
            residue.key8 = molecule.key8;
            residue.name = molecule.name;
            for (n = 0; n < 3; ++n) {
                dArray3[n] = 0.0;
            }
        } else {
            linkedHashSet = new LinkedHashSet<String>(molecule.atomView(atom).keySet());
            residue = atom.residue;
            for (n = 0; n < 3; ++n) {
                dArray3[n] = atom.xyz[n];
            }
        }
        if ((d3 = (d2 = dArray[0] - dArray3[0]) * d2 + (d = dArray[1] - dArray3[1]) * d) < 1.0E-5) {
            d2 = 1.0;
            d = 0.0;
        } else {
            d3 = Math.sqrt(d3);
            d2 /= d3;
            d /= d3;
        }
        for (int i = 0; i < n2; ++i) {
            dArray2[0] = d2 * this.xo[i] - d * this.yo[i] + dArray[0];
            dArray2[1] = d * this.xo[i] + d2 * this.yo[i] + dArray[1];
            dArray2[2] = dArray3[2];
            object = new Atom(residue, this.atomType, this.atomType, dArray2[0], dArray2[1], dArray2[2]);
            ((Atom)object).generateKey(linkedHashSet);
            atomArray[i] = object;
            Molecule molecule2 = molecule;
            molecule2.getClass();
            undoRedo.backup(molecule2.new Molecule.UndoableAddAtom((Atom)object));
        }
        if (atom != null) {
            Atom atom2 = atomArray[0];
            object = new Bond(atom, atom2, "single");
            Atom atom3 = atom;
            atom3.getClass();
            undoRedo.backup(atom3.new Atom.UndoableAddBond((Bond)object));
            Atom atom4 = atom2;
            atom4.getClass();
            undoRedo.backup(atom4.new Atom.UndoableAddBond((Bond)object));
        }
        Atom atom5 = atomArray[n2 - 1];
        for (int i = 0; i < n2; ++i) {
            Atom atom6 = atomArray[i];
            Bond bond = new Bond(atom5, atom6, this.templateBond);
            Atom atom7 = atom5;
            atom7.getClass();
            undoRedo.backup(atom7.new Atom.UndoableAddBond(bond));
            Atom atom8 = atom6;
            atom8.getClass();
            undoRedo.backup(atom8.new Atom.UndoableAddBond(bond));
            atom5 = atom6;
        }
    }
}

