/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.List;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class SearchLibraryDialog
implements ActionListener,
MouseListener {
    private JDialog dialog = new JDialog((Frame)JLMain.mainFrame, true);
    private JTextField textField1;
    private JTextField textField2;
    private JButton go1;
    private JButton go2;
    private JTextArea textArea;
    private JScrollPane scrollPane;
    private static final String bsn = JLMain.bsn;
    String ligandId = "";

    SearchLibraryDialog() {
        this.dialog.setTitle("Search Standard Library for Ligand");
        JPanel jPanel = new JPanel();
        JTextArea jTextArea = new JTextArea(6, 40);
        jTextArea.append("Enter a search string (e.g. P, PL, PLP), click on Search, then double-click on the Ligand Id to load the ligand." + bsn + "A blank search returns all ligands in the library. " + bsn + "Note: it may take a few seconds to load the ligand after double-clicking." + bsn + "Also note that the search is case-sensitive and that most monomers are upper-case, e.g. LYS");
        jTextArea.setLineWrap(true);
        jTextArea.setWrapStyleWord(true);
        jTextArea.setBackground(jPanel.getBackground());
        jTextArea.setEditable(false);
        MouseListener[] mouseListenerArray = jTextArea.getMouseListeners();
        for (int i = 0; i < mouseListenerArray.length; ++i) {
            jTextArea.removeMouseListener(mouseListenerArray[i]);
        }
        MouseMotionListener[] mouseMotionListenerArray = jTextArea.getMouseMotionListeners();
        for (int i = 0; i < mouseMotionListenerArray.length; ++i) {
            jTextArea.removeMouseMotionListener(mouseMotionListenerArray[i]);
        }
        jPanel.add(jTextArea);
        JPanel jPanel2 = new JPanel();
        JPanel jPanel3 = new JPanel();
        JPanel jPanel4 = new JPanel();
        JPanel jPanel5 = new JPanel();
        Font font = new Font("", 0, 12);
        JLabel jLabel = new JLabel("Ligand ID");
        jPanel2.add(jLabel);
        jLabel.setFont(font);
        jLabel = new JLabel("Keyword ");
        jPanel3.add(jLabel);
        jLabel.setFont(font);
        this.textField1 = new JTextField(10);
        jPanel2.add(this.textField1);
        this.textField1.addActionListener(this);
        this.textField2 = new JTextField(10);
        jPanel3.add(this.textField2);
        this.textField2.addActionListener(this);
        this.go1 = new JButton("Search");
        jPanel2.add(this.go1);
        this.go1.addActionListener(this);
        this.go2 = new JButton("Search");
        jPanel3.add(this.go2);
        this.go2.addActionListener(this);
        this.textArea = new JTextArea(20, 40);
        this.textArea.setEditable(false);
        this.scrollPane = new JScrollPane(this.textArea);
        jPanel4.add(this.scrollPane);
        this.textArea.addMouseListener(this);
        JButton jButton = new JButton("Cancel");
        jButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                SearchLibraryDialog.this.dialog.setVisible(false);
                SearchLibraryDialog.this.dialog.dispose();
            }
        });
        jPanel5.add(jButton);
        JPanel jPanel6 = new JPanel();
        jPanel6.setLayout(new BoxLayout(jPanel6, 3));
        jPanel6.add(Box.createRigidArea(new Dimension(0, 15)));
        jPanel.setAlignmentX(0.5f);
        jPanel2.setAlignmentX(0.5f);
        jPanel3.setAlignmentX(0.5f);
        jPanel4.setAlignmentX(0.5f);
        jPanel5.setAlignmentX(0.5f);
        jPanel6.add(jPanel);
        jPanel6.add(Box.createRigidArea(new Dimension(0, 5)));
        jPanel6.add(jPanel2);
        jPanel6.add(jPanel3);
        jPanel6.add(jPanel4);
        jPanel6.add(jPanel5);
        jPanel6.setOpaque(true);
        this.dialog.setContentPane(jPanel6);
        int n = 520;
        int n2 = 600;
        this.dialog.setSize(new Dimension(n, n2));
        this.dialog.setLocation(DialogWindows.screenWidth / 2 - n / 2, DialogWindows.locationTop);
    }

    public void showDialog() {
        this.dialog.setVisible(true);
        this.dialog.addWindowListener(new WindowAdapter(){

            public void windowOpened(WindowEvent windowEvent) {
                SwingUtilities.invokeLater(new Runnable(){

                    public void run() {
                        SearchLibraryDialog.this.textField1.requestFocusInWindow();
                    }
                });
            }
        });
    }

    SearchLibraryDialog(List<String> list) {
        this();
        this.textArea.setText("");
        for (String string : list) {
            MonomerHeader monomerHeader = (MonomerHeader)StdLib.compHeaderMap.get(string);
            if (monomerHeader == null || !monomerHeader.key8.equals(string)) continue;
            this.textArea.append(" " + monomerHeader.key8 + "\t" + monomerHeader.name + bsn);
        }
        this.textArea.setCaretPosition(0);
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getSource() == this.textField1 || actionEvent.getSource() == this.go1) {
            this.textArea.setText("");
            String string = this.textField1.getText();
            for (MonomerHeader monomerHeader : StdLib.compHeaderMap.values()) {
                if (!monomerHeader.key8.startsWith(string)) continue;
                this.textArea.append(" " + monomerHeader.key8 + "\t" + monomerHeader.name + bsn);
            }
            this.textArea.setCaretPosition(0);
        } else if (actionEvent.getSource() == this.textField2 || actionEvent.getSource() == this.go2) {
            this.textArea.setText("");
            String string = this.textField2.getText();
            for (MonomerHeader monomerHeader : StdLib.compHeaderMap.values()) {
                if (!monomerHeader.name.contains(string)) continue;
                this.textArea.append(" " + monomerHeader.key8 + "\t" + monomerHeader.name + bsn);
            }
            this.textArea.setCaretPosition(0);
        }
    }

    @Override
    public void mouseClicked(MouseEvent mouseEvent) {
        int n;
        if (this.textArea.getSelectedText() == null) {
            return;
        }
        String string = this.textArea.getText();
        int n2 = string.lastIndexOf(bsn, n = this.textArea.getSelectionStart() - 1) + 1 + bsn.length();
        if (n2 == 2) {
            n2 = 1;
        }
        int n3 = string.indexOf("\t", n2);
        this.ligandId = string.substring(n2, n3);
        this.dialog.setVisible(false);
        this.dialog.dispose();
    }

    String getLigandId() {
        return this.ligandId;
    }

    @Override
    public void mouseEntered(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseExited(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseReleased(MouseEvent mouseEvent) {
    }

    @Override
    public void mousePressed(MouseEvent mouseEvent) {
    }
}

