/*
 * Decompiled with CFR 0.152.
 */
import java.io.File;
import java.util.LinkedHashMap;
import java.util.Map;

abstract class StdLib {
    static final Map<String, Monomer> compMap = new LinkedHashMap<String, Monomer>();
    static MonLib compHeaderMap;
    static MonLib shortHeaderMap;
    private static String freeKey3;

    StdLib() {
    }

    static void init() {
        try {
            compHeaderMap = new MonLib();
            shortHeaderMap = new MonLib(compHeaderMap);
        }
        catch (Exception exception) {
            if (Env.vbPrint) {
                exception.printStackTrace(System.err);
            }
            throw new NullPointerException("cannot read monomer dictionary");
        }
        freeKey3 = StdLib.setFreeKey3();
    }

    private static String setFreeKey3() {
        String string = "ABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789";
        int n = string.length();
        for (int i = 0; i < n; ++i) {
            String string2 = string.substring(i, i + 1);
            for (int j = 0; j < n; ++j) {
                String string3 = string2 + string.substring(j, j + 1);
                for (int k = 0; k < n; ++k) {
                    String string4 = string3 + string.substring(k, k + 1);
                    if (compHeaderMap.get(string4) != null) continue;
                    return string4;
                }
            }
        }
        throw new NullPointerException("no free names in the library");
    }

    static String getWrkKey() {
        return freeKey3;
    }

    static Version getVersion() {
        return compHeaderMap.getVersion();
    }

    static boolean hasReady(String string) {
        return compMap.get(string) != null;
    }

    static void clear() {
        compMap.clear();
        shortHeaderMap.clear();
    }

    static Monomer get(String string, boolean bl) {
        Monomer monomer = compMap.get(string);
        if (monomer != null) {
            return monomer;
        }
        MonomerHeader monomerHeader = (MonomerHeader)compHeaderMap.get(string);
        if (monomerHeader == null) {
            return null;
        }
        if ((monomerHeader = shortHeaderMap.put(string, monomerHeader)) != null) {
            throw new NullPointerException();
        }
        File file = new Libcheck().getEntry(string, bl);
        monomer = new CifLib(file).getMonomer();
        if (monomer == null || !monomer.key8.equals(string)) {
            throw new NullPointerException();
        }
        Molecule molecule = new Molecule(monomer);
        molecule.restraints = null;
        boolean bl2 = false;
        molecule = molecule.regularise(true, bl, bl2);
        monomer = new Monomer(molecule);
        compMap.put(string, monomer);
        return monomer;
    }

    static CharArray toBuffer() {
        CharArray charArray = new CharArray();
        compHeaderMap.toBuffer(charArray);
        return charArray;
    }

    static File getFile(String string) {
        return compHeaderMap.getFile(string);
    }
}

