/*
 * Decompiled with CFR 0.152.
 */
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;

class T {
    GLib gLib = new GLib();
    String atomType = "Po";
    String bondType = "single";
    Finder finder1;
    Finder finder2;

    public static void main(String[] stringArray) {
        Env.init(stringArray);
        new T();
    }

    T() {
        Object object;
        File file = new File("test");
        if (!file.isFile()) {
            throw new NullPointerException();
        }
        Scratch.init();
        StdLib.init();
        Versions.init();
        try {
            new Rings();
        }
        catch (ExceptionInInitializerError exceptionInInitializerError) {
            object = exceptionInInitializerError.getCause();
            ((Throwable)object).printStackTrace(System.err);
            System.err.println("AAAAA " + ((Throwable)object).getMessage());
            System.err.println("BBBB ");
        }
        catch (Throwable throwable) {
            System.err.println("CCCCC " + throwable.getMessage());
        }
        try {
            BufferedReader bufferedReader = new BufferedReader(new FileReader(file));
            object = bufferedReader.readLine();
            while (object != null) {
                this.test((String)object);
                object = bufferedReader.readLine();
            }
            System.out.println();
        }
        catch (FileNotFoundException fileNotFoundException) {
            throw new NullPointerException();
        }
        catch (IOException iOException) {
            throw new NullPointerException();
        }
        if (!Env.vbScratch) {
            Scratch.clear();
        }
    }

    void test(String string) {
        String string2 = string.trim();
        if (string2.length() == 0) {
            System.out.println();
            return;
        }
        if (string2.startsWith("#")) {
            System.out.println(string2);
            return;
        }
        System.out.println();
        System.out.println(">  " + string2);
        String[] stringArray = string2.split("\\s+");
        if (stringArray[0].equals("details")) {
            this.details();
        } else if (stringArray[0].equals("set")) {
            this.set(stringArray);
        } else if (stringArray[0].equals("edit")) {
            this.edit(stringArray);
        } else if (stringArray[0].equals("remove")) {
            this.remove(stringArray[1]);
        } else if (stringArray[0].equals("find1")) {
            this.find1(stringArray);
        } else if (stringArray[0].equals("find2")) {
            this.find2(stringArray);
        } else if (stringArray[0].equals("read")) {
            this.read(stringArray[1]);
        } else if (stringArray[0].equals("write")) {
            this.write(stringArray[1]);
        } else if (stringArray[0].equals("summary")) {
            this.summary();
        } else if (stringArray[0].equals("add")) {
            this.add(stringArray);
        } else if (stringArray[0].equals("clear")) {
            this.clear();
        } else if (stringArray[0].equals("regularise")) {
            this.regularise(stringArray[1]);
        } else if (stringArray[0].equals("convert")) {
            this.convert(stringArray[1]);
        } else {
            throw new NullPointerException();
        }
    }

    void set(String[] stringArray) {
        String string = stringArray[1];
        if (stringArray.length < 3) {
            throw new NullPointerException();
        }
        if (string.equals("bond")) {
            this.bondType = stringArray[2];
        } else if (string.equals("atom")) {
            this.atomType = stringArray[2];
        }
    }

    void read(String string) {
        CifLib cifLib = new CifLib(new File(string));
        this.gLib = new GLib();
        this.gLib.undoableAddMols(cifLib.polymerView());
    }

    void write(String string) {
        CifLib cifLib = new CifLib();
        for (Molecule molecule : this.gLib) {
            Residue residue = molecule.getResidue();
            if (residue == null) {
                cifLib.add(molecule);
                continue;
            }
            cifLib.add(residue.mono);
        }
        cifLib.toBuffer().writeTo(new File(string));
    }

    void summary() {
        System.out.println(this.gLib.summary());
    }

    void details() {
        this.finder1.details();
    }

    void clear() {
        StdLib.clear();
        this.gLib.undoableClear();
    }

    void find1(String[] stringArray) {
        this.finder1 = new Finder();
        this.finder1.find(stringArray);
    }

    void find2(String[] stringArray) {
        this.finder2 = new Finder();
        this.finder2.find(stringArray);
    }

    void remove(String string) {
        System.out.println(this.finder1);
        if (this.finder1 == null) {
            throw new NullPointerException();
        }
        if (string.equals("bond") && this.finder1.bond != null) {
            this.gLib.undoableRemoveBond(this.finder1.link, this.finder1.bond);
        } else if (string.equals("atom") && this.finder1.atom != null) {
            this.gLib.undoableRemoveAtom(this.finder1.link, this.finder1.atom);
        } else if (string.equals("link") && this.finder1.link != null) {
            this.gLib.undoableRemoveMolecule(this.finder1.link);
        } else {
            throw new NullPointerException();
        }
    }

    void edit(String[] stringArray) {
        System.out.println(this.finder1);
        String string = stringArray[1];
        String string2 = stringArray[2];
        String string3 = stringArray[3];
        if (this.finder1 == null) {
            throw new NullPointerException();
        }
        if (string.equals("bond") && this.finder1.bond != null) {
            if (string2.equals("type")) {
                this.gLib.undoableChangeBond(this.finder1.link, this.finder1.bond, string3);
            }
        } else if (string.equals("atom") && this.finder1.atom != null) {
            String string4 = this.finder1.atom.key4;
            String string5 = this.finder1.atom.symbol;
            float f = this.finder1.atom.charge.floatValue();
            String string6 = "/ void /";
            if (string2.equals("key4")) {
                string4 = string3;
            }
            if (string2.equals("symbol")) {
                string5 = string3;
            }
            if (string2.equals("charge")) {
                f = Float.parseFloat(string3);
            }
            if (string2.equals("chir")) {
                string6 = GenericRestraint.getChirType(string3);
            }
            this.gLib.undoableChangeAtom(string6, this.finder1.link, this.finder1.atom, string4, string5, f);
        } else if (string.equals("link") && this.finder1.link != null) {
            String string7 = this.finder1.link.key8;
            String string8 = this.finder1.link.name;
            if (string2.equals("key8")) {
                string7 = string3;
            }
            if (string2.equals("name")) {
                string8 = string3;
            }
            this.gLib.undoableRenameMolecule(this.finder1.link, string7, string8);
        } else {
            throw new NullPointerException();
        }
    }

    void add(String[] stringArray) {
        String string = stringArray[1];
        if (string.equals("bond")) {
            if (this.finder1 == null || this.finder1.atom == null) {
                throw new NullPointerException();
            }
            if (this.finder2 == null || this.finder2.atom == null) {
                throw new NullPointerException();
            }
            System.out.println(this.finder1);
            System.out.println(this.finder2);
            if (this.finder1.link == this.finder2.link) {
                this.gLib.undoableAddBond(this.finder1.link, this.finder1.atom, this.finder2.atom, this.bondType);
            } else {
                String string2 = this.finder1.link.getResidue().key8 + "-" + this.finder2.link.getResidue().key8;
                this.gLib.undoableAddBond(string2, this.finder1.link, this.finder1.atom, this.finder2.link, this.finder2.atom, this.bondType);
            }
            this.finder2 = null;
            this.finder1 = new Finder();
        } else if (string.equals("atom")) {
            if (this.finder1 == null || this.finder1.atom == null) {
                throw new NullPointerException();
            }
            System.out.println(this.finder1);
            this.gLib.undoableAddAtom(this.finder1.link, this.finder1.atom, this.atomType, new double[]{0.0, 0.0});
        } else if (string.equals("link")) {
            if (stringArray.length < 3) {
                throw new NullPointerException();
            }
            String string3 = stringArray[2];
            System.out.println(string3);
            boolean bl = false;
            Monomer monomer = StdLib.get(string3, bl);
            if (monomer == null) {
                throw new NullPointerException();
            }
            this.gLib.undoableAddMolecule(string3, monomer);
        } else if (string.equals("new")) {
            if (stringArray.length < 3) {
                throw new NullPointerException();
            }
            System.out.println(stringArray[2]);
            this.gLib.undoableAddMolecule(stringArray[2], this.atomType);
        } else {
            throw new NullPointerException();
        }
    }

    void regularise(String string) {
        boolean bl = false;
        this.gLib.undoableRegularise(this.gLib.get(string), bl);
    }

    void convert(String string) {
        this.gLib.undoableConvertMolecule(this.gLib.get(string));
    }

    class Finder {
        Molecule link;
        Atom atom;
        Bond bond;

        Finder() {
        }

        public String toString() {
            if (this.atom != null && this.bond != null) {
                throw new NullPointerException();
            }
            String string = "   Focused: ";
            if (this.link == null) {
                if (this.bond != null || this.atom != null) {
                    throw new NullPointerException();
                }
                return string + "nothing";
            }
            string = string + this.link.key8;
            if (this.atom != null) {
                string = string + " " + this.atom;
            }
            if (this.bond != null) {
                string = string + " " + this.bond;
            }
            return string;
        }

        void find(String[] stringArray) {
            int n;
            this.link = null;
            this.atom = null;
            this.bond = null;
            if (stringArray.length == 1) {
                throw new NullPointerException();
            }
            int n2 = 1;
            String string = stringArray[n2];
            Object object = T.this.gLib.iterator();
            while (object.hasNext()) {
                Molecule molecule;
                this.link = molecule = (Molecule)object.next();
                if (this.link.key8.equals(string)) break;
                this.link = null;
            }
            if (this.link == null) {
                return;
            }
            if (++n2 == stringArray.length) {
                return;
            }
            object = stringArray[n2];
            if (n2 == stringArray.length) {
                throw new NullPointerException();
            }
            string = stringArray[++n2];
            int n3 = this.link.atoms.size();
            for (n = 0; n < n3; ++n) {
                this.atom = this.link.atoms.get(n);
                if (this.atom.key4.equals(string) && this.atom.residue.key8.equals(object)) break;
                this.atom = null;
            }
            if (this.atom == null) {
                return;
            }
            if (++n2 == stringArray.length) {
                return;
            }
            object = stringArray[n2];
            if (n2 == stringArray.length) {
                throw new NullPointerException();
            }
            string = stringArray[++n2];
            n3 = this.atom.size();
            for (n = 0; n < n3; ++n) {
                this.bond = (Bond)this.atom.get(n);
                Atom atom = this.bond.another(this.atom);
                if (atom.key4.equals(string) && atom.residue.key8.equals(object)) break;
                this.bond = null;
            }
            if (this.bond == null) {
                return;
            }
            this.atom = null;
        }

        void details() {
            if (this.link == null) {
                System.out.println("   Focused: nothing");
                return;
            }
            System.out.println("   Focused: " + this.link.key8);
            System.out.println("   Details:");
            for (Residue residue : this.link.residueList()) {
                System.out.println(residue.mono);
                System.out.println("---");
            }
        }
    }
}

