/*
 * Decompiled with CFR 0.152.
 */
class Transform {
    protected double[][] rot = new double[][]{{1.0, 0.0, 0.0}, {0.0, 1.0, 0.0}, {0.0, 0.0, 1.0}};
    protected double[] tra = new double[]{0.0, 0.0, 0.0};
    private double[] rw = new double[3];

    Transform() {
    }

    void forward(double[] dArray) {
        int n;
        for (n = 0; n < 3; ++n) {
            this.rw[n] = dArray[n];
        }
        for (n = 0; n < 3; ++n) {
            dArray[n] = this.tra[n];
        }
        for (n = 0; n < 3; ++n) {
            for (int i = 0; i < 3; ++i) {
                int n2 = n;
                dArray[n2] = dArray[n2] + this.rot[n][i] * this.rw[i];
            }
        }
    }

    void backward(double[] dArray) {
        int n;
        for (n = 0; n < 3; ++n) {
            this.rw[n] = dArray[n] - this.tra[n];
        }
        for (n = 0; n < 3; ++n) {
            dArray[n] = 0.0;
        }
        for (n = 0; n < 3; ++n) {
            for (int i = 0; i < 3; ++i) {
                int n2 = n;
                dArray[n2] = dArray[n2] + this.rot[i][n] * this.rw[i];
            }
        }
    }

    void translate(double[] dArray) {
        for (int i = 0; i < 2; ++i) {
            int n = i;
            this.tra[n] = this.tra[n] + dArray[i];
        }
    }

    void translate(double d) {
        this.tra[2] = this.tra[2] + d;
    }

    void rotate(Rotation rotation) {
        int n;
        int n2;
        for (n2 = 0; n2 < 3; ++n2) {
            this.rw[n2] = this.tra[n2];
        }
        for (n2 = 0; n2 < 3; ++n2) {
            this.tra[n2] = rotation.tra[n2];
        }
        for (n2 = 0; n2 < 3; ++n2) {
            for (n = 0; n < 3; ++n) {
                int n3 = n2;
                this.tra[n3] = this.tra[n3] + rotation.rot[n2][n] * this.rw[n];
            }
        }
        for (n2 = 0; n2 < 3; ++n2) {
            for (n = 0; n < 3; ++n) {
                this.rw[n] = this.rot[n][n2];
            }
            for (n = 0; n < 3; ++n) {
                this.rot[n][n2] = 0.0;
            }
            for (n = 0; n < 3; ++n) {
                for (int i = 0; i < 3; ++i) {
                    double[] dArray = this.rot[n];
                    int n4 = n2;
                    dArray[n4] = dArray[n4] + rotation.rot[n][i] * this.rw[i];
                }
            }
        }
    }
}

