/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Color;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.util.List;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.table.AbstractTableModel;

class ViewTable
extends JPanel {
    public ViewTable() {
        super(new GridLayout(1, 0));
    }

    public void showTable(Molecule molecule, String string) {
        JFrame jFrame = new JFrame(molecule.key8 + ": " + string);
        this.setOpaque(true);
        jFrame.setContentPane(this);
        jFrame.pack();
        int n = 800;
        int n2 = 600;
        jFrame.setSize(n, n2);
        jFrame.setLocation(DialogWindows.screenWidth / 2 - n / 2, DialogWindows.locationTop);
        jFrame.setVisible(true);
        MyTableModel myTableModel = new MyTableModel(molecule);
        myTableModel.showTable(string);
        JTable jTable = new JTable(myTableModel);
        jTable.setForeground(Color.BLACK);
        jTable.setGridColor(Color.LIGHT_GRAY);
        jTable.setPreferredScrollableViewportSize(new Dimension(1000, 700));
        JScrollPane jScrollPane = new JScrollPane(jTable);
        this.add(jScrollPane);
    }

    class MyTableModel
    extends AbstractTableModel {
        private Molecule molecule = null;
        private String[] columnNames = null;
        private Object[][] data = null;

        public MyTableModel(Molecule molecule) {
            this.molecule = molecule;
        }

        public void showTable(String string) {
            block9: {
                block13: {
                    block12: {
                        block11: {
                            block10: {
                                block8: {
                                    if (!string.equals("ATOMS")) break block8;
                                    this.columnNames = new String[7];
                                    this.columnNames[0] = "Atom Id";
                                    this.columnNames[1] = "Atom Type Symbol";
                                    this.columnNames[2] = "Atom Type Energy";
                                    this.columnNames[3] = "Atom Partial Charge";
                                    this.columnNames[4] = "x";
                                    this.columnNames[5] = "y";
                                    this.columnNames[6] = "z";
                                    this.data = new Object[this.molecule.atoms.size()][7];
                                    int n = this.molecule.atoms.size();
                                    for (int i = 0; i < n; ++i) {
                                        Atom atom = this.molecule.atoms.get(i);
                                        this.data[i][0] = atom.key4;
                                        this.data[i][1] = atom.symbol;
                                        this.data[i][2] = atom.energy;
                                        this.data[i][3] = atom.charge;
                                        this.data[i][4] = String.format("%8.3f", atom.xyz[0]);
                                        this.data[i][5] = String.format("%8.3f", atom.xyz[1]);
                                        this.data[i][6] = String.format("%8.3f", atom.xyz[2]);
                                    }
                                    break block9;
                                }
                                if (!string.equals("BONDS")) break block10;
                                this.columnNames = new String[5];
                                this.columnNames[0] = "Atom Id1";
                                this.columnNames[1] = "Atom Id2";
                                this.columnNames[2] = "Bond Type";
                                this.columnNames[3] = "Bond Dist";
                                this.columnNames[4] = "Bond Dist Esd";
                                List list = (List)this.molecule.restraints.get(0);
                                this.data = new Object[list.size()][5];
                                int n = list.size();
                                for (int i = 0; i < n; ++i) {
                                    GenericRestraint genericRestraint = (GenericRestraint)list.get(i);
                                    this.data[i][0] = genericRestraint.atoms.get((int)0).key4;
                                    this.data[i][1] = genericRestraint.atoms.get((int)1).key4;
                                    this.data[i][2] = genericRestraint.type;
                                    this.data[i][3] = Float.valueOf(genericRestraint.value.mean);
                                    this.data[i][4] = Float.valueOf(genericRestraint.value.sd);
                                }
                                break block9;
                            }
                            if (!string.equals("ANGLES")) break block11;
                            this.columnNames = new String[5];
                            this.columnNames[0] = "Atom Id1";
                            this.columnNames[1] = "Atom Id2";
                            this.columnNames[2] = "Atom Id3";
                            this.columnNames[3] = "Bond Angle";
                            this.columnNames[4] = "Bond Angle Esd";
                            List list = (List)this.molecule.restraints.get(1);
                            this.data = new Object[list.size()][5];
                            int n = list.size();
                            for (int i = 0; i < n; ++i) {
                                GenericRestraint genericRestraint = (GenericRestraint)list.get(i);
                                this.data[i][0] = genericRestraint.atoms.get((int)0).key4;
                                this.data[i][1] = genericRestraint.atoms.get((int)1).key4;
                                this.data[i][2] = genericRestraint.atoms.get((int)2).key4;
                                this.data[i][3] = Float.valueOf(genericRestraint.value.mean);
                                this.data[i][4] = Float.valueOf(genericRestraint.value.sd);
                            }
                            break block9;
                        }
                        if (!string.equals("TORSIONS")) break block12;
                        this.columnNames = new String[7];
                        this.columnNames[0] = "Id";
                        this.columnNames[1] = "Atom Id1";
                        this.columnNames[2] = "Atom Id2";
                        this.columnNames[3] = "Atom Id3";
                        this.columnNames[4] = "Atom Id4";
                        this.columnNames[5] = "Torsion Angle";
                        this.columnNames[6] = "Torsion Angle Esd";
                        List list = (List)this.molecule.restraints.get(2);
                        this.data = new Object[list.size()][7];
                        int n = list.size();
                        for (int i = 0; i < n; ++i) {
                            GenericRestraint genericRestraint = (GenericRestraint)list.get(i);
                            this.data[i][0] = genericRestraint.key;
                            this.data[i][1] = genericRestraint.atoms.get((int)0).key4;
                            this.data[i][2] = genericRestraint.atoms.get((int)1).key4;
                            this.data[i][3] = genericRestraint.atoms.get((int)2).key4;
                            this.data[i][4] = genericRestraint.atoms.get((int)3).key4;
                            this.data[i][5] = Float.valueOf(genericRestraint.value.mean);
                            this.data[i][6] = Float.valueOf(genericRestraint.value.sd);
                        }
                        break block9;
                    }
                    if (!string.equals("CHIRALITIES")) break block13;
                    this.columnNames = new String[11];
                    this.columnNames[0] = "Id";
                    this.columnNames[1] = "Id Centre";
                    this.columnNames[2] = "Atom Id1";
                    this.columnNames[3] = "Atom Id2";
                    this.columnNames[4] = "Atom Id3";
                    this.columnNames[5] = "Volume Sign";
                    this.columnNames[6] = "Atom Id4";
                    this.columnNames[7] = "Atom Id5";
                    this.columnNames[8] = "Atom Id6";
                    this.columnNames[9] = "Atom Id7";
                    this.columnNames[10] = "Atom Id8";
                    List list = (List)this.molecule.restraints.get(3);
                    this.data = new Object[list.size()][11];
                    int n = list.size();
                    for (int i = 0; i < n; ++i) {
                        GenericRestraint genericRestraint = (GenericRestraint)list.get(i);
                        this.data[i][0] = genericRestraint.key;
                        this.data[i][1] = genericRestraint.atoms.get((int)0).key4;
                        this.data[i][2] = genericRestraint.atoms.get((int)1).key4;
                        this.data[i][3] = genericRestraint.atoms.get((int)2).key4;
                        this.data[i][4] = genericRestraint.atoms.get((int)3).key4;
                        this.data[i][5] = genericRestraint.type;
                        this.data[i][6] = genericRestraint.atoms.get((int)4).key4;
                        this.data[i][7] = genericRestraint.atoms.get((int)5).key4;
                        this.data[i][8] = genericRestraint.atoms.get((int)6).key4;
                        this.data[i][9] = genericRestraint.atoms.get((int)7).key4;
                        this.data[i][10] = genericRestraint.atoms.get((int)8).key4;
                    }
                    break block9;
                }
                if (!string.equals("PLANES")) break block9;
                this.columnNames = new String[3];
                this.columnNames[0] = "Plane Id";
                this.columnNames[1] = "Atom Id";
                this.columnNames[2] = "Dist Esd";
                List list = (List)this.molecule.restraints.get(4);
                int n = 0;
                for (GenericRestraint genericRestraint : list) {
                    n += genericRestraint.atoms.size();
                }
                this.data = new Object[n][3];
                n = 0;
                for (GenericRestraint genericRestraint : list) {
                    for (Atom atom : genericRestraint.atoms) {
                        this.data[n][0] = genericRestraint.key;
                        this.data[n][1] = atom.key4;
                        this.data[n][2] = Float.valueOf(genericRestraint.sigma.sd);
                        ++n;
                    }
                }
            }
        }

        public int getColumnCount() {
            return this.columnNames.length;
        }

        public int getRowCount() {
            return this.data.length;
        }

        public String getColumnName(int n) {
            return this.columnNames[n];
        }

        public Object getValueAt(int n, int n2) {
            return this.data[n][n2];
        }

        public boolean isCellEditable(int n, int n2) {
            return false;
        }
    }
}

