/*
 * Decompiled with CFR 0.152.
 */
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class Atom
extends ArrayList<Bond> {
    final Residue residue;
    GenericRestraint chir;
    String key4;
    String symbol;
    String energy;
    Float charge;
    double[] xyz = new double[]{0.0, 0.0, 0.0};
    Atom coupled = this;
    private boolean changed = false;
    private boolean changedCharge = false;
    static final Atom NULL = new Atom();
    private static int counter1 = 0;
    private final int cou1;
    public static final Comparator<Atom> originComparator = new Comparator<Atom>(){

        @Override
        public int compare(Atom atom, Atom atom2) {
            return atom.cou1 - atom2.cou1;
        }
    };
    private static int counter2 = 0;
    private final int cou2 = counter2++;
    public static final Comparator<Atom> timeComparator = new Comparator<Atom>(){

        @Override
        public int compare(Atom atom, Atom atom2) {
            return atom.cou2 - atom2.cou2;
        }
    };
    public static final Comparator<Atom> zComparator = new Comparator<Atom>(){

        @Override
        public int compare(Atom atom, Atom atom2) {
            if (atom.xyz[2] < atom2.xyz[2]) {
                return 1;
            }
            if (atom.xyz[2] > atom2.xyz[2]) {
                return -1;
            }
            return atom.cou2 - atom2.cou2;
        }
    };

    boolean hasChanged() {
        return this.changed;
    }

    boolean hasChangedCharge() {
        return this.changedCharge;
    }

    void resetChanged() {
        this.changed = this.changedCharge;
    }

    void resetCharge() {
        if (!this.changedCharge) {
            this.charge = Float.valueOf(0.0f);
        }
    }

    void resetHidden() {
        this.changed = false;
    }

    boolean isHidden() {
        if (!this.symbol.equals("H")) {
            return false;
        }
        if (this.size() != 1) {
            return true;
        }
        return !this.changed && ((Bond)this.get((int)0)).another((Atom)this).changed;
    }

    Atom(Residue residue, String string, String string2, double d, double d2, double d3) {
        this.cou1 = counter1++;
        this.residue = residue;
        this.key4 = string2;
        this.symbol = string;
        this.energy = string;
        this.charge = Float.valueOf(0.0f);
        this.xyz[0] = d;
        this.xyz[1] = d2;
        this.xyz[2] = d3;
        this.changed = true;
    }

    Atom(Residue residue) {
        this.cou1 = counter1++;
        this.residue = residue;
    }

    Atom(Residue residue, Atom atom) {
        this.cou1 = atom.cou1;
        this.residue = residue;
        this.key4 = atom.key4;
        this.symbol = atom.symbol;
        this.energy = atom.energy;
        this.charge = atom.charge;
        this.xyz[0] = atom.xyz[0];
        this.xyz[1] = atom.xyz[1];
        this.xyz[2] = atom.xyz[2];
        this.changed = atom.changed;
        this.changedCharge = atom.changedCharge;
    }

    void resetKey(Set<String> set) {
        if (set.add(this.key4)) {
            return;
        }
        String string = this.key4.substring(0, Math.min(3, this.key4.length()));
        for (int i = 1; i < 10; ++i) {
            this.key4 = string + i;
            if (!set.add(this.key4)) continue;
            return;
        }
        this.generateKey(set);
    }

    void generateKey(Set<String> set) {
        while (++this.residue.newAtomCount < 1000) {
            this.key4 = this.symbol + this.residue.newAtomCount;
            if (!set.add(this.key4)) continue;
            return;
        }
        throw new NullPointerException();
    }

    @Override
    public String toString() {
        return this.key4 + "-" + String.valueOf(this.cou2) + "-" + String.valueOf(this.cou1);
    }

    static int sign(List<Atom> list) {
        double[] dArray = list.get((int)0).xyz;
        double[][] dArrayArray = new double[3][];
        for (int i = 0; i < 3; ++i) {
            double[] dArray2 = list.get((int)(i + 1)).xyz;
            double[] dArray3 = new double[3];
            for (int j = 0; j < 3; ++j) {
                dArray3[j] = dArray2[j] - dArray[j];
            }
            dArrayArray[i] = dArray3;
        }
        double d = dArrayArray[0][0] * dArrayArray[1][1] * dArrayArray[2][2];
        d -= dArrayArray[0][0] * dArrayArray[1][2] * dArrayArray[2][1];
        d -= dArrayArray[1][1] * dArrayArray[2][0] * dArrayArray[0][2];
        d -= dArrayArray[2][2] * dArrayArray[0][1] * dArrayArray[1][0];
        d += dArrayArray[0][2] * dArrayArray[1][0] * dArrayArray[2][1];
        if ((d += dArrayArray[2][0] * dArrayArray[0][1] * dArrayArray[1][2]) > 0.0) {
            return 1;
        }
        return -1;
    }

    private Atom() {
        this.cou1 = Integer.MAX_VALUE;
        this.residue = null;
    }

    @Override
    public int hashCode() {
        return this.cou2;
    }

    @Override
    public boolean equals(Object object) {
        return object.hashCode() == this.cou2;
    }

    public int compareTo(Object object) {
        throw new NullPointerException();
    }

    class UndoableReplaceBond
    extends Backup {
        Bond bondOld;
        Bond bondNew;
        GenericRestraint chirOld;
        GenericRestraint chirNew;

        UndoableReplaceBond(Bond bond, Bond bond2) {
            this.chirOld = Atom.this.chir;
            this.chirNew = Atom.this.chir == null ? null : Atom.this.chir.duplicatePart();
            this.bondOld = bond;
            this.bondNew = bond2;
            Atom.this.remove(bond);
            Atom.this.add(bond2);
            Atom.this.chir = this.chirNew;
            if (Env.vbPrint) {
                System.out.println(":::: " + Atom.this.key4 + " replace bond");
            }
        }

        void undo() {
            Atom.this.remove(this.bondNew);
            Atom.this.add(this.bondOld);
            Atom.this.chir = this.chirOld;
        }

        void redo() {
            Atom.this.remove(this.bondOld);
            Atom.this.add(this.bondNew);
            Atom.this.chir = this.chirNew;
        }
    }

    class UndoableRemoveBond
    extends Backup {
        Bond bond;
        GenericRestraint chirOld;
        boolean changedOld;

        UndoableRemoveBond(Bond bond) {
            this.chirOld = Atom.this.chir;
            Atom.this.chir = null;
            this.bond = bond;
            Atom.this.remove(this.bond);
            this.changedOld = Atom.this.changed;
            Atom.this.changed = true;
            if (Env.vbPrint) {
                System.out.println(":::: " + Atom.this.key4 + " remove bond");
            }
        }

        void undo() {
            Atom.this.chir = this.chirOld;
            Atom.this.add(this.bond);
            Atom.this.changed = this.changedOld;
        }

        void redo() {
            Atom.this.chir = null;
            Atom.this.remove(this.bond);
            Atom.this.changed = true;
        }
    }

    class UndoableAddBond
    extends Backup {
        Bond bond;
        GenericRestraint chirOld;
        boolean changedOld;

        UndoableAddBond(Bond bond) {
            this.chirOld = Atom.this.chir;
            Atom.this.chir = null;
            this.bond = bond;
            Atom.this.add(this.bond);
            this.changedOld = Atom.this.changed;
            Atom.this.changed = true;
            if (Env.vbPrint) {
                System.out.println(":::: " + Atom.this.key4 + " add bond");
            }
        }

        void undo() {
            Atom.this.chir = this.chirOld;
            Atom.this.remove(this.bond);
            Atom.this.changed = this.changedOld;
        }

        void redo() {
            Atom.this.chir = null;
            Atom.this.add(this.bond);
            Atom.this.changed = true;
        }
    }

    class UndoableEditCharge
    extends Backup {
        Float valueOld;
        Float valueNew;
        boolean changedOld;
        boolean changedChargeOld;

        UndoableEditCharge(Float f) {
            this.valueOld = Atom.this.charge;
            this.valueNew = f;
            Atom.this.charge = f;
            this.changedChargeOld = Atom.this.changedCharge;
            Atom.this.changedCharge = true;
            this.changedOld = Atom.this.changed;
            Atom.this.changed = true;
            if (Env.vbPrint) {
                System.out.println(":::: " + Atom.this.key4 + " charge " + Atom.this.charge);
            }
        }

        void undo() {
            Atom.this.charge = this.valueOld;
            Atom.this.changedCharge = this.changedChargeOld;
            Atom.this.changed = this.changedOld;
        }

        void redo() {
            Atom.this.charge = this.valueNew;
            Atom.this.changedCharge = true;
            Atom.this.changed = true;
        }
    }

    class UndoableEditSymbol
    extends Backup {
        String energyOld;
        String energyNew;
        String valueOld;
        String valueNew;
        boolean changedOld;

        UndoableEditSymbol(String string) {
            this.valueOld = Atom.this.symbol;
            this.valueNew = string;
            Atom.this.symbol = string;
            this.energyOld = Atom.this.energy;
            this.energyNew = string;
            Atom.this.energy = string;
            this.changedOld = Atom.this.changed;
            Atom.this.changed = true;
            if (Env.vbPrint) {
                System.out.println(":::: " + Atom.this.key4 + " symbol " + Atom.this.symbol);
            }
        }

        void undo() {
            Atom.this.symbol = this.valueOld;
            Atom.this.energy = this.energyOld;
            Atom.this.changed = this.changedOld;
        }

        void redo() {
            Atom.this.symbol = this.valueNew;
            Atom.this.energy = this.energyNew;
            Atom.this.changed = true;
        }
    }

    class UndoableEditKey4
    extends Backup {
        String valueOld;
        String valueNew;

        UndoableEditKey4(String string) {
            this.valueOld = Atom.this.key4;
            this.valueNew = string;
            Atom.this.key4 = string;
            if (Env.vbPrint) {
                System.out.println(":::: " + Atom.this.key4 + " key4 " + Atom.this.key4);
            }
        }

        void undo() {
            Atom.this.key4 = this.valueOld;
        }

        void redo() {
            Atom.this.key4 = this.valueNew;
        }
    }
}

