/*
 * Decompiled with CFR 0.152.
 */
class Bond {
    boolean visited = false;
    Atom atom1;
    Atom atom2;
    String type;
    Value value;

    public String toString() {
        return "(" + this.atom1 + (this.type.equals("double") ? " == " : " -- ") + this.atom2 + ")";
    }

    Bond() {
    }

    Bond(String string, double d) {
        this.type = string;
        this.value = new Value(new Float(d).floatValue(), new Float(0.3f).floatValue());
    }

    Bond(Atom atom, Atom atom2, String string) {
        this.type = string;
        this.value = new Value(new Float(1.5f).floatValue(), new Float(0.3f).floatValue());
        int n = Atom.timeComparator.compare(atom, atom2);
        if (n < 0) {
            this.atom1 = atom;
            this.atom2 = atom2;
            return;
        }
        if (n > 0) {
            this.atom1 = atom2;
            this.atom2 = atom;
            return;
        }
        throw new NullPointerException();
    }

    Bond(Atom atom, Atom atom2, Bond bond) {
        this.type = bond.type;
        this.value = bond.value;
        int n = Atom.timeComparator.compare(atom, atom2);
        if (n < 0) {
            this.atom1 = atom;
            this.atom2 = atom2;
            return;
        }
        if (n > 0) {
            this.atom1 = atom2;
            this.atom2 = atom;
            return;
        }
        throw new NullPointerException();
    }

    Bond(GenericRestraint genericRestraint) {
        if (genericRestraint.atoms.size() != 2) {
            throw new NullPointerException();
        }
        this.atom1 = genericRestraint.atoms.get(0);
        this.atom2 = genericRestraint.atoms.get(1);
        this.type = genericRestraint.type;
        this.value = genericRestraint.value;
    }

    Atom another(Atom atom) {
        if (atom == this.atom1) {
            return this.atom2;
        }
        if (atom == this.atom2) {
            return this.atom1;
        }
        throw new NullPointerException();
    }
}

