/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.Map;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;

class ChangeAtomDialog
implements ActionListener {
    private Map<String, Atom> atomMap;
    private Molecule ligand;
    private JDialog dialog;
    private JLabel label1;
    private JLabel label2;
    private JLabel label3;
    private JLabel label5;
    private JTextField textField1;
    private JComboBox atomTypeList;
    private JComboBox atomChirList;
    private JTextField textField3;
    private JButton submitButton;
    private JButton cancelButton;
    public String[] atomTypeArray = new String[]{"H", "He", "Li", "Be", "B", "C", "N", "O", "F", "Ne", "Na", "Mg", "Al", "Si", "P", "S", "Cl", "Ar", "K", "Ca", "Sc", "Ti", "V", "Cr", "Mn", "Fe", "Co", "Ni", "Cu", "Zn", "Ga", "Ge", "As", "Se", "Br", "Kr", "Rb", "Sr", "Y", "Zr", "Nb", "Mo", "Tc", "Ru", "Rh", "Pd", "Ag", "Cd", "In", "Sn", "Sb", "Te", "I", "Xe", "Cs", "Ba", "La", "Ce", "Pr", "Nd", "Pm", "Sm", "Eu", "Gd", "Tb", "Dy", "Ho", "Er", "Tm", "Yb", "Lu", "Hf", "Ta", "W", "Re", "Os", "Ir", "Pt", "Au", "Hg", "Tl", "Pb", "Bi", "Po", "At", "Rn", "Fr", "Ra", "Ac", "Th", "Pa", "U", "Np", "Pu", "Am", "Cm", "Bk", "Cf", "Es", "Fm", "Md", "No", "Lr"};
    private Atom atom = null;
    private String previousType;

    public ChangeAtomDialog(Molecule molecule, Atom atom) {
        this.ligand = molecule;
        this.atom = atom;
        this.atomMap = molecule.atomView(atom);
        if (this.atomMap.remove(atom.key4) == null) {
            throw new NullPointerException();
        }
        this.dialog = new JDialog((Frame)JLMain.mainFrame, true);
        this.dialog.setTitle("Edit Atom Details");
        this.label1 = new JLabel("Atom Id");
        this.textField1 = new JTextField(10);
        this.textField1.setText(atom.key4);
        this.textField1.addActionListener(this);
        this.label2 = new JLabel("Atom Type");
        this.label3 = new JLabel("Atom Charge");
        this.label5 = new JLabel("Chirality");
        this.textField3 = new JTextField(10);
        this.textField3.setText(String.valueOf(atom.charge));
        this.textField3.addActionListener(this);
        this.submitButton = new JButton("Submit");
        this.submitButton.addActionListener(this);
        this.cancelButton = new JButton("Cancel");
        this.cancelButton.addActionListener(this);
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BoxLayout(jPanel, 0));
        jPanel.add(new JLabel("Please edit your atom details and click on Submit:"));
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout(new BoxLayout(jPanel2, 0));
        jPanel2.add(this.label1);
        jPanel2.add(Box.createRigidArea(new Dimension(40, 0)));
        this.setComponentSize(this.textField1, 150, 25);
        jPanel2.add(this.textField1);
        int n = 0;
        for (int i = 0; i < this.atomTypeArray.length; ++i) {
            if (!atom.symbol.equals(this.atomTypeArray[i])) continue;
            n = i;
            break;
        }
        JPanel jPanel3 = new JPanel();
        jPanel3.setLayout(new BoxLayout(jPanel3, 2));
        jPanel3.add(this.label2);
        jPanel3.add(Box.createRigidArea(new Dimension(23, 0)));
        this.atomTypeList = new JComboBox<String>(this.atomTypeArray);
        this.atomTypeList.setSelectedIndex(n);
        this.setComponentSize(this.atomTypeList, 154, 30);
        jPanel3.add(this.atomTypeList);
        this.atomTypeList.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                String string = ChangeAtomDialog.this.textField1.getText();
                String string2 = (String)ChangeAtomDialog.this.atomTypeList.getSelectedItem();
                if (string.toUpperCase().startsWith(ChangeAtomDialog.this.previousType.toUpperCase())) {
                    string2 = string2.toUpperCase();
                    ChangeAtomDialog.this.textField1.setText(string2 + string.substring(ChangeAtomDialog.this.previousType.length()));
                }
                ChangeAtomDialog.this.previousType = string2;
            }
        });
        this.previousType = (String)this.atomTypeList.getSelectedItem();
        JPanel jPanel4 = new JPanel();
        jPanel4.setLayout(new BoxLayout(jPanel4, 0));
        jPanel4.add(this.label3);
        jPanel4.add(Box.createRigidArea(new Dimension(10, 0)));
        this.setComponentSize(this.textField3, 150, 25);
        jPanel4.add(this.textField3);
        JPanel jPanel5 = new JPanel();
        jPanel5.setLayout(new BoxLayout(jPanel5, 2));
        jPanel5.add(this.label5);
        jPanel5.add(Box.createRigidArea(new Dimension(40, 0)));
        int n2 = -1;
        if (atom.chir != null) {
            n2 = atom.chir.getIndex();
        }
        if (n2 < 0) {
            this.atomChirList = new JComboBox<String>(new String[]{"n/a"});
            this.atomChirList.setSelectedIndex(0);
            this.atomChirList.setEnabled(false);
            this.label5.setEnabled(false);
        } else {
            this.atomChirList = new JComboBox<String>(atom.chir.getOptions());
            this.atomChirList.setSelectedIndex(n2);
            this.atomChirList.setEnabled(true);
            this.label5.setEnabled(true);
        }
        this.setComponentSize(this.atomChirList, 154, 30);
        jPanel5.add(this.atomChirList);
        JPanel jPanel6 = new JPanel();
        jPanel6.setLayout(new BoxLayout(jPanel6, 2));
        jPanel6.add(this.cancelButton);
        jPanel6.add(Box.createRigidArea(new Dimension(72, 0)));
        jPanel6.add(this.submitButton);
        JPanel jPanel7 = new JPanel();
        jPanel7.setLayout(new BoxLayout(jPanel7, 3));
        jPanel7.add(Box.createRigidArea(new Dimension(0, 30)));
        jPanel7.add(jPanel);
        jPanel7.add(Box.createRigidArea(new Dimension(0, 20)));
        jPanel7.add(jPanel2);
        jPanel7.add(Box.createRigidArea(new Dimension(0, 5)));
        jPanel7.add(jPanel3);
        jPanel7.add(Box.createRigidArea(new Dimension(0, 5)));
        jPanel7.add(jPanel4);
        jPanel7.add(Box.createRigidArea(new Dimension(0, 5)));
        jPanel7.add(jPanel5);
        jPanel7.add(Box.createRigidArea(new Dimension(0, 20)));
        jPanel7.add(jPanel6);
        jPanel7.setOpaque(true);
        this.dialog.setContentPane(jPanel7);
        int n3 = DialogWindows.dialogWidth;
        int n4 = DialogWindows.dialogHeight;
        this.dialog.setSize(new Dimension(n3, n4));
        this.dialog.setLocation(DialogWindows.screenWidth / 2 - n3 / 2, DialogWindows.locationTop2);
        this.dialog.setVisible(true);
        this.dialog.addWindowListener(new WindowAdapter(){

            public void windowOpened(WindowEvent windowEvent) {
                SwingUtilities.invokeLater(new Runnable(){

                    public void run() {
                        ChangeAtomDialog.this.textField1.requestFocusInWindow();
                    }
                });
            }
        });
    }

    public void setComponentSize(JComponent jComponent, int n, int n2) {
        Dimension dimension = new Dimension(n, n2);
        jComponent.setPreferredSize(dimension);
        jComponent.setMinimumSize(dimension);
        jComponent.setMaximumSize(dimension);
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getSource() == this.cancelButton) {
            this.dialog.setVisible(false);
            this.dialog.dispose();
        } else if (actionEvent.getSource() == this.textField1 || actionEvent.getSource() == this.textField3 || actionEvent.getSource() == this.submitButton) {
            boolean bl = false;
            String string = this.textField1.getText();
            String string2 = (String)this.atomTypeList.getSelectedItem();
            float f = 0.0f;
            boolean bl2 = false;
            try {
                f = Float.parseFloat(this.textField3.getText());
            }
            catch (NumberFormatException numberFormatException) {
                bl2 = true;
            }
            if (string.length() == 0 || string.length() > 4) {
                bl = true;
                DialogWindows.showWarningDialog("Atom Id must be 1 - 4 characters - please try again");
            } else if (bl2 || (double)f < -3.0 || (double)f > 3.0) {
                bl = true;
                DialogWindows.showWarningDialog("Charge must be a number between -3.0 and +3.0 - please try again");
            } else if (this.atomMap.get(string) != null) {
                bl = true;
                DialogWindows.showWarningDialog("This Atom Id already exists - please enter a new Atom Id");
            }
            if (!bl) {
                String string3 = "/ void /";
                if (this.atom.chir != null) {
                    string3 = this.atom.chir.getType(this.atomChirList.getSelectedIndex());
                }
                JLMain.currentPanel.gLib.undoableChangeAtom(string3, this.ligand, this.atom, string, string2, f);
                this.dialog.setVisible(false);
                this.dialog.dispose();
            }
        }
    }
}

