/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;

class ChangeBondDialog
implements ActionListener {
    private Molecule ligand;
    private JDialog dialog;
    private JLabel label1;
    private JComboBox bondTypeList;
    private JButton submitButton;
    private JButton cancelButton;
    public String[] bondTypeArray = new String[]{"single", "double", "triple", "deloc", "aromatic", "metal"};
    private Bond bond;

    public ChangeBondDialog(Molecule molecule, Bond bond) {
        this.bond = bond;
        this.ligand = molecule;
    }

    public void showDialog() {
        this.dialog = new JDialog((Frame)JLMain.mainFrame, true);
        this.dialog.setTitle("Edit Bond Type");
        this.label1 = new JLabel("Bond Type");
        this.submitButton = new JButton("Submit");
        this.submitButton.addActionListener(this);
        this.cancelButton = new JButton("Cancel");
        this.cancelButton.addActionListener(this);
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BoxLayout(jPanel, 0));
        jPanel.add(new JLabel("Please edit your bond type and click on Submit:"));
        int n = 0;
        for (int i = 0; i < this.bondTypeArray.length; ++i) {
            if (!this.bond.type.startsWith(this.bondTypeArray[i])) continue;
            n = i;
            break;
        }
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout(new BoxLayout(jPanel2, 2));
        jPanel2.add(this.label1);
        jPanel2.add(Box.createRigidArea(new Dimension(23, 0)));
        this.bondTypeList = new JComboBox<String>(this.bondTypeArray);
        this.bondTypeList.setSelectedIndex(n);
        this.setComponentSize(this.bondTypeList, 150, 30);
        jPanel2.add(this.bondTypeList);
        JPanel jPanel3 = new JPanel();
        jPanel3.setLayout(new BoxLayout(jPanel3, 2));
        jPanel3.add(this.submitButton);
        jPanel3.add(Box.createRigidArea(new Dimension(10, 0)));
        jPanel3.add(this.cancelButton);
        JPanel jPanel4 = new JPanel();
        jPanel4.setLayout(new BoxLayout(jPanel4, 3));
        jPanel4.add(Box.createRigidArea(new Dimension(0, 30)));
        jPanel4.add(jPanel);
        jPanel4.add(Box.createRigidArea(new Dimension(0, 20)));
        jPanel4.add(jPanel2);
        jPanel4.add(Box.createRigidArea(new Dimension(0, 20)));
        jPanel4.add(jPanel3);
        jPanel4.setOpaque(true);
        this.dialog.setContentPane(jPanel4);
        int n2 = DialogWindows.dialogWidth;
        int n3 = DialogWindows.dialogHeight;
        this.dialog.setSize(new Dimension(n2, n3));
        this.dialog.setLocation(DialogWindows.screenWidth / 2 - n2 / 2, DialogWindows.locationTop2);
        this.dialog.setVisible(true);
        this.dialog.addWindowListener(new WindowAdapter(){

            public void windowOpened(WindowEvent windowEvent) {
                SwingUtilities.invokeLater(new Runnable(){

                    public void run() {
                        ChangeBondDialog.this.bondTypeList.requestFocusInWindow();
                    }
                });
            }
        });
    }

    public void setComponentSize(JComponent jComponent, int n, int n2) {
        Dimension dimension = new Dimension(n, n2);
        jComponent.setPreferredSize(dimension);
        jComponent.setMinimumSize(dimension);
        jComponent.setMaximumSize(dimension);
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getSource() == this.cancelButton) {
            this.dialog.setVisible(false);
            this.dialog.dispose();
        } else if (actionEvent.getSource() == this.submitButton) {
            String string = (String)this.bondTypeList.getSelectedItem();
            if (!string.equals(this.bond.type)) {
                JLMain.currentPanel.gLib.undoableChangeBond(this.ligand, this.bond, string);
            }
            this.dialog.setVisible(false);
            this.dialog.dispose();
        }
    }
}

