/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;

class ChangeLigandIdDialog
implements ActionListener {
    private JDialog dialog;
    private JLabel label1;
    private JTextField textField1;
    private JButton submitButton;
    private JButton cancelButton;
    private String oldLigandId = "";
    GLib targetLib;
    String newKey8 = null;

    public ChangeLigandIdDialog(GLib gLib, String string) {
        this.targetLib = gLib;
        this.oldLigandId = string;
    }

    public void showDialog() {
        this.dialog = new JDialog((Frame)JLMain.mainFrame, true);
        this.dialog.setTitle("Edit Ligand Id");
        this.label1 = new JLabel("Ligand Id");
        this.textField1 = new JTextField(10);
        this.textField1.setText(this.oldLigandId);
        this.textField1.addActionListener(this);
        this.submitButton = new JButton("Submit");
        this.submitButton.addActionListener(this);
        this.cancelButton = new JButton("Cancel");
        this.cancelButton.addActionListener(this);
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BoxLayout(jPanel, 0));
        jPanel.add(new JLabel("Please edit your Ligand Id (1 - 8 characters) and click on Submit:"));
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout(new BoxLayout(jPanel2, 0));
        jPanel2.add(this.label1);
        jPanel2.add(Box.createRigidArea(new Dimension(40, 0)));
        this.setComponentSize(this.textField1, 150, 25);
        jPanel2.add(this.textField1);
        JPanel jPanel3 = new JPanel();
        jPanel3.setLayout(new BoxLayout(jPanel3, 2));
        jPanel3.add(this.submitButton);
        jPanel3.add(Box.createRigidArea(new Dimension(10, 0)));
        jPanel3.add(this.cancelButton);
        JPanel jPanel4 = new JPanel();
        jPanel4.setLayout(new BoxLayout(jPanel4, 3));
        jPanel4.add(Box.createVerticalStrut(10));
        jPanel4.add(Box.createRigidArea(new Dimension(0, 20)));
        jPanel4.add(jPanel);
        jPanel4.add(Box.createRigidArea(new Dimension(0, 20)));
        jPanel4.add(jPanel2);
        jPanel4.add(Box.createRigidArea(new Dimension(0, 20)));
        jPanel4.add(jPanel3);
        jPanel4.setOpaque(true);
        this.dialog.setContentPane(jPanel4);
        int n = DialogWindows.dialogWidth;
        int n2 = DialogWindows.dialogHeight;
        this.dialog.setSize(new Dimension(n, n2));
        this.dialog.setLocation(DialogWindows.screenWidth / 2 - n / 2, DialogWindows.locationTop2);
        this.dialog.setVisible(true);
        this.dialog.addWindowListener(new WindowAdapter(){

            public void windowOpened(WindowEvent windowEvent) {
                SwingUtilities.invokeLater(new Runnable(){

                    public void run() {
                        ChangeLigandIdDialog.this.textField1.requestFocusInWindow();
                    }
                });
            }
        });
    }

    public void setComponentSize(JComponent jComponent, int n, int n2) {
        Dimension dimension = new Dimension(n, n2);
        jComponent.setPreferredSize(dimension);
        jComponent.setMinimumSize(dimension);
        jComponent.setMaximumSize(dimension);
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getSource() == this.cancelButton) {
            this.dialog.setVisible(false);
            this.dialog.dispose();
        } else if (actionEvent.getSource() == this.textField1 || actionEvent.getSource() == this.submitButton) {
            String string = this.textField1.getText();
            if (string.length() == 0 || string.length() > 8) {
                DialogWindows.showWarningDialog("Ligand Id must be 1 - 8 characters - please try again");
            } else if (!string.matches("[a-zA-Z0-9-_]+")) {
                DialogWindows.showWarningDialog("Ligand Id must consist of these characters: A-Z, a-z, 1-9, -, _ (no spaces allowed) - please try again");
            } else if (this.exists(string)) {
                DialogWindows.showWarningDialog("This Ligand Id already exists - please enter a new Ligand Id");
            } else {
                if (!string.equals(this.oldLigandId)) {
                    this.newKey8 = string;
                }
                this.dialog.setVisible(false);
                this.dialog.dispose();
            }
        }
    }

    boolean exists(String string) {
        return !string.equals(this.oldLigandId) && this.targetLib.contains(string);
    }
}

