/*
 * Decompiled with CFR 0.152.
 */
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class CifLoop
extends LinkedHashMap<String, CifColumn> {
    private static final String bsn = System.getProperty("line.separator");
    int[] blockSizes;
    int[] blockRef;
    List<CifColumn> columns;
    int ic = 0;
    int jc = 0;
    int nc = 0;
    int ir = 0;
    int nr = 0;

    CifLoop(String string, List<String> list, List<String> list2) {
        int n = list.size();
        if (2 * n != list2.size()) {
            throw new NullPointerException();
        }
        for (int i = 0; i < n; ++i) {
            String string2 = list.get(i);
            this.put(string2, new CifColumn(string + string2, list2.get(i)));
        }
        this.blockRef = new int[n];
        LinkedHashMap<String, Integer> linkedHashMap = new LinkedHashMap<String, Integer>();
        int n2 = 0;
        for (int i = 0; i < n; ++i) {
            String string3 = list2.get(n + i);
            Integer n3 = (Integer)linkedHashMap.get(string3);
            if (n3 == null) {
                n3 = new Integer(n2++);
                linkedHashMap.put(string3, n3);
            }
            this.blockRef[i] = n3;
        }
        this.blockSizes = new int[n2];
        this.columns = new ArrayList(this.values());
        this.nc = this.columns.size();
    }

    CifLoop(CifLoop cifLoop) {
        for (Map.Entry entry : cifLoop.entrySet()) {
            this.put(entry.getKey(), new CifColumn((CifColumn)entry.getValue()));
        }
        this.columns = new ArrayList(this.values());
        this.nc = this.columns.size();
        this.blockSizes = cifLoop.blockSizes;
        this.blockRef = cifLoop.blockRef;
    }

    public void add(Object object) {
        if (this.ic != 0 || this.ir != 0) {
            throw new NullPointerException();
        }
        this.columns.get(this.jc++).add(object);
        if (this.jc == this.nc) {
            this.jc = 0;
            ++this.nr;
        }
    }

    public boolean hasNextNoCycle() {
        if (this.jc != 0) {
            throw new NullPointerException();
        }
        return this.ir < this.nr && this.ic < this.nc;
    }

    public boolean hasNext() {
        if (this.jc != 0) {
            throw new NullPointerException();
        }
        if (this.ir < this.nr && this.ic < this.nc) {
            return true;
        }
        this.ic = 0;
        this.ir = 0;
        return false;
    }

    public Object next() {
        if (this.jc != 0) {
            throw new NullPointerException();
        }
        Object object = this.columns.get(this.ic++).get(this.ir);
        if (this.ic == this.nc) {
            this.ic = 0;
            ++this.ir;
        }
        return object;
    }

    public void trimBlocks() {
        int n;
        int n2 = this.blockSizes.length;
        for (n = 0; n < n2; ++n) {
            this.blockSizes[n] = 0;
        }
        n2 = this.size();
        for (n = 0; n < n2; ++n) {
            if (this.columns.get(n).isVoid()) continue;
            int n3 = this.blockRef[n];
            this.blockSizes[n3] = this.blockSizes[n3] + 1;
        }
        n2 = this.size();
        for (n = 0; n < n2; ++n) {
            if (this.blockSizes[this.blockRef[n]] != 0) continue;
            this.columns.get(n).clear();
        }
    }

    void trim(int n) {
        int n2 = 0;
        for (CifColumn cifColumn : this.values()) {
            if (cifColumn.size() == n) {
                if (cifColumn.isVoid()) {
                    cifColumn.clear();
                    continue;
                }
                ++n2;
                continue;
            }
            if (cifColumn.size() == 0) continue;
            System.err.println("kr = " + n + ", nr = " + this.nr);
            throw new NullPointerException();
        }
        this.nr = n;
        if (n2 == 0) {
            this.nr = 0;
        }
    }

    public boolean isVoid() {
        for (CifColumn cifColumn : this.values()) {
            if (cifColumn.isVoid()) continue;
            return false;
        }
        return true;
    }

    @Override
    public void clear() {
        for (CifColumn cifColumn : this.values()) {
            cifColumn.clear();
        }
        this.nr = 0;
    }

    @Override
    public String toString() {
        CharArray charArray = new CharArray();
        this.appendTo(charArray);
        return charArray.toString();
    }

    void appendTo(CharArray charArray) {
        if (this.isVoid()) {
            return;
        }
        this.trimBlocks();
        charArray.append(bsn).append("loop_").append(bsn);
        for (Object object : this.values()) {
            if (((ArrayList)object).isEmpty()) continue;
            charArray.append(((CifColumn)object).asString()).append(bsn);
        }
        for (int i = 0; i < this.nr; ++i) {
            for (CifColumn cifColumn : this.values()) {
                if (cifColumn.isEmpty()) continue;
                charArray.append(cifColumn.asString(i));
            }
            charArray.append(bsn);
        }
    }
}

