/*
 * Decompiled with CFR 0.152.
 */
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class GLib
extends ArrayList<Molecule> {
    final UndoRedo undoRedo = new UndoRedo();

    GLib() {
    }

    String summary() {
        String string = "   GLib:";
        for (Molecule molecule : this) {
            String string2 = " [" + molecule.key8 + ": ";
            for (Residue residue : molecule.residueList()) {
                string = string + string2 + residue.key8;
                String string3 = ",new";
                if (residue.mono != null) {
                    string = string + "," + residue.mono.key8 + "(" + residue.mono.key3 + ")";
                    string3 = residue.mono.isStandard() ? ",std" : ",own";
                }
                string = string + string3;
                string2 = "; ";
            }
            string = string + "]";
        }
        for (Molecule molecule : this) {
            if (molecule.getResidue() != null) continue;
            string = string + Env.bsn + molecule.linkRecordPDB();
        }
        return string;
    }

    void undoableAddMols(List<Molecule> list) {
        this.undoRedo.backupStarts("add molecules");
        for (Molecule molecule : list) {
            this.undoRedo.backup(new UndoableAddMolecule(molecule));
        }
        this.undoRedo.backupEnds();
    }

    Molecule get(String string) {
        for (Molecule molecule : this) {
            if (!molecule.key8.equals(string)) continue;
            return molecule;
        }
        return null;
    }

    boolean contains(String string) {
        return this.get(string) != null;
    }

    public void moveAtom(Molecule molecule, Atom atom, double[] dArray) {
        for (int i = 0; i < 2; ++i) {
            int n = i;
            atom.xyz[n] = atom.xyz[n] + dArray[i];
        }
        molecule.updateSphere();
    }

    public void moveMol(Molecule molecule, double[] dArray) {
        for (Residue object : molecule.residueList()) {
            object.transform.translate(dArray);
        }
        for (int i = 0; i < 2; ++i) {
            int n = i;
            molecule.xyz[n] = molecule.xyz[n] + dArray[i];
        }
        for (Atom atom : molecule.atoms) {
            for (int i = 0; i < 2; ++i) {
                int n = i;
                atom.xyz[n] = atom.xyz[n] + dArray[i];
            }
        }
    }

    public void rotateMol(Molecule molecule, double[] dArray, double[] dArray2) {
        Rotation rotation = new Rotation(molecule.radius, molecule.xyz, dArray, dArray2);
        for (Residue object : molecule.residueList()) {
            object.transform.rotate(rotation);
        }
        for (Atom atom : molecule.atoms) {
            rotation.forward(atom.xyz);
        }
        Collections.sort(molecule.atoms, Atom.zComparator);
    }

    void undoableClear() {
        this.undoRedo.backupStarts("Clear");
        this.undoRedo.backup(new UndoableClear());
        this.undoRedo.backupEnds();
    }

    void undoableAddMolecule(String string, String string2) {
        this.undoRedo.backupStarts("new ligand");
        Molecule molecule = null;
        Ring ring = Rings.get(string2);
        if (ring == null) {
            molecule = new Molecule(string, string2);
        } else {
            molecule = new Molecule(string);
            ring.undoableAddTo(this.undoRedo, molecule, null, new double[]{0.0, 0.0});
        }
        this.undoRedo.backup(new UndoableAddMolecule(molecule));
        this.undoRedo.backupEnds();
    }

    Molecule undoableAddMolecule(String string, Monomer monomer) {
        Molecule molecule = new Molecule(monomer);
        molecule.key8 = string;
        this.undoRedo.backupStarts("add monmomer " + string);
        this.undoRedo.backup(new UndoableAddMolecule(molecule));
        this.undoRedo.backupEnds();
        return molecule;
    }

    void undoableRegularise(Molecule molecule, boolean bl) {
        if (!this.contains(molecule)) {
            throw new NullPointerException();
        }
        if (molecule.restraints != null) {
            throw new NullPointerException();
        }
        boolean bl2 = true;
        Molecule molecule2 = molecule.regularise(true, bl2, bl);
        if (molecule2.getResidue() != null) {
            molecule2 = new Molecule(new Monomer(molecule2));
        }
        this.undoRedo.backupStarts("regularise");
        this.undoRedo.backup(new UndoableRemoveMolecule(molecule));
        this.undoRedo.backup(new UndoableAddMolecule(molecule2));
        this.undoRedo.backupEnds();
    }

    void undoableConvertMolecule(Molecule molecule) {
        if (!this.contains(molecule)) {
            throw new NullPointerException();
        }
        Molecule molecule2 = new Molecule(new Monomer(molecule));
        this.undoRedo.backupStarts("convert");
        this.undoRedo.backup(new UndoableRemoveMolecule(molecule));
        this.undoRedo.backup(new UndoableAddMolecule(molecule2));
        this.undoRedo.backupEnds();
    }

    void undoableReplaceMolecule(Molecule molecule, Molecule molecule2) {
        if (molecule == null || molecule2 == null || !this.contains(molecule)) {
            throw new NullPointerException();
        }
        this.undoRedo.backupStarts("replace " + molecule.key8 + " with " + molecule2.key8);
        this.undoRedo.backup(new UndoableReplaceMolecule(molecule, molecule2));
        this.undoRedo.backupEnds();
    }

    void undoableRemoveMolecule(Molecule molecule) {
        if (molecule == null || !this.contains(molecule)) {
            throw new NullPointerException();
        }
        this.undoRedo.backupStarts("Remove Molecule " + molecule.key8);
        this.undoRedo.backup(new UndoableRemoveMolecule(molecule));
        this.undoRedo.backupEnds();
    }

    void undoableRenameMolecule(Molecule molecule, String string, String string2) {
        Monomer monomer;
        Residue residue;
        if (molecule == null || !this.contains(molecule)) {
            throw new NullPointerException();
        }
        boolean bl = molecule.key8.equals(string);
        boolean bl2 = molecule.name.equals(string2);
        if (bl && bl2) {
            return;
        }
        this.undoRedo.backupStarts("Rename Molecule " + molecule.key8 + " to " + string + " " + string2);
        if (!bl) {
            Molecule molecule2 = molecule;
            molecule2.getClass();
            this.undoRedo.backup(new Molecule.UndoableEditKey8(molecule2, string));
        }
        if (!bl2) {
            Molecule molecule3 = molecule;
            molecule3.getClass();
            this.undoRedo.backup(new Molecule.UndoableEditName(molecule3, string2));
        }
        if ((residue = molecule.getResidue()) != null && (monomer = residue.mono) != null && !monomer.isStandard() && molecule.restraints != null) {
            if (!bl2) {
                Residue residue2 = residue;
                residue2.getClass();
                this.undoRedo.backup(new Residue.UndoableEditName(residue2, string2));
            }
            if (!bl) {
                Residue residue3 = residue;
                residue3.getClass();
                this.undoRedo.backup(new Residue.UndoableEditKey8(residue3, string));
            }
            if (!bl2) {
                Monomer monomer2 = monomer;
                monomer2.getClass();
                this.undoRedo.backup(new Monomer.UndoableEditName(monomer2, string2));
            }
            if (!bl) {
                Monomer monomer3 = monomer;
                monomer3.getClass();
                this.undoRedo.backup(new Monomer.UndoableEditKey8(monomer3, string));
            }
            String string3 = string.substring(0, Math.min(3, string.length()));
            if (!bl) {
                Monomer monomer4 = monomer;
                monomer4.getClass();
                this.undoRedo.backup(new Monomer.UndoableEditKey3(monomer4, string3));
            }
        }
        this.undoRedo.backupEnds();
    }

    Atom undoableReplaceAtom(Molecule molecule, Atom atom) {
        if (molecule == null || !this.contains(molecule)) {
            throw new NullPointerException();
        }
        if (atom == null || !molecule.atoms.contains(atom)) {
            throw new NullPointerException();
        }
        Object object = atom.iterator();
        while (object.hasNext()) {
            Bond bond = (Bond)object.next();
            Object object2 = bond.another(atom);
            if (((Atom)object2).coupled == object2) continue;
            throw new NullPointerException();
        }
        this.undoRedo.backupStarts("replace atom");
        atom.coupled = object = new Atom(atom.residue, atom);
        if (atom.chir != null) {
            ((Atom)object).chir = atom.chir.duplicatePart();
        }
        for (Object object2 : atom) {
            Atom atom2 = ((Bond)object2).another(atom);
            Bond bond = new Bond(atom2, (Atom)object, (Bond)object2);
            Atom atom3 = atom2;
            atom3.getClass();
            this.undoRedo.backup(atom3.new Atom.UndoableReplaceBond((Bond)object2, bond));
            ((ArrayList)object).add(bond);
        }
        atom.coupled = atom;
        Molecule molecule2 = molecule;
        molecule2.getClass();
        this.undoRedo.backup(new Molecule.UndoableRemoveAtom(molecule2, atom));
        Molecule molecule3 = molecule;
        molecule3.getClass();
        this.undoRedo.backup(new Molecule.UndoableAddAtom(molecule3, (Atom)object));
        this.undoRedo.backup(new Molecule.UndoableClearRestraints(molecule));
        this.undoRedo.backupEnds();
        return object;
    }

    void movingAtomStopped(Molecule molecule, Atom atom) {
        if (molecule == null || !this.contains(molecule)) {
            throw new NullPointerException();
        }
        if (atom == null || !molecule.atoms.contains(atom)) {
            throw new NullPointerException();
        }
        if (atom.chir != null) {
            for (Atom object : atom.chir.atoms) {
                if (molecule.atoms.contains(object) || object == Atom.NULL) continue;
                throw new NullPointerException();
            }
            atom.chir.setSign().setType();
        }
        for (Bond bond : atom) {
            Atom atom2 = bond.another(atom);
            if (atom2.chir == null) continue;
            for (Atom atom3 : atom2.chir.atoms) {
                if (molecule.atoms.contains(atom3) || atom3 == Atom.NULL) continue;
                throw new NullPointerException();
            }
            atom2.chir.setSign().setType();
        }
    }

    void undoableRemoveAtom(Molecule molecule, Atom atom) {
        this.undoRedo.backupStarts("remove atom");
        if (molecule.atoms.indexOf(atom) < 0) {
            throw new NullPointerException();
        }
        for (Bond bond : atom) {
            Atom atom2;
            Atom atom3 = atom2 = bond.another(atom);
            atom3.getClass();
            this.undoRedo.backup(atom3.new Atom.UndoableRemoveBond(bond));
            if (atom2.size() != 0 || !atom2.symbol.equals("H")) continue;
            Molecule molecule2 = molecule;
            molecule2.getClass();
            this.undoRedo.backup(new Molecule.UndoableRemoveAtom(molecule2, atom2));
        }
        Molecule molecule3 = molecule;
        molecule3.getClass();
        this.undoRedo.backup(new Molecule.UndoableRemoveAtom(molecule3, atom));
        if (molecule.atoms.size() == 0) {
            this.undoRedo.backup(new UndoableRemoveMolecule(molecule));
        }
        this.undoRedo.backup(new Molecule.UndoableClearRestraints(molecule));
        this.undoRedo.backupEnds();
    }

    Atom undoableAddAtom(Molecule molecule, Atom atom, String string, double[] dArray) {
        Ring ring = Rings.get(string);
        if (ring == null) {
            this.undoRedo.backupStarts("add atom");
            Atom atom2 = new Atom(atom.residue, string, string, dArray[0], dArray[1], atom.xyz[2]);
            LinkedHashSet<String> linkedHashSet = new LinkedHashSet<String>(molecule.atomView(atom).keySet());
            atom2.generateKey(linkedHashSet);
            Bond bond = new Bond(atom, atom2, "single");
            Molecule molecule2 = molecule;
            molecule2.getClass();
            this.undoRedo.backup(new Molecule.UndoableAddAtom(molecule2, atom2));
            Atom atom3 = atom;
            atom3.getClass();
            this.undoRedo.backup(atom3.new Atom.UndoableAddBond(bond));
            Atom atom4 = atom2;
            atom4.getClass();
            this.undoRedo.backup(atom4.new Atom.UndoableAddBond(bond));
            this.undoRedo.backup(new Molecule.UndoableClearRestraints(molecule));
            this.undoRedo.backupEnds();
            return atom2;
        }
        this.undoRedo.backupStarts("add ring");
        ring.undoableAddTo(this.undoRedo, molecule, atom, dArray);
        this.undoRedo.backup(new Molecule.UndoableClearRestraints(molecule));
        this.undoRedo.backupEnds();
        return atom;
    }

    void undoableChangeAtom(String string, Molecule molecule, Atom atom, String string2, String string3, float f) {
        if (molecule == null || !this.contains(molecule)) {
            throw new NullPointerException();
        }
        if (atom == null || !molecule.atoms.contains(atom)) {
            throw new NullPointerException();
        }
        boolean bl = atom.key4.equals(string2);
        boolean bl2 = atom.symbol.equals(string3);
        boolean bl3 = atom.charge.equals(Float.valueOf(f));
        boolean bl4 = true;
        if (atom.chir != null) {
            bl4 = atom.chir.type.equals(string);
        }
        if (bl && bl2 && bl3 && bl4) {
            return;
        }
        this.undoRedo.backupStarts("Edit Atom");
        if (!bl) {
            Atom atom2 = atom;
            atom2.getClass();
            this.undoRedo.backup(atom2.new Atom.UndoableEditKey4(string2));
        }
        if (!bl2) {
            Atom atom3 = atom;
            atom3.getClass();
            this.undoRedo.backup(atom3.new Atom.UndoableEditSymbol(string3));
        }
        if (!bl3) {
            Atom atom4 = atom;
            atom4.getClass();
            this.undoRedo.backup(atom4.new Atom.UndoableEditCharge(Float.valueOf(f)));
        }
        if (!bl4) {
            GenericRestraint genericRestraint = atom.chir;
            genericRestraint.getClass();
            this.undoRedo.backup(new GenericRestraint.UndoableEditType(genericRestraint, string));
        }
        boolean bl5 = true;
        if (atom.chir != null) {
            bl5 = atom.chir.isConsistent();
        }
        if (!(bl2 && bl3 && bl5)) {
            this.undoRedo.backup(new Molecule.UndoableClearRestraints(molecule));
        }
        this.undoRedo.backupEnds();
    }

    void undoableRemoveBond(Molecule molecule, Bond bond) {
        this.undoRedo.backupStarts("remove bond");
        Atom atom = bond.atom1;
        Atom atom2 = bond.atom2;
        if (molecule.atoms.indexOf(atom) < 0 || molecule.atoms.indexOf(atom2) < 0) {
            throw new NullPointerException();
        }
        Atom atom3 = atom;
        atom3.getClass();
        this.undoRedo.backup(atom3.new Atom.UndoableRemoveBond(bond));
        Atom atom4 = atom2;
        atom4.getClass();
        this.undoRedo.backup(atom4.new Atom.UndoableRemoveBond(bond));
        if (atom.size() == 0 && atom.symbol.equals("H")) {
            Molecule molecule2 = molecule;
            molecule2.getClass();
            this.undoRedo.backup(new Molecule.UndoableRemoveAtom(molecule2, atom));
        }
        if (atom2.size() == 0 && atom2.symbol.equals("H")) {
            Molecule molecule3 = molecule;
            molecule3.getClass();
            this.undoRedo.backup(new Molecule.UndoableRemoveAtom(molecule3, atom2));
        }
        if (molecule.atoms.size() == 0) {
            this.undoRedo.backup(new UndoableRemoveMolecule(molecule));
        }
        this.undoRedo.backup(new Molecule.UndoableClearRestraints(molecule));
        this.undoRedo.backupEnds();
    }

    void undoableAddBond(Molecule molecule, Atom atom, Atom atom2, String string) {
        Bond bond = new Bond(atom, atom2, string);
        this.undoRedo.backupStarts("add bond");
        Atom atom3 = atom;
        atom3.getClass();
        this.undoRedo.backup(atom3.new Atom.UndoableAddBond(bond));
        Atom atom4 = atom2;
        atom4.getClass();
        this.undoRedo.backup(atom4.new Atom.UndoableAddBond(bond));
        this.undoRedo.backup(new Molecule.UndoableClearRestraints(molecule));
        this.undoRedo.backupEnds();
    }

    void undoableAddBond(String string, Molecule molecule, Atom atom, Molecule molecule2, Atom atom2, String string2) {
        if (molecule == molecule2) {
            throw new NullPointerException();
        }
        if (atom.residue.cootId != atom2.residue.cootId) {
            throw new NullPointerException();
        }
        atom.residue.isFirst = true;
        atom2.residue.isFirst = false;
        Bond bond = new Bond(atom, atom2, string2);
        Molecule molecule3 = new Molecule();
        molecule3.atoms.addAll(molecule.atoms);
        molecule3.atoms.addAll(molecule2.atoms);
        molecule3.key8 = string;
        molecule3.name = molecule.getResidue().key8 + "-" + molecule2.getResidue().key8;
        double d = atom.xyz[2];
        double d2 = atom2.xyz[2];
        for (Atom atom3 : molecule.atoms) {
            atom3.xyz[2] = atom3.xyz[2] - d;
        }
        for (Atom atom3 : molecule2.atoms) {
            atom3.xyz[2] = atom3.xyz[2] - d2;
        }
        atom.residue.transform.translate(-d);
        atom2.residue.transform.translate(-d2);
        this.undoRedo.backupStarts("add link");
        this.undoRedo.backup(new UndoableRemoveMolecule(molecule));
        this.undoRedo.backup(new UndoableRemoveMolecule(molecule2));
        this.undoRedo.backup(new UndoableAddMolecule(molecule3));
        Atom atom4 = atom;
        atom4.getClass();
        this.undoRedo.backup(atom4.new Atom.UndoableAddBond(bond));
        Atom atom5 = atom2;
        atom5.getClass();
        this.undoRedo.backup(atom5.new Atom.UndoableAddBond(bond));
        this.undoRedo.backup(new Molecule.UndoableClearRestraints(molecule3));
        this.undoRedo.backupEnds();
    }

    void undoableChangeBond(Molecule molecule, Bond bond, String string) {
        Atom atom = bond.atom1;
        Atom atom2 = bond.atom2;
        Bond bond2 = new Bond(atom, atom2, string);
        this.undoRedo.backupStarts("Edit Bond");
        Atom atom3 = atom;
        atom3.getClass();
        this.undoRedo.backup(atom3.new Atom.UndoableRemoveBond(bond));
        Atom atom4 = atom2;
        atom4.getClass();
        this.undoRedo.backup(atom4.new Atom.UndoableRemoveBond(bond));
        Atom atom5 = atom;
        atom5.getClass();
        this.undoRedo.backup(atom5.new Atom.UndoableAddBond(bond2));
        Atom atom6 = atom2;
        atom6.getClass();
        this.undoRedo.backup(atom6.new Atom.UndoableAddBond(bond2));
        this.undoRedo.backup(new Molecule.UndoableClearRestraints(molecule));
        this.undoRedo.backupEnds();
    }

    class UndoableReplaceMolecule
    extends Backup {
        Molecule molOld;
        Molecule molNew;

        UndoableReplaceMolecule(Molecule molecule, Molecule molecule2) {
            this.molOld = molecule;
            this.molNew = molecule2;
            for (Atom atom : molecule.atoms) {
                atom.residue.transform.backward(atom.xyz);
            }
            GLib.this.remove(molecule);
            GLib.this.add(molecule2);
            molecule2.updateSphere();
            if (Env.vbPrint) {
                System.out.println(":::: GLib replace " + molecule.key8 + " " + molecule2.key8);
            }
        }

        void undo() {
            for (Atom atom : this.molOld.atoms) {
                atom.residue.transform.forward(atom.xyz);
            }
            for (Atom atom : this.molNew.atoms) {
                atom.residue.transform.backward(atom.xyz);
            }
            GLib.this.remove(this.molNew);
            GLib.this.add(this.molOld);
            this.molOld.updateSphere();
        }

        void redo() {
            for (Atom atom : this.molOld.atoms) {
                atom.residue.transform.backward(atom.xyz);
            }
            for (Atom atom : this.molNew.atoms) {
                atom.residue.transform.forward(atom.xyz);
            }
            GLib.this.remove(this.molOld);
            GLib.this.add(this.molNew);
            this.molNew.updateSphere();
        }
    }

    class UndoableRemoveMolecule
    extends Backup {
        Molecule mol;

        UndoableRemoveMolecule(Molecule molecule) {
            this.mol = molecule;
            GLib.this.remove(this.mol);
            if (Env.vbPrint) {
                System.out.println(":::: GLib remove molecule " + this.mol.key8);
            }
        }

        void undo() {
            GLib.this.add(this.mol);
            this.mol.updateSphere();
        }

        void redo() {
            GLib.this.remove(this.mol);
        }
    }

    class UndoableAddMolecule
    extends Backup {
        Molecule mol;

        UndoableAddMolecule(Molecule molecule) {
            this.mol = molecule;
            GLib.this.add(this.mol);
            this.mol.updateSphere();
            if (Env.vbPrint) {
                System.out.println(":::: GLib add " + this.mol.key8);
            }
        }

        void undo() {
            GLib.this.remove(this.mol);
        }

        void redo() {
            GLib.this.add(this.mol);
            this.mol.updateSphere();
        }
    }

    class UndoableClear
    extends Backup {
        List<Molecule> list;

        UndoableClear() {
            this.list = new ArrayList<Molecule>(GLib.this.size());
            Iterator iterator = GLib.this.iterator();
            while (iterator.hasNext()) {
                this.list.add((Molecule)iterator.next());
            }
            GLib.this.clear();
            if (Env.vbPrint) {
                System.out.println(":::: GLib clear");
            }
        }

        void undo() {
            GLib.this.addAll(this.list);
        }

        void redo() {
            GLib.this.clear();
        }
    }
}

