/*
 * Decompiled with CFR 0.152.
 */
import java.io.File;
import java.io.FileWriter;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JOptionPane;

class JLMain {
    static JLGPanel currentPanel;
    static String option;
    static int buttonsMask;
    static boolean showNames;
    static boolean showHydrogens;
    static boolean showCharges;
    static File openDir;
    static String bsn;
    static JFrame mainFrame;
    static final File toCoot;
    static final File fromCoot;

    JLMain() {
    }

    static void actionNewLigand() {
        NewLigandDialog newLigandDialog = new NewLigandDialog(JLMain.currentPanel.gLib);
        newLigandDialog.showDialog();
        String string = newLigandDialog.getLigandId();
        String string2 = newLigandDialog.getAtomType();
        if (string == null || string2 == null) {
            return;
        }
        JLMain.currentPanel.gLib.undoableAddMolecule(string, string2);
    }

    static void actionLoadLigand() {
        SearchLibraryDialog searchLibraryDialog = new SearchLibraryDialog();
        searchLibraryDialog.showDialog();
        JLMain.actionLoadLigand(searchLibraryDialog.getLigandId());
    }

    static Molecule actionLoadLigand(String string) {
        Monomer monomer;
        block8: {
            if (string == null || string.length() == 0) {
                return null;
            }
            monomer = null;
            if (!StdLib.hasReady(string)) {
                currentPanel.drawMessage("Please wait, " + string + " is being loaded");
            }
            boolean bl = false;
            try {
                monomer = StdLib.get(string, bl);
            }
            catch (Exception exception) {
                if (!Env.vbPrint) break block8;
                exception.printStackTrace(System.err);
            }
        }
        if (monomer != null) {
            monomer.recentre();
        }
        Molecule molecule = null;
        if (monomer != null) {
            String string2 = string;
            String string3 = "The ligand '" + string2 + "' has been loaded" + bsn + "but the";
            CorrectLinkIdDialog correctLinkIdDialog = new CorrectLinkIdDialog(string3, JLMain.currentPanel.gLib, string2);
            string2 = correctLinkIdDialog.newKey8;
            if (string2 != null) {
                molecule = JLMain.currentPanel.gLib.undoableAddMolecule(string2, monomer);
            }
        } else {
            String string4 = "Code '" + string + "' does not exist in the library - please try again";
            DialogWindows.showErrorDialog(string4);
        }
        return molecule;
    }

    static void actionSave(String string, String string2, String string3, boolean bl) {
        Object object;
        String string4;
        Object object2;
        CifLib cifLib;
        File file;
        Molecule molecule;
        block35: {
            molecule = null;
            try {
                molecule = JLMain.currentPanel.gLib.get(string3);
            }
            catch (Exception exception) {
                DialogWindows.showErrorDialog("Internal error");
                return;
            }
            if (molecule == null) {
                DialogWindows.showErrorDialog("Internal error");
                return;
            }
            if (molecule.restraints == null) {
                String string5 = "Ligand " + string3 + " is not regularised - please regularise before saving";
                DialogWindows.showWarningDialog(string5);
                return;
            }
            file = null;
            cifLib = null;
            if (string.equals("APPEND")) {
                object2 = new JFileChooser(openDir);
                ((JFileChooser)object2).setDialogTitle("Append to CIF-library");
                ((JFileChooser)object2).setFileFilter(new FileNameExtensionFilter("CIF Library Files", "cif", "lib"));
                ((JFileChooser)object2).setApproveButtonText("Append");
                if (((JFileChooser)object2).showOpenDialog(mainFrame) != 0) {
                    return;
                }
                file = ((JFileChooser)object2).getSelectedFile();
                openDir = file.getParentFile();
                try {
                    currentPanel.drawMessage("Please wait, " + file.getName() + " is being read and validated");
                    cifLib = new CifLib(file);
                }
                catch (Exception exception) {
                    DialogWindows.showErrorDialog("File " + file + " does not seem to be a valid CIF-library");
                    return;
                }
            } else if (string.equals("SAVE")) {
                object2 = new JCheckedFileChooser(openDir);
                ((JFileChooser)object2).setDialogTitle("Save as CIF-library");
                ((JFileChooser)object2).setSelectedFile(new File(openDir, string3 + ".cif"));
                ((JFileChooser)object2).setFileFilter(new FileNameExtensionFilter("CIF Library Files", "cif", "lib"));
                if (((JFileChooser)object2).showDialog(mainFrame, "Save") != 0) {
                    return;
                }
                file = ((JFileChooser)object2).getSelectedFile();
                openDir = file.getParentFile();
                cifLib = new CifLib();
            } else {
                DialogWindows.showErrorDialog("Internal error");
                return;
            }
            object2 = null;
            string4 = "";
            try {
                if (string2.equals("COMP")) {
                    object = null;
                    try {
                        object = new Monomer(molecule);
                    }
                    catch (Exception exception) {
                        DialogWindows.showErrorDialog("Internal error");
                        return;
                    }
                    object2 = "monomer";
                    cifLib.add((Monomer)object);
                    break block35;
                }
                if (string2.equals("LINK")) {
                    if (molecule.getResidue() != null) {
                        DialogWindows.showErrorDialog("Internal error");
                        return;
                    }
                    object2 = "link";
                    string4 = cifLib.add(molecule);
                    break block35;
                }
                DialogWindows.showErrorDialog("Internal error");
                return;
            }
            catch (Exception exception) {
                if (Env.vbPrint) {
                    exception.printStackTrace(System.err);
                }
                DialogWindows.showWarningDialog("The " + (String)object2 + " '" + string3 + "' cannot be appended to the CIF-library " + file.getName() + " because of name conflict(s)");
                return;
            }
        }
        try {
            cifLib.toBuffer().writeTo(file);
        }
        catch (Exception exception) {
            DialogWindows.showErrorDialog("Error writing file " + file.getName());
            return;
        }
        object = "The " + (String)object2 + " '" + string3;
        if (string.equals("APPEND")) {
            object = (String)object + "' has been appended to the CIF-library " + file.getName();
        } else if (string.equals("SAVE")) {
            object = (String)object + "' has been saved to the library file " + file.getName();
        } else {
            DialogWindows.showErrorDialog("Internal error");
            return;
        }
        if (bl) {
            object = (String)object + Env.bsn + "and will be sent to Coot";
        }
        object = (String)object + string4;
        DialogWindows.showInformationDialog((String)object);
        if (string2.equals("LINK")) {
            Object object3;
            String string6 = molecule.linkRecordPDB();
            if (Env.vbPrint) {
                System.err.println(string6);
            }
            File file2 = toCoot;
            if (!bl) {
                object3 = "To use the link '" + string3 + "'";
                object3 = (String)object3 + Env.bsn + "1) Add the following template LINK record to the input PDB-file " + "(just before the CRYST1 record)";
                object3 = (String)object3 + Env.bsn + "2) Change the chain IDs and residue numbers as appropriate";
                object3 = (String)object3 + Env.bsn + "3) In REFMAC task of CCP4I, define '" + file.getName() + "' as additional library";
                object3 = (String)object3 + Env.bsn;
                object3 = (String)object3 + Env.bsn + "NB. DO NOT change the order of residues in the LINK record!";
                object3 = (String)object3 + Env.bsn;
                object3 = (String)object3 + Env.bsn + "...";
                object3 = (String)object3 + Env.bsn + string6;
                object3 = (String)object3 + Env.bsn + "CRYST1 ...";
                object3 = (String)object3 + Env.bsn;
                int n = JOptionPane.showConfirmDialog(mainFrame, object3 = (String)object3 + Env.bsn + "Do you want to save this template in a separate file?", "Save Link Record", 0);
                if (n != 0) {
                    return;
                }
                JCheckedFileChooser jCheckedFileChooser = new JCheckedFileChooser(openDir);
                jCheckedFileChooser.setDialogTitle("Save PDB LINK record");
                jCheckedFileChooser.setSelectedFile(new File(openDir, "linkrecord.pdb"));
                jCheckedFileChooser.setFileFilter(new FileNameExtensionFilter("PDB Files", "pdb"));
                if (jCheckedFileChooser.showDialog(mainFrame, "Save") != 0) {
                    return;
                }
                file2 = jCheckedFileChooser.getSelectedFile();
                openDir = file2.getParentFile();
            }
            try {
                object3 = new FileWriter(file2);
                ((Writer)object3).write(file.getCanonicalFile().toString() + Env.bsn);
                ((Writer)object3).write(string6 + Env.bsn);
                ((OutputStreamWriter)object3).close();
            }
            catch (Exception exception) {
                object = "Error writing file " + file2.getName();
                DialogWindows.showErrorDialog((String)object);
            }
            if (!bl) {
                object = "File " + file2.getName() + " was successfully written";
                DialogWindows.showInformationDialog((String)object);
            }
        }
    }

    static void actionRegularise(String string, boolean bl) {
        Molecule molecule = JLMain.currentPanel.gLib.get(string);
        if (molecule.restraints != null) {
            DialogWindows.showWarningDialog("This ligand is already regularised");
            return;
        }
        currentPanel.drawMessage("Please wait, " + string + " is being regularised");
        JLMain.regularise(molecule, bl);
    }

    static void actionDelete(String string) {
        String string2 = "Are you sure you want to delete ligand " + string + "?";
        int n = JOptionPane.showConfirmDialog(mainFrame, string2, "Delete Ligand", 0);
        if (n != 0) {
            return;
        }
        JLMain.currentPanel.gLib.undoableRemoveMolecule(JLMain.currentPanel.gLib.get(string));
    }

    static void actionFind(String string) {
        try {
            Molecule molecule = JLMain.currentPanel.gLib.get(string);
            if (molecule.restraints == null) {
                String string2 = "Ligand " + string + " is not regularised - please regularise before searching";
                DialogWindows.showWarningDialog(string2);
                return;
            }
            String string3 = "Please wait, the library is being searched for " + string + " matches";
            currentPanel.drawMessage(string3);
            List<String> list = new Libcheck().getMatches(molecule);
            currentPanel.resetPanel();
            if (list == null || list.size() == 0) {
                String string4 = "Ligand " + string + " has no exact matches in the standard library";
                DialogWindows.showInformationDialog(string4);
                return;
            }
            SearchLibraryDialog searchLibraryDialog = new SearchLibraryDialog(list);
            searchLibraryDialog.showDialog();
            JLMain.actionLoadLigand(searchLibraryDialog.getLigandId());
        }
        catch (Exception exception) {
            DialogWindows.showErrorDialog("Internal error");
            return;
        }
    }

    static void actionEnterSmile() {
        SmileStringDialog smileStringDialog = new SmileStringDialog(JLMain.currentPanel.gLib);
        smileStringDialog.showDialog();
        if (smileStringDialog.canceled()) {
            return;
        }
        String string = smileStringDialog.getLigandId();
        String string2 = smileStringDialog.getSmileString();
        Monomer monomer = null;
        boolean bl = true;
        boolean bl2 = true;
        try {
            currentPanel.drawMessage("Please wait, your smile string is being processed");
            CharArray charArray = new CharArray(string2 + bsn);
            File file = new Libcheck().runLibcheckOnly(charArray, "SMILE", string, bl2, bl);
            CifLib cifLib = new CifLib(file);
            monomer = cifLib.getMonomer();
            monomer.recentre();
            if (bl) {
                Molecule molecule = new Molecule(monomer);
                molecule.restraints = null;
                boolean bl3 = false;
                monomer = new Monomer(molecule.regularise(true, bl2, bl3));
            }
        }
        catch (Exception exception) {
            DialogWindows.showErrorDialog("Cannot read the smile string");
            if (Env.vbPrint) {
                exception.printStackTrace(System.err);
            }
            return;
        }
        JLMain.currentPanel.gLib.undoableAddMolecule(monomer.key8, monomer);
    }

    static Molecule actionReadFromLib(String string, String string2) {
        Object object;
        boolean bl = true;
        Monomer monomer = null;
        File file = new File(string);
        try {
            currentPanel.drawMessage("Please wait, " + string2 + " is being read from " + file.getName() + " and regularised");
            openDir = file.getParentFile();
            monomer = new CifLib(file).getMonomer(string2);
        }
        catch (Exception exception) {
            DialogWindows.showErrorDialog("Could not read library-file '" + file.getName() + "'");
            if (Env.vbPrint) {
                exception.printStackTrace(System.err);
            }
            return null;
        }
        if (monomer == null) {
            return null;
        }
        try {
            monomer.recentre();
            object = new Molecule(monomer);
            ((Molecule)object).restraints = null;
            boolean bl2 = false;
            monomer = new Monomer(((Molecule)object).regularise(true, bl, bl2));
        }
        catch (Exception exception) {
            DialogWindows.showErrorDialog("Regularisation failed");
            if (Env.vbPrint) {
                exception.printStackTrace(System.err);
            }
            return null;
        }
        object = "The ligand '" + monomer.key8 + "' has been imported" + bsn + "but the";
        CorrectLinkIdDialog correctLinkIdDialog = new CorrectLinkIdDialog((String)object, JLMain.currentPanel.gLib, monomer.key8);
        monomer.key8 = correctLinkIdDialog.newKey8;
        if (monomer.key8 == null) {
            return null;
        }
        return JLMain.currentPanel.gLib.undoableAddMolecule(monomer.key8, monomer);
    }

    /*
     * WARNING - void declaration
     */
    static void actionReadLib(boolean bl) {
        Object object;
        void var6_10;
        Object object2;
        JFileChooser jFileChooser = new JFileChooser(openDir);
        jFileChooser.setDialogTitle("Import Ligand from CIF-library");
        jFileChooser.setFileFilter(new FileNameExtensionFilter("CIF Library Files", "cif", "lib"));
        if (jFileChooser.showOpenDialog(mainFrame) != 0) {
            return;
        }
        File file = jFileChooser.getSelectedFile();
        openDir = file.getParentFile();
        CifLib cifLib = null;
        try {
            currentPanel.drawMessage("Please wait, " + file.getName() + " is being read and validated");
            cifLib = new CifLib(file);
        }
        catch (Exception exception) {
            DialogWindows.showErrorDialog("Could not read library-file '" + file.getName() + "'");
            if (Env.vbPrint) {
                exception.printStackTrace(System.err);
            }
            return;
        }
        LinkedHashMap<String, Monomer> linkedHashMap = new LinkedHashMap<String, Monomer>();
        for (Monomer object32 : cifLib.monomerView()) {
            linkedHashMap.put(object32.key8, object32);
        }
        if (linkedHashMap.size() == 0) {
            DialogWindows.showErrorDialog("Could not find Ligands in file '" + file.getName() + "'");
            return;
        }
        Object[] objectArray = linkedHashMap.keySet().toArray();
        Object object3 = objectArray[0];
        if (objectArray.length > 1) {
            object2 = new ChooseLigandFromFile();
            ((ChooseLigandFromFile)object2).showDialog(objectArray);
            String string = ((ChooseLigandFromFile)object2).getLigandId();
            if (!linkedHashMap.keySet().contains(string)) {
                return;
            }
        }
        object2 = (Monomer)linkedHashMap.get(var6_10);
        try {
            if (objectArray.length > 1) {
                currentPanel.drawMessage("Please wait, " + ((Monomer)object2).key8 + " is being regularised");
            }
            ((Monomer)object2).recentre();
            object = new Molecule((Monomer)object2);
            ((Molecule)object).restraints = null;
            boolean bl2 = false;
            object2 = new Monomer(((Molecule)object).regularise(true, bl, bl2));
        }
        catch (Exception exception) {
            DialogWindows.showErrorDialog("Regularisation failed");
            if (Env.vbPrint) {
                exception.printStackTrace(System.err);
            }
            return;
        }
        object = "The ligand '" + ((Monomer)object2).key8 + "' has been imported" + bsn + "but the";
        CorrectLinkIdDialog correctLinkIdDialog = new CorrectLinkIdDialog((String)object, JLMain.currentPanel.gLib, ((Monomer)object2).key8);
        ((Monomer)object2).key8 = correctLinkIdDialog.newKey8;
        if (((Monomer)object2).key8 == null) {
            return;
        }
        JLMain.currentPanel.gLib.undoableAddMolecule(((Monomer)object2).key8, (Monomer)object2);
    }

    static void actionReadMOL(boolean bl) {
        Object object;
        CharSequence charSequence;
        JFileChooser jFileChooser = new JFileChooser(openDir);
        jFileChooser.setDialogTitle("Import Ligand from MOL(2)-file");
        jFileChooser.setFileFilter(new FileNameExtensionFilter("MOL(2) Files", "mol", "mol2"));
        if (jFileChooser.showOpenDialog(mainFrame) != 0) {
            return;
        }
        File file = jFileChooser.getSelectedFile();
        openDir = file.getParentFile();
        Monomer monomer = null;
        boolean bl2 = true;
        try {
            currentPanel.drawMessage("Please wait, file " + file.getName() + " is being processed");
            charSequence = new CharArray(file);
            object = new Libcheck().runLibcheckOnly((CharArray)charSequence, "MOL", null, bl2, bl);
            CifLib cifLib = new CifLib((File)object);
            monomer = cifLib.getMonomer();
            monomer.recentre();
            if (bl) {
                Molecule molecule = new Molecule(monomer);
                molecule.restraints = null;
                boolean bl3 = false;
                monomer = new Monomer(molecule.regularise(true, bl2, bl3));
            }
        }
        catch (Exception exception) {
            DialogWindows.showErrorDialog("Could not read MOL(2)-file '" + file.getName() + "'");
            if (Env.vbPrint) {
                exception.printStackTrace(System.err);
            }
            return;
        }
        charSequence = "The ligand '" + monomer.key8 + "' has been imported" + bsn + "but the";
        object = new CorrectLinkIdDialog((String)charSequence, JLMain.currentPanel.gLib, monomer.key8);
        monomer.key8 = ((CorrectLinkIdDialog)object).newKey8;
        if (monomer.key8 == null) {
            return;
        }
        JLMain.currentPanel.gLib.undoableAddMolecule(monomer.key8, monomer);
    }

    static void actionReadSDF(boolean bl) {
        Object object;
        CharSequence charSequence;
        JFileChooser jFileChooser = new JFileChooser(openDir);
        jFileChooser.setDialogTitle("Import Ligand from SDF-file");
        jFileChooser.setFileFilter(new FileNameExtensionFilter("SDF Files", "sdf"));
        if (jFileChooser.showOpenDialog(mainFrame) != 0) {
            return;
        }
        File file = jFileChooser.getSelectedFile();
        openDir = file.getParentFile();
        Monomer monomer = null;
        boolean bl2 = true;
        try {
            currentPanel.drawMessage("Please wait, file " + file.getName() + " is being processed");
            charSequence = new CharArray(file);
            object = new Libcheck().runLibcheckOnly((CharArray)charSequence, "SDF", null, bl2, bl);
            CifLib cifLib = new CifLib((File)object);
            monomer = cifLib.getMonomer();
            monomer.recentre();
            if (bl) {
                Molecule molecule = new Molecule(monomer);
                molecule.restraints = null;
                boolean bl3 = false;
                monomer = new Monomer(molecule.regularise(true, bl2, bl3));
            }
        }
        catch (Exception exception) {
            DialogWindows.showErrorDialog("Could not read SDF-file '" + file.getName() + "'");
            if (Env.vbPrint) {
                exception.printStackTrace(System.err);
            }
            return;
        }
        charSequence = "The ligand '" + monomer.key8 + "' has been imported" + bsn + "but the";
        object = new CorrectLinkIdDialog((String)charSequence, JLMain.currentPanel.gLib, monomer.key8);
        monomer.key8 = ((CorrectLinkIdDialog)object).newKey8;
        if (monomer.key8 == null) {
            return;
        }
        JLMain.currentPanel.gLib.undoableAddMolecule(monomer.key8, monomer);
    }

    /*
     * WARNING - void declaration
     */
    static void actionReadPDB(boolean bl) {
        Object object;
        void var6_13;
        Object object2;
        Object object4;
        JFileChooser jFileChooser = new JFileChooser(openDir);
        jFileChooser.setDialogTitle("Import Ligand from PDB-file");
        jFileChooser.setFileFilter(new FileNameExtensionFilter("PDB Files", "pdb"));
        if (jFileChooser.showOpenDialog(mainFrame) != 0) {
            return;
        }
        File file = jFileChooser.getSelectedFile();
        openDir = file.getParentFile();
        CifLib cifLib = null;
        try {
            currentPanel.drawMessage("Please wait, file " + file.getName() + " is being processed");
            object4 = new CharArray(file);
            boolean bl2 = true;
            File object32 = new Libcheck().runLibcheckOnly((CharArray)object4, "PDB", null, bl2, bl);
            cifLib = new CifLib(object32);
        }
        catch (Exception exception) {
            DialogWindows.showErrorDialog("Could not read PDB-file '" + file.getName() + "'");
            if (Env.vbPrint) {
                exception.printStackTrace(System.err);
            }
            return;
        }
        object4 = new LinkedHashMap();
        for (Monomer monomer : cifLib.monomerView()) {
            object4.put(monomer.key8, monomer);
        }
        if (object4.size() == 0) {
            DialogWindows.showErrorDialog("Could not find Ligands in file '" + file.getName() + "'");
            return;
        }
        Object[] objectArray = object4.keySet().toArray();
        Object object3 = objectArray[0];
        if (objectArray.length > 1) {
            object2 = new ChooseLigandFromFile();
            ((ChooseLigandFromFile)object2).showDialog(objectArray);
            String string = ((ChooseLigandFromFile)object2).getLigandId();
            if (!object4.keySet().contains(string)) {
                return;
            }
        }
        object2 = (Monomer)object4.get(var6_13);
        try {
            ((Monomer)object2).recentre();
            if (bl) {
                if (objectArray.length > 1) {
                    currentPanel.drawMessage("Please wait, " + ((Monomer)object2).key8 + " is being regularised");
                }
                object = new Molecule((Monomer)object2);
                ((Molecule)object).restraints = null;
                boolean bl2 = true;
                boolean bl3 = false;
                object2 = new Monomer(((Molecule)object).regularise(true, bl2, bl3));
            }
        }
        catch (Exception exception) {
            DialogWindows.showErrorDialog("Regularisation failed");
            if (Env.vbPrint) {
                exception.printStackTrace(System.err);
            }
            return;
        }
        object = "The ligand '" + ((Monomer)object2).key8 + "' has been imported" + bsn + "but the";
        CorrectLinkIdDialog correctLinkIdDialog = new CorrectLinkIdDialog((String)object, JLMain.currentPanel.gLib, ((Monomer)object2).key8);
        ((Monomer)object2).key8 = correctLinkIdDialog.newKey8;
        if (((Monomer)object2).key8 == null) {
            return;
        }
        JLMain.currentPanel.gLib.undoableAddMolecule(((Monomer)object2).key8, (Monomer)object2);
    }

    /*
     * WARNING - void declaration
     */
    static void actionRead(String string) {
        void var7_15;
        Object object;
        Object object3;
        JFileChooser jFileChooser = new JFileChooser(openDir);
        if (string.equals("L")) {
            jFileChooser.setDialogTitle("Import Ligand from CIF-library");
            jFileChooser.setFileFilter(new FileNameExtensionFilter("CIF Library Files", "cif", "lib"));
        } else if (string.equals("PDB")) {
            jFileChooser.setDialogTitle("Import Ligand from PDB-file");
            jFileChooser.setFileFilter(new FileNameExtensionFilter("PDB Files", "pdb"));
        } else if (string.equals("SDF")) {
            jFileChooser.setDialogTitle("Import Ligand from SDF-file");
            jFileChooser.setFileFilter(new FileNameExtensionFilter("SDF Files", "sdf"));
        }
        if (jFileChooser.showOpenDialog(mainFrame) != 0) {
            return;
        }
        File file = jFileChooser.getSelectedFile();
        openDir = file.getParentFile();
        File file2 = null;
        if (string.equals("L")) {
            file2 = file;
        } else {
            currentPanel.drawMessage("Please wait, file " + file.getName() + " is being processed");
            object3 = new CharArray(file);
            boolean bl = true;
            boolean bl2 = true;
            try {
                file2 = new Libcheck().runLibcheckOnly((CharArray)object3, string, null, bl, bl2);
            }
            catch (NullPointerException nullPointerException) {
                // empty catch block
            }
        }
        object3 = null;
        try {
            object3 = new CifLib(file2);
        }
        catch (NullPointerException nullPointerException) {
            DialogWindows.showErrorDialog("Could not read " + string + "-file '" + file.getName() + "'");
            return;
        }
        LinkedHashMap<String, Monomer> linkedHashMap = new LinkedHashMap<String, Monomer>();
        for (Monomer monomer : ((CifLib)object3).monomerView()) {
            linkedHashMap.put(monomer.key8, monomer);
        }
        if (linkedHashMap.size() == 0) {
            DialogWindows.showErrorDialog("Could not find Ligands in file '" + file.getName() + "'");
            return;
        }
        Object[] objectArray = linkedHashMap.keySet().toArray();
        Object object2 = objectArray[0];
        if (objectArray.length > 1) {
            object = new ChooseLigandFromFile();
            ((ChooseLigandFromFile)object).showDialog(objectArray);
            String string2 = ((ChooseLigandFromFile)object).getLigandId();
            if (!linkedHashMap.keySet().contains(string2)) {
                return;
            }
        }
        object = (String)var7_15;
        String string3 = "The ligand '" + (String)object + "' has been imported" + bsn + "but the";
        CorrectLinkIdDialog correctLinkIdDialog = new CorrectLinkIdDialog(string3, JLMain.currentPanel.gLib, (String)object);
        object = correctLinkIdDialog.newKey8;
        if (object == null) {
            return;
        }
        JLMain.currentPanel.gLib.undoableAddMolecule((String)object, (Monomer)linkedHashMap.get(var7_15));
    }

    static void actionSavePdb(String string) {
        Molecule molecule = JLMain.currentPanel.gLib.get(string);
        if (molecule.getResidue() == null) {
            String string2 = "Something wrong: this should not be a link";
            DialogWindows.showErrorDialog(string2);
            return;
        }
        if (molecule.restraints == null) {
            String string3 = "Ligand " + string + " is not regularised - please regularise before saving";
            DialogWindows.showInformationDialog(string3);
            return;
        }
        Monomer monomer = new Monomer(molecule);
        SavePdbDialog savePdbDialog = new SavePdbDialog();
        savePdbDialog.showDialog(string);
        if (!savePdbDialog.savePdb) {
            return;
        }
        boolean bl = savePdbDialog.includeH;
        JCheckedFileChooser jCheckedFileChooser = new JCheckedFileChooser(openDir);
        jCheckedFileChooser.setDialogTitle("Save Coordinates in PFB-file");
        jCheckedFileChooser.setSelectedFile(new File(openDir, string + ".pdb"));
        jCheckedFileChooser.setFileFilter(new FileNameExtensionFilter("PDB Files", "pdb"));
        if (jCheckedFileChooser.showDialog(mainFrame, "Save Coordinates") != 0) {
            return;
        }
        File file = jCheckedFileChooser.getSelectedFile();
        openDir = file.getParentFile();
        try {
            new PdbWriter().write(monomer, file, bl);
            String string4 = "File " + file.getName() + " was successfully written";
            DialogWindows.showInformationDialog(string4);
        }
        catch (Exception exception) {
            String string5 = "Error writing PDB-file " + file.getName();
            DialogWindows.showErrorDialog(string5);
        }
    }

    static void actionViewFile() {
        JFileChooser jFileChooser = new JFileChooser(openDir);
        jFileChooser.setDialogTitle("View File");
        jFileChooser.addChoosableFileFilter(new FileNameExtensionFilter("CIF Library Files", "cif", "lib"));
        jFileChooser.addChoosableFileFilter(new FileNameExtensionFilter("PDB Files", "pdb"));
        jFileChooser.setFileFilter(jFileChooser.getAcceptAllFileFilter());
        jFileChooser.setApproveButtonText("View");
        if (jFileChooser.showOpenDialog(mainFrame) != 0) {
            return;
        }
        File file = jFileChooser.getSelectedFile();
        openDir = file.getParentFile();
        if (!file.canRead()) {
            DialogWindows.showErrorDialog("Cannot read file '" + file.getName() + "'");
            return;
        }
        if (file.length() > 2000000L) {
            DialogWindows.showWarningDialog("File size for '" + file.getName() + "' is too large( > 2MB )");
            return;
        }
        new ViewFileDialog().show(file.getName(), new CharArray(file).toString());
    }

    static void actionViewLinkFile(String string) {
        Molecule molecule = JLMain.currentPanel.gLib.get(string);
        if (molecule.restraints == null) {
            String string2 = "This ligand is not regularised - please regularise before viewing link data";
            DialogWindows.showWarningDialog(string2);
            return;
        }
        try {
            CifLib cifLib = new CifLib();
            cifLib.add(molecule);
            new ViewFileDialog().show(molecule.key8, cifLib.toBuffer().toString());
        }
        catch (Exception exception) {
            DialogWindows.showWarningDialog("The link '" + string + "' cannot be viewed because of unexpected error");
        }
    }

    static void actionViewTable(String string, String string2) {
        Molecule molecule = JLMain.currentPanel.gLib.get(string2);
        if (molecule.restraints == null) {
            int n = JOptionPane.showConfirmDialog(mainFrame, "This ligand needs to be regularised before viewing table data - " + Env.bsn + "would you like to regularise now?", "Ligand is not regularised", 0);
            if (n != 0) {
                return;
            }
            currentPanel.drawMessage("Please wait, " + string2 + " is being regularised");
            if (!JLMain.regularise(molecule, false)) {
                return;
            }
        }
        molecule = JLMain.currentPanel.gLib.get(string2);
        new ViewTable().showTable(molecule, string);
    }

    static void actionClear() {
        int n = JOptionPane.showConfirmDialog(mainFrame, "Are you sure you want to remove all the ligands from this Tab ?", "Clear Tab", 0);
        if (n != 0) {
            return;
        }
        JLMain.currentPanel.gLib.undoableClear();
    }

    static void actionCheckChemistry() {
        Object object;
        Object object22;
        Object object3;
        GLib gLib = JLMain.currentPanel.gLib;
        if (gLib.isEmpty()) {
            return;
        }
        Molecule molecule = (Molecule)gLib.get(0);
        if (gLib.size() > 1) {
            object3 = new ArrayList(gLib.size());
            for (Object object22 : gLib) {
                object3.add(((Molecule)object22).key8);
            }
            object = new SelectMoleculeDialog();
            ((SelectMoleculeDialog)object).showDialog((List<String>)object3, "Check Valencies");
            molecule = gLib.get(((SelectMoleculeDialog)object).ligandId);
            if (molecule == null) {
                return;
            }
        }
        object3 = CheckChemistry.checkValencies(new Molecule((Molecule)molecule, (boolean)false).atoms, "restrictive");
        object = molecule.atoms.iterator();
        while (object.hasNext()) {
            ((Atom)object22).coupled = object22 = (Atom)object.next();
        }
        object = "Check Valencies for ligand " + molecule.key8;
        object22 = Env.bsn;
        object22 = (String)object22 + Env.bsn + "Missing / excessive hydrogen atoms, if any, will be";
        object22 = (String)object22 + Env.bsn + "handled during regularisation (Ligand > Regularise)";
        String string = Env.bsn;
        string = string + Env.bsn + "However, missing or excessive hydrogen atoms will be";
        string = string + Env.bsn + "handled during regularisation (Ligand > Regularise)";
        if (object3 == null) {
            DialogWindows.showInformationDialog((String)object + ": OK" + (String)object22);
        } else {
            DialogWindows.showErrorDialog((String)object + ": " + (String)object3 + string);
        }
    }

    static void actionCorrectBonds() {
        Object object;
        Object object2;
        GLib gLib = JLMain.currentPanel.gLib;
        if (gLib.isEmpty()) {
            return;
        }
        Molecule molecule = (Molecule)gLib.get(0);
        if (gLib.size() > 1) {
            object2 = new ArrayList<String>(gLib.size());
            for (Molecule molecule2 : gLib) {
                object2.add(molecule2.key8);
            }
            object = new SelectMoleculeDialog();
            ((SelectMoleculeDialog)object).showDialog((List<String>)object2, "Correct Bonds");
            molecule = gLib.get(((SelectMoleculeDialog)object).ligandId);
            if (molecule == null) {
                return;
            }
        }
        object2 = null;
        object = "";
        if (molecule.restraints == null) {
            boolean bl = true;
            boolean bl2 = false;
            object2 = molecule.regularise(false, bl, bl2);
            object = CorrectBonds.compare(molecule.atoms, ((Molecule)object2).atoms);
            Iterator<Atom> iterator = molecule.atoms.iterator();
            while (iterator.hasNext()) {
                Atom atom;
                atom.coupled = atom = iterator.next();
            }
        }
        String string = "Correct Bonds for ligand " + molecule.key8;
        String string2 = Env.bsn;
        string2 = string2 + Env.bsn + "Missing / excessive hydrogen atoms, if any, will be";
        string2 = string2 + Env.bsn + "handled during regularisation (Ligand > Regularise)";
        if (((String)object).equals("")) {
            DialogWindows.showInformationDialog(string + " - no changes to make" + string2);
        } else {
            JLMain.currentPanel.gLib.undoableReplaceMolecule(molecule, (Molecule)object2);
            string2 = Env.bsn + Env.bsn + (String)object + string2;
            DialogWindows.showWarningDialog(string + " - changes have been made" + string2);
        }
    }

    static void actionUndo() {
        JLMain.currentPanel.gLib.undoRedo.undo();
    }

    static void actionRedo() {
        JLMain.currentPanel.gLib.undoRedo.redo();
    }

    static boolean regularise(Molecule molecule, boolean bl) {
        try {
            JLMain.currentPanel.gLib.undoableRegularise(molecule, bl);
            return true;
        }
        catch (Exception exception) {
            DialogWindows.showErrorDialog("Regularisation failed");
            if (Env.vbPrint) {
                exception.printStackTrace(System.err);
            }
            return false;
        }
    }

    static {
        showNames = false;
        showHydrogens = false;
        showCharges = false;
        openDir = Env.cwd;
        bsn = Env.bsn;
        toCoot = new File(Env.cwd, ".jligand-to-coot-link");
        fromCoot = new File(Env.cwd, ".coot-to-jligand-8lcs");
    }
}

