/*
 * Decompiled with CFR 0.152.
 */
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.Box;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;

class JLMenuBar
extends JMenuBar {
    private JMenu jLigandMenu;
    private JMenu tabMenu;
    private JMenu fileMenu;
    private JMenu openMenu;
    private JMenu ligandMenu;
    private JMenu openAsIsMenu;
    private JMenu libmolMenu;
    private JMenu regulariseMenu;
    private JMenu saveCooMenu;
    private JMenu ligandDataMenu;
    private JMenu viewLigandDataMenu;
    private JMenu saveCompMenu;
    private JMenu saveLinkMenu;
    private JMenu cootMenu;
    private JMenu saveCootLinkMenu;
    private JMenu appendCootLinkMenu;
    private JMenu appendCompMenu;
    private JMenu appendLinkMenu;
    private JMenu findMenu;
    private JMenu viewLinkDataMenu;
    private JMenu deleteMenu;
    private JMenu helpMenu;
    private JMenuItem aboutItem;
    private JMenuItem quitItem;
    private JMenuItem openCIFItem;
    private JMenuItem openPDBItem;
    private JMenuItem openSDFItem;
    private JMenuItem openMOLItem;
    private JMenuItem openAsIsCIFItem;
    private JMenuItem openAsIsPDBItem;
    private JMenuItem openAsIsSDFItem;
    private JMenuItem openAsIsMOLItem;
    private JMenuItem enterSmileItem;
    private JMenuItem addTabItem;
    private JMenuItem deleteTabItem;
    private JMenuItem clearTabItem;
    private JMenuItem periodicTableItem;
    private JMenuItem viewFileItem;
    private JMenuItem helpJLigandItem;
    private JMenuItem helpJLigandMouseItem;
    private JMenuItem helpJLigandKeypadItem;
    private ActionListener listener;

    JLMenuBar(ActionListener actionListener) {
        this.listener = actionListener;
        this.aboutItem = new JMenuItem("About ...");
        this.aboutItem.addActionListener(this.listener);
        this.aboutItem.setActionCommand("ABOUT");
        this.quitItem = new JMenuItem("Quit ...");
        this.quitItem.addActionListener(this.listener);
        this.quitItem.setActionCommand("QUIT");
        this.addTabItem = new JMenuItem("New Tab");
        this.addTabItem.addActionListener(this.listener);
        this.addTabItem.setActionCommand("TAB_NEW");
        this.openCIFItem = new JMenuItem("CIF File ...");
        this.openCIFItem.addActionListener(this.listener);
        this.openCIFItem.setActionCommand("FILE_LIB");
        this.openPDBItem = new JMenuItem("PDB File ...");
        this.openPDBItem.addActionListener(this.listener);
        this.openPDBItem.setActionCommand("FILE_PDB");
        this.openSDFItem = new JMenuItem("SDF File ...");
        this.openSDFItem.addActionListener(this.listener);
        this.openSDFItem.setActionCommand("FILE_SDF");
        this.openMOLItem = new JMenuItem("MOL(2) File ...");
        this.openMOLItem.addActionListener(this.listener);
        this.openMOLItem.setActionCommand("FILE_MOL");
        this.enterSmileItem = new JMenuItem("Enter Smile String ...");
        this.enterSmileItem.addActionListener(this.listener);
        this.enterSmileItem.setActionCommand("ENTER_SMILE");
        this.openAsIsCIFItem = new JMenuItem("CIF File ...");
        this.openAsIsCIFItem.addActionListener(this.listener);
        this.openAsIsCIFItem.setActionCommand("FILE_LIB_ASIS");
        this.openAsIsPDBItem = new JMenuItem("PDB File ...");
        this.openAsIsPDBItem.addActionListener(this.listener);
        this.openAsIsPDBItem.setActionCommand("FILE_PDB_ASIS");
        this.openAsIsSDFItem = new JMenuItem("SDF File ...");
        this.openAsIsSDFItem.addActionListener(this.listener);
        this.openAsIsSDFItem.setActionCommand("FILE_SDF_ASIS");
        this.openAsIsMOLItem = new JMenuItem("MOL(2) File ...");
        this.openAsIsMOLItem.addActionListener(this.listener);
        this.openAsIsMOLItem.setActionCommand("FILE_MOL_ASIS");
        this.deleteTabItem = new JMenuItem("Delete Current Tab ...");
        this.deleteTabItem.addActionListener(this.listener);
        this.deleteTabItem.setActionCommand("TAB_DELETE");
        this.clearTabItem = new JMenuItem("Clear Tab ...");
        this.clearTabItem.addActionListener(this.listener);
        this.clearTabItem.setActionCommand("TAB_CLEAR");
        this.openMenu = new JMenu("Open");
        this.openMenu.add(this.openCIFItem);
        this.openMenu.add(this.openPDBItem);
        boolean bl = false;
        if (!bl) {
            this.openMenu.add(this.openSDFItem);
        }
        if (!bl) {
            this.openMenu.add(this.openMOLItem);
        }
        this.openMenu.add(this.enterSmileItem);
        this.openAsIsMenu = new JMenu("Open As Is");
        this.openAsIsMenu.add(this.openAsIsCIFItem);
        this.openAsIsMenu.add(this.openAsIsPDBItem);
        this.openAsIsMenu.add(this.openAsIsSDFItem);
        this.openAsIsMenu.add(this.openAsIsMOLItem);
        this.saveCompMenu = new JMenu("Save as Monomer");
        this.saveLinkMenu = new JMenu("Save as Link");
        this.appendCompMenu = new JMenu("Append as Monomer");
        this.appendLinkMenu = new JMenu("Append as Link");
        this.saveCooMenu = new JMenu("Save Coordinates");
        this.saveCootLinkMenu = new JMenu("Save as Link and Send to Coot");
        this.appendCootLinkMenu = new JMenu("Append as Link and Send to Coot");
        this.libmolMenu = new JMenu("LibMol");
        this.regulariseMenu = new JMenu("Regularise");
        this.deleteMenu = new JMenu("Delete");
        this.findMenu = new JMenu("Find in standard library");
        this.viewLigandDataMenu = new JMenu("View Ligand Data");
        this.viewLinkDataMenu = new JMenu("View Link File");
        this.periodicTableItem = new JMenuItem("Periodic Table ...");
        this.periodicTableItem.addActionListener(this.listener);
        this.periodicTableItem.setActionCommand("PERIODIC_TABLE");
        this.viewFileItem = new JMenuItem("View File ...");
        this.viewFileItem.addActionListener(this.listener);
        this.viewFileItem.setActionCommand("VIEW_FILE");
        this.helpJLigandItem = new JMenuItem("JLigand Help");
        this.helpJLigandItem.addActionListener(this.listener);
        this.helpJLigandItem.setActionCommand("HELP_JLIGAND");
        this.helpJLigandMouseItem = new JMenuItem("JLigand Mouse Help");
        this.helpJLigandMouseItem.addActionListener(this.listener);
        this.helpJLigandMouseItem.setActionCommand("HELP_MOUSE");
        this.helpJLigandKeypadItem = new JMenuItem("JLigand Keypad Help");
        this.helpJLigandKeypadItem.addActionListener(this.listener);
        this.helpJLigandKeypadItem.setActionCommand("HELP_KEYPAD");
        boolean bl2 = true;
        this.jLigandMenu = new JMenu("JLigand");
        this.jLigandMenu.add(this.aboutItem);
        this.jLigandMenu.add(this.quitItem);
        String string = "File";
        if (bl2 && Env.talkToCoot) {
            string = "File / Coot";
        }
        this.fileMenu = new JMenu(string);
        this.fileMenu.add(this.openMenu);
        if (Env.asIs) {
            this.fileMenu.add(this.openAsIsMenu);
        }
        this.fileMenu.addSeparator();
        this.fileMenu.add(this.saveCompMenu);
        this.fileMenu.add(this.saveLinkMenu);
        if (bl2 && Env.talkToCoot) {
            this.fileMenu.add(this.saveCootLinkMenu);
        }
        this.fileMenu.addSeparator();
        this.fileMenu.add(this.appendCompMenu);
        this.fileMenu.add(this.appendLinkMenu);
        if (bl2 && Env.talkToCoot) {
            this.fileMenu.add(this.appendCootLinkMenu);
        }
        this.fileMenu.addSeparator();
        this.fileMenu.add(this.saveCooMenu);
        this.cootMenu = new JMenu("Coot");
        if (!bl2 && Env.talkToCoot) {
            this.cootMenu.add(this.saveCootLinkMenu);
            this.cootMenu.add(this.appendCootLinkMenu);
        }
        this.tabMenu = new JMenu("Tab");
        this.tabMenu.add(this.addTabItem);
        this.tabMenu.add(this.deleteTabItem);
        this.tabMenu.add(this.clearTabItem);
        this.ligandMenu = new JMenu("Ligand");
        if (Libmol.isAvailable()) {
            this.ligandMenu.add(this.libmolMenu);
        }
        this.ligandMenu.add(this.regulariseMenu);
        this.ligandMenu.add(this.deleteMenu);
        if (Versions.enableSearch()) {
            this.ligandMenu.add(this.findMenu);
        }
        this.ligandDataMenu = new JMenu("View");
        this.ligandDataMenu.add(this.viewLigandDataMenu);
        this.ligandDataMenu.add(this.viewLinkDataMenu);
        this.ligandDataMenu.add(this.viewFileItem);
        this.helpMenu = new JMenu("Help");
        this.helpMenu.add(this.helpJLigandItem);
        this.helpMenu.add(this.helpJLigandMouseItem);
        this.helpMenu.add(this.helpJLigandKeypadItem);
        int n = 25;
        this.add(Box.createHorizontalStrut(n));
        this.add(this.jLigandMenu);
        this.add(Box.createHorizontalStrut(n));
        this.add(this.fileMenu);
        this.add(Box.createHorizontalStrut(n));
        this.add(this.tabMenu);
        this.add(Box.createHorizontalStrut(n));
        this.add(this.ligandMenu);
        this.add(Box.createHorizontalStrut(n));
        this.add(this.ligandDataMenu);
        this.add(Box.createHorizontalStrut(n));
        this.add(this.helpMenu);
        if (!bl2 && Env.talkToCoot) {
            this.add(Box.createHorizontalStrut(n));
            this.add(this.cootMenu);
        }
        this.fileMenu.addMouseListener(new MouseAdapter(){

            public void mouseEntered(MouseEvent mouseEvent) {
                JLMenuBar.this.resetMenus();
            }
        });
        this.cootMenu.addMouseListener(new MouseAdapter(){

            public void mouseEntered(MouseEvent mouseEvent) {
                JLMenuBar.this.resetMenus();
            }
        });
        this.ligandMenu.addMouseListener(new MouseAdapter(){

            public void mouseEntered(MouseEvent mouseEvent) {
                JLMenuBar.this.resetMenus();
            }
        });
        this.ligandDataMenu.addMouseListener(new MouseAdapter(){

            public void mouseEntered(MouseEvent mouseEvent) {
                JLMenuBar.this.resetMenus();
            }
        });
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void resetMenus() {
        this.saveCompMenu.removeAll();
        this.saveLinkMenu.removeAll();
        this.appendCompMenu.removeAll();
        this.appendLinkMenu.removeAll();
        this.saveCootLinkMenu.removeAll();
        this.appendCootLinkMenu.removeAll();
        this.saveCooMenu.removeAll();
        this.libmolMenu.removeAll();
        this.regulariseMenu.removeAll();
        this.viewLigandDataMenu.removeAll();
        this.deleteMenu.removeAll();
        this.findMenu.removeAll();
        this.viewLinkDataMenu.removeAll();
        GLib gLib = JLMain.currentPanel.gLib;
        for (Molecule molecule : gLib) {
            String string = molecule.key8;
            if (molecule.getResidue() == null) {
                int n = molecule.atoms.get((int)0).residue.cootId;
                if (n > 0) {
                    this.addCootLinkItem(string);
                } else {
                    if (n != 0) throw new NullPointerException();
                    this.addLinkItem(string);
                }
            } else {
                this.addCooItem(string);
            }
            this.addLigandItem(string);
        }
    }

    public void addLigandItem(String string) {
        String[] stringArray = new String[]{"Atoms", "Bonds", "Angles", "Torsions", "Chiralities", "Planes"};
        String[] stringArray2 = new String[]{"ATOMS ", "BONDS ", "ANGLES ", "TORSIONS ", "CHIRALITIES ", "PLANES "};
        JMenu jMenu = new JMenu(string);
        JMenuItem jMenuItem = null;
        for (int i = 0; i < 6; ++i) {
            jMenuItem = new JMenuItem(stringArray[i]);
            jMenuItem.addActionListener(this.listener);
            jMenuItem.setActionCommand(stringArray2[i] + string);
            jMenu.add(jMenuItem);
        }
        this.viewLigandDataMenu.add(jMenu);
        JMenuItem jMenuItem2 = new JMenuItem(string + " ...");
        jMenuItem2.addActionListener(this.listener);
        jMenuItem2.setActionCommand("SAVE_COMP " + string);
        this.saveCompMenu.add(jMenuItem2);
        JMenuItem jMenuItem3 = new JMenuItem(string + " ...");
        jMenuItem3.addActionListener(this.listener);
        jMenuItem3.setActionCommand("APPEND_COMP " + string);
        this.appendCompMenu.add(jMenuItem3);
        JMenuItem jMenuItem4 = new JMenuItem(string);
        jMenuItem4.addActionListener(this.listener);
        jMenuItem4.setActionCommand("LIBMOL " + string);
        this.libmolMenu.add(jMenuItem4);
        JMenuItem jMenuItem5 = new JMenuItem(string);
        jMenuItem5.addActionListener(this.listener);
        jMenuItem5.setActionCommand("REGULARISE " + string);
        this.regulariseMenu.add(jMenuItem5);
        JMenuItem jMenuItem6 = new JMenuItem(string + " ...");
        jMenuItem6.addActionListener(this.listener);
        jMenuItem6.setActionCommand("DELETE " + string);
        this.deleteMenu.add(jMenuItem6);
        JMenuItem jMenuItem7 = new JMenuItem(string + " ...");
        jMenuItem7.addActionListener(this.listener);
        jMenuItem7.setActionCommand("FIND_COMP " + string);
        this.findMenu.add(jMenuItem7);
    }

    public void addCooItem(String string) {
        JMenuItem jMenuItem = new JMenuItem(string + " ...");
        this.saveCooMenu.add(jMenuItem);
        jMenuItem.addActionListener(this.listener);
        jMenuItem.setActionCommand("SAVE_PDB " + string);
    }

    public void addLinkItem(String string) {
        JMenuItem jMenuItem = new JMenuItem(string);
        this.viewLinkDataMenu.add(jMenuItem);
        jMenuItem.addActionListener(this.listener);
        jMenuItem.setActionCommand("VIEW_LINK " + string);
        JMenuItem jMenuItem2 = new JMenuItem(string + " ...");
        jMenuItem2.addActionListener(this.listener);
        jMenuItem2.setActionCommand("SAVE_LINK " + string);
        this.saveLinkMenu.add(jMenuItem2);
        JMenuItem jMenuItem3 = new JMenuItem(string + " ...");
        jMenuItem3.addActionListener(this.listener);
        jMenuItem3.setActionCommand("APPEND_LINK " + string);
        this.appendLinkMenu.add(jMenuItem3);
    }

    public void addCootLinkItem(String string) {
        JMenuItem jMenuItem = new JMenuItem(string);
        jMenuItem.addActionListener(this.listener);
        jMenuItem.setActionCommand("SAVE_COOT_LINK " + string);
        this.saveCootLinkMenu.add(jMenuItem);
        JMenuItem jMenuItem2 = new JMenuItem(string);
        jMenuItem2.addActionListener(this.listener);
        jMenuItem2.setActionCommand("APPEND_COOT_LINK " + string);
        this.appendCootLinkMenu.add(jMenuItem2);
    }
}

