/*
 * Decompiled with CFR 0.152.
 */
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.Locale;
import javax.swing.AbstractButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.JToggleButton;
import javax.swing.SwingUtilities;

class JLigand
extends JFrame
implements ActionListener,
ItemListener {
    public static JLPanelCentre panelCentre;
    public static JToggleButton defaultOptionButton;
    public static JToggleButton choiceOptionButton;
    public static CootListener cootListener;

    public static void main(String[] stringArray) {
        Locale.setDefault(new Locale("en", "GB"));
        Env.init(stringArray);
        new JLigand();
    }

    public JLigand() {
        Object object;
        String string;
        JOptionPane jOptionPane = new JOptionPane(Versions.welcomeInfo(), 1);
        final JDialog jDialog = jOptionPane.createDialog(null, Versions.programInfo());
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                jDialog.setVisible(true);
            }
        });
        JLMain.mainFrame = this;
        if (Env.talkToCoot) {
            cootListener = new CootListener();
        }
        Toolkit toolkit = this.getToolkit();
        new MouseTracer(toolkit);
        new KeyTracer(toolkit);
        DialogWindows.initialise(toolkit.getScreenSize());
        try {
            Scratch.init();
        }
        catch (Exception exception) {
            if (Env.vbPrint) {
                exception.printStackTrace(System.err);
            }
            string = "Cannot create scratch directory";
            DialogWindows.showErrorDialog(string);
            System.exit(1);
        }
        try {
            StdLib.init();
        }
        catch (Exception exception) {
            if (Env.vbPrint) {
                exception.printStackTrace(System.err);
            }
            string = "Cannot parse the standard monomer library - please notify your system administrator";
            DialogWindows.showErrorDialog(string);
            System.exit(1);
        }
        try {
            Versions.init();
        }
        catch (Exception exception) {
            if (Env.vbPrint) {
                exception.printStackTrace(System.err);
            }
            DialogWindows.showErrorDialog(exception.getMessage());
            System.exit(1);
        }
        try {
            Libmol.init();
        }
        catch (Exception exception) {
            if (Env.vbPrint) {
                exception.printStackTrace(System.err);
            }
            DialogWindows.showErrorDialog(exception.getMessage());
            System.exit(1);
        }
        Runtime.getRuntime().addShutdownHook(new Thread(new Runnable(){

            public void run() {
                if (Libmol.isAvailable()) {
                    Libmol.finish();
                }
                if (!Env.vbScratch) {
                    Scratch.clear();
                }
                if (Env.vbPrint) {
                    System.err.println("FINISHED" + Env.bsn);
                }
            }
        }));
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent windowEvent) {
                System.exit(0);
            }
        });
        try {
            object = "LYS";
            boolean bl = false;
            StdLib.get((String)object, bl);
        }
        catch (Exception exception) {
            if (Env.vbPrint) {
                exception.printStackTrace(System.err);
            }
            DialogWindows.showErrorDialog(exception.getMessage());
            System.exit(1);
        }
        this.setSize(DialogWindows.windowWidth, DialogWindows.windowHeight);
        this.setLocation(DialogWindows.locationLeft, DialogWindows.locationTop);
        this.setJMenuBar(new JLMenuBar(this));
        object = new JLPanelNorth(this);
        JLPanelWest jLPanelWest = new JLPanelWest(this);
        panelCentre = new JLPanelCentre();
        panelCentre.addTab();
        Container container = this.getContentPane();
        container.setLayout(new BorderLayout());
        container.add((Component)panelCentre, "Center");
        container.add((Component)object, "North");
        container.add((Component)jLPanelWest, "West");
        this.setTitle(Versions.programInfo());
        this.setVisible(true);
        if (jDialog.isVisible()) {
            jDialog.setVisible(true);
        }
        JLMain.currentPanel.resetPanel();
        if (Env.talkToCoot) {
            cootListener.run();
        }
    }

    void actionAbout() {
        DialogWindows.showInformationDialog(Versions.aboutInfo());
    }

    void actionQuit() {
        int n = JOptionPane.showConfirmDialog(this, "Really Quit?", "Quit JLigand", 0);
        if (n == 0) {
            System.exit(0);
        }
    }

    public void actionPerformed(ActionEvent actionEvent) {
        String[] stringArray = actionEvent.getActionCommand().trim().split(" +");
        String string = stringArray[0];
        String string2 = null;
        if (stringArray.length == 2) {
            string2 = stringArray[1];
        }
        if (string.equals("OPTION")) {
            JLMain.option = string2;
        } else if (string.equals("ABOUT")) {
            this.actionAbout();
        } else if (string.equals("QUIT")) {
            this.actionQuit();
        } else if (string.equals("TAB_NEW")) {
            panelCentre.addTab();
        } else if (string.equals("TAB_DELETE")) {
            panelCentre.deleteTab();
        } else if (string.equals("TAB_CLEAR")) {
            JLMain.actionClear();
        } else if (string.equals("FILE_LIB")) {
            JLMain.actionReadLib(true);
        } else if (string.equals("FILE_PDB")) {
            JLMain.actionReadPDB(true);
        } else if (string.equals("FILE_SDF")) {
            JLMain.actionReadSDF(true);
        } else if (string.equals("FILE_MOL")) {
            JLMain.actionReadMOL(true);
        } else if (string.equals("ENTER_SMILE")) {
            JLMain.actionEnterSmile();
        } else if (string.equals("FILE_LIB_ASIS")) {
            JLMain.actionReadLib(false);
        } else if (string.equals("FILE_PDB_ASIS")) {
            JLMain.actionReadPDB(false);
        } else if (string.equals("FILE_SDF_ASIS")) {
            JLMain.actionReadSDF(false);
        } else if (string.equals("FILE_MOL_ASIS")) {
            JLMain.actionReadMOL(false);
        } else if (string.equals("SAVE_COMP")) {
            JLMain.actionSave("SAVE", "COMP", string2, false);
        } else if (string.equals("SAVE_LINK")) {
            JLMain.actionSave("SAVE", "LINK", string2, false);
        } else if (string.equals("APPEND_COMP")) {
            JLMain.actionSave("APPEND", "COMP", string2, false);
        } else if (string.equals("APPEND_LINK")) {
            JLMain.actionSave("APPEND", "LINK", string2, false);
        } else if (string.equals("SAVE_COOT_LINK")) {
            JLMain.actionSave("SAVE", "LINK", string2, true);
        } else if (string.equals("APPEND_COOT_LINK")) {
            JLMain.actionSave("APPEND", "LINK", string2, true);
        } else if (string.equals("SAVE_PDB")) {
            JLMain.actionSavePdb(string2);
        } else if (string.equals("LIBMOL")) {
            JLMain.actionRegularise(string2, true);
        } else if (string.equals("REGULARISE")) {
            JLMain.actionRegularise(string2, false);
        } else if (string.equals("DELETE")) {
            JLMain.actionDelete(string2);
        } else if (string.equals("FIND_COMP")) {
            JLMain.actionFind(string2);
        } else if (string.equals("ATOMS")) {
            JLMain.actionViewTable(string, string2);
        } else if (string.equals("BONDS")) {
            JLMain.actionViewTable(string, string2);
        } else if (string.equals("ANGLES")) {
            JLMain.actionViewTable(string, string2);
        } else if (string.equals("TORSIONS")) {
            JLMain.actionViewTable(string, string2);
        } else if (string.equals("CHIRALITIES")) {
            JLMain.actionViewTable(string, string2);
        } else if (string.equals("PLANES")) {
            JLMain.actionViewTable(string, string2);
        } else if (string.equals("VIEW_LINK")) {
            JLMain.actionViewLinkFile(string2);
        } else if (string.equals("PERIODIC_TABLE")) {
            DialogWindows.periodicTableDialog.showDialog();
        } else if (string.equals("VIEW_FILE")) {
            JLMain.actionViewFile();
        } else if (string.equals("HELP_JLIGAND")) {
            DialogWindows.helpJLigand.showDialog();
        } else if (string.equals("HELP_MOUSE")) {
            DialogWindows.helpJLigandMouse.showDialog();
        } else if (string.equals("HELP_KEYPAD")) {
            DialogWindows.helpJLigandKeypad.showDialog();
        } else if (string.equals("LIGAND_NEW")) {
            JLMain.actionNewLigand();
        } else if (string.equals("LIGAND_ID")) {
            JLMain.actionLoadLigand(string2);
        } else if (string.equals("LIGAND_SEARCH")) {
            JLMain.actionLoadLigand();
        } else if (string.equals("CHECK_CHEM")) {
            JLMain.actionCheckChemistry();
        } else if (string.equals("CHECK_BONDS")) {
            JLMain.actionCorrectBonds();
        } else if (string.equals("UNDO")) {
            JLMain.actionUndo();
        } else if (string.equals("REDO")) {
            JLMain.actionRedo();
        } else {
            throw new NullPointerException();
        }
        JLMain.currentPanel.resetPanel();
    }

    public void itemStateChanged(ItemEvent itemEvent) {
        AbstractButton abstractButton = (AbstractButton)itemEvent.getItem();
        String string = abstractButton.getActionCommand();
        if (string.equals("SHOW_IDS")) {
            JLMain.showNames = abstractButton.isSelected();
        } else if (string.equals("SHOW_HYDROGENS")) {
            JLMain.showHydrogens = abstractButton.isSelected();
        } else if (string.equals("SHOW_CHARGES")) {
            JLMain.showCharges = abstractButton.isSelected();
        } else {
            throw new NullPointerException();
        }
        defaultOptionButton.doClick();
        JLMain.currentPanel.requestFocusInWindow();
    }
}

