/*
 * Decompiled with CFR 0.152.
 */
import java.io.BufferedReader;
import java.io.File;
import java.io.FileWriter;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;

class Libmol {
    private static boolean available = false;
    private static String prgName = "libmol";
    private static String comName = "com";
    private static String logName = "log";
    private static String inpName = "inp.lib";
    private static String outName = "out.lib";
    private static String pdbName = "out.pdb";
    private static String cmd;
    private static OutputStreamWriter osw;
    private static BufferedReader br;
    private static String fmt;

    Libmol() {
    }

    public static void init() {
        cmd = Env.windows ? prgName + ".exe" : prgName;
        available = false;
        try {
            Process process = new ProcessBuilder(cmd, "-jligand").start();
            osw = new OutputStreamWriter(process.getOutputStream());
            br = new BufferedReader(new InputStreamReader(process.getInputStream()));
        }
        catch (Exception exception) {
            return;
        }
        available = true;
        fmt = Env.bsn + "RUN_BEGIN";
        fmt = fmt + Env.bsn + "LIBIN %s";
        fmt = fmt + Env.bsn + "MON %s";
        fmt = fmt + Env.bsn + "LIBOUT %s";
        fmt = fmt + Env.bsn + "XYZOUT %s";
        fmt = fmt + Env.bsn + "RUN_END" + Env.bsn;
    }

    public static boolean isAvailable() {
        return available;
    }

    public static File execute(CharArray charArray, String string) {
        File file = Scratch.getWrkDir();
        File file2 = new File(file, inpName);
        File file3 = new File(file, outName);
        File file4 = new File(file, pdbName);
        try {
            charArray.writeTo(file2);
            osw.write(String.format(fmt, file2.getPath(), string, file3.getPath(), file4.getPath()));
            osw.flush();
            FileWriter fileWriter = new FileWriter(new File(file, logName));
            String string2 = "";
            while (!string2.equals("RUN_END")) {
                string2 = br.readLine();
                fileWriter.write(string2 + Env.bsn);
            }
            fileWriter.close();
            fileWriter = new FileWriter(new File(file, comName));
            fileWriter.write("#!/bin/tcsh -f" + Env.bsn + Env.bsn);
            fileWriter.write(cmd + " >! " + logName + " <<+" + Env.bsn);
            fileWriter.write(String.format(fmt, inpName, string, outName, pdbName));
            fileWriter.write("END" + Env.bsn);
            fileWriter.write("+" + Env.bsn + Env.bsn);
            fileWriter.close();
            if (!file3.isFile()) {
                throw new NullPointerException();
            }
            return file3;
        }
        catch (Exception exception) {
            if (Env.vbPrint) {
                exception.printStackTrace(System.err);
            }
            throw new NullPointerException();
        }
    }

    public static void finish() {
        try {
            osw.write(Env.bsn + "END" + Env.bsn);
            osw.close();
            br.close();
        }
        catch (Exception exception) {
            if (Env.vbPrint) {
                exception.printStackTrace(System.err);
            }
            throw new NullPointerException();
        }
    }
}

