/*
 * Decompiled with CFR 0.152.
 */
import java.io.File;
import java.io.InputStream;
import java.util.LinkedHashMap;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class MonLib
extends LinkedHashMap<String, MonomerHeader> {
    private final File srcDir;
    private final File monDir;
    private final File monList;
    private final String listHead;
    private final String listTail;
    public final String CLIBD_MON;

    MonLib() throws Exception {
        Object object;
        this.monDir = new File(Env.monDirName).getCanonicalFile();
        this.srcDir = null;
        this.CLIBD_MON = new File(this.monDir, " ").toString().trim();
        File file = new File(this.monDir, "list");
        this.monList = new File(file, "mon_lib_list.cif");
        CharArray charArray = new CharArray(this.monList);
        CifFile cifFile = new CifFile(charArray);
        CifData cifData = (CifData)cifFile.get("data_comp_list");
        CifLoop cifLoop = cifData.iterator().next();
        while (cifLoop.hasNext()) {
            object = new MonomerHeader(cifLoop);
            if (super.put(((MonomerHeader)object).key8, object) == null) continue;
            throw new NullPointerException();
        }
        this.listHead = ((Object)charArray.subSequence(0, cifData.first)).toString();
        object = new CharArray();
        for (Map.Entry entry : cifFile.entrySet()) {
            cifData = (CifData)entry.getValue();
            if (!((String)entry.getKey()).startsWith("data_mod_")) continue;
            ((CharArray)object).append(charArray.subSequence(cifData.first, cifData.last));
        }
        this.listTail = ((CharArray)object).toString();
    }

    MonLib(MonLib monLib) throws Exception {
        this.monDir = Scratch.getWrkDir();
        this.srcDir = monLib.monDir;
        this.CLIBD_MON = new File(this.monDir, " ").toString().trim();
        File file = new File(this.monDir, "list");
        file.mkdir();
        this.monList = new File(file, "mon_lib_list.cif");
        this.listHead = monLib.listHead.toString();
        this.listTail = monLib.listTail.toString();
        InputStream inputStream = this.getClass().getResourceAsStream("resources/mon_lib_ind.cif");
        new CharArray(inputStream).writeTo(new File(this.monDir, "mon_lib_ind.cif"));
        inputStream = this.getClass().getResourceAsStream("resources/mon_lib_ind2.cif");
        new CharArray(inputStream).writeTo(new File(this.monDir, "mon_lib_ind2.cif"));
        File file2 = new File(this.srcDir, "ener_lib.cif");
        new CharArray(file2).writeTo(new File(this.monDir, "ener_lib.cif"));
        this.writeMonList();
    }

    Version getVersion() {
        return new Version(this.listHead);
    }

    void toBuffer(CharArray charArray) {
        CifData cifData = (CifData)CifFile.template.get("data_comp_list");
        CifLoop cifLoop = cifData.iterator().next();
        for (MonomerHeader monomerHeader : this.values()) {
            monomerHeader.toCif(cifLoop);
        }
        charArray.append("data_comp_list");
        cifData.appendTo(charArray);
        cifData.clear();
        charArray.append(Env.bsn);
    }

    private void writeMonList() {
        CharArray charArray = new CharArray(this.listHead);
        this.toBuffer(charArray);
        charArray.append(this.listTail);
        charArray.writeTo(this.monList);
    }

    @Override
    public void clear() {
        if (this.srcDir == null) {
            throw new NullPointerException();
        }
        super.clear();
        try {
            this.writeMonList();
        }
        catch (Exception exception) {
            throw new NullPointerException();
        }
    }

    File getFile(String string) {
        return new File(new File(this.monDir, string.substring(0, 1).toLowerCase()), string + ".cif");
    }

    private void copyFile(String string) throws Exception {
        String string2 = string.substring(0, 1).toLowerCase();
        File file = new File(new File(this.srcDir, string2), string + ".cif");
        File file2 = new File(this.monDir, string2);
        if (!file2.exists()) {
            file2.mkdir();
        }
        File file3 = new File(file2, string + ".cif");
        new CharArray(file).writeTo(file3);
    }

    @Override
    public MonomerHeader put(String string, MonomerHeader monomerHeader) {
        if (this.srcDir == null) {
            throw new NullPointerException();
        }
        monomerHeader = super.put(string, monomerHeader);
        try {
            this.writeMonList();
            this.copyFile(string);
        }
        catch (Exception exception) {
            super.remove(string);
            throw new NullPointerException();
        }
        return monomerHeader;
    }
}

