/*
 * Decompiled with CFR 0.152.
 */
import java.io.File;
import java.io.FileWriter;
import java.io.Writer;

class PdbWriter {
    String bsn = Env.bsn;
    String atomFormat = "ATOM  %5d %-4s %-3s A   1    %8.3f%8.3f%8.3f  1.00 20.00 %11s" + this.bsn;
    String crystFormat = "CRYST1  100.000  100.000  100.000  90.00  90.00  90.00 P 1" + this.bsn;
    String modresFormat = "MODRES      %-3s A    1  %-8s                                        RENAME" + this.bsn;

    PdbWriter() {
    }

    void write(Monomer monomer, File file, boolean bl) {
        try {
            FileWriter fileWriter = new FileWriter(file);
            if (!monomer.key3.equals(monomer.key8)) {
                fileWriter.write(String.format(this.modresFormat, monomer.key3, monomer.key8));
            }
            fileWriter.write(this.crystFormat);
            int n = 0;
            for (Atom atom : monomer.atoms) {
                if (!bl && atom.symbol.equals("H")) continue;
                String string = atom.symbol.toUpperCase();
                String string2 = atom.key4;
                if (string.length() != 2 && string2.length() != 4) {
                    string2 = " " + string2;
                }
                fileWriter.write(String.format(this.atomFormat, ++n, string2, monomer.key3, atom.xyz[0], atom.xyz[1], atom.xyz[2], string));
            }
            ((Writer)fileWriter).close();
        }
        catch (Exception exception) {
            throw new NullPointerException();
        }
    }
}

