/*
 * Decompiled with CFR 0.152.
 */
import java.io.File;

class Refmac {
    private static final String xyzin = "input.pdb";
    private static final String libin = "input.lib";
    private static final String xyzout = "output.pdb";
    private static final String comName = "refmac.com";
    private static final String logName = "refmac.log";

    Refmac() {
    }

    static Version getVersion() {
        File file = Scratch.getWrkDir();
        ProcessWrapper processWrapper = new ProcessWrapper("refmac5");
        processWrapper.keywords("end");
        try {
            processWrapper.execute(file, comName, logName);
            return new Version(new CharArray(new File(file, logName)).toString());
        }
        catch (Exception exception) {
            if (Env.vbPrint) {
                exception.printStackTrace(System.err);
            }
            throw new NullPointerException("cannot run refmac");
        }
    }

    void refine(Monomer monomer) {
        File file = Scratch.getWrkDir();
        ProcessWrapper processWrapper = new ProcessWrapper("refmac5");
        processWrapper.args("libin", libin, "xyzin", xyzin, "xyzout", xyzout);
        processWrapper.keywords("make", "hout", "yes");
        processWrapper.keywords("mode", "newentry");
        processWrapper.keywords("end");
        CifLib cifLib = new CifLib();
        cifLib.add(monomer);
        cifLib.toBuffer().writeTo(new File(file, libin));
        new PdbWriter().write(monomer, new File(file, xyzin), true);
        processWrapper.setenv("CLIBD_MON", StdLib.shortHeaderMap.CLIBD_MON);
        processWrapper.setInfo("   Refmac:   %-4s %-11s ...  %-3s  ...  ", file.getName(), libin, monomer.key8);
        processWrapper.execute(file, comName, logName);
        new PdbReader().read(monomer, new File(file, xyzout));
    }
}

