/*
 * Decompiled with CFR 0.152.
 */
abstract class Versions {
    private static String bsn = System.getProperty("line.separator");
    private static String authors = "Andrey Lebedev, Paul Young, Alexei Vagin, Garib Murshudov";
    private static String eMail = "andrey.lebedev@stfc.ac.uk";
    private static String version = Env.version;
    private static String versionDate = Env.versionDate;
    private static Version requiredLibrary;
    private static Version requiredLibcheck;
    private static Version requiredRefmac;
    private static Version currentLibrary;
    private static Version currentLibcheck;
    private static Version currentRefmac;

    Versions() {
    }

    static void init() {
        requiredLibrary = new Version("5.28");
        requiredLibcheck = new Version("5.1.14");
        requiredRefmac = new Version("5.6.0116");
        currentLibrary = StdLib.getVersion();
        currentLibcheck = Libcheck.getVersion();
        currentRefmac = Refmac.getVersion();
    }

    static String programInfo() {
        return "JLigand " + version;
    }

    static String welcomeInfo() {
        return bsn + "Please wait, Jligand is reading library" + bsn + bsn + "Please also note that the loading and regularisation" + bsn + "of ligands can take several seconds to complete." + bsn + bsn;
    }

    static String aboutInfo() {
        return bsn + "JLigand " + version + " - " + versionDate + bsn + bsn + "Recommended external components:" + bsn + "libcheck " + requiredLibcheck.getVersion() + ", " + "refmac " + requiredRefmac.getVersion() + ", " + "dictionary " + requiredLibrary.getVersion() + " or newer." + bsn + bsn + "Found:" + bsn + "libcheck " + currentLibcheck.getVersion() + ", " + "refmac " + currentRefmac.getVersion() + ", " + "dictionary " + currentLibrary.getVersion() + bsn + bsn;
    }

    private static String versionAndDate(String string, Version version) {
        String string2 = "%-11s %-7s ( %10s )";
        return String.format(string2, string, version.getVersion(), version.getDate());
    }

    static String cifHeaderInfo() {
        String string = "%-17s %s";
        return "# Created using " + Versions.programInfo() + bsn + "# and" + bsn + "# " + Versions.versionAndDate("dictionary", currentLibrary) + bsn + "# " + Versions.versionAndDate("libcheck", currentLibcheck) + bsn + "# " + Versions.versionAndDate("refmac", currentRefmac) + bsn + "#" + bsn + "# Authors: " + authors + bsn + "# E-mail: " + eMail + bsn + "#" + bsn + bsn + "global_" + bsn + String.format(string, "_lib_name", "mon_lib") + bsn + String.format(string, "_lib_version", currentLibrary.getVersion()) + bsn + String.format(string, "_lib_update", currentLibrary.getDate()) + bsn + bsn;
    }

    private static String currentAndRequired(String string, Version version, Version version2) {
        String string2 = " + ";
        if (version.isOlderThan(version2)) {
            string2 = " - ";
        }
        string2 = string2 + "%-16s  %-11s  %s";
        return String.format(string2, string, version.getVersion(), version2.getVersion());
    }

    static String printedInfo() {
        return "   component         current      required" + bsn + bsn + Versions.currentAndRequired("dictionary", currentLibrary, requiredLibrary) + bsn + Versions.currentAndRequired("libcheck", currentLibcheck, requiredLibcheck) + bsn + Versions.currentAndRequired("refmac", currentRefmac, requiredRefmac) + bsn;
    }

    static boolean enableSearch() {
        if (Env.enableSearch) {
            return true;
        }
        if (currentLibrary.isOlderThan(new Version("5.28"))) {
            return false;
        }
        return !currentLibcheck.isOlderThan(new Version("5.1.14"));
    }
}

