/**
 * 
 */
package gui;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;


/**
 * @author Kerry White
 *Generates a prm file from the information included in the mol2 and reference ligand files
 */
public class File_Generator {
	
	private String filename2,filename3;
	File output;
	
	public File_Generator(String f2,String f3,File o){
		//filename1=f1;
		filename2=f2;
		filename3=f3;
		output=o;
	}

	public File generate(){
		File temp=new File("cavity_generation_template.prm");
		File mol2=new File(filename2);
		try{
			BufferedReader p = new BufferedReader(new FileReader(mol2));
			while (!p.readLine().equals("@<TRIPOS>MOLECULE"));
			String header = p.readLine().trim();
			BufferedReader input = new BufferedReader(new FileReader(temp));
			BufferedWriter out = new BufferedWriter(new FileWriter(output));
			String text;
			while((text = input.readLine()) != null){
				if(text.startsWith("TITLE"))
					text="TITLE "+header;
				else if(text.startsWith("RECEPTOR_FILE"))
					text="RECEPTOR_FILE "+filename2;
				else if(text.startsWith("        REF_MOL"))
					text="REF_MOL "+filename3;
				out.write(text +"\n");
			}
			out.close();
			input.close();
		}
		catch(IOException ioException){
			
		}
		System.out.println(output.toString());
		return output;
	}
	
}
