package gui;

import java.io.File;


import javax.swing.filechooser.FileFilter;

/**
 * Class that provides a file filter for Mol2 files - it extends FileFilter
 * @author Kerry White
 *
 */
public class Mol2FileFilter extends FileFilter {

	public Mol2FileFilter() {
		super();
	
	}

	/* (non-Javadoc)
	 * @see javax.swing.filechooser.FileFilter#accept(java.io.File)
	 */
	public boolean accept(File f) {
		if (f.isDirectory()) {
           return true;
       }
		String extension = Utils.getExtension(f);
       if (extension != null) {
           if (extension.equals(Utils.mol2) )
                   return true;
           } else {
               return false;
           }
       
		return false;
	}

	/* (non-Javadoc)
	 * @see javax.swing.filechooser.FileFilter#getDescription()
	 */
	public String getDescription() {

		return "Just mol2 files";
	}
	
}
