package gui;





import java.io.File;

import javax.swing.filechooser.FileFilter;

/**
* @author Kerry White
* filters the files so only directories and files ending in .pdb are dispalyed in the file chooser dialog
*/
public class PdbFileFilter extends FileFilter{


	
	
	public PdbFileFilter() {
		super();
	
	}

	/* (non-Javadoc)
	 * @see javax.swing.filechooser.FileFilter#accept(java.io.File)
	 */
	public boolean accept(File f) {
		if (f.isDirectory()) {
           return true;
       }
		String extension = Utils.getExtension(f);
       if (extension != null) {
           if (extension.equals(Utils.pdb) )
                   return true;
           } else {
               return false;
           }
       
		return false;
	}

	/* (non-Javadoc)
	 * @see javax.swing.filechooser.FileFilter#getDescription()
	 */
	public String getDescription() {

		return "Just PDB files";
	}

}
