package gui;

import java.io.File;

import javax.swing.filechooser.FileFilter;

/**
 * filters files so only those with the .sd extension are available to thr file chooser dialogue
 * @author Kerry White
 *
 */
public class SdFileFilter extends FileFilter {

	


	

		public SdFileFilter() {
			super();
		
		}

		/* (non-Javadoc)
		 * @see javax.swing.filechooser.FileFilter#accept(java.io.File)
		 */
		public boolean accept(File f) {
			if (f.isDirectory()) {
	           return true;
	       }
			String extension = Utils.getExtension(f);
	       if (extension != null) {
	           if (extension.equals(Utils.sd) )
	                   return true;
	           } else {
	               return false;
	           }
	       
			return false;
		}

		/* (non-Javadoc)
		 * @see javax.swing.filechooser.FileFilter#getDescription()
		 */
		public String getDescription() {

			return "Just sd files";
		}
}
