package gui;

import java.io.File;

import javax.swing.filechooser.FileFilter;

/**
 * Filters files so that only files with the .prm extension are available to the file chooser dialogue
 * @author Kerry White
 *
 */
public class PrmFileFilter extends FileFilter{

	public PrmFileFilter() {
		super();
	
	}

	/* (non-Javadoc)
	 * @see javax.swing.filechooser.FileFilter#accept(java.io.File)
	 */
	public boolean accept(File f) {
		if (f.isDirectory()) {
           return true;
       }
		String extension = Utils.getExtension(f);
       if (extension != null) {
           if (extension.equals(Utils.prm) )
                   return true;
           } else {
               return false;
           }
       
		return false;
	}

	/* (non-Javadoc)
	 * @see javax.swing.filechooser.FileFilter#getDescription()
	 */
	public String getDescription() {

		return "Just prm files";
	}
	
}
