package gui;

import java.awt.Component;
import java.awt.Container;
import java.awt.FlowLayout;
import java.awt.Graphics;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.Color;
import java.io.File;
import java.io.IOException;

import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JTabbedPane;
import javax.swing.JTextField;

/**
 * Class to make a gui for the rDock program
 * @author Kerry White
 *
 */
public class Main_gui extends JFrame{

	private Graphics g;
	//declare all private global variables - they can be accessed by anything in this class or internal classes
	private JPanel jp1_1,jp2_1,jp3_1,jp5_1,jp6_1,jp1, jp2,jpa;
	private JButton pdbBrowse, mol2Browse, refBrowse, docBrowse, createCavity, runButton;
	private JButton pdbView,mol2View, refView, docView, check_file,convert;
	private JButton directory, view_results;
	private JLabel pdbLabel, mol2Label, refLabel, dockLabel,protocolLabel,nrLabel, opLabel;
	private JLabel pdbText, mol2Text, refText, dockText,dirText;
	private JTextField  nrText, opText;
	private String filename, filename2, filename3, filename4, filename5, output,dir,dir_full;
	private String filename_full, filename2_full, filename3_full, filename4_full, filename5_full, output_full;
	private GridBagLayout layout;
	private GridBagConstraints constraints;
	private Container container;
	private int numRuns;
	private JTabbedPane tp;
	private ImageIcon logo;
	private  JLabel img,dirLabel;
	private File o;
	private JSeparator sep,sep2,sep3,sep4,sep5,sep6,sep7,sep8,sep9;
	private JComboBox combo;
    private String gui_path,protocol_path;
    private PathHandler ph;
    private Path_fixer pf;
    private JButton set1,set2;



	/**
	 * Construcor - sets up the gui
	 *
	 */
	public Main_gui(){

		super("rDock GUI");

		Color color=new Color(176,226,255);

		ph=new PathHandler();
		pf=new Path_fixer();
		gui_path=ph.getGp();
		protocol_path=ph.getDp();

		//set up the main gui container that everythin gets added to
		container = getContentPane();
		layout = new GridBagLayout();
		jpa=new JPanel();
		jpa.setLayout(new FlowLayout(FlowLayout.LEFT));
		jpa.setBackground(color);
		jp1 = new JPanel();
		jp1.setLayout(layout);
		jp1.setBackground(color);
		jp2 = new JPanel();
		jp2.setLayout(layout);
		jp2.setBackground(color);
		constraints = new GridBagConstraints();		
		logo=new ImageIcon(gui_path+"/rdock2.jpg");

		

		//------------------------tab 1-----------------------------------------------------
		//-----------------------------------------------------------------------------------
		img=new JLabel();
		img.setIcon(logo);
		jpa.add(img);

		directory=new JButton("browse");
		directory.setToolTipText("Working directory");
		DirectoryHandler dh = new DirectoryHandler();
		directory.addActionListener(dh);

		dirText = new JLabel();
		dirLabel = new JLabel("Working directory");

		constraints.insets = new Insets(2,2,2,2);

		sep=new JSeparator(JSeparator.HORIZONTAL);
		sep2=new JSeparator(JSeparator.HORIZONTAL);
		sep3=new JSeparator(JSeparator.HORIZONTAL);
		sep4=new JSeparator(JSeparator.HORIZONTAL);
		sep5=new JSeparator(JSeparator.HORIZONTAL);
		sep6=new JSeparator(JSeparator.HORIZONTAL);
		sep7=new JSeparator(JSeparator.HORIZONTAL);
		sep8=new JSeparator(JSeparator.HORIZONTAL);
		sep9=new JSeparator(JSeparator.HORIZONTAL);

		//-----------------------------------------------------------------------------
		constraints.fill = GridBagConstraints.BOTH;
		addComponent(jp1,img,0,0,1,1);

		constraints.fill = GridBagConstraints.BOTH;
		addComponent(jp1,dirLabel,1,0,1,1);
		constraints.fill = GridBagConstraints.BOTH;
		addComponent(jp1,directory,1,2,1,1);

		constraints.fill = GridBagConstraints.BOTH;
		addComponent(jp1,dirText,1,1,1,1);
		
		constraints.fill = GridBagConstraints.BOTH;
		addComponent(jp1,sep9,2,0,3,1);
		
		pdbLabel = new JLabel("pdb file");
		pdbLabel.setToolTipText("Please enter the location of pdb file that you wish to use");

		pdbText = new JLabel();

		jp1_1=new JPanel();
		jp1_1.setLayout(new GridLayout(2,1,5,5));
		jp1_1.setBackground(color);

		pdbBrowse=new JButton("Browse..");
		pdbBrowse.setToolTipText("browse for file");
		jp1_1.add(pdbBrowse);
		PdbButtonHandler handler = new PdbButtonHandler();
		pdbBrowse.addActionListener(handler);

		pdbView=new JButton("View");
		pdbView.setToolTipText("View file");
		pdbView.setEnabled(false);
		jp1_1.add(pdbView);
		PdbViewHandler pvh = new PdbViewHandler();
		pdbView.addActionListener(pvh);

		constraints.fill = GridBagConstraints.BOTH;
		addComponent(jp1,pdbLabel,3,0,1,1);

		constraints.fill = GridBagConstraints.BOTH;
		addComponent(jp1,pdbText,3,1,1,1);

		constraints.fill = GridBagConstraints.BOTH;
		addComponent(jp1,jp1_1,3,2,1,1);

		constraints.fill = GridBagConstraints.BOTH;
		//constraints.gridwidth=GridBagConstraints.REMAINDER;
		addComponent(jp1,sep,4,0,3,1);

		//----------------------------------------------------------------------
		check_file=new JButton("Check file");
		check_file.setToolTipText("Check file");
		check_file.setEnabled(false);
		Check_fileButtonHandler cf = new Check_fileButtonHandler();
		check_file.addActionListener(cf);

		convert=new JButton("Convert");
		convert.setToolTipText("Convert");
		convert.setEnabled(false);
		ConvertButtonHandler co = new ConvertButtonHandler();
		convert.addActionListener(co);

		constraints.gridwidth=1;
		constraints.fill = GridBagConstraints.BOTH;
		addComponent(jp1,check_file,5,0,1,1);
		constraints.fill = GridBagConstraints.BOTH;
		addComponent(jp1,convert,5,1,1,1);

		constraints.fill = GridBagConstraints.BOTH;
		addComponent(jp1,sep2,6,0,3,1);
		//----------------------------------------------------------------------
		mol2Label = new JLabel("mol2 file");
		mol2Label.setToolTipText("Please enter the location of the mol2 file that you wish to use");

		mol2Text = new JLabel();

		jp2_1=new JPanel();
		jp2_1.setLayout(new GridLayout(2,1,5,5));
		jp2_1.setBackground(color);		

		mol2Browse=new JButton("Browse..");
		mol2Browse.setToolTipText("browse for file");
		jp2_1.add(mol2Browse);
		Mol2ButtonHandler handler2 = new Mol2ButtonHandler();
		mol2Browse.addActionListener(handler2);

		mol2View=new JButton("View");
		mol2View.setToolTipText("View file");
		mol2View.setEnabled(false);
		jp2_1.add(mol2View);
		Mol2ViewHandler mvh = new Mol2ViewHandler();
		mol2View.addActionListener(mvh);

		constraints.fill = GridBagConstraints.BOTH;
		addComponent(jp1,mol2Label,7,0,1,1);

		constraints.fill = GridBagConstraints.BOTH;
		addComponent(jp1,mol2Text,7,1,1,1);

		constraints.fill = GridBagConstraints.BOTH;
		addComponent(jp1,jp2_1,7,2,1,1);

		constraints.fill = GridBagConstraints.BOTH;
		addComponent(jp1,sep3,8,0,3,1);
		//--------------------------------------------------------------------------------
		refLabel = new JLabel("Reference Ligand");
		refLabel.setToolTipText("Please enter the location of the reference ligand file that you wish to use");

		refText = new JLabel();

		jp3_1=new JPanel();
		jp3_1.setLayout(new GridLayout(2,1,5,5));
		jp3_1.setBackground(color);

		refBrowse=new JButton("Browse..");
		refBrowse.setToolTipText("browse for file");
		jp3_1.add(refBrowse);
		RefButtonHandler handler3 = new RefButtonHandler();
		refBrowse.addActionListener(handler3);

		refView=new JButton("View");
		refView.setToolTipText("View file");
		refView.setEnabled(false);
		jp3_1.add(refView);
		RefViewHandler rvh = new RefViewHandler();
		refView.addActionListener(rvh);

		constraints.fill = GridBagConstraints.BOTH;
		addComponent(jp1,refLabel,9,0,1,1);

		constraints.fill = GridBagConstraints.BOTH;
		addComponent(jp1,refText,9,1,1,1);

		constraints.fill = GridBagConstraints.BOTH;
		addComponent(jp1,jp3_1,9,2,1,1);

		constraints.fill = GridBagConstraints.BOTH;
		addComponent(jp1,sep4,10,0,3,1);
		//----------------------------------------------------------------------
		createCavity=new JButton("Create Cavity");
		createCavity.setToolTipText("Create a Cavity");
		createCavity.setMnemonic('C');
		createCavity.setEnabled(false);
		CavityButtonHandler handlerCav = new CavityButtonHandler();
		createCavity.addActionListener(handlerCav);

		constraints.fill = GridBagConstraints.BOTH;
		addComponent(jp1,createCavity,11,1,1,1);


		constraints.fill = GridBagConstraints.BOTH;
		addComponent(jp1,sep5,12,0,3,1);
		//----------------------------------------------------------------------------
		dockLabel = new JLabel("Molecule to dock");
		dockLabel.setToolTipText("Please enter the location of the molecule to dock");

		dockText = new JLabel();

		jp5_1=new JPanel();
		jp5_1.setLayout(new GridLayout(2,1,5,5));
		jp5_1.setBackground(color);

		docBrowse=new JButton("Browse..");
		docBrowse.setToolTipText("browse for file");
		jp5_1.add(docBrowse);
		DocButtonHandler handler4 = new DocButtonHandler();
		docBrowse.addActionListener(handler4);	   
		
		docView=new JButton("View");
		docView.setToolTipText("View file");
		docView.setEnabled(false);
		jp5_1.add(docView);
		DocViewHandler dvh = new DocViewHandler();
		docView.addActionListener(dvh);

		constraints.fill = GridBagConstraints.BOTH;
		addComponent(jp1,dockLabel,13,0,1,1);

		constraints.fill = GridBagConstraints.BOTH;
		addComponent(jp1,dockText,13,1,1,1);

		constraints.fill = GridBagConstraints.BOTH;
		addComponent(jp1,jp5_1,13,2,1,1);


		constraints.fill = GridBagConstraints.BOTH;
		addComponent(jp1,sep6,14,0,3,1);
		//--------------------------------------------------------------------------
		protocolLabel = new JLabel("docking protocol");
		protocolLabel.setToolTipText("Please enter the location of the dpcking protocol");

		jp6_1=new JPanel();
		jp6_1.setLayout(new GridLayout(2,1,5,5));
		jp6_1.setBackground(color);

		//String[] items={"dock.prm"}; 
		ProtocolList pl = new ProtocolList(protocol_path);
		String[] items=pl.getList(); 
		combo=new JComboBox();
		combo.addItem("");
		for(int i=0;i<items.length;i++)
			combo.addItem(items[i]);
		ComboHandler c= new ComboHandler();
		combo.addActionListener(c);

		constraints.fill = GridBagConstraints.BOTH;
		addComponent(jp1,protocolLabel,15,0,1,1);

		constraints.fill = GridBagConstraints.BOTH;
		addComponent(jp1,combo,15,1,1,1);

		constraints.fill = GridBagConstraints.BOTH;
		addComponent(jp1,sep8,16,0,3,1);
		//--------------------------------------------------------------------------
		nrLabel=new JLabel("Number of runs");
		nrLabel.setToolTipText("plese enter the number of runs");

		nrText = new JTextField();
		nrHandler nr = new nrHandler();
		nrText.addActionListener(nr);

		set1= new JButton("Set number");
		set1.setToolTipText("Set the number of runs to be that which you've just entered");
		Set1Handler s1 = new Set1Handler();
		set1.addActionListener(s1);
		
		constraints.fill = GridBagConstraints.BOTH;
		addComponent(jp1,nrLabel,17,0,1,1);

		constraints.fill = GridBagConstraints.BOTH;
		addComponent(jp1,nrText,17,1,1,1);

		constraints.fill = GridBagConstraints.BOTH;
		addComponent(jp1,set1,17,2,1,1);

		opLabel=new JLabel("Output Files");
		opLabel.setToolTipText("Please enter the root for your output files");

		opText=new JTextField();
		opHandler op =new opHandler();
		opText.addActionListener(op);

		set2= new JButton("Set output");
		set2.setToolTipText("Set the base name for output files");
		Set2Handler s2 = new Set2Handler();
		set2.addActionListener(s2);
		
		constraints.fill = GridBagConstraints.BOTH;
		addComponent(jp1,opLabel,18,0,1,1);

		constraints.fill = GridBagConstraints.BOTH;
		addComponent(jp1,opText,18,1,1,1);

		constraints.fill = GridBagConstraints.BOTH;
		addComponent(jp1,set2,18,2,1,1);
		
		constraints.fill = GridBagConstraints.BOTH;
		addComponent(jp1,sep7,19,0,3,1);
		//----------------------------------------------------------------------------
		runButton=new JButton("Run");
		runButton.setToolTipText("Run");
		runButton.setMnemonic('R');
		runButton.setEnabled(false);
		RunButtonHandler handlerRun = new RunButtonHandler();
		runButton.addActionListener(handlerRun);
		constraints.fill = GridBagConstraints.BOTH;
		addComponent(jp1,runButton,20,1,1,1);

		//------------------------------------------------------------------------
		view_results=new JButton("View Results");
		view_results.setToolTipText("View reults using DSVisualizer");
		view_results.setEnabled(false);
		ViewResultsHandler vr = new ViewResultsHandler();
		view_results.addActionListener(vr);
		constraints.fill=GridBagConstraints.BOTH;
		addComponent(jp1, view_results, 21, 1, 1, 1);

		filename="";
		filename2="";
		filename3="";
		filename4="";
		filename5="";
		filename5_full="";
		output="";
		numRuns=0;

		

		//----------------------create actual gui------------------------------------
		jpa.add(jp1);
		JScrollPane js = new JScrollPane(jpa);
		tp = new JTabbedPane();
		tp.addTab("Single ligand", null, js);
		container.add(tp);

		//sets the starting size of the gui and makes it visible

		setSize(450,720);
		setVisible(true);
		try{
			container.paint(g);
		}
		catch (NullPointerException e){

		}
	}

	/**
	 * 
	 * method to add a component to the GridBag layout
	 * @param jp the pannel to which the item has to be added
	 * @param component the component to be added
	 * @param row the row the component has to be added to
	 * @param column the column the component has to be added to
	 * @param width the number of columns the component should span
	 * @param height the number of rows the component should span
	 */
	private void addComponent(JPanel jp,Component component, int row,int column,int width, int height){
		//set gridx and gridy
		constraints.gridx=column;
		constraints.gridy=row;

		//set gridwidth and gridheight
		constraints.gridwidth=width;
		constraints.gridheight=height;

		//set constraints and add component
		layout.setConstraints(component, constraints);
		jp.add(component);
	}


	/**
	 * Main method to call the guis constructor and make sure that it closes properly
	 * @param args
	 */
	public static void main(String args[]){
		Main_gui application = new Main_gui();
		application.setDefaultCloseOperation(JFrame.EXIT_ON_CLOSE);
	}


	//-------------------tab1 handlers----------------------------------------------------------
	/**
	 * internal class to handle the clicking of the pdb browse button
	 * @author Kerry White
	 *
	 */
	private class PdbButtonHandler implements ActionListener{

		public void actionPerformed(ActionEvent e) {
			JFileChooser fileChooser = new JFileChooser();
			PdbFileFilter filter = new PdbFileFilter();
			fileChooser.setFileFilter(filter);
			int result = fileChooser.showOpenDialog(fileChooser);
			if(result==JFileChooser.CANCEL_OPTION)
				filename= "no file";
			File fileName = fileChooser.getSelectedFile();
			if(fileName == null || fileName.getName().equals(""))
				JOptionPane.showMessageDialog(fileChooser,"Invalid File Name", "Invalid FileName",JOptionPane.ERROR_MESSAGE);
			fileName=pf.file_fixer(fileName);	
filename= fileName.getName();
			filename_full = fileName.toString();
			pdbText.setText(filename);
			pdbView.setEnabled(true);
			check_file.setEnabled(true);
		}

	}

	/**
	 * internal class to handle the pressing of the pdb view button
	 * @author Kerry White
	 *
	 */
	private class PdbViewHandler implements ActionListener{

		public void actionPerformed(ActionEvent e) {
			Viewer view = new Viewer(filename_full);
			view.view();
		}

	}

	private class Mol2ButtonHandler implements ActionListener{

		public void actionPerformed(ActionEvent e) {
			JFileChooser fileChooser = new JFileChooser();
			Mol2FileFilter filter = new Mol2FileFilter();
			fileChooser.setFileFilter(filter);
			int result = fileChooser.showOpenDialog(fileChooser);
			if(result==JFileChooser.CANCEL_OPTION)
				filename2= "no file";
			File fileName = fileChooser.getSelectedFile();
			if(fileName == null || fileName.getName().equals(""))
				JOptionPane.showMessageDialog(fileChooser,"Invalid File Name", "Invalid FileName",JOptionPane.ERROR_MESSAGE);
			fileName=pf.file_fixer(fileName);
filename2= fileName.getName();
			filename2_full = fileName.toString();
			mol2Text.setText(filename2);
			mol2View.setEnabled(true);

			if(!filename3.equals(""))
				createCavity.setEnabled(true);

		}

	}

	private class Mol2ViewHandler implements ActionListener{

		public void actionPerformed(ActionEvent e) {
			Viewer view = new Viewer(filename2_full);
			view.view();

		}

	}

	private class RefButtonHandler implements ActionListener{

		public void actionPerformed(ActionEvent e) {
			JFileChooser fileChooser = new JFileChooser();
			SdFileFilter filter = new SdFileFilter();
			fileChooser.setFileFilter(filter);
			int result = fileChooser.showOpenDialog(fileChooser);
			if(result==JFileChooser.CANCEL_OPTION)
				filename3= "no file";
			File fileName = fileChooser.getSelectedFile();
			if(fileName == null || fileName.getName().equals(""))
				JOptionPane.showMessageDialog(fileChooser,"Invalid File Name", "Invalid FileName",JOptionPane.ERROR_MESSAGE);
		fileName=pf.file_fixer(fileName);
	filename3= fileName.getName();
			filename3_full = fileName.toString();
			refText.setText(filename3);
			refView.setEnabled(true);

			if(!filename2.equals(""))
				createCavity.setEnabled(true);
		}

	}

	private class RefViewHandler implements ActionListener{

		public void actionPerformed(ActionEvent e) {
			Viewer view = new Viewer(filename3_full);
			view.view();

		}

	}

	private class DocButtonHandler implements ActionListener{

		public void actionPerformed(ActionEvent e) {
			JFileChooser fileChooser = new JFileChooser();
			SdFileFilter filter = new SdFileFilter();
			fileChooser.setFileFilter(filter);
			int result = fileChooser.showOpenDialog(fileChooser);
			if(result==JFileChooser.CANCEL_OPTION)
				filename4= "no file";
			File fileName = fileChooser.getSelectedFile();
			if(fileName == null || fileName.getName().equals(""))
				JOptionPane.showMessageDialog(fileChooser,"Invalid File Name", "Invalid FileName",JOptionPane.ERROR_MESSAGE);
			filename4= fileName.getName();
			filename4_full = fileName.toString();
			dockText.setText(filename4);
			docView.setEnabled(true);

			if(!filename2.equals("") && !filename3.equals("") && !filename4.equals("") && !filename5_full.equals("")&& !output.equals("") && numRuns!=0){
				runButton.setEnabled(true);
			}
		}

	}


	private class DocViewHandler implements ActionListener{

		public void actionPerformed(ActionEvent e) {
			Viewer view = new Viewer(filename4_full);
			view.view();

		}

	}

	private class CavityButtonHandler implements ActionListener{

		public void actionPerformed(ActionEvent e) {
			System.out.println("hello");
			Runtime runtime = Runtime.getRuntime();
			Process proc;
			String ou=filename2_full.replaceAll("mol2$", "prm");
			System.out.println(ou);
			try {
				o = new File(ou);
				File_Generator fg = new File_Generator(filename2_full,filename3_full,o);
				o=fg.generate();
				proc = runtime.exec("rbcavity -r"+o+" -was");

				try {
					if (proc.waitFor() != 0) {
						System.err.println("exit value = " + proc.exitValue());
					}
				}
				catch (InterruptedException ex) { System.err.println(e); }
			} catch (IOException e1) {
				// TODO Auto-generated catch block
				e1.printStackTrace();
			}
		}
	}

	private class RunButtonHandler implements ActionListener{

		public void actionPerformed(ActionEvent e) {
			Runtime runtime = Runtime.getRuntime();
			Process proc;			
			try {
			    System.out.println(filename4_full +" "+filename5_full+" " +output+ " "+numRuns);
				proc = runtime.exec("rbdock -r"+o+" -i "+ filename4_full +" -o "+output+" -p "+ filename5_full +" -n "+numRuns);

				try {
					if (proc.waitFor() != 0) {
						System.err.println("exit value = " + proc.exitValue());
					}
				}
				catch (InterruptedException ex) { System.err.println(e); }
			} catch (IOException e1) {
				// TODO Auto-generated catch block
				e1.printStackTrace();
			}
			view_results.setEnabled(true);
		}
	}


	private class nrHandler implements ActionListener{


		public void actionPerformed(ActionEvent arg0) {

			numRuns=Integer.parseInt(nrText.getText());
			if(!filename2.equals("") && !filename3.equals("") && !filename4_full.equals("") && !filename5_full.equals("")&& !output.equals("") ){
				runButton.setEnabled(true);
			}
			
		}

	}
	
	private class Set1Handler implements ActionListener{


		public void actionPerformed(ActionEvent arg0) {

			numRuns=Integer.parseInt(nrText.getText());
			if(!filename2.equals("") && !filename3.equals("") && !filename4_full.equals("") && !filename5_full.equals("")&& !output.equals("") ){
				runButton.setEnabled(true);
			}
			
		}

	}

	private class opHandler implements ActionListener{

		public void actionPerformed(ActionEvent e) {
			output=opText.getText();
			output=dir_full+"/"+output;
			System.out.println(output);
			if(!filename2.equals("") && !filename3.equals("") && !filename4_full.equals("") && !filename5_full.equals("") && numRuns!=0){
				runButton.setEnabled(true);
			}
		}

	}

	
	private class Set2Handler implements ActionListener{

		public void actionPerformed(ActionEvent e) {
			output=opText.getText();
			output=dir_full+"/"+output;
			System.out.println(output);
			if(!filename2.equals("") && !filename3.equals("") && !filename4_full.equals("") && !filename5_full.equals("") && numRuns!=0){
				runButton.setEnabled(true);
			}
		}

	}
	
	private class Check_fileButtonHandler implements ActionListener{

		public void actionPerformed(ActionEvent arg0) {
			Runtime runtime = Runtime.getRuntime();
			Process proc;
			try {
				proc = runtime.exec("python "+ "completeerrors.pyc "+filename_full);
				proc=runtime.exec("emacs Errors.txt");

				try {
					if (proc.waitFor() != 0) {
						System.err.println("exit value = " + proc.exitValue());
					}
				}
				catch (InterruptedException ex) { System.err.println(ex); }
			} catch (IOException e1) {
				// TODO Auto-generated catch block
				e1.printStackTrace();
			}
			convert.setEnabled(true);
		}

	}

	private class ConvertButtonHandler implements ActionListener{

		public void actionPerformed(ActionEvent e) {
			Runtime runtime = Runtime.getRuntime();
			Process proc;
			String mf = filename.replaceAll("pdb", "mol2");
			try {
				proc = runtime.exec("babel -i pdb "+filename_full+ " -o mol2 "+dir_full+"/"+mf);

				try {
					if (proc.waitFor() != 0) {
						System.err.println("exit value = " + proc.exitValue());
					}
				}
				catch (InterruptedException ex) { System.err.println(ex); }
			} catch (IOException e1) {
				// TODO Auto-generated catch block
				e1.printStackTrace();
			}

		}

	}



	private class ViewResultsHandler implements ActionListener{

		public void actionPerformed(ActionEvent e) {
			Viewer view=new Viewer(output+".sd");
			view.view();

		}

	}

	private class ComboHandler implements ActionListener{
		public void actionPerformed(ActionEvent e){
			filename5_full=protocol_path+combo.getSelectedItem().toString();
			System.out.println(filename5_full);
		}
	}

	private class DirectoryHandler implements ActionListener{

		public void actionPerformed(ActionEvent arg0) {
			JFileChooser fileChooser = new JFileChooser();
			//PrmFileFilter filter = new PrmFileFilter();
			fileChooser.setFileSelectionMode(JFileChooser.DIRECTORIES_ONLY);
			int result = fileChooser.showOpenDialog(fileChooser);
			if(result==JFileChooser.CANCEL_OPTION)
				dir= "no file";
			File fileName = fileChooser.getSelectedFile();
			if(fileName == null || fileName.getName().equals(""))
				JOptionPane.showMessageDialog(fileChooser,"Invalid File Name", "Invalid FileName",JOptionPane.ERROR_MESSAGE);
			dir= fileName.getName();
			dir_full = fileName.toString();
			dirText.setText(dir);
		}

	}

}
