#----------------------------------------------------------------
#
# Script to get best score from Output generated from rDock
#
#----------------------------------------------------------------

# Enable strict mode
use strict;

my $filename="output.txt"; #input filename
open FILE,"$filename" or die "Can not open input file\n";

#initializing variables
my (@pdbid,@score_line);
my $i=1;
my $best=0;
my($rline,$score,$pid,$myline);

my $outfilename="best_scored.txt"; #output filename
#open output file in writing mode
open OUTFILE,">$outfilename" or die "Can not open input file\n";

#reading each line from input file
while(<FILE>)
{
     #search for PDB ID
     if(($pid)=$_=~/^-r\s*(\w{4})\.prm/) #fetching pdb id
     {     #check if PDB already exists in array
          if ( !grep( /$pid/, @pdbid ) ){
               #store the pdb id into array
              push(@pdbid,$pid);
              #print $myline,"\n";
              #print $pid,"\n","\n***********$i*************************\n";
              $i++;
              $best=0;
              #$score=0;
              push(@score_line,$myline); #store line having best score
              #print OUTFILE $myline,"\n";
              #print OUTFILE "PDB ID: ",$pid,"\n";
              
          }
     }
     #pattern search for score line
     if(($rline,$score)=$_=~/(^\d{1,2}\s+\-?(\d+\.\d+)\s+\-?\d+\.\d+\s+\-?\d+\.\d+\s+\d+\.\d+\s+0.000)/)
     {
         #print "$rline##$best### $score\n";
         #searching for best score value and storing it into $myline
         if($best == 0)
         {
              $best=$score;
              $myline=$rline;
             #print $rline,"\n";
         }
         elsif($best<$score)
         {
              $best=$score;
              $myline=$rline;
         }
     }
     
     
}

push(@score_line,$myline);
#print OUTFILE $myline,"\n";
close FILE; #close the filehandler

#printing PDB ID and best score into Output file

my $j=1;
#reading value stored into araay @pdbid and @score_line
for(my $i=0;$i<=$#pdbid;$i++)
{
     print OUTFILE "PDB ID: ",$pdbid[$i],"\n"; #writing PDB ID into File
     print OUTFILE $score_line[$j],"\n";   #writing best score line into file
     $j++;
     
}

close OUTFILE; #close the filehandler
#print "\n",$myline,"\n";
#print @pdbid;


print "\n Successfully Completed\n";




