#!/usr/bin/perl

#----------------------------------------------------------------
#
# Script to get Lowest RMSD from Outout generated from rDock
#
#----------------------------------------------------------------

# Enable strict mode
use strict;

# get filename as standard input
#print "Enter Input file :\t";
#chomp(my $filename=<stdin>);

my $filename="output.txt"; #input filename
open FILE,"$filename" or die "Can not open input file\n";

#initializing variables
my (@pdbid,@rmsd_line);
my $i=1;
my $lowest=0;
my($rline,$rmsd,$pid,$myline);

# get output filename as standard input
#print "Enter Output file :\t";
#chomp(my $outfilename=<stdin>);

my $outfilename="lowest_rmsd.txt"; #output filename
#open output file in writing mode
open OUTFILE,">$outfilename" or die "Can not open input file\n";

#reading each line from input file
while(<FILE>)
{
     #search for PDB ID
     if(($pid)=$_=~/^-r\s*(\w{4})\.prm/) #fetching pdb id
     {     #check if PDB already exits in array
          if ( !grep( /$pid/, @pdbid ) ){
               #store the pdb id into array
              push(@pdbid,$pid);
              #print $myline,"\n";
              #print $pid,"\n","\n***********$i*************************\n";
              $i++;
              $lowest=0;
              #$rmsd=0;
              push(@rmsd_line,$myline); #store line having lowest RMSD
              #print OUTFILE $myline,"\n";
              #print OUTFILE "PDB ID: ",$pid,"\n";
              
          }
     }
     #pattern search for rmsd line
     if(($rline,$rmsd)=$_=~/(^\d{1,2}\s+\-?\d+\.\d+\s+\-?\d+\.\d+\s+\-?\d+\.\d+\s+(\d+\.\d+)\s+0.000)/)
     {
         #print "$rline##$lowest### $rmsd\n";
         #searching for lowest rmsd value and storing it into $myline
         if($lowest == 0)
         {
              $lowest=$rmsd;
              $myline=$rline;
             #print $rline,"\n";
         }
         elsif($lowest>$rmsd)
         {
              $lowest=$rmsd;
              $myline=$rline;
         }
     }
     
     
}

push(@rmsd_line,$myline);
#print OUTFILE $myline,"\n";
close FILE; #close the filehandler

#printing PDB ID and Lowest RMSD into Output file

my $j=1;
#reading value stored into araay @pdbid and @rmsd_line
for(my $i=0;$i<=$#pdbid;$i++)
{
     print OUTFILE "PDB ID: ",$pdbid[$i],"\n"; #writing PDB ID into File
     print OUTFILE $rmsd_line[$j],"\n";        #writing lowest RMSD line into file
     $j++;
     
}

close OUTFILE; #close the filehandler
#print "\n",$myline,"\n";
#print @pdbid;


print "\n Successfully Completed\n";
