      SUBROUTINE WRT_LIB(MDOC,MODE,ICRD,IERR)
C -------------------------------------------------------
C -P- WRT_LIB - writes library to the file.
C
C     MODE:  TITC - titles only for new
C            TITA - all
C            TITL - 'Y', 'C', except 'N' , 'C'
C            MONL
C            MONC
C            MONA
C            MODL
C            MODC
C            MODA
C            LINL
C            LINC
C            LINA
C
C            STOP
C
C -S-
C -------------------------------------------------------
      INTEGER*4 MDOC,IERR,ICRD
      CHARACTER MODE*4
C ******
C -----------------------------------------------
      INCLUDE 'lib_com.fh'
C -----------------------------------
      INCLUDE 'crd_com.fh'
C ----------------------------------
      INTEGER*4 IATOM
      CHARACTER LINE*256
      CHARACTER ATOM*4,CH1_1*1,CH1_2*1,CH2*2,CH3*3,POINT*4
      CHARACTER TYPE*8,CH8*8,CHAR8*8
      CHARACTER WATOM1*6,WATOM2*6,WATOM3*6,WATOM4*6
      CHARACTER WATOM5*6,WATOM6*6,WATOM7*6,WATOM8*6,WATOM9*6
C     CHARACTER CH1_3*1,CH1_4*1,CH1_5*1,CH5*5
      CHARACTER STR*80,TITLE_M*80,CH4*4
      EQUIVALENCE (IATOM,ATOM)
      DATA POINT/'.   '/,TYPE/'.       '/
C -----------------------------------
  
      IF(MODE(1:3).EQ.'TIT') THEN
        IF(ICRD.EQ.0) THEN
          IF(LMO_FILE.EQ.' ') RETURN
          IERR=0
C         open file 
          IF(LMO_IUN.NE.0) THEN
            CALL MSGERR(MDOC,' ERR: output_lib_file was open before')
            IERR=1
            RETURN
          ENDIF
          M   = 99

C         IUN = 11
          IUN = CRO3_IUN
          CALL OPENFW(IUN,M,LMO_PATH,LMO_FILE,LMO_EXT,IERR)
          CRO3_IUN = IUN

          IF(IERR.NE.0) THEN
            CALL MSGERR(MDOC,' ERR: can''t open output_lib_file')
            RETURN
          ENDIF
          LMO_IUN = IUN
          WRITE(LINE,'(''global_'')') 
          CALL WRTSTR(IUN,MDOC,LINE,IERR)
          WRITE(LINE,'(''_lib_name   '',6X,A)') LB_NAME(1:16)
          CALL WRTSTR(IUN,MDOC,LINE,IERR)
          WRITE(LINE,'(''_lib_version'',6X,A)') LB_VERS(1:16)
          CALL WRTSTR(IUN,MDOC,LINE,IERR)
          WRITE(LINE,'(''_lib_update '',6X,A)') LB_DATE(1:16)
          CALL WRTSTR(IUN,MDOC,LINE,IERR)

C          WRITE(LINE
C     *  ,'(''# ------------------------------------------------'')')
C          CALL WRTSTR(IUN,MDOC,LINE,IERR)
C          WRITE(LINE,'(''#'')')
C          CALL WRTSTR(IUN,MDOC,LINE,IERR)
C          WRITE(LINE,'(''# ---   LIST OF MONOMERS ---'')')
          TITLE_M = '# ---   LIST OF MONOMERS ---'
C          CALL WRTSTR(IUN,MDOC,LINE,IERR)
C          WRITE(LINE,'(''#'')')
C          CALL WRTSTR(IUN,MDOC,LINE,IERR)
C          WRITE(LINE,'(''data_comp_list'')')
C          CALL WRTSTR(IUN,MDOC,LINE,IERR)
        ELSE 
          IF(ICRD.LE.0) THEN
            CALL MSGERR(MDOC,' ERR: output_CIFile isn''t open.')
            IERR=1
            RETURN
          ENDIF
          IUN = ICRD 
C          WRITE(LINE
C     *  ,'(''# ------------------------------------------------'')')
C          CALL WRTSTR(IUN,MDOC,LINE,IERR)
C          WRITE(LINE,'(''#'')')
C          CALL WRTSTR(IUN,MDOC,LINE,IERR)
C          WRITE(LINE,'(''# ---   LIST OF NEW MONOMERS ---'')')
          TITLE_M = '# ---   LIST OF NEW MONOMERS ---'
C          CALL WRTSTR(IUN,MDOC,LINE,IERR)
C          WRITE(LINE,'(''#'')')
C          CALL WRTSTR(IUN,MDOC,LINE,IERR)
C          WRITE(LINE,'(''data_comp_list'')')
C          CALL WRTSTR(IUN,MDOC,LINE,IERR)
        ENDIF

C        WRITE(LINE,'(''loop_'')')
C        CALL WRTSTR(IUN,MDOC,LINE,IERR)
C        WRITE(LINE,'(''_chem_comp.id'')')
C        CALL WRTSTR(IUN,MDOC,LINE,IERR)
C        WRITE(LINE,'(''_chem_comp.one_letter_code'')')
C        CALL WRTSTR(IUN,MDOC,LINE,IERR)
C        WRITE(LINE,'(''_chem_comp.name'')')
C        CALL WRTSTR(IUN,MDOC,LINE,IERR)
C        WRITE(LINE,'(''_chem_comp.type'')')
C        CALL WRTSTR(IUN,MDOC,LINE,IERR)
C        WRITE(LINE,'(''_chem_comp.number_atoms_all'')')
C        CALL WRTSTR(IUN,MDOC,LINE,IERR)
C        WRITE(LINE,'(''_chem_comp.number_atoms_nh'')')
C        CALL WRTSTR(IUN,MDOC,LINE,IERR)
C        WRITE(LINE,'(''_chem_comp.desc_level'')')
C        CALL WRTSTR(IUN,MDOC,LINE,IERR)

        IF(LML_NMON.GT.0) THEN

c            WRITE(*,*) '-wrt-:',LB_NUMB_LIB,LML_NMON,MODE
c            WRITE(*,*) '-wrt:'
c     *      ,LML_MNAME(LML_NMON),LML_FUSE(LML_NMON),LML_PASS(LML_NMON)

          IFIRST_M = 0
          DO L=1,LML_NMON

            IF((LML_FUSE(L).EQ.'C'.AND.MODE.EQ.'TITC').OR. 
     *         (MODE.EQ.'TITA')                       .OR. 
     *         (LML_FUSE(L).NE.'N'.AND.LML_FUSE(L).NE.'?'.AND.
     *                                          MODE.EQ.'TITL')) THEN

c            WRITE(*,*) '-wrt:',l,LML_MNAME(l),LML_FUSE(l),LML_PASS(l)


              IF(IFIRST_M.EQ.0) THEN
                WRITE(LINE,'(A)')
     *  '# ------------------------------------------------'
                CALL WRTSTR(IUN,MDOC,LINE,IERR)
                WRITE(LINE,'(''#'')')
                CALL WRTSTR(IUN,MDOC,LINE,IERR)
                LINE = TITLE_M
                CALL WRTSTR(IUN,MDOC,LINE,IERR)
                WRITE(LINE,'(''#'')')
                CALL WRTSTR(IUN,MDOC,LINE,IERR)
                WRITE(LINE,'(''data_comp_list'')')
                CALL WRTSTR(IUN,MDOC,LINE,IERR)
                WRITE(LINE,'(''loop_'')')
                CALL WRTSTR(IUN,MDOC,LINE,IERR)
                WRITE(LINE,'(''_chem_comp.id'')')
                CALL WRTSTR(IUN,MDOC,LINE,IERR)
                WRITE(LINE,'(''_chem_comp.three_letter_code'')')
                CALL WRTSTR(IUN,MDOC,LINE,IERR)
                WRITE(LINE,'(''_chem_comp.name'')')
                CALL WRTSTR(IUN,MDOC,LINE,IERR)
                WRITE(LINE,'(''_chem_comp.group'')')
                CALL WRTSTR(IUN,MDOC,LINE,IERR)
                WRITE(LINE,'(''_chem_comp.number_atoms_all'')')
                CALL WRTSTR(IUN,MDOC,LINE,IERR)
                WRITE(LINE,'(''_chem_comp.number_atoms_nh'')')
                CALL WRTSTR(IUN,MDOC,LINE,IERR)
                WRITE(LINE,'(''_chem_comp.desc_level'')')
                CALL WRTSTR(IUN,MDOC,LINE,IERR)
                IFIRST_M = 1
              ENDIF
              CH3 = LML_MNAME2(L)(1:3)
              J   = LML_IATOM(L)
              NA  = 0
              NHA = 0                  
              IF(J.GT.0) THEN
                IF(LMA_NATOM.GT.0) THEN
                  DO IA=J,LMA_NATOM
                    IF(LMA_MNAME(IA).EQ.LML_MNAME(L)) THEN
                      NA = NA+1
                      IF(LMA_SYMB(IA).NE.'H   '.AND.
     *                   LMA_SYMB(IA).NE.'D   ') THEN
                        NHA=NHA+1
                      ENDIF
                    ENDIF           
                  ENDDO
                ENDIF
              ENDIF

              CH1_2 = ''''
              CH1_1 = LML_PRSNT(L)
              IF(CH1_1.EQ.' ') CH1_1 = '.'
              STR = LML_NAME(L)
              CALL LENSTR_BL(STR,LEN)
              IF(LEN.GT.36) LEN = 36
              IF(LEN.LT.36) THEN
                DO II=LEN+1,36
                  STR(II:II) = ' '
                ENDDO
              ENDIF
              IF(LML_MNAME(L)(1:1).NE.'?') THEN
                WRITE(LINE,100)
     *          LML_MNAME(L),CH3,CH1_2,STR(1:36),CH1_2
     *         ,LML_TYPE(L),NA,NHA,CH1_1
C     *        ,LML_NATM(L),LML_NHATM(L)
                CALL WRTSTR(IUN,MDOC,LINE,IERR)
  100           FORMAT(A8,1X,A3,1X,A1,A36,A1,1X,A16,1X,I4,I4,1X,A1)
              ENDIF
            ENDIF
          ENDDO
        ELSE
          IF(MODE.NE.'TITC') THEN
            WRITE(LINE,'('' Number of monomers = 0'')')
            CALL MSGDOC(MDOC,LINE)
            LMO_IUN = 0
            RETURN
          ENDIF
        ENDIF

        IF(LMS_NEW.GT.0.OR.MODE.NE.'TITC') THEN
        IF(LMS_NSYN.GT.0) THEN
          IFIRST_M = 0

          DO L=1,LMS_NSYN
            IF((LMS_FLAG(L).EQ.'N'.OR.MODE.NE.'TITC').AND.
     *          LMS_ATOM(L).EQ.'.') THEN
              IF(IFIRST_M.EQ.0) THEN

                WRITE(LINE,'(''#'')')
                CALL WRTSTR(IUN,MDOC,LINE,IERR)
                WRITE(LINE,'(''# ---   LIST OF SYNONYMS ---'')')
                CALL WRTSTR(IUN,MDOC,LINE,IERR)

                WRITE(LINE,'(''#'')')
                CALL WRTSTR(IUN,MDOC,LINE,IERR)
                WRITE(LINE,'(''data_comp_synonym_list'')')
                CALL WRTSTR(IUN,MDOC,LINE,IERR)
                WRITE(LINE,'(''loop_'')')
                CALL WRTSTR(IUN,MDOC,LINE,IERR)
                WRITE(LINE,'(''_chem_comp_synonym.comp_id'')')
                CALL WRTSTR(IUN,MDOC,LINE,IERR)
          WRITE(LINE,'(''_chem_comp_synonym.comp_alternative_id'')')
                CALL WRTSTR(IUN,MDOC,LINE,IERR)
                WRITE(LINE,'(''_chem_comp_synonym.mod_id'')')
                CALL WRTSTR(IUN,MDOC,LINE,IERR)
                IFIRST_M = 1
              ENDIF
              WRITE(LINE,200) 
     *        LMS_MNAME(L)
     *        ,LMS_AMNAME(L),LMS_MOD(L)
              CALL WRTSTR(IUN,MDOC,LINE,IERR)
  200         FORMAT(A8,4X,A8,1X,A8)
            ENDIF
          ENDDO

          IFIRST_MM = 0

          DO L=1,LMS_NSYN
            IF((LMS_FLAG(L).EQ.'N'.OR.MODE.NE.'TITC').AND.
     *          LMS_ATOM(L).NE.'.') THEN
              IF(IFIRST_MM.EQ.0) THEN

                IF(IFIRST_M.EQ.0) THEN
                  WRITE(LINE,'(''#'')')
                  CALL WRTSTR(IUN,MDOC,LINE,IERR)
                  WRITE(LINE,'(''# ---   LIST OF SYNONYMS ---'')')
                  CALL WRTSTR(IUN,MDOC,LINE,IERR)
                ENDIF

                WRITE(LINE,'(''#'')')
                CALL WRTSTR(IUN,MDOC,LINE,IERR)
                WRITE(LINE,'(''data_comp_synonym_atom_list'')')
                CALL WRTSTR(IUN,MDOC,LINE,IERR)
                WRITE(LINE,'(''loop_'')')
                CALL WRTSTR(IUN,MDOC,LINE,IERR)
                WRITE(LINE,'(''_chem_comp_synonym_atom.comp_id'')')
                CALL WRTSTR(IUN,MDOC,LINE,IERR)
        WRITE(LINE,'(''_chem_comp_synonym_atom.comp_alternative_id'')')
                CALL WRTSTR(IUN,MDOC,LINE,IERR)
                WRITE(LINE,'(''_chem_comp_synonym_atom.atom_id'')')
                CALL WRTSTR(IUN,MDOC,LINE,IERR)
        WRITE(LINE,'(''_chem_comp_synonym_atom.atom_alternative_id'')')
                CALL WRTSTR(IUN,MDOC,LINE,IERR)

                IFIRST_MM = 1
              ENDIF
              WATOM1 = LMS_ATOM(L)
              WATOM2 = LMS_AATOM(L)
              CALL CORR_NAME_CIF_OUT(WATOM1)
              CALL CORR_NAME_CIF_OUT(WATOM2)
              WRITE(LINE,201) 
     *        LMS_MNAME(L)
     *        ,LMS_AMNAME(L),WATOM1,WATOM2
              CALL WRTSTR(IUN,MDOC,LINE,IERR)
 201          FORMAT(A8,4X,A8,1X,A6,1X,A6)
            ENDIF
          ENDDO


        ENDIF
        ENDIF

        IF(LLL_NLINK.GT.0) THEN
          IFIRST=0
          DO L=1,LLL_NLINK
            IF((LLL_FUSE(L).EQ.'C'.AND.MODE.EQ.'TITC').OR. 
     *         (MODE.EQ.'TITA')                       .OR. 
     *         (LLL_FUSE(L).NE.'N'.AND.LLL_FUSE(L).NE.'?'.AND.
     *                                 MODE.EQ.'TITL')) THEN
              IF(IFIRST.EQ.0) THEN 
                WRITE(LINE,'(''#'')')
                CALL WRTSTR(IUN,MDOC,LINE,IERR)
                WRITE(LINE,'(''# ---   LIST OF LINKS ---'')')
                CALL WRTSTR(IUN,MDOC,LINE,IERR)
                WRITE(LINE,'(''#'')')
                CALL WRTSTR(IUN,MDOC,LINE,IERR)
                WRITE(LINE,'(''data_link_list'')')
                CALL WRTSTR(IUN,MDOC,LINE,IERR)
                WRITE(LINE,'(''loop_'')')
                CALL WRTSTR(IUN,MDOC,LINE,IERR)
                WRITE(LINE,'(''_chem_link.id'')')
                CALL WRTSTR(IUN,MDOC,LINE,IERR)
C                WRITE(LINE,'(''_chem_link.one_letter_code'')')
C                CALL WRTSTR(IUN,MDOC,LINE,IERR)
C                WRITE(LINE,'(''_chem_link.name'')')
C                CALL WRTSTR(IUN,MDOC,LINE,IERR)
                WRITE(LINE,'(''_chem_link.comp_id_1'')')
                CALL WRTSTR(IUN,MDOC,LINE,IERR)
                WRITE(LINE,'(''_chem_link.mod_id_1'')')
                CALL WRTSTR(IUN,MDOC,LINE,IERR)
                WRITE(LINE,'(''_chem_link.group_comp_1'')')
                CALL WRTSTR(IUN,MDOC,LINE,IERR)
                WRITE(LINE,'(''_chem_link.comp_id_2'')')
                CALL WRTSTR(IUN,MDOC,LINE,IERR)
                WRITE(LINE,'(''_chem_link.mod_id_2'')')
                CALL WRTSTR(IUN,MDOC,LINE,IERR)
                WRITE(LINE,'(''_chem_link.group_comp_2'')')
                CALL WRTSTR(IUN,MDOC,LINE,IERR)
                WRITE(LINE,'(''_chem_link.name'')')
                CALL WRTSTR(IUN,MDOC,LINE,IERR)
                IFIRST=1
              ENDIF
              WRITE(LINE,300) 
     *        LLL_LNAME(L)
     *        ,LLL_MON1(L),LLL_MOD1(L),LLL_TYPE1(L)
     *        ,LLL_MON2(L),LLL_MOD2(L),LLL_TYPE2(L)
              CALL WRTSTR(IUN,MDOC,LINE,IERR)
  300         FORMAT(A8,1X,A8,1X,A8,1X,A8
     *                              ,1X,A8,1X,A8,1X,A8)
              WRITE(LINE,301) LLL_DETAIL(L)(1:24)
              CALL WRTSTR(IUN,MDOC,LINE,IERR)
 301          FORMAT(1X,A24)
            ENDIF
          ENDDO
        ENDIF

C        IF(LRL_NMON.GT.0.AND.MODE.NE.'TIT?') THEN
C          WRITE(LINE,'(''#'')')
C          CALL WRTSTR(IUN,MDOC,LINE,IERR)
C          WRITE(LINE
C     *    ,'(''# ---   LIST OF RECOGNIZED LINKED MONOMERS ---'')')
C          CALL WRTSTR(IUN,MDOC,LINE,IERR)
C          WRITE(LINE,'(''#'')')
C          CALL WRTSTR(IUN,MDOC,LINE,IERR)
C          WRITE(LINE,'(''data_link_comp_list'')')
C          CALL WRTSTR(IUN,MDOC,LINE,IERR)
C          WRITE(LINE,'(''loop_'')')
C          CALL WRTSTR(IUN,MDOC,LINE,IERR)
C          WRITE(LINE,'(''_lib_link_comp_list_comp_id'')')
C          CALL WRTSTR(IUN,MDOC,LINE,IERR)
C          WRITE(LINE,'(''_lib_link_comp_list_link_id'')')
C          CALL WRTSTR(IUN,MDOC,LINE,IERR)
C          DO L=1,LRL_NMON
C            WRITE(LINE,310) 
C     *      LRL_MON(L),LRL_LINK(L)
C            CALL WRTSTR(IUN,MDOC,LINE,IERR)
C  310       FORMAT(1X,A3,2X,A8)
C          ENDDO
C        ENDIF

        IF(LDL_NMOD.GT.0) THEN
          IFIRST=0
          DO L=1,LDL_NMOD
            IF((LDL_FUSE(L).EQ.'C'.AND.MODE.EQ.'TITC').OR. 
     *         (MODE.EQ.'TITA')                       .OR. 
     *         (LDL_FUSE(L).NE.'N'.AND.LDL_FUSE(L).NE.'?'.AND.
     *                                 MODE.EQ.'TITL')) THEN
              IF(IFIRST.EQ.0) THEN 
                WRITE(LINE,'(''#'')')
                CALL WRTSTR(IUN,MDOC,LINE,IERR)
                WRITE(LINE,'(''# ---   LIST OF MODIFICATIONS ---'')')
                CALL WRTSTR(IUN,MDOC,LINE,IERR)
                WRITE(LINE,'(''#'')')
                CALL WRTSTR(IUN,MDOC,LINE,IERR)
                WRITE(LINE,'(''data_mod_list'')')
                CALL WRTSTR(IUN,MDOC,LINE,IERR)
                WRITE(LINE,'(''loop_'')')
                CALL WRTSTR(IUN,MDOC,LINE,IERR)
                WRITE(LINE,'(''_chem_mod.id'')')
                CALL WRTSTR(IUN,MDOC,LINE,IERR)
c                WRITE(LINE,'(''_chem_mod.one_letter_code'')')
c                CALL WRTSTR(IUN,MDOC,LINE,IERR)
                WRITE(LINE,'(''_chem_mod.name'')')
                CALL WRTSTR(IUN,MDOC,LINE,IERR)
                WRITE(LINE,'(''_chem_mod.comp_id'')')
                CALL WRTSTR(IUN,MDOC,LINE,IERR)
                WRITE(LINE,'(''_chem_mod.group_id'')')
                CALL WRTSTR(IUN,MDOC,LINE,IERR)
c                WRITE(LINE,'(''_chem_mod.sub_mod_id'')')
c                CALL WRTSTR(IUN,MDOC,LINE,IERR)
c                WRITE(LINE,'(''_chem_mod.sub_mod_order'')')
c                CALL WRTSTR(IUN,MDOC,LINE,IERR)
                IFIRST=1
              ENDIF

c              WRITE(CH2,'(I2)') LDL_ORDER(L)
c              IF(LDL_ORDER(L).EQ.0) CH2='. '

              WRITE(LINE,400) 
     *        LDL_MNAME(L),LDL_DETAIL(L),LDL_COMP(L),LDL_TYPE(L)
    
              CALL WRTSTR(IUN,MDOC,LINE,IERR)
  400         FORMAT(A8,1X,A48,1X,A8,1X,A8)
            ENDIF
          ENDDO
        ENDIF

c        IF(LMR_NREC.GT.0.AND.MODE.NE.'TITC') THEN
c          WRITE(LINE,'(''#'')')
c          CALL WRTSTR(IUN,MDOC,LINE,IERR)
c          WRITE(LINE
c     *    ,'(''# ---   LIST OF RECOGNIZED MODIFIED MONOMERS ---'')')
c          CALL WRTSTR(IUN,MDOC,LINE,IERR)
c          WRITE(LINE,'(''#'')')
c          CALL WRTSTR(IUN,MDOC,LINE,IERR)
c          WRITE(LINE,'(''data_mod_comp_list'')')
c          CALL WRTSTR(IUN,MDOC,LINE,IERR)
c          WRITE(LINE,'(''loop_'')')
c          CALL WRTSTR(IUN,MDOC,LINE,IERR)
c          WRITE(LINE,'(''_chem_mod_comp.comp_id'')')
c          CALL WRTSTR(IUN,MDOC,LINE,IERR)
c          WRITE(LINE,'(''_chem_mod_comp.mod_id'')')
c          CALL WRTSTR(IUN,MDOC,LINE,IERR)
c          WRITE(LINE,'(''_chem_mod_comp.name'')')
c          CALL WRTSTR(IUN,MDOC,LINE,IERR)
c          WRITE(LINE,'(''_chem_mod_comp.type'')')
c          CALL WRTSTR(IUN,MDOC,LINE,IERR)
c          DO L=1,LMR_NREC
c            WRITE(LINE,410) 
c     *      LMR_COMP(L),LMR_MNAME(L),LMR_DETAIL(L),LMR_TYPE(L)
c            CALL WRTSTR(IUN,MDOC,LINE,IERR)
c  410       FORMAT(1X,A3,5X,A8,1X,A48,1X,A8)
c          ENDDO
c        ENDIF

      ELSE IF(MODE(1:3).EQ.'MON'.OR.MODE(1:3).EQ.'LIN'.OR.
     *        MODE(1:3).EQ.'MOD') THEN

        IF(ICRD.GT.0) THEN
          IF(ICRD.LE.0) THEN
            CALL MSGERR(MDOC,' ERROR: output_CIFile isn''t open')
            IERR=1
            RETURN
          ENDIF
          IUN=ICRD 
        ELSE
          IF(LMO_IUN.EQ.0) THEN
            CALL MSGERR(MDOC,' ERR: output_lib_file isn''t open..')
            IERR=1
            RETURN
          ENDIF
          IUN=LMO_IUN 
        ENDIF

        IF(MODE(1:3).EQ.'LIN'.OR.MODE(1:3).EQ.'MOD') GO TO 6000


        IF(LML_NMON.GT.0) THEN
          WRITE(LINE,'(''#'')')
          CALL WRTSTR(IUN,MDOC,LINE,IERR)
          WRITE(LINE,'(''# --- DESCRIPTION OF MONOMERS ---'')')
          CALL WRTSTR(IUN,MDOC,LINE,IERR)
          WRITE(LINE,'(''#'')')
          DO I=1,LML_NMON

            IF((LML_FUSE(I).EQ.'C'.AND.MODE.EQ.'MONC').OR.
     *         (MODE.EQ.'MONA')                       .OR.
     *         (LML_FUSE(I).NE.'N'.AND.LML_FUSE(I).NE.'?'.AND.
     *                                 MODE.EQ.'MONL')) THEN
              CH8 = LML_MNAME(I)
              IF(CH8(1:1).NE.'?') THEN
                WRITE(LINE,'(''#'')')
                CALL WRTSTR(IUN,MDOC,LINE,IERR)
                WRITE(LINE,'(''data_comp_'',A8)') CH8
                CALL WRTSTR(IUN,MDOC,LINE,IERR)
                WRITE(LINE,'(''#'')')
                CALL WRTSTR(IUN,MDOC,LINE,IERR)
              ENDIF
              J=LML_IATOM(I)
              IF(J.GT.0) THEN
                ICOOR=0
                IF(LMA_NATOM.GT.0) THEN
                  DO L=J,LMA_NATOM
                    IF(LMA_MNAME(L).NE.CH8) GO TO 511
                    IF(LMA_COOR_FLAG(L).EQ.'N'.OR.
     *                 LMA_COOR_FLAG(L).EQ.'.'    ) ICOOR=1
                  ENDDO
                ENDIF
 511            CONTINUE
                WRITE(LINE,'(''loop_'')')
                CALL WRTSTR(IUN,MDOC,LINE,IERR)
                WRITE(LINE,'(''_chem_comp_atom.comp_id'')')
                CALL WRTSTR(IUN,MDOC,LINE,IERR)
                WRITE(LINE,'(''_chem_comp_atom.atom_id'')')
                CALL WRTSTR(IUN,MDOC,LINE,IERR)
                WRITE(LINE,'(''_chem_comp_atom.type_symbol'')')
                CALL WRTSTR(IUN,MDOC,LINE,IERR)
                WRITE(LINE,'(''_chem_comp_atom.type_energy'')')
                CALL WRTSTR(IUN,MDOC,LINE,IERR)
c                IF(LML_PRSNT(I).NE.'M') THEN
                  WRITE(LINE,'(''_chem_comp_atom.partial_charge'')')
                  CALL WRTSTR(IUN,MDOC,LINE,IERR)
c                ENDIF
                IF(ICOOR.EQ.0) THEN
                  WRITE(LINE,'(''_chem_comp_atom.x'')')
                  CALL WRTSTR(IUN,MDOC,LINE,IERR)
                  WRITE(LINE,'(''_chem_comp_atom.y'')')
                  CALL WRTSTR(IUN,MDOC,LINE,IERR)
                  WRITE(LINE,'(''_chem_comp_atom.z'')')
                  CALL WRTSTR(IUN,MDOC,LINE,IERR)
                ENDIF
                IF(LMA_NATOM.GT.0) THEN
                  DO L=J,LMA_NATOM
                    IF(LMA_MNAME(L).NE.CH8) GO TO 510
                    WATOM1 = LMA_ANAME(L)
                    CALL CORR_NAME_CIF_OUT(WATOM1)
c                    IF(LML_PRSNT(I).NE.'M') THEN
                    IF(ICOOR.NE.0) THEN
                      WRITE(LINE,500) 
     *                LMA_MNAME(L),WATOM1
     *               ,LMA_SYMB(L),LMA_CHEM(L),LMA_CHARG(L)
                      CALL WRTSTR(IUN,MDOC,LINE,IERR)
  500                 FORMAT(1X,A8,6X,A6,1X,A4,1X,A4,3X,F8.3)
                    ELSE
                      WRITE(LINE,501) 
     *                LMA_MNAME(L),WATOM1
     *               ,LMA_SYMB(L),LMA_CHEM(L),LMA_CHARG(L)
     *               ,LMA_X(L),LMA_Y(L),LMA_Z(L)
                      CALL WRTSTR(IUN,MDOC,LINE,IERR)
 501                  FORMAT(1X,A8,6X,A6,1X,A4,1X,A4,3X,F8.3
     *                ,3X,F8.3,1X,F8.3,1X,F8.3)
c                      WRITE(LINE,501) 
c     *                LMA_MNAME(L),WATOM1
c     *               ,LMA_SYMB(L),LMA_CHEM(L)
c                      CALL WRTSTR(IUN,MDOC,LINE,IERR)
c 501                  FORMAT(1X,A8,1X,A6,1X,A4,1X,A4)
                    ENDIF
                  ENDDO
  510             CONTINUE
                ENDIF
              ENDIF
              J=LML_IATOM(I)
              K=LML_ICONN(I)
              IF(J.GT.0.AND.LML_PRSNT(I).NE.'M') THEN
                WRITE(LINE,'(''loop_'')')
                CALL WRTSTR(IUN,MDOC,LINE,IERR)
                WRITE(LINE,'(''_chem_comp_tree.comp_id'')')
                CALL WRTSTR(IUN,MDOC,LINE,IERR)
                WRITE(LINE,'(''_chem_comp_tree.atom_id'')')
                CALL WRTSTR(IUN,MDOC,LINE,IERR)
                WRITE(LINE,'(''_chem_comp_tree.atom_back'')')
                CALL WRTSTR(IUN,MDOC,LINE,IERR)
c                WRITE(LINE,'(''_chem_comp_tree.back_type'')')
c                CALL WRTSTR(IUN,MDOC,LINE,IERR)
                WRITE(LINE,'(''_chem_comp_tree.atom_forward'')')
                CALL WRTSTR(IUN,MDOC,LINE,IERR)

C               WRITE(LINE
C    *          ,'(''_chem_comp_tree.additional_connect_atom_id_1'')')
C               CALL WRTSTR(IUN,MDOC,LINE,IERR)
C               WRITE(LINE
C    *          ,'(''_chem_comp_tree.additional_connect_atom_id_2'')')
C               CALL WRTSTR(IUN,MDOC,LINE,IERR)
c               WRITE(LINE
c    *          ,'(''_chem_comp_tree.additional_connect_type'')')
c               CALL WRTSTR(IUN,MDOC,LINE,IERR)

                WRITE(LINE
     *          ,'(''_chem_comp_tree.connect_type'')')
                CALL WRTSTR(IUN,MDOC,LINE,IERR)

                IF(LMA_NATOM.GT.0) THEN
                  DO L=J,LMA_NATOM
                    IF(LMA_MNAME(L).NE.CH8) GO TO 610
C !!!
                    CHAR8 = LMA_TYPE(L)
                    IF(CHAR8.EQ.' ') CHAR8 = '.'
                    IF(LMA_BACK(L)(1:1).EQ.'.') CHAR8='START' 
                    IF(LMA_FORW(L).EQ.'END ') THEN
                      CHAR8       = 'END' 
                      LMA_FORW(L) = '.'
                    ENDIF
C !!!
                    CH4 = LMA_BACK(L)
                    IF(CH4(1:1).EQ.'.') CH4 = 'n/a '

                    WATOM1 = LMA_ANAME(L)
                    WATOM2 = CH4
                    WATOM3 = LMA_FORW(L)
                    CALL CORR_NAME_CIF_OUT(WATOM1)
                    CALL CORR_NAME_CIF_OUT(WATOM2)
                    CALL CORR_NAME_CIF_OUT(WATOM3)

                    WRITE(LINE,600) 
     *              LMA_MNAME(L)
     *             ,WATOM1,WATOM2,WATOM3
     *             ,CHAR8

C    *             ,POINT,POINT,TYPE
                    CALL WRTSTR(IUN,MDOC,LINE,IERR)
  600        FORMAT(1X,A8,1X,A6,1X,A6,1X,A6,1X,A8)
C 600        FORMAT(1X,A8,6X,A4,1X,A4,1X,A8,1X,A4,1X,A4,1X,A4,1X,A8)
                  ENDDO
  610             CONTINUE
                ENDIF
                IF(LMN_NCONN.GT.0.AND.K.GT.0) THEN
                  DO L=K,LMN_NCONN
                    IF(LMN_MNAME(L).NE.CH8) GO TO 620
                    CHAR8 = 'ADD'
                    WATOM1 = LMN_1ATM(L)
                    WATOM2 = LMN_2ATM(L)
                    CALL CORR_NAME_CIF_OUT(WATOM1)
                    CALL CORR_NAME_CIF_OUT(WATOM2)
                    WRITE(LINE,630)
     *              LMN_MNAME(L),WATOM1
     *             ,WATOM2,POINT,CHAR8

  630               FORMAT(1X,A8,1X,A6,1X,A6,1X,A,1X,A)

C    *              LMN_MNAME(L),POINT,POINT,TYPE,POINT,LMN_1ATM(L)
C    *             ,LMN_2ATM(L),LMN_TYPE(L)

                    CALL WRTSTR(IUN,MDOC,LINE,IERR)
                  ENDDO
  620             CONTINUE
                ENDIF
              ENDIF
              J=LML_IBOND(I)
              IF(J.GT.0) THEN
                WRITE(LINE,'(''loop_'')')
                CALL WRTSTR(IUN,MDOC,LINE,IERR)
                WRITE(LINE,'(''_chem_comp_bond.comp_id'')')
                CALL WRTSTR(IUN,MDOC,LINE,IERR)
                WRITE(LINE,'(''_chem_comp_bond.atom_id_1'')')
                CALL WRTSTR(IUN,MDOC,LINE,IERR)
                WRITE(LINE,'(''_chem_comp_bond.atom_id_2'')')
                CALL WRTSTR(IUN,MDOC,LINE,IERR)
                WRITE(LINE,'(''_chem_comp_bond.type'')')
                CALL WRTSTR(IUN,MDOC,LINE,IERR)
                IF(LML_PRSNT(I).NE.'M') THEN
                  WRITE(LINE,'(''_chem_comp_bond.value_dist'')')
                  CALL WRTSTR(IUN,MDOC,LINE,IERR)
                  WRITE(LINE,'(''_chem_comp_bond.value_dist_esd'')')
                  CALL WRTSTR(IUN,MDOC,LINE,IERR)
                ENDIF
                IF(LMB_NBOND.GT.0) THEN
                  DO L=J,LMB_NBOND
                    IF(LMB_MNAME(L).NE.CH8) GO TO 710
                    ESD=LMB_DEV(L)
                    IF(ESD.LE.0.0) ESD=0.02
                    WATOM1 = LMB_1ATM(L)
                    WATOM2 = LMB_2ATM(L)
                    CALL CORR_NAME_CIF_OUT(WATOM1)
                    CALL CORR_NAME_CIF_OUT(WATOM2)
                    IF(LML_PRSNT(I).NE.'M') THEN
                      WRITE(LINE,700) 
     *                LMB_MNAME(L)
     *               ,WATOM1,WATOM2,LMB_TYPE(L),LMB_VAL(L)
     *               ,ESD
                      CALL WRTSTR(IUN,MDOC,LINE,IERR)
  700                 FORMAT(1X,A8,1X,A6,1X,A6,4X,A8,1X,F8.3,1X,F8.3)
                    ELSE
                      WRITE(LINE,701) 
     *                LMB_MNAME(L)
     *               ,WATOM1,WATOM2,LMB_TYPE(L)
                      CALL WRTSTR(IUN,MDOC,LINE,IERR)
 701                  FORMAT(1X,A8,1X,A6,1X,A6,4X,A8)
                    ENDIF
                  ENDDO
  710             CONTINUE
                ENDIF
              ENDIF
              J=LML_ITHET(I)
              IF(J.GT.0) THEN
                WRITE(LINE,'(''loop_'')')
                CALL WRTSTR(IUN,MDOC,LINE,IERR)
                WRITE(LINE,'(''_chem_comp_angle.comp_id'')')
                CALL WRTSTR(IUN,MDOC,LINE,IERR)
                WRITE(LINE,'(''_chem_comp_angle.atom_id_1'')')
                CALL WRTSTR(IUN,MDOC,LINE,IERR)
                WRITE(LINE,'(''_chem_comp_angle.atom_id_2'')')
                CALL WRTSTR(IUN,MDOC,LINE,IERR)
                WRITE(LINE,'(''_chem_comp_angle.atom_id_3'')')
                CALL WRTSTR(IUN,MDOC,LINE,IERR)
                WRITE(LINE,'(''_chem_comp_angle.value_angle'')')
                CALL WRTSTR(IUN,MDOC,LINE,IERR)
                WRITE(LINE,'(''_chem_comp_angle.value_angle_esd'')')
                CALL WRTSTR(IUN,MDOC,LINE,IERR)
                IF(LMG_NANGL.GT.0) THEN
                  DO L=J,LMG_NANGL
                    IF(LMG_MNAME(L).NE.CH8) GO TO 810
                    ESD=LMG_DEV(L)
                    IF(ESD.LE.0.0) ESD=3.0
                    WATOM1 = LMG_1ATM(L)
                    WATOM2 = LMG_2ATM(L)
                    WATOM3 = LMG_3ATM(L)
                    CALL CORR_NAME_CIF_OUT(WATOM1)
                    CALL CORR_NAME_CIF_OUT(WATOM2)
                    CALL CORR_NAME_CIF_OUT(WATOM3)

                    WRITE(LINE,800) 
     *              LMG_MNAME(L)
     *             ,WATOM1,WATOM2,WATOM3,LMG_VAL(L)
     *             ,ESD
                    CALL WRTSTR(IUN,MDOC,LINE,IERR)
  800               FORMAT(1X,A8,1X,A6,1X,A6,1X,A6,1X,F8.3,1X,F8.3)
                  ENDDO
  810             CONTINUE
                ENDIF
              ENDIF
              J=LML_ITORS(I)
              IF(J.GT.0) THEN
                WRITE(LINE,'(''loop_'')')
                CALL WRTSTR(IUN,MDOC,LINE,IERR)
                WRITE(LINE,'(''_chem_comp_tor.comp_id'')')
                CALL WRTSTR(IUN,MDOC,LINE,IERR)
                WRITE(LINE,'(''_chem_comp_tor.id'')')
                CALL WRTSTR(IUN,MDOC,LINE,IERR)
                WRITE(LINE,'(''_chem_comp_tor.atom_id_1'')')
                CALL WRTSTR(IUN,MDOC,LINE,IERR)
                WRITE(LINE,'(''_chem_comp_tor.atom_id_2'')')
                CALL WRTSTR(IUN,MDOC,LINE,IERR)
                WRITE(LINE,'(''_chem_comp_tor.atom_id_3'')')
                CALL WRTSTR(IUN,MDOC,LINE,IERR)
                WRITE(LINE,'(''_chem_comp_tor.atom_id_4'')')
                CALL WRTSTR(IUN,MDOC,LINE,IERR)
                WRITE(LINE,'(''_chem_comp_tor.value_angle'')')
                CALL WRTSTR(IUN,MDOC,LINE,IERR)
                WRITE(LINE,'(''_chem_comp_tor.value_angle_esd'')')
                CALL WRTSTR(IUN,MDOC,LINE,IERR)
                WRITE(LINE,'(''_chem_comp_tor.period'')')
                CALL WRTSTR(IUN,MDOC,LINE,IERR)
                IF(LMT_NTORS.GT.0) THEN
                  IC=0
                  DO L=J,LMT_NTORS
                    IF(LMT_MNAME(L).NE.CH8) GO TO 910
                    ANGL=LMT_VAL(L)
                    IF(ANGL.GT. 180.0) ANGL=ANGL-360.0
                    IF(ANGL.LE.-180.0) ANGL=ANGL+360.0
                    IPRD=LMT_PRD(L)
                    ESD=LMT_DEV(L)
                    IF(ESD.LE.0.0) ESD = 20.0
                    CHAR8 =LMT_LABEL(L)
                    IF(IPRD.EQ.0) ESD=0.0
C !!!!
c                    IF(IPRD.EQ.0) IPRD=1
c                    IF(CHAR8(1:5).EQ.'CONST') THEN
c                      IPRD=0
c                      IC=IC+1
c                      IF(IC.GT.99) IC=99
c                      WRITE(CH2,'(I2)') IC
c                      IF(CH2(1:1).EQ.' ') CH2(1:1)='0'
c                      CHAR8='CONST_'//CH2
c  
c                      IF(IPRD.EQ.0) ESD=0.0
c
c                    ENDIF
C !!!
                    WATOM1 = LMT_1ATM(L) 
                    WATOM2 = LMT_2ATM(L) 
                    WATOM3 = LMT_3ATM(L)
                    WATOM4 = LMT_4ATM(L)
                    CALL CORR_NAME_CIF_OUT(WATOM1)
                    CALL CORR_NAME_CIF_OUT(WATOM2)
                    CALL CORR_NAME_CIF_OUT(WATOM3)
                    CALL CORR_NAME_CIF_OUT(WATOM4)

                    WRITE(LINE,900) 
     *              LMT_MNAME(L),CHAR8
     *             ,WATOM1,WATOM2,WATOM3,WATOM4
     *             ,ANGL,ESD,IPRD
                    CALL WRTSTR(IUN,MDOC,LINE,IERR)
  900               FORMAT(1X,A8,1X,A8,1X,A6,1X,A6,1X,A6,1X,A6,2X
     *              ,F8.3,1X,F8.3,1X,I3)
                  ENDDO

  910             CONTINUE
                ENDIF
              ENDIF
              J=LML_ICHIR(I)
              IF(J.GT.0) THEN
                IF(LMC_NCHIR.GT.0) THEN
                  IC     = 0
                  ICROSS = 0
                  DO L=J,LMC_NCHIR
                    IF(LMC_MNAME(L).NE.CH8) GO TO 1011
                    IF(LMC_SIGN(L)(1:6).EQ.'cross3'.OR.
     *                 LMC_SIGN(L)(1:6).EQ.'cross4'.OR.
     *                 LMC_SIGN(L)(1:6).EQ.'cross5'.OR.
     *                 LMC_SIGN(L)(1:6).EQ.'cross6'.OR.
     *                 LMC_SIGN(L)(1:5).EQ.'star5'.OR.
     *                 LMC_SIGN(L)(1:5).EQ.'star6'    ) ICROSS = 1
                  ENDDO
 1011             CONTINUE

                  WRITE(LINE,'(''loop_'')')
                  CALL WRTSTR(IUN,MDOC,LINE,IERR)
                  WRITE(LINE,'(''_chem_comp_chir.comp_id'')')
                  CALL WRTSTR(IUN,MDOC,LINE,IERR)
                  WRITE(LINE,'(''_chem_comp_chir.id'')')
                  CALL WRTSTR(IUN,MDOC,LINE,IERR)
                  WRITE(LINE,'(''_chem_comp_chir.atom_id_centre'')')
                  CALL WRTSTR(IUN,MDOC,LINE,IERR)
                  WRITE(LINE,'(''_chem_comp_chir.atom_id_1'')')
                  CALL WRTSTR(IUN,MDOC,LINE,IERR)
                  WRITE(LINE,'(''_chem_comp_chir.atom_id_2'')')
                  CALL WRTSTR(IUN,MDOC,LINE,IERR)
                  WRITE(LINE,'(''_chem_comp_chir.atom_id_3'')')
                  CALL WRTSTR(IUN,MDOC,LINE,IERR)
                  WRITE(LINE,'(''_chem_comp_chir.volume_sign'')')
                  CALL WRTSTR(IUN,MDOC,LINE,IERR)
                  IF(ICROSS.EQ.1) THEN
                    WRITE(LINE,'(''_chem_comp_chir.atom_id_4'')')
                    CALL WRTSTR(IUN,MDOC,LINE,IERR)
                    WRITE(LINE,'(''_chem_comp_chir.atom_id_5'')')
                    CALL WRTSTR(IUN,MDOC,LINE,IERR)
                    WRITE(LINE,'(''_chem_comp_chir.atom_id_6'')')
                    CALL WRTSTR(IUN,MDOC,LINE,IERR)
                    WRITE(LINE,'(''_chem_comp_chir.atom_id_7'')')
                    CALL WRTSTR(IUN,MDOC,LINE,IERR)
                    WRITE(LINE,'(''_chem_comp_chir.atom_id_8'')')
                    CALL WRTSTR(IUN,MDOC,LINE,IERR)
                  ENDIF

                  DO L=J,LMC_NCHIR
                    IF(LMC_MNAME(L).NE.CH8) GO TO 1010
C !!
                    IC=IC+1
                    IF(IC.GT.99) IC=99
                    WRITE(CH2,'(I2)') IC
                    IF(CH2(1:1).EQ.' ') CH2(1:1)='0'
                    CHAR8='chir_'//CH2  
C !!!
                    WATOM1 = LMC_1ATM(L) 
                    WATOM2 = LMC_2ATM(L) 
                    WATOM3 = LMC_3ATM(L)
                    WATOM4 = LMC_4ATM(L)
                    CALL CORR_NAME_CIF_OUT(WATOM1)
                    CALL CORR_NAME_CIF_OUT(WATOM2)
                    CALL CORR_NAME_CIF_OUT(WATOM3)
                    CALL CORR_NAME_CIF_OUT(WATOM4)
                    WRITE(LINE,1000) 
     *              LMC_MNAME(L),CHAR8
     *             ,WATOM1,WATOM2,WATOM3,WATOM4
     *             ,LMC_SIGN(L)
                    CALL WRTSTR(IUN,MDOC,LINE,IERR)
 1000               FORMAT(1X,A8,1X,A8,1X,A6,1X,A6,1X,A6,1X,A6,4X,A8)
                    IF(ICROSS.EQ.1) THEN
                      WATOM5 = LMC_5ATM(L) 
                      WATOM6 = LMC_6ATM(L) 
                      WATOM7 = LMC_7ATM(L)
                      WATOM8 = LMC_8ATM(L)
                      WATOM9 = LMC_9ATM(L)
                      CALL CORR_NAME_CIF_OUT(WATOM5)
                      CALL CORR_NAME_CIF_OUT(WATOM6)
                      CALL CORR_NAME_CIF_OUT(WATOM7)
                      CALL CORR_NAME_CIF_OUT(WATOM8)
                      CALL CORR_NAME_CIF_OUT(WATOM9)
                      WRITE(LINE,1001) 
     *                WATOM5,WATOM6,WATOM7,WATOM8,WATOM9
                      CALL WRTSTR(IUN,MDOC,LINE,IERR)
 1001                 FORMAT(19X,A6,1X,A6,1X,A6,1X,A6,1X,A6)
                    ENDIF
                  ENDDO
 1010             CONTINUE
                ENDIF

              ENDIF
              J=LML_IPLAN(I)
              IF(J.GT.0) THEN
                WRITE(LINE,'(''loop_'')')
                CALL WRTSTR(IUN,MDOC,LINE,IERR)
                WRITE(LINE,'(''_chem_comp_plane_atom.comp_id'')')
                CALL WRTSTR(IUN,MDOC,LINE,IERR)
                WRITE(LINE,'(''_chem_comp_plane_atom.plane_id'')')
                CALL WRTSTR(IUN,MDOC,LINE,IERR)
                WRITE(LINE,'(''_chem_comp_plane_atom.atom_id'')')
                CALL WRTSTR(IUN,MDOC,LINE,IERR)
                WRITE(LINE,'(''_chem_comp_plane_atom.dist_esd'')')
                CALL WRTSTR(IUN,MDOC,LINE,IERR)
                IF(LMP_NPLAN.GT.0) THEN
                  DO L=J,LMP_NPLAN
                    IF(LMP_MNAME(L).NE.CH8) GO TO 1110
                    DO K=1,LMP_NATOM(L)
                      IATOM  = LMP_ATOM(K,L)
                      WATOM1 = ATOM
                      CALL CORR_NAME_CIF_OUT(WATOM1)
                      WRITE(LINE,1100) 
     *                LMP_MNAME(L)
     *               ,LMP_LABEL(L),WATOM1,LMP_DEV(K,L)
                      CALL WRTSTR(IUN,MDOC,LINE,IERR)
 1100                 FORMAT(1X,A8,1X,A8,2X,A6,1X,F8.3)
                    ENDDO
                  ENDDO
 1110             CONTINUE
                ENDIF
              ENDIF
            ENDIF
          ENDDO
        ENDIF

        IF(MODE(1:3).EQ.'MON') GO TO 6200

 6000   CONTINUE
        IF(MODE(1:3).EQ.'MOD') GO TO 6100


        IF(LLL_NLINK.GT.0) THEN
        IFIRST=0
        DO I=1,LLL_NLINK
          IF((LLL_FUSE(I).EQ.'C'.AND.MODE.EQ.'LINC').OR.
     *       (MODE.EQ.'LINA')                       .OR.
     *       (LLL_FUSE(I).NE.'N'.AND.LLL_FUSE(I).NE.'?'.AND.
     *                               MODE.EQ.'LINL')) THEN
            IF(IFIRST.EQ.0) THEN
              WRITE(LINE,'(''#'')')
              CALL WRTSTR(IUN,MDOC,LINE,IERR)
              WRITE(LINE,'(''# --- DESCRIPTION OF LINKS ---'')')
              CALL WRTSTR(IUN,MDOC,LINE,IERR)
              WRITE(LINE,'(''#'')')
              IFIRST=1
            ENDIF
            CH8=LLL_LNAME(I)
            IF(LLL_NLINK.GT.1.AND.I.GT.1) THEN
              DO J=1,I-1
                IF(CH8.EQ.LLL_LNAME(J)) GO TO 6101
              ENDDO
            ENDIF
            WRITE(LINE,'(''#'')')
            CALL WRTSTR(IUN,MDOC,LINE,IERR)
            WRITE(LINE,'(''data_link_'',A8)') CH8
            CALL WRTSTR(IUN,MDOC,LINE,IERR)
            WRITE(LINE,'(''#'')')
            CALL WRTSTR(IUN,MDOC,LINE,IERR)


C           J=LLL_IATOM(I)
C           IF(J.GT.0) THEN
C              WRITE(LINE,'(''loop_'')')
C              CALL WRTSTR(IUN,MDOC,LINE,IERR)
C              WRITE(LINE,'(''_chem_link_atom_link_id'')')
C              CALL WRTSTR(IUN,MDOC,LINE,IERR)
C              WRITE(LINE,'(''_chem_link_atom_atom_id'')')
C              CALL WRTSTR(IUN,MDOC,LINE,IERR)
C              WRITE(LINE,'(''_chem_link_atom_type_symbol'')')
C              CALL WRTSTR(IUN,MDOC,LINE,IERR)
C              WRITE(LINE,'(''_chem_link_atom_type'')')
C              CALL WRTSTR(IUN,MDOC,LINE,IERR)
C              WRITE(LINE,'(''_chem_link_atom_charge'')')
C              CALL WRTSTR(IUN,MDOC,LINE,IERR)
C              IF(LLA_NATOM.GT.0) THEN
C                DO L=J,LLA_NATOM
C                  IF(LLA_MNAME(L).NE.CH8) GO TO 2510
C                  WRITE(LINE,2500) 
C     *            LLA_MNAME(L)
C     *           ,LLA_ANAME(L),LLA_SYMB(L),LLA_CHEM(L),LLA_CHARG(L)
C                  CALL WRTSTR(IUN,MDOC,LINE,IERR)
C 2500             FORMAT(1X,A8,6X,A4,1X,A4,1X,A4,3X,F8.3)
C                ENDDO
C 2510           CONTINUE
C              ENDIF
C           ENDIF
C           J=LLL_IATOM(I)
C            J=LLL_ICONN(I)
C            IF(J.GT.0) THEN
C              WRITE(LINE,'(''loop_'')')
C              CALL WRTSTR(IUN,MDOC,LINE,IERR)
C              WRITE(LINE,'(''_chem_link_tree.link_id'')')
C              CALL WRTSTR(IUN,MDOC,LINE,IERR)
C              WRITE(LINE,'(''_chem_link_tree.comp_flag_atom'')')
C              CALL WRTSTR(IUN,MDOC,LINE,IERR)
C              WRITE(LINE,'(''_chem_link_tree.atom_id'')')
C              CALL WRTSTR(IUN,MDOC,LINE,IERR)
C              WRITE(LINE,'(''_chem_link_tree.comp_flag_back'')')
C              CALL WRTSTR(IUN,MDOC,LINE,IERR)
C              WRITE(LINE,'(''_chem_link_tree.atom_back'')')
C              CALL WRTSTR(IUN,MDOC,LINE,IERR)
C              WRITE(LINE,'(''_chem_link_tree.back_type'')')
C              CALL WRTSTR(IUN,MDOC,LINE,IERR)
C              WRITE(LINE,'(''_chem_link_tree.comp_flag_forward'')')
C              CALL WRTSTR(IUN,MDOC,LINE,IERR)
C              WRITE(LINE,'(''_chem_link_tree.atom_forward'')')
C              CALL WRTSTR(IUN,MDOC,LINE,IERR)
C              WRITE(LINE,'(''_chem_link_tree.connect_type'')')
C              CALL WRTSTR(IUN,MDOC,LINE,IERR)
C
C              IF(LLN_NCONN.GT.0) THEN
C                DO L=J,LLN_NCONN
C                  IF(LLN_LNAME(L).NE.CH8) GO TO 2610
C                  WRITE(CH1_1,'(I1)') LLN_FATOM(L)
C                  WRITE(CH1_2,'(I1)') LLN_FBACK(L)
C                  WRITE(CH1_3,'(I1)') LLN_FFORW(L)
C                  WRITE(CH1_4,'(I1)') LLN_F1ATM(L)
C                  WRITE(CH1_5,'(I1)') LLN_F2ATM(L)
C                  IF(CH1_1.EQ.'0') CH1_1='.'
C                  IF(CH1_2.EQ.'0') CH1_2='.'
C                  IF(CH1_3.EQ.'0') CH1_3='.'
C                  IF(CH1_4.EQ.'0') CH1_4='.'
C                  IF(CH1_5.EQ.'0') CH1_5='.'
C
C
C !!!
C                  LLN_TYPE(L)='.'
C !!!!
C                    CH4 = LLN_BACK(L)
C                    IF(CH4(1:1).EQ.'.') CH4 = 'n/a '
C
C                  WRITE(LINE,2600) 
C     *            LLN_LNAME(L),CH1_1
C     *           ,LLN_ATOM(L),CH1_2,CH4,LLN_BTYPE(L)
C     *           ,CH1_3,LLN_FORW(L),LLN_TYPE(L)
C
C     *           ,CH1_3,LLN_FORW(L)   ,CH1_4,LLN_1ATM(L)
C     *           ,CH1_5,LLN_2ATM(L),LLN_TYPE(L)
C
C                  CALL WRTSTR(IUN,MDOC,LINE,IERR)
C 2600             FORMAT(1X,A8,1X,A1,1X,A4,1X,A1,1X,A4,1X,A8,1X,A1
C     *            ,1X,A4,1X,A8)
C 2600             FORMAT(1X,A8,1X,A1,1X,A4,1X,A1,1X,A4,1X,A8,1X,A1
C     *            ,1X,A4,1X,A1,1X,A4,1X,A1,1X,A4,1X,A8)
C                ENDDO
C 2610           CONTINUE
C              ENDIF
C            ENDIF

            J=LLL_IBOND(I)
            IF(J.GT.0) THEN
                WRITE(LINE,'(''loop_'')')
                CALL WRTSTR(IUN,MDOC,LINE,IERR)
                WRITE(LINE,'(''_chem_link_bond.link_id'')')
                CALL WRTSTR(IUN,MDOC,LINE,IERR)
                WRITE(LINE,'(''_chem_link_bond.atom_1_comp_id'')')
                CALL WRTSTR(IUN,MDOC,LINE,IERR)
                WRITE(LINE,'(''_chem_link_bond.atom_id_1'')')
                CALL WRTSTR(IUN,MDOC,LINE,IERR)
                WRITE(LINE,'(''_chem_link_bond.atom_2_comp_id'')')
                CALL WRTSTR(IUN,MDOC,LINE,IERR)
                WRITE(LINE,'(''_chem_link_bond.atom_id_2'')')
                CALL WRTSTR(IUN,MDOC,LINE,IERR)
                WRITE(LINE,'(''_chem_link_bond.type'')')
                CALL WRTSTR(IUN,MDOC,LINE,IERR)
                WRITE(LINE,'(''_chem_link_bond.value_dist'')')
                CALL WRTSTR(IUN,MDOC,LINE,IERR)
                WRITE(LINE,'(''_chem_link_bond.value_dist_esd'')')
                CALL WRTSTR(IUN,MDOC,LINE,IERR)
                IF(LLB_NBOND.GT.0) THEN
                  DO L=J,LLB_NBOND
                    IF(LLB_LNAME(L).NE.CH8) GO TO 2710
                    ESD=LLB_DEV(L)
                    IF(ESD.LE.0.0) ESD=0.02

                    WATOM1 = LLB_1ATM(L)
                    WATOM2 = LLB_2ATM(L)
                    CALL CORR_NAME_CIF_OUT(WATOM1)
                    CALL CORR_NAME_CIF_OUT(WATOM2)


                    WRITE(LINE,2700) 
     *              LLB_LNAME(L),LLB_F1ATM(L),WATOM1
     *             ,LLB_F2ATM(L),WATOM2,LLB_TYPE(L)
     *             ,LLB_VAL(L),ESD
                    CALL WRTSTR(IUN,MDOC,LINE,IERR)
 2700               FORMAT(1X,A8,1X,I1,1X,A6,2X,I1,1X,A6,4X,A8,1X
     *              ,F8.3,1X,F8.3)
                  ENDDO
 2710             CONTINUE
                ENDIF
            ENDIF
            J=LLL_ITHET(I)
            IF(J.GT.0) THEN
                WRITE(LINE,'(''loop_'')')
                CALL WRTSTR(IUN,MDOC,LINE,IERR)
                WRITE(LINE,'(''_chem_link_angle.link_id'')')
                CALL WRTSTR(IUN,MDOC,LINE,IERR)
                WRITE(LINE,'(''_chem_link_angle.atom_1_comp_id'')')
                CALL WRTSTR(IUN,MDOC,LINE,IERR)
                WRITE(LINE,'(''_chem_link_angle.atom_id_1'')')
                CALL WRTSTR(IUN,MDOC,LINE,IERR)
                WRITE(LINE,'(''_chem_link_angle.atom_2_comp_id'')')
                CALL WRTSTR(IUN,MDOC,LINE,IERR)
                WRITE(LINE,'(''_chem_link_angle.atom_id_2'')')
                CALL WRTSTR(IUN,MDOC,LINE,IERR)
                WRITE(LINE,'(''_chem_link_angle.atom_3_comp_id'')')
                CALL WRTSTR(IUN,MDOC,LINE,IERR)
                WRITE(LINE,'(''_chem_link_angle.atom_id_3'')')
                CALL WRTSTR(IUN,MDOC,LINE,IERR)
                WRITE(LINE,'(''_chem_link_angle.value_angle'')')
                CALL WRTSTR(IUN,MDOC,LINE,IERR)
                WRITE(LINE,'(''_chem_link_angle.value_angle_esd'')')
                CALL WRTSTR(IUN,MDOC,LINE,IERR)
                IF(LLG_NANGL.GT.0) THEN
                  DO L=J,LLG_NANGL
                    IF(LLG_LNAME(L).NE.CH8) GO TO 2810
                    ESD=LLG_DEV(L)
                    IF(ESD.LE.0.0) ESD=3.0

                    WATOM1 = LLG_1ATM(L)
                    WATOM2 = LLG_2ATM(L)
                    WATOM3 = LLG_3ATM(L)
                    CALL CORR_NAME_CIF_OUT(WATOM1)
                    CALL CORR_NAME_CIF_OUT(WATOM2)
                    CALL CORR_NAME_CIF_OUT(WATOM3)


                    WRITE(LINE,2800) 
     *              LLG_LNAME(L),LLG_F1ATM(L)
     *             ,WATOM1,LLG_F2ATM(L),WATOM2
     *             ,LLG_F3ATM(L),WATOM3
     *             ,LLG_VAL(L),ESD
                    CALL WRTSTR(IUN,MDOC,LINE,IERR)
 2800               FORMAT(1X,A8,1X,I1,1X,A6,2X,I1,1X,A6,2X,I1,1X,A6
     *              ,1X,F8.3,1X,F8.3)
                  ENDDO
 2810             CONTINUE
                ENDIF
            ENDIF
            J=LLL_ITORS(I)
            IF(J.GT.0) THEN
                WRITE(LINE,'(''loop_'')')
                CALL WRTSTR(IUN,MDOC,LINE,IERR)
                WRITE(LINE,'(''_chem_link_tor.link_id'')')
                CALL WRTSTR(IUN,MDOC,LINE,IERR)
                WRITE(LINE,'(''_chem_link_tor.id'')')
                CALL WRTSTR(IUN,MDOC,LINE,IERR)
                WRITE(LINE,'(''_chem_link_tor.atom_1_comp_id'')')
                CALL WRTSTR(IUN,MDOC,LINE,IERR)
                WRITE(LINE,'(''_chem_link_tor.atom_id_1'')')
                CALL WRTSTR(IUN,MDOC,LINE,IERR)
                WRITE(LINE,'(''_chem_link_tor.atom_2_comp_id'')')
                CALL WRTSTR(IUN,MDOC,LINE,IERR)
                WRITE(LINE,'(''_chem_link_tor.atom_id_2'')')
                CALL WRTSTR(IUN,MDOC,LINE,IERR)
                WRITE(LINE,'(''_chem_link_tor.atom_3_comp_id'')')
                CALL WRTSTR(IUN,MDOC,LINE,IERR)
                WRITE(LINE,'(''_chem_link_tor.atom_id_3'')')
                CALL WRTSTR(IUN,MDOC,LINE,IERR)
                WRITE(LINE,'(''_chem_link_tor.atom_4_comp_id'')')
                CALL WRTSTR(IUN,MDOC,LINE,IERR)
                WRITE(LINE,'(''_chem_link_tor.atom_id_4'')')
                CALL WRTSTR(IUN,MDOC,LINE,IERR)
                WRITE(LINE,'(''_chem_link_tor.value_angle'')')
                CALL WRTSTR(IUN,MDOC,LINE,IERR)
                WRITE(LINE,'(''_chem_link_tor.value_angle_esd'')')
                CALL WRTSTR(IUN,MDOC,LINE,IERR)
                WRITE(LINE,'(''_chem_link_tor.period'')')
                CALL WRTSTR(IUN,MDOC,LINE,IERR)
                IF(LLT_NTORS.GT.0) THEN
                  DO L=J,LLT_NTORS
                    IF(LLT_LNAME(L).NE.CH8) GO TO 2910
                    ESD=LLT_DEV(L)
                    IF(ESD.LE.0.0) ESD=20.0
                    WATOM1 = LLT_1ATM(L) 
                    WATOM2 = LLT_2ATM(L)
                    WATOM3 = LLT_3ATM(L)
                    WATOM4 = LLT_4ATM(L)
                    CALL CORR_NAME_CIF_OUT(WATOM1)
                    CALL CORR_NAME_CIF_OUT(WATOM2)
                    CALL CORR_NAME_CIF_OUT(WATOM3)
                    CALL CORR_NAME_CIF_OUT(WATOM4)
                    WRITE(LINE,2900) 
     *              LLT_LNAME(L),LLT_LABEL(L),LLT_F1ATM(L),WATOM1
     *             ,LLT_F2ATM(L),WATOM2      ,LLT_F3ATM(L),WATOM3
     *             ,LLT_F4ATM(L),WATOM4
     *             ,LLT_VAL(L),ESD,LLT_PRD(L)
                    CALL WRTSTR(IUN,MDOC,LINE,IERR)
 2900               FORMAT(1X,A8,1X,A8,1X,I1,1X,A6,1X,I1,1X,A6,1X,I1
     *              ,1X,A6,1X,I1,1X,A6,1X,F7.2,1X,F5.1,1X,I1)
                  ENDDO
 2910             CONTINUE
                ENDIF
            ENDIF
            J=LLL_ICHIR(I)
            IF(J.GT.0) THEN
                WRITE(LINE,'(''loop_'')')
                CALL WRTSTR(IUN,MDOC,LINE,IERR)
                WRITE(LINE,'(''_chem_link_chir.link_id'')')
                CALL WRTSTR(IUN,MDOC,LINE,IERR)

C                WRITE(LINE,'(''_chem_link_chir.id'')')
C                CALL WRTSTR(IUN,MDOC,LINE,IERR)

           WRITE(LINE,'(''_chem_link_chir.atom_centre_comp_id'')')
                CALL WRTSTR(IUN,MDOC,LINE,IERR)
                WRITE(LINE,'(''_chem_link_chir.atom_id_centre'')')
                CALL WRTSTR(IUN,MDOC,LINE,IERR)
                WRITE(LINE,'(''_chem_link_chir.atom_1_comp_id'')')
                CALL WRTSTR(IUN,MDOC,LINE,IERR)
                WRITE(LINE,'(''_chem_link_chir.atom_id_1'')')
                CALL WRTSTR(IUN,MDOC,LINE,IERR)
                WRITE(LINE,'(''_chem_link_chir.atom_2_comp_id'')')
                CALL WRTSTR(IUN,MDOC,LINE,IERR)
                WRITE(LINE,'(''_chem_link_chir.atom_id_2'')')
                CALL WRTSTR(IUN,MDOC,LINE,IERR)
                WRITE(LINE,'(''_chem_link_chir.atom_3_comp_id'')')
                CALL WRTSTR(IUN,MDOC,LINE,IERR)
                WRITE(LINE,'(''_chem_link_chir.atom_id_3'')')
                CALL WRTSTR(IUN,MDOC,LINE,IERR)
                WRITE(LINE,'(''_chem_link_chir.volume_sign'')')
                CALL WRTSTR(IUN,MDOC,LINE,IERR)
                IF(LLC_NCHIR.GT.0) THEN
                  DO L=J,LLC_NCHIR
                    IF(LLC_LNAME(L).NE.CH8) GO TO 3010
C !!!
                    CHAR8='.'
C !!!
                    WATOM1 = LLC_1ATM(L)
                    WATOM2 = LLC_2ATM(L)
                    WATOM3 = LLC_3ATM(L)
                    WATOM4 = LLC_4ATM(L)
                    CALL CORR_NAME_CIF_OUT(WATOM1)
                    CALL CORR_NAME_CIF_OUT(WATOM2)
                    CALL CORR_NAME_CIF_OUT(WATOM3)
                    CALL CORR_NAME_CIF_OUT(WATOM4)
                    WRITE(LINE,3000) 
     *              LLC_LNAME(L),LLC_F1ATM(L),WATOM1
     *             ,LLC_F2ATM(L),WATOM2,LLC_F3ATM(L),WATOM3
     *             ,LLC_F4ATM(L),WATOM4
     *             ,LLC_SIGN(L)
                    CALL WRTSTR(IUN,MDOC,LINE,IERR)
 3000               FORMAT(1X,A8,3X,I1,1X,A6,2X,I1
     *              ,1X,A6,2X,I1,1X,A6,2X,I1,1X,A6,2X,A8)
                  ENDDO
 3010             CONTINUE
                ENDIF
            ENDIF
            J=LLL_IPLAN(I)
            IF(J.GT.0) THEN
                WRITE(LINE,'(''loop_'')')
                CALL WRTSTR(IUN,MDOC,LINE,IERR)
                WRITE(LINE,'(''_chem_link_plane.link_id'')')
                CALL WRTSTR(IUN,MDOC,LINE,IERR)
                WRITE(LINE,'(''_chem_link_plane.plane_id'')')
                CALL WRTSTR(IUN,MDOC,LINE,IERR)
                WRITE(LINE,'(''_chem_link_plane.atom_comp_id'')')
                CALL WRTSTR(IUN,MDOC,LINE,IERR)
                WRITE(LINE,'(''_chem_link_plane.atom_id'')')
                CALL WRTSTR(IUN,MDOC,LINE,IERR)
                WRITE(LINE,'(''_chem_link_plane.dist_esd'')')
                CALL WRTSTR(IUN,MDOC,LINE,IERR)
                IF(LLP_NPLAN.GT.0) THEN
                  DO L=J,LLP_NPLAN
                    IF(LLP_LNAME(L).NE.CH8) GO TO 3110
                    DO K=1,LLP_NATOM(L)
                      IATOM = LLP_ATOM(K,L)
                      WATOM1 = ATOM
                      CALL CORR_NAME_CIF_OUT(WATOM1)
                      WRITE(LINE,3100) 
     *                LLP_LNAME(L),LLP_LABEL(L)
     *               ,LLP_FATOM(K,L),WATOM1,LLP_DEV(K,L)
                      CALL WRTSTR(IUN,MDOC,LINE,IERR)
 3100                 FORMAT(1X,A8,3X,A8,2X,I1,1X,A6,1X,F8.3)
                    ENDDO
                  ENDDO
 3110             CONTINUE
                ENDIF
            ENDIF
          ENDIF
 6101     CONTINUE
        ENDDO
        ENDIF

 6100   CONTINUE
        IF(MODE(1:3).EQ.'LIN') GO TO 6200

        IF(LDL_NMOD.GT.0) THEN
        IFIRST=0
        DO I=1,LDL_NMOD
          IF((LDL_FUSE(I).EQ.'C'.AND.MODE.EQ.'MODC').OR.
     *       (MODE.EQ.'MODA')                       .OR.
     *       (LDL_FUSE(I).NE.'N'.AND.LDL_FUSE(I).NE.'?'.AND.
     *                               MODE.EQ.'MODL')) THEN
            IF(IFIRST.EQ.0) THEN
              WRITE(LINE,'(''#'')')
              CALL WRTSTR(IUN,MDOC,LINE,IERR)
              WRITE(LINE,'(''# --- DESCRIPTION OF MODIFICATIONS ---'')')
              CALL WRTSTR(IUN,MDOC,LINE,IERR)
              WRITE(LINE,'(''#'')')
              IFIRST=1
            ENDIF
C            IF(LDL_SUB_MOD(I)(1:1).EQ.'.') THEN
              CH8=LDL_MNAME(I)
              WRITE(LINE,'(''#'')')
              CALL WRTSTR(IUN,MDOC,LINE,IERR)
              WRITE(LINE,'(''data_mod_'',A8)') CH8
              CALL WRTSTR(IUN,MDOC,LINE,IERR)
              WRITE(LINE,'(''#'')')
              CALL WRTSTR(IUN,MDOC,LINE,IERR)
              J=LDL_IATOM(I)
              IF(J.GT.0) THEN
                WRITE(LINE,'(''loop_'')')
                CALL WRTSTR(IUN,MDOC,LINE,IERR)
                WRITE(LINE,'(''_chem_mod_atom.mod_id'')')
                CALL WRTSTR(IUN,MDOC,LINE,IERR)
                WRITE(LINE,'(''_chem_mod_atom.function'')')
                CALL WRTSTR(IUN,MDOC,LINE,IERR)
                WRITE(LINE,'(''_chem_mod_atom.atom_id'')')
                CALL WRTSTR(IUN,MDOC,LINE,IERR)
                WRITE(LINE,'(''_chem_mod_atom.new_atom_id'')')
                CALL WRTSTR(IUN,MDOC,LINE,IERR)
                WRITE(LINE,'(''_chem_mod_atom.new_type_symbol'')')
                CALL WRTSTR(IUN,MDOC,LINE,IERR)
                WRITE(LINE,'(''_chem_mod_atom.new_type_energy'')')
                CALL WRTSTR(IUN,MDOC,LINE,IERR)
                WRITE(LINE,'(''_chem_mod_atom.new_partial_charge'')')
                CALL WRTSTR(IUN,MDOC,LINE,IERR)
                IF(LDA_NATOM.GT.0) THEN
                  DO L=J,LDA_NATOM
                    IF(LDA_MNAME(L).NE.CH8) GO TO 4510
                    WATOM1 = LDA_ANAME(L) 
                    WATOM2 = LDA_ANEW(L)
                    CALL CORR_NAME_CIF_OUT(WATOM1)
                    CALL CORR_NAME_CIF_OUT(WATOM2)
                    WRITE(LINE,4500) 
     *              LDA_MNAME(L),LDA_FUNCT(L)
     *              ,WATOM1,WATOM2,LDA_SYMB(L),LDA_CHEM(L)
     *              ,LDA_CHARG(L)
                    CALL WRTSTR(IUN,MDOC,LINE,IERR)
 4500               FORMAT(1X,A8,1X,A8,1X,A6,1X,A6,1X,A4,1X,A4,1X,F8.3)
                  ENDDO
 4510             CONTINUE
                ENDIF
              ENDIF
              J=LDL_IATOM(I)
              K=LDL_ICONN(I)
              IF(K.GT.0) THEN
                WRITE(LINE,'(''loop_'')')
                CALL WRTSTR(IUN,MDOC,LINE,IERR)
                WRITE(LINE,'(''_chem_mod_tree.mod_id'')')
                CALL WRTSTR(IUN,MDOC,LINE,IERR)
                WRITE(LINE,'(''_chem_mod_tree.function'')')
                CALL WRTSTR(IUN,MDOC,LINE,IERR)
                WRITE(LINE,'(''_chem_mod_tree.atom_id'')')
                CALL WRTSTR(IUN,MDOC,LINE,IERR)
                WRITE(LINE,'(''_chem_mod_tree.atom_back'')')
                CALL WRTSTR(IUN,MDOC,LINE,IERR)
                WRITE(LINE,'(''_chem_mod_tree.back_type'')')
                CALL WRTSTR(IUN,MDOC,LINE,IERR)
                WRITE(LINE,'(''_chem_mod_tree.atom_forward'')')
                CALL WRTSTR(IUN,MDOC,LINE,IERR)
                WRITE(LINE,'(''_chem_mod_tree.connect_type'')')
                CALL WRTSTR(IUN,MDOC,LINE,IERR)

                IF(LDN_NCONN.GT.0) THEN
                  DO L=K,LDN_NCONN
                    IF(LDN_MNAME(L).NE.CH8) GO TO 4610

C !!!!
C                    CHAR8='.'
C                    IF(LDN_BACK(L)(1:1).EQ.'.'.AND.
C     *                 LDN_FUNCT(L)(1:6).NE.'delete') THEN
C                      CHAR8='START' 
C                      LMA_BACK(L)='.'
C                    ENDIF
C                    IF(LDN_FORW(L)(1:3).EQ.'END') THEN 
C                      CHAR8='END' 
C                      LMA_FORW(L)='.'
C                    ENDIF
C                    LDN_TYPE(L)=CHAR8
C !!!!
                    CH4 = LDN_BACK(L)
                    IF(CH4(1:1).EQ.'.') CH4 = 'n/a '
                    WATOM1 = LDN_ATOM(L)
                    WATOM2 = CH4
                    WATOM3 = LDN_FORW(L)
                    CALL CORR_NAME_CIF_OUT(WATOM1)
                    CALL CORR_NAME_CIF_OUT(WATOM2)
                    CALL CORR_NAME_CIF_OUT(WATOM3)

                    WRITE(LINE,4600) 
     *              LDN_MNAME(L),LDN_FUNCT(L)
     *             ,WATOM1,WATOM2,LDN_BTYPE(L)
     *             ,WATOM3,LDN_TYPE(L)

c     *             ,LDN_FORW(L),LDN_1ATM(L)
c     *             ,LDN_2ATM(L),LDN_TYPE(L)
                    CALL WRTSTR(IUN,MDOC,LINE,IERR)
 4600               FORMAT(1X,A8,1X,A8,1X,A6,1X,A6,1X,A8
     *              ,1X,A6,1X,A8)
                  ENDDO
 4610             CONTINUE
                ENDIF
              ENDIF
              J=LDL_IBOND(I)
              IF(J.GT.0) THEN
                WRITE(LINE,'(''loop_'')')
                CALL WRTSTR(IUN,MDOC,LINE,IERR)
                WRITE(LINE,'(''_chem_mod_bond.mod_id'')')
                CALL WRTSTR(IUN,MDOC,LINE,IERR)
                WRITE(LINE,'(''_chem_mod_bond.function'')')
                CALL WRTSTR(IUN,MDOC,LINE,IERR)
                WRITE(LINE,'(''_chem_mod_bond.atom_id_1'')')
                CALL WRTSTR(IUN,MDOC,LINE,IERR)
                WRITE(LINE,'(''_chem_mod_bond.atom_id_2'')')
                CALL WRTSTR(IUN,MDOC,LINE,IERR)
                WRITE(LINE,'(''_chem_mod_bond.new_type'')')
                CALL WRTSTR(IUN,MDOC,LINE,IERR)
                WRITE(LINE,'(''_chem_mod_bond.new_value_dist'')')
                CALL WRTSTR(IUN,MDOC,LINE,IERR)
                WRITE(LINE,'(''_chem_mod_bond.new_value_dist_esd'')')
                CALL WRTSTR(IUN,MDOC,LINE,IERR)
                IF(LDB_NBOND.GT.0) THEN
                  DO L=J,LDB_NBOND
                    IF(LDB_MNAME(L).NE.CH8) GO TO 4710
                    ESD=LDB_DEV(L)
                    IF(ESD.LE.0.0) ESD=0.02
                    WATOM1 = LDB_1ATM(L) 
                    WATOM2 = LDB_2ATM(L)
                    CALL CORR_NAME_CIF_OUT(WATOM1)
                    CALL CORR_NAME_CIF_OUT(WATOM2)
                    WRITE(LINE,4700) 
     *              LDB_MNAME(L),LDB_FUNCT(L),WATOM1
     *             ,WATOM2,LDB_TYPE(L)
     *             ,LDB_VAL(L),ESD
                    CALL WRTSTR(IUN,MDOC,LINE,IERR)
 4700               FORMAT(1X,A8,1X,A8,1X,A6,2X,A6,4X,A8,1X
     *              ,F8.3,1X,F8.3)
                  ENDDO
 4710             CONTINUE
                ENDIF
              ENDIF
              J=LDL_ITHET(I)
              IF(J.GT.0) THEN
                WRITE(LINE,'(''loop_'')')
                CALL WRTSTR(IUN,MDOC,LINE,IERR)
                WRITE(LINE,'(''_chem_mod_angle.mod_id'')')
                CALL WRTSTR(IUN,MDOC,LINE,IERR)
                WRITE(LINE,'(''_chem_mod_angle.function'')')
                CALL WRTSTR(IUN,MDOC,LINE,IERR)
                WRITE(LINE,'(''_chem_mod_angle.atom_id_1'')')
                CALL WRTSTR(IUN,MDOC,LINE,IERR)
                WRITE(LINE,'(''_chem_mod_angle.atom_id_2'')')
                CALL WRTSTR(IUN,MDOC,LINE,IERR)
                WRITE(LINE,'(''_chem_mod_angle.atom_id_3'')')
                CALL WRTSTR(IUN,MDOC,LINE,IERR)
                WRITE(LINE,'(''_chem_mod_angle.new_value_angle'')')
                CALL WRTSTR(IUN,MDOC,LINE,IERR)
                WRITE(LINE,'(''_chem_mod_angle.new_value_angle_esd'')')
                CALL WRTSTR(IUN,MDOC,LINE,IERR)
                IF(LDG_NANGL.GT.0) THEN
                  DO L=J,LDG_NANGL
                    IF(LDG_MNAME(L).NE.CH8) GO TO 4810
                    ESD=LDG_DEV(L)
                    IF(ESD.LE.0.0) ESD=3.0
                    WATOM1 = LDG_1ATM(L)
                    WATOM2 = LDG_2ATM(L)
                    WATOM3 = LDG_3ATM(L)
                    CALL CORR_NAME_CIF_OUT(WATOM1)
                    CALL CORR_NAME_CIF_OUT(WATOM2)
                    CALL CORR_NAME_CIF_OUT(WATOM3)
                    WRITE(LINE,4800) 
     *              LDG_MNAME(L),LDG_FUNCT(L)
     *             ,WATOM1,WATOM2
     *             ,WATOM3
     *             ,LDG_VAL(L),ESD
                    CALL WRTSTR(IUN,MDOC,LINE,IERR)
 4800               FORMAT(1X,A8,1X,A8,1X,A6,2X,A6,2X,A6
     *              ,1X,F8.3,1X,F8.3)
                  ENDDO
 4810             CONTINUE
                ENDIF
              ENDIF
              J=LDL_ITORS(I)
              IF(J.GT.0) THEN
                WRITE(LINE,'(''loop_'')')
                CALL WRTSTR(IUN,MDOC,LINE,IERR)
                WRITE(LINE,'(''_chem_mod_tor.mod_id'')')
                CALL WRTSTR(IUN,MDOC,LINE,IERR)
                WRITE(LINE,'(''_chem_mod_tor.function'')')
                CALL WRTSTR(IUN,MDOC,LINE,IERR)
                WRITE(LINE,'(''_chem_mod_tor.id'')')
                CALL WRTSTR(IUN,MDOC,LINE,IERR)
                WRITE(LINE,'(''_chem_mod_tor.atom_id_1'')')
                CALL WRTSTR(IUN,MDOC,LINE,IERR)
                WRITE(LINE,'(''_chem_mod_tor.atom_id_2'')')
                CALL WRTSTR(IUN,MDOC,LINE,IERR)
                WRITE(LINE,'(''_chem_mod_tor.atom_id_3'')')
                CALL WRTSTR(IUN,MDOC,LINE,IERR)
                WRITE(LINE,'(''_chem_mod_tor.atom_id_4'')')
                CALL WRTSTR(IUN,MDOC,LINE,IERR)
                WRITE(LINE,'(''_chem_mod_tor.new_value_angle'')')
                CALL WRTSTR(IUN,MDOC,LINE,IERR)
                WRITE(LINE,'(''_chem_mod_tor.new_value_angle_esd'')')
                CALL WRTSTR(IUN,MDOC,LINE,IERR)
                WRITE(LINE,'(''_chem_mod_tor.new_period'')')
                CALL WRTSTR(IUN,MDOC,LINE,IERR)
                IF(LDT_NTORS.GT.0) THEN
                  DO L=J,LDT_NTORS
                    IF(LDT_MNAME(L).NE.CH8) GO TO 4910
                    ESD=LDT_DEV(L)
                    IF(ESD.LE.0.0) ESD=20.0
                    WATOM1 = LDT_1ATM(L)
                    WATOM2 = LDT_2ATM(L)
                    WATOM3 = LDT_3ATM(L)
                    WATOM4 = LDT_4ATM(L)
                    CALL CORR_NAME_CIF_OUT(WATOM1)
                    CALL CORR_NAME_CIF_OUT(WATOM2)
                    CALL CORR_NAME_CIF_OUT(WATOM3)
                    CALL CORR_NAME_CIF_OUT(WATOM4)
                    WRITE(LINE,4900) 
     *              LDT_MNAME(L),LDT_FUNCT(L),LDT_LABEL(L)
     *             ,WATOM1,WATOM2,WATOM3,WATOM4
     *             ,LDT_VAL(L),ESD,LDT_PRD(L)
                    CALL WRTSTR(IUN,MDOC,LINE,IERR)
 4900               FORMAT(1X,A8,1X,A8,1X,A8,1X,A6,1X,A6
     *              ,1X,A6,1X,A6,1X,F7.2,1X,F5.1,1X,I1)
                  ENDDO
 4910             CONTINUE
                ENDIF
              ENDIF

              J=LDL_ICHIR(I)
              IF(J.GT.0) THEN

                IF(LDC_NCHIR.GT.0) THEN
                  ICROSS = 0
                  DO L=J,LDC_NCHIR
                    IF(LDC_MNAME(L).NE.CH8) GO TO 5011
                    IF(LDC_SIGN(L)(1:6).EQ.'cross3'.OR.
     *                 LDC_SIGN(L)(1:6).EQ.'cross4'.OR.
     *                 LDC_SIGN(L)(1:6).EQ.'cross5'.OR.
     *                 LDC_SIGN(L)(1:6).EQ.'cross6'.OR.
     *                 LDC_SIGN(L)(1:5).EQ.'star5'.OR.
     *                 LDC_SIGN(L)(1:5).EQ.'star6'    ) ICROSS = 1
                  ENDDO
 5011             CONTINUE
                ENDIF

                WRITE(LINE,'(''loop_'')')
                CALL WRTSTR(IUN,MDOC,LINE,IERR)
                WRITE(LINE,'(''_chem_mod_chir.mod_id'')')
                CALL WRTSTR(IUN,MDOC,LINE,IERR)

C                WRITE(LINE,'(''_chem_mod_chir.id'')')
C                CALL WRTSTR(IUN,MDOC,LINE,IERR)

                WRITE(LINE,'(''_chem_mod_chir.function'')')
                CALL WRTSTR(IUN,MDOC,LINE,IERR)
                WRITE(LINE,'(''_chem_mod_chir.atom_id_centre'')')
                CALL WRTSTR(IUN,MDOC,LINE,IERR)
                WRITE(LINE,'(''_chem_mod_chir.atom_id_1'')')
                CALL WRTSTR(IUN,MDOC,LINE,IERR)
                WRITE(LINE,'(''_chem_mod_chir.atom_id_2'')')
                CALL WRTSTR(IUN,MDOC,LINE,IERR)
                WRITE(LINE,'(''_chem_mod_chir.atom_id_3'')')
                CALL WRTSTR(IUN,MDOC,LINE,IERR)
                WRITE(LINE,'(''_chem_mod_chir.new_volume_sign'')')
                CALL WRTSTR(IUN,MDOC,LINE,IERR)
                  IF(ICROSS.EQ.1) THEN
                    WRITE(LINE,'(''_chem_mod_chir.atom_id_4'')')
                    CALL WRTSTR(IUN,MDOC,LINE,IERR)
                    WRITE(LINE,'(''_chem_mod_chir.atom_id_5'')')
                    CALL WRTSTR(IUN,MDOC,LINE,IERR)
                    WRITE(LINE,'(''_chem_mod_chir.atom_id_6'')')
                    CALL WRTSTR(IUN,MDOC,LINE,IERR)
                    WRITE(LINE,'(''_chem_mod_chir.atom_id_7'')')
                    CALL WRTSTR(IUN,MDOC,LINE,IERR)
                    WRITE(LINE,'(''_chem_mod_chir.atom_id_8'')')
                    CALL WRTSTR(IUN,MDOC,LINE,IERR)
                  ENDIF

                IF(LDC_NCHIR.GT.0) THEN
                  DO L=J,LDC_NCHIR
                    IF(LDC_MNAME(L).NE.CH8) GO TO 5010
C !!!
                    CHAR8='.'
C !!! 
                    WATOM1 = LDC_1ATM(L)
                    WATOM2 = LDC_2ATM(L)
                    WATOM3 = LDC_3ATM(L)
                    WATOM4 = LDC_4ATM(L)
                    CALL CORR_NAME_CIF_OUT(WATOM1)
                    CALL CORR_NAME_CIF_OUT(WATOM2)
                    CALL CORR_NAME_CIF_OUT(WATOM3)
                    CALL CORR_NAME_CIF_OUT(WATOM4)
                    WRITE(LINE,5000) 
     *              LDC_MNAME(L),LDC_FUNCT(L)
     *             ,WATOM1,WATOM2,WATOM3,WATOM4
     *             ,LDC_SIGN(L)
                    CALL WRTSTR(IUN,MDOC,LINE,IERR)
 5000               FORMAT(1X,A8,3X,1X,A8,1X,A6,2X,A6,2X,A6
     *              ,2X,A6,2X,A8)
                    IF(ICROSS.EQ.1) THEN
                      WATOM5 = LDC_5ATM(L) 
                      WATOM6 = LDC_6ATM(L) 
                      WATOM7 = LDC_7ATM(L)
                      WATOM8 = LDC_8ATM(L)
                      WATOM9 = LDC_9ATM(L)
                      CALL CORR_NAME_CIF_OUT(WATOM5)
                      CALL CORR_NAME_CIF_OUT(WATOM6)
                      CALL CORR_NAME_CIF_OUT(WATOM7)
                      CALL CORR_NAME_CIF_OUT(WATOM8)
                      CALL CORR_NAME_CIF_OUT(WATOM9)
                      WRITE(LINE,5001) 
     *                WATOM5,WATOM6,WATOM7,WATOM8,WATOM9
                      CALL WRTSTR(IUN,MDOC,LINE,IERR)
 5001                 FORMAT(19X,A6,1X,A6,1X,A6,1X,A6,1X,A6)
                    ENDIF

                  ENDDO
 5010             CONTINUE
                ENDIF
              ENDIF
              J=LDL_IPLAN(I)
              IF(J.GT.0) THEN
                WRITE(LINE,'(''loop_'')')
                CALL WRTSTR(IUN,MDOC,LINE,IERR)
                WRITE(LINE,'(''_chem_mod_plane_atom.mod_id'')')
                CALL WRTSTR(IUN,MDOC,LINE,IERR)
                WRITE(LINE,'(''_chem_mod_plane_atom.function'')')
                CALL WRTSTR(IUN,MDOC,LINE,IERR)
                WRITE(LINE,'(''_chem_mod_plane_atom.plane_id'')')
                CALL WRTSTR(IUN,MDOC,LINE,IERR)
                WRITE(LINE,'(''_chem_mod_plane_atom.atom_id'')')
                CALL WRTSTR(IUN,MDOC,LINE,IERR)
                WRITE(LINE,'(''_chem_mod_plane_atom.new_dist_esd'')')
                CALL WRTSTR(IUN,MDOC,LINE,IERR)
                IF(LDP_NPLAN.GT.0) THEN
                  DO L=J,LDP_NPLAN
                    IF(LDP_MNAME(L).NE.CH8) GO TO 5110
                    DO K=1,LDP_NATOM(L)
                      IATOM  = LDP_ATOM(K,L)
                      WATOM1 = ATOM
                      CALL CORR_NAME_CIF_OUT(WATOM1)
                      WRITE(LINE,5100) 
     *                LDP_MNAME(L),LDP_FUNCT(L),LDP_LABEL(L)
     *               ,WATOM1,LDP_DEV(K,L)
                      CALL WRTSTR(IUN,MDOC,LINE,IERR)
 5100                 FORMAT(1X,A8,3X,A8,2X,A8,1X,A6,1X,F8.3)
                    ENDDO
                  ENDDO
 5110             CONTINUE
                ENDIF
              ENDIF
C            ENDIF

          ENDIF
        ENDDO
        ENDIF

 6200   CONTINUE

        WRITE(LINE,'(A)')
     *  '# ------------------------------------------------------'
        CALL WRTSTR(IUN,MDOC,LINE,IERR)

      ELSE IF(MODE.EQ.'STOP') THEN
        IF(LMO_IUN.EQ.0) THEN
          CALL MSGERR(MDOC,' ERR: output_lib_file can''t be close')
          IERR=1
          RETURN
        ENDIF
        END FILE LMO_IUN
        CLOSE(LMO_IUN)
        LMO_IUN = 0
      ENDIF
C -----------------------------------
      RETURN
      END     


C ******
      SUBROUTINE WRT_LIB_NEW(MDOC,MODE,ICRD,IERR)
C -------------------------------------------------------
C -P- WRT_LIB - writes library to the file.
C
C     MODE:  TITC - titles only for new
C            TITA - all
C            TITL - 'Y', 'C', except 'N' , 'C'
C            MONL
C            MONC
C            MONA
C            MODL
C            MODC
C            MODA
C            LINL
C            LINC
C            LINA
C
C            STOP
C
C -S-
C -------------------------------------------------------
      INTEGER*4 MDOC,IERR,ICRD
      CHARACTER MODE*4
C ******
C -----------------------------------------------
      INCLUDE 'lib_com.fh'
C -----------------------------------
      INCLUDE 'crd_com.fh'
C ----------------------------------
      INTEGER*4 IATOM
      CHARACTER LINE*256
      CHARACTER ATOM*4,CH1_1*1,CH1_2*1,CH2*2,CH3*3,POINT*4
      CHARACTER TYPE*8,CH8*8,CHAR8*8
      CHARACTER WATOM1*6,WATOM2*6,WATOM3*6,WATOM4*6
C     CHARACTER CH1_3*1,CH1_4*1,CH1_5*1,CH5*5
      CHARACTER STR*80,TITLE_M*80,CH4*4
      EQUIVALENCE (IATOM,ATOM)
      DATA POINT/'.   '/,TYPE/'.       '/
C -----------------------------------
  
      IF(MODE(1:3).EQ.'TIT') THEN
        IF(ICRD.EQ.0) THEN
          IF(LMO_FILE.EQ.' ') RETURN
          IERR=0
C         open file 
          IF(LMO_IUN.NE.0) THEN
            CALL MSGERR(MDOC,' ERR: output_lib_file was open before')
            IERR=1
            RETURN
          ENDIF
          M   = 99

C         IUN = 11
          IUN = CRO3_IUN
          CALL OPENFW(IUN,M,LMO_PATH,LMO_FILE,LMO_EXT,IERR)
          CRO3_IUN = IUN

          IF(IERR.NE.0) THEN
            CALL MSGERR(MDOC,' ERR: can''t open output_lib_file')
            RETURN
          ENDIF
          LMO_IUN = IUN
          WRITE(LINE,'(''global_'')') 
          CALL WRTSTR(IUN,MDOC,LINE,IERR)
          WRITE(LINE,'(''_lib_name   '',6X,A)') LB_NAME(1:16)
          CALL WRTSTR(IUN,MDOC,LINE,IERR)
          WRITE(LINE,'(''_lib_version'',6X,A)') LB_VERS(1:16)
          CALL WRTSTR(IUN,MDOC,LINE,IERR)
          WRITE(LINE,'(''_lib_update '',6X,A)') LB_DATE(1:16)
          CALL WRTSTR(IUN,MDOC,LINE,IERR)

          TITLE_M = '# ---   LIST OF MONOMERS ---'

        ELSE 
          IF(ICRD.LE.0) THEN
            CALL MSGERR(MDOC,' ERR: output_CIFile isn''t open.')
            IERR=1
            RETURN
          ENDIF
          IUN = ICRD 

          TITLE_M = '# ---   LIST OF NEW MONOMERS ---'

        ENDIF

        IF(LML_NMON.GT.0) THEN
          IFIRST_M = 0
          DO L=1,LML_NMON

            IF((LML_FUSE(L).EQ.'C'.AND.MODE.EQ.'TITC').OR. 
     *         (MODE.EQ.'TITA')                       .OR. 
     *         (LML_FUSE(L).NE.'N'.AND.LML_FUSE(L).NE.'?'.AND.
     *                                          MODE.EQ.'TITL')) THEN
              IF(IFIRST_M.EQ.0) THEN
                WRITE(LINE,'(A)')
     *  '# ------------------------------------------------'
                CALL WRTSTR(IUN,MDOC,LINE,IERR)
                WRITE(LINE,'(''#'')')
                CALL WRTSTR(IUN,MDOC,LINE,IERR)
                LINE = TITLE_M
                CALL WRTSTR(IUN,MDOC,LINE,IERR)
              ENDIF

              CALL WRT_TITLE_MONOMER(MDOC,IUN,L,IFIRST_M,IERR)

            ENDIF
          ENDDO
        ELSE
          IF(MODE.NE.'TITC') THEN
            WRITE(LINE,'('' Number of monomers = 0'')')
            CALL MSGDOC(MDOC,LINE)
            LMO_IUN = 0
            RETURN
          ENDIF
        ENDIF

        IF(LMS_NEW.GT.0.OR.MODE.NE.'TITC') THEN
        IF(LMS_NSYN.GT.0) THEN
          IFIRST_M = 0

          DO L=1,LMS_NSYN
            IF((LMS_FLAG(L).EQ.'N'.OR.MODE.NE.'TITC').AND.
     *          LMS_ATOM(L).EQ.'.') THEN

              IF(IFIRST_M.EQ.0) THEN

                WRITE(LINE,'(''#'')')
                CALL WRTSTR(IUN,MDOC,LINE,IERR)
                WRITE(LINE,'(''# ---   LIST OF SYNONYMS ---'')')
                CALL WRTSTR(IUN,MDOC,LINE,IERR)

                WRITE(LINE,'(''#'')')
                CALL WRTSTR(IUN,MDOC,LINE,IERR)
                WRITE(LINE,'(''data_comp_synonym_list'')')
                CALL WRTSTR(IUN,MDOC,LINE,IERR)
                WRITE(LINE,'(''loop_'')')
                CALL WRTSTR(IUN,MDOC,LINE,IERR)
                WRITE(LINE,'(''_chem_comp_synonym.comp_id'')')
                CALL WRTSTR(IUN,MDOC,LINE,IERR)
          WRITE(LINE,'(''_chem_comp_synonym.comp_alternative_id'')')
                CALL WRTSTR(IUN,MDOC,LINE,IERR)
                WRITE(LINE,'(''_chem_comp_synonym.mod_id'')')
                CALL WRTSTR(IUN,MDOC,LINE,IERR)
                IFIRST_M = 1
              ENDIF
              WRITE(LINE,200) 
     *        LMS_MNAME(L)
     *        ,LMS_AMNAME(L),LMS_MOD(L)
              CALL WRTSTR(IUN,MDOC,LINE,IERR)
  200         FORMAT(A8,4X,A8,1X,A8)
            ENDIF
          ENDDO

          IFIRST_MM = 0

          DO L=1,LMS_NSYN
            IF((LMS_FLAG(L).EQ.'N'.OR.MODE.NE.'TITC').AND.
     *          LMS_ATOM(L).NE.'.') THEN
              IF(IFIRST_MM.EQ.0) THEN

                IF(IFIRST_M.EQ.0) THEN
                  WRITE(LINE,'(''#'')')
                  CALL WRTSTR(IUN,MDOC,LINE,IERR)
                  WRITE(LINE,'(''# ---   LIST OF SYNONYMS ---'')')
                  CALL WRTSTR(IUN,MDOC,LINE,IERR)
                ENDIF

                WRITE(LINE,'(''#'')')
                CALL WRTSTR(IUN,MDOC,LINE,IERR)
                WRITE(LINE,'(''data_comp_synonym_atom_list'')')
                CALL WRTSTR(IUN,MDOC,LINE,IERR)
                WRITE(LINE,'(''loop_'')')
                CALL WRTSTR(IUN,MDOC,LINE,IERR)
                WRITE(LINE,'(''_chem_comp_synonym_atom.comp_id'')')
                CALL WRTSTR(IUN,MDOC,LINE,IERR)
        WRITE(LINE,'(''_chem_comp_synonym_atom.comp_alternative_id'')')
                CALL WRTSTR(IUN,MDOC,LINE,IERR)
                WRITE(LINE,'(''_chem_comp_synonym_atom.atom_id'')')
                CALL WRTSTR(IUN,MDOC,LINE,IERR)
        WRITE(LINE,'(''_chem_comp_synonym_atom.atom_alternative_id'')')
                CALL WRTSTR(IUN,MDOC,LINE,IERR)

                IFIRST_MM = 1
              ENDIF
              WATOM1 = LMS_ATOM(L)
              WATOM2 = LMS_AATOM(L)
              CALL CORR_NAME_CIF_OUT(WATOM1)
              CALL CORR_NAME_CIF_OUT(WATOM2)
              WRITE(LINE,201) 
     *        LMS_MNAME(L)
     *        ,LMS_AMNAME(L),WATOM1,WATOM2
              CALL WRTSTR(IUN,MDOC,LINE,IERR)
 201          FORMAT(A8,4X,A8,1X,A6,1X,A6)
            ENDIF
          ENDDO


        ENDIF
        ENDIF

        IF(LLL_NLINK.GT.0) THEN
          IFIRST=0
          DO L=1,LLL_NLINK
            IF((LLL_FUSE(L).EQ.'C'.AND.MODE.EQ.'TITC').OR. 
     *         (MODE.EQ.'TITA')                       .OR. 
     *         (LLL_FUSE(L).NE.'N'.AND.LLL_FUSE(L).NE.'?'.AND.
     *                                 MODE.EQ.'TITL')) THEN


              IF(IFIRST.EQ.0) THEN 
                WRITE(LINE,'(''#'')')
                CALL WRTSTR(IUN,MDOC,LINE,IERR)
                WRITE(LINE,'(''# ---   LIST OF LINKS ---'')')
                CALL WRTSTR(IUN,MDOC,LINE,IERR)
              ENDIF

              CALL WRT_TITLE_LINK(MDOC,IUN,L,IFIRST,IERR)

            ENDIF
          ENDDO
        ENDIF

        IF(LDL_NMOD.GT.0) THEN
          IFIRST=0
          DO L=1,LDL_NMOD
            IF((LDL_FUSE(L).EQ.'C'.AND.MODE.EQ.'TITC').OR. 
     *         (MODE.EQ.'TITA')                       .OR. 
     *         (LDL_FUSE(L).NE.'N'.AND.LDL_FUSE(L).NE.'?'.AND.
     *                                 MODE.EQ.'TITL')) THEN
              IF(IFIRST.EQ.0) THEN 
                WRITE(LINE,'(''#'')')
                CALL WRTSTR(IUN,MDOC,LINE,IERR)
                WRITE(LINE,'(''# ---   LIST OF MODIFICATIONS ---'')')
                CALL WRTSTR(IUN,MDOC,LINE,IERR)
              ENDIF

              CALL WRT_TITLE_MODIFICATION(MDOC,IUN,L,IFIRST,IERR)

            ENDIF
          ENDDO
        ENDIF

      ELSE IF(MODE(1:3).EQ.'MON'.OR.MODE(1:3).EQ.'LIN'.OR.
     *        MODE(1:3).EQ.'MOD') THEN

        IF(ICRD.GT.0) THEN
          IF(ICRD.LE.0) THEN
            CALL MSGERR(MDOC,' ERROR: output_CIFile isn''t open')
            IERR=1
            RETURN
          ENDIF
          IUN=ICRD 
        ELSE
          IF(LMO_IUN.EQ.0) THEN
            CALL MSGERR(MDOC,' ERR: output_lib_file isn''t open..')
            IERR=1
            RETURN
          ENDIF
          IUN=LMO_IUN 
        ENDIF

        IF(MODE(1:3).EQ.'LIN'.OR.MODE(1:3).EQ.'MOD') GO TO 6000


        IF(LML_NMON.GT.0) THEN
          WRITE(LINE,'(''#'')')
          CALL WRTSTR(IUN,MDOC,LINE,IERR)
          WRITE(LINE,'(''# --- DESCRIPTION OF MONOMERS ---'')')
          CALL WRTSTR(IUN,MDOC,LINE,IERR)
          WRITE(LINE,'(''#'')')
          DO I=1,LML_NMON

            IF((LML_FUSE(I).EQ.'C'.AND.MODE.EQ.'MONC').OR.
     *         (MODE.EQ.'MONA')                       .OR.
     *         (LML_FUSE(I).NE.'N'.AND.LML_FUSE(I).NE.'?'.AND.
     *                                 MODE.EQ.'MONL')) THEN          
              CALL WRT_DESRC_ONE_MONOMER(MDOC,IUN,I,IERR)

            ENDIF
          ENDDO
        ENDIF

        IF(MODE(1:3).EQ.'MON') GO TO 6200

 6000   CONTINUE
        IF(MODE(1:3).EQ.'MOD') GO TO 6100


        IF(LLL_NLINK.GT.0) THEN
        IFIRST=0
        DO I=1,LLL_NLINK
          IF((LLL_FUSE(I).EQ.'C'.AND.MODE.EQ.'LINC').OR.
     *       (MODE.EQ.'LINA')                       .OR.
     *       (LLL_FUSE(I).NE.'N'.AND.LLL_FUSE(I).NE.'?'.AND.
     *                               MODE.EQ.'LINL')) THEN
            IF(IFIRST.EQ.0) THEN
              WRITE(LINE,'(''#'')')
              CALL WRTSTR(IUN,MDOC,LINE,IERR)
              WRITE(LINE,'(''# --- DESCRIPTION OF LINKS ---'')')
              CALL WRTSTR(IUN,MDOC,LINE,IERR)
              WRITE(LINE,'(''#'')')
              IFIRST=1
            ENDIF


            CALL WRT_DESRC_ONE_LINK(MDOC,IUN,I,IERR)
           
          ENDIF

        ENDDO
        ENDIF

 6100   CONTINUE
        IF(MODE(1:3).EQ.'LIN') GO TO 6200

        IF(LDL_NMOD.GT.0) THEN
        IFIRST=0
        DO I=1,LDL_NMOD
          IF((LDL_FUSE(I).EQ.'C'.AND.MODE.EQ.'MODC').OR.
     *       (MODE.EQ.'MODA')                       .OR.
     *       (LDL_FUSE(I).NE.'N'.AND.LDL_FUSE(I).NE.'?'.AND.
     *                               MODE.EQ.'MODL')) THEN
            IF(IFIRST.EQ.0) THEN
              WRITE(LINE,'(''#'')')
              CALL WRTSTR(IUN,MDOC,LINE,IERR)
              WRITE(LINE,'(''# --- DESCRIPTION OF MODIFICATIONS ---'')')
              CALL WRTSTR(IUN,MDOC,LINE,IERR)
              WRITE(LINE,'(''#'')')
              IFIRST=1
            ENDIF
C            IF(LDL_SUB_MOD(I)(1:1).EQ.'.') THEN

            CALL WRT_DESRC_ONE_MODIFICATION(MDOC,IUN,I,IERR)

C            ENDIF
          ENDIF
        ENDDO
        ENDIF

 6200   CONTINUE

        WRITE(LINE,'(A)')
     *  '# ------------------------------------------------------'
        CALL WRTSTR(IUN,MDOC,LINE,IERR)

      ELSE IF(MODE.EQ.'STOP') THEN
        IF(LMO_IUN.EQ.0) THEN
          CALL MSGERR(MDOC,' ERR: output_lib_file can''t be close')
          IERR=1
          RETURN
        ENDIF
        END FILE LMO_IUN
        LMO_IUN = 0
      ENDIF
C -----------------------------------
      RETURN
      END     

      SUBROUTINE WRT_TITLE_MONOMER(MDOC,IUN,L,IFIRST_M,IERR)
C ------------------------------------------------------------
      INTEGER   MDOC,IUN,L,IFIRST_M,IERR
C ----
      CHARACTER LINE*256,STR*256,CH1_1*1,CH1_2*1,CH3*3
C -----------------------------------------------
      INCLUDE 'lib_com.fh'
C ------------------------------------------------------------      
              IF(IFIRST_M.EQ.0) THEN
                WRITE(LINE,'(''#'')')
                CALL WRTSTR(IUN,MDOC,LINE,IERR)
                WRITE(LINE,'(''data_comp_list'')')
                CALL WRTSTR(IUN,MDOC,LINE,IERR)
                WRITE(LINE,'(''loop_'')')
                CALL WRTSTR(IUN,MDOC,LINE,IERR)
                WRITE(LINE,'(''_chem_comp.id'')')
                CALL WRTSTR(IUN,MDOC,LINE,IERR)
                WRITE(LINE,'(''_chem_comp.three_letter_code'')')
                CALL WRTSTR(IUN,MDOC,LINE,IERR)
                WRITE(LINE,'(''_chem_comp.name'')')
                CALL WRTSTR(IUN,MDOC,LINE,IERR)
                WRITE(LINE,'(''_chem_comp.group'')')
                CALL WRTSTR(IUN,MDOC,LINE,IERR)
                WRITE(LINE,'(''_chem_comp.number_atoms_all'')')
                CALL WRTSTR(IUN,MDOC,LINE,IERR)
                WRITE(LINE,'(''_chem_comp.number_atoms_nh'')')
                CALL WRTSTR(IUN,MDOC,LINE,IERR)
                WRITE(LINE,'(''_chem_comp.desc_level'')')
                CALL WRTSTR(IUN,MDOC,LINE,IERR)
                IFIRST_M = 1
              ENDIF
              CH3 = LML_MNAME2(L)(1:3)
              J   = LML_IATOM(L)
              NA  = 0
              NHA = 0                  
              IF(J.GT.0) THEN
                IF(LMA_NATOM.GT.0) THEN
                  DO IA=J,LMA_NATOM
                    IF(LMA_MNAME(IA).EQ.LML_MNAME(L)) THEN
                      NA = NA+1
                      IF(LMA_SYMB(IA).NE.'H   '.AND.
     *                   LMA_SYMB(IA).NE.'D   ') THEN
                        NHA=NHA+1
                      ENDIF
                    ENDIF           
                  ENDDO
                ENDIF
              ENDIF

              CH1_2 = ''''
              CH1_1 = LML_PRSNT(L)
              IF(CH1_1.EQ.' ') CH1_1 = '.'
CZEB     aaa '4-HYDROXY-3,4-DIHYDRO-ZEBULARINEMIDI ' non-polymer        31  17 M
c2345678112311123456789 123456789 123456789 123456711123456789 123456112341234
c         123456789 123456789 123456789 12345611     123456789 123456112341234
              STR = LML_NAME(L)
              CALL LENSTR_BL(STR,LEN)
              IF(LEN.GT.36) LEN = 36
              IF(LEN.LT.36) THEN
                DO II=LEN+1,36
                  STR(II:II) = ' '
                ENDDO
              ENDIF
              IF(LML_MNAME(L)(1:1).NE.'?') THEN
                WRITE(LINE,100)
     *          LML_MNAME(L),CH3,CH1_2,STR(1:36),CH1_2
     *         ,LML_TYPE(L),NA,NHA,CH1_1
C     *        ,LML_NATM(L),LML_NHATM(L)
                CALL WRTSTR(IUN,MDOC,LINE,IERR)
  100           FORMAT(A8,1X,A3,1X,A1,A36,A1,1X,A16,1X,I4,I4,1X,A1)
              ENDIF
C ------------------------
      RETURN
      END

      SUBROUTINE WRT_DESRC_ONE_MONOMER(MDOC,IUN,I,IERR)
C -----------------------------------------------
      INCLUDE 'lib_com.fh'
C -----------------------------------
      INTEGER*4 MDOC,IUN,I,IERR
      CHARACTER LINE*256
      CHARACTER CH2*2,POINT*4,TYPE*8,CH8*8,CH4*4,CHAR8*8
      CHARACTER WATOM1*6,WATOM2*6,WATOM3*6,WATOM4*6
      CHARACTER WATOM5*6,WATOM6*6,WATOM7*6,WATOM8*6,WATOM9*6
C ----------
      INTEGER*4 IATOM
      CHARACTER ATOM*4
      EQUIVALENCE (IATOM,ATOM)
C ----------
      DATA POINT/'.   '/,TYPE/'.       '/
C -----------------------------------------------
              CH8 = LML_MNAME(I)
              IF(CH8(1:1).NE.'?') THEN
                WRITE(LINE,'(''#'')')
                CALL WRTSTR(IUN,MDOC,LINE,IERR)
                WRITE(LINE,'(''data_comp_'',A8)') CH8
                CALL WRTSTR(IUN,MDOC,LINE,IERR)
                WRITE(LINE,'(''#'')')
                CALL WRTSTR(IUN,MDOC,LINE,IERR)
              ENDIF
              J=LML_IATOM(I)
              IF(J.GT.0) THEN
                WRITE(LINE,'(''loop_'')')
                CALL WRTSTR(IUN,MDOC,LINE,IERR)
                WRITE(LINE,'(''_chem_comp_atom.comp_id'')')
                CALL WRTSTR(IUN,MDOC,LINE,IERR)
                WRITE(LINE,'(''_chem_comp_atom.atom_id'')')
                CALL WRTSTR(IUN,MDOC,LINE,IERR)
                WRITE(LINE,'(''_chem_comp_atom.type_symbol'')')
                CALL WRTSTR(IUN,MDOC,LINE,IERR)
                WRITE(LINE,'(''_chem_comp_atom.type_energy'')')
                CALL WRTSTR(IUN,MDOC,LINE,IERR)
c                IF(LML_PRSNT(I).NE.'M') THEN
                  WRITE(LINE,'(''_chem_comp_atom.partial_charge'')')
                  CALL WRTSTR(IUN,MDOC,LINE,IERR)
c                ENDIF
                IF(LMA_NATOM.GT.0) THEN
                  DO L=J,LMA_NATOM
                    IF(LMA_MNAME(L).NE.CH8) GO TO 510
                    WATOM1 = LMA_ANAME(L)
                    CALL CORR_NAME_CIF_OUT(WATOM1)
c                    IF(LML_PRSNT(I).NE.'M') THEN
                      WRITE(LINE,500) 
     *                LMA_MNAME(L),WATOM1
     *               ,LMA_SYMB(L),LMA_CHEM(L),LMA_CHARG(L)
                      CALL WRTSTR(IUN,MDOC,LINE,IERR)
  500                 FORMAT(1X,A8,6X,A6,1X,A4,1X,A4,3X,F8.3)
c                    ELSE
c                      WRITE(LINE,501) 
c     *                LMA_MNAME(L),WATOM1
c     *               ,LMA_SYMB(L),LMA_CHEM(L)
c                      CALL WRTSTR(IUN,MDOC,LINE,IERR)
c 501                  FORMAT(1X,A8,1X,A6,1X,A4,1X,A4)
c                    ENDIF
                  ENDDO
  510             CONTINUE
                ENDIF
              ENDIF
              J=LML_IATOM(I)
              K=LML_ICONN(I)
              IF(J.GT.0.AND.LML_PRSNT(I).NE.'M') THEN
                WRITE(LINE,'(''loop_'')')
                CALL WRTSTR(IUN,MDOC,LINE,IERR)
                WRITE(LINE,'(''_chem_comp_tree.comp_id'')')
                CALL WRTSTR(IUN,MDOC,LINE,IERR)
                WRITE(LINE,'(''_chem_comp_tree.atom_id'')')
                CALL WRTSTR(IUN,MDOC,LINE,IERR)
                WRITE(LINE,'(''_chem_comp_tree.atom_back'')')
                CALL WRTSTR(IUN,MDOC,LINE,IERR)
c                WRITE(LINE,'(''_chem_comp_tree.back_type'')')
c                CALL WRTSTR(IUN,MDOC,LINE,IERR)
                WRITE(LINE,'(''_chem_comp_tree.atom_forward'')')
                CALL WRTSTR(IUN,MDOC,LINE,IERR)

C               WRITE(LINE
C    *          ,'(''_chem_comp_tree.additional_connect_atom_id_1'')')
C               CALL WRTSTR(IUN,MDOC,LINE,IERR)
C               WRITE(LINE
C    *          ,'(''_chem_comp_tree.additional_connect_atom_id_2'')')
C               CALL WRTSTR(IUN,MDOC,LINE,IERR)
c               WRITE(LINE
c    *          ,'(''_chem_comp_tree.additional_connect_type'')')
c               CALL WRTSTR(IUN,MDOC,LINE,IERR)

                WRITE(LINE
     *          ,'(''_chem_comp_tree.connect_type'')')
                CALL WRTSTR(IUN,MDOC,LINE,IERR)

                IF(LMA_NATOM.GT.0) THEN
                  DO L=J,LMA_NATOM
                    IF(LMA_MNAME(L).NE.CH8) GO TO 610
C !!!
                    CHAR8=LMA_TYPE(L)
                    IF(CHAR8.EQ.' ') CHAR8 = '.'
                    IF(LMA_BACK(L)(1:1).EQ.'.') CHAR8='START' 
                    IF(LMA_FORW(L).EQ.'END ') THEN
                      CHAR8       = 'END' 
                      LMA_FORW(L) = '.'
                    ENDIF
C !!!
                    CH4 = LMA_BACK(L)
                    IF(CH4(1:1).EQ.'.') CH4 = 'n/a '

                    WATOM1 = LMA_ANAME(L)
                    WATOM2 = CH4
                    WATOM3 = LMA_FORW(L)
                    CALL CORR_NAME_CIF_OUT(WATOM1)
                    CALL CORR_NAME_CIF_OUT(WATOM2)
                    CALL CORR_NAME_CIF_OUT(WATOM3)

                    WRITE(LINE,600) 
     *              LMA_MNAME(L)
     *             ,WATOM1,WATOM2,WATOM3
     *             ,CHAR8

C    *             ,POINT,POINT,TYPE
                    CALL WRTSTR(IUN,MDOC,LINE,IERR)
  600        FORMAT(1X,A8,1X,A6,1X,A6,1X,A6,1X,A8)
C 600        FORMAT(1X,A8,6X,A4,1X,A4,1X,A8,1X,A4,1X,A4,1X,A4,1X,A8)
                  ENDDO
  610             CONTINUE
                ENDIF
                IF(LMN_NCONN.GT.0.AND.K.GT.0) THEN
                  DO L=K,LMN_NCONN
                    IF(LMN_MNAME(L).NE.CH8) GO TO 620
                    CHAR8 = 'ADD'
                    WATOM1 = LMN_1ATM(L)
                    WATOM2 = LMN_2ATM(L)
                    CALL CORR_NAME_CIF_OUT(WATOM1)
                    CALL CORR_NAME_CIF_OUT(WATOM2)
                    WRITE(LINE,630)
     *              LMN_MNAME(L),WATOM1
     *             ,WATOM2,POINT,CHAR8

  630               FORMAT(1X,A8,1X,A6,1X,A6,1X,A,1X,A)

C    *              LMN_MNAME(L),POINT,POINT,TYPE,POINT,LMN_1ATM(L)
C    *             ,LMN_2ATM(L),LMN_TYPE(L)

                    CALL WRTSTR(IUN,MDOC,LINE,IERR)
                  ENDDO
  620             CONTINUE
                ENDIF
              ENDIF
              J=LML_IBOND(I)
              IF(J.GT.0) THEN
                WRITE(LINE,'(''loop_'')')
                CALL WRTSTR(IUN,MDOC,LINE,IERR)
                WRITE(LINE,'(''_chem_comp_bond.comp_id'')')
                CALL WRTSTR(IUN,MDOC,LINE,IERR)
                WRITE(LINE,'(''_chem_comp_bond.atom_id_1'')')
                CALL WRTSTR(IUN,MDOC,LINE,IERR)
                WRITE(LINE,'(''_chem_comp_bond.atom_id_2'')')
                CALL WRTSTR(IUN,MDOC,LINE,IERR)
                WRITE(LINE,'(''_chem_comp_bond.type'')')
                CALL WRTSTR(IUN,MDOC,LINE,IERR)
                IF(LML_PRSNT(I).NE.'M') THEN
                  WRITE(LINE,'(''_chem_comp_bond.value_dist'')')
                  CALL WRTSTR(IUN,MDOC,LINE,IERR)
                  WRITE(LINE,'(''_chem_comp_bond.value_dist_esd'')')
                  CALL WRTSTR(IUN,MDOC,LINE,IERR)
                ENDIF
                IF(LMB_NBOND.GT.0) THEN
                  DO L=J,LMB_NBOND
                    IF(LMB_MNAME(L).NE.CH8) GO TO 710
                    ESD=LMB_DEV(L)
                    IF(ESD.LE.0.0) ESD=0.02
                    WATOM1 = LMB_1ATM(L)
                    WATOM2 = LMB_2ATM(L)
                    CALL CORR_NAME_CIF_OUT(WATOM1)
                    CALL CORR_NAME_CIF_OUT(WATOM2)
                    IF(LML_PRSNT(I).NE.'M') THEN
                      WRITE(LINE,700) 
     *                LMB_MNAME(L)
     *               ,WATOM1,WATOM2,LMB_TYPE(L),LMB_VAL(L)
     *               ,ESD
                      CALL WRTSTR(IUN,MDOC,LINE,IERR)
  700                 FORMAT(1X,A8,1X,A6,1X,A6,4X,A8,1X,F8.3,1X,F8.3)
                    ELSE
                      WRITE(LINE,701) 
     *                LMB_MNAME(L)
     *               ,WATOM1,WATOM2,LMB_TYPE(L)
                      CALL WRTSTR(IUN,MDOC,LINE,IERR)
 701                  FORMAT(1X,A3,8X,A6,1X,A6,4X,A8)
                    ENDIF
                  ENDDO
  710             CONTINUE
                ENDIF
              ENDIF
              J=LML_ITHET(I)
              IF(J.GT.0) THEN
                WRITE(LINE,'(''loop_'')')
                CALL WRTSTR(IUN,MDOC,LINE,IERR)
                WRITE(LINE,'(''_chem_comp_angle.comp_id'')')
                CALL WRTSTR(IUN,MDOC,LINE,IERR)
                WRITE(LINE,'(''_chem_comp_angle.atom_id_1'')')
                CALL WRTSTR(IUN,MDOC,LINE,IERR)
                WRITE(LINE,'(''_chem_comp_angle.atom_id_2'')')
                CALL WRTSTR(IUN,MDOC,LINE,IERR)
                WRITE(LINE,'(''_chem_comp_angle.atom_id_3'')')
                CALL WRTSTR(IUN,MDOC,LINE,IERR)
                WRITE(LINE,'(''_chem_comp_angle.value_angle'')')
                CALL WRTSTR(IUN,MDOC,LINE,IERR)
                WRITE(LINE,'(''_chem_comp_angle.value_angle_esd'')')
                CALL WRTSTR(IUN,MDOC,LINE,IERR)
                IF(LMG_NANGL.GT.0) THEN
                  DO L=J,LMG_NANGL
                    IF(LMG_MNAME(L).NE.CH8) GO TO 810
                    ESD=LMG_DEV(L)
                    IF(ESD.LE.0.0) ESD=3.0
                    WATOM1 = LMG_1ATM(L)
                    WATOM2 = LMG_2ATM(L)
                    WATOM3 = LMG_3ATM(L)
                    CALL CORR_NAME_CIF_OUT(WATOM1)
                    CALL CORR_NAME_CIF_OUT(WATOM2)
                    CALL CORR_NAME_CIF_OUT(WATOM3)

                    WRITE(LINE,800) 
     *              LMG_MNAME(L)
     *             ,WATOM1,WATOM2,WATOM3,LMG_VAL(L)
     *             ,ESD
                    CALL WRTSTR(IUN,MDOC,LINE,IERR)
  800               FORMAT(1X,A8,1X,A6,1X,A6,1X,A6,1X,F8.3,1X,F8.3)
                  ENDDO
  810             CONTINUE
                ENDIF
              ENDIF
              J=LML_ITORS(I)
              IF(J.GT.0) THEN
                WRITE(LINE,'(''loop_'')')
                CALL WRTSTR(IUN,MDOC,LINE,IERR)
                WRITE(LINE,'(''_chem_comp_tor.comp_id'')')
                CALL WRTSTR(IUN,MDOC,LINE,IERR)
                WRITE(LINE,'(''_chem_comp_tor.id'')')
                CALL WRTSTR(IUN,MDOC,LINE,IERR)
                WRITE(LINE,'(''_chem_comp_tor.atom_id_1'')')
                CALL WRTSTR(IUN,MDOC,LINE,IERR)
                WRITE(LINE,'(''_chem_comp_tor.atom_id_2'')')
                CALL WRTSTR(IUN,MDOC,LINE,IERR)
                WRITE(LINE,'(''_chem_comp_tor.atom_id_3'')')
                CALL WRTSTR(IUN,MDOC,LINE,IERR)
                WRITE(LINE,'(''_chem_comp_tor.atom_id_4'')')
                CALL WRTSTR(IUN,MDOC,LINE,IERR)
                WRITE(LINE,'(''_chem_comp_tor.value_angle'')')
                CALL WRTSTR(IUN,MDOC,LINE,IERR)
                WRITE(LINE,'(''_chem_comp_tor.value_angle_esd'')')
                CALL WRTSTR(IUN,MDOC,LINE,IERR)
                WRITE(LINE,'(''_chem_comp_tor.period'')')
                CALL WRTSTR(IUN,MDOC,LINE,IERR)
                IF(LMT_NTORS.GT.0) THEN
                  IC=0
                  DO L=J,LMT_NTORS
                    IF(LMT_MNAME(L).NE.CH8) GO TO 910
                    ANGL=LMT_VAL(L)
                    IF(ANGL.GT. 180.0) ANGL=ANGL-360.0
                    IF(ANGL.LE.-180.0) ANGL=ANGL+360.0
                    IPRD=LMT_PRD(L)
                    ESD=LMT_DEV(L)
                    IF(ESD.LE.0.0) ESD = 20.0
                    CHAR8 =LMT_LABEL(L)
                    IF(IPRD.EQ.0) ESD=0.0
C !!!!
c                    IF(IPRD.EQ.0) IPRD=1
c                    IF(CHAR8(1:5).EQ.'CONST') THEN
c                      IPRD=0
c                      IC=IC+1
c                      IF(IC.GT.99) IC=99
c                      WRITE(CH2,'(I2)') IC
c                      IF(CH2(1:1).EQ.' ') CH2(1:1)='0'
c                      CHAR8='CONST_'//CH2
c  
c                      IF(IPRD.EQ.0) ESD=0.0
c
c                    ENDIF
C !!!
                    WATOM1 = LMT_1ATM(L) 
                    WATOM2 = LMT_2ATM(L) 
                    WATOM3 = LMT_3ATM(L)
                    WATOM4 = LMT_4ATM(L)
                    CALL CORR_NAME_CIF_OUT(WATOM1)
                    CALL CORR_NAME_CIF_OUT(WATOM2)
                    CALL CORR_NAME_CIF_OUT(WATOM3)
                    CALL CORR_NAME_CIF_OUT(WATOM4)

                    WRITE(LINE,900) 
     *              LMT_MNAME(L),CHAR8
     *             ,WATOM1,WATOM2,WATOM3,WATOM4
     *             ,ANGL,ESD,IPRD
                    CALL WRTSTR(IUN,MDOC,LINE,IERR)
  900               FORMAT(1X,A8,1X,A8,1X,A6,1X,A6,1X,A6,1X,A6,2X
     *              ,F8.3,1X,F8.3,1X,I3)
                  ENDDO

  910             CONTINUE
                ENDIF
              ENDIF
              J=LML_ICHIR(I)
              IF(J.GT.0) THEN
                IF(LMC_NCHIR.GT.0) THEN

                  IC     = 0
                  ICROSS = 0
                  DO L=J,LMC_NCHIR
                    IF(LMC_MNAME(L).NE.CH8) GO TO 1011
                    IF(LMC_SIGN(L)(1:6).EQ.'cross3'.OR.
     *                 LMC_SIGN(L)(1:6).EQ.'cross4'.OR.
     *                 LMC_SIGN(L)(1:6).EQ.'cross5'.OR.
     *                 LMC_SIGN(L)(1:6).EQ.'cross6'.OR.
     *                 LMC_SIGN(L)(1:5).EQ.'star5'.OR.
     *                 LMC_SIGN(L)(1:5).EQ.'star6'    ) ICROSS = 1
                  ENDDO
 1011             CONTINUE

                  WRITE(LINE,'(''loop_'')')
                  CALL WRTSTR(IUN,MDOC,LINE,IERR)
                  WRITE(LINE,'(''_chem_comp_chir.comp_id'')')
                  CALL WRTSTR(IUN,MDOC,LINE,IERR)
                  WRITE(LINE,'(''_chem_comp_chir.id'')')
                  CALL WRTSTR(IUN,MDOC,LINE,IERR)
                  WRITE(LINE,'(''_chem_comp_chir.atom_id_centre'')')
                  CALL WRTSTR(IUN,MDOC,LINE,IERR)
                  WRITE(LINE,'(''_chem_comp_chir.atom_id_1'')')
                  CALL WRTSTR(IUN,MDOC,LINE,IERR)
                  WRITE(LINE,'(''_chem_comp_chir.atom_id_2'')')
                  CALL WRTSTR(IUN,MDOC,LINE,IERR)
                  WRITE(LINE,'(''_chem_comp_chir.atom_id_3'')')
                  CALL WRTSTR(IUN,MDOC,LINE,IERR)
                  WRITE(LINE,'(''_chem_comp_chir.volume_sign'')')
                  CALL WRTSTR(IUN,MDOC,LINE,IERR)
                  IF(ICROSS.EQ.1) THEN
                    WRITE(LINE,'(''_chem_comp_chir.atom_id_4'')')
                    CALL WRTSTR(IUN,MDOC,LINE,IERR)
                    WRITE(LINE,'(''_chem_comp_chir.atom_id_5'')')
                    CALL WRTSTR(IUN,MDOC,LINE,IERR)
                    WRITE(LINE,'(''_chem_comp_chir.atom_id_6'')')
                    CALL WRTSTR(IUN,MDOC,LINE,IERR)
                    WRITE(LINE,'(''_chem_comp_chir.atom_id_7'')')
                    CALL WRTSTR(IUN,MDOC,LINE,IERR)
                    WRITE(LINE,'(''_chem_comp_chir.atom_id_8'')')
                    CALL WRTSTR(IUN,MDOC,LINE,IERR)
                  ENDIF

                  DO L=J,LMC_NCHIR
                    IF(LMC_MNAME(L).NE.CH8) GO TO 1010
C !!
                    IC=IC+1
                    IF(IC.GT.99) IC=99
                    WRITE(CH2,'(I2)') IC
                    IF(CH2(1:1).EQ.' ') CH2(1:1)='0'
                    CHAR8='chir_'//CH2  
C !!!
                    WATOM1 = LMC_1ATM(L) 
                    WATOM2 = LMC_2ATM(L) 
                    WATOM3 = LMC_3ATM(L)
                    WATOM4 = LMC_4ATM(L)
                    CALL CORR_NAME_CIF_OUT(WATOM1)
                    CALL CORR_NAME_CIF_OUT(WATOM2)
                    CALL CORR_NAME_CIF_OUT(WATOM3)
                    CALL CORR_NAME_CIF_OUT(WATOM4)
                    WRITE(LINE,1000) 
     *              LMC_MNAME(L),CHAR8
     *             ,WATOM1,WATOM2,WATOM3,WATOM4
     *             ,LMC_SIGN(L)
                    CALL WRTSTR(IUN,MDOC,LINE,IERR)
 1000               FORMAT(1X,A8,1X,A8,1X,A6,1X,A6,1X,A6,1X,A6,4X,A8)
                    IF(ICROSS.EQ.1) THEN
                      WATOM5 = LMC_5ATM(L) 
                      WATOM6 = LMC_6ATM(L) 
                      WATOM7 = LMC_7ATM(L)
                      WATOM8 = LMC_8ATM(L)
                      WATOM9 = LMC_9ATM(L)
                      CALL CORR_NAME_CIF_OUT(WATOM5)
                      CALL CORR_NAME_CIF_OUT(WATOM6)
                      CALL CORR_NAME_CIF_OUT(WATOM7)
                      CALL CORR_NAME_CIF_OUT(WATOM8)
                      CALL CORR_NAME_CIF_OUT(WATOM9)
                      WRITE(LINE,1001) 
     *                WATOM5,WATOM6,WATOM7,WATOM8,WATOM9
                      CALL WRTSTR(IUN,MDOC,LINE,IERR)
 1001                 FORMAT(19X,A6,1X,A6,1X,A6,1X,A6,1X,A6)
                    ENDIF
                  ENDDO
 1010             CONTINUE
                ENDIF
              ENDIF

              J=LML_IPLAN(I)
              IF(J.GT.0) THEN
                WRITE(LINE,'(''loop_'')')
                CALL WRTSTR(IUN,MDOC,LINE,IERR)
                WRITE(LINE,'(''_chem_comp_plane_atom.comp_id'')')
                CALL WRTSTR(IUN,MDOC,LINE,IERR)
                WRITE(LINE,'(''_chem_comp_plane_atom.plane_id'')')
                CALL WRTSTR(IUN,MDOC,LINE,IERR)
                WRITE(LINE,'(''_chem_comp_plane_atom.atom_id'')')
                CALL WRTSTR(IUN,MDOC,LINE,IERR)
                WRITE(LINE,'(''_chem_comp_plane_atom.dist_esd'')')
                CALL WRTSTR(IUN,MDOC,LINE,IERR)
                IF(LMP_NPLAN.GT.0) THEN
                  DO L=J,LMP_NPLAN
                    IF(LMP_MNAME(L).NE.CH8) GO TO 1110
                    DO K=1,LMP_NATOM(L)
                      IATOM  = LMP_ATOM(K,L)
                      WATOM1 = ATOM
                      CALL CORR_NAME_CIF_OUT(WATOM1)
                      WRITE(LINE,1100) 
     *                LMP_MNAME(L)
     *               ,LMP_LABEL(L),WATOM1,LMP_DEV(K,L)
                      CALL WRTSTR(IUN,MDOC,LINE,IERR)
 1100                 FORMAT(1X,A8,1X,A8,2X,A6,1X,F8.3)
                    ENDDO
                  ENDDO
 1110             CONTINUE
                ENDIF
              ENDIF
C ---------------------------------
      RETURN
      END

      SUBROUTINE WRT_TITLE_LINK(MDOC,IUN,L,IFIRST,IERR)
C -----------------------------------------------------
      INTEGER*4 MDOC,IERR,IUN,L,IFIRST
      CHARACTER LINE*256
C ******
C -----------------------------------
      INCLUDE 'lib_com.fh'
C -----------------------------------------------------

              IF(IFIRST.EQ.0) THEN 
                WRITE(LINE,'(''#'')')
                CALL WRTSTR(IUN,MDOC,LINE,IERR)
                WRITE(LINE,'(''data_link_list'')')
                CALL WRTSTR(IUN,MDOC,LINE,IERR)
                WRITE(LINE,'(''loop_'')')
                CALL WRTSTR(IUN,MDOC,LINE,IERR)
                WRITE(LINE,'(''_chem_link.id'')')
                CALL WRTSTR(IUN,MDOC,LINE,IERR)
C                WRITE(LINE,'(''_chem_link.one_letter_code'')')
C                CALL WRTSTR(IUN,MDOC,LINE,IERR)
C                WRITE(LINE,'(''_chem_link.name'')')
C                CALL WRTSTR(IUN,MDOC,LINE,IERR)
                WRITE(LINE,'(''_chem_link.comp_id_1'')')
                CALL WRTSTR(IUN,MDOC,LINE,IERR)
                WRITE(LINE,'(''_chem_link.mod_id_1'')')
                CALL WRTSTR(IUN,MDOC,LINE,IERR)
                WRITE(LINE,'(''_chem_link.group_comp_1'')')
                CALL WRTSTR(IUN,MDOC,LINE,IERR)
                WRITE(LINE,'(''_chem_link.comp_id_2'')')
                CALL WRTSTR(IUN,MDOC,LINE,IERR)
                WRITE(LINE,'(''_chem_link.mod_id_2'')')
                CALL WRTSTR(IUN,MDOC,LINE,IERR)
                WRITE(LINE,'(''_chem_link.group_comp_2'')')
                CALL WRTSTR(IUN,MDOC,LINE,IERR)
                WRITE(LINE,'(''_chem_link.name'')')
                CALL WRTSTR(IUN,MDOC,LINE,IERR)
                IFIRST=1
              ENDIF
              WRITE(LINE,300) 
     *        LLL_LNAME(L)
     *        ,LLL_MON1(L),LLL_MOD1(L),LLL_TYPE1(L)
     *        ,LLL_MON2(L),LLL_MOD2(L),LLL_TYPE2(L)
              CALL WRTSTR(IUN,MDOC,LINE,IERR)
  300         FORMAT(A8,1X,A8,1X,A8,1X,A8
     *                              ,1X,A8,1X,A8,1X,A8)
              WRITE(LINE,301) LLL_DETAIL(L)(1:24)
              CALL WRTSTR(IUN,MDOC,LINE,IERR)
 301          FORMAT(1X,A24)
C -------------------------
      RETURN
      END

C ******
      SUBROUTINE WRT_TITLE_MODIFICATION(MDOC,IUN,L,IFIRST,IERR)
C -----------------------------------------------------
      INTEGER*4 MDOC,IERR,IUN,L,IFIRST
      CHARACTER LINE*256
C ******
C -----------------------------------
      INCLUDE 'lib_com.fh'
C -----------------------------------------------------


              IF(IFIRST.EQ.0) THEN 
                WRITE(LINE,'(''#'')')
                CALL WRTSTR(IUN,MDOC,LINE,IERR)
                WRITE(LINE,'(''data_mod_list'')')
                CALL WRTSTR(IUN,MDOC,LINE,IERR)
                WRITE(LINE,'(''loop_'')')
                CALL WRTSTR(IUN,MDOC,LINE,IERR)
                WRITE(LINE,'(''_chem_mod.id'')')
                CALL WRTSTR(IUN,MDOC,LINE,IERR)
c                WRITE(LINE,'(''_chem_mod.one_letter_code'')')
c                CALL WRTSTR(IUN,MDOC,LINE,IERR)
                WRITE(LINE,'(''_chem_mod.name'')')
                CALL WRTSTR(IUN,MDOC,LINE,IERR)
                WRITE(LINE,'(''_chem_mod.comp_id'')')
                CALL WRTSTR(IUN,MDOC,LINE,IERR)
                WRITE(LINE,'(''_chem_mod.group_id'')')
                CALL WRTSTR(IUN,MDOC,LINE,IERR)
c                WRITE(LINE,'(''_chem_mod.sub_mod_id'')')
c                CALL WRTSTR(IUN,MDOC,LINE,IERR)
c                WRITE(LINE,'(''_chem_mod.sub_mod_order'')')
c                CALL WRTSTR(IUN,MDOC,LINE,IERR)
                IFIRST=1
              ENDIF

c              WRITE(CH2,'(I2)') LDL_ORDER(L)
c              IF(LDL_ORDER(L).EQ.0) CH2='. '

              WRITE(LINE,400) 
     *        LDL_MNAME(L),LDL_DETAIL(L),LDL_COMP(L),LDL_TYPE(L)
    
              CALL WRTSTR(IUN,MDOC,LINE,IERR)
  400         FORMAT(A8,1X,A48,1X,A8,1X,A8)
C -------------------------
      RETURN
      END

      SUBROUTINE WRT_DESRC_ONE_LINK(MDOC,IUN,I,IERR)
C -------------------------------------------------------
      INTEGER*4 MDOC,IUN,IERR,I
C -----------------------------------------------
      INCLUDE 'lib_com.fh'
C ----------------------------------
      CHARACTER LINE*256,CHAR8*8,CH8*8
      CHARACTER WATOM1*6,WATOM2*6,WATOM3*6,WATOM4*6
C ----
      INTEGER*4 IATOM
      CHARACTER ATOM*4
      EQUIVALENCE (IATOM,ATOM)
C -------------------------------------------------------
            CH8=LLL_LNAME(I)
            IF(LLL_NLINK.GT.1.AND.I.GT.1) THEN
              DO J=1,I-1
                IF(CH8.EQ.LLL_LNAME(J)) GO TO 6101
              ENDDO
            ENDIF

            WRITE(LINE,'(''#'')')
            CALL WRTSTR(IUN,MDOC,LINE,IERR)
            WRITE(LINE,'(''data_link_'',A8)') CH8
            CALL WRTSTR(IUN,MDOC,LINE,IERR)
            WRITE(LINE,'(''#'')')
            CALL WRTSTR(IUN,MDOC,LINE,IERR)

            J=LLL_IBOND(I)
            IF(J.GT.0) THEN
                WRITE(LINE,'(''loop_'')')
                CALL WRTSTR(IUN,MDOC,LINE,IERR)
                WRITE(LINE,'(''_chem_link_bond.link_id'')')
                CALL WRTSTR(IUN,MDOC,LINE,IERR)
                WRITE(LINE,'(''_chem_link_bond.atom_1_comp_id'')')
                CALL WRTSTR(IUN,MDOC,LINE,IERR)
                WRITE(LINE,'(''_chem_link_bond.atom_id_1'')')
                CALL WRTSTR(IUN,MDOC,LINE,IERR)
                WRITE(LINE,'(''_chem_link_bond.atom_2_comp_id'')')
                CALL WRTSTR(IUN,MDOC,LINE,IERR)
                WRITE(LINE,'(''_chem_link_bond.atom_id_2'')')
                CALL WRTSTR(IUN,MDOC,LINE,IERR)
                WRITE(LINE,'(''_chem_link_bond.type'')')
                CALL WRTSTR(IUN,MDOC,LINE,IERR)
                WRITE(LINE,'(''_chem_link_bond.value_dist'')')
                CALL WRTSTR(IUN,MDOC,LINE,IERR)
                WRITE(LINE,'(''_chem_link_bond.value_dist_esd'')')
                CALL WRTSTR(IUN,MDOC,LINE,IERR)
                IF(LLB_NBOND.GT.0) THEN
                  DO L=J,LLB_NBOND
                    IF(LLB_LNAME(L).NE.CH8) GO TO 2710
                    ESD=LLB_DEV(L)
                    IF(ESD.LE.0.0) ESD=0.02

                    WATOM1 = LLB_1ATM(L)
                    WATOM2 = LLB_2ATM(L)
                    CALL CORR_NAME_CIF_OUT(WATOM1)
                    CALL CORR_NAME_CIF_OUT(WATOM2)


                    WRITE(LINE,2700) 
     *              LLB_LNAME(L),LLB_F1ATM(L),WATOM1
     *             ,LLB_F2ATM(L),WATOM2,LLB_TYPE(L)
     *             ,LLB_VAL(L),ESD
                    CALL WRTSTR(IUN,MDOC,LINE,IERR)
 2700               FORMAT(1X,A8,1X,I1,1X,A6,2X,I1,1X,A6,4X,A8,1X
     *              ,F8.3,1X,F8.3)
                  ENDDO
 2710             CONTINUE
                ENDIF
            ENDIF
            J=LLL_ITHET(I)
            IF(J.GT.0) THEN
                WRITE(LINE,'(''loop_'')')
                CALL WRTSTR(IUN,MDOC,LINE,IERR)
                WRITE(LINE,'(''_chem_link_angle.link_id'')')
                CALL WRTSTR(IUN,MDOC,LINE,IERR)
                WRITE(LINE,'(''_chem_link_angle.atom_1_comp_id'')')
                CALL WRTSTR(IUN,MDOC,LINE,IERR)
                WRITE(LINE,'(''_chem_link_angle.atom_id_1'')')
                CALL WRTSTR(IUN,MDOC,LINE,IERR)
                WRITE(LINE,'(''_chem_link_angle.atom_2_comp_id'')')
                CALL WRTSTR(IUN,MDOC,LINE,IERR)
                WRITE(LINE,'(''_chem_link_angle.atom_id_2'')')
                CALL WRTSTR(IUN,MDOC,LINE,IERR)
                WRITE(LINE,'(''_chem_link_angle.atom_3_comp_id'')')
                CALL WRTSTR(IUN,MDOC,LINE,IERR)
                WRITE(LINE,'(''_chem_link_angle.atom_id_3'')')
                CALL WRTSTR(IUN,MDOC,LINE,IERR)
                WRITE(LINE,'(''_chem_link_angle.value_angle'')')
                CALL WRTSTR(IUN,MDOC,LINE,IERR)
                WRITE(LINE,'(''_chem_link_angle.value_angle_esd'')')
                CALL WRTSTR(IUN,MDOC,LINE,IERR)
                IF(LLG_NANGL.GT.0) THEN
                  DO L=J,LLG_NANGL
                    IF(LLG_LNAME(L).NE.CH8) GO TO 2810
                    ESD=LLG_DEV(L)
                    IF(ESD.LE.0.0) ESD=3.0

                    WATOM1 = LLG_1ATM(L)
                    WATOM2 = LLG_2ATM(L)
                    WATOM3 = LLG_3ATM(L)
                    CALL CORR_NAME_CIF_OUT(WATOM1)
                    CALL CORR_NAME_CIF_OUT(WATOM2)
                    CALL CORR_NAME_CIF_OUT(WATOM3)


                    WRITE(LINE,2800) 
     *              LLG_LNAME(L),LLG_F1ATM(L)
     *             ,WATOM1,LLG_F2ATM(L),WATOM2
     *             ,LLG_F3ATM(L),WATOM3
     *             ,LLG_VAL(L),ESD
                    CALL WRTSTR(IUN,MDOC,LINE,IERR)
 2800               FORMAT(1X,A8,1X,I1,1X,A6,2X,I1,1X,A6,2X,I1,1X,A6
     *              ,1X,F8.3,1X,F8.3)
                  ENDDO
 2810             CONTINUE
                ENDIF
            ENDIF
            J=LLL_ITORS(I)
            IF(J.GT.0) THEN
                WRITE(LINE,'(''loop_'')')
                CALL WRTSTR(IUN,MDOC,LINE,IERR)
                WRITE(LINE,'(''_chem_link_tor.link_id'')')
                CALL WRTSTR(IUN,MDOC,LINE,IERR)
                WRITE(LINE,'(''_chem_link_tor.id'')')
                CALL WRTSTR(IUN,MDOC,LINE,IERR)
                WRITE(LINE,'(''_chem_link_tor.atom_1_comp_id'')')
                CALL WRTSTR(IUN,MDOC,LINE,IERR)
                WRITE(LINE,'(''_chem_link_tor.atom_id_1'')')
                CALL WRTSTR(IUN,MDOC,LINE,IERR)
                WRITE(LINE,'(''_chem_link_tor.atom_2_comp_id'')')
                CALL WRTSTR(IUN,MDOC,LINE,IERR)
                WRITE(LINE,'(''_chem_link_tor.atom_id_2'')')
                CALL WRTSTR(IUN,MDOC,LINE,IERR)
                WRITE(LINE,'(''_chem_link_tor.atom_3_comp_id'')')
                CALL WRTSTR(IUN,MDOC,LINE,IERR)
                WRITE(LINE,'(''_chem_link_tor.atom_id_3'')')
                CALL WRTSTR(IUN,MDOC,LINE,IERR)
                WRITE(LINE,'(''_chem_link_tor.atom_4_comp_id'')')
                CALL WRTSTR(IUN,MDOC,LINE,IERR)
                WRITE(LINE,'(''_chem_link_tor.atom_id_4'')')
                CALL WRTSTR(IUN,MDOC,LINE,IERR)
                WRITE(LINE,'(''_chem_link_tor.value_angle'')')
                CALL WRTSTR(IUN,MDOC,LINE,IERR)
                WRITE(LINE,'(''_chem_link_tor.value_angle_esd'')')
                CALL WRTSTR(IUN,MDOC,LINE,IERR)
                WRITE(LINE,'(''_chem_link_tor.period'')')
                CALL WRTSTR(IUN,MDOC,LINE,IERR)
                IF(LLT_NTORS.GT.0) THEN
                  DO L=J,LLT_NTORS
                    IF(LLT_LNAME(L).NE.CH8) GO TO 2910
                    ESD=LLT_DEV(L)
                    IF(ESD.LE.0.0) ESD=20.0
                    WATOM1 = LLT_1ATM(L) 
                    WATOM2 = LLT_2ATM(L)
                    WATOM3 = LLT_3ATM(L)
                    WATOM4 = LLT_4ATM(L)
                    CALL CORR_NAME_CIF_OUT(WATOM1)
                    CALL CORR_NAME_CIF_OUT(WATOM2)
                    CALL CORR_NAME_CIF_OUT(WATOM3)
                    CALL CORR_NAME_CIF_OUT(WATOM4)
                    WRITE(LINE,2900) 
     *              LLT_LNAME(L),LLT_LABEL(L),LLT_F1ATM(L),WATOM1
     *             ,LLT_F2ATM(L),WATOM2      ,LLT_F3ATM(L),WATOM3
     *             ,LLT_F4ATM(L),WATOM4
     *             ,LLT_VAL(L),ESD,LLT_PRD(L)
                    CALL WRTSTR(IUN,MDOC,LINE,IERR)
 2900               FORMAT(1X,A8,1X,A8,1X,I1,1X,A6,1X,I1,1X,A6,1X,I1
     *              ,1X,A6,1X,I1,1X,A6,1X,F7.2,1X,F5.1,1X,I1)
                  ENDDO
 2910             CONTINUE
                ENDIF
            ENDIF
            J=LLL_ICHIR(I)
            IF(J.GT.0) THEN
                WRITE(LINE,'(''loop_'')')
                CALL WRTSTR(IUN,MDOC,LINE,IERR)
                WRITE(LINE,'(''_chem_link_chir.link_id'')')
                CALL WRTSTR(IUN,MDOC,LINE,IERR)

C                WRITE(LINE,'(''_chem_link_chir.id'')')
C                CALL WRTSTR(IUN,MDOC,LINE,IERR)

           WRITE(LINE,'(''_chem_link_chir.atom_centre_comp_id'')')
                CALL WRTSTR(IUN,MDOC,LINE,IERR)
                WRITE(LINE,'(''_chem_link_chir.atom_id_centre'')')
                CALL WRTSTR(IUN,MDOC,LINE,IERR)
                WRITE(LINE,'(''_chem_link_chir.atom_1_comp_id'')')
                CALL WRTSTR(IUN,MDOC,LINE,IERR)
                WRITE(LINE,'(''_chem_link_chir.atom_id_1'')')
                CALL WRTSTR(IUN,MDOC,LINE,IERR)
                WRITE(LINE,'(''_chem_link_chir.atom_2_comp_id'')')
                CALL WRTSTR(IUN,MDOC,LINE,IERR)
                WRITE(LINE,'(''_chem_link_chir.atom_id_2'')')
                CALL WRTSTR(IUN,MDOC,LINE,IERR)
                WRITE(LINE,'(''_chem_link_chir.atom_3_comp_id'')')
                CALL WRTSTR(IUN,MDOC,LINE,IERR)
                WRITE(LINE,'(''_chem_link_chir.atom_id_3'')')
                CALL WRTSTR(IUN,MDOC,LINE,IERR)
                WRITE(LINE,'(''_chem_link_chir.volume_sign'')')
                CALL WRTSTR(IUN,MDOC,LINE,IERR)
                IF(LLC_NCHIR.GT.0) THEN
                  DO L=J,LLC_NCHIR
                    IF(LLC_LNAME(L).NE.CH8) GO TO 3010
C !!!
                    CHAR8='.'
C !!!
                    WATOM1 = LLC_1ATM(L)
                    WATOM2 = LLC_2ATM(L)
                    WATOM3 = LLC_3ATM(L)
                    WATOM4 = LLC_4ATM(L)
                    CALL CORR_NAME_CIF_OUT(WATOM1)
                    CALL CORR_NAME_CIF_OUT(WATOM2)
                    CALL CORR_NAME_CIF_OUT(WATOM3)
                    CALL CORR_NAME_CIF_OUT(WATOM4)
                    WRITE(LINE,3000) 
     *              LLC_LNAME(L),LLC_F1ATM(L),WATOM1
     *             ,LLC_F2ATM(L),WATOM2,LLC_F3ATM(L),WATOM3
     *             ,LLC_F4ATM(L),WATOM4
     *             ,LLC_SIGN(L)
                    CALL WRTSTR(IUN,MDOC,LINE,IERR)
 3000               FORMAT(1X,A8,3X,I1,1X,A6,2X,I1
     *              ,1X,A6,2X,I1,1X,A6,2X,I1,1X,A6,2X,A8)
                  ENDDO
 3010             CONTINUE
                ENDIF
            ENDIF
            J=LLL_IPLAN(I)
            IF(J.GT.0) THEN
                WRITE(LINE,'(''loop_'')')
                CALL WRTSTR(IUN,MDOC,LINE,IERR)
                WRITE(LINE,'(''_chem_link_plane.link_id'')')
                CALL WRTSTR(IUN,MDOC,LINE,IERR)
                WRITE(LINE,'(''_chem_link_plane.plane_id'')')
                CALL WRTSTR(IUN,MDOC,LINE,IERR)
                WRITE(LINE,'(''_chem_link_plane.atom_comp_id'')')
                CALL WRTSTR(IUN,MDOC,LINE,IERR)
                WRITE(LINE,'(''_chem_link_plane.atom_id'')')
                CALL WRTSTR(IUN,MDOC,LINE,IERR)
                WRITE(LINE,'(''_chem_link_plane.dist_esd'')')
                CALL WRTSTR(IUN,MDOC,LINE,IERR)
                IF(LLP_NPLAN.GT.0) THEN
                  DO L=J,LLP_NPLAN
                    IF(LLP_LNAME(L).NE.CH8) GO TO 3110
                    DO K=1,LLP_NATOM(L)
                      IATOM = LLP_ATOM(K,L)
                      WATOM1 = ATOM
                      CALL CORR_NAME_CIF_OUT(WATOM1)
                      WRITE(LINE,3100) 
     *                LLP_LNAME(L),LLP_LABEL(L)
     *               ,LLP_FATOM(K,L),WATOM1,LLP_DEV(K,L)
                      CALL WRTSTR(IUN,MDOC,LINE,IERR)
 3100                 FORMAT(1X,A8,3X,A8,2X,I1,1X,A6,1X,F8.3)
                    ENDDO
                  ENDDO
 3110             CONTINUE
                ENDIF
            ENDIF

 6101     CONTINUE
C ----------------------------------
      RETURN
      END 

      SUBROUTINE WRT_DESRC_ONE_MODIFICATION(MDOC,IUN,I,IERR)
C -------------------------------------------------------
      INTEGER*4 MDOC,IUN,IERR,I
C -----------------------------------------------
      INCLUDE 'lib_com.fh'
C ----------------------------------
      CHARACTER LINE*256,CHAR8*8,CH8*8,CH4*4
      CHARACTER WATOM1*6,WATOM2*6,WATOM3*6,WATOM4*6
      CHARACTER WATOM5*6,WATOM6*6,WATOM7*6,WATOM8*6,WATOM9*6
C ----
      INTEGER*4 IATOM
      CHARACTER ATOM*4
      EQUIVALENCE (IATOM,ATOM)
C -------------------------------------------------------

              CH8=LDL_MNAME(I)
              WRITE(LINE,'(''#'')')
              CALL WRTSTR(IUN,MDOC,LINE,IERR)
              WRITE(LINE,'(''data_mod_'',A8)') CH8
              CALL WRTSTR(IUN,MDOC,LINE,IERR)
              WRITE(LINE,'(''#'')')
              CALL WRTSTR(IUN,MDOC,LINE,IERR)
              J=LDL_IATOM(I)
              IF(J.GT.0) THEN
                WRITE(LINE,'(''loop_'')')
                CALL WRTSTR(IUN,MDOC,LINE,IERR)
                WRITE(LINE,'(''_chem_mod_atom.mod_id'')')
                CALL WRTSTR(IUN,MDOC,LINE,IERR)
                WRITE(LINE,'(''_chem_mod_atom.function'')')
                CALL WRTSTR(IUN,MDOC,LINE,IERR)
                WRITE(LINE,'(''_chem_mod_atom.atom_id'')')
                CALL WRTSTR(IUN,MDOC,LINE,IERR)
                WRITE(LINE,'(''_chem_mod_atom.new_atom_id'')')
                CALL WRTSTR(IUN,MDOC,LINE,IERR)
                WRITE(LINE,'(''_chem_mod_atom.new_type_symbol'')')
                CALL WRTSTR(IUN,MDOC,LINE,IERR)
                WRITE(LINE,'(''_chem_mod_atom.new_type_energy'')')
                CALL WRTSTR(IUN,MDOC,LINE,IERR)
                WRITE(LINE,'(''_chem_mod_atom.new_partial_charge'')')
                CALL WRTSTR(IUN,MDOC,LINE,IERR)
                IF(LDA_NATOM.GT.0) THEN
                  DO L=J,LDA_NATOM
                    IF(LDA_MNAME(L).NE.CH8) GO TO 4510
                    WATOM1 = LDA_ANAME(L) 
                    WATOM2 = LDA_ANEW(L)
                    CALL CORR_NAME_CIF_OUT(WATOM1)
                    CALL CORR_NAME_CIF_OUT(WATOM2)
                    WRITE(LINE,4500) 
     *              LDA_MNAME(L),LDA_FUNCT(L)
     *              ,WATOM1,WATOM2,LDA_SYMB(L),LDA_CHEM(L)
     *              ,LDA_CHARG(L)
                    CALL WRTSTR(IUN,MDOC,LINE,IERR)
 4500               FORMAT(1X,A8,1X,A8,1X,A6,1X,A6,1X,A4,1X,A4,1X,F8.3)
                  ENDDO
 4510             CONTINUE
                ENDIF
              ENDIF
              J=LDL_IATOM(I)
              K=LDL_ICONN(I)
              IF(K.GT.0) THEN
                WRITE(LINE,'(''loop_'')')
                CALL WRTSTR(IUN,MDOC,LINE,IERR)
                WRITE(LINE,'(''_chem_mod_tree.mod_id'')')
                CALL WRTSTR(IUN,MDOC,LINE,IERR)
                WRITE(LINE,'(''_chem_mod_tree.function'')')
                CALL WRTSTR(IUN,MDOC,LINE,IERR)
                WRITE(LINE,'(''_chem_mod_tree.atom_id'')')
                CALL WRTSTR(IUN,MDOC,LINE,IERR)
                WRITE(LINE,'(''_chem_mod_tree.atom_back'')')
                CALL WRTSTR(IUN,MDOC,LINE,IERR)
                WRITE(LINE,'(''_chem_mod_tree.back_type'')')
                CALL WRTSTR(IUN,MDOC,LINE,IERR)
                WRITE(LINE,'(''_chem_mod_tree.atom_forward'')')
                CALL WRTSTR(IUN,MDOC,LINE,IERR)
                WRITE(LINE,'(''_chem_mod_tree.connect_type'')')
                CALL WRTSTR(IUN,MDOC,LINE,IERR)

                IF(LDN_NCONN.GT.0) THEN
                  DO L=K,LDN_NCONN
                    IF(LDN_MNAME(L).NE.CH8) GO TO 4610

C !!!!
C                    CHAR8='.'
C                    IF(LDN_BACK(L)(1:1).EQ.'.'.AND.
C     *                 LDN_FUNCT(L)(1:6).NE.'delete') THEN
C                      CHAR8='START' 
C                      LMA_BACK(L)='.'
C                    ENDIF
C                    IF(LDN_FORW(L)(1:3).EQ.'END') THEN 
C                      CHAR8='END' 
C                      LMA_FORW(L)='.'
C                    ENDIF
C                    LDN_TYPE(L)=CHAR8
C !!!!
                    CH4 = LDN_BACK(L)
                    IF(CH4(1:1).EQ.'.') CH4 = 'n/a '
                    WATOM1 = LDN_ATOM(L)
                    WATOM2 = CH4
                    WATOM3 = LDN_FORW(L)
                    CALL CORR_NAME_CIF_OUT(WATOM1)
                    CALL CORR_NAME_CIF_OUT(WATOM2)
                    CALL CORR_NAME_CIF_OUT(WATOM3)

                    WRITE(LINE,4600) 
     *              LDN_MNAME(L),LDN_FUNCT(L)
     *             ,WATOM1,WATOM2,LDN_BTYPE(L)
     *             ,WATOM3,LDN_TYPE(L)

c     *             ,LDN_FORW(L),LDN_1ATM(L)
c     *             ,LDN_2ATM(L),LDN_TYPE(L)
                    CALL WRTSTR(IUN,MDOC,LINE,IERR)
 4600               FORMAT(1X,A8,1X,A8,1X,A6,1X,A6,1X,A8
     *              ,1X,A6,1X,A8)
                  ENDDO
 4610             CONTINUE
                ENDIF
              ENDIF
              J=LDL_IBOND(I)
              IF(J.GT.0) THEN
                WRITE(LINE,'(''loop_'')')
                CALL WRTSTR(IUN,MDOC,LINE,IERR)
                WRITE(LINE,'(''_chem_mod_bond.mod_id'')')
                CALL WRTSTR(IUN,MDOC,LINE,IERR)
                WRITE(LINE,'(''_chem_mod_bond.function'')')
                CALL WRTSTR(IUN,MDOC,LINE,IERR)
                WRITE(LINE,'(''_chem_mod_bond.atom_id_1'')')
                CALL WRTSTR(IUN,MDOC,LINE,IERR)
                WRITE(LINE,'(''_chem_mod_bond.atom_id_2'')')
                CALL WRTSTR(IUN,MDOC,LINE,IERR)
                WRITE(LINE,'(''_chem_mod_bond.new_type'')')
                CALL WRTSTR(IUN,MDOC,LINE,IERR)
                WRITE(LINE,'(''_chem_mod_bond.new_value_dist'')')
                CALL WRTSTR(IUN,MDOC,LINE,IERR)
                WRITE(LINE,'(''_chem_mod_bond.new_value_dist_esd'')')
                CALL WRTSTR(IUN,MDOC,LINE,IERR)
                IF(LDB_NBOND.GT.0) THEN
                  DO L=J,LDB_NBOND
                    IF(LDB_MNAME(L).NE.CH8) GO TO 4710
                    ESD=LDB_DEV(L)
                    IF(ESD.LE.0.0) ESD=0.02
                    WATOM1 = LDB_1ATM(L) 
                    WATOM2 = LDB_2ATM(L)
                    CALL CORR_NAME_CIF_OUT(WATOM1)
                    CALL CORR_NAME_CIF_OUT(WATOM2)
                    WRITE(LINE,4700) 
     *              LDB_MNAME(L),LDB_FUNCT(L),WATOM1
     *             ,WATOM2,LDB_TYPE(L)
     *             ,LDB_VAL(L),ESD
                    CALL WRTSTR(IUN,MDOC,LINE,IERR)
 4700               FORMAT(1X,A8,1X,A8,1X,A6,2X,A6,4X,A8,1X
     *              ,F8.3,1X,F8.3)
                  ENDDO
 4710             CONTINUE
                ENDIF
              ENDIF
              J=LDL_ITHET(I)
              IF(J.GT.0) THEN
                WRITE(LINE,'(''loop_'')')
                CALL WRTSTR(IUN,MDOC,LINE,IERR)
                WRITE(LINE,'(''_chem_mod_angle.mod_id'')')
                CALL WRTSTR(IUN,MDOC,LINE,IERR)
                WRITE(LINE,'(''_chem_mod_angle.function'')')
                CALL WRTSTR(IUN,MDOC,LINE,IERR)
                WRITE(LINE,'(''_chem_mod_angle.atom_id_1'')')
                CALL WRTSTR(IUN,MDOC,LINE,IERR)
                WRITE(LINE,'(''_chem_mod_angle.atom_id_2'')')
                CALL WRTSTR(IUN,MDOC,LINE,IERR)
                WRITE(LINE,'(''_chem_mod_angle.atom_id_3'')')
                CALL WRTSTR(IUN,MDOC,LINE,IERR)
                WRITE(LINE,'(''_chem_mod_angle.new_value_angle'')')
                CALL WRTSTR(IUN,MDOC,LINE,IERR)
                WRITE(LINE,'(''_chem_mod_angle.new_value_angle_esd'')')
                CALL WRTSTR(IUN,MDOC,LINE,IERR)
                IF(LDG_NANGL.GT.0) THEN
                  DO L=J,LDG_NANGL
                    IF(LDG_MNAME(L).NE.CH8) GO TO 4810
                    ESD=LDG_DEV(L)
                    IF(ESD.LE.0.0) ESD=3.0
                    WATOM1 = LDG_1ATM(L)
                    WATOM2 = LDG_2ATM(L)
                    WATOM3 = LDG_3ATM(L)
                    CALL CORR_NAME_CIF_OUT(WATOM1)
                    CALL CORR_NAME_CIF_OUT(WATOM2)
                    CALL CORR_NAME_CIF_OUT(WATOM3)
                    WRITE(LINE,4800) 
     *              LDG_MNAME(L),LDG_FUNCT(L)
     *             ,WATOM1,WATOM2
     *             ,WATOM3
     *             ,LDG_VAL(L),ESD
                    CALL WRTSTR(IUN,MDOC,LINE,IERR)
 4800               FORMAT(1X,A8,1X,A8,1X,A6,2X,A6,2X,A6
     *              ,1X,F8.3,1X,F8.3)
                  ENDDO
 4810             CONTINUE
                ENDIF
              ENDIF
              J=LDL_ITORS(I)
              IF(J.GT.0) THEN
                WRITE(LINE,'(''loop_'')')
                CALL WRTSTR(IUN,MDOC,LINE,IERR)
                WRITE(LINE,'(''_chem_mod_tor.mod_id'')')
                CALL WRTSTR(IUN,MDOC,LINE,IERR)
                WRITE(LINE,'(''_chem_mod_tor.function'')')
                CALL WRTSTR(IUN,MDOC,LINE,IERR)
                WRITE(LINE,'(''_chem_mod_tor.id'')')
                CALL WRTSTR(IUN,MDOC,LINE,IERR)
                WRITE(LINE,'(''_chem_mod_tor.atom_id_1'')')
                CALL WRTSTR(IUN,MDOC,LINE,IERR)
                WRITE(LINE,'(''_chem_mod_tor.atom_id_2'')')
                CALL WRTSTR(IUN,MDOC,LINE,IERR)
                WRITE(LINE,'(''_chem_mod_tor.atom_id_3'')')
                CALL WRTSTR(IUN,MDOC,LINE,IERR)
                WRITE(LINE,'(''_chem_mod_tor.atom_id_4'')')
                CALL WRTSTR(IUN,MDOC,LINE,IERR)
                WRITE(LINE,'(''_chem_mod_tor.new_value_angle'')')
                CALL WRTSTR(IUN,MDOC,LINE,IERR)
                WRITE(LINE,'(''_chem_mod_tor.new_value_angle_esd'')')
                CALL WRTSTR(IUN,MDOC,LINE,IERR)
                WRITE(LINE,'(''_chem_mod_tor.new_period'')')
                CALL WRTSTR(IUN,MDOC,LINE,IERR)
                IF(LDT_NTORS.GT.0) THEN
                  DO L=J,LDT_NTORS
                    IF(LDT_MNAME(L).NE.CH8) GO TO 4910
                    ESD=LDT_DEV(L)
                    IF(ESD.LE.0.0) ESD=20.0
                    WATOM1 = LDT_1ATM(L)
                    WATOM2 = LDT_2ATM(L)
                    WATOM3 = LDT_3ATM(L)
                    WATOM4 = LDT_4ATM(L)
                    CALL CORR_NAME_CIF_OUT(WATOM1)
                    CALL CORR_NAME_CIF_OUT(WATOM2)
                    CALL CORR_NAME_CIF_OUT(WATOM3)
                    CALL CORR_NAME_CIF_OUT(WATOM4)
                    WRITE(LINE,4900) 
     *              LDT_MNAME(L),LDT_FUNCT(L),LDT_LABEL(L)
     *             ,WATOM1,WATOM2,WATOM3,WATOM4
     *             ,LDT_VAL(L),ESD,LDT_PRD(L)
                    CALL WRTSTR(IUN,MDOC,LINE,IERR)
 4900               FORMAT(1X,A8,1X,A8,1X,A8,1X,A6,1X,A6
     *              ,1X,A6,1X,A6,1X,F7.2,1X,F5.1,1X,I1)
                  ENDDO
 4910             CONTINUE
                ENDIF
              ENDIF
              J=LDL_ICHIR(I)
              IF(J.GT.0) THEN


                IF(LDC_NCHIR.GT.0) THEN
                  ICROSS = 0
                  DO L=J,LDC_NCHIR
                    IF(LDC_MNAME(L).NE.CH8) GO TO 5011
                    IF(LDC_SIGN(L)(1:6).EQ.'cross3'.OR.
     *                 LDC_SIGN(L)(1:6).EQ.'cross4'.OR.
     *                 LDC_SIGN(L)(1:6).EQ.'cross5'.OR.
     *                 LDC_SIGN(L)(1:6).EQ.'cross6'.OR.
     *                 LDC_SIGN(L)(1:5).EQ.'star5'.OR.
     *                 LDC_SIGN(L)(1:5).EQ.'star6'    ) ICROSS = 1
                  ENDDO
 5011             CONTINUE
                ENDIF 



                WRITE(LINE,'(''loop_'')')
                CALL WRTSTR(IUN,MDOC,LINE,IERR)
                WRITE(LINE,'(''_chem_mod_chir.mod_id'')')
                CALL WRTSTR(IUN,MDOC,LINE,IERR)

C                WRITE(LINE,'(''_chem_mod_chir.id'')')
C                CALL WRTSTR(IUN,MDOC,LINE,IERR)

                WRITE(LINE,'(''_chem_mod_chir.function'')')
                CALL WRTSTR(IUN,MDOC,LINE,IERR)
                WRITE(LINE,'(''_chem_mod_chir.atom_id_centre'')')
                CALL WRTSTR(IUN,MDOC,LINE,IERR)
                WRITE(LINE,'(''_chem_mod_chir.atom_id_1'')')
                CALL WRTSTR(IUN,MDOC,LINE,IERR)
                WRITE(LINE,'(''_chem_mod_chir.atom_id_2'')')
                CALL WRTSTR(IUN,MDOC,LINE,IERR)
                WRITE(LINE,'(''_chem_mod_chir.atom_id_3'')')
                CALL WRTSTR(IUN,MDOC,LINE,IERR)
                WRITE(LINE,'(''_chem_mod_chir.new_volume_sign'')')
                CALL WRTSTR(IUN,MDOC,LINE,IERR)

                  IF(ICROSS.EQ.1) THEN
                    WRITE(LINE,'(''_chem_mod_chir.atom_id_4'')')
                    CALL WRTSTR(IUN,MDOC,LINE,IERR)
                    WRITE(LINE,'(''_chem_mod_chir.atom_id_5'')')
                    CALL WRTSTR(IUN,MDOC,LINE,IERR)
                    WRITE(LINE,'(''_chem_mod_chir.atom_id_6'')')
                    CALL WRTSTR(IUN,MDOC,LINE,IERR)
                    WRITE(LINE,'(''_chem_mod_chir.atom_id_7'')')
                    CALL WRTSTR(IUN,MDOC,LINE,IERR)
                    WRITE(LINE,'(''_chem_mod_chir.atom_id_8'')')
                    CALL WRTSTR(IUN,MDOC,LINE,IERR)
                  ENDIF

                IF(LDC_NCHIR.GT.0) THEN
                  DO L=J,LDC_NCHIR
                    IF(LDC_MNAME(L).NE.CH8) GO TO 5010
C !!!
                    CHAR8='.'
C !!! 
                    WATOM1 = LDC_1ATM(L)
                    WATOM2 = LDC_2ATM(L)
                    WATOM3 = LDC_3ATM(L)
                    WATOM4 = LDC_4ATM(L)
                    CALL CORR_NAME_CIF_OUT(WATOM1)
                    CALL CORR_NAME_CIF_OUT(WATOM2)
                    CALL CORR_NAME_CIF_OUT(WATOM3)
                    CALL CORR_NAME_CIF_OUT(WATOM4)
                    WRITE(LINE,5000) 
     *              LDC_MNAME(L),LDC_FUNCT(L)
     *             ,WATOM1,WATOM2,WATOM3,WATOM4
     *             ,LDC_SIGN(L)
                    CALL WRTSTR(IUN,MDOC,LINE,IERR)
 5000               FORMAT(1X,A8,3X,1X,A8,1X,A6,2X,A6,2X,A6
     *              ,2X,A6,2X,A8)

                    IF(ICROSS.EQ.1) THEN
                      WATOM5 = LDC_5ATM(L) 
                      WATOM6 = LDC_6ATM(L) 
                      WATOM7 = LDC_7ATM(L)
                      WATOM8 = LDC_8ATM(L)
                      WATOM9 = LDC_9ATM(L)
                      CALL CORR_NAME_CIF_OUT(WATOM5)
                      CALL CORR_NAME_CIF_OUT(WATOM6)
                      CALL CORR_NAME_CIF_OUT(WATOM7)
                      CALL CORR_NAME_CIF_OUT(WATOM8)
                      CALL CORR_NAME_CIF_OUT(WATOM9)
                      WRITE(LINE,5001) 
     *                WATOM5,WATOM6,WATOM7,WATOM8,WATOM9
                      CALL WRTSTR(IUN,MDOC,LINE,IERR)
 5001                 FORMAT(19X,A6,1X,A6,1X,A6,1X,A6,1X,A6)
                    ENDIF

                  ENDDO
 5010             CONTINUE
                ENDIF
              ENDIF
              J=LDL_IPLAN(I)
              IF(J.GT.0) THEN
                WRITE(LINE,'(''loop_'')')
                CALL WRTSTR(IUN,MDOC,LINE,IERR)
                WRITE(LINE,'(''_chem_mod_plane_atom.mod_id'')')
                CALL WRTSTR(IUN,MDOC,LINE,IERR)
                WRITE(LINE,'(''_chem_mod_plane_atom.function'')')
                CALL WRTSTR(IUN,MDOC,LINE,IERR)
                WRITE(LINE,'(''_chem_mod_plane_atom.plane_id'')')
                CALL WRTSTR(IUN,MDOC,LINE,IERR)
                WRITE(LINE,'(''_chem_mod_plane_atom.atom_id'')')
                CALL WRTSTR(IUN,MDOC,LINE,IERR)
                WRITE(LINE,'(''_chem_mod_plane_atom.new_dist_esd'')')
                CALL WRTSTR(IUN,MDOC,LINE,IERR)
                IF(LDP_NPLAN.GT.0) THEN
                  DO L=J,LDP_NPLAN
                    IF(LDP_MNAME(L).NE.CH8) GO TO 5110
                    DO K=1,LDP_NATOM(L)
                      IATOM  = LDP_ATOM(K,L)
                      WATOM1 = ATOM
                      CALL CORR_NAME_CIF_OUT(WATOM1)
                      WRITE(LINE,5100) 
     *                LDP_MNAME(L),LDP_FUNCT(L),LDP_LABEL(L)
     *               ,WATOM1,LDP_DEV(K,L)
                      CALL WRTSTR(IUN,MDOC,LINE,IERR)
 5100                 FORMAT(1X,A8,3X,A8,2X,A8,1X,A6,1X,F8.3)
                    ENDDO
                  ENDDO
 5110             CONTINUE
                ENDIF
              ENDIF
C -----------------------------
      RETURN
      END

      SUBROUTINE CHKASYM(MDOC,ASYMB,INSF,IERR)
C -----------------------------------------------
C -P- CHKASYM -
C -S-
C ---
      INCLUDE 'lib_com.fh'
C --
      INTEGER*4 MDOC,IERR
      CHARACTER ASYMB*4
C ******
      CHARACTER LINE*256
C ---------------------------------------
      JERR = 0
  200 CONTINUE
      IERR = 0
      INSF = 0

      IF(LSF_NASYMB.GT.0) THEN
        DO  I=1,LSF_NASYMB
          IF(LSF_ELEMENT(I).EQ.ASYMB) THEN
            INSF = I
            GO TO 100
          ENDIF
        ENDDO
      ENDIF

      CALL GET_SFA(ASYMB
     *      ,N,NE,A1,A2,A3,A4,B1,B2,B3,B4,C,FI,FII,RAD,IERR)

C      CALL GET_SFA(ASYMB,NE,A1,A2,A3,A4,B1,B2,B3,B4,C,FI,FII,IERR)

      IF(IERR.EQ.1) THEN

        WRITE(LINE,300) ASYMB
  300   FORMAT(
     *  ' WARNING: can''t find atomic scatt.factors for :',A4)
        CALL MSGDOC(MDOC,LINE)
        CALL MSGDOC(MDOC,
     *  '          default symbol is "N   "')
        ASYMB = 'N   '
        JERR  = 2
        GO TO 200

      ENDIF

      LSF_NASYMB = LSF_NASYMB + 1
      IF(LSF_NASYMB.GT.MAXASYMB) THEN
        WRITE(LINE,'(A,I6,A)')
     *' ERR: number of tables of atomic scatt. factors >',MAXASYMB,
     *' /lib. limit/'
        CALL MSGERR(MDOC,LINE)
        CALL MSGERR(MDOC,
     *  ' Change parameter MAXMLIST in "lib_com.fh"')
        IERR=1
        RETURN
      ENDIF

      INSF                    = LSF_NASYMB

      LSF_ELEMENT(LSF_NASYMB) = ASYMB
      LSF_ATOM   (LSF_NASYMB) = ASYMB

      LSF_NE     (LSF_NASYMB) = NE
      LSF_A1     (LSF_NASYMB) = A1
      LSF_A2     (LSF_NASYMB) = A2
      LSF_A3     (LSF_NASYMB) = A3
      LSF_A4     (LSF_NASYMB) = A4
      LSF_B1     (LSF_NASYMB) = B1
      LSF_B2     (LSF_NASYMB) = B2
      LSF_B3     (LSF_NASYMB) = B3
      LSF_B4     (LSF_NASYMB) = B4
      LSF_C      (LSF_NASYMB) = C
      LSF_FI     (LSF_NASYMB) = FI
      LSF_FII    (LSF_NASYMB) = FII
      LSF_RAD    (LSF_NASYMB) = RAD
  100 CONTINUE     
      IERR = 0
      IF(JERR.GT.0) IERR = JERR
      RETURN
      END


C ******
      SUBROUTINE PUT_MDLIB(MDOC,I,BLOCK,LENB,ITEM,LENI
     *  ,DATA,IDATA,FDATA,LEND,IERR)
C -------------------------------------------------------
C -P- PUT_MDLIB - reads modification's description.
C -S-
C -------------------------------------------------------
      INCLUDE 'lib_com.fh'
C ----
      REAL      FDATA
      INTEGER*4 IDATA,MDOC,I,IERR
      INTEGER*4 LENB,LENI,LEND
      CHARACTER BLOCK*(*),DATA*(*),ITEM*(*)
C -----------------------------------------------
      INCLUDE 'CIF_items_lib.fh'
C -----------------------------------------------
      IERR = 0

C     DATA ITL_MOD       /'_chem_mod.                              '/
      CALL LENSTR_BL(ITL_MOD,LMD)
      CALL LENSTR_BL(ITL_MODA,LMDA)
      CALL LENSTR_BL(ITL_MODR,LMDR)
      CALL LENSTR_BL(ITL_MODB,LMDB)
      CALL LENSTR_BL(ITL_MODG,LMDG)
      CALL LENSTR_BL(ITL_MODT,LMDT)
      CALL LENSTR_BL(ITL_MODC,LMDC)
      CALL LENSTR_BL(ITL_MODP,LMDP)


      IF(LDL_NMOD.LE.0) RETURN
      IF(ITEM(1:LMD).EQ.ITL_MOD(1:LMD)) THEN
c        CALL PT_MDLIST(MDOC,I,BLOCK,LENB,ITEM,LENI
c     *    ,DATA,IDATA,FDATA,LEND,IERR)
C      ELSE IF(ITEM(1:15).EQ.'_chem_mod_comp.') THEN
C        CALL PT_MDREC(MDOC,I,BLOCK,LENB,ITEM,LENI
C     *    ,DATA,IDATA,FDATA,LEND,IERR)
      ELSE IF(ITEM(1:LMDA).EQ.ITL_MODA(1:LMDA)) THEN
        CALL PT_MDATOM(MDOC,I,BLOCK,LENB,ITEM,LENI
     *    ,DATA,IDATA,FDATA,LEND,IERR)
      ELSE IF(ITEM(1:LMDR).EQ.ITL_MODR(1:LMDR)) THEN
        CALL PT_MDCONN(MDOC,I,BLOCK,LENB,ITEM,LENI
     *    ,DATA,IDATA,FDATA,LEND,IERR)
      ELSE IF(ITEM(1:LMDB).EQ.ITL_MODB(1:LMDB)) THEN
        CALL PT_MDBOND(MDOC,I,BLOCK,LENB,ITEM,LENI
     *    ,DATA,IDATA,FDATA,LEND,IERR)
      ELSE IF(ITEM(1:LMDG).EQ.ITL_MODG(1:LMDG)) THEN
        CALL PT_MDANGL(MDOC,I,BLOCK,LENB,ITEM,LENI
     *    ,DATA,IDATA,FDATA,LEND,IERR)
      ELSE IF(ITEM(1:LMDT).EQ.ITL_MODT(1:LMDT)) THEN
        CALL PT_MDTORS(MDOC,I,BLOCK,LENB,ITEM,LENI
     *    ,DATA,IDATA,FDATA,LEND,IERR)
      ELSE IF(ITEM(1:LMDC).EQ.ITL_MODC(1:LMDC)) THEN
        CALL PT_MDCHIR(MDOC,I,BLOCK,LENB,ITEM,LENI
     *    ,DATA,IDATA,FDATA,LEND,IERR)
      ELSE IF(ITEM(1:LMDP).EQ.ITL_MODP(1:LMDP)) THEN
        CALL PT_MDPLAN(MDOC,I,BLOCK,LENB,ITEM,LENI
     *    ,DATA,IDATA,FDATA,LEND,IERR)

      ENDIF
      RETURN
C -----------------------------------
      END     

C ******
      SUBROUTINE PT_MDLIST(MDOC,I,BLOCK,LENB,ITEM,LENI
     *  ,DATA,IDATA,FDATA,LEND,IERR)
C ---------------------------------------------
C -P- PT_MDLIST - reads modification's description.
C -S-
C ---------------------------------------------
      REAL      FDATA
      INTEGER*4 IDATA,MDOC,I,IERR
      INTEGER*4 LENB,LENI,LEND
      CHARACTER BLOCK*(*),DATA*(*),ITEM*(*)
C -----------------------------------------------
      INCLUDE 'lib_com.fh'
C -----------------------------------
      CHARACTER LINE*256
C -----------------------------------------------
      INCLUDE 'CIF_items_lib.fh'
C -----------------------------------------------
      IERR=0

      CALL LENSTR_BL(ITL_MOD_ID,LMDI)

C      DATA ITL_MOD_NAME  /'_chem_mod.name                          '/
C      DATA ITL_MOD_COMP  /'_chem_mod.comp_id                       '/
C      DATA ITL_MOD_GRP   /'_chem_mod.group_id                      '/
      CALL LENSTR_BL(ITL_MOD_NAME,LMDN)
      CALL LENSTR_BL(ITL_MOD_COMP,LMDC)
      CALL LENSTR_BL(ITL_MOD_GRP ,LMDG)
         
      IF(ITEM(1:LMDI).EQ.ITL_MOD_ID) THEN 
        IF(I.NE.1) THEN
          WRITE(LINE,'(A,A8,A)')' ERR: item _chem_mod.id :',DATA(1:8),
     *          ' must be first in the string'
          CALL MSGERR(MDOC,LINE)
          LDL_IMOD = 0           
          IERR     = 1
          RETURN
        ENDIF
        LDL_NMOD = LDL_NMOD+1
        IF(LDL_NMOD.GT.MAXDMDF) THEN
          WRITE(LINE,'(A,I6,A)')' ERR: number of modifications >'
     *    ,MAXDMDF,' /lib. limit/'
          CALL MSGERR(MDOC,LINE)
            CALL MSGERR(MDOC,
     *  ' Change parameter MAXMLIST in "lib_com.fh"')
          LDL_NMOD = 0
          IERR     = 1
          RETURN
        ENDIF
        LDL_IMOD                 = LDL_NMOD
        LDL_MNAME(LDL_IMOD)(1:8) = DATA(1:8)
        LDL_FUSE (LDL_IMOD)      = 'N'
        IF(LB_PASS.GT.LB_NUMB_LIB)  LDL_FUSE(LDL_IMOD) = 'C'
        LDL_ORDER(LDL_IMOD)      = 0
        RETURN
      ENDIF
C COMLETENESS ????
      IF(LDL_IMOD.GT.0.AND.I.GT.1) THEN
        IF(ITEM(1:LMDC).EQ.ITL_MOD_COMP(1:LMDC)) THEN
          LDL_COMP  (LDL_IMOD) =DATA(1:LEND)
        ELSE IF(ITEM(1:LMDN).EQ.ITL_MOD_NAME(1:LMDN)) THEN
          LDL_DETAIL (LDL_IMOD)=DATA(1:LEND)
        ELSE IF(ITEM(1:LMDG).EQ.ITL_MOD_GRP(1:LMDG)) THEN
          LDL_TYPE(LDL_IMOD)=DATA(1:LEND)
        ENDIF
      ENDIF
      RETURN
C -----------------------------------
      END     

C ******
      SUBROUTINE PT_MDREC(MDOC,I,BLOCK,LENB,ITEM,LENI
     *  ,DATA,IDATA,FDATA,LEND,IERR)
C ---------------------------------------------
C -P- PT_MDREC -
C -S-
C ---------------------------------------------
      REAL      FDATA
      INTEGER*4 IDATA,MDOC,I,IERR
      INTEGER*4 LENB,LENI,LEND
      CHARACTER BLOCK*(*),DATA*(*),ITEM*(*)
C -----------------------------------------------
      INCLUDE 'lib_com.fh'
C ******
C -----------------------------------
      CHARACTER LINE*256
C -----------------------------------
      IERR=0

      IF(I.EQ.1) THEN
        LMR_NREC=LMR_NREC+1
        IF(LMR_NREC.GT.MAXDMDF) THEN
          WRITE(LINE,'(A,I6,A)')
     * ' ERR: number of lines in _chem_mod_comp. >',MAXDMDF,
     * ' /lib. limit'
          CALL MSGERR(MDOC,LINE)
          CALL MSGERR(MDOC,
     *    ' Change parameter MAXMLIST in "lib_com.fh"')
          LMR_NREC=0
          IERR=1
          RETURN
        ENDIF
      ENDIF

C COMLETENESS ????

        IF(ITEM(16:22).EQ.     'comp_id'  ) THEN
          LMR_COMP   (LMR_NREC)=DATA(1:LEND)
        ELSE IF(ITEM(16:21).EQ.'mod_id'   ) THEN
          LMR_MNAME  (LMR_NREC)=DATA(1:LEND)
        ELSE IF(ITEM(16:19).EQ.'name') THEN
          LMR_DETAIL (LMR_NREC)=DATA(1:LEND)
        ELSE IF(ITEM(16:19).EQ.'type') THEN
          LMR_TYPE   (LMR_NREC)=DATA(1:LEND)
        ENDIF

      RETURN
C -----------------------------------
      END     

C ******
      SUBROUTINE PT_MDATOM(MDOC,I,BLOCK,LENB,ITEM,LENI
     *  ,DATA,IDATA,FDATA,LEND,IERR)
C -------------------------------------------------------
C -P- PT_MDATOM 
C -S-
C -------------------------------------------------------
C ----
      REAL      FDATA
      INTEGER*4 IDATA,MDOC,I,IERR
      INTEGER*4 LENB,LENI,LEND
      CHARACTER BLOCK*(*),DATA*(*),ITEM*(*)
C -----------------------------------------------
      INCLUDE 'lib_com.fh'
C ******
C -----------------------------------
      CHARACTER LINE*256,MOD*8,ASYMB*4
C -----------------------------------
      IERR = 0
      IF(ITEM(16:21).EQ.'mod_id' ) THEN 
        IF(I.NE.1) THEN
          WRITE(LINE,'(A,A8,A)')' ERR: item _chem_mod_atom.mod_id :'
     *    ,DATA(1:8),' must be first in the string'
          CALL MSGERR(MDOC,LINE)
          LDL_IMOD = 0           
          IERR     = 1
          RETURN
        ENDIF
        MOD = DATA(1:8)
        IF(LDL_NMOD.LE.0) THEN
          CALL MSGERR(MDOC,
     *    ' ERR: number of modifications in the list= 0')
          IERR = 1
          RETURN
        ENDIF
        IF(LDL_IMOD.EQ.0) LDL_IMOD=1
        DO J=1,LDL_NMOD
          L = (LDL_IMOD-1)+J
          IF(L.GT.LDL_NMOD) L=L-LDL_NMOD
C          IF(MOD.EQ.LDL_MNAME(L).AND.LDL_SUB_MOD(L)(1:1).EQ.'.')THEN
          IF(MOD.EQ.LDL_MNAME(L))THEN
            LDL_IMOD  = L
            LDA_NATOM = LDA_NATOM+1
            IF(LDA_NATOM.GT.MAXDATM) THEN
            WRITE(LINE,'(A,A8,A,I6,A)')' ERR: number of atoms for mod:'
     *        ,MOD,'  >',MAXDATM,' /lib. limit/'
              CALL MSGERR(MDOC,LINE)
            CALL MSGERR(MDOC,
     *  ' Change parameter MAXMLIST in "lib_com.fh"')
              LDL_IMOD = 0           
              IERR     = 1
              RETURN
            ENDIF
            IF(LDL_IATOM(L).EQ.0) LDL_IATOM(L) = LDA_NATOM 
            LDA_MNAME(LDA_NATOM) = DATA(1:8)

            LDA_SYMB (LDA_NATOM) = '.'
            LDA_CHEM (LDA_NATOM) = '.'
            LDA_CHARG(LDA_NATOM) = 0.0
            LDA_ANEW (LDA_NATOM) = '.'

            RETURN
          ENDIF
        ENDDO
        WRITE(LINE,'(A,A8,A)')' ERR: item _chem_mod_atom.mod_id :',
     *     MOD,' not found in the list of modifications'
        CALL MSGERR(MDOC,LINE)
        WRITE(LINE,'('' BLOCK :'',A)') BLOCK(1:LENB)
        CALL MSGERR(MDOC,LINE)
        LDL_IMOD = 0           
        IERR     = 1
        RETURN
      ENDIF
C COMLETENESS ????
      IF(LDL_IMOD.GT.0.AND.I.GT.1) THEN
        IF(ITEM(16:22).EQ.'atom_id'  ) THEN
          LDA_ANAME(LDA_NATOM)=DATA(1:4)
        ELSE IF(ITEM(16:30).EQ.'new_type_symbol') THEN
          ASYMB=DATA(1:4)
          IF(ASYMB(1:1).NE.'.') THEN
            CALL CHKASYM(MDOC,ASYMB,INSF,IERR)
            IERR = 0
          ENDIF
          LDA_SYMB (LDA_NATOM)=ASYMB
        ELSE IF(ITEM(16:30).EQ.'new_type_energy') THEN
          LDA_CHEM(LDA_NATOM)=DATA(1:4)
        ELSE IF(ITEM(16:23).EQ.'function') THEN
          LDA_FUNCT(LDA_NATOM)=DATA(1:8)
        ELSE IF(ITEM(16:33).EQ.'new_partial_charge') THEN
          LDA_CHARG(LDA_NATOM)=FDATA
        ELSE IF(ITEM(16:26).EQ.'new_atom_id') THEN
          LDA_ANEW (LDA_NATOM)=DATA(1:4)
        ENDIF
      ENDIF
      RETURN
C -----------------------------------
      END     

C ******
      SUBROUTINE PT_MDCONN(MDOC,I,BLOCK,LENB,ITEM,LENI
     *  ,DATA,IDATA,FDATA,LEND,IERR)
C -------------------------------------------------------
C -P- PT_MDCONN -
C -S-
C -------------------------------------------------------
C ----
      REAL      FDATA
      INTEGER*4 IDATA,MDOC,I,IERR
      INTEGER*4 LENB,LENI,LEND
      CHARACTER BLOCK*(*),DATA*(*),ITEM*(*)
C -----------------------------------------------
      INCLUDE 'lib_com.fh'
C -----------------------------------
      CHARACTER LINE*256,MOD*8
C -----------------------------------
      IERR = 0
      IF(ITEM(16:21).EQ.'mod_id' ) THEN 
        IF(I.NE.1) THEN
          WRITE(LINE,'(A,A8,A)')' ERR: item _chem_mod_tree.mod_id :'
     *    ,DATA(1:8),' must be first in the string'
          CALL MSGERR(MDOC,LINE)
          LDL_IMOD = 0           
          IERR     = 1
          RETURN
        ENDIF
        MOD = DATA(1:8)
        IF(LDL_NMOD.LE.0) THEN
          CALL MSGERR(MDOC
     *    ,' ERR: number of modifications in the list = 0')
          LDL_IMOD = 0           
          IERR     = 1
          RETURN
        ENDIF
        IF(LDL_IMOD.EQ.0) LDL_IMOD = 1
        DO J=1,LDL_NMOD
          L = (LDL_IMOD-1)+J
          IF(L.GT.LDL_NMOD) L=L-LDL_NMOD
C          IF(MOD.EQ.LDL_MNAME(L).AND.LDL_SUB_MOD(L)(1:1).EQ.'.')THEN
          IF(MOD.EQ.LDL_MNAME(L))THEN
            LDL_IMOD  = L
            LDN_NCONN = LDN_NCONN+1
            IF(LDN_NCONN.GT.MAXDCNN) THEN
              WRITE(LINE,'(A,A8,A,I6,A)')
     *        ' ERR: read number of connections for mod:'
     *        ,MOD,'  >',MAXDCNN,' /lib. limit/'
              CALL MSGERR(MDOC,LINE)
              CALL MSGERR(MDOC,
     *  ' Change parameter MAXMLIST in "lib_com.fh"')
              LDL_IMOD = 0           
              IERR     = 1
              RETURN
            ENDIF
            IF(LDL_ICONN(L).EQ.0) LDL_ICONN(L) = LDN_NCONN 

            LDN_MNAME(LDN_NCONN) = MOD

            LDN_ATOM (LDN_NCONN) = '.'
            LDN_BACK (LDN_NCONN) = '.'
            LDN_BTYPE(LDN_NCONN) = '.'
            LDN_FORW (LDN_NCONN) = '.'
            LDN_1ATM (LDN_NCONN) = '.'
            LDN_TYPE (LDN_NCONN) = '.'
            LDN_2ATM (LDN_NCONN) = '.'

            RETURN
          ENDIF
        ENDDO
        WRITE(LINE,'(A,A8,A)')' ERR: item _chem_mod_tree.mod_id :'
     *     ,MOD,' not found in the list of modifications'
        CALL MSGERR(MDOC,LINE)
        WRITE(LINE,'('' BLOCK :'',A)') BLOCK(1:LENB)
        CALL MSGERR(MDOC,LINE)
        LDL_IMOD = 0           
        IERR     = 1
        RETURN
      ENDIF

C COMLETENESS ????
      IF(LDL_IMOD.GT.0.AND.I.GT.1) THEN
        IF(ITEM(16:22).EQ.     'atom_id' ) THEN 
          LDN_ATOM(LDN_NCONN)  = DATA(1:4)
        ELSE IF(ITEM(16:24).EQ.'atom_back'  ) THEN
          IF(DATA(1:3).EQ.'n/a') DATA(1:4) = '.   '
          LDN_BACK(LDN_NCONN)  = DATA(1:4)
        ELSE IF(ITEM(16:24).EQ.'back_type'  ) THEN
          LDN_BTYPE(LDN_NCONN) = DATA(1:8)
        ELSE IF(ITEM(16:23).EQ.'function'  ) THEN
          LDN_FUNCT(LDN_NCONN) = DATA(1:8)
        ELSE IF(ITEM(16:27).EQ.'atom_forward'  ) THEN
          IF(DATA(1:3).EQ.'n/a') DATA(1:4) = '.   '
          LDN_FORW(LDN_NCONN)  = DATA(1:4)
        ELSE IF(ITEM(16:27).EQ.'connect_type'  ) THEN
          LDN_TYPE(LDN_NCONN)=DATA(1:8)
        ENDIF

C        ELSE IF(ITEM(27:43).EQ.'connect_atom_id_1'  ) THEN
C          LDN_1ATM(LDN_NCONN) = DATA(1:4)
C        ELSE IF(ITEM(27:38).EQ.'connect_type'  ) THEN
C          LDN_TYPE(LDN_NCONN) = DATA(1:8)
C        ELSE IF(ITEM(27:43).EQ.'connect_atom_id_2'  ) THEN
C          LDN_2ATM(LDN_NCONN) = DATA(1:4)
C        ENDIF

      ENDIF

      RETURN
C -----------------------------------
      END     


C ******
      SUBROUTINE PT_MDBOND(MDOC,I,BLOCK,LENB,ITEM,LENI
     *  ,DATA,IDATA,FDATA,LEND,IERR)
C -------------------------------------------------------
C -P- PT_MDBOND -
C -S-
C -------------------------------------------------------
C ----
      REAL      FDATA
      INTEGER*4 IDATA,MDOC,I,IERR
      INTEGER*4 LENB,LENI,LEND
      CHARACTER BLOCK*(*),DATA*(*),ITEM*(*)
C -----------------------------------------------
      INCLUDE 'lib_com.fh'
C ******
C -----------------------------------
      CHARACTER LINE*256,MOD*8
C -----------------------------------
      IERR = 0
      IF(ITEM(16:21).EQ.'mod_id' ) THEN 
        IF(I.NE.1) THEN
          WRITE(LINE,'(A,A8,A)')' ERR: item _chem_mod_bond.mod_id :'
     *    ,DATA(1:8),' must be first in the string'
          CALL MSGERR(MDOC,LINE)
          LDL_IMOD = 0           
          IERR     = 1
          RETURN
        ENDIF
        MOD = DATA(1:8)
        IF(LDL_NMOD.LE.0) THEN
          CALL MSGERR(MDOC
     *    ,' ERR: number of modifications in the list= 0')
          IERR = 1
          RETURN
        ENDIF
        IF(LDL_IMOD.EQ.0) LDL_IMOD = 1
        DO J=1,LDL_NMOD
          L = (LDL_IMOD-1)+J
          IF(L.GT.LDL_NMOD) L=L-LDL_NMOD
C         IF(MOD.EQ.LDL_MNAME(L).AND.LDL_SUB_MOD(L)(1:1).EQ.'.')THEN
          IF(MOD.EQ.LDL_MNAME(L))THEN
            LDL_IMOD  = L
            LDB_NBOND = LDB_NBOND+1
            IF(LDB_NBOND.GT.MAXDBND) THEN
              WRITE(LINE,'(A,A8,A,I6,A)')
     *      ' ERR: read number of bonds for mod:',MOD,' >',MAXDBND,
     *      ' /lib. limit/'
              CALL MSGERR(MDOC,LINE)
            CALL MSGERR(MDOC,
     *  ' Change parameter MAXMLIST in "lib_com.fh"')
              LDL_IMOD = 0           
              IERR     = 1
              RETURN
            ENDIF
            IF(LDL_IBOND(L).EQ.0) LDL_IBOND(L)=LDB_NBOND 
            LDB_MNAME(LDB_NBOND) = DATA(1:8)
            RETURN
          ENDIF
        ENDDO
        WRITE(LINE,'(A,A8,A)')' ERR: item _chem_mod_bond.mod_id :',MOD,
     *   ' not found in the list of modifications'
        CALL MSGERR(MDOC,LINE)
        WRITE(LINE,'('' BLOCK :'',A)') BLOCK(1:LENB)
        CALL MSGERR(MDOC,LINE)
        LDL_IMOD = 0           
        IERR     = 1
        RETURN
      ENDIF
C COMLETENESS ????
      IF(LDL_IMOD.GT.0.AND.I.GT.1) THEN
        IF(ITEM(16:24).EQ.'atom_id_1'  ) THEN
          LDB_1ATM (LDB_NBOND)  = DATA(1:4)
        ELSE IF(ITEM(16:24).EQ.'atom_id_2'  ) THEN
          LDB_2ATM (LDB_NBOND)  = DATA(1:4)
        ELSE IF(ITEM(16:23).EQ.'new_type') THEN
          LDB_TYPE (LDB_NBOND)  = DATA(1:8)
        ELSE IF(ITEM(16:33).EQ.'new_value_dist_esd') THEN
          LDB_DEV  (LDB_NBOND)  = FDATA
        ELSE IF(ITEM(16:29).EQ.'new_value_dist') THEN
          LDB_VAL  (LDB_NBOND)  = FDATA
        ELSE IF(ITEM(16:23).EQ.'function'  ) THEN
          LDB_FUNCT (LDB_NBOND) = DATA(1:8)
        ENDIF
      ENDIF

      RETURN
C -----------------------------------
      END     
C ******

      SUBROUTINE PT_MDANGL(MDOC,I,BLOCK,LENB,ITEM,LENI
     *  ,DATA,IDATA,FDATA,LEND,IERR)
C -------------------------------------------------------
C -P- PT_MDANGL - 
C -S-
C -------------------------------------------------------
C ----
      REAL      FDATA
      INTEGER*4 IDATA,MDOC,I,IERR
      INTEGER*4 LENB,LENI,LEND
      CHARACTER BLOCK*(*),DATA*(*),ITEM*(*)
C -----------------------------------------------
      INCLUDE 'lib_com.fh'
C ******
C -----------------------------------
      CHARACTER LINE*256,MOD*8
C -----------------------------------
      IERR=0
      IF(ITEM(17:22).EQ.'mod_id' ) THEN 
        IF(I.NE.1) THEN
          WRITE(LINE,'(A,A8,A)')' ERR: item _chem_mod_angle.mod_id :'
     *    ,DATA(1:8),' must be first in the string'
          CALL MSGERR(MDOC,LINE)
          LDL_IMOD = 0           
          IERR=1
          RETURN
        ENDIF
        MOD=DATA(1:8)
        IF(LDL_NMOD.LE.0) THEN
          CALL MSGERR(MDOC
     *    ,' ERR: number of modifications in the list= 0')
          IERR=1
          RETURN
        ENDIF
        IF(LDL_IMOD.EQ.0) LDL_IMOD=1
        DO J=1,LDL_NMOD
          L=(LDL_IMOD-1)+J
          IF(L.GT.LDL_NMOD) L=L-LDL_NMOD
C          IF(MOD.EQ.LDL_MNAME(L).AND.LDL_SUB_MOD(L)(1:1).EQ.'.')THEN
          IF(MOD.EQ.LDL_MNAME(L))THEN
            LDL_IMOD = L
            LDG_NANGL=LDG_NANGL+1
            IF(LDG_NANGL.GT.MAXDANG) THEN
              WRITE(LINE,'(A,A8,A,I6,A)')
     *  ' ERR: read number of angles for mod:',MOD,' >',MAXDANG,
     *  ' /lib. limit/'
              CALL MSGERR(MDOC,LINE)
            CALL MSGERR(MDOC,
     *  ' Change parameter MAXMLIST in "lib_com.fh"')
              LDL_IMOD = 0           
              IERR=1
              RETURN
            ENDIF
            IF(LDL_ITHET(L).EQ.0) LDL_ITHET(L)=LDG_NANGL 
            LDG_MNAME(LDG_NANGL) = DATA(1:8)
            RETURN
          ENDIF
        ENDDO
        WRITE(LINE,'(A,A8,A)')' ERR: item _chem_mod_angle.mod_id :',MOD,
     *  ' not found in the list of modifications'
        CALL MSGERR(MDOC,LINE)
        WRITE(LINE,'('' BLOCK :'',A)') BLOCK(1:LENB)
        CALL MSGERR(MDOC,LINE)
        LDL_IMOD = 0           
        IERR=1
        RETURN
      ENDIF
C COMLETENESS ????

      IF(LDL_IMOD.GT.0.AND.I.GT.1) THEN
        IF(ITEM(17:25)     .EQ.'atom_id_1'  ) THEN
          LDG_1ATM (LDG_NANGL)=DATA(1:4)
        ELSE IF(ITEM(17:25).EQ.'atom_id_2'  ) THEN
          LDG_2ATM (LDG_NANGL)=DATA(1:4)
        ELSE IF(ITEM(17:25).EQ.'atom_id_3'  ) THEN
          LDG_3ATM (LDG_NANGL)=DATA(1:4)
        ELSE IF(ITEM(17:35).EQ.'new_value_angle_esd') THEN
          LDG_DEV  (LDG_NANGL)=FDATA
        ELSE IF(ITEM(17:31).EQ.'new_value_angle') THEN
          LDG_VAL  (LDG_NANGL)=FDATA
        ELSE IF(ITEM(17:24).EQ.'function'  ) THEN
          LDG_FUNCT (LDG_NANGL)=DATA(1:8)
        ENDIF
      ENDIF

      RETURN
C -----------------------------------
      END     

C ******
      SUBROUTINE PT_MDTORS(MDOC,I,BLOCK,LENB,ITEM,LENI
     *  ,DATA,IDATA,FDATA,LEND,IERR)
C -------------------------------------------------------
C -P- PT_MDTORS - 
C -S-
C -------------------------------------------------------
C ----
      REAL      FDATA
      INTEGER*4 IDATA,MDOC,I,IERR
      INTEGER*4 LENB,LENI,LEND
      CHARACTER BLOCK*(*),DATA*(*),ITEM*(*)
C -----------------------------------------------
      INCLUDE 'lib_com.fh'
C ******
C -----------------------------------
      CHARACTER LINE*256,MOD*8
C -----------------------------------
      IERR=0
      IF(ITEM(15:20).EQ.'mod_id' ) THEN 
        IF(I.NE.1) THEN
          WRITE(LINE,'(A,A8,A)')' ERR: item _chem_mod_tor.mod_id :'
     *    ,DATA(1:8),' must be first in the string'
          CALL MSGERR(MDOC,LINE)
          LDL_IMOD = 0           
          IERR=1
          RETURN
        ENDIF
        MOD=DATA(1:8)
        IF(LDL_NMOD.LE.0) THEN
          CALL MSGERR(MDOC
     *    ,' ERR: number of modifications in the list= 0')
          IERR=1
          RETURN
        ENDIF
        IF(LDL_IMOD.EQ.0) LDL_IMOD=1
        DO J=1,LDL_NMOD
          L=(LDL_IMOD-1)+J
          IF(L.GT.LDL_NMOD) L=L-LDL_NMOD
C          IF(MOD.EQ.LDL_MNAME(L).AND.LDL_SUB_MOD(L)(1:1).EQ.'.')THEN
          IF(MOD.EQ.LDL_MNAME(L))THEN
            LDL_IMOD = L
            LDT_NTORS=LDT_NTORS+1
            IF(LDT_NTORS.GT.MAXDTOR) THEN
              WRITE(LINE,'(A,A8,A,I6,A)')
     *       ' ERR: read number of tors for mod:'
     *        ,MOD,'  >',MAXDTOR,' /lib. limit/'
              CALL MSGERR(MDOC,LINE)
            CALL MSGERR(MDOC,
     *  ' Change parameter MAXMLIST in "lib_com.fh"')
              LDL_IMOD = 0           
              IERR=1
              RETURN
            ENDIF
            IF(LDL_ITORS(L).EQ.0) LDL_ITORS(L)=LDT_NTORS 
            LDT_MNAME(LDT_NTORS) = DATA(1:8)
            LDT_LABEL(LDT_NTORS) = '.'
            RETURN
          ENDIF
        ENDDO
        WRITE(LINE,'(A,A8,A)')' ERR: item _chem_mod_tor.mod_id :'
     *  ,MOD,' not found in the list of modifications'
        CALL MSGERR(MDOC,LINE)
        WRITE(LINE,'('' BLOCK :'',A)') BLOCK(1:LENB)
        CALL MSGERR(MDOC,LINE)
        LDL_IMOD = 0           
        IERR=1
        RETURN
      ENDIF
C COMLETENESS ????
      IF(LDL_IMOD.GT.0.AND.I.GT.1) THEN
        IF(ITEM(15:33).EQ.'new_value_angle_esd' ) THEN
          LDT_DEV  (LDT_NTORS)=FDATA
        ELSE IF(ITEM(15:29).EQ.'new_value_angle'    ) THEN
          LDT_VAL  (LDT_NTORS)=FDATA
        ELSE IF(ITEM(15:24).EQ.'new_period') THEN
          LDT_PRD  (LDT_NTORS)=IDATA
        ELSE IF(ITEM(15:23).EQ.'atom_id_1') THEN
          LDT_1ATM (LDT_NTORS)=DATA(1:4)
        ELSE IF(ITEM(15:23).EQ.'atom_id_2') THEN
          LDT_2ATM (LDT_NTORS)=DATA(1:4)
        ELSE IF(ITEM(15:23).EQ.'atom_id_3') THEN
          LDT_3ATM (LDT_NTORS)=DATA(1:4)
        ELSE IF(ITEM(15:23).EQ.'atom_id_4') THEN
          LDT_4ATM (LDT_NTORS)=DATA(1:4)
        ELSE IF(ITEM(15:16).EQ.'id') THEN
          LDT_LABEL(LDT_NTORS)=DATA(1:8)
        ELSE IF(ITEM(15:22).EQ.'function') THEN
          LDT_FUNCT(LDT_NTORS)=DATA(1:8)
        ENDIF
      ENDIF

      RETURN
C -----------------------------------
      END     

C ******
      SUBROUTINE PT_MDPLAN(MDOC,I,BLOCK,LENB,ITEM,LENI
     *  ,DATA,IDATA,FDATA,LEND,IERR)
C -------------------------------------------------------
C -P- PT_MDPLAN -
C -S-
C -------------------------------------------------------
C ----
      REAL      FDATA
      INTEGER*4 IDATA,MDOC,I,IERR
      INTEGER*4 LENB,LENI,LEND
      CHARACTER BLOCK*(*),DATA*(*),ITEM*(*)
C -----------------------------------------------
      INCLUDE 'lib_com.fh'
C ******
C -----------------------------------
      COMMON/STTDPLN/ DEV,ISATOM,LABEL,MNAME,FUNCT
      REAL      DEV
      INTEGER*4 ISATOM
      CHARACTER LABEL*8,MNAME*8,FUNCT*8
C ---
      INTEGER*4 IATOM
      CHARACTER LINE*256,MOD*8,ATOM*4
      EQUIVALENCE (IATOM,ATOM)
C -----------------------------------
      IERR=0
      IF(ITEM(22:27).EQ.'mod_id' ) THEN 
        IF(I.NE.1) THEN
          WRITE(LINE,'(A,A8,A)')
     *     ' ERR: item _chem_mod_plane_atom.mod_id :',DATA(1:8)
     *    ,' must be first in the string'
          CALL MSGERR(MDOC,LINE)
          LDL_IMOD = 0           
          IERR=1
          RETURN
        ENDIF
        MOD=DATA(1:8)
        IF(LDL_NMOD.LE.0) THEN
          CALL MSGERR(MDOC
     *    ,' ERR: number of modifications in the list= 0')
          IERR=1
          RETURN
        ENDIF
        IF(LDL_IMOD.EQ.0) LDL_IMOD=1
        DO J=1,LDL_NMOD
          L=(LDL_IMOD-1)+J
          IF(L.GT.LDL_NMOD) L=L-LDL_NMOD
C          IF(MOD.EQ.LDL_MNAME(L).AND.LDL_SUB_MOD(L)(1:1).EQ.'.')THEN
          IF(MOD.EQ.LDL_MNAME(L))THEN
            LDL_IMOD = L
            MNAME = DATA(1:8)
            RETURN
          ENDIF
        ENDDO
        WRITE(LINE,'(A,A8,A)')' ERR: item _chem_mod_plane_atom.mod_id :'
     *   ,MOD,' not found in the list of modifications'
        CALL MSGERR(MDOC,LINE)
        WRITE(LINE,'('' BLOCK :'',A)') BLOCK(1:LENB)
        CALL MSGERR(MDOC,LINE)
        LDL_IMOD = 0           
        IERR=1
        RETURN
      ENDIF
C COMLETENESS ????
      IF(LDL_IMOD.GT.0.AND.I.GT.1) THEN
        IF(ITEM(22:29).EQ.     'plane_id'    ) THEN
          LABEL= DATA(1:8)
        ELSE IF(ITEM(22:29).EQ.'function'    ) THEN
          FUNCT= DATA(1:8)
        ELSE IF(ITEM(22:28).EQ.'atom_id') THEN
          ATOM = DATA(1:4)
          ISATOM=IATOM
        ELSE IF(ITEM(22:33).EQ.'new_dist_esd') THEN
          DEV = FDATA
        ENDIF
      ENDIF

      IF(LDL_IMOD.GT.0.AND.I.EQ.5) THEN
        L=LDL_IMOD
        IF(LDL_IPLAN(L).LE.LDP_NPLAN) THEN
          IF(LDL_IPLAN(L).GT.0) THEN
            DO II=LDL_IPLAN(L),LDP_NPLAN
               IF(LABEL.EQ.LDP_LABEL(II)) GO TO 100
            ENDDO
          ENDIF
          LDP_NPLAN=LDP_NPLAN+1
          IF(LDP_NPLAN.GT.MAXDPLN) THEN
            WRITE(LINE,'(A,A8,A,I6,A)')
     *  ' ERR: read number of plans for mod:',MNAME,' >',MAXDPLN,
     *  ' /lib. limit/'
            CALL MSGERR(MDOC,LINE)
            CALL MSGERR(MDOC,
     *  ' Change parameter MAXMLIST in "lib_com.fh"')
            LDL_IMOD = 0           
            IERR=1
            RETURN
          ENDIF
          IF(LDL_IPLAN(L).EQ.0) LDL_IPLAN(L)=LDP_NPLAN
          II=LDP_NPLAN
          LDP_NATOM(II)=0
          LDP_MNAME(II)=MNAME
 100      CONTINUE

          LDP_NATOM(II)=LDP_NATOM(II)+1
          IF(LDP_NATOM(II).GT.MAXDAPL) THEN
            WRITE(LINE,'(A,A8,A,I6,A)')
     *      ' ERR: read number of plans atom for monomer ',MNAME,
     *      '  >',MAXDAPL,' /lib. limit/'
            CALL MSGERR(MDOC,LINE)
            CALL MSGERR(MDOC,
     *  ' Change parameter MAXMLIST in "lib_com.fh"')
            LDL_IMOD = 0           
            IERR=1
            RETURN
          ENDIF
          LDP_FUNCT(II)=FUNCT
          LDP_LABEL(II)=LABEL
          LDP_ATOM (LDP_NATOM(II),II) = ISATOM
          LDP_DEV  (LDP_NATOM(II),II) = DEV
        ENDIF
      ENDIF 
      RETURN
C -----------------------------------
      END     

C ******
      SUBROUTINE PT_MDCHIR(MDOC,I,BLOCK,LENB,ITEM,LENI
     *  ,DATA,IDATA,FDATA,LEND,IERR)
C -------------------------------------------------------
C -P- PT_MDCHIR - 
C -S-
C -------------------------------------------------------
C ----
      REAL      FDATA
      INTEGER*4 IDATA,MDOC,I,IERR
      INTEGER*4 LENB,LENI,LEND
      CHARACTER BLOCK*(*),DATA*(*),ITEM*(*)
C -----------------------------------------------
      INCLUDE 'lib_com.fh'
C ******
C -----------------------------------
      CHARACTER LINE*256,MOD*8
C -----------------------------------
      IERR=0
      IF(ITEM(16:21).EQ.'mod_id' ) THEN 
        IF(I.NE.1) THEN
          WRITE(LINE,'(A,A8,A)')' ERR: item _chem_mod_chir.mod_id :'
     *    ,DATA(1:8),' must be first in the string'
          CALL MSGERR(MDOC,LINE)
          LDL_IMOD = 0           
          IERR=1
          RETURN
        ENDIF
        MOD=DATA(1:8)
        IF(LDL_NMOD.LE.0) THEN
          CALL MSGERR(MDOC
     *    ,' ERR: number of modifications in the list= 0')
          IERR=1
          RETURN
        ENDIF
        IF(LDL_IMOD.EQ.0) LDL_IMOD=1
        DO J=1,LDL_NMOD
          L=(LDL_IMOD-1)+J
          IF(L.GT.LDL_NMOD) L=L-LDL_NMOD
C          IF(MOD.EQ.LDL_MNAME(L).AND.LDL_SUB_MOD(L)(1:1).EQ.'.')THEN
          IF(MOD.EQ.LDL_MNAME(L))THEN
            LDL_IMOD = L
            LDC_NCHIR=LDC_NCHIR+1
            IF(LDC_NCHIR.GT.MAXMCHR) THEN
              WRITE(LINE,'(A,A8,A,I6,A)')
     *        ' ERR: read number of chiralities for mod:',MOD,
     *        '  >',MAXMCHR,' /lib. limit/'
              CALL MSGERR(MDOC,LINE)
            CALL MSGERR(MDOC,
     *  ' Change parameter MAXMLIST in "lib_com.fh"')
              LDL_IMOD = 0           
              IERR=1
              RETURN
            ENDIF
            IF(LDL_ICHIR(L).EQ.0) LDL_ICHIR(L)=LDC_NCHIR 
            LDC_MNAME(LDC_NCHIR) = DATA(1:8)
            LDC_1ATM (LDC_NCHIR) = '.'
            LDC_2ATM (LDC_NCHIR) = '.'
            LDC_3ATM (LDC_NCHIR) = '.'
            LDC_4ATM (LDC_NCHIR) = '.'
            LDC_5ATM (LDC_NCHIR) = '.'
            LDC_6ATM (LDC_NCHIR) = '.'
            LDC_7ATM (LDC_NCHIR) = '.'
            LDC_8ATM (LDC_NCHIR) = '.'
            LDC_9ATM (LDC_NCHIR) = '.'
            LDC_SIGN (LDC_NCHIR) = '.'
            RETURN
          ENDIF
        ENDDO
        WRITE(LINE,'(A,A8,A)')' ERR: item _chem_mod_chir.mod_id :',MOD
     *  ,' not found in the list of modifications'
        CALL MSGERR(MDOC,LINE)
        WRITE(LINE,'('' BLOCK :'',A)') BLOCK(1:LENB)
        CALL MSGERR(MDOC,LINE)
        LDL_IMOD = 0           
        IERR=1
        RETURN
      ENDIF
C COMLETENESS ????
      IF(LDL_IMOD.GT.0.AND.I.GT.1) THEN
        IF(ITEM(16:30).EQ.'new_volume_sign'    ) THEN
          LDC_SIGN  (LDC_NCHIR)=DATA(1:8)
        ELSE IF(ITEM(16:23).EQ.'function'    ) THEN
          LDC_FUNCT (LDC_NCHIR)=DATA(1:8)
        ELSE IF(ITEM(16:29).EQ.'atom_id_centre') THEN
          LDC_1ATM (LDC_NCHIR)=DATA(1:4)
        ELSE IF(ITEM(16:24).EQ.'atom_id_1') THEN
          LDC_2ATM (LDC_NCHIR)=DATA(1:4)
        ELSE IF(ITEM(16:24).EQ.'atom_id_2') THEN
          LDC_3ATM (LDC_NCHIR)=DATA(1:4)
        ELSE IF(ITEM(16:24).EQ.'atom_id_3') THEN
          LDC_4ATM (LDC_NCHIR)=DATA(1:4)
        ELSE IF(ITEM(16:24).EQ.'atom_id_4') THEN
          LDC_5ATM (LDC_NCHIR)=DATA(1:4)
        ELSE IF(ITEM(16:24).EQ.'atom_id_5') THEN
          LDC_6ATM (LDC_NCHIR)=DATA(1:4)
        ELSE IF(ITEM(16:24).EQ.'atom_id_6') THEN
          LDC_7ATM (LDC_NCHIR)=DATA(1:4)
        ELSE IF(ITEM(16:24).EQ.'atom_id_7') THEN
          LDC_8ATM (LDC_NCHIR)=DATA(1:4)
        ELSE IF(ITEM(16:24).EQ.'atom_id_8') THEN
          LDC_9ATM (LDC_NCHIR)=DATA(1:4)
        ENDIF
      ENDIF

      RETURN
C -----------------------------------
      END     

C ******
      SUBROUTINE PUT_LNLIB(MDOC,I,BLOCK,LENB,ITEM,LENI
     *  ,DATA,IDATA,FDATA,LEND,IERR)
C -------------------------------------------------------
C -P- PUT_LNLIB - reads link's description.
C -S-
C -------------------------------------------------------
      INCLUDE 'lib_com.fh'
C ----
      REAL      FDATA
      INTEGER*4 IDATA,MDOC,I,IERR
      INTEGER*4 LENB,LENI,LEND
      CHARACTER BLOCK*(*),DATA*(*),ITEM*(*)
C -----------------------------------------------
      INCLUDE 'CIF_items_lib.fh'
C -----------------------------------------------
      IERR=0

C      DATA ITL_LNK       /'_chem_link.                             '/
C      DATA ITL_LNKB      /'_chem_link_bond.                        '/
C      DATA ITL_LNKG      /'_chem_link_angle.                       '/
C      DATA ITL_LNKT      /'_chem_link_tor.                         '/
C      DATA ITL_LNKC      /'_chem_link_chir.                        '/
C      DATA ITL_LNKP      /'_chem_link_plane.                       '/

      CALL LENSTR_BL(ITL_LNK ,LLNK)
      CALL LENSTR_BL(ITL_LNKB,LLNKB)
      CALL LENSTR_BL(ITL_LNKG,LLNKG)
      CALL LENSTR_BL(ITL_LNKT,LLNKT)
      CALL LENSTR_BL(ITL_LNKC,LLNKC)
      CALL LENSTR_BL(ITL_LNKP,LLNKP)
 
      IF(LLL_NLINK.LE.0) RETURN
      IF(ITEM(1:LLNK).EQ.ITL_LNK(1:LLNK)) THEN
C        CALL PT_LNLIST(MDOC,I,BLOCK,LENB,ITEM,LENI
C     *    ,DATA,IDATA,FDATA,LEND,IERR)
C      ELSE IF(ITEM(1:16).EQ.'_chem_link_tree.') THEN
C        CALL PT_LNCONN(MDOC,I,BLOCK,LENB,ITEM,LENI
C     *    ,DATA,IDATA,FDATA,LEND,IERR)
      ELSE IF(ITEM(1:LLNKB).EQ.ITL_LNKB(1:LLNKB)) THEN
        CALL PT_LNBOND(MDOC,I,BLOCK,LENB,ITEM,LENI
     *    ,DATA,IDATA,FDATA,LEND,IERR)
      ELSE IF(ITEM(1:LLNKG).EQ.ITL_LNKG(1:LLNKG)) THEN
        CALL PT_LNANGL(MDOC,I,BLOCK,LENB,ITEM,LENI
     *    ,DATA,IDATA,FDATA,LEND,IERR)
      ELSE IF(ITEM(1:LLNKT).EQ.ITL_LNKT(1:LLNKT)) THEN
        CALL PT_LNTORS(MDOC,I,BLOCK,LENB,ITEM,LENI
     *    ,DATA,IDATA,FDATA,LEND,IERR)
      ELSE IF(ITEM(1:LLNKC).EQ.ITL_LNKC(1:LLNKC)) THEN
        CALL PT_LNCHIR(MDOC,I,BLOCK,LENB,ITEM,LENI
     *    ,DATA,IDATA,FDATA,LEND,IERR)
      ELSE IF(ITEM(1:LLNKP).EQ.ITL_LNKP(1:LLNKP)) THEN
        CALL PT_LNPLAN(MDOC,I,BLOCK,LENB,ITEM,LENI
     *    ,DATA,IDATA,FDATA,LEND,IERR)

      ENDIF
      RETURN
C -----------------------------------
      END     

C ******
      SUBROUTINE PT_LNLIST(MDOC,I,BLOCK,LENB,ITEM,LENI
     *  ,DATA,IDATA,FDATA,LEND,IERR)
C ---------------------------------------------
C -P- PT_LNLIST - reads link's description.
C -S-
C ---------------------------------------------
      REAL      FDATA
      INTEGER*4 IDATA,MDOC,I,IERR
      INTEGER*4 LENB,LENI,LEND
      CHARACTER BLOCK*(*),DATA*(*),ITEM*(*)
C -----------------------------------------------
      INCLUDE 'lib_com.fh'
C ******
C -----------------------------------
      CHARACTER LINE*256
C -----------------------------------------------
      INCLUDE 'CIF_items_lib.fh'
C -----------------------------------------------
      IERR=0

C      DATA ITL_LNK_ID    /'_chem_link.id                           '/
C      DATA ITL_LNK_NAME  /'_chem_link.name                         '/
C      DATA ITL_LNK_COM1  /'_chem_link.comp_id_1                    '/
C      DATA ITL_LNK_MOD1  /'_chem_link.mod_id_1                     '/
C      DATA ITL_LNK_GRP1  /'_chem_link.group_comp_1                 '/
C      DATA ITL_LNK_COM2  /'_chem_link.comp_id_2                    '/
C      DATA ITL_LNK_MOD2  /'_chem_link.mod_id_2                     '/
C      DATA ITL_LNK_GRP2  /'_chem_link.group_comp_2                 '/

      CALL LENSTR_BL(ITL_LNK_ID  ,LLID)
         
      IF(ITEM(1:LLID).EQ.ITL_LNK_ID(1:LLID)) THEN 
        IF(I.NE.1) THEN
          WRITE(LINE,'(A,A8,A)')' ERR: item _chem_link.id :',DATA(1:8)
     *          ,' must be first in the string'
          CALL MSGERR(MDOC,LINE)
          LLL_IMOD = 0           
          IERR     = 1
          RETURN
        ENDIF
        LLL_NLINK = LLL_NLINK+1
        IF(LLL_NLINK.GT.MAXLLNK) THEN
          WRITE(LINE,'(A,I6,A)')' ERR: number of links >',MAXLLNK,
     *    ' /lib. limit/'
          CALL MSGERR(MDOC,LINE)
            CALL MSGERR(MDOC,
     *  ' Change parameter MAXMLIST in "lib_com.fh"')
          LLL_NLINK = 0
          IERR      = 1
          RETURN
        ENDIF
        LLL_ILINK                 = LLL_NLINK
        LLL_LNAME(LLL_ILINK)(1:8) = DATA(1:8)
        LLL_FUSE (LLL_ILINK)      = 'N'
        IF(LB_PASS.GT.LB_NUMB_LIB)  LLL_FUSE(LLL_ILINK) = 'C'
        RETURN
      ENDIF
C COMLETENESS ????
      CALL LENSTR_BL(ITL_LNK_NAME,LLNM)
      CALL LENSTR_BL(ITL_LNK_COM1,LLC1)
      CALL LENSTR_BL(ITL_LNK_MOD1,LLM1)
      CALL LENSTR_BL(ITL_LNK_GRP1,LLG1)
      CALL LENSTR_BL(ITL_LNK_COM2,LLC2)
      CALL LENSTR_BL(ITL_LNK_MOD2,LLM2)
      CALL LENSTR_BL(ITL_LNK_GRP2,LLG2)
      IF(LLL_ILINK.GT.0.AND.I.GT.1) THEN
        IF(ITEM(12:26).EQ.'one_letter_code'  ) THEN
          LLL_CODE1  (LLL_ILINK)=DATA(1:1)
        ELSE IF(ITEM(1:LLNM).EQ.ITL_LNK_NAME(1:LLNM)) THEN
          LLL_DETAIL (LLL_ILINK)=DATA(1:LEND)
        ELSE IF(ITEM(1:LLC1).EQ.ITL_LNK_COM1(1:LLC1)) THEN
          LLL_MON1   (LLL_ILINK)=DATA(1:LEND)
        ELSE IF(ITEM(1:LLC2).EQ.ITL_LNK_COM2(1:LLC2)) THEN
          LLL_MON2   (LLL_ILINK)=DATA(1:LEND)
        ELSE IF(ITEM(1:LLM1).EQ.ITL_LNK_MOD1(1:LLM1)) THEN
          LLL_MOD1   (LLL_ILINK)=DATA(1:LEND)
        ELSE IF(ITEM(1:LLM2).EQ.ITL_LNK_MOD2(1:LLM2)) THEN
          LLL_MOD2   (LLL_ILINK)=DATA(1:LEND)
        ELSE IF(ITEM(1:LLG1).EQ.ITL_LNK_GRP1(1:LLG1)) THEN
          LLL_TYPE1  (LLL_ILINK)=DATA(1:LEND)
        ELSE IF(ITEM(1:LLG2).EQ.ITL_LNK_GRP2(1:LLG2)) THEN
          LLL_TYPE2  (LLL_ILINK)=DATA(1:LEND)
        ENDIF
      ENDIF
      RETURN
C -----------------------------------
      END     

C ******
      SUBROUTINE PT_LNCONN(MDOC,I,BLOCK,LENB,ITEM,LENI
     *  ,DATA,IDATA,FDATA,LEND,IERR)
C -------------------------------------------------------
C -P- PT_LNCONN -
C -S-
C -------------------------------------------------------
C ----
      REAL      FDATA
      INTEGER*4 IDATA,MDOC,I,IERR
      INTEGER*4 LENB,LENI,LEND
      CHARACTER BLOCK*(*),DATA*(*),ITEM*(*)
C -----------------------------------------------
      INCLUDE 'lib_com.fh'
C ******
C -----------------------------------
      CHARACTER LINE*256,LINK*8
C -----------------------------------
      IERR = 0
      IF(ITEM(17:23).EQ.'link_id' ) THEN 
        IF(I.NE.1) THEN
          WRITE(LINE,'(A,A8,A)')' ERR: item _chem_link_tree.link_id :'
     *    ,DATA(1:8),' must be first in the string'
          CALL MSGERR(MDOC,LINE)
          LLL_ILINK = 0           
          IERR      = 1
          RETURN
        ENDIF
        LINK = DATA(1:8)
        IF(LLL_NLINK.LE.0) THEN
          CALL MSGERR(MDOC
     *    ,' ERR: number of links in the list = 0')
          LLL_ILINK = 0           
          IERR      = 1
          RETURN
        ENDIF
        IF(LLL_ILINK.EQ.0) LLL_ILINK=1
        DO J=1,LLL_NLINK
          L=(LLL_ILINK-1)+J
          IF(L.GT.LLL_NLINK) L=L-LLL_NLINK
          IF(LINK.EQ.LLL_LNAME(L)) THEN
            LLL_ILINK = L
            LLN_NCONN = LLN_NCONN+1
            IF(LLN_NCONN.GT.MAXLCNN) THEN
              WRITE(LINE,'(A,A8,A,I6,A)')
     *        ' ERR: read number of connections for link:'
     *        ,LINK,'  >',MAXLCNN,' /lib. limit/'
              CALL MSGERR(MDOC,LINE)
            CALL MSGERR(MDOC,
     *  ' Change parameter MAXMLIST in "lib_com.fh"')
              LLL_ILINK = 0           
              IERR      = 1
              RETURN
            ENDIF
            IF(LLL_ICONN(L).EQ.0) LLL_ICONN(L)=LLN_NCONN 
            LLN_LNAME(LLN_NCONN) = LINK
            LLN_ATOM (LLN_NCONN) = '.'
            LLN_FATOM(LLN_NCONN) = 0
            LLN_BACK (LLN_NCONN) = '.'
            LLN_FBACK(LLN_NCONN) = 0
            LLN_BTYPE(LLN_NCONN) = '.'
            LLN_FORW (LLN_NCONN) = '.'
            LLN_FFORW(LLN_NCONN) = 0
            LLN_1ATM (LLN_NCONN) = '.'
            LLN_F1ATM(LLN_NCONN) = 0
            LLN_TYPE (LLN_NCONN) = '.'
            LLN_2ATM (LLN_NCONN) = '.'
            LLN_F2ATM(LLN_NCONN) = 0
            RETURN
          ENDIF
        ENDDO
        WRITE(LINE,'(A,A8,A)')' ERR: item _chem_link_tree.link_id :'
     *     ,LINK,' not found in the list of links'
        CALL MSGERR(MDOC,LINE)
        WRITE(LINE,'('' BLOCK :'',A)') BLOCK(1:LENB)
        CALL MSGERR(MDOC,LINE)
        LLL_ILINK = 0           
        IERR      = 1
        RETURN
      ENDIF

C COMLETENESS ????
      IF(LLL_ILINK.GT.0.AND.I.GT.1) THEN
        IF(ITEM(17:29).EQ.'_atom_comp_id'  ) THEN
          LLN_FATOM(LLN_NCONN)=IDATA
        ELSE IF(ITEM(17:23).EQ.'atom_id' ) THEN 
          LLN_ATOM(LLN_NCONN)=DATA(1:4)
        ELSE IF(ITEM(17:33).EQ.'atom_back_comp_id'  ) THEN
          LLN_FBACK(LLN_NCONN)=IDATA
        ELSE IF(ITEM(17:25).EQ.'atom_back'  ) THEN
          IF(DATA(1:3).EQ.'n/a') DATA(1:4) = '.   '
          LLN_BACK(LLN_NCONN)=DATA(1:4)
        ELSE IF(ITEM(17:25).EQ.'back_type'  ) THEN
          LLN_BTYPE(LLN_NCONN)=DATA(1:8)
        ELSE IF(ITEM(17:36).EQ.'atom_forward_comp_id'  ) THEN
          LLN_FFORW(LLN_NCONN)=IDATA
        ELSE IF(ITEM(17:28).EQ.'atom_forward'  ) THEN
          IF(DATA(1:3).EQ.'n/a') DATA(1:4) = '.   '
          LLN_FORW(LLN_NCONN)=DATA(1:4)
        ELSE IF(ITEM(17:28).EQ.'connect_type'  ) THEN
          LLN_TYPE(LLN_NCONN)=DATA(1:8)
        ENDIF

c        ELSE IF(ITEM(28:49).EQ.'connect_atom_comp_id_1'  ) THEN
c          LLN_F1ATM(LLN_NCONN)=IDATA
c        ELSE IF(ITEM(28:44).EQ.'connect_atom_id_1'  ) THEN
c          LLN_1ATM(LLN_NCONN)=DATA(1:4)
c        ELSE IF(ITEM(28:39).EQ.'connect_type'  ) THEN
c          LLN_TYPE(LLN_NCONN)=DATA(1:8)
c        ELSE IF(ITEM(28:49).EQ.'connect_atom_comp_id_2'  ) THEN
c          LLN_F2ATM(LLN_NCONN)=IDATA
c        ELSE IF(ITEM(28:44).EQ.'connect_atom_id_2'  ) THEN
c          LLN_2ATM(LLN_NCONN)=DATA(1:4)
c        ENDIF

      ENDIF
      RETURN
C -----------------------------------
      END     

C ******
      SUBROUTINE PT_LNBOND(MDOC,I,BLOCK,LENB,ITEM,LENI
     *  ,DATA,IDATA,FDATA,LEND,IERR)
C -------------------------------------------------------
C -P- PT_LNBOND -
C -S-
C -------------------------------------------------------
C ----
      REAL      FDATA
      INTEGER*4 IDATA,MDOC,I,IERR
      INTEGER*4 LENB,LENI,LEND
      CHARACTER BLOCK*(*),DATA*(*),ITEM*(*)
C -----------------------------------------------
      INCLUDE 'lib_com.fh'
C ******
C -----------------------------------
      CHARACTER LINE*256,LINK*8
C -----------------------------------
      IERR=0
      IF(ITEM(17:23).EQ.'link_id' ) THEN 
        IF(I.NE.1) THEN
          WRITE(LINE,'(A,A8,A)')' ERR: item _chem_link_bond.link_id :'
     *    ,DATA(1:8),' must be first in the string'
          CALL MSGERR(MDOC,LINE)
          LLL_ILINK = 0           
          IERR=1
          RETURN
        ENDIF
        LINK=DATA(1:8)
        IF(LLL_NLINK.LE.0) THEN
          CALL MSGERR(MDOC
     *    ,' ERR: number of links in the list= 0')
          IERR=1
          RETURN
        ENDIF
        IF(LLL_ILINK.EQ.0) LLL_ILINK=1
        DO J=1,LLL_NLINK
          L=(LLL_ILINK-1)+J
          IF(L.GT.LLL_NLINK) L=L-LLL_NLINK
          IF(LINK.EQ.LLL_LNAME(L)) THEN
            LLL_ILINK = L
            LLB_NBOND=LLB_NBOND+1
            IF(LLB_NBOND.GT.MAXLBND) THEN
              WRITE(LINE,'(A,A8,A,I6,A)')
     *      ' ERR: read number of bonds for link:',LINK,' >',MAXLBND
     *        ,' /lib. limit/'
              CALL MSGERR(MDOC,LINE)
            CALL MSGERR(MDOC,
     *  ' Change parameter MAXMLIST in "lib_com.fh"')
              LLL_ILINK = 0           
              IERR=1
              RETURN
            ENDIF
            IF(LLL_IBOND(L).EQ.0) LLL_IBOND(L)=LLB_NBOND 
            LLB_LNAME(LLB_NBOND) = DATA(1:8)
            RETURN
          ENDIF
        ENDDO   
        WRITE(LINE,'(A,A8,A)')' ERR: item _chem_link_bond.link_id :'
     *    ,LINK,' not found in the list of links'
        CALL MSGERR(MDOC,LINE)
        WRITE(LINE,'('' BLOCK :'',A)') BLOCK(1:LENB)
        CALL MSGERR(MDOC,LINE)
        LLL_ILINK = 0           
        IERR=1
        RETURN
      ENDIF
C COMLETENESS ????
      IF(LLL_ILINK.GT.0.AND.I.GT.1) THEN
        IF(ITEM(17:30).EQ.'atom_1_comp_id'  ) THEN
          LLB_F1ATM (LLB_NBOND)=IDATA
        ELSE IF(ITEM(17:25).EQ.'atom_id_1'  ) THEN
          LLB_1ATM (LLB_NBOND)=DATA(1:4)
        ELSE IF(ITEM(17:30).EQ.'atom_2_comp_id'  ) THEN
          LLB_F2ATM (LLB_NBOND)=IDATA
        ELSE IF(ITEM(17:25).EQ.'atom_id_2'  ) THEN
          LLB_2ATM (LLB_NBOND)=DATA(1:4)
        ELSE IF(ITEM(17:20).EQ.'type') THEN
          LLB_TYPE (LLB_NBOND)=DATA(1:8)
        ELSE IF(ITEM(17:30).EQ.'value_dist_esd') THEN
          LLB_DEV  (LLB_NBOND)=FDATA
        ELSE IF(ITEM(17:26).EQ.'value_dist') THEN
          LLB_VAL  (LLB_NBOND)=FDATA
        ENDIF
      ENDIF

      RETURN
C -----------------------------------
      END     
C ******

      SUBROUTINE PT_LNANGL(MDOC,I,BLOCK,LENB,ITEM,LENI
     *  ,DATA,IDATA,FDATA,LEND,IERR)
C -------------------------------------------------------
C -P- PT_LNANGL - 
C -S-
C -------------------------------------------------------
C ----
      REAL      FDATA
      INTEGER*4 IDATA,MDOC,I,IERR
      INTEGER*4 LENB,LENI,LEND
      CHARACTER BLOCK*(*),DATA*(*),ITEM*(*)
C -----------------------------------------------
      INCLUDE 'lib_com.fh'
C ******
C -----------------------------------
      CHARACTER LINE*256,LINK*8
C -----------------------------------
      IERR=0
      IF(ITEM(18:24).EQ.'link_id' ) THEN 
        IF(I.NE.1) THEN
          WRITE(LINE,'(A,A8,A)')' ERR: item _chem_link_angle.link_id :'
     *    ,DATA(1:8),' must be first in the string'
          CALL MSGERR(MDOC,LINE)
          LLL_ILINK = 0           
          IERR=1
          RETURN
        ENDIF
        LINK=DATA(1:8)
        IF(LLL_NLINK.LE.0) THEN
          CALL MSGERR(MDOC
     *    ,' ERR: number of links in the list= 0')
          IERR=1
          RETURN
        ENDIF
        IF(LLL_ILINK.EQ.0) LLL_ILINK=1
        DO J=1,LLL_NLINK
          L=(LLL_ILINK-1)+J
          IF(L.GT.LLL_NLINK) L=L-LLL_NLINK
          IF(LINK.EQ.LLL_LNAME(L)) THEN
            LLL_ILINK = L
            LLG_NANGL=LLG_NANGL+1
            IF(LLG_NANGL.GT.MAXLANG) THEN
              WRITE(LINE,'(A,A8,A,I6,A)')
     *      ' ERR: read number of angles for link:',LINK,' >',MAXLANG
     *        ,' /lib. limit/'
              CALL MSGERR(MDOC,LINE)
            CALL MSGERR(MDOC,
     *  ' Change parameter MAXMLIST in "lib_com.fh"')
              LLL_ILINK = 0           
              IERR=1
              RETURN
            ENDIF
            IF(LLL_ITHET(L).EQ.0) LLL_ITHET(L)=LLG_NANGL 
            LLG_LNAME(LLG_NANGL) = DATA(1:8)
            RETURN
          ENDIF
        ENDDO
        WRITE(LINE,'(A,A8,A)')' ERR: item _chem_link_angle.link_id :'
     *   ,LINK,' not found in the list of links'
        CALL MSGERR(MDOC,LINE)
        WRITE(LINE,'('' BLOCK :'',A)') BLOCK(1:LENB)
        CALL MSGERR(MDOC,LINE)
        LLL_ILINK = 0           
        IERR=1
        RETURN
      ENDIF
C COMLETENESS ????
      IF(LLL_ILINK.GT.0.AND.I.GT.1) THEN
        IF(ITEM(18:26)     .EQ.'atom_id_1'  ) THEN
          LLG_1ATM (LLG_NANGL)=DATA(1:4)
        ELSE IF(ITEM(18:31).EQ.'atom_1_comp_id'  ) THEN
          LLG_F1ATM (LLG_NANGL)=IDATA
        ELSE IF(ITEM(18:26).EQ.'atom_id_2'  ) THEN
          LLG_2ATM (LLG_NANGL)=DATA(1:4)
        ELSE IF(ITEM(18:31).EQ.'atom_2_comp_id'  ) THEN
          LLG_F2ATM (LLG_NANGL)=IDATA
        ELSE IF(ITEM(18:26).EQ.'atom_id_3'  ) THEN
          LLG_3ATM (LLG_NANGL)=DATA(1:4)
        ELSE IF(ITEM(18:31).EQ.'atom_3_comp_id'  ) THEN
          LLG_F3ATM (LLG_NANGL)=IDATA
        ELSE IF(ITEM(18:32).EQ.'value_angle_esd') THEN
          LLG_DEV  (LLG_NANGL)=FDATA
        ELSE IF(ITEM(18:28).EQ.'value_angle') THEN
          LLG_VAL  (LLG_NANGL)=FDATA
        ENDIF
      ENDIF

      RETURN
C -----------------------------------
      END     

C ******
      SUBROUTINE PT_LNTORS(MDOC,I,BLOCK,LENB,ITEM,LENI
     *  ,DATA,IDATA,FDATA,LEND,IERR)
C -------------------------------------------------------
C -P- PT_LNTORS - 
C -S-
C -------------------------------------------------------
C ----
      REAL      FDATA
      INTEGER*4 IDATA,MDOC,I,IERR
      INTEGER*4 LENB,LENI,LEND
      CHARACTER BLOCK*(*),DATA*(*),ITEM*(*)
C -----------------------------------------------
      INCLUDE 'lib_com.fh'
C ******
C -----------------------------------
      CHARACTER LINE*256,LINK*8
C -----------------------------------
      IERR=0
      IF(ITEM(16:23).EQ.'link_id' ) THEN 
        IF(I.NE.1) THEN
          WRITE(LINE,'(A,A8,A)')' ERR: item _chem_link_tor.link_id :'
     *    ,DATA(1:8),' must be first in the string'
          CALL MSGERR(MDOC,LINE)
          LLL_ILINK = 0           
          IERR=1
          RETURN
        ENDIF
        LINK=DATA(1:8)
        IF(LLL_NLINK.LE.0) THEN
          CALL MSGERR(MDOC
     *    ,' ERR: number of links in the list= 0')
          IERR=1
          RETURN
        ENDIF
        IF(LLL_ILINK.EQ.0) LLL_ILINK=1
        DO J=1,LLL_NLINK
          L=(LLL_ILINK-1)+J
          IF(L.GT.LLL_NLINK) L=L-LLL_NLINK
          IF(LINK.EQ.LLL_LNAME(L)) THEN
            LLL_ILINK = L
            LLT_NTORS=LLT_NTORS+1
            IF(LLT_NTORS.GT.MAXLTOR) THEN
              WRITE(LINE,'(A,A8,A,I6,A)')
     *      ' ERR: read number of tors for link:',LINK,' >',MAXLTOR
     *        ,' /lib. limit/'
              CALL MSGERR(MDOC,LINE)
            CALL MSGERR(MDOC,
     *  ' Change parameter MAXMLIST in "lib_com.fh"')
              LLL_ILINK = 0           
              IERR=1
              RETURN
            ENDIF
            IF(LLL_ITORS(L).EQ.0) LLL_ITORS(L)=LLT_NTORS 
            LLT_LNAME(LLT_NTORS) = DATA(1:8)
            RETURN
          ENDIF
        ENDDO
        WRITE(LINE,'(A,A8,A)')' ERR: item _chem_link_tor.link_id :',LINK
     *  ,' not found in the list of links'
        CALL MSGERR(MDOC,LINE)
        WRITE(LINE,'('' BLOCK :'',A)') BLOCK(1:LENB)
        CALL MSGERR(MDOC,LINE)
        LLL_ILINK = 0           
        IERR=1
        RETURN
      ENDIF
C COMLETENESS ????
      IF(LLL_ILINK.GT.0.AND.I.GT.1) THEN
        IF(ITEM(16:30).EQ.'value_angle_esd' ) THEN
          LLT_DEV  (LLT_NTORS)=FDATA
        ELSE IF(ITEM(16:26).EQ.'value_angle') THEN
          LLT_VAL  (LLT_NTORS)=FDATA
        ELSE IF(ITEM(16:21).EQ.'period') THEN
          LLT_PRD  (LLT_NTORS)=IDATA
        ELSE IF(ITEM(16:24).EQ.'atom_id_1') THEN
          LLT_1ATM (LLT_NTORS)=DATA(1:4)
        ELSE IF(ITEM(16:29).EQ.'atom_1_comp_id') THEN
          LLT_F1ATM (LLT_NTORS)=IDATA
        ELSE IF(ITEM(16:24).EQ.'atom_id_2') THEN
          LLT_2ATM (LLT_NTORS)=DATA(1:4)
        ELSE IF(ITEM(16:29).EQ.'atom_2_comp_id') THEN
          LLT_F2ATM (LLT_NTORS)=IDATA
        ELSE IF(ITEM(16:24).EQ.'atom_id_3') THEN
          LLT_3ATM (LLT_NTORS)=DATA(1:4)
        ELSE IF(ITEM(16:29).EQ.'atom_3_comp_id') THEN
          LLT_F3ATM (LLT_NTORS)=IDATA
        ELSE IF(ITEM(16:24).EQ.'atom_id_4') THEN
          LLT_4ATM (LLT_NTORS)=DATA(1:4)
        ELSE IF(ITEM(16:29).EQ.'atom_4_comp_id') THEN
          LLT_F4ATM (LLT_NTORS)=IDATA
        ELSE IF(ITEM(16:17).EQ.'id') THEN
          LLT_LABEL(LLT_NTORS)=DATA(1:8)
        ENDIF
      ENDIF

      RETURN
C -----------------------------------
      END     

C ******
      SUBROUTINE PT_LNPLAN(MDOC,I,BLOCK,LENB,ITEM,LENI
     *  ,DATA,IDATA,FDATA,LEND,IERR)
C -------------------------------------------------------
C -P- PT_LNPLAN -
C -S-
C -------------------------------------------------------
C ----
      REAL      FDATA
      INTEGER*4 IDATA,MDOC,I,IERR
      INTEGER*4 LENB,LENI,LEND
      CHARACTER BLOCK*(*),DATA*(*),ITEM*(*)
C -----------------------------------------------
      INCLUDE 'lib_com.fh'
C ******
C -----------------------------------
      COMMON/STTLPLN/ DEV,ISATOM,LABEL,LNAME,FLAG
      REAL      DEV
      INTEGER*4 ISATOM,FLAG
      CHARACTER LABEL*8,LNAME*8
C ---
      INTEGER*4 IATOM
      CHARACTER LINE*256,LINK*8,ATOM*4
      EQUIVALENCE (IATOM,ATOM)
C -----------------------------------
      IERR = 0
      IF(ITEM(18:24).EQ.'link_id' ) THEN 
        IF(I.NE.1) THEN
        WRITE(LINE,'(A,A8,A)')' ERR: item _chem_link_plane.link_id :'
     *    ,DATA(1:8),' must be first in the string'
          CALL MSGERR(MDOC,LINE)
          LLL_ILINK = 0           
          IERR      = 1
          RETURN
        ENDIF
        LINK = DATA(1:8)
        IF(LLL_NLINK.LE.0) THEN
          CALL MSGERR(MDOC
     *    ,' ERR: number of links in the list= 0')
          IERR = 1
          RETURN
        ENDIF
        IF(LLL_ILINK.EQ.0) LLL_ILINK = 1
        DO J=1,LLL_NLINK
          L = (LLL_ILINK-1)+J
          IF(L.GT.LLL_NLINK) L = L-LLL_NLINK
          IF(LINK.EQ.LLL_LNAME(L)) THEN
            LLL_ILINK = L
            LNAME     = DATA(1:8)
            RETURN
          ENDIF
        ENDDO
      WRITE(LINE,'(A,A8,A)')' ERR: item _chem_link_plane.link_id :'
     *   ,LINK,' not found in the list of links'
        CALL MSGERR(MDOC,LINE)
        WRITE(LINE,'('' BLOCK :'',A)') BLOCK(1:LENB)
        CALL MSGERR(MDOC,LINE)
        LLL_ILINK = 0           
        IERR      = 1
        RETURN
      ENDIF
C COMLETENESS ????
      IF(LLL_ILINK.GT.0.AND.I.GT.1) THEN
        IF(ITEM(18:25).EQ.     'plane_id'    ) THEN
          LABEL  = DATA(1:8)
        ELSE IF(ITEM(18:29).EQ.'atom_comp_id') THEN
          FLAG   = IDATA
        ELSE IF(ITEM(18:24).EQ.'atom_id') THEN
          ATOM   = DATA(1:4)
          ISATOM = IATOM
        ELSE IF(ITEM(18:25).EQ.'dist_esd') THEN
          DEV    = FDATA
        ENDIF
      ENDIF

      IF(LLL_ILINK.GT.0.AND.I.EQ.5) THEN
        L = LLL_ILINK
        IF(LLL_IPLAN(L).LE.LLP_NPLAN) THEN
          IF(LLL_IPLAN(L).GT.0) THEN
            DO II=LLL_IPLAN(L),LLP_NPLAN
               IF(LABEL.EQ.LLP_LABEL(II)) GO TO 100
            ENDDO
          ENDIF
          LLP_NPLAN = LLP_NPLAN+1
          IF(LLP_NPLAN.GT.MAXLPLN) THEN
            WRITE(LINE,'(A,A8,A,I6,A)')
     *      ' ERR: read number of plans for link:',LNAME,' >',
     *      MAXLPLN,' /lib. limit/'
            CALL MSGERR(MDOC,LINE)
            CALL MSGERR(MDOC,
     *  ' Change parameter MAXMLIST in "lib_com.fh"')
            LLL_ILINK = 0           
            IERR      = 1
            RETURN
          ENDIF
          IF(LLL_IPLAN(L).EQ.0) LLL_IPLAN(L) = LLP_NPLAN
          II            = LLP_NPLAN
          LLP_NATOM(II) = 0
          LLP_LNAME(II) = LNAME
 100      CONTINUE

          LLP_NATOM(II) = LLP_NATOM(II)+1
          IF(LLP_NATOM(II).GT.MAXLAPL) THEN
            WRITE(LINE,'(A,A8,A,I6,A)')
     *      ' ERR: read number of plans atom for link: '
     *      ,LNAME,'  >',MAXLAPL,' /lib. limit/'
            CALL MSGERR(MDOC,LINE)
            CALL MSGERR(MDOC,
     *  ' Change parameter MAXMLIST in "lib_com.fh"')
            LLL_ILINK = 0           
            IERR      = 1
            RETURN
          ENDIF
          LLP_LABEL(II)               = LABEL
          LLP_FATOM(LLP_NATOM(II),II) = FLAG
          LLP_ATOM (LLP_NATOM(II),II) = ISATOM
          LLP_DEV  (LLP_NATOM(II),II) = DEV
        ENDIF
      ENDIF 
      RETURN
C -----------------------------------
      END     

C ******
      SUBROUTINE PT_LNCHIR(MDOC,I,BLOCK,LENB,ITEM,LENI
     *  ,DATA,IDATA,FDATA,LEND,IERR)
C -------------------------------------------------------
C -P- PT_LNCHIR - 
C -S-
C -------------------------------------------------------
C ----
      REAL      FDATA
      INTEGER*4 IDATA,MDOC,I,IERR
      INTEGER*4 LENB,LENI,LEND
      CHARACTER BLOCK*(*),DATA*(*),ITEM*(*)
C -----------------------------------------------
      INCLUDE 'lib_com.fh'
C ******
C -----------------------------------
      CHARACTER LINE*256,LINK*8
C -----------------------------------
      IERR=0  
      IF(ITEM(17:23).EQ.'link_id' ) THEN 
        IF(I.NE.1) THEN
          WRITE(LINE,'(A,A8,A)')' ERR: item _chem_link_chir.link_id :'
     *    ,DATA(1:8),' must be first in the string'
          CALL MSGERR(MDOC,LINE)
          LLL_ILINK = 0           
          IERR=1
          RETURN
        ENDIF
        LINK=DATA(1:8)
        IF(LLL_NLINK.LE.0) THEN
          CALL MSGERR(MDOC
     *    ,' ERR: number of links in the list= 0')
          IERR=1
          RETURN
        ENDIF
        IF(LLL_ILINK.EQ.0) LLL_ILINK=1
        DO J=1,LLL_NLINK
          L=(LLL_ILINK-1)+J
          IF(L.GT.LLL_NLINK) L=L-LLL_NLINK
          IF(LINK.EQ.LLL_LNAME(L)) THEN
            LLL_ILINK = L
            LLC_NCHIR=LLC_NCHIR+1
            IF(LLC_NCHIR.GT.MAXLCHR) THEN
              WRITE(LINE,'(A,A8,A,I6,A)')
     *        ' ERR: read number of chiralities for link:'
     *        ,LINK,'  >',MAXLCHR,' /lib. limit/'
              CALL MSGERR(MDOC,LINE)
            CALL MSGERR(MDOC,
     *  ' Change parameter MAXMLIST in "lib_com.fh"')
              LLL_ILINK = 0           
              IERR=1
              RETURN
            ENDIF
            IF(LLL_ICHIR(L).EQ.0) LLL_ICHIR(L)=LLC_NCHIR 
            LLC_LNAME(LLC_NCHIR) = DATA(1:8)
            RETURN
          ENDIF
        ENDDO
        WRITE(LINE,'(A,A8,A)')' ERR: item _chem_link_chir.link_id :'
     *  ,LINK,' not found in the list of links'
        CALL MSGERR(MDOC,LINE)
        WRITE(LINE,'('' BLOCK :'',A)') BLOCK(1:LENB)
        CALL MSGERR(MDOC,LINE)
        LLL_ILINK = 0           
        IERR=1
        RETURN
      ENDIF
C COMLETENESS ????
      IF(LLL_ILINK.GT.0.AND.I.GT.1) THEN
        IF(ITEM(17:27).EQ.'volume_sign'    ) THEN
          LLC_SIGN  (LLC_NCHIR)=DATA(1:8)
        ELSE IF(ITEM(17:30).EQ.'atom_id_centre') THEN
          LLC_1ATM (LLC_NCHIR)=DATA(1:4)
        ELSE IF(ITEM(17:35).EQ.'atom_centre_comp_id') THEN
          LLC_F1ATM (LLC_NCHIR)=IDATA
        ELSE IF(ITEM(17:25).EQ.'atom_id_1') THEN
          LLC_2ATM (LLC_NCHIR)=DATA(1:4)
        ELSE IF(ITEM(17:30).EQ.'atom_1_comp_id') THEN
          LLC_F2ATM (LLC_NCHIR)=IDATA
        ELSE IF(ITEM(17:25).EQ.'atom_id_2') THEN
          LLC_3ATM (LLC_NCHIR)=DATA(1:4)
        ELSE IF(ITEM(17:30).EQ.'atom_2_comp_id') THEN
          LLC_F3ATM (LLC_NCHIR)=IDATA
        ELSE IF(ITEM(17:25).EQ.'atom_id_3') THEN
          LLC_4ATM (LLC_NCHIR)=DATA(1:4)
        ELSE IF(ITEM(17:30).EQ.'atom_3_comp_id') THEN
          LLC_F4ATM (LLC_NCHIR)=IDATA
        ENDIF
      ENDIF

      RETURN
C -----------------------------------
      END     


         SUBROUTINE COPYMD(MDOC,IMOD,IERR)
         RETURN
         END
         SUBROUTINE CHKMOD(MDOC,ML_ID,JERR)
         RETURN
         END
         SUBROUTINE CHKLNK(MDOC,LN_ID,JERR)
         RETURN
         END
         SUBROUTINE COPYLN(MDOC,ILINK,IERR)
         RETURN
         END 

C ******
      SUBROUTINE RD_ENRLIB(MDOC,MODE,IERR)
C -------------------------------------------------------
C -P- RD_ENLIB - reads library of energy parameters
C -S-
C -------------------------------------------------------
      INTEGER*4 MDOC,IERR
      CHARACTER MODE*4
C -----------------------------------------------
      INCLUDE 'lib_com.fh'
C ******
      INCLUDE 'crd_com.fh'
C ----------------------------------
      PARAMETER ( NWORDSMAX = 60 )
      COMMON /COMCIF_INFO/ N_CIF,I_CIF,FDT_CIF,IDT_CIF
     *               ,N_DATA,N_ITEM
     *               ,DT_CIF,ITM_CIF,BLK_CIF,LOOP_FLAG,BLK_FLAG
      REAL      FDT_CIF(NWORDSMAX)
      INTEGER*4 IDT_CIF(NWORDSMAX)
      INTEGER*4 N_DATA   
      INTEGER*4 N_ITEM  
      INTEGER*4 N_CIF   
      INTEGER*4 I_CIF
      CHARACTER DT_CIF (NWORDSMAX)*80
      CHARACTER ITM_CIF(NWORDSMAX)*80
      CHARACTER BLK_CIF*80
      CHARACTER LOOP_FLAG*1,BLK_FLAG*1
C ---
      COMMON/COM_CRD_CIF/ IEND_CIF      
C ---
C -----------------------------------
      REAL      FDATA
      INTEGER*4 IDATA,IUN,M,IEND
      CHARACTER DATA*80,ITEM*80
C -----------------------------------
      IERR = 0
      IEND = 0

      IF(MODE.EQ.'ALL ') LEA_NATOM = 0
      LEB_NBOND  = 0
      LEG_NANGL  = 0
      LET_NTORS  = 0
      LEW_NCONT  = 0
      LEH_NHBOND = 0
      LES_NSYN   = 0

C ------
C     open file of mon_library
C     IUN = 10
      IUN = CRI_IUN
      M   = 99
      CALL OPENFR(IUN,M,LEI_PATH,LEI_FILE,LEI_EXT,IERR)
      IF(IERR.NE.0) THEN
        CALL MSGERR(MDOC,' ERROR: can''t open "ener_lib.cif"')
        RETURN
      ENDIF
      LEI_IUN = IUN
      IEND    =-1
C -------
      IF(IEND.EQ.-1) THEN
        REWIND IUN
        IEND_CIF =-1
        IEND     = 0
      ENDIF

  300 CONTINUE   
      CALL GETCIF_INFO(IUN,MDOC,IERR,IEND_CIF)
      IF(IERR.NE.0.OR.(IEND_CIF.NE.0.AND.IEND_CIF.NE.-2)) THEN
        CLOSE(IUN,ERR=410)
 410    CONTINUE
        LEI_IUN = 0
        IEND    = 1
        RETURN
      ENDIF
      IF(IEND_CIF.EQ.-2) THEN
C
C       This string / DT_CIF (NWORDSMAX) / is a comment
C   
        GO TO 300
      ENDIF
       
      IF(N_CIF.LE.0) GO TO 300

      DO I=1,N_CIF
        CALL LENSTR_BL(ITM_CIF(I),LENI) 
        ITEM  = ITM_CIF(I)(1:LENI)
        CALL LENSTR_BL(DT_CIF(I),LEND) 
        DATA  = DT_CIF(I)(1:LEND)
        CALL LENSTR_BL(BLK_CIF,LENB) 
        IDATA = IDT_CIF(I)
        FDATA = FDT_CIF(I)

        IF(BLK_CIF(1:7) .EQ.'global_') THEN         

        ELSE IF(ITEM(1:5).EQ.'_lib_') THEN
          CALL PUT_ENLIB(MDOC,MODE,I,BLK_CIF,LENB,ITEM,LENI
     *    ,DATA,IDATA,FDATA,LEND,IERR)
          IF(IERR.NE.0) THEN
            CLOSE(IUN,ERR=400)
 400        CONTINUE
            LEI_IUN = 0
            RETURN
          ENDIF
        ENDIF
      ENDDO
      GO TO 300
C -----------------------------------
      END     

C ******
      SUBROUTINE PUT_ENLIB(MDOC,MODE,I,BLOCK,LENB,ITEM,LENI
     *  ,DATA,IDATA,FDATA,LEND,IERR)
C -------------------------------------------------------
C -P- PUT_ENLIB - reads energy library.
C -S-
C -------------------------------------------------------
C ----
      REAL      FDATA
      INTEGER*4 IDATA,MDOC,I,IERR
      INTEGER*4 LENB,LENI,LEND
      CHARACTER BLOCK*(*),DATA*(*),ITEM*(*),MODE*4
C ******
C -----------------------------------------------
      IERR=0
      IF(ITEM(1:9).EQ.'_lib_atom') THEN
        CALL PT_EATOM(MDOC,MODE,I,BLOCK,LENB,ITEM,LENI
     *    ,DATA,IDATA,FDATA,LEND,IERR)
      ELSE IF(ITEM(1:9).EQ.'_lib_bond') THEN
        CALL PT_EBOND(MDOC,I,BLOCK,LENB,ITEM,LENI
     *    ,DATA,IDATA,FDATA,LEND,IERR)
      ELSE IF(ITEM(1:9).EQ.'_lib_angl') THEN
        CALL PT_EANGL(MDOC,I,BLOCK,LENB,ITEM,LENI
     *    ,DATA,IDATA,FDATA,LEND,IERR)
      ELSE IF(ITEM(1:9).EQ.'_lib_tors') THEN
        CALL PT_ETORS(MDOC,I,BLOCK,LENB,ITEM,LENI
     *    ,DATA,IDATA,FDATA,LEND,IERR)
      ELSE IF(ITEM(1:8).EQ.'_lib_vdw') THEN
        CALL PT_EVDW(MDOC,I,BLOCK,LENB,ITEM,LENI
     *    ,DATA,IDATA,FDATA,LEND,IERR)
      ELSE IF(ITEM(1:10).EQ.'_lib_hbond') THEN
        CALL PT_EHBOND(MDOC,I,BLOCK,LENB,ITEM,LENI
     *    ,DATA,IDATA,FDATA,LEND,IERR)
      ELSE IF(ITEM(1:12).EQ.'_lib_synonym') THEN
        CALL PT_ESYNONYM(MDOC,I,BLOCK,LENB,ITEM,LENI
     *    ,DATA,IDATA,FDATA,LEND,IERR)

      ENDIF
      RETURN
C -----------------------------------
      END     

C ******
      SUBROUTINE PT_EATOM(MDOC,MODE,I,BLOCK,LENB,ITEM,LENI
     *  ,DATA,IDATA,FDATA,LEND,IERR)
C -------------------------------------------------------
C -P- PT_EATOM - reads energy library information about atoms.
C -S-
C -------------------------------------------------------
C ----
      REAL      FDATA
      INTEGER*4 IDATA,MDOC,I,IERR
      INTEGER*4 LENB,LENI,LEND
      CHARACTER BLOCK*(*),DATA*(*),ITEM*(*),MODE*4
C -----------------------------------------------
      INCLUDE 'lib_com.fh'
C ******
C -----------------------------------
      CHARACTER LINE*256,CHEM*4
C -----------------------------------
      IERR = 0
      IF(ITEM(11:14).EQ.'type' ) THEN 
        IF(I.NE.1) THEN
          WRITE(LINE,'(A,A4,A)')' ERR: item _lib_atom.type :',DATA(1:4)
     *    ,' must be first in the string'
          CALL MSGERR(MDOC,LINE)
          LEA_IATOM = 0           
          IERR      = 1
          RETURN
        ENDIF
        CHEM = DATA(1:4)
        IF(MODE.NE.'ALL ') THEN
          IF(LEA_NATOM.LE.0) THEN
            CALL MSGERR(MDOC
     *      ,' ERR: number of atom types in the list= 0')
            LEA_IATOM = 0           
            IERR      = 1
            RETURN
          ENDIF
          DO L=1,LEA_NATOM
            IF(CHEM.EQ.LEA_ANAME(L)) THEN
              LEA_IATOM           = L
              LEA_TYPE(LEA_IATOM) = 'Y'
              RETURN
            ENDIF
          ENDDO
          IF(CHEM(1:1).EQ.'H'.AND.MODE.EQ.'H   ') THEN
            IF(LEA_NATOM.GT.MAXETYP) THEN
              WRITE(LINE,'(A,I6,A)')' ERR: number of atom types >'
     *        ,MAXETYP,' /lib. limit/'
              CALL MSGERR(MDOC,LINE)
            CALL MSGERR(MDOC,
     *  ' Change parameter MAXETYP in "lib_com.fh"')
              IERR = 1
              RETURN
            ENDIF
            LEA_NATOM            = LEA_NATOM + 1
            LEA_ANAME(LEA_NATOM) = CHEM
            LEA_TYPE (LEA_NATOM) = 'Y'
            LEA_IATOM            = LEA_NATOM
          ELSE
            LEA_IATOM = 0
          ENDIF
          RETURN
        ELSE
          IF(LEA_NATOM.GT.MAXETYP) THEN
            WRITE(LINE,'(A,I6,A)')' ERR: number of atom types >'
     *      ,MAXETYP,' /lib. limit/'
            CALL MSGERR(MDOC,LINE)
            CALL MSGERR(MDOC,
     *  ' Change parameter MAXMLIST in "lib_com.fh"')
            IERR = 1
            RETURN
          ENDIF
          LEA_NATOM            = LEA_NATOM + 1
          LEA_ANAME(LEA_NATOM) = CHEM
          LEA_TYPE (LEA_NATOM) = 'Y'
          LEA_IATOM            = LEA_NATOM
          LEA_WEIGHT(LEA_IATOM)  = 0.0
          LEA_RADIUS(LEA_IATOM)  = 0.0
          LEA_HRADIUS(LEA_IATOM) = 0.0
          LEA_IRADIUS(LEA_IATOM) = 0.0
          LEA_POLAR(LEA_IATOM)   = 0.0
          LEA_HPOLAR(LEA_IATOM)  = 0.0
          LEA_VALENCY(LEA_IATOM) = 0
          LEA_SP(LEA_IATOM)      = 0
          RETURN        
        ENDIF
      ENDIF
C COMLETENESS ????
      IF(LEA_IATOM.GT.0.AND.I.GT.1) THEN
        IF(ITEM(11:17).EQ.'hb_type') THEN
          LEA_HTYPE(LEA_IATOM) = DATA(1:1)
        ELSE IF(ITEM(11:16).EQ.'weight') THEN
          LEA_WEIGHT(LEA_IATOM) = FDATA
        ELSE IF(ITEM(11:20).EQ.'vdw_radius') THEN
          LEA_RADIUS(LEA_IATOM) = FDATA
        ELSE IF(ITEM(11:15).EQ.'polar') THEN
          LEA_POLAR(LEA_IATOM) = FDATA
        ELSE IF(ITEM(11:16).EQ.'hpolar') THEN
          LEA_HPOLAR(LEA_IATOM) = FDATA
        ELSE IF(ITEM(11:21).EQ.'vdwh_radius') THEN
          LEA_HRADIUS(LEA_IATOM) = FDATA
        ELSE IF(ITEM(11:20).EQ.'ion_radius') THEN
          LEA_IRADIUS(LEA_IATOM) = FDATA
        ELSE IF(ITEM(11:17).EQ.'element') THEN
          LEA_ENAME(LEA_IATOM) = DATA
        ELSE IF(ITEM(11:17).EQ.'valency') THEN
          LEA_VALENCY(LEA_IATOM) = IDATA
        ELSE IF(ITEM(11:12).EQ.'sp') THEN
          LEA_SP(LEA_IATOM) = IDATA
        ENDIF
      ENDIF
      RETURN
C -----------------------------------
      END     

C ******
      SUBROUTINE PT_EBOND(MDOC,I,BLOCK,LENB,ITEM,LENI
     *  ,DATA,IDATA,FDATA,LEND,IERR)
C -------------------------------------------------------
C -P- PT_EBOND - reads enegy library information about bonds.
C -S-
C -------------------------------------------------------
C ----
      REAL      FDATA
      INTEGER*4 IDATA,MDOC,I,IERR
      INTEGER*4 LENB,LENI,LEND
      CHARACTER BLOCK*(*),DATA*(*),ITEM*(*)
C -----------------------------------------------
      INCLUDE 'lib_com.fh'
C ******
C -----------------------------------
      CHARACTER LINE*256,CHEM*4
C -----------------------------------
      IERR=0
      IF(ITEM(11:21).EQ.'atom_type_1' ) THEN 
        IF(I.NE.1) THEN
          WRITE(LINE,'(A,A4,A)')' ERR: item _lib_bond.atom_type_1 :'
     *    ,DATA(1:4),' must be first in the string'
          CALL MSGERR(MDOC,LINE)
          LEB_IBOND = 0           
          IERR      = 1
          RETURN
        ENDIF
        CHEM=DATA(1:4)
        IF(LEA_NATOM.LE.0) THEN
          CALL MSGERR(MDOC
     *    ,' ERR: number of atom types in the list= 0')
          LEB_IBOND = 0           
          IERR      = 1
          RETURN
        ENDIF
        DO L=1,LEA_NATOM
          IF(CHEM.EQ.LEA_ANAME(L).AND.LEA_TYPE(L).EQ.'Y') THEN
            LEB_NBOND=LEB_NBOND+1
            IF(LEB_NBOND.GT.MAXBTYP) THEN
              WRITE(LINE,'(A,I6,A)')' ERR: read number of bonds  >'
     *        ,MAXBTYP,' /lib. limit/'
              CALL MSGERR(MDOC,LINE)
            CALL MSGERR(MDOC,
     *  ' Change parameter MAXBTYP in "lib_com.fh"')
              LEB_IBOND = 0           
              IERR=1
              RETURN
            ENDIF
            LEB_IBOND              = LEB_NBOND           
            LEB_1ATM   (LEB_NBOND) = DATA(1:4)
            LEB_2ATM   (LEB_NBOND) = '.'
            LEB_TYPE   (LEB_NBOND) = '.'
            LEB_I1ATM  (LEB_NBOND) = 0
            LEB_I2ATM  (LEB_NBOND) = 0
            LEB_CONST  (LEB_NBOND) = 0.0
            LEB_LENGTH (LEB_NBOND) = 0.0
            RETURN
          ENDIF
        ENDDO
        LEB_IBOND = 0           
        RETURN
      ENDIF

      IF(LEB_IBOND.NE.0.AND.ITEM(11:21).EQ.'atom_type_2') THEN 
        IF(I.NE.2) THEN
          WRITE(LINE,'(A,A4,A)')' ERR: item _lib_bond_atom_type_2 :'
     *    ,DATA(1:4),' must be second in the string'
          CALL MSGERR(MDOC,LINE)
          LEB_IBOND = 0           
          LEB_NBOND = LEB_NBOND -1          
          IERR      = 1
          RETURN
        ENDIF
        CHEM = DATA(1:4)
        IF(LEA_NATOM.LE.0) THEN
          CALL MSGERR(MDOC
     *    ,' ERR: number of atom types in the list= 0')
          LEB_IBOND = 0           
          IERR      = 1
          RETURN
        ENDIF
        DO L=1,LEA_NATOM
          IF(CHEM.EQ.LEA_ANAME(L).AND.LEA_TYPE(L).EQ.'Y') THEN
            LEB_2ATM   (LEB_NBOND) = DATA(1:4)
            RETURN
          ENDIF
        ENDDO
        LEB_IBOND = 0           
        LEB_NBOND = LEB_NBOND - 1
        RETURN
      ENDIF

C COMLETENESS ????

      IF(LEB_IBOND.GT.0.AND.I.GT.2) THEN
        IF(ITEM(11:14).EQ.'type') THEN
          LEB_TYPE (LEB_NBOND) = DATA(1:8)
        ELSE IF(ITEM(11:15).EQ.'const') THEN
          LEB_CONST  (LEB_NBOND) = FDATA
        ELSE IF(ITEM(11:16).EQ.'length') THEN
          LEB_LENGTH (LEB_NBOND) = FDATA
        ENDIF
      ENDIF

      RETURN
C -----------------------------------
      END     

C ******
      SUBROUTINE PT_EANGL(MDOC,I,BLOCK,LENB,ITEM,LENI
     *  ,DATA,IDATA,FDATA,LEND,IERR)
C -------------------------------------------------------
C -P- PT_EANGL - reads enegy library information about angles.
C -S-
C -------------------------------------------------------
C ----
      REAL      FDATA
      INTEGER*4 IDATA,MDOC,I,IERR
      INTEGER*4 LENB,LENI,LEND
      CHARACTER BLOCK*(*),DATA*(*),ITEM*(*)
C -----------------------------------------------
      INCLUDE 'lib_com.fh'
C ******
C -----------------------------------
      CHARACTER LINE*256,CHEM*4
C -----------------------------------
      IERR=0
      IF(ITEM(12:22).EQ.'atom_type_1' ) THEN 
        IF(I.NE.1) THEN
          WRITE(LINE,'(A,A4,A)')' ERR: item _lib_angle.atom_type_1 :'
     *    ,DATA(1:4),' must be first in the string'
          CALL MSGERR(MDOC,LINE)
          LEG_IANGL = 0           
          IERR=1
          RETURN
        ENDIF
        CHEM=DATA(1:4)
        IF(LEA_NATOM.LE.0) THEN
          CALL MSGERR(MDOC
     *    ,' ERR: number of atom types in the list= 0')
          LEG_IANGL = 0           
          IERR=1
          RETURN
        ENDIF
        DO L=1,LEA_NATOM
          IF(CHEM.EQ.LEA_ANAME(L).AND.LEA_TYPE(L).EQ.'Y') THEN
            LEG_NANGL=LEG_NANGL+1
            IF(LEG_NANGL.GT.MAXATYP) THEN
              WRITE(LINE,'(A,I6,A)')' ERR: read number of angles  >'
     *        ,MAXATYP,' /lib. limit/'
              CALL MSGERR(MDOC,LINE)
            CALL MSGERR(MDOC,
     *  ' Change parameter MAXATYP in "lib_com.fh"')
              LEG_IANGL = 0           
              IERR=1
              RETURN
            ENDIF
            LEG_IANGL = LEG_NANGL           
            LEG_1ATM   (LEG_NANGL) = DATA(1:4)
            LEG_2ATM   (LEG_NANGL) = '.'
            LEG_3ATM   (LEG_NANGL) = '.'
            LEG_I1ATM  (LEG_NANGL) = 0
            LEG_I2ATM  (LEG_NANGL) = 0
            LEG_I3ATM  (LEG_NANGL) = 0
            LEG_CONST  (LEG_NANGL) = 0.0
            LEG_ANGLE  (LEG_NANGL) = 0.0
            RETURN
          ENDIF
        ENDDO
        LEG_IANGL = 0           
        RETURN
      ENDIF

      IF(LEG_IANGL.NE.0.AND.ITEM(12:22).EQ.'atom_type_2') THEN 
        IF(I.NE.2) THEN
          WRITE(LINE,'(A,A4,A)')' ERR: item _lib_angle_atom_type_2 :'
     *    ,DATA(1:4),' must be second in the string'
          CALL MSGERR(MDOC,LINE)
          LEG_IANGL = 0           
          LEG_NANGL = LEG_NANGL -1          
          IERR=1
          RETURN
        ENDIF
        CHEM=DATA(1:4)
        IF(LEA_NATOM.LE.0) THEN
          CALL MSGERR(MDOC
     *    ,' ERR: number of atom types in the list= 0')
          LEG_IANGL = 0           
          IERR=1
          RETURN
        ENDIF
        DO L=1,LEA_NATOM
          IF(CHEM.EQ.LEA_ANAME(L).AND.LEA_TYPE(L).EQ.'Y') THEN
            LEG_2ATM   (LEG_NANGL) = DATA(1:4)
            RETURN
          ENDIF
        ENDDO
        LEG_IANGL = 0           
        LEG_NANGL = LEG_NANGL - 1
        RETURN
      ENDIF

      IF(LEG_IANGL.NE.0.AND.ITEM(12:22).EQ.'atom_type_3') THEN 
        IF(I.NE.3) THEN
          WRITE(LINE,'(A,A4,A)')' ERR: item _lib_angle_atom_type_3 :'
     *    ,DATA(1:4),' must be third in the string'
          CALL MSGERR(MDOC,LINE)
          LEG_IANGL = 0           
          LEG_NANGL = LEG_NANGL -1          
          IERR=1
          RETURN
        ENDIF
        CHEM=DATA(1:4)
        IF(LEA_NATOM.LE.0) THEN
          CALL MSGERR(MDOC
     *    ,' ERR: number of atom types in the list= 0')
          LEG_IANGL = 0           
          IERR=1
          RETURN
        ENDIF
        DO L=1,LEA_NATOM
          IF(CHEM.EQ.LEA_ANAME(L).AND.LEA_TYPE(L).EQ.'Y') THEN
            LEG_3ATM   (LEG_NANGL) = DATA(1:4)
            RETURN
          ENDIF
        ENDDO
        LEG_IANGL = 0           
        LEG_NANGL = LEG_NANGL - 1
        RETURN
      ENDIF

C COMLETENESS ????

      IF(LEG_IANGL.GT.0.AND.I.GT.3) THEN
        IF(ITEM(12:16).EQ.'const') THEN
          LEG_CONST (LEG_NANGL)=FDATA
        ELSE IF(ITEM(12:16).EQ.'value') THEN
          LEG_ANGLE (LEG_NANGL)=FDATA
        ENDIF
      ENDIF

      RETURN
C -----------------------------------
      END     

C ******
      SUBROUTINE PT_ETORS(MDOC,I,BLOCK,LENB,ITEM,LENI
     *  ,DATA,IDATA,FDATA,LEND,IERR)
C -------------------------------------------------------
C -P- PT_ETORS - reads enegy library information about torsion angles.
C -S-
C -------------------------------------------------------
C ----
      REAL      FDATA
      INTEGER*4 IDATA,MDOC,I,IERR
      INTEGER*4 LENB,LENI,LEND
      CHARACTER BLOCK*(*),DATA*(*),ITEM*(*)
C -----------------------------------------------
      INCLUDE 'lib_com.fh'
C ******
C -----------------------------------
      CHARACTER LINE*256,CHEM*4
C -----------------------------------
      IERR=0
      IF(ITEM(11:21).EQ.'atom_type_1' ) THEN 
        IF(I.NE.1) THEN
          WRITE(LINE,'(A,A4,A)')' ERR: item _lib_tor.atom_type_1 :'
     *    ,DATA(1:4),' must be first in the string'
          CALL MSGERR(MDOC,LINE)
          LET_ITORS = 0           
          IERR=1
          RETURN
        ENDIF
        CHEM=DATA(1:4)
        IF(LEA_NATOM.LE.0) THEN
          CALL MSGERR(MDOC
     *    ,' ERR: number of atom types in the list= 0')
          LET_ITORS = 0           
          IERR=1
          RETURN
        ENDIF
        IF(CHEM(1:1).EQ.'.') GO TO 100
        DO L=1,LEA_NATOM
          IF(CHEM.EQ.LEA_ANAME(L).AND.LEA_TYPE(L).EQ.'Y') THEN
            GO TO 100
          ENDIF
        ENDDO
        LET_ITORS = 0           
        RETURN

  100   CONTINUE
        IF(LET_NTORS.GT.MAXTTYP) THEN
          WRITE(LINE,'(A,I6,A)')' ERR: read number of torsions >'
     *    ,MAXTTYP,' /lib. limit/'
          CALL MSGERR(MDOC,LINE)
            CALL MSGERR(MDOC,
     *  ' Change parameter MAXTTYP in "lib_com.fh"')
          LET_ITORS = 0           
          IERR=1
          RETURN
        ENDIF
        LET_NTORS=LET_NTORS+1
        LET_ITORS = LET_NTORS           
        LET_1ATM   (LET_NTORS) = DATA(1:4)
        LET_2ATM   (LET_NTORS) = '.'
        LET_3ATM   (LET_NTORS) = '.'
        LET_4ATM   (LET_NTORS) = '.'
        LET_CONST  (LET_NTORS) = 0.0
        LET_ANGLE  (LET_NTORS) = 0.0
        LET_PRD    (LET_NTORS) =  0
        LET_LABEL  (LET_NTORS) = '.'
        RETURN
      ENDIF

      IF(LET_ITORS.NE.0.AND.ITEM(11:21).EQ.'atom_type_2') THEN 
        IF(I.NE.2) THEN
          WRITE(LINE,'(A,A4,A)')' ERR: item _lib_tor.atom_type_2 :'
     *    ,DATA(1:4),' must be second in the string'
          CALL MSGERR(MDOC,LINE)
          LET_ITORS = 0           
          LET_NTORS = LET_NTORS -1          
          IERR=1
          RETURN
        ENDIF
        CHEM=DATA(1:4)
        IF(LEA_NATOM.LE.0) THEN
          CALL MSGERR(MDOC
     *    ,' ERR: number of atom types in the list= 0')
          LET_ITORS = 0           
          LET_NTORS = LET_NTORS -1          
          IERR=1
          RETURN
        ENDIF
        DO L=1,LEA_NATOM
          IF(CHEM.EQ.LEA_ANAME(L).AND.LEA_TYPE(L).EQ.'Y') THEN
            LET_2ATM   (LET_NTORS) = DATA(1:4)
            RETURN
          ENDIF
        ENDDO
        LET_ITORS = 0           
        LET_NTORS = LET_NTORS - 1
        RETURN
      ENDIF

      IF(LET_ITORS.NE.0.AND.ITEM(11:21).EQ.'atom_type_3') THEN 
        IF(I.NE.3) THEN
          WRITE(LINE,'(A,A4,A)')' ERR: item _lib_tor_atom_type_3 :'
     *    ,DATA(1:4),' must be third in the string'
          CALL MSGERR(MDOC,LINE)
          LET_ITORS = 0           
          LET_NTORS = LET_NTORS -1          
          IERR=1
          RETURN
        ENDIF
        CHEM=DATA(1:4)
        IF(LEA_NATOM.LE.0) THEN
          CALL MSGERR(MDOC
     *    ,' ERR: number of atom types in the list= 0')
          LET_ITORS = 0           
          LET_NTORS = LET_NTORS - 1
          IERR=1
          RETURN
        ENDIF
        DO L=1,LEA_NATOM
          IF(CHEM.EQ.LEA_ANAME(L).AND.LEA_TYPE(L).EQ.'Y') THEN
            LET_3ATM   (LET_NTORS) = DATA(1:4)
            RETURN
          ENDIF
        ENDDO
        LET_ITORS = 0           
        LET_NTORS = LET_NTORS - 1
        RETURN
      ENDIF

      IF(LET_ITORS.NE.0.AND.ITEM(11:21).EQ.'atom_type_4') THEN 
        IF(I.NE.4) THEN
          WRITE(LINE,'(A,A4,A)')' ERR: item _lib_tor.atom_type_4 :'
     *    ,DATA(1:4),' must be fourth in the string'
          CALL MSGERR(MDOC,LINE)
          LET_ITORS = 0           
          LET_NTORS = LET_NTORS -1          
          IERR=1
          RETURN
        ENDIF
        CHEM=DATA(1:4)
        IF(CHEM(1:1).EQ.'.') THEN
          LET_4ATM   (LET_NTORS) = DATA(1:4)
          RETURN
        ENDIF
        IF(LEA_NATOM.LE.0) THEN
          CALL MSGERR(MDOC
     *    ,' ERR: number of atom types in the list= 0')
          LET_ITORS = 0           
          LET_NTORS = LET_NTORS - 1
          IERR=1
          RETURN
        ENDIF
        DO L=1,LEA_NATOM
          IF(CHEM.EQ.LEA_ANAME(L).AND.LEA_TYPE(L).EQ.'Y') THEN
            LET_4ATM   (LET_NTORS) = DATA(1:4)
            RETURN
          ENDIF
        ENDDO
        LET_ITORS = 0           
        LET_NTORS = LET_NTORS - 1
        RETURN
      ENDIF


C COMLETENESS ????

      IF(LET_ITORS.GT.0.AND.I.GT.4) THEN
        IF(ITEM(11:15).EQ.'const') THEN
          LET_CONST (LET_NTORS)=FDATA
        ELSE IF(ITEM(11:15).EQ.'angle') THEN
          LET_ANGLE (LET_NTORS)=FDATA
        ELSE IF(ITEM(11:16).EQ.'period') THEN
          LET_PRD (LET_NTORS)=IDATA
        ELSE IF(ITEM(11:15).EQ.'label') THEN
          LET_LABEL (LET_NTORS)=DATA(1:8)
        ENDIF
      ENDIF

      RETURN
C -----------------------------------
      END     

C ******
      SUBROUTINE PT_EVDW(MDOC,I,BLOCK,LENB,ITEM,LENI
     *  ,DATA,IDATA,FDATA,LEND,IERR)
C -------------------------------------------------------
C -P- PT_EVDW - reads enegy library information about VDW - contacts.
C -S-
C -------------------------------------------------------
C ----
      REAL      FDATA
      INTEGER*4 IDATA,MDOC,I,IERR
      INTEGER*4 LENB,LENI,LEND
      CHARACTER BLOCK*(*),DATA*(*),ITEM*(*)
C -----------------------------------------------
      INCLUDE 'lib_com.fh'
C ******
C -----------------------------------
      CHARACTER LINE*256,CHEM*4
C -----------------------------------
      IERR=0
      IF(ITEM(10:20).EQ.'atom_type_1' ) THEN 
        IF(I.NE.1) THEN
          WRITE(LINE,'(A,A4,A)')' ERR: item _lib_vdw.atom_type_1 :'
     *    ,DATA(1:4),' must be first in the string'
          CALL MSGERR(MDOC,LINE)
          LEW_ICONT = 0           
          IERR=1
          RETURN
        ENDIF
        CHEM=DATA(1:4)
        IF(LEA_NATOM.LE.0) THEN
          CALL MSGERR(MDOC
     *    ,' ERR: number of atom types in the list= 0')
          LEW_ICONT = 0           
          IERR=1
          RETURN
        ENDIF
        DO L=1,LEA_NATOM
          IF(CHEM.EQ.LEA_ANAME(L).AND.LEA_TYPE(L).EQ.'Y') THEN
            LEW_NCONT=LEW_NCONT+1
            IF(LEW_NCONT.GT.MAXWTYP) THEN
              WRITE(LINE,'(A,I6,A)')
     *   ' ERR: read number of vdw contacts  >',MAXWTYP,' /lib. limit/'
              CALL MSGERR(MDOC,LINE)
            CALL MSGERR(MDOC,
     *  ' Change parameter MAXWTYP in "lib_com.fh"')
              LEW_ICONT = 0           
              IERR=1
              RETURN
            ENDIF
            LEW_ICONT = LEW_NCONT           
            LEW_1ATM   (LEW_NCONT) = DATA(1:4)
            LEW_2ATM   (LEW_NCONT) = '.'
            LEW_HFLAG  (LEW_NCONT) = '.'
            LEW_EMIN   (LEW_NCONT) = 0.0
            LEW_RMIN   (LEW_NCONT) = 0.0
            RETURN
          ENDIF
        ENDDO
        LEW_ICONT = 0           
        RETURN
      ENDIF

      IF(LEW_ICONT.NE.0.AND.ITEM(10:20).EQ.'atom_type_2') THEN 
        IF(I.NE.2) THEN
          WRITE(LINE,'(A,A4,A)')' ERR: item _lib_vdw.atom_type_2 :'
     *    ,DATA(1:4),' must be second in the string'
          CALL MSGERR(MDOC,LINE)
          LEW_ICONT = 0           
          LEW_NCONT = LEW_NCONT -1          
          IERR=1
          RETURN
        ENDIF
        CHEM=DATA(1:4)
        IF(LEA_NATOM.LE.0) THEN
          CALL MSGERR(MDOC
     *    ,' ERR: number of atom types in the list= 0')
          LEW_ICONT = 0           
          IERR=1
          RETURN
        ENDIF
        DO L=1,LEA_NATOM
          IF(CHEM.EQ.LEA_ANAME(L).AND.LEA_TYPE(L).EQ.'Y') THEN
            LEW_2ATM   (LEW_NCONT) = DATA(1:4)
            RETURN
          ENDIF
        ENDDO
        LEW_ICONT = 0           
        LEW_NCONT = LEW_NCONT - 1
        RETURN
      ENDIF

C COMLETENESS ????

      IF(LEW_ICONT.GT.0.AND.I.GT.2) THEN
        IF(ITEM(10:15).EQ.'H_flag') THEN
          LEW_HFLAG (LEW_NCONT)=DATA(1:1)
        ELSE IF(ITEM(10:15).EQ.'energy') THEN
          LEW_EMIN  (LEW_NCONT)=FDATA
        ELSE IF(ITEM(10:15).EQ.'radius') THEN
          LEW_RMIN  (LEW_NCONT)=FDATA
        ENDIF
      ENDIF

      RETURN
C -----------------------------------
      END     

C ******
      SUBROUTINE PT_EHBOND(MDOC,I,BLOCK,LENB,ITEM,LENI
     *  ,DATA,IDATA,FDATA,LEND,IERR)
C -------------------------------------------------------
C -P- PT_EHBOND - reads enegy library information about H - bonds.
C -S-
C -------------------------------------------------------
C ----
      REAL      FDATA
      INTEGER*4 IDATA,MDOC,I,IERR
      INTEGER*4 LENB,LENI,LEND
      CHARACTER BLOCK*(*),DATA*(*),ITEM*(*)
C -----------------------------------------------
      INCLUDE 'lib_com.fh'
C ******
C -----------------------------------
      CHARACTER LINE*256,CHEM*4
C -----------------------------------
      IERR=0
      IF(ITEM(12:22).EQ.'atom_type_1' ) THEN 
        IF(I.NE.1) THEN
          WRITE(LINE,'(A,A4,A)')' ERR: item _lib_hbond.atom_type_1 :'
     *    ,DATA(1:4),' must be first in the string'
          CALL MSGERR(MDOC,LINE)
          LEH_IHBOND = 0           
          IERR=1
          RETURN
        ENDIF
        CHEM=DATA(1:4)
        IF(LEA_NATOM.LE.0) THEN
          CALL MSGERR(MDOC
     *    ,' ERR: number of atom types in the list= 0')
          LEH_IHBOND = 0           
          IERR=1
          RETURN
        ENDIF
        DO L=1,LEA_NATOM
          IF(CHEM.EQ.LEA_ANAME(L).AND.LEA_TYPE(L).EQ.'Y') THEN
            LEH_NHBOND=LEH_NHBOND+1
            IF(LEH_NHBOND.GT.MAXHTYP) THEN
              WRITE(LINE,'(A,I6,A)')' ERR: read number of H bonds  >'
     *        ,MAXHTYP,' /lib. limit/'
              CALL MSGERR(MDOC,LINE)
            CALL MSGERR(MDOC,
     *  ' Change parameter MAXHTYP in "lib_com.fh"')
              LEH_IHBOND = 0           
              IERR=1
              RETURN
            ENDIF
            LEH_IHBOND = LEH_NHBOND           
            LEH_1ATM   (LEH_NHBOND) = DATA(1:4)
            LEH_2ATM   (LEH_NHBOND) = '.'
            LEH_EMIN   (LEH_NHBOND) = 0.0
            LEH_DIST   (LEH_NHBOND) = 0.0
            RETURN
          ENDIF
        ENDDO
        LEH_IHBOND = 0           
        RETURN
      ENDIF

      IF(LEH_IHBOND.NE.0.AND.ITEM(12:22).EQ.'atom_type_2') THEN 
        IF(I.NE.2) THEN
          WRITE(LINE,'(A,A4,A)')' ERR: item _lib_hbond.atom_type_2 :'
     *    ,DATA(1:4),' must be second in the string'
          CALL MSGERR(MDOC,LINE)
          LEH_IHBOND = 0           
          LEH_NHBOND = LEH_NHBOND -1          
          IERR=1
          RETURN
        ENDIF
        CHEM=DATA(1:4)
        IF(LEA_NATOM.LE.0) THEN
          CALL MSGERR(MDOC
     *    ,' ERR: number of atom types in the list= 0')
          LEH_IHBOND = 0           
          IERR=1
          RETURN
        ENDIF
        DO L=1,LEA_NATOM
          IF(CHEM.EQ.LEA_ANAME(L).AND.LEA_TYPE(L).EQ.'Y') THEN
            LEH_2ATM   (LEH_NHBOND) = DATA(1:4)
            RETURN
          ENDIF
        ENDDO
        LEH_IHBOND = 0           
        LEH_NHBOND = LEH_NHBOND - 1
        RETURN
      ENDIF

C COMLETENESS ????

      IF(LEH_IHBOND.GT.0.AND.I.GT.2) THEN
        IF(ITEM(12:14).EQ.'min') THEN
          LEH_EMIN  (LEH_NHBOND)=FDATA
        ELSE IF(ITEM(12:15).EQ.'dist') THEN
          LEH_DIST  (LEH_NHBOND)=FDATA
        ENDIF
      ENDIF

      RETURN
C -----------------------------------
      END     
C ******
      SUBROUTINE PT_ESYNONYM(MDOC,I,BLOCK,LENB,ITEM,LENI
     *  ,DATA,IDATA,FDATA,LEND,IERR)
C -------------------------------------------------------
C -P- PT_ESYNONYM
C -S-
C -------------------------------------------------------
C ----
      REAL      FDATA
      INTEGER*4 IDATA,MDOC,I,IERR
      INTEGER*4 LENB,LENI,LEND
      CHARACTER BLOCK*(*),DATA*(*),ITEM*(*)
C -----------------------------------------------
      INCLUDE 'lib_com.fh'
C ******
C -----------------------------------
      CHARACTER LINE*256
C -----------------------------------
      IERR = 0
      IF(ITEM(14:22).EQ.'atom_type' ) THEN 
        IF(I.NE.1) THEN
          WRITE(LINE,'(A,A4,A)')' ERR: item _lib_synonym.atom_type :'
     *    ,DATA(1:4),' must be first in the string'
          CALL MSGERR(MDOC,LINE)
          LES_ISYN = 0           
          IERR     = 1
          RETURN
        ENDIF
        IF(LES_NSYN.GT.MAXSTYP) THEN
          WRITE(LINE,'(A,I6,A)')' ERR: read number of synonym. types  >'
     *    ,MAXSTYP,' /lib. limit/'
          CALL MSGERR(MDOC,LINE)
          CALL MSGERR(MDOC,
     *  ' Change parameter MAXSTYP in "lib_com.fh"')
          LES_ISYN = 0           
          IERR = 1
          RETURN
        ENDIF
        LES_NSYN           = LES_NSYN + 1
        LES_ISYN           = LES_NSYN           
        LES_ATYP(LES_NSYN) = DATA(1:4)
        LES_STYP(LES_NSYN) = '.'
        RETURN
      ENDIF

      IF(LES_ISYN.NE.0.AND.ITEM(14:34).EQ.'atom_alternative_type') THEN 
 
        IF(I.NE.2) THEN
          WRITE(LINE,'(A,A4,A)')
     *    ' ERR: item _lib_synonym.atom_alternative_type :'
     *    ,DATA(1:4),' must be second in the string'
          CALL MSGERR(MDOC,LINE)
          LES_ISYN = 0           
          LES_NSYN = LES_NSYN -1          
          IERR=1
          RETURN
        ENDIF

        LES_STYP(LES_NSYN) = DATA(1:4)

      ENDIF

      RETURN
C -----------------------------------
      END     

C ******
      SUBROUTINE GET_CLIST(MDOC,IERR)
C -----------------------------------------------
C -P- GET_CLIST - creat list of chemical type of atoms
C -P-             from mon_library.
C -S-
C -----------------------------------------------
      INTEGER*4 MDOC,IERR
C      CHARACTER MODE*4
C ---
      INCLUDE 'lib_com.fh'
C ******
C ---
      CHARACTER LINE*256
C --------------------------------
      IERR=0
      LEA_NATOM = 0
      IF(LMA_NATOM.LE.0) THEN
        CALL MSGERR(MDOC,' ERROR: number of atoms in library = 0')
        IERR=2
        RETURN
      ENDIF

      DO L=1,LMA_NATOM
        IF(LEA_NATOM.GT.0) THEN
          DO I=1,LEA_NATOM
            IF(LMA_CHEM(L).EQ.LEA_ANAME(I)) GO TO 100
          ENDDO
        ENDIF
        IF(LEA_NATOM.GT.MAXETYP) THEN
          WRITE(LINE,'(A,I6,A)')' ERROR: number of atom types >'
     *    ,MAXETYP,' /lib. limit/'
          CALL MSGERR(MDOC,LINE)
          IERR=1
          RETURN
        ENDIF
        LEA_NATOM = LEA_NATOM + 1
        LEA_ANAME(LEA_NATOM) = LMA_CHEM(L)
        LEA_TYPE (LEA_NATOM) = 'N'
  100   CONTINUE
      ENDDO

c     LEA_NATOM = 0
      WRITE(LINE,'(A,I6)')
     *' NUMBER OF ATOM TYPES IN THE STRUCTURE    :', LEA_NATOM
      CALL MSGDOC(MDOC,LINE)

      RETURN
      END     

C ******
      SUBROUTINE WRT_ELIB(MODE,MDOC,IERR)
C -------------------------------------------------------
C -P- WRT_ELIB - writes energy library to the file.
C -S-
C -------------------------------------------------------
      INTEGER*4 MDOC,IERR
      CHARACTER MODE*4
C ******
      CHARACTER LINE*256
C -----------------------------------------------
      INCLUDE 'lib_com.fh'
      INCLUDE 'crd_com.fh'
C ----------------------------------
C -----------------------------------
      IF(LEO_FILE.EQ.' ') RETURN
      IERR=0
      IF(MODE.EQ.'TITL') THEN
C     open file 
        IF(LEO_IUN.NE.0) THEN
          CALL MSGERR(MDOC
     *    ,' ERROR: output_ener_lib_file was open before')
          IERR=1
          RETURN
        ENDIF
        M=99
C       IUN=12
        IUN=CRO_IUN
        CALL OPENFW(IUN,M,LEO_PATH,LEO_FILE,LEO_EXT,IERR)
        IF(IERR.NE.0) THEN
          CALL MSGERR(MDOC,' ERR: can''t open output ener_lib file')
          RETURN
        ENDIF
        LEO_IUN=IUN

        WRITE(LINE,'(''#'')')
        CALL WRTSTR(IUN,MDOC,LINE,IERR)
        WRITE(LINE,'(''data_ener_lib'')')
        CALL WRTSTR(IUN,MDOC,LINE,IERR)

        WRITE(LINE,'(''#'')')
        CALL WRTSTR(IUN,MDOC,LINE,IERR)
        WRITE(LINE,'(''# --- ATOM ---'')')
        CALL WRTSTR(IUN,MDOC,LINE,IERR)
        WRITE(LINE,'(''#'')')
        CALL WRTSTR(IUN,MDOC,LINE,IERR)

        IF(LEA_NATOM.GT.0) THEN

          WRITE(LINE,'(''loop_'')')
          CALL WRTSTR(IUN,MDOC,LINE,IERR)


          WRITE(LINE,'(''_lib_atom.type'')')
          CALL WRTSTR(IUN,MDOC,LINE,IERR)
          WRITE(LINE,'(''_lib_atom.weight'')')
          CALL WRTSTR(IUN,MDOC,LINE,IERR)
          WRITE(LINE,'(''_lib_atom.hb_type'')')
          CALL WRTSTR(IUN,MDOC,LINE,IERR)
          WRITE(LINE,'(''_lib_atom.vdw_radius'')')
          CALL WRTSTR(IUN,MDOC,LINE,IERR)
C          WRITE(LINE,'(''_lib_atom.polar'')')
C          CALL WRTSTR(IUN,MDOC,LINE,IERR)
          WRITE(LINE,'(''_lib_atom.vdwh_radius'')')
          CALL WRTSTR(IUN,MDOC,LINE,IERR)
C          WRITE(LINE,'(''_lib_atom.hpolar'')')
C          CALL WRTSTR(IUN,MDOC,LINE,IERR)
          WRITE(LINE,'(''_lib_atom.ion_radius'')')
          CALL WRTSTR(IUN,MDOC,LINE,IERR)
          WRITE(LINE,'(''_lib_atom.element'')')
          CALL WRTSTR(IUN,MDOC,LINE,IERR)
          WRITE(LINE,'(''_lib_atom.valency'')')
          CALL WRTSTR(IUN,MDOC,LINE,IERR)
          WRITE(LINE,'(''_lib_atom.sp'')')
          CALL WRTSTR(IUN,MDOC,LINE,IERR)

          DO L=1,LEA_NATOM
c            WRITE(LINE,100) 
c     *      LEA_ANAME(L)
c     *      ,LEA_WEIGHT(L),LEA_HTYPE(L),LEA_RADIUS(L),LEA_POLAR(L)
c     *      ,LEA_HRADIUS(L),LEA_HPOLAR(L)
c  100       FORMAT(1X,A4,1X,F10.5,1X,A1,1X,F8.3,1X,F8.3,1X
c     *            ,F8.3,1X,F8.3)
            WRITE(LINE,100) 
     *      LEA_ANAME(L)
     *      ,LEA_WEIGHT(L),LEA_HTYPE(L),LEA_RADIUS(L)
     *      ,LEA_HRADIUS(L),LEA_IRADIUS(L),LEA_ENAME(L),LEA_VALENCY(L)
     *      ,LEA_SP(L)
  100       FORMAT(1X,A4,2X,F10.5,2X,A1,2X,F8.3,2X,F8.3,2X,A4
     *            ,F8.3,I5,1X,I3)
            CALL WRTSTR(IUN,MDOC,LINE,IERR)
          ENDDO
        ELSE
          WRITE(LINE,'(''#  Number of atoms = 0'')')
          CALL MSGDOC(MDOC,LINE)
          RETURN
        ENDIF
      ELSE IF(MODE.EQ.'WRIT') THEN
        IF(LEO_IUN.EQ.0) THEN
          CALL MSGERR(MDOC,' ERR: output_ener_lib_file isn''t open')
          IERR=1
          RETURN
        ENDIF
        IUN=LEO_IUN 
        IF(LEB_NBOND.GT.0) THEN
          WRITE(LINE,'(''#'')')
          CALL WRTSTR(IUN,MDOC,LINE,IERR)
          WRITE(LINE,'(''# ---  BONDS ---'')')
          CALL WRTSTR(IUN,MDOC,LINE,IERR)
          WRITE(LINE,'(''#'')')
          CALL WRTSTR(IUN,MDOC,LINE,IERR)
          WRITE(LINE,'(''loop_'')')
          CALL WRTSTR(IUN,MDOC,LINE,IERR)

          WRITE(LINE,'(''_lib_bond.atom_type_1'')')
          CALL WRTSTR(IUN,MDOC,LINE,IERR)
          WRITE(LINE,'(''_lib_bond.atom_type_2'')')
          CALL WRTSTR(IUN,MDOC,LINE,IERR)
          WRITE(LINE,'(''_lib_bond.type'')')
          CALL WRTSTR(IUN,MDOC,LINE,IERR)
          WRITE(LINE,'(''_lib_bond.const'')')
          CALL WRTSTR(IUN,MDOC,LINE,IERR)
          WRITE(LINE,'(''_lib_bond.length'')')
          CALL WRTSTR(IUN,MDOC,LINE,IERR)

          DO I1=1,LEA_NATOM
          DO I2=1,I1

          DO L=1,LEB_NBOND
            IF(LEA_ANAME(I1).EQ.LEB_1ATM(L).AND.
     *          LEA_ANAME(I2).EQ.LEB_2ATM(L)) THEN
            WRITE(LINE,200) 
     *      LEB_1ATM(L),LEB_2ATM(L),LEB_TYPE(L),LEB_CONST(L)
     *      ,LEB_LENGTH(L)
            CALL WRTSTR(IUN,MDOC,LINE,IERR)
            ELSE IF(LEA_ANAME(I1).EQ.LEB_2ATM(L).AND.
     *         LEA_ANAME(I2).EQ.LEB_1ATM(L)) THEN
            WRITE(LINE,200) 
     *      LEB_2ATM(L),LEB_1ATM(L),LEB_TYPE(L),LEB_CONST(L)
     *      ,LEB_LENGTH(L)
  200       FORMAT(1X,A4,1X,A4,1X,A8,1X,F8.3,1X,F8.3)
            CALL WRTSTR(IUN,MDOC,LINE,IERR)
            ENDIF
          ENDDO

        ENDDO
        ENDDO

        ELSE
          WRITE(LINE,'(''#   Number of bonds = 0'')')
          CALL MSGDOC(MDOC,LINE)
          RETURN
        ENDIF
        IF(LEG_NANGL.GT.0) THEN
          WRITE(LINE,'(''#'')')
          CALL WRTSTR(IUN,MDOC,LINE,IERR)
          WRITE(LINE,'(''# ---  ANGLES ---'')')
          CALL WRTSTR(IUN,MDOC,LINE,IERR)
          WRITE(LINE,'(''#'')')
          CALL WRTSTR(IUN,MDOC,LINE,IERR)
          WRITE(LINE,'(''loop_'')')
          CALL WRTSTR(IUN,MDOC,LINE,IERR)

          WRITE(LINE,'(''_lib_angle.atom_type_1'')')
          CALL WRTSTR(IUN,MDOC,LINE,IERR)
          WRITE(LINE,'(''_lib_angle.atom_type_2'')')
          CALL WRTSTR(IUN,MDOC,LINE,IERR)
          WRITE(LINE,'(''_lib_angle.atom_type_3'')')
          CALL WRTSTR(IUN,MDOC,LINE,IERR)
          WRITE(LINE,'(''_lib_angle.const'')')
          CALL WRTSTR(IUN,MDOC,LINE,IERR)
          WRITE(LINE,'(''_lib_angle.value'')')
          CALL WRTSTR(IUN,MDOC,LINE,IERR)

          DO I2=1,LEA_NATOM
          DO I1=1,LEA_NATOM
          DO I3=1,I1

          DO L=1,LEG_NANGL
             
            IF(LEA_ANAME(I1).EQ.LEG_1ATM(L).AND.
     *         LEA_ANAME(I2).EQ.LEG_2ATM(L).AND.
     *         LEA_ANAME(I3).EQ.LEG_3ATM(L)) THEN

            WRITE(LINE,300) 
     *      LEG_1ATM(L),LEG_2ATM(L),LEG_3ATM(L),LEG_CONST(L)
     *      ,LEG_ANGLE(L)
  300       FORMAT(1X,A4,1X,A4,1X,A4,1X,F8.3,1X,F8.3)
            CALL WRTSTR(IUN,MDOC,LINE,IERR)
            ELSE IF(LEA_ANAME(I1).EQ.LEG_3ATM(L).AND.
     *         LEA_ANAME(I2).EQ.LEG_2ATM(L).AND.
     *         LEA_ANAME(I3).EQ.LEG_1ATM(L)) THEN
            WRITE(LINE,300) 
     *      LEG_3ATM(L),LEG_2ATM(L),LEG_1ATM(L),LEG_CONST(L)
     *      ,LEG_ANGLE(L)
            CALL WRTSTR(IUN,MDOC,LINE,IERR)
            ENDIF

          ENDDO

          ENDDO
          ENDDO
          ENDDO
        ELSE
          WRITE(LINE,'(''#  Number of angles = 0'')')
          CALL MSGDOC(MDOC,LINE)
          RETURN
        ENDIF
        IF(LET_NTORS.GT.0) THEN
          WRITE(LINE,'(''#'')')
          CALL WRTSTR(IUN,MDOC,LINE,IERR)
          WRITE(LINE,'(''# ---  TORSIONS ---'')')
          CALL WRTSTR(IUN,MDOC,LINE,IERR)
          WRITE(LINE,'(''#'')')
          CALL WRTSTR(IUN,MDOC,LINE,IERR)
          WRITE(LINE,'(''loop_'')')
          CALL WRTSTR(IUN,MDOC,LINE,IERR)

          WRITE(LINE,'(''_lib_tor.atom_type_1'')')
          CALL WRTSTR(IUN,MDOC,LINE,IERR)
          WRITE(LINE,'(''_lib_tor.atom_type_2'')')
          CALL WRTSTR(IUN,MDOC,LINE,IERR)
          WRITE(LINE,'(''_lib_tor.atom_type_3'')')
          CALL WRTSTR(IUN,MDOC,LINE,IERR)
          WRITE(LINE,'(''_lib_tor.atom_type_4'')')
          CALL WRTSTR(IUN,MDOC,LINE,IERR)
          WRITE(LINE,'(''_lib_tor.label'')')
          CALL WRTSTR(IUN,MDOC,LINE,IERR)
          WRITE(LINE,'(''_lib_tor.const'')')
          CALL WRTSTR(IUN,MDOC,LINE,IERR)
          WRITE(LINE,'(''_lib_tor.angle'')')
          CALL WRTSTR(IUN,MDOC,LINE,IERR)
          WRITE(LINE,'(''_lib_tor.period'')')
          CALL WRTSTR(IUN,MDOC,LINE,IERR)
          DO L=1,LET_NTORS
            WRITE(LINE,400) 
     *       LET_1ATM(L),LET_2ATM(L),LET_3ATM(L),LET_4ATM(L)
     *      ,LET_LABEL(L),LET_CONST(L),LET_ANGLE(L),LET_PRD(L)
  400       FORMAT(1X,A4,1X,A4,1X,A4,1X,A4,1X,A8,1X
     *             ,F8.3,1X,F8.3,1X,I5)
            CALL WRTSTR(IUN,MDOC,LINE,IERR)
          ENDDO
        ELSE
          WRITE(LINE,'(''# Number of tortions = 0'')')
          CALL MSGDOC(MDOC,LINE)
          RETURN
        ENDIF
        IF(LEW_NCONT.GT.0) THEN
          WRITE(LINE,'(''#'')')
          CALL WRTSTR(IUN,MDOC,LINE,IERR)
          WRITE(LINE,'(''# ---  VDW contacts ---'')')
          CALL WRTSTR(IUN,MDOC,LINE,IERR)
          WRITE(LINE,'(''#'')')
          CALL WRTSTR(IUN,MDOC,LINE,IERR)
          WRITE(LINE,'(''loop_'')')
          CALL WRTSTR(IUN,MDOC,LINE,IERR)

          WRITE(LINE,'(''_lib_vdw.atom_type_1'')')
          CALL WRTSTR(IUN,MDOC,LINE,IERR)
          WRITE(LINE,'(''_lib_vdw.atom_type_2'')')
          CALL WRTSTR(IUN,MDOC,LINE,IERR)
          WRITE(LINE,'(''_lib_vdw.energy_min'')')
          CALL WRTSTR(IUN,MDOC,LINE,IERR)
          WRITE(LINE,'(''_lib_vdw.radius_min'')')
          CALL WRTSTR(IUN,MDOC,LINE,IERR)
          WRITE(LINE,'(''_lib_vdw.H_flag'')')
          CALL WRTSTR(IUN,MDOC,LINE,IERR)

          DO I1=1,LEA_NATOM
          DO I2=1,I1

          DO L=1,LEW_NCONT

            IF(LEA_ANAME(I1).EQ.LEW_1ATM(L).AND.
     *          LEA_ANAME(I2).EQ.LEW_2ATM(L)) THEN

            WRITE(LINE,500) 
     *      LEW_1ATM(L),LEW_2ATM(L),LEW_EMIN(L),LEW_RMIN(L)
     *      ,LEW_HFLAG(L)
            CALL WRTSTR(IUN,MDOC,LINE,IERR)
            ELSE IF(LEA_ANAME(I1).EQ.LEW_2ATM(L).AND.
     *          LEA_ANAME(I2).EQ.LEW_1ATM(L)) THEN

            WRITE(LINE,500) 
     *      LEW_2ATM(L),LEW_1ATM(L),LEW_EMIN(L),LEW_RMIN(L)
     *      ,LEW_HFLAG(L)
  500       FORMAT(1X,A4,1X,A4,2X,F10.5,2X,F8.3,3X,A1)
            CALL WRTSTR(IUN,MDOC,LINE,IERR)

            ENDIF

          ENDDO

          ENDDO     
          ENDDO     

        ELSE
          WRITE(LINE,'(''#   Number of VDW contacts = 0'')')
          CALL MSGDOC(MDOC,LINE)
          RETURN
        ENDIF
        IF(LEH_NHBOND.GT.0) THEN
          WRITE(LINE,'(''#'')')
          CALL WRTSTR(IUN,MDOC,LINE,IERR)
          WRITE(LINE,'(''# ---  H-BONDS ---'')')
          CALL WRTSTR(IUN,MDOC,LINE,IERR)
          WRITE(LINE,'(''#'')')
          CALL WRTSTR(IUN,MDOC,LINE,IERR)
          WRITE(LINE,'(''loop_'')')
          CALL WRTSTR(IUN,MDOC,LINE,IERR)

          WRITE(LINE,'(''_lib_hbond.atom_type_1'')')
          CALL WRTSTR(IUN,MDOC,LINE,IERR)
          WRITE(LINE,'(''_lib_hbond.atom_type_2'')')
          CALL WRTSTR(IUN,MDOC,LINE,IERR)
          WRITE(LINE,'(''_lib_hbond.min'')')
          CALL WRTSTR(IUN,MDOC,LINE,IERR)
          WRITE(LINE,'(''_lib_hbond.dist'')')
          CALL WRTSTR(IUN,MDOC,LINE,IERR)

          DO I1=1,LEA_NATOM
          DO I2=1,I1

          DO L=1,LEH_NHBOND

            IF(LEA_ANAME(I1).EQ.LEH_1ATM(L).AND.
     *         LEA_ANAME(I2).EQ.LEH_2ATM(L)) THEN

            WRITE(LINE,600) 
     *      LEH_1ATM(L),LEH_2ATM(L),LEH_EMIN(L)
     *      ,LEH_DIST(L)
  600       FORMAT(1X,A4,1X,A4,1X,F8.3,1X,F8.3)
            CALL WRTSTR(IUN,MDOC,LINE,IERR)
            ELSE IF(LEA_ANAME(I1).EQ.LEH_2ATM(L).AND.
     *         LEA_ANAME(I2).EQ.LEH_1ATM(L)) THEN

            WRITE(LINE,600) 
     *      LEH_2ATM(L),LEH_1ATM(L),LEH_EMIN(L)
     *      ,LEH_DIST(L)
            CALL WRTSTR(IUN,MDOC,LINE,IERR)
            ENDIF

          ENDDO

          ENDDO
          ENDDO

        ELSE
          WRITE(LINE,'(''#   Number of H - bonds = 0'')')
          CALL MSGDOC(MDOC,LINE)
          RETURN
        ENDIF

        WRITE(LINE,'(''# ----------------------'')')
        CALL WRTSTR(IUN,MDOC,LINE,IERR)
      ELSE IF(MODE.EQ.'STOP') THEN
        IF(LEO_IUN.EQ.0) THEN
          CALL MSGERR(MDOC
     *    ,' ERROR: output "ener_lib.cif": can''t be closed')
          IERR=1
          RETURN
        ENDIF
        END FILE LEO_IUN
        LEO_IUN = 0
      ENDIF
C -----------------------------------
      RETURN
      END     
