      SUBROUTINE MTZ_PARAMS(LABIN_C,LABOUT_C,IERROR)
C
C---Reads relevant keywords for mtz file. Opens and reads 
C---some info from mtz file.
      IMPLICIT NONE
      INCLUDE 'refi_flags.fh'
      INCLUDE 'celsym.fh'
      INCLUDE 'agreem.fh'
      INCLUDE 'weights.fh'
      INCLUDE 'vitals.fh'
      INCLUDE 'const.fh'

      CHARACTER LABIN_C*(*),LABOUT_C*(*)
      INTEGER IERROR


      INTEGER MPARS
      PARAMETER (MPARS = 200)
      INTEGER MCOLS
      PARAMETER (MCOLS = 200)
      INTEGER IBEG(MPARS),IEND(MPARS),IDEC(MPARS),ITYP(MPARS)
      REAL FVALUE(MPARS)
      CHARACTER CVALUE(MPARS)*4
C
      CHARACTER LaueGroupName*10,Clabs(Mcols)*30,Ctyps(Mcols)*1

      INTEGER NLPRGI,NLPRGO
      INTEGER LOOKUP(MCOLS)
      COMMON /MTZRD/NLPRGI,NLPRGO,LOOKUP
      CHARACTER LSPRGI(MCOLS)*30,CTPRGI(MCOLS)*1,LSPRGO(16)*30,
     &          CTPRGO(16)*1
      COMMON /MTZRDC/LSPRGO,CTPRGO
      CHARACTER LSUSRJ(MCOLS)*30

  
      INTEGER ILMAX,ILPRGO,NFPART,NAPART,ITOK,IP,NTOK,I,J,IS
      INTEGER NumLaueSymm,JDO115,MTZIN,MTZOUT,IFAIL,NCOL,ILAB
      INTEGER IPRINT
      REAL SSTL,SMN,SMX
      REAL RRR(3,3,6),CELMTZ(6),CELL_T(6)
      CHARACTER KEY*4
      CHARACTER LINE1*128
      LOGICAL LPRINT,LEND
C 
C----Harvesting stuff
      INTEGER MSETS
      PARAMETER (MSETS = MCOLS)
      INTEGER NDATASETS,ISETS(MSETS),ISET,CSETID(MCOLS),CSETOUT(MCOLS),
     +          SETID
      REAL DATCELL,DATWAVE
      CHARACTER*64 PNAME,XNAME,DNAME,PNAME_OUT,XNAME_OUT,DNAME_OUT
      COMMON /MTZSET/ NDATASETS,PNAME(MSETS),XNAME(MSETS),DNAME(MSETS),
     +         PNAME_OUT(MCOLS),XNAME_OUT(MCOLS),DNAME_OUT(MCOLS),
     +         DATCELL(6,MSETS),DATWAVE(MSETS)
C
C---Data block
      DATA NLPRGI,LSPRGI/34,'H','K','L','FP','SIGFP','FREE',
     +     'FPART1','PHIP1','FPART2','PHIP2','FPART3','PHIP3',
     +     'HLA','HLB','HLC','HLD','FOM','PHIB',
     +     182*' '/
      DATA CTPRGI/'H','H','H','F','Q','I','F','P','F','P','F','P',
     +            'A','A','A','A','W','P',
     +    182*' '/
      DATA LookUp/-1,-1,-1,-1,-1,195*0/
      DATA NLPRGO,LSPRGO/0,'H','K','L','FP','SIGFP','FREE','FC','PHIC',
     +     'FWT','PHWT','DELFWT','PHDELWT','FOM','PHICOMB',' ',' '/
      DATA CTPRGO/'H','H','H','F','Q','I','F','P','F','P','F','P','W',
     +            'P',' ',' '/
C
      do i = 1,6
        celmtz(i) = 0.0
      enddo

      MTZIN  = 1
      NTOK = MPARS
      LPRINT = .FALSE.
      IF(LABIN_C.NE.' ') THEN
        CALL PARSER(KEY,LABIN_C,IBEG,IEND,ITYP,FVALUE,CVALUE,IDEC,NTOK,
     &            LEND,LPRINT)
        CALL LKYIN(1,LSPRGI,NLPRGI,NTOK,LABIN_C,IBEG,IEND)
        ITOK = 2
        CALL LKYSET(LSPRGI,NLPRGI,LSUSRJ,LOOKUP,ITOK,NTOK,LABIN_C,IBEG,
     &              IEND)
        ILMAX   = 5
        ILPRGO  = 5
        NFPART  = 0
        NAPART  = 0 
        NPART   = 0
        NSCPART = 0
c
c---Free_R factor
        IF (LOOKUP(6).NE.0) THEN
          FREER_FLAG = .TRUE.
C  Has Free R exclusion been set to something other than 0
          IF ( LFreeRexcludeVal .EQ.-999) LFreeRexcludeVal = 0
          ILPRGO = ILPRGO + 1
          ILMAX  = ILMAX + 1
        END IF
c
c---Fpart input?
        DO    IP=1,NMAXPART
          IF (LOOKUP(5+2*IP).NE.0.AND.LOOKUP(5+2*IP+1).NE.0) THEN
            FPART_FLAG = .TRUE.
            NPART      = NPART + 1
            IF( ISCPART(IP) .NE.0) NSCPART = NSCPART + 1
C  But this is not output - overwritten by map coefficients
            ILMAX = ILMAX + 2
          ELSEIF(LOOKUP(5+2*IP).NE.0.AND.LOOKUP(5+2*IP+1).EQ.0.OR.
     +           LOOKUP(5+2*IP).EQ.0.AND.LOOKUP(5+2*IP+1).NE.0) THEN
            WRITE(LINE1,'(A,I5,A)')
     +             ' Amplitude or phases for partial ',IP,
     +             ' structure has not been assigned. Ignore it'
            CALL ERRWRT(0,LINE1)
            LOOKUP(5+2*IP) = 0
            LOOKUP(6+2*IP) = 0
          END IF
        ENDDO
        IF(LOOKUP(6+2*NMAXPART+1).NE.0.AND.
     +                           LOOKUP(6+2*NMAXPART+2).NE.0) THEN
          MIR_FLAG = .TRUE.
          ILMAX    = ILMAX + 2
        ELSEIF(LOOKUP(6+2*NMAXPART+1).EQ.0.AND.
     +                           LOOKUP(6+2*NMAXPART+2).NE.0.OR.
     +         LOOKUP(6+2*NMAXPART+1).NE.0.AND.
     +                           LOOKUP(6+2*NMAXPART+2).EQ.0) THEN
            WRITE(LINE1,'(A)')
     +    ' A or B for MIR/MAD has not been assigned. Ingore it'
            CALL ERRWRT(0,LINE1)
        ENDIF
        IF(MIR_FLAG.AND.LOOKUP(6+2*NMAXPART+3).NE.0.AND.
     +                           LOOKUP(6+2*NMAXPART+4).NE.0) THEN
          ILMAX = ILMAX + 2
        ENDIF
        IF(LOOKUP(6+2*NMAXPART+5).NE.0.AND.LOOKUP(6+2*NMAXPART+6).NE.0) 
     +                  THEN
          PHASE_FLAG = .TRUE.
          ILMAX      = ILMAX + 2
        ELSEIF(LOOKUP(6+2*NMAXPART+5).EQ.0.AND. 
     +                               LOOKUP(6+2*NMAXPART+6).NE.0) THEN
            PHASE_FLAG = .TRUE.
            ILMAX = ILMAX + 1
            CALL ERRWRT(0,
     +              'Figure of merit of phases has not been assigned')
            CALL ERRWRT(0,'They will be assumed to be equal to 1.0')
        ENDIF
      ENDIF
 500  CONTINUE
      LPRINT = .FALSE.
      IPRINT = 0
      IFAIL  = 0
      CALL LROPEN(MTZIN,'HKLIN',IPRINT,IFAIL)
      IF(IFAIL.GT.0) CALL ERRWRT(1,' Reflection file ')
      CALL LRASSN(MTZIN,LSPRGI,NLPRGI,LOOKUP,CTPRGI)
      CALL LRCLAB(MTZIN,CLABS,CTYPS,NCOL)
CMDW-4.2      CALL LRID(MTZIN,PNAME,DNAME,ISETS,NDATASETS)
C     Notify available space
cMDW-5.0      NDATASETS = MSETS
CMDW-5.0      CALL LRIDX(MTZIN,PNAME,XNAME,DNAME,ISETS,
CMDW-5.0     +             DATCELL,DATWAVE,NDATASETS)
C
C---- Get dataset ID for column and match to dataset header info.
      IF (NDATASETS.GT.0) CALL LRCLID(MTZIN,CSETID,NCOL)
C
C---- Copy over FP SIGFP information for output if required
      LSPRGO(4) = CLABS(LookUp(4))
      LSPRGO(5) = CLABS(LookUp(5))
      CTPRGO(4) = CTYPS(LookUp(4))
      CTPRGO(5) = CTYPS(LookUp(5))
      IF (NDATASETS.GT.0) THEN
        CSETOUT(1) = CSETID(LookUp(1))
        CSETOUT(2) = CSETID(LookUp(2))
        CSETOUT(3) = CSETID(LookUp(3))
        CSETOUT(4) = CSETID(LookUp(4))
        CSETOUT(5) = CSETID(LookUp(5))
      ENDIF
C
C----   Is FreeRFlag  set
      ILPRGO = 14
      NLPRGO = ILPRGO
      IF (LookUp(6).NE.0) THEN
        LSPRGO(6) = CLABS(LookUp(6))
        CTPRGO(6) = CTYPS(LookUp(6))
C  The FreeRflag should belong to the base data set
        IF (NDATASETS.GT.0) CSETOUT(6) = CSETID(LookUp(1))
      END IF
C
      IF((.NOT.MIR_FLAG).AND.(.NOT.PHASE_FLAG)) THEN
C
C-----Knock off the PHICOMB label
        ILPRGO = ILPRGO-1
      ENDIF
C
C---Add users coefficients.
      if(scale_map_calc.gt.0.0.or.scale_map_obs.gt.0.0) then
        ilprgo = ilprgo + 1
        LSPRGO(ilprgo) = 'F_user'
        CTRPGO(ilprgo) = 'F'
        ilprgo = ilprgo + 1
        LSPRGO(ilprgo) = 'PHI_user'
        CTPRGO(ilprgo) = 'P'
        nlprgo = nlprgo + 1
      endif

C
C---- Move  FC PHIC WWT DELFWT PHICOMB labels if No FreeRflag
      IF (LookUp(6).EQ.0) THEN
        DO    ILAB = 6,NLPRGO-1
          LSPRGO(ILAB) = LSPRGO(ILAB+1)
          CTPRGO(ILAB) = CTPRGO(ILAB+1)
        ENDDO
        ILPRGO = ILPRGO-1
        NLPRGO = ILPRGO
      END IF 
C
C  Now for output if requested: File opened in SR oppro
      IF( LABOUT_C .NE. ' ') THEN
        MTZOUT = 2
C
C---  NLPRGO = 12 if Free set; otherwise 11
        NLPRGO    = ILPRGO
C
C----In case LSQ we have only 7 or 8 output labels
        IF(REFS.EQ.'LSQF') THEN
          NLPRGO = 8
          IF(LookUp(6).EQ.0) NLPRGO = 7
        ENDIF
        CALL PARSER(KEY,LABOUT_C,IBEG,IEND,ITYP,FVALUE,CVALUE,IDEC,
     &                NTOK,LEND,.FALSE.)
        CALL LKYOUT(MTZOUT,LSPRGO,NLPRGO,NTOK,LABOUT_C,IBEG,IEND)
      END IF

      IF (NDATASETS.GT.0) THEN
        DO ILAB = 7,NLPRGO
C----All new columns inherit dataset of FP
          CSETOUT(ILAB) = CSETID(LookUp(4))
        ENDDO
        DO JDO115 = 1,NLPRGO
          SETID = CSETOUT(JDO115)
          DO ISET = 1,NDATASETS
            IF (ISETS(ISET).EQ.SETID) THEN
              PNAME_OUT(JDO115) = PNAME(ISET)
              XNAME_OUT(JDO115) = XNAME(ISET)
              DNAME_OUT(JDO115) = DNAME(ISET)
              do i=1,6
                celmtz(i) = datcell(i,iset)
              enddo
            END IF
          ENDDO
        ENDDO
      END IF

      CALL LRSORT(MTZIN,ISORT)
c Cell is selected from datasets, see above. Just use lrcell in case
c no dataset information.
      if (celmtz(1).eq.0.0) then
        call lrcell(mtzin,celmtz)
      endif
C
C---If cell dimensions are different keep old cells
C---If there were no cells take new one)
      DO    I=1,6
         CELL_T(I) = CELMTZ(I)
      ENDDO
      CALL CHECK_CELL(CELL_T,IERROR)
      IF(IERROR.EQ.3) THEN
        CALL ERRWRT(1,'Difference between cells from mtz and previous'
     &          //' ones is more than 10% ' )
      ENDIF
      CALL LSTRSL(MTZIN,CELMTZ(1),CELMTZ(2),CELMTZ(3),
     +           CELMTZ(4),CELMTZ(5),CELMTZ(6))
C
C  Return CELL volume, and reciprocal cell for celsym.fh
      DO   I=1,6
        CELL_T(I) = CELL(I)
      ENDDO

      IF(CELL(4).LE.5.0.AND.CELL(5).LE.5.0.AND.CELL(6).LE.5.0) THEN
         CELL_T(4) = CELL(4)*RTODEG
         CELL_T(5) = CELL(5)*RTODEG
         CELL_T(6) = CELL(6)*RTODEG
      ENDIF
      CALL RBFRO1(CELL_T,VOLUME,RRR)
      CALL RBRCEL(RCELL,RVOL)
C
C---Read resolution
      CALL LRRSOL(MTZIN,SMN,SMX)
      SMN = SQRT(SMN)/2.0
      SMX = SQRT(SMX)/2.0
      IF(STLMIN.LE.0.0) STLMIN = SMN
      IF(STLMIN.LT.SMN) STLMIN = SMN
      IF(STLMAX.LE.0.0) STLMAX = SMX
      IF(STLMAX.GT.SMX) STLMAX = SMX
C   Scaling resolution: if not set on data line use full resolution range
      IF(SMINS.EQ.0.04 .AND. SMAXS .EQ.1.0) THEN
        SMINS = STLMIN
        SMAXS = STLMAX
      END IF
C   If a Range set for analysis, work out the number of bins now.
      SSTL = 4.0*STLMAX*STLMAX
      IF(RANGE.LT.-0.5) THEN
         RANGE = SSTL/NBIN
      END IF
C
C---Read symmetry and check against old symmetry. MTZ symmetry has 
C---highest priorety
      ISPNO = 1
      LPRINT = .FALSE.
      CALL LRSYMI(MTZIN,NumPrimSymm,Ltype,NumSpaceGroup,
     +                  SpaceGroupName,PointGroupName)
      CALL LRSYMM(MTZIN,NumSymmetry,RealSymmMatrx)
      CALL PGDEFN(PointGroupName,NumPrimSymm,NumSymmetry,
     +                 RealSymmMatrx,LPRINT)
      CALL PGNLAU(PointGroupName,NumLaueSymm,LaueGroupName)
C
C---- Now set up the extinction check for soutfC
      CALL EPSLN(NumSymmetry,
     +             NumPrimSymm,
     +              RealSymmMatrx,
     +               0)
      CALL CENTRIC(NumSymmetry,
     +               RealSymmMatrx,
     +                0)
      NSMULT = NumSymmetry/NumPrimSymm
C
C---Compare symmetry
      IF(ISPNO.GT.1) THEN
        IF(ISPNO.NE.NumSpaceGroup) THEN
          CALL ERRWRT(0,'Space group from mtz is different ')
        ENDIF
      ELSE
        DO    IS=1,NumSymmetry
          DO    I=1,3
            DO    J=1,3
              ROT(I,J,IS) = RealSymmMatrx(I,J,IS)
            ENDDO
            TR(I,IS)   = RealSymmMatrx(I,4,IS)
          ENDDO
        ENDDO
        NSYM  = NumSymmetry
        ISPNO = NumSpaceGroup
      END IF
      CALL TKNONCUB

      RETURN
      END
