C
C
C     This code is distributed under the terms and conditions of the
C     CCP4 licence agreement as `Part 2' (Annex 2) software.
C     A copy of the CCP4 licence can be obtained by writing to the
C     CCP4 Secretary, Daresbury Laboratory, Warrington WA4 4AD, UK.
C
C
C
      SUBROUTINE NEWENTRY_IDEALISE
C
C---Subroutine for refinement with diagonal approximation
      IMPLICIT NONE
      INCLUDE 'atom_com.fh'
      INCLUDE 'pls_incl.fh'
      INCLUDE 'celsym.fh'
      INCLUDE 'refi_flags.fh'
      INCLUDE 'agreem.fh'
      INCLUDE 'const.fh'
      INCLUDE 'weights.fh'
      INCLUDE 'vitals.fh'
      INCLUDE 'tls.fh'
      INCLUDE 'makecif.fh'
C
C----These arrays should be controlled dynamicly as they depend 
C----on coordinates
      REAL AM,V,DV
      INTEGER NE,NZZ,NWTB
      COMMON /LSQMTX/ AM( QQM),V( QQV),DV( QQV)
      COMMON /DISTNS/ NE( QQD),NZZ( QQD),NWTB( QQD)
C
C---Local variables
      INTEGER IA
      REAL WV_SAVE,WA_SAVE
C
C---report about type of refinement and so on
C----------------------------------------------------
C-------------------------------------------------
c 
      REFID = 'IDEA'
      MAKE_CHECK = '0'
      CALL SET_HKON_FLAGS
C
c---Save vital parameters
      CALL SAVE_VITAL
      GEOM_FLAG  = .TRUE.
      X_RAY_FLAG = .FALSE.

      IF(.NOT.X_RAY_FLAG) THEN
C
C---If we are not going to refine 
        ITEMP = 0
        NOCC  = 0
      ENDIF
      IF(.NOT.GEOM_FLAG) THEN
        NDIS = 0
        NBIS = 0
        NVDW = 0
      ENDIF
C
c---Add these variables to vitals.fh
      NVPOS = 0
      NMPOS = 0
      NVOCC = 0
      NMOCC = 0
      NVTMP = 0
      NMTMP = 0
C
C---Find number of variables and second derivative matrix elements
C---for different type of parameters
      DO    IA=1,N_ATOM
        IF(ATOM_REF_FLAG(IA).GT.0) THEN
          NVPOS = NVPOS + 3
          NMPOS = NMPOS + 6
          IF(IOCCUP.GT.0) THEN
            NVOCC = NVOCC + 1
            NMOCC = NMOCC + 1
          ENDIF
          IF(ITEMP.NE.0) THEN
            IF(U_ANISO(2,IA).EQ.0.0) THEN
              NVTMP = NVTMP + 1
              NMTMP = NMTMP + 1
            ELSE
              NVTMP = NVTMP + 6
              NMTMP = NMTMP + 21
            ENDIF
          ENDIF
        ENDIF
      ENDDO
      NVALL = NVPOS + NVOCC + NVTMP   
c
C---Begin refinement cycles
C
C---Memory allocation should be done here
      IF(NCCREF.LE.5) NCCREF = 13
      WV_SAVE = WVSKAL
      WVSKAL  = 20.0
      CALL CGSPARCE
      WVSKAL = WV_SAVE
      WA_SAVE = WASKAL
      WASKAL = 10.0
      CALL CGSPARCE
      WASKAL = WA_SAVE
      CALL CGSPARCE

C
cd      CALL UGTENV('XYZOUT',NAMEC)
cd      PATHC = ' '
cd      EXTC  = ' '
cd      MDOC  = 0
cd      CALL WRITE_ATOMS(MDOC,PATHC,NAMEC,EXTC,IERROR)
cd      IF(IERROR.GT.0) THEN
cd        CALL ERRWRT(-1,'Write atoms failed in HKON')
cd        CALL ERRWRT(1,
cd     +           'FATAL ERROR. Check if you have specified filename')
cd      ENDIF
cd      CALL ADD_SCALE_CONTR

      RETURN
      END
