C
C
C     This code is distributed under the terms and conditions of the
C     CCP4 licence agreement as `Part 2' (Annex 2) software.
C     A copy of the CCP4 licence can be obtained by writing to the
C     CCP4 Secretary, Daresbury Laboratory, Warrington WA4 4AD, UK.
C
C
      SUBROUTINE OPPRO
C
C----Subroutine to read parameters of model
C----In the current version this routine uses Alexei's routines
C----to read mmCIF file. 
      INCLUDE 'crd_com.fh'
      INCLUDE 'atom_com.fh'
      INCLUDE 'celsym.fh'
      INCLUDE 'const.fh'
      INCLUDE 'refi_flags.fh'
      INCLUDE 'makecif.fh'
      INCLUDE 'ncs_rest.fh'
      include 'anom_params.fh'
C
C--Local variables and arrays
      REAL A(4),B(4),CU(2),MO(2)
C
C--Will be deleted
      CHARACTER LINE*128
      integer ir,i,is,ierr
C
C---Read coordinates from mmCIF file
      IERR = 0
      IF(REFID.NE.'UNRE') THEN
        CALL MAKECIF_REFMAC
      ELSE
        CALL READ_ATOMS_REFMAC
      ENDIF

      IF(BSET_DEFAULT_FLAG) CALL RESET_BVALUES
C
C---Treat NCS if it has been defined
      IF(NUMBER_NCSR.GT.0..AND.REFID.EQ.'REST') CALL NCSR_EQUAVALENCES
      IF(NUMBER_NCSC.GT.0..AND.REFID.EQ.'REST') CALL NCSC_EQUAVALENCES

C
C---Read form factors of atoms. 
      NG    = 5
      NGAUS = 5
      IF(CS_NSFATM.LE.0) CALL ERRWRT(1,'No Scatterers')
      DO    IS=1,CS_NSFATM
        IFAIL = -1
        CALL SFREAD2(CS_ELEMENT(IS),NG,A,B,C,IWT,IELEC,CU,
     +              MO,IFAIL)
         IF(IFAIL.LT.0) 
     +       CALL ERRWRT(1,' No match for ATOM ID'//CS_ELEMENT(IS))
         DO   I=1,4
           CS_A(I,IS) = A(I)
           CS_B(I,IS) = B(I)
         ENDDO
         CS_A(5,IS)   = C
         CS_B(5,IS)   = 0.0
         CS_FI(IS)    = CU(1)
         CS_FII(IS)   = CU(2)
         CS_NELEC(IS) = IELEC
         if(nform_ano.gt.0) then
            do  i=1,nform_ano
               if(cs_element(is).eq.ano_elem(i)) then
                  cs_fi(is) = fprime(i)
                  cs_fii(is) = f2prime(i)
                  cs_a(1,is) = cs_a(1,is) + fprime(i)
               endif
            enddo
         endif
      ENDDO
C
C---Prepare form factors for second derivative matrices
C
C---Make Gaussians for squared atoms to calculate hessians
C
C----First for square of same atoms
C----WARNING!!!!!
C----Here we define only for same atoms convolution. It is
C----enough for diag calculation. For nondiag other kind of convolution
C----should be calculated also
      NGAUS2 = NGAUS*(NGAUS+1)/2
      DO     ISCAT=1,CS_NSFATM
        IGG = 0
        DO     IG1=1,NGAUS
          DO    IG2=IG1,NGAUS
            CC = 2.0
            IF(IG1.EQ.IG2) CC = 1.0
            IGG = IGG+1
            CS_AA(IGG,ISCAT) = CC*CS_A(IG1,ISCAT)*CS_A(IG2,ISCAT)
            CS_BB(IGG,ISCAT) = CS_B(IG1,ISCAT) + CS_B(IG2,ISCAT)
          ENDDO
        ENDDO
      ENDDO
C
C---CIF
      CALL ERRWRT(-1,' ')
      CALL ERRWRT(-1,' ')
      CALL ERRWRT(-1,' loop_')
      CALL ERRWRT(-1,'     _atom_type_symbol')
      CALL ERRWRT(-1,'     _atom_type_scat_Cromer_Mann_a1')
      CALL ERRWRT(-1,'     _atom_type_scat_Cromer_Mann_b1')
      CALL ERRWRT(-1,'     _atom_type_scat_Cromer_Mann_a2')
      CALL ERRWRT(-1,'     _atom_type_scat_Cromer_Mann_b2')
      CALL ERRWRT(-1,'     _atom_type_scat_Cromer_Mann_a3')
      CALL ERRWRT(-1,'     _atom_type_scat_Cromer_Mann_b3')
      CALL ERRWRT(-1,'     _atom_type_scat_Cromer_Mann_a4')
      CALL ERRWRT(-1,'     _atom_type_scat_Cromer_Mann_b4')
      CALL ERRWRT(-1,'     _atom_type_scat_Cromer_Mann_c')
      CALL ERRWRT(-1,' ')
      CALL ERRWRT(-1,' ')
      DO    ISC = 1,CS_NSFATM
         WRITE(LINE,'(2X,A4,9F9.4)')CS_ELEMENT(ISC),(CS_A(II,ISC),
     +                 CS_B(II,ISC),II=1,4),CS_A(5,ISC)
         CALL ERRWRT(-1,LINE)
      ENDDO
      CALL ERRWRT(-1,' ')
      CALL ERRWRT(-1,' ')
C
C---Any other things. like check symmetry and so on
C
C---Restraints should be read and prepared here
c      if(excl_refi_flag) then
c        call prepare_excl_refi
c      endif
      IF(REFID.EQ.'REST'.OR.REFID.EQ.'IDEA') then
        CALL READ_RESTR
      ENDIF
C
C---Read some chemical information about atoms in the coordiante file
      CALL READ_STR_REFMAC
C
      RETURN
      END
C
      SUBROUTINE RESET_BVALUES
C
C---Sets B values to predefined values. Could be extended to reset
C---b values for predefined residues or atoms (using atom selection)
      IMPLICIT NONE
      INCLUDE 'atom_com.fh'
      INCLUDE 'refi_flags.fh'
C
      INTEGER IA
C
      DO   IA = 1,N_ATOM
        IF(U_ANISO(2,IA).LE.0.0) THEN
C
C---Isotropic atom
          U_ANISO(1,IA) = UDefault_Ind
        ELSE
          U_ANISO(1,IA) = UDefault_Ind
          U_ANISO(2,IA) = UDefault_Ind
          U_ANISO(3,IA) = UDefault_Ind
          U_ANISO(4,IA) = UDefault_Ind
          U_ANISO(5,IA) = UDefault_Ind
          U_ANISO(6,IA) = UDefault_Ind
        ENDIF
      ENDDO

      RETURN
      END
C
      SUBROUTINE CHECK_SYMMETRY(NSPGRP,SPGRP,NSYM_IN,ROT_IN,VECT_IN,
     &                 IERROR)
      IMPLICIT NONE
      INCLUDE 'celsym.fh'
      INTEGER NSPGRP,IERROR,NSYM_IN
      REAL ROT_IN(3,3,*),VECT_IN(3,*)
      CHARACTER SPGRP*(*)

      INTEGER I,J,IS
      INTEGER LENSTR

      IERROR = 0
C
C--First check if space group numbers are same
C
      IF(ISPNO.LT.1.AND.NSPGRP.GE.1) THEN
C
C---Symmetry has not been defined previously. Use new symmetry
        DO    IS=1,NSYM_IN
          DO   J=1,3
            DO   I=1,3
              RealSymmMatrx(I,J,IS) = ROT_IN(I,J,IS)
            ENDDO
            RealSymmMatrx(J,4,IS) = VECT_IN(J,IS)
            RealSymmMatrx(4,J,IS) = 0.0
          ENDDO
          RealSymmMatrx(4,4,IS) = 1.0
        ENDDO
        NumSymmetry = NSYM_IN
        ISPNO = NSPGRP
        SpaceGroupName = SPGRP(1:LENSTR(SPGRP))
        IERROR = 0
        RETURN
      ELSEIF(ISPNO.GT.1.AND.NSPGRP.LE.1) THEN
C
C---There is no new symmetry. But old symmetry has been defined. Use old
C---symmetry
        DO   IS=1,NumSymmetry
          DO    J=1,3
            DO   I=1,3
              ROT_IN(I,J,IS) = RealSymmMatrx(I,J,IS)
            ENDDO
            VECT_IN(J,IS) = RealSymmMatrx(J,4,IS)
          ENDDO
        ENDDO
        NSYM_IN = NumSymmetry
        NSPGRP = ISPNO
        SPGRP  = SpaceGroupName(1:LENSTR(SpaceGroupName))
        IERROR = 1
        RETURN
      ELSEIF(ISPNO.NE.NSPGRP) THEN
C
C---Space group names are different. It is serious error
        IERROR = 2
        RETURN
      ELSE
C
C---Space group number is same. Check and make other parameters
c---of symmetry consistent with each other

      ENDIF

      END
C
      SUBROUTINE CHECK_CELL(CELL_IN,IERROR)
C
c---this routine checks if new cell and that from celsym.fh (previously
C---read cell) are consistent.If not then changes cell parameters accordingly
      IMPLICIT NONE
      INCLUDE 'celsym.fh'

      INTEGER IERROR
      REAL CELL_IN(6)
C
C---local varaibles
      INTEGER I
      REAL DELTA_C,DELTA_A,DENUM_C,DENUM_A,EPS_LOCAL,CELL_TOL1,
     &     DELTA_C1,CELL_TOL2
      REAL DEGTOR
      DATA EPS_LOCAL/1.0E-8/,CELL_TOL1/0.01/,CELL_TOL2/0.1/
      DATA DEGTOR/0.017453293/
C
c---Makecif wants cell angles in radians
      IF(CELL(4).GT.5.0.AND.CELL(5).GT.5.0.AND.CELL(6).GT.5.0) THEN
        CELL(4) = CELL(4)*DEGTOR
        CELL(5) = CELL(5)*DEGTOR
        CELL(6) = CELL(6)*DEGTOR
      ENDIF
C
      IF(CELL_IN(4).GT.5.0.AND.CELL_IN(5).GT.5.0
     &                    .AND.CELL_IN(6).GT.5.0) THEN
         CELL_IN(4) = CELL_IN(4)*DEGTOR
         CELL_IN(5) = CELL_IN(5)*DEGTOR
         CELL_IN(6) = CELL_IN(6)*DEGTOR
      ENDIF
C
C---First check if we have already cell
      IERROR = 0
      DELTA_C = CELL_IN(1)**2 + CELL_IN(2)**2 + CELL_IN(3)**2+
     &          CELL_IN(4)**2 + CELL_IN(5)**2 + CELL_IN(6)**2
      DELTA_C1 = CELL(1)**2 + CELL(2)**2 + CELL(3)**2+CELL(4)**2
     &         +CELL(5)**2 + CELL(6)**2
      IF(SQRT(DELTA_C).LE.EPS_LOCAL) THEN
C
C---There is no cell parameters. Use old ones
        IERROR = 1
        DO   I=1,6
          CELL_IN(I) = CELL(I)
        ENDDO
      ELSEIF(DELTA_C1.LE.EPS_LOCAL) THEN
C
C---There was no cell. Use new one
        IERROR = 1
        DO   I=1,6
          CELL(I) = CELL_IN(I)
        ENDDO
      ELSE
C
C---We had cell. Now check if they agree
        DELTA_C = SQRT((CELL(1)-CELL_IN(1))**2 + (CELL(2)-CELL_IN(2))**2
     &                +(CELL(3)-CELL_IN(3))**2)
        DENUM_C = AMAX1(CELL(1),CELL_IN(1))+AMAX1(CELL(2),CELL_IN(2))+
     &            AMAX1(CELL(3),CELL_IN(3))
        DELTA_A = SQRT((CELL(4)-CELL_IN(4))**2 + (CELL(5)-CELL_IN(5))**2
     &                +(CELL(6)-CELL_IN(6))**2)
        DENUM_A = AMAX1(CELL(4),CELL_IN(4))+AMAX1(CELL(5),CELL_IN(5))+
     &            AMAX1(CELL(6),CELL_IN(6))
        IF(DELTA_C/DENUM_C.LE.CELL_TOL1.AND.
     &     DELTA_A/DENUM_A.LE.CELL_TOL1) THEN
C
c---Difference in cell dimensions is less than 1%. No worries. Make them 
C---equal
          IERROR = 0
          DO    I=1,6
            CELL_IN(I) = CELL(I)
          ENDDO
        ELSEIF(DELTA_C/DENUM_C.LE.CELL_TOL2.AND.
     &         DELTA_A/DENUM_A.LE.CELL_TOL2) THEN
C
C---Difference is less than 10 more than 1%. Use previous cell. 
          IERROR = 2
          DO    I=1,6
            CELL_IN(I) = CELL(I)
          ENDDO
        ELSE
C
C---Difference is more than 10%. Use previous cell. But it is serious. 
C---Outside this routine error should be reported
          IERROR = 3
          DO   I=1,6
            CELL_IN(I) = CELL(I)
          ENDDO
        ENDIF
      ENDIF
      RETURN
      END
C
      SUBROUTINE MAKECIF_REFMAC
C
      IMPLICIT NONE
      INCLUDE 'celsym.fh'
      INCLUDE 'atom_com.fh'
      INCLUDE 'makecif.fh'
      INCLUDE 'const.fh'
      INCLUDE 'monitor.fh'
C
C---This routine calls makecif. makecif reads coordinate file
C---and creates restraint list. If hydrogens should be restored
C---then makecif is called twice. First call to find positions
C---of hydrogens and second call to find restraint list. Same is
C---if any other absent atoms needed to be restored.
      REAL CELL_C(6)
      CHARACTER IN_COORD_FILE*256,SCRATCH*256,
     &          OUT_FILE_CIF*256,MAKE_PROG_NAME*20,LIST_MAKE*1
      CHARACTER DICT_PATH*250
      CHARACTER MAKE_FSTOP*1
      INTEGER IERR,MDOC,IN_FILE,IFAIL,LL,NSPGRP,I,IUNIT,IERROR,IRUN
      LOGICAL LEXISTS
      INTEGER LENSTR
      EXTERNAL LENSTR

      IRUN = 1
      MDOC = -999
      CALL UGTENV('XYZIN',IN_COORD_FILE)
      CALL UGTENV('TEMP1',SCRATCH)
      OUT_FILE_CIF = SCRATCH(1:LENSTR(SCRATCH))//'_new'
      MAKE_PROG_NAME    = 'refmac'
      CALL UGTENV('CLIBD_MON',DICT_PATH)
      IF(DICT_PATH.EQ.' ') CALL UGTENV('CDIC_REFMAC',DICT_PATH)
      IF(DICT_PATH.EQ.' ') THEN
cpjx  MAKECIFLIB would be set in temp_makecif_path.fh
cpjx  but this is unsafe e.g. portability problems.
cpjx        MAKE_PROG_LIB_PATH = MAKECIFLIB(1:LENSTR(MAKECIFLIB))
cpjx  Instead fail if the dictionary path isn't set
        CALL errwrt(1,'No path for dictionary files!')
      ELSE
        MAKE_PROG_LIB_PATH =DICT_PATH(1:LENSTR(DICT_PATH))
      ENDIF
C
C---If we have cell and symmetry then use it
      NSPGRP = ISPNO
      DO   I=1,6
         CELL_C(I) = 0.0
      ENDDO
      IF(CELL(1)*CELL(2)*CELL(3).GT.1) THEN
         DO  I=1,6
           CELL_C(I) = CELL(I)
         ENDDO
        IF(CELL(4).LT.5.0.OR.CELL(5).LT.5.0
     &                    .OR.CELL(6).LT.5.0) THEN
          CELL_C(4) = CELL_C(4)/DEGTOR
          CELL_C(5) = CELL_C(5)/DEGTOR
          CELL_C(6) = CELL_C(6)/DEGTOR
        ENDIF
      ENDIF
      LIST_MAKE = 'M'
      CALL UGTENV('LIBIN',MAKE_FILE_LIB2)
      IF(MAKE_FILE_LIB2.EQ.' ') CALL UGTENV('LIB_IN',MAKE_FILE_LIB2)

      CALL UGTENV('LIBOUT',MAKE_LIB_OUT)
      IF(MAKE_LIB_OUT.EQ.' ') CALL UGTENV('LIB_OUT',MAKE_LIB_OUT)
      IF(MAKE_LIB_OUT.EQ.' ') 
     &   MAKE_LIB_OUT = SCRATCH(1:LENSTR(SCRATCH))//'_lib.cif'
      IF(MON_STYLE.EQ.'MANY') LIST_MAKE = 'L'
C
c---Undocumented option.
      IF(MON_STYLE.EQ.'TEST') LIST_MAKE = 'T'
      MAKE_NEW_FLAG = ' '
      IERR          = 0
      CALL MAKECIF(MDOC,IN_COORD_FILE,OUT_FILE_CIF,MAKE_FILE_LIB2
     *  ,MAKE_CUTOFF,MAKE_DMIN_SPEC,MAKE_CONN_FLAG,MAKE_CIS_FLAG
     &  ,MAKE_LNK_FLAG,MAKE_CHAIN_FLAG,MAKE_PEPT_FLAG,MAKE_CHECK_SPEC
     &  ,MAKE_HFLAG,MAKE_RFLAG,MAKE_FORM,MAKE_SYMM_FLAG,MAKE_SS_FLAG
     &  ,MAKE_SUGAR_FLAG,LIST_MAKE,MAKE_CHECK,MAKE_NEWL_VALUE_FLAG
     &  ,MAKE_SRCH_FLAG
     &  ,make_segid_in_flag,MAKE_PROG_LIB_PATH,MAKE_LIBS_PATH
     &  ,MAKE_LIBS_NAME,MAKE_LIBS_EXT
     &  ,MAKE_PROG_NAME,NSPGRP,CELL_C,MAKE_LIB_OUT,MAKE_NEW_FLAG
     &  ,MAKE_FSTOP,IERR)
C
C---Check if cell parameters from mtz and from pdb are consistent.
      CALL CHECK_CELL_FROM_MAKECIF(IERR)

C
      DO   I=1,6
        CELL_C(I) = 0.0
      ENDDO
      IF(N_ATOM.LE.0) THEN
        CALL ERRWRT(-1,'Number of atoms in the input file is 0')
        CALL ERRWRT(-1,'Input pdb file seems to be empty')
        CALL ERRWRT(1,'Check input coordinates')
      ENDIF
      IF(N_ATOM.GT.MAXATOM) THEN
        CALL ERRWRT(-1,'Too many atoms in the input coordinate file')
        CALL ERRWRT(-1,'It may happen because of hydrogen generations')
        CALL ERRWRT(-1,'Change MAXATOM in "atom_com.fh" and recompile'
     &    //' the program')
        CALL ERRWRT(1,'Too many atoms in the input file')
      ENDIF
      IF(IERR.EQ.6) THEN
        CALL ERRWRT(-1,' ')
        CALL ERRWRT(-1,' ')
        CALL ERRWRT(-1,'There is an error in the input coordinate file')
        CALL ERRWRT(-1,'At least one the chains has 2 residues with the'
     &    //' same number')
        CALL ERRWRT(-1,'Check above to see error')
        CALL ERRWRT(1,'Problem with coordinate file')
      ENDIF
C
C---Exit if nothing else is required
cd      IF(MAKE_LIGAND_LEVEL_FLAG.EQ.'H'.AND.MAKE_NEW_FLAG.EQ.'Y') THEN
      IF(MAKE_LIGAND_LEVEL_FLAG.EQ.'H'.AND.MAKE_FSTOP.EQ.'Y') THEN
        CALL WRITE_ATOMS_REFMAC
        CALL ERRWRT(-1,' ')
        CALL ERRWRT(-1,'Important, Important, Important!!!!!')
        CALL ERRWRT(-1,' ')
        CALL ERRWRT(-1,'Your coordinate file has a ligand which has'
     &    //' either minimum or no description in the library')
        CALL ERRWRT(-1,'A new ligand description has been added to '//
     &      MAKE_LIB_OUT(1:LENSTR(MAKE_LIB_OUT)))
        CALL ERRWRT(-1,'Picture of the new ligand can be viewed using '
     &   //'postscript file. See above')
        CALL ERRWRT(-1,'Check description in this file and, if'
     &    //' satisfied, use it as the input library')
        CALL ERRWRT(-1,'Otherwise either edit bond orders manually'
     &    //' or use CCP4i Sketcher to view and edit the ligand')
        CALL ERRWRT(-1,'and create a library entry by running libcheck')
        CALL ERRWRT(-1,'It is strongly recommended that dictionary '
     &   //' entry should be checked carefully before using it')
        CALL ERRWRT(-1,'If you are happy with the library description '
     &   //'then use the keyword (MAKE CHECK NONE)')
        CALL ERRWRT(-1,'I.e. do not check correctness'
     &   //' of the coordinates ')
C
C---Something about postscript file
        CALL errwrt(1,'New ligand has been encountered. Stopping now')
      ELSEIF(MAKE_NEW_FLAG.EQ.'Y'.AND.MAKE_FSTOP.EQ.'Y') THEN
        MAKE_FILE_LIB2 = MAKE_LIB_OUT
        MAKE_LIB_OUT = SCRATCH(1:LENSTR(SCRATCH))//'_lib1.cif'
        ierr = 0
        write(*,*)make_file_lib2
      ENDIF
      
C
C---General errors
      IF(IERR.GT.0) THEN
        WRITE(*,*)'IERR = ',IERR
        CALL ERRWRT(-1,' ')
        CALL ERRWRT(-1,'There is error. See above')
        CALL ERRWRT(1,'Fatal error. Cannot continue')
      ENDIF
      IF(MAKE_HFLAG.NE.'A'.AND.MAKE_RFLAG.NE.'Y') GOTO 200
      STRUCT_FILE    = OUT_FILE_CIF(1:LENSTR(OUT_FILE_CIF))//'.str'
      INQUIRE (FILE=STRUCT_FILE(1:LENSTR(STRUCT_FILE)),EXIST=LEXISTS)
      IF(LEXISTS) THEN
        IFAIL = -1
        IUNIT = 0
        CALL CCPDPN(IUNIT,STRUCT_FILE(1:LENSTR(STRUCT_FILE)),
     &          'UNKNOWN','U',LL,IFAIL)
        CLOSE(IUNIT,STATUS='DELETE')
      ENDIF
C
c---Do not run second time if no hydrogens are needed
      IRUN = IRUN + 1
C
C---Now check if space group and symmetry were present in the coordinate file   
      LIST_MAKE = 'S'
      IF(MAKE_HFLAG.EQ.'A') MAKE_HFLAG = 'Y'
      IF(MAKE_RFLAG.EQ.'Y') MAKE_RFLAG = 'N'
      MAKE_CHECK     = '0'
      MAKE_CONN_FLAG = '0'
      MAKE_LNK_FLAG  = '0'
      IERR       = 0
      IN_COORD_FILE = OUT_FILE_CIF(1:LENSTR(OUT_FILE_CIF))//'.crd'
      OUT_FILE_CIF  = SCRATCH(1:LENSTR(SCRATCH))//'_new1'
      CALL MAKECIF(MDOC,IN_COORD_FILE,OUT_FILE_CIF,MAKE_FILE_LIB2
     &  ,MAKE_CUTOFF,MAKE_DMIN_SPEC,MAKE_CONN_FLAG,MAKE_CIS_FLAG
     &  ,MAKE_LNK_FLAG,MAKE_CHAIN_FLAG,MAKE_PEPT_FLAG,MAKE_CHECK_SPEC
     &  ,MAKE_HFLAG,MAKE_RFLAG,MAKE_FORM,MAKE_SYMM_FLAG,MAKE_SS_FLAG
     &  ,MAKE_SUGAR_FLAG,LIST_MAKE,MAKE_CHECK,MAKE_NEWL_VALUE_FLAG
     &  ,MAKE_SRCH_FLAG
     &  ,make_segid_in_flag,MAKE_PROG_LIB_PATH,MAKE_LIBS_PATH
     &  ,MAKE_LIBS_NAME,MAKE_LIBS_EXT
     &  ,MAKE_PROG_NAME,NSPGRP,CELL_C,MAKE_LIB_OUT,MAKE_NEW_FLAG
     &  ,MAKE_FSTOP,IERR)
      IF(IERR.GT.0) THEN
        WRITE(*,*)'IERR = ',IERR
        CALL ERRWRT(-1,' ')
        CALL ERRWRT(-1,'There is error. See above')
        CALL ERRWRT(1,'Fatal error. Cannot continue')
      ENDIF
C
C---Delete intermediate file.
 200  CONTINUE
      IF(MAKE_EXIT.EQ.'Y') THEN
        CALL WRITE_ATOMS_REFMAC
        CALL ERRWRT(-1,'Restraints file: '
     &     //OUT_FILE_CIF(1:LENSTR(OUT_FILE_CIF))//'.rst')
        CALL ERRWRT(-1,'mmCIF file     : '
     &     //OUT_FILE_CIF(1:LENSTR(OUT_FILE_CIF))//'.crd')
        CALL ERRWRT(-1,'Connectivity file: '
     &     //OUT_FILE_CIF(1:LENSTR(OUT_FILE_CIF))//'.str')
        CALL CCPERR(0,'After Makecif')
      ENDIF
      IF(IRUN.GT.1) THEN
        IN_FILE = 0
        IFAIL   = -1
        CALL CCPDPN(IN_FILE,IN_COORD_FILE(1:LENSTR(IN_COORD_FILE)),
     &     'OLD','F',LL,IFAIL)
        CLOSE (UNIT=IN_FILE,STATUS='DELETE')
      ENDIF
      IN_FILE = 0
      IFAIL   = -1
      CALL CCPDPN(IN_FILE,OUT_FILE_CIF(1:LENSTR(OUT_FILE_CIF))//
     &         '.crd','OLD','F',LL,IFAIL)
      CLOSE (UNIT=IN_FILE,STATUS='DELETE')
C
C---Find name of necessary files for future use.
      RESTRAINT_FILE = OUT_FILE_CIF(1:LENSTR(OUT_FILE_CIF))//'.rst'
      STRUCT_FILE    = OUT_FILE_CIF(1:LENSTR(OUT_FILE_CIF))//'.str'
      COORD_FILE     = OUT_FILE_CIF(1:LENSTR(OUT_FILE_CIF))//'.crd'
C
C---Process and change some of the parameters (e.g. xyz 9999.000 occ = 0)
C
      call process_strange_pdb_r
C
cd      CALL MAKECIF_SYMMCOPY
C
      RETURN
      END
C
      subroutine process_strange_pdb_r
      implicit none
      include 'atom_com.fh'
      include 'refi_flags.fh'
C
c---Process strange pdb files
C
C---if coordinates are 9999.00 then put occupancies to 0
C---if B values are 0 then change them to some small value
C---if cell parameters are equa to 1 then change them to accomodate
C---the molecule
C
      integer ia

      do ia =1,N_ATOM
        if(abs(xyz_crd(1,ia)).gt.9998.0.or.
     &     abs(xyz_crd(2,ia)).gt.9998.0.or.
     &     abs(xyz_crd(2,ia)).gt.9998.0) then
           occup(ia) = 0.0
        endif
        if(u_aniso(2,ia).le.0.0) then
          if(u_aniso(1,ia).le.0.0) u_aniso(1,ia) = BResetMin
        else
          if(u_aniso(1,ia)+u_aniso(2,ia)+u_aniso(3,ia).le.0.0) then
             u_aniso(1,ia) = BResetMin
             u_aniso(2,ia) = BResetMin
             u_aniso(3,ia) = BResetMin
             u_aniso(4,ia) = 0.0
             u_aniso(5,ia) = 0.0
             u_aniso(6,ia) = 0.0
          endif
        endif
      enddo

      return
      end

      SUBROUTINE CHECK_CELL_FROM_MAKECIF(IERR)
C
      IMPLICIT NONE
      INCLUDE 'celsym.fh'
      INCLUDE 'atom_com.fh'
      INCLUDE 'refi_flags.fh'
      INTEGER IERR
      INTEGER ISYM,I,J
C
C
C---Check if cell parameters from mtz and from pdb are consistent.
cd      WRITE(*,*)'IERR = ',IERR,CS_NSPGR
cd      STOP
      if(cs_nsym.le.0) then
        call errwrt(1,'Unrecognised space group')
      endif
      IF(IERR.EQ.7) THEN
        CALL ERRWRT(-1,'Input coordinate does not have CRYST card')
        CALL ERRWRT(-1,'Check the input coordinate file')
        CALL ERRWRT(1,'Input coordinate file is not complete')
      ENDIF
      IF(IERR.EQ.9) THEN
         CALL ERRWRT(-1,
     &        'Inpit coordinate file does not have CRYST card')
         CALL ERRWRT(-1,'Coordinate file must have cryst card')
         CALL ERRWRT(-1,
     &        'Check if your coordinates and mtz correspond each other')
         CALL ERRWRT(1,'Problem with cell dimensions')
      ENDIF

      IF(IERR.EQ.10) THEN
        CALL ERRWRT(-1,
     &        'Large differences between cells from pdb and mtz')
        CALL ERRWRT(-1,
     &        'Check if coordinate file corresponds to this mtz file')
        CALL ERRWRT(1,'Disagreement between mtz and pdb')
      ENDIF
C
C---Copy symmetry back to RealSymm.
cd      stop
      ISPNO  = CS_NSPGR
      NumSymmetry = CS_NSYM
      DO    ISYM=1,CS_NSYM

        DO   J=1,3
          DO   I=1,3
            RealSymmMatrx(I,J,ISYM) = CS_M_CS(I,J,ISYM)
          ENDDO
          RealSymmMatrx(J,4,ISYM) = CS_V_CS(J,ISYM)
          RealSymmMatrx(4,J,ISYM) = 0.0
        ENDDO
      ENDDO
C
C---Oder of symmetry may have changed. Take precautions
      DO    ISYM=1,NumSymmetry
        DO    I=1,3
           DO    J=1,3
            ROT(I,J,ISYM) = RealSymmMatrx(I,J,ISYM)
          ENDDO
          TR(I,ISYM)   = RealSymmMatrx(I,4,ISYM)
        ENDDO
      ENDDO
      NSYM  = NumSymmetry
      CALL TKNONCUB

C
C---Copy cells also
      DO   I=1,6
         CELL(I) = CS_CELL(I)
      ENDDO
      RETURN
      END
C
      SUBROUTINE READ_ATOMS_REFMAC
      IMPLICIT NONE
      INCLUDE 'atom_com.fh'
      INCLUDE 'celsym.fh'
      INCLUDE 'const.fh'
      include 'makecif.fh'

C
C----This routine reads coordinate file. Input file could be in mmcif
C----or pdb format. This routine will normally be called in unrestrained
C----refinement mode
C
      REAL CELL_C(6)
      CHARACTER FILE_TYPE_FLAG*1,PEPT_FLAG*1,IN_COORD_FILE*256,EXT*10,
     &          PATH*10
      INTEGER MDOC,IERR,LEN,NSPGRP,I
      INTEGER LENSTR
      CHARACTER OUT_FILE_CRD*256
      CHARACTER H_R*1

      CALL UGTENV('XYZOUT',OUT_FILE_CRD)
      IF(OUT_FILE_CRD.EQ.' ') THEN
         CALL ERRWRT(0,' No output coordinate file has been defined')
         CALL ERRWRT(0,' Output coordinates will be written to XYZOUT')
         OUT_FILE_CRD = 'XYZOUT'
      ENDIF
C
      CALL UGTENV('XYZIN',IN_COORD_FILE)
      IF(IN_COORD_FILE.EQ.' ') IN_COORD_FILE = 'XYZIN'
C
c---Check if input file has pdb or mmcif format
      CALL PDB_OR_CIF(MDOC,IN_COORD_FILE,FILE_TYPE_FLAG,IERR)
C
C =============================================
C
C     read coord input file 
C
      MDOC      = -999
      EXT       = ' '
      PATH      = ' '
      PEPT_FLAG = 'N'
      IERR      = 0
      NSPGRP    = ISPNO
      DO   I=1,6
        CELL_C(I) = 0.0
      ENDDO
      IF(CELL(1)*CELL(2)*CELL(3).GT.1) THEN
         DO  I=1,6
           CELL_C(I) = CELL(I)
         ENDDO
        IF(CELL(4).LT.5.0.OR.CELL(5).LT.5.0
     &                    .OR.CELL(6).LT.5.0) THEN
          CELL_C(4) = CELL_C(4)/DEGTOR
          CELL_C(5) = CELL_C(5)/DEGTOR
          CELL_C(6) = CELL_C(6)/DEGTOR
        ENDIF
      ENDIF
      CALL INIT_ATM_INF(MDOC,IERR)
      CALL INIT_DEFAULTS

      IERR = 0
      IF(FILE_TYPE_FLAG.EQ.'P') THEN
C       ---  read PDB_file.
C       make_PDB.f
        H_R = 'Y'
        CALL GET_PDB(MDOC,IN_COORD_FILE,NSPGRP,CELL_C,PEPT_FLAG,
     &        make_segid_in_flag,H_R,IERR)    
        IF(IERR.EQ.7.OR.IERR.EQ.9) THEN
          CALL ERRWRT(-1,'Input coordinate does not have CRYST card')
          CALL ERRWRT(-1,'Check the input coordinate file')
          CALL ERRWRT(1,'Input coordinate file is not complete')
        ENDIF
        IF(IERR.EQ.10) THEN
          CALL ERRWRT(-1,
     &        'Large differences between cells from pdb and mtz')
          CALL ERRWRT(-1,
     &        'Check if coordinate file corresponds to this mtz file')
          CALL ERRWRT(1,'Disagreement between mtz and pdb')
        ENDIF
      ELSE
        LEN =  LENSTR(IN_COORD_FILE)
        IF(LEN.GT.0.AND.IN_COORD_FILE(1:1).NE.' '.AND.
     *    IN_COORD_FILE(1:1).NE.',') THEN
C          --- read CIFile.
C         read_CIF.f
          CALL READ_ATOMS(MDOC,PATH,IN_COORD_FILE,EXT,NSPGRP,CELL_C,
     &                  IERR)
         CALL CHECK_CELL_FROM_MAKECIF(IERR)
        ELSE
          GOTO 100
        ENDIF
      ENDIF
      IERR = 0
      RETURN
 100  CONTINUE
      CALL ERRWRT(1,'Reading coordinate file')
      END
C
      SUBROUTINE WRITE_ATOMS_REFMAC
      IMPLICIT NONE
C
      INCLUDE 'atom_com.fh'
      INCLUDE 'makecif.fh'
      INTEGER IOUT,IERR,MDOC,IA
      CHARACTER OUT_FILE_CRD*256,E*10,PATH*10

      CALL UGTENV('XYZOUT',OUT_FILE_CRD)
      IF(OUT_FILE_CRD.EQ.' ') OUT_FILE_CRD = 'XYZOUT'
      
      IOUT = 0
      PATH = ' '
      E    = ' '
      MDOC = -999
C
C---Write in a pdb format
      DO   IA=1,N_ATOM
        IF(U_ANISO(2,IA).NE.0.0) THEN
          B_FLAG(IA) = IA
        ENDIF
      ENDDO
      CALL OPENFW(IOUT,MDOC,PATH,OUT_FILE_CRD,E,IERR)
      IF(IERR.GT.0) THEN
         CALL ERRWRT(1,'Problem with output coordinate file')
      ENDIF
      CLOSE(IOUT)
      CALL WRITE_ATOMS_PDB(MDOC,MAKE_HFLAG_O,MAKE_DEPOS,
     &     make_segid_out_flag,PATH,
     &                       OUT_FILE_CRD,E,IERR)

cd      CALL WRITE_ATOMS(MDOC,PATH,OUT_FILE_CRD,E,IERR)
c    
c---Add here CIF format
      RETURN
      END
C
      SUBROUTINE READ_RESTR
C
c---This routine reads list of restraint from MAKECIF and writes into 
C---separate unformatted files for further use
C
      IMPLICIT NONE
      INCLUDE 'crd_com.fh'
      INCLUDE 'atom_com.fh'
      INCLUDE 'pls_incl.fh'
      INCLUDE 'makecif.fh'
      INCLUDE 'restr_files.fh'
      INCLUDE 'restr_params.fh'

      INTEGER MAXPLN_ATOM
      PARAMETER (MAXPLN_ATOM = 50)
      INTEGER IS_LOCAL,IS_LOCAL1,IS_LOCAL2,IS_LOCAL3,IA1,IA2,IA3,
     +        IA4,MD,IN,ISCRB,ISCRA,ISCRT,ISCRC,ISCRP
      INTEGER NR_BOND,NR_ANGL,NR_TORS,NR_CHIR,NR_PLAN,IEND,NREST,
     +        NA_PLAN
      INTEGER MAX_BOND
      PARAMETER (MAX_BOND = 2*MAXATOM)
      INTEGER MAXANGLE
      PARAMETER (MAXANGLE = 4*MAXATOM)
      INTEGER MAXTOR
      PARAMETER (MAXTOR   = 8*MAXRESID)
      INTEGER MAXCHIR
      PARAMETER (MAXCHIR  = 4*MAXRESID)
      INTEGER NMAX_PLANE
      PARAMETER (NMAX_PLANE = 3*MAXRESID)
      INTEGER IA1_B(MAX_BOND),IA2_B(MAX_BOND),IA1_A(MAXANGLE),
     &        IA2_A(MAXANGLE),IA3_A(MAXANGLE),IA1_T(MAXTOR),
     &        IA2_T(MAXTOR),IA3_T(MAXTOR),IA4_T(MAXTOR),IA1_C(MAXCHIR),
     &        IA2_C(MAXCHIR),IA3_C(MAXCHIR),IA4_C(MAXCHIR),
     &        ICHIR_SIGN(MAXCHIR),
     &        IA1_P(MAXPLN_ATOM,NMAX_PLANE),NPLANE(NMAX_PLANE),
     &        ITORS_PERIOD(MAXTOR),ITOR_FLAG(MAXTOR),IS_BOND(4,MAX_BOND)
      REAL  RS_VIDL_B(MAX_BOND),RS_SDI_B(MAX_BOND),RS_VIDL_A(MAXANGLE),
     &      RS_SDI_A(MAXANGLE),RS_DIST_A(MAXANGLE),RS_DESD_A(MAXANGLE),
     &      RS_VIDL_T(MAXTOR),RS_SDI_T(MAXTOR),RS_VIDL_C(MAXCHIR),
     &      RS_SDI_C(MAXCHIR),RS_VIDL_P(NMAX_PLANE),
     &      RS_SDI_P(NMAX_PLANE)
      REAL SIGN_CHIR
      CHARACTER*8 TORS_LABEL(MAXTOR)
      INTEGER N_REMAIN_ARRAY
      PARAMETER (N_REMAIN_ARRAY=QQDEN-(8*MAX_BOND+7*MAXANGLE+10*MAXTOR+
     &                          7*MAXCHIR+(MAXPLN_ATOM+3)*NMAX_PLANE))
      REAL WORKSPACE(N_REMAIN_ARRAY)
      COMMON /R_SCRATCH/IA1_B,IA2_B,IA1_A,IA2_A,IA3_A,IA1_T,IA2_T,
     &                  IA3_T,IA4_T,IA1_C,IA2_C,IA3_C,IA4_C,
     &                  ICHIR_SIGN,IA1_P,ITOR_FLAG,
     &                  NPLANE,ITORS_PERIOD,RS_VIDL_B,RS_SDI_B,
     &                  RS_VIDL_A,RS_SDI_A,RS_VIDL_T,RS_SDI_T,
     &                  RS_VIDL_C,RS_SDI_C,RS_DIST_A,RS_DESD_A,
     &                  RS_VIDL_P,RS_SDI_P,TORS_LABEL,IS_BOND,
     &                  WORKSPACE
      INTEGER IERROR
      INTEGER LENSTR
      REAL FIND_CHIR_SIGN
      EXTERNAL LENSTR,FIND_CHIR_SIGN

      INTEGER LL,IFAIL,IR,RS_NUM_OLD,NREAD,MODE,IPL,IERR,
     &        I,J,JRS
      CHARACTER PATHR*10,EXTR*10,THIS_ALT*1
      CHARACTER SCRATCH_FILE*256
      character chnamp1*4
      LOGICAL APPLY_OK

C

      MD  = 0
      IN  = 0
      PATHR = ' '
      EXTR = ' '
      IERR = 0

      CALL ORRST_CIF(MD,IN,PATHR,RESTRAINT_FILE,EXTR,IERR)
C
C---Output files
      ISCRB = 0
      ISCRA = 0
      ISCRT = 0
      ISCRC = 0
      ISCRP = 0
      IS_LOCAL = 0
      IS_LOCAL1 = 0
      IS_LOCAL2 = 0
      IS_LOCAL3 = 0

      IFAIL = 0
      LL    = 0
cd      OPEN(ISCRB,FILE='BOND_R',FORM='UNFORMATTED')
      CALL UGTENV('TEMP1',SCRATCH_FILE)
      BOND_FILE = SCRATCH_FILE(1:LENSTR(SCRATCH_FILE))//'_BOND_R'
      IFAIL = -1
      CALL CCPDPN(ISCRB,BOND_FILE(1:LENSTR(BOND_FILE)),'UNKNOWN',
     &            'U',LL,IFAIL)
      IFAIL = -1
      ANGLE_FILE = SCRATCH_FILE(1:LENSTR(SCRATCH_FILE))//'_ANGL_R'
      CALL CCPDPN(ISCRA,ANGLE_FILE(1:LENSTR(ANGLE_FILE)),'UNKNOWN',
     &          'U',LL,IFAIL)
      IFAIL = -1
      TORS_FILE = SCRATCH_FILE(1:LENSTR(SCRATCH_FILE))//'_TORS_R'

      CALL CCPDPN(ISCRT,TORS_FILE(1:LENSTR(TORS_FILE)),'UNKNOWN',
     &          'U',LL,IFAIL)
      IFAIL = -1
      CHIR_FILE = SCRATCH_FILE(1:LENSTR(SCRATCH_FILE))//'_CHIR_R'
      CALL CCPDPN(ISCRC,CHIR_FILE(1:LENSTR(CHIR_FILE)),'UNKNOWN',
     &          'U',LL,IFAIL)
      IFAIL = -1
      PLANE_FILE = SCRATCH_FILE(1:LENSTR(SCRATCH_FILE))//'_PLANE_R'
      CALL CCPDPN(ISCRP,PLANE_FILE(1:LENSTR(PLANE_FILE)),'UNKNOWN',
     &          'U',LL,IFAIL)
C
C---Initialise. Number of different restraint types is 0
      NR_BOND     = 0
      NR_ANGL     = 0
      NR_TORS     = 0
      NR_CHIR     = 0
      NR_PLAN     = 0
      RS_NUM_OLD  = -1
      IEND        = 0
      NREST       = 0
      NA_PLAN     = 0
      NREAD       = 0
      IF(IERR.EQ.100) THEN
         CLOSE(UNIT=IN,STATUS='DELETE')
         CLOSE(UNIT=ISCRB)
         CLOSE(UNIT=ISCRA)
         CLOSE(UNIT=ISCRP)
         CLOSE(UNIT=ISCRC)
         CLOSE(UNIT=ISCRT)
         RETURN
       END IF
      IERR        = 0
cd      MD          = -999
C
C---Start reading restraints. If there is new restraint return here
 200  CONTINUE
      CALL RDRST_CIF(MD,IN,MODE,IEND,IERR)
      NREAD = NREAD + 1
      IF(IERR.NE.0) CALL ERRWRT(1,'Reading restraint file')
      IF(IEND.NE.0) GOTO 300
C
C---It is restraint
      IF(MODE.EQ.0) THEN
        IA1 = RS_IA1
        IA2 = RS_IA2
        IA3 = RS_IA3
        IA4 = RS_IA4
C
C
C--It is bond distance
        IF(RS_NAME.EQ.'BOND') THEN
          NR_BOND = NR_BOND + 1
          IF(NR_BOND.GT.MAX_BOND) THEN
             CALL ERRWRT(1,'Number of bonds exceeds maximum number')
          ENDIF
          IA1_B(NR_BOND) = IA1
          IA2_B(NR_BOND) = IA2
          RS_VIDL_B(NR_BOND) = RS_VIDL
          IF(RS_SDI.LE.0.0) RS_SDI = 0.03
          RS_SDI_B(NR_BOND)  = RS_SDI
          IS_BOND(1,NR_BOND) = 1
          IS_BOND(2,NR_BOND) = 0
          IS_BOND(3,NR_BOND) = 0
          IS_BOND(4,NR_BOND) = 0
C
C---Symmetry related bond
        ELSE IF(RS_NAME.EQ.'BNDS') THEN
          NR_BOND = NR_BOND + 1
          IF(NR_BOND.GT.MAX_BOND) THEN
             CALL ERRWRT(1,'Number of bonds exceeds maximum number')
          ENDIF
          IA1_B(NR_BOND) = IA2
          IA2_B(NR_BOND) = IA1
          RS_VIDL_B(NR_BOND) = RS_VIDL
          IF(RS_SDI.LE.0.0) RS_SDI = 0.03
          RS_SDI_B(NR_BOND)  = RS_SDI
          CALL EXTRACT_SYMM_FROM_LABEL(RS_LABEL,IS_BOND(1,NR_BOND),
     &                    IERROR)
          IF(IERROR.NE.0)
     &       CALL ERRWRT(1,'Error in reding symmetry related bonds')
C
C---It is an angle
        ELSE IF(RS_NAME.EQ.'ANGL') THEN
          NR_ANGL = NR_ANGL + 1
          IF(NR_ANGL.GT.MAXANGLE) THEN
            CALL ERRWRT(1,'Number of angles exceeds maximum number')
          ENDIF
          IA1_A(NR_ANGL) = IA1
          IA2_A(NR_ANGL) = IA2
          IA3_A(NR_ANGL) = IA3
          RS_VIDL_A(NR_ANGL) = RS_VIDL
          RS_SDI_A(NR_ANGL)  = RS_SDI
          RS_DIST_A(NR_ANGL) = RS_DIST
          RS_DESD_A(NR_ANGL) = RS_DESD
        ELSE IF(RS_NAME.EQ.'TORS') THEN
           NR_TORS = NR_TORS + 1
           IR = NR_TORS
           IF(NR_TORS.GT.MAXTOR) THEN
             CALL ERRWRT(1,'Number of torsions exceeds maximum number')
           ENDIF
C
C--Treat this torsion as user wishes. I.e. restrain, change 
C--targets etc.
          ITOR_FLAG(IR) = 0
          IA1_T(NR_TORS) = IA1
          IA2_T(NR_TORS) = IA2
          IA3_T(NR_TORS) = IA3
          IA4_T(NR_TORS) = IA4
          RS_VIDL_T(NR_TORS) = RS_VIDL
          RS_SDI_T(NR_TORS)  = RS_SDI
          ITORS_PERIOD(NR_TORS) = RS_PRD
          TORS_LABEL(NR_TORS)   = RS_LABEL
C
c---Now decide if this torsion angle is for restraint or not.
          CALL IS_IT_RESTR_TORSION(TORS_LABEL(IR),IA1_T(IR),IA2_T(IR),
     &           IA3_T(IR),IA4_T(IR),ITORS_PERIOD(IR),RS_VIDL_T(IR),
     &           RS_SDI_T(IR),RS_SOURCE_ID,ITOR_FLAG(IR))
          IF(ITOR_FLAG(IR).LE.0) ITOR_FLAG(IR) = 0
cd          IF(ITOR_FLAG(IR).GT.0) THEN
cd            IF(ITORS_PERIOD(IR).GT.1)WRITE(*,*)ITORS_PERIOD(IR)
cd          ENDIF
        ELSE IF(RS_NAME.EQ.'CHIR') THEN
           NR_CHIR = NR_CHIR + 1
           IF(NR_CHIR.GT.MAXCHIR) THEN
            CALL ERRWRT(1,'Number of chirals exceeds maximum number')
          ENDIF
          IA1_C(NR_CHIR) = IA1
          IA2_C(NR_CHIR) = IA2
          IA3_C(NR_CHIR) = IA3
          IA4_C(NR_CHIR) = IA4
          ICHIR_SIGN(NR_CHIR) = 1
          IF(RS_LABEL(1:4).EQ.'nega') THEN
            ICHIR_SIGN(NR_CHIR) = -1
          ELSE IF(RS_LABEL(1:4).EQ.'both') THEN
             ICHIR_SIGN(NR_CHIR) =  0
          ELSE IF(RS_LABEL(1:4).EQ.'anom') THEN
            SIGN_CHIR = FIND_CHIR_SIGN(XYZ_CRD(1,IA1_C(NR_CHIR)),
     *                                 XYZ_CRD(1,IA2_C(NR_CHIR)),
     *                                 XYZ_CRD(1,IA3_C(NR_CHIR)),
     *                                 XYZ_CRD(1,IA4_C(NR_CHIR)))
            IF(SIGN_CHIR.LT.0.0) THEN
              ICHIR_SIGN(NR_CHIR) = -1
            ELSE
              ICHIR_SIGN(NR_CHIR) = 1
            ENDIF
          ENDIF
          RS_VIDL_C(NR_CHIR) = RS_VIDL
          RS_SDI_C(NR_CHIR)  = RS_SDI
        ELSE IF(RS_NAME.EQ.'PLAN') THEN
C
C---Make sure to read all atoms belonging to this particular plane
cd           IF(OCCUP(IA1).LE.0.0) THEN
             IF(RS_NUM_OLD.NE.RS_NUM) THEN
               NR_PLAN = NR_PLAN + 1
               IF(NR_PLAN.GT.NMAX_PLANE) THEN
                 CALL ERRWRT(1,
     &                'Number of planes exceeds maximum allowed')
               ENDIF
               NA_PLAN         = 1
               NPLANE(NR_PLAN) = 1

               RS_VIDL_P(NR_PLAN)     = RS_VIDL
               RS_SDI_P(NR_PLAN)      = RS_SDI
               IA1_P(NA_PLAN,NR_PLAN) = IA1
             ELSE
               RS_VIDL_P(NR_PLAN)     = RS_VIDL
               RS_SDI_P(NR_PLAN)      = RS_SDI
               NA_PLAN                = NA_PLAN + 1
               NPLANE(NR_PLAN)        = NPLANE(NR_PLAN) + 1
               IA1_P(NA_PLAN,NR_PLAN) = IA1
             ENDIF
cd           ENDIF
           RS_NUM_OLD = RS_NUM
        ENDIF
      ELSE
C
C--Comment line
cd        C_LINE = CR_LINE
cd        IFLAG  = 0
      ENDIF
      GOTO 200
 300  CONTINUE
C
C---Write restraints to output intermediate files. They will be used 
C---for restraints and report of geometry
      DO   IR = 1,NR_BOND
        if(occup(ia1_b(ir)).gt.0.0.and.occup(ia2_b(ir)).gt.0.0) then
          WRITE(ISCRB)IA1_B(IR),IA2_B(IR),RS_VIDL_B(IR),RS_SDI_B(IR),
     &      IS_BOND(1,IR),IS_BOND(2,IR),IS_BOND(3,IR),IS_BOND(4,IR),1
        endif
      ENDDO
      CLOSE(UNIT=ISCRB)
C
C
c---Add new bonds here
      call read_psuedorest(bond_file)
c
      DO   IR=1,NR_ANGL
cd        RS_SDI_A(IR) = 3.0
       if(occup(ia1_a(ir)).gt.0.0.and.
     &    occup(ia2_a(ir)).gt.0.0.and.
     &    occup(ia3_a(ir)).gt.0.0)   then
            WRITE(ISCRA)IA1_A(IR),IA2_A(IR),IA3_A(IR),RS_VIDL_A(IR),
     &          RS_SDI_A(IR),RS_DIST_A(IR),RS_DESD_A(IR)
       endif
C
c---Add new angles here
      ENDDO
C
      DO  IR=1,NR_TORS
        IF(TORS_LABEL(IR)(1:4).EQ.'omeg'.AND.ITOR_FLAG(IR).GT.0) THEN
          IF(NCIS_TRANS_RES.GT.0) THEN
            DO   I=1,NCIS_TRANS_RES
              J = I_RESID(IA1_T(IR))
              call get_chain_namepdb(chnamp1,j)
              READ(RES_NUM_PDB(J)(3:6),*)JRS
              IF(JRS.EQ.CIS_TRANS_RES(I)) THEN
                IF(CIS_TRANS_CHAIN(I).EQ.chnamp1) THEN
                  THIS_ALT= CIS_TRANS_ALT(I)
                  APPLY_OK = .FALSE.
                  IF(THIS_ALT.NE.'.') THEN
                    IF(ID_ALT(IA1_T(IR)).EQ.THIS_ALT) THEN
C
C---Check all atoms must have same alt code.
C
                      IF(ID_ALT(IA1_T(IR)).EQ.THIS_ALT.AND.
     &                   ID_ALT(IA2_T(IR)).EQ.THIS_ALT.AND.
     &                   ID_ALT(IA3_T(IR)).EQ.THIS_ALT.AND.
     &                   ID_ALT(IA4_T(IR)).EQ.THIS_ALT) THEN
                        APPLY_OK = .TRUE.
                      ENDIF
                    ENDIF
                  ELSE
                    APPLY_OK = .TRUE.
                  ENDIF
                  IF(APPLY_OK) THEN
                    IF(CIS_TRANS_VALUE(I)(1:3).EQ.'CIS') THEN
                      RS_VIDL_T(IR) = 0.0
                    ELSE IF(CIS_TRANS_VALUE(I)(1:3).EQ.'TRA') THEN
                      RS_VIDL_T(IR) = 180.0
                    ENDIF
                  ENDIF
                ENDIF
              ENDIF
            ENDDO
          ENDIF
        ENDIF
cd        IF(TORS_LABEL(IR)(1:3).EQ.'chi'.AND.
cd     &    RES_NAME(I_RESID(IR)).NE.'PRO') ITOR_FLAG = 3
cd          IF(ITORS_PERIOD(IR).EQ.1) RS_SDI_T(IR) = 3.0
cd        IF(TORS_LABEL(IR)(1:4).EQ.'omeg') RS_SDI_T(IR) = 3.0
        if(occup(ia1_t(ir)).gt.0.0.and.
     &     occup(ia2_t(ir)).gt.0.0.and.
     &     occup(ia3_t(ir)).gt.0.0.and.
     &     occup(ia4_t(ir)).gt.0.0)    then
          WRITE(ISCRT)TORS_LABEL(IR),IA1_T(IR),IA2_T(IR),IA3_T(IR),
     &           IA4_T(IR),ITORS_PERIOD(IR),RS_VIDL_T(IR),RS_SDI_T(IR),
     &           ITOR_FLAG(IR)
        endif
C
C---Add new torsions here
      ENDDO
C

      DO   IR=1,NR_CHIR
        IF(NCHIR_REPLACE.GT.0) THEN
          DO   I=1,NCHIR_REPLACE
            J = I_RESID(IA1_C(IR))
            call get_chain_namepdb(chnamp1,j)
            READ(RES_NUM_PDB(J)(3:6),*)JRS
            IF(JRS.EQ.CHIR_REPL_RES(I)) THEN
              IF(CHIR_REPL_CHAIN(I).EQ.chnamp1) THEN
                IF(CHIR_REPL_ATOM(I).EQ.ATM_NAME_INP(IA1_C(IR))) THEN
                  THIS_ALT = CHIR_REPL_ALT(I)
                  APPLY_OK = .FALSE.
                  IF(THIS_ALT.NE.'.') THEN
                    IF(ID_ALT(IA1_C(IR)).EQ.THIS_ALT) THEN
                       APPLY_OK = .TRUE.
                    ENDIF
                  ELSE
                    APPLY_OK = .TRUE.
                  ENDIF
C
                  IF(APPLY_OK) THEN
                    IF(CHIR_REPL_SIGN(I).EQ.'P') THEN
                      ICHIR_SIGN(IR) = 1
                    ELSE IF(CHIR_REPL_SIGN(I).EQ.'M') THEN
                      ICHIR_SIGN(IR) = -1
                    ELSE IF(CHIR_REPL_SIGN(I).EQ.'B') THEN
                      ICHIR_SIGN(IR) = 0
                    ENDIF
                  ENDIF
                ENDIF
              ENDIF
            ENDIF
          ENDDO
        ENDIF
        RS_SDI_C(IR) = 0.20
        if(occup(ia1_c(ir)).gt.0.0.and.
     &     occup(ia2_c(ir)).gt.0.0.and.
     &     occup(ia3_c(ir)).gt.0.0.and.
     &     occup(ia4_c(ir)).gt.0.0)    then
          WRITE(ISCRC)IA1_C(IR),IA2_C(IR),IA3_C(IR),IA4_C(IR),
     &        RS_VIDL_C(IR),RS_SDI_C(IR),ICHIR_SIGN(IR)
        endif
C
C---Add new chirals here
      ENDDO
C
      DO   IR=1,NR_PLAN
C
C---If more than 10 atoms then check and divide into local
C---planes. 
cd        IF(NPLANE(IR).GT.10) THEN
cd          CALL DIVIDE_PLANES(NPLANE(IR),IA1_P(1,IR),
cd        WRITE(*,*)NPLANE(IR),RES_NAME(I_RESID(IA1_P(1,IR)))(1:4),
cd     &           (ATM_NAME(IA1_P(IPL,IR)),IPL=1,NPLANE(IR)),RS_SDI_P(IR)
cd        ELSE IF
        NA_PLAN = 0
        DO  IPL=1,NPLANE(IR)
          IF(OCCUP(IA1_P(IPL,IR)).GT.0.0) THEN
            NA_PLAN = NA_PLAN  + 1
            IA1_P(NA_PLAN,IR) = IA1_P(IPL,IR)
          ENDIF
        ENDDO
        NPLANE(IR) = NA_PLAN
        IF(NA_PLAN.GT.0) THEN
          RS_SDI_P(IR) =  0.02
          WRITE(ISCRP)NPLANE(IR),RS_VIDL_P(IR),RS_SDI_P(IR),
     &           (IA1_P(IPL,IR),IPL=1,NPLANE(IR))
        ENDIF
cd        ENDIF
C
C---Add new planes here
      ENDDO
      CLOSE(UNIT=IN,STATUS='DELETE')
      CLOSE(UNIT=ISCRA)
      CLOSE(UNIT=ISCRP)
      CLOSE(UNIT=ISCRC)
      CLOSE(UNIT=ISCRT)

      RETURN
      END
C
      SUBROUTINE IS_IT_RESTR_TORSION(TORS_LABEL,IA1,IA2,IA3,
     &           IA4,ITORS_PERIOD,RS_VIDL_T,RS_SDI_T,RS_SOURCE_ID,
     &           ITOR_FLAG)
      IMPLICIT NONE
      INCLUDE 'restr_params.fh'
      INCLUDE 'atom_com.fh'
C
C---Looks up to the list defined in 'restr_params.fh' and decides if
C---it is restrainable torsion
      INTEGER IA1,IA2,IA3,IA4,ITORS_PERIOD,ITOR_FLAG,I_C,L_RES_T1,
     &        L_TORS_N,L_TORS_L,L_GROUP_L,L_TYPE_L,I_TYPE_R
      REAL RS_VIDL_T,RS_SDI_T
      CHARACTER TORS_LABEL*(*),RS_SOURCE_ID*(*)
      INTEGER I,I_SAME_RESIDUE,L_RES_T,I_RES_C1,I_RES_C2,I_NAME_R
      INTEGER LENSTR
      EXTERNAL LENSTR
C
C---Initialise
      ITOR_FLAG = 0
C
C---All atoms must be from the same residue. If yes look up residue names/groups
C---If no look link names, groups.
C
      I_SAME_RESIDUE = 0
      IF(IA1.LE.0.OR.IA2.LE.0.OR.IA3.LE.0.OR.IA4.LE.0) RETURN
      IF(I_RESID(IA1).EQ.I_RESID(IA2).AND.
     &    I_RESID(IA1).EQ.I_RESID(IA3).AND.
     &    I_RESID(IA1).EQ.I_RESID(IA4))THEN
        I_SAME_RESIDUE = 1
        I_RES_C1       = I_RESID(IA1)
      ELSE
        I_RES_C1 = I_RESID(IA1)
        IF(I_RESID(IA1).NE.I_RESID(IA2)) THEN
          I_RES_C2 = I_RESID(IA2)
        ELSEIF(I_RESID(IA1).NE.I_RESID(IA3)) THEN
          I_RES_C2 =  I_RESID(IA3)
        ELSEIF(I_RESID(IA1).NE.I_RESID(IA4)) THEN
          I_RES_C2 =  I_RESID(IA4)
        ENDIF
      ENDIF
C
C---Now look if it is one of the residues or groups
      IF(I_SAME_RESIDUE.EQ.1) THEN
        I_C = 0
        L_TORS_L = MIN(8,LENSTR(TORS_LABEL))
        I_TYPE_R = IRES_TYPE(I_RES_C1)
cd        I_NAME_R = I_RESID(I_RES_C1)
       
        L_TYPE_L = MIN(8,LENSTR(RS_SOURCE_ID))
        L_RES_T1 = MIN(8,LENSTR(RES_NAME(I_RES_C1)))

        DO   I=1,N_RESTRAIN_TORS
C
C---Look residue name
          L_RES_T = LENSTR(RES_NAME_TORS_RESTR(I))
          L_TORS_N = LENSTR(RES_NAME_TORS_NAME(I))
          IF(L_RES_T.GT.0.AND.RES_NAME_TORS_RESTR(I)(1:1).NE.'.') THEN
            IF(L_RES_T1.GT.0.AND.L_TORS_N.GT.0.AND.L_TORS_L.GT.0) THEN
              IF(RES_NAME(I_RES_C1)(1:L_RES_T1).EQ.
     &           RES_NAME_TORS_RESTR(I)(1:L_RES_T).AND.
     &           TORS_LABEL(1:L_TORS_L).EQ.
     &           RES_NAME_TORS_NAME(I)(1:L_TORS_N)) THEN
                ITOR_FLAG = 1
                I_C = I
                GOTO 110
              ENDIF
            ENDIF
          ENDIF
        ENDDO
C
        DO   I=1,N_RESTRAIN_TORS
          L_RES_T = MIN(8,LENSTR(RES_NAME_TORS_RESTR(I)))
          L_TORS_N = MIN(8,LENSTR(RES_NAME_TORS_NAME(I)))
          L_GROUP_L = MIN(8,LENSTR(GROUP_NAME_TORS_RESTR(I)))
          IF(L_GROUP_L.GT.0.AND.
     &       GROUP_NAME_TORS_RESTR(I)(1:1).NE.'.') THEN
C
C---Decide using group ('peptide', 'DNA' etc) name. We should have access 
C---this information
            IF(GROUP_NAME_TORS_RESTR(I)(1:L_GROUP_L).EQ.
     &         RS_SOURCE_ID(1:L_TYPE_L).AND.
     &         TORS_LABEL(1:L_TORS_L).EQ.
     &         RES_NAME_TORS_NAME(I)(1:L_TORS_N)) THEN
              ITOR_FLAG = 1
              I_C = I
              GOTO 110
            ENDIF
          ENDIF
C
        ENDDO
 110    CONTINUE

        I = I_C
C
C---If user has changed targets and other things apply them.
        IF(ITOR_FLAG.GT.0.AND.I_C.GT.0) THEN
          IF(RES_NAME_TORS_PERIOD(I).GT.0)
     &           ITORS_PERIOD = RES_NAME_TORS_PERIOD(I)
          IF(RES_NAME_TORS_VALUE(I).GE.-180.0) 
     &         RS_VIDL_T = RES_NAME_TORS_VALUE(I)
          IF(RES_NAME_TORS_SIGMA(I).GT.0.0)
     &       RS_SDI_T = RES_NAME_TORS_SIGMA(I)
        ENDIF
      ELSE
C
C---Torsion is between residues. Link info. Use that info.
C---It is a link.
        I_C = 0
        L_TYPE_L  = MIN(8,LENSTR(RS_SOURCE_ID))
        L_TORS_L  = MIN(8,LENSTR(TORS_LABEL))
        DO   I=1,N_RESTRAIN_TORS
          L_GROUP_L = MIN(8,LENSTR(LINK_NAME_TORS_RESTR(I)))
          L_TORS_N  = MIN(8,LENSTR(RES_NAME_TORS_NAME(I)))
          IF(LINK_NAME_TORS_RESTR(I)(1:L_GROUP_L).EQ.
     &         RS_SOURCE_ID(1:L_TYPE_L).AND.
     &         TORS_LABEL(1:L_TORS_L).EQ.
     &         RES_NAME_TORS_NAME(I)(1:L_TORS_N)) THEN
              ITOR_FLAG = 1
              I_C = I
              GOTO 200 
          ENDIF
        ENDDO
 200    CONTINUE
C
C---If user has changed targets and other things apply them.
        IF(ITOR_FLAG.GT.0.AND.I_C.GT.0) THEN
C
          I = I_C
          IF(RES_NAME_TORS_PERIOD(I).GT.0)
     &           ITORS_PERIOD = RES_NAME_TORS_PERIOD(I)
          IF(RES_NAME_TORS_VALUE(I).GE.0.0) 
     &         RS_VIDL_T = RES_NAME_TORS_VALUE(I)
          IF(RES_NAME_TORS_SIGMA(I).GT.0.0)
     &       RS_SDI_T = RES_NAME_TORS_SIGMA(I)
        ENDIF
      ENDIF
C
C---Now remove torsion angles from restraints if such thing have been defined
      IF(N_RESTRAIN_TORS_E.GT.0) THEN
      IF(I_SAME_RESIDUE.EQ.1) THEN
        I_C = 0
        L_TORS_L = MIN(8,LENSTR(TORS_LABEL))
        DO   I=1,N_RESTRAIN_TORS_E
C
C---Look residue name
          L_RES_T = MIN(8,LENSTR(RES_NAME_TORS_RESTR_E(I)))
          L_RES_T1 = MIN(8,LENSTR(RES_NAME(I_RES_C1)))
          L_TORS_N = MIN(8,LENSTR(RES_NAME_TORS_NAME_E(I)))
          IF(L_RES_T.GT.0.AND.RES_NAME_TORS_RESTR_E(I)(1:1).NE.'.') THEN
            IF(L_RES_T1.GT.0.AND.L_TORS_N.GT.0.AND.L_TORS_L.GT.0) THEN
              IF(RES_NAME(I_RES_C1)(1:L_RES_T1).EQ.
     &           RES_NAME_TORS_RESTR_E(I)(1:L_RES_T).AND.
     &           TORS_LABEL(1:L_TORS_L).EQ.
     &           RES_NAME_TORS_NAME_E(I)(1:L_TORS_N)) THEN
                ITOR_FLAG = 0
                I_C = I
                GOTO 210
              ENDIF
            ENDIF
          ENDIF
C
          L_GROUP_L = MIN(8,LENSTR(GROUP_NAME_TORS_RESTR_E(I)))
          IF(L_GROUP_L.GT.0.AND.
     &       GROUP_NAME_TORS_RESTR_E(I)(1:1).NE.'.') THEN
C
C---Decide using group ('peptide', 'DNA' etc) name. We should have access 
C---this information
            I_TYPE_R = IRES_TYPE(I_RES_C1)
            L_TYPE_L = MIN(8,LENSTR(RS_SOURCE_ID))
            IF(GROUP_NAME_TORS_RESTR_E(I)(1:L_GROUP_L).EQ.
     &         RS_SOURCE_ID(1:L_TYPE_L).AND.
     &         TORS_LABEL(1:L_TORS_L).EQ.
     &         RES_NAME_TORS_NAME_E(I)(1:L_TORS_N)) THEN
              ITOR_FLAG = 0
              I_C = I
              GOTO 210
            ENDIF
          ENDIF
C
        ENDDO
 210    CONTINUE

      ELSE
C
C---Torsion is between residues. Link info. Use that info.
C---It is a link.
        I_C = 0
        L_TYPE_L  = MIN(8,LENSTR(RS_SOURCE_ID))
        L_TORS_L  = MIN(8,LENSTR(TORS_LABEL))
        DO   I=1,N_RESTRAIN_TORS_E
          L_GROUP_L = MIN(8,LENSTR(LINK_NAME_TORS_RESTR_E(I)))
          L_TORS_N  = MIN(8,LENSTR(RES_NAME_TORS_NAME_E(I)))
          IF(LINK_NAME_TORS_RESTR_E(I)(1:L_GROUP_L).EQ.
     &         RS_SOURCE_ID(1:L_TYPE_L).AND.
     &         TORS_LABEL(1:L_TORS_L).EQ.
     &         RES_NAME_TORS_NAME_E(I)(1:L_TORS_N)) THEN
              ITOR_FLAG = 0
              I_C = I
              GOTO 300 
          ENDIF
        ENDDO
 300    CONTINUE
C
      ENDIF
      ENDIF

      END
C
      SUBROUTINE EXTRACT_SYMM_FROM_LABEL(RS_LABEL,IS_REST,IERROR)
      IMPLICIT NONE
C
      CHARACTER RS_LABEL*(*)
      INTEGER IERROR,IS_REST(4)
C
C----Local variables
      INTEGER I,LEN_RS
      INTEGER LENSTR
      EXTERNAL LENSTR
C
      IERROR = 0
      IS_REST(1) = 0
      IS_REST(2) = 0
      IS_REST(3) = 0
      IS_REST(4) = 0
C
      LEN_RS = LENSTR(RS_LABEL)
      DO   I=1,LEN_RS
        IF(RS_LABEL(I:I).EQ.'_') GOTO 100
      ENDDO
C
c---No underscore. Error
      IERROR = 1
      RETURN
C
 100  CONTINUE
      IF(I.NE.LEN_RS-3) THEN
        IERROR = 1
        RETURN
      ENDIF
      IF(I.LE.1) THEN
        IERROR = 1
        RETURN
      ENDIF
C
C---Now extarct symmetry
      READ(RS_LABEL(1:I-1),*)IS_REST(1)
      I = I + 1
      READ(RS_LABEL(I:I),'(I1)')IS_REST(2)
      IS_REST(2) = IS_REST(2) - 5
      I = I + 1
      READ(RS_LABEL(I:I),'(I1)') IS_REST(3)
      IS_REST(3) = IS_REST(3) - 5
      I = I + 1
      READ(RS_LABEL(I:I),'(I1)')IS_REST(4)
      IS_REST(4) = IS_REST(4) - 5
C
      RETURN
      END

C
cd      SUBROUTINE DIVIDE_PLANES
C
cd      DO   IPL = 1,NPLANE
cd        IF(N_BOND_ATOM(IPL).GT.1.AND.PLANE_ATOM_ALL_FLAG(IPL).GT.0) THEN
cd          IAT_PLANE = 1
cd          PLANE_ATOM = (IPL)
cd          DO   IPL1 = 1,N_BOND_ATOM(IPL)
cd            IAT_PLANE = IAT_PLANE + 1
cd            PLANE_ATOM(IAT_PLANE) = (IPL1)
cd            PLANE_ATOM_ALL_FLAG(IPL1) = 0
cd            DO  IPL2 = 1,NBOND_ATOM(IPL1)
cd              IAT_PLANE = IAT_PLANE + 1
cd              PLANE_ATOM(IAT_PLANE) = (IPL2)
cd            ENDDO
cd          ENDDO
cd        ENDIF
cd      ENDDO
C
      SUBROUTINE READ_STR_REFMAC
C
      IMPLICIT NONE
      INCLUDE 'atom_com.fh'
      INCLUDE 'atom_com_str.fh'
      INCLUDE 'ref_com_str.fh'
      INCLUDE 'crd_com.fh'
      INCLUDE 'makecif.fh'
      INCLUDE 'const.fh'
      INCLUDE 'monitor.fh'
      INCLUDE 'refi_flags.fh'
      INCLUDE 'weights.fh'
C
      CHARACTER*15 AT_FULL1,AT_FULL2,AT_FULL3,AT_FULL4
      INTEGER MD,IN,IERR,IEND,IATOM_C,IA_TYPE,LENSTR,IA
      INTEGER IFLAG_OCC,IMODE,I,J,IERROR,I1,I2,I3,I4
      CHARACTER EXTR*2,PATHR*2
      LOGICAL LEXISTS
C
      MD  = -999
      IN  = 0
      PATHR = ' '
      EXTR = ' '
      IERR = 0
C
C---First check if STRUCT_FILE exists
      IF(STRUCT_FILE.EQ.' ') THEN
        CALL DEFAULT_ATOMTYPE
        RETURN
      ENDIF
      INQUIRE (FILE=STRUCT_FILE(1:LENSTR(STRUCT_FILE)),EXIST=LEXISTS)
      IF(.NOT.LEXISTS) THEN
C
C--Set defaults atomic types and radii. It happens in unrestrained refinement
        CALL DEFAULT_ATOMTYPE
        RETURN  
      ENDIF
      CALL READ_STR(MD,PATHR,STRUCT_FILE,EXTR,IERR)
      IF(IERR.GT.0) THEN
        CALL ERRWRT(-1,'Something is wrong with tree')
        CALL errwrt(1,'Reading tree filed')
      ENDIF
C
C---Find maximum vdw radius and replace default maximum if default is less 
C---than that from coordinates
cd      call default_atomtype
      DO   IA=1,N_ATOM
        if(OCCUP(IA).GT.0.0) THEN
          DVDW_CUT_MIN = AMAX1(DVDW_CUT_MIN,VDW_RAD(IA))
        endif
      ENDDO

cd      IF(MODE.NE.'INTE') RETURN
C
c---Now we have read tree and all these stuff. Now initialise and check
c---tree.
C
cd      IMODE = 0
cd      CALL TREE_INITIALIZATION(MD,IMODE,IFLAG_OCC,IERR)
C
C--Remember if IFLAG_OCC = 1 then some atoms have 0 occupancy.

cd      IF(IERR.GT.1) THEN
cd        CALL ERRWRT(-1,'Intialisation of tree')
cd        CALL CCPERR(1,'Tree initialisation failed')
cd      ENDIF
C
cd      IMODE = 1
cd      CALL ANGTOCR_STR(MD,IMODE,IERR)
cd      IF(IERR.GT.0) THEN
cd        CALL 
cd     &  CCPERR(1,'Conversion of angles to cartesian coordinates failed')
cd      ENDIF
C
cd      IMODE = 0
cd       DO   I=1,N_TREE
cd         J                 = IATM_FIRST_TREE_C(I) 
cd         XYZ_TREE(1,I)     = XYZ_CRD(1,J)
cd         XYZ_TREE(2,I)     = XYZ_CRD(2,J)
cd         XYZ_TREE(3,I)     = XYZ_CRD(3,J)
cd         ANGLES_TREE(1,I)  = 0.0
cd         ANGLES_TREE(2,I)  = 0.0
cd         ANGLES_TREE(3,I)  = 0.0
cd       ENDDO
cd      CALL CRTOANG_STR(IMODE,IERR)
cd      IF(IERR.GT.0) THEN
cd        CALL CCPERR(1,'Conversion from coordinates to angels failed')
cd      ENDIF
C
C---Now test tree etc.
C
cd      IF(MON_STYLE.EQ.'TEST') THEN
cd      WRITE(*,*)'Number of variable angles =',N_PHI
cd      WRITE(*,*)'Number of trees           =',N_TREE
cd      DO   I=1,N_PHI
cd         I1 = IP_PSI(I)
cd         CALL FULL_ATOM_NAME(I1,AT_FULL1,IERROR)
cd         I2 = IATM_BACK(I1)
cd         IF(I2.GT.0) THEN 
cd           I3 = IATM_BACK(I2)
cd           CALL FULL_ATOM_NAME(I2,AT_FULL2,IERROR)
cd         ELSE
cd           I3 = 0
cd           AT_FULL2 = ' '
cd         ENDIF
cd         IF(I3.GT.0) THEN
cd           I4 = IATM_BACK(I3)
cd           CALL FULL_ATOM_NAME(I3,AT_FULL3,IERROR)
cd         ELSE
cd           I4 = 0
cd           AT_FULL3 = ' '
cd         ENDIF
cd         IF(I4.GT.0) THEN
cd           CALL FULL_ATOM_NAME(I4,AT_FULL4,IERROR)
cd         ELSE
cd           AT_FULL4 = ' '
cd         ENDIF
cd         WRITE(*,*)AT_FULL1,AT_FULL2,AT_FULL3,AT_FULL4
C
cd         WRITE(*,*)'Phi type ',PHI_VAR(I)*RTODEG,ID_TREE(I1),AT_FULL1,
cd     &            PHI_TYPE(I)
cd      ENDDO
C
C---Print out extra links

cd      DO   IA = 1,N_ATOM
cd        CALL FULL_ATOM_NAME(IA,AT_FULL1,IERROR)
cd        WRITE(*,*)IA,OCCUP(IA),AT_FULL1,ID_PHI(IA),ID_TREE(IA)
cd      ENDDO

cd      STOP
cd      ENDIF
      RETURN
      END
C
      SUBROUTINE DEFAULT_ATOMTYPE
C
C---Defines default atom types. They are names of elements and some default
C---radii for them
      IMPLICIT NONE
      INCLUDE 'atom_com.fh'
      INCLUDE 'atom_com_str.fh'
C
      INTEGER IA
C
cd      CALL ERRWRT(1,'Here we are')
      IF(N_ATOM.LE.0) THEN
        CALL ERRWRT(-1,' ')
        CALL ERRWRT(-1,'There is no atom. DEFAULT_ATOMTYPE should'
     &           //' be called when atoms have already been read')
        CALL ERRWRT(1,'PROBLEM in DEFAULT_ATOMTYPE')
      ENDIF  
      DO   IA = 1,N_ATOM
        CHEM_TYPE(IA)     = CS_ATYPE(ID_SF(IA))
        HB_TYPE(IA) = 'N'
        IF(CS_ELEMENT(ID_SF(IA)).EQ.'H ') THEN
           VDW_RAD(IA) = 1.2
           ION_RAD(IA) = -1.0
c          VDW_RAD(IA) = 0.7
        ELSE IF(CS_ELEMENT(ID_SF(IA)).EQ.'O ') then
           VDW_RAD(IA) = 1.52
           ION_RAD(IA) = 1.28
        ELSE IF(CS_ELEMENT(ID_SF(IA)).EQ.'C ') then
           VDW_RAD(IA) = 1.8
           ION_RAD(IA) = -1.0
        ELSE IF(CS_ELEMENT(ID_SF(IA)).EQ.'N ') then
           VDW_RAD(IA) = 1.55
           ION_RAD(IA) = 1.32
        ELSE IF(CS_ELEMENT(ID_SF(IA)).EQ.'S ') then
           VDW_RAD(IA) = 1.80
           ION_RAD(IA) = 0.4
        ELSE IF(CS_ELEMENT(ID_SF(IA)).EQ.'P ') then
           VDW_RAD(IA) = 1.80
           ION_RAD(IA) = 0.59
        ELSE
          VDW_RAD(IA) = 1.8
          ION_RAD(IA) = -1.0
        ENDIF
      ENDDO
      RETURN
      END
C
      SUBROUTINE REFPRE
      IMPLICIT NONE
C
C---Reads and prepares reflection list.
      INCLUDE 'atom_com.fh'
      INCLUDE 'agreem.fh'
      INCLUDE 'pls_incl.fh'
      INCLUDE 'celsym.fh'
      INCLUDE 'refi_flags.fh'
      INCLUDE 'weights.fh'
      INCLUDE 'const.fh'
      include 'map_params.fh'

      INTEGER ISYSR,ISYSW,IFOFC,ISCRF,IATMR,IDISK,JDISK,NEWFIL,INXYZ,
     &        IOUTX,MTZIN
      COMMON /FILES / ISYSR,ISYSW,IFOFC,ISCRF,IATMR,IDISK,JDISK,NEWFIL
     .               ,INXYZ,IOUTX,MTZIN
C
      integer sz
      INTEGER HMAX,KMAX,LMAX
      COMMON /HKLLIM/ HMAX, KMAX, LMAX
C
      CHARACTER LINE*120
C
C---Scratch area for everything
      REAL VAL
c      COMMON  /R_SCRATCH/ VAL(QQDEN)
C
c
c---allocatable
      integer, allocatable :: inds(:)
      integer, allocatable :: lind(:)
      integer, allocatable :: freer(:)
      real, allocatable :: fo(:)
      real, allocatable :: sigo(:)
      real, allocatable :: fo_map(:)
      real, allocatable :: sigo_map(:)
      real, allocatable :: fpart(:)
      real, allocatable :: apart(:)
      real, allocatable :: hlabcd(:)
      real, allocatable :: fo_weight(:)
      INTEGER I,IPAKLM,INTLIM,NO,NGX,NGY,NGZ
      REAL STLMIN0,STLMAX0,SMAX
C
C---Define bins 
      STLMIN0 = STLMIN
      STLMAX0 = STLMAX
      stlmin_input = stlmin
      stlmax_input = stlmax
      IF(REFTYP.EQ.'MTZ') THEN
C
C---Find maximum resolution of observed structure factors
         CALL MTZ_FIND_MAX_RESO_FO(MTZIN,STLMIN0,STLMAX0)
      ENDIF

      STLMAX = AMIN1(STLMAX,STLMAX0)
      SMINS  = AMIN1(STLMIN,SMINS)
      SMAXS  = AMAX1(STLMAX,SMAXS)
      if(.not.map_extend_flag) then
         stlmin_input = stlmin
         stlmax_input = stlmax
      endif
C
      BINSIZE  = (STLMAX**2 - STLMIN**2)/NBIN
      SMINB(1) = STLMIN
      DO    I=2,NBIN
        SMINB(I)   = SQRT(SMINB(I-1)**2 + BINSIZE)
        SMAXB(I-1) = SMINB(I)
      ENDDO
      SMAXB(NBIN)   = STLMAX
      SMAXB(NBIN+1) = SMINB(1)
      SMINB(NBIN+1) = SMINB(1)
C
C---If we are using mtz open and read usefull information from there
      SMAX = STLMAX*2.0
      HMAX = INT(CELL(1)*SMAX)
      KMAX = INT(CELL(2)*SMAX)
      LMAX = INT(CELL(3)*SMAX)
C
C   Check packing limits - cant go above 2**23
      IPAKLM = LMAX* (2*KMAX+1) * (2*HMAX+1)
      INTLIM = 1024*1024*512
      IF(IPAKLM .GT. INTLIM) THEN
         WRITE(LINE,'(A,A,I10)')
     +          ' Packing problem - your cell is TOO BIG! ',
     +          'Maximum allowed packed index',INTLIM
         CALL ERRWRT(0,LINE)
         WRITE(LINE,'(A,I10)')
     +         ' Maximum expected from this cell and resolution:',IPAKLM
         CALL ERRWRT(1,LINE)
      ENDIF
      SZ = NOBS 
C---
C---First define sizes of arrays and give space for them
      allocate(inds(SZ))
      allocate(fo(sz))
      allocate(sigo(sz))
      allocate(lind(sz))
      allocate(freer(sz))
      if(fpart_flag) then
         allocate(fpart(npart*sz))
         allocate(apart(npart*sz))
      else
         allocate(fpart(2))
         allocate(apart(2))
      endif
      if(mir_flag.or.phase_flag) then
         allocate(hlabcd(4*sz))
      else
         allocate(hlabcd(4))
      endif
      allocate(fo_map(sz))
      allocate(sigo_map(sz))
      allocate(fo_weight(sz))
C
C----Read reflection and write into Reflscr unformatted file
      IF(REFTYP.EQ.'MTZ') THEN
C
C---Reflection are in MTZ format
        CALL MTZRED(no,inds,fo,sigo,freer,lind,fpart,apart,hlabcd,
     &        fo_map,sigo_map,fo_weight,sz)

      ELSE
        CALL ERRWRT(1,'Other than MTZ reflection type')
      ENDIF
      CALL GET_GRID_SPACING(FSHANN,NGX,NGY,NGZ,HMAX,KMAX,LMAX)
C
C---Report grids
      N1 = NX/IPX
      N2 = NY/IPY
      N3 = NZ/IPZ
c
c---  deallocate
      deallocate(inds)
      deallocate(fo)
      deallocate(sigo)
      deallocate(freer)
      deallocate(lind)
      deallocate(fpart)
      deallocate(apart)
      deallocate(fo_map)
      deallocate(sigo_map)
      deallocate(fo_weight)

      RETURN
      END
C
 
      SUBROUTINE MTZ_FIND_MAX_RESO_FO(MTZIN,STLMIN0,STLMAX0)
      IMPLICIT NONE
C
C---This subroutine finds resolution limits for fobs.
      INTEGER MTZIN
      REAL STLMIN0,STLMAX0
C
C---Areas for reading mtz file
      INTEGER MCOLS
      PARAMETER (MCOLS = 200)
      INTEGER LOOKUP(MCOLS)
      LOGICAL LOGMSS(MCOLS)
C
      INTEGER NLPRGI,NLPRGO
      COMMON /MTZRD/NLPRGI,NLPRGO,LOOKUP
C
C--Array for mtz
      REAL ADATA(200)
C
C---Local scalars
      INTEGER IFO,ISO,NREF
      REAL SSQMAX0,SSQMAX,SSQMIN0,SSQMIN,SSQ
      LOGICAL EOF
C
      IFO     = LOOKUP(4)
      ISO     = LOOKUP(5)
      SSQMAX  = (2.0*STLMAX0)**2
      SSQMAX0 = -1.0E32
      SSQMIN0 = 1.0E32
      NREF    = 0
 10   CONTINUE
      CALL LRREFL(MTZIN,SSQ,ADATA,EOF)
      IF(EOF) GOTO 100
      NREF = NREF + 1
      IF(SSQ.GT.SSQMAX) GOTO 10
      CALL LRREFM(MTZIN,LOGMSS)
      IF(.NOT.LOGMSS(IFO) ) THEN
        SSQMAX0 = AMAX1(SSQMAX0,SSQ)
        SSQMIN0 = AMIN1(SSQMIN0,SSQ)
      ENDIF
      IF(.NOT.LOGMSS(ISO) ) THEN
        SSQMAX0 = AMAX1(SSQMAX0,SSQ)
        SSQMIN0 = AMIN1(SSQMIN0,SSQ)
      ENDIF
C
      GOTO 10
 100  CONTINUE
      STLMAX0 = SQRT(SSQMAX0)/2.0
      STLMIN0 = SQRT(SSQMIN0)/2.0
      CALL LRREWD(MTZIN)
      RETURN
      END
C
      SUBROUTINE MTZRED(NO,NIND,FO,SIGO,FREER,LIND,FPART,PHIP,ABCD,
     +  fo_map,sigo_map,fo_weight,SZ)
C
C---Subroutine reads reflection from mtz file sorts them (l>0 h fastest
C---k second and l slowest indices
C---writes sorted reflections into unformatted output file. LIND stores
C---information about old sort
C---
      INCLUDE 'agreem.fh'
      INCLUDE 'celsym.fh'
      INCLUDE 'monitor.fh'
      INCLUDE 'refi_flags.fh'
      INCLUDE 'weights.fh'
      INCLUDE 'const.fh'
      include 'restr_files.fh'

      INTEGER SZ
      REAL FO(*),SIGO(*),FREER(*),FPART(*),PHIP(*),ABCD(*)
      real fo_map(sz),sigo_map(*)
      real fo_weight(sz)
      INTEGER NIND(SZ),LIND(SZ)
      COMMON /FILES / ISYSR,ISYSW,IFOFC,ISCRF,IATMR,IDISK,JDISK,NEWFIL
     .               ,INXYZ,IOUTX,MTZIN
      EXTERNAL PACK,UNPACK
C
C---Areas for reading mtz file
      PARAMETER (MCOLS = 200)
      INTEGER LOOKUP(MCOLS)
      LOGICAL LOGMSS(MCOLS)
C
      COMMON /MTZRD/NLPRGI,NLPRGO,LOOKUP
      REAL ADATA(200)
      REAL STLMAX0
      LOGICAL EOF
      INTEGER IHH(3)
c
      integer ifo_map,isigo_map,ifo_weight
      integer ifomap_unit,ifail,ll
      character scr1*512
C
C---
      REAL FPP(NMAXPART),PHPP(NMAXPART)
      INTEGER IFPART(NMAXPART),IAPART(NMAXPART)
      REAL SIGNORM(100)
      CHARACTER LINE*120
      REAL HLA,HLB,HLC,HLD
C
      REAL LSTLSQ
      EXTERNAL  LSTLSQ
C
C---Now read reflections into massive
      IFO    = LOOKUP(4)
      ISO    = LOOKUP(5)
      IFREE = 0
      IHLA  = 0
      IHLB  = 0
      IHLC  = 0
      IHLD  = 0
      IFOM  = 0
      IPB   = 0
      IF(FREER_FLAG) IFREE=LOOKUP(6)
      IF(FPART_FLAG) THEN
         DO    IP=1,NPART
           IFPART(IP) = 0
           IAPART(IP) = 0
         ENDDO
         IP1 = 0
         DO    IP=1,NMAXPART
           IF(LOOKUP(5+2*IP).NE.0 .AND. LOOKUP(6+2*IP).NE.0) THEN
             IP1 = IP1+1
             IFPART(IP1) = LOOKUP(5+2*IP)
             IAPART(IP1) = LOOKUP(6+2*IP)
             ISCPART(IP1) = ISCPART(IP)
           ENDIF
         ENDDO
      ENDIF
      IF(MIR_FLAG) THEN
         IHLA=max(0,LOOKUP(6+2*NMAXPART + 1))
         IHLB=max(0,LOOKUP(6+2*NMAXPART + 2))
         IHLC=max(0,LOOKUP(6+2*NMAXPART + 3))
         IHLD=max(0,LOOKUP(6+2*NMAXPART + 4))
      ENDIF
      IF(PHASE_FLAG) THEN
         IFOM = max(0,LOOKUP(6+2*NMAXPART+5))
         IPB  = max(0,LOOKUP(6+2*NMAXPART+6))
         CALL BESSTAB
      ENDIF
      if(fomap_flag) then
         ifo_map=max(0,lookup(6+2*nmaxpart+7))
         isigo_map=max(0,lookup(6+2*nmaxpart+8))
         if(ifo_map.le.0 .or. isigo_map .le. 0 ) fomap_flag = .FALSE.
      endif
      if(foweight_flag) then
         ifo_weight = max(0,lookup(6+2*nmaxpart+9))
      endif
      NREF = 0
      I = 0
      SSQMAX = (2.0*STLMAX_input)**2
      SSQMAX0 = SSQMAX
C
 20   CONTINUE
      CALL LRREFL(MTZIN,SSQ,ADATA,EOF)
      do while(.not.eof)
         NREF = NREF + 1
         IF(SSQ.le.SSQMAX)  then
            CALL LRREFM(MTZIN,LOGMSS)
            IF(LOGMSS(IFO) ) ADATA(IFO) = 0.0
            IF(LOGMSS(ISO) ) ADATA(ISO) = -0.01
C
C---Problem with 0 reflections. I think you can't have 0 refections without
C---having 0 sigma's. Some data processing softwares give 0 reflections
C---I am replacing them with unknown reflections which is not best thing in the
C---world. But this problem should be dealt in data processing programs and 
C---if intensities are less than 0 they should be converted into positive
C---amplitudes as it is done by TRUNCATE (reference: French and Wilson 1978??)
            IF(ADATA(IFO).LE.0.0) ADATA(ISO) = -0.01
            I = I+1
C
C---If we should read other information (Fpart,PHI,ABCD or others
C---add here
            IH      = NINT(ADATA(1))
            IK      = NINT(ADATA(2))
            IL      = NINT(ADATA(3))
            IHH(1) = IH
            IHH(2) = IK
            IHH(3) = IL
            CALL CENTR(IHH,ICENT)
            FO(I)   =  ADATA(IFO)*exp(b_sharp_refine*ssq/4.0)
            SIGO(I) =  ADATA(ISO)*exp(b_sharp_refine*ssq/4.0)
cd      SIGO(I) =  FO(I)*0.01
            LIND(I) = I
            IF(FREER_FLAG) THEN
               IF(LOGMSS(IFREE)) then
                  if(LfreeRexcludeVal.eq.0) then
                     freer(i) = 1.0
                  else
                     freer(i) = 0.0
                  endif
               else
                  freer(i) = adata(ifree)
               endif
               IF(LOGMSS(IFO) .OR. LOGMSS(ISO))  FREER(I) = -FREER(I)
            END IF
            IF(FPART_FLAG) THEN
               DO    IP=1,NPART
                  IPOS = I+(IP-1)*NOBS
                  FPART(IPOS) = 0.0
                  PHIP(IPOS) = 0.0
                  IF(.NOT.LOGMSS(IFPART(IP))) 
     &                 FPART(IPOS)=ADATA(IFPART(IP))
                  IF(.NOT.LOGMSS(IFPART(IP))) 
     &                 PHIP(IPOS)=ADATA(IAPART(IP))
               ENDDO
            ELSE
               NSCPART = 0
            ENDIF
            IF(MIR_FLAG) THEN
               HLA = 0.0
               HLB = 0.0
               HLC = 0.0
               HLD = 0.0
               IF(.NOT.LOGMSS(IHLA).AND..NOT.LOGMSS(IHLB).AND.
     +              .NOT.LOGMSS(IHLC).AND..NOT.LOGMSS(IHLD)) THEN
                  IF(IHLA.NE.0) HLA = ADATA(IHLA)
                  IF(IHLB.NE.0) HLB = ADATA(IHLB)
                  IF(IHLC.NE.0) HLC = ADATA(IHLC)
                  IF(IHLD.NE.0) HLD = ADATA(IHLD)
               ENDIF
            ENDIF
            IF(.NOT.MIR_FLAG.AND.PHASE_FLAG) THEN
               FOM = 1.0
               IF(IFOM.GT.0) THEN
                  FOM = 0.0
                  IF(.NOT.LOGMSS(IFOM)) FOM = ADATA(IFOM)
               ENDIF
               IF(.NOT.LOGMSS(IPB)) THEN
                  PHASE = ADATA(IPB)
               ELSE
                  FOM   = 0.0
                  PHASE = 0.0 
               ENDIF
               CALL FOMPHASE2AB(ICENT,FOM,PHASE,HLA,HLB)
               HLC = 0.0
               HLD = 0.0
            ENDIF
            IF(MIR_FLAG.OR.PHASE_FLAG) THEN
               IPOS        = I
               RSQ         =  LSTLSQ(MTZIN,IH,IK,IL)
               BLUR_FACTOR = PHAS_BLUR_SCAL*EXP(-RSQ*PHAS_BLUR_BVAL)
               ABCD(IPOS)  = HLA*BLUR_FACTOR
               IPOS        = IPOS+NOBS
               ABCD(IPOS)  = HLB*BLUR_FACTOR
               IPOS        = IPOS+NOBS
               ABCD(IPOS)  = HLC*BLUR_FACTOR
               IPOS        = IPOS+NOBS
               ABCD(IPOS)  = HLD*BLUR_FACTOR
            ENDIF
            if(fomap_flag) then
               tmp_loc = exp(b_sharp_refine*ssq/4.0)
               fo_map(i) = adata(ifo_map)*tmp_loc
               sigo_map(i) = adata(isigo_map)*tmp_loc
            else
               fo_map(i) = fo(i)*exp(b_sharp_refine*ssq/4.0)
               sigo_map(i)=sigo(i)*exp(b_sharp_refine*ssq/4.0)
            endif
            if(foweight_flag.and.ifo_weight.gt.0) then
               fo_weight(i) = adata(ifo_weight)
            else
               fo_weight(i) = 1.0
            endif
C
            IF(IL.LT.0) THEN
               IH      = -IH
               IK      = -IK
               IL      = -IL
               LIND(I) = -LIND(I)
               IF(FPART_FLAG) THEN
                  DO    IP=1,NPART
                     IPOS       = I+(IP-1)*NOBS
                     PHIP(IPOS) = -PHIP(IPOS)
                  ENDDO
               ENDIF
               IF(MIR_FLAG.OR.PHASE_FLAG) THEN
                  IPOS       = I + NOBS
                  ABCD(IPOS) = -ABCD(IPOS)
                  IPOS       = IPOS + 2*NOBS
                  ABCD(IPOS) = -ABCD(IPOS)
               ENDIF
            ELSEIF(IL.EQ.0.AND.IK.LT.0) THEN
               IK = -IK
               IH = -IH
               LIND(I) = -LIND(I)
               IF(FPART_FLAG) THEN
                  DO    IP=1,NPART
                     IPOS = I+(IP-1)*NOBS
                     PHIP(IPOS) = -PHIP(IPOS)
                  ENDDO
               ENDIF
               IF(MIR_FLAG.OR.PHASE_FLAG) THEN
                  IPOS = I + NOBS
                  ABCD(IPOS) = -ABCD(IPOS)
                  IPOS = IPOS + 2*NOBS
                  ABCD(IPOS) = -ABCD(IPOS)
               ENDIF
            ELSEIF(IL.EQ.0.AND.IK.EQ.0.AND.IH.LT.0) THEN
               IH = -IH
               LIND(I) = -LIND(I)
               IF(FPART_FLAG) THEN
                  DO    IP=1,NPART
                     IPOS = I+(IP-1)*NOBS
                     PHIP(IPOS) = -PHIP(IPOS)
                  ENDDO
               ENDIF
               IF(MIR_FLAG.OR.PHASE_FLAG) THEN
                  IPOS = I + NOBS
                  ABCD(IPOS) = -ABCD(IPOS)
                  IPOS = IPOS + 2*NOBS
                  ABCD(IPOS) = -ABCD(IPOS)
               ENDIF
            ENDIF
            CALL PACK(IND,IH,IK,IL)
C
C----Add some calculation to calculate number of reflections in bins 
C---- and so on
            NIND(I) = IND
         endif
         call lrrefl(mtzin,ssq,adata,eof)
      enddo
      IF(PHASE_FLAG) MIR_FLAG = .TRUE.
      NO = I
      IF(NO.GT.SZ) THEN
         LINE =  ' ***ERROR- More observed data than is consistent'
         CALL ERRWRT(-1,LINE)
         LINE =  ' with the resolution cut-off and the spacegroup. ***'
         CALL ERRWRT(-1,LINE)
         LINE = ' Are you inputting only ONE asymmetric unit?'
         CALL ERRWRT(1,LINE)
      END IF
C
c---Now define resolution bins for MLestimates. Take care of minimum
C----resolution of actual observed data and minimum resolution desired.
C----They might be different.
C
      CALL DEFINE_BINS_FOR_ML(NO,NIND,FO,SIGO,FREER)
c
C---  Now sort reflections
      WRITE(ISYSW,'(A,I10)')' Number of reflections in file ',NREF
      WRITE(ISYSW,'(A,I10)')' Number of reflection read     ',NO
      CALL ISORT1(NO,NIND,LIND)
C
C---Now write into output file sorted reflections
      IFAIL = -1
      CALL CCPDPN(ISCRF,'REFSCR','UNKNOWN','U',LL,IFAIL)
      IFSCR_SAVE = ISCRF

c      if(fomap_flag) then
      call ugtenv('TEMP1',scr1)
      l1=lenstr(scr1)
      if(l1.gt.0) then
         fomap_file = scr1(1:l1)//'.fomap'
      else
         fomap_file = 'local_file.fomap'
      endif
      ifail = -1
      ll    =  0
      ifomap_unit = 0
      call ccpdpn(ifomap_unit,fomap_file,'UNKNOWN','U',ll,ifail)
      do i=1,no
         lnd = abs(lind(i))
         write(ifomap_unit) fo_map(lnd),sigo_map(lnd),fo_weight(lnd)
      enddo
      close(ifomap_unit)
c      endif
c
      DO     I=1,NO
        LND = IABS(LIND(I))
C
C--If phases process here
c
c--Each type of dat ain a seperate file?
        IND = NIND(I)
        CALL UNPACK(IND,IH,IK,IL)
        RSQ   =  LSTLSQ(MTZIN,IH,IK,IL)
        STHOL = SQRT(RSQ)
        IF(MIR_FLAG) THEN
          IPOS = LND
          HLA  = ABCD(IPOS)
          IPOS = IPOS+NOBS
          HLB  = ABCD(IPOS)
          IPOS = IPOS+NOBS
          HLC  = ABCD(IPOS)
          IPOS = IPOS+NOBS
          HLD  = ABCD(IPOS)
        ENDIF
cd        FO(LND) = FO(LND)*EXP(RSQ*60)
cd        SIGO(LND) = SIGO(LND)*EXP(RSQ*60)
        IF(FREER_FLAG.AND.FPART_FLAG) THEN
          DO    IP=1,NPART
            IPOS = LND+(IP-1)*NOBS
            FPP(IP) = FPART(IPOS)
            PHPP(IP) = PHIP(IPOS)
          ENDDO
          IF(.NOT.MIR_FLAG) THEN
            WRITE(ISCRF)IH,IK,IL,STHOL,FO(LND),SIGO(LND),FREER(LND),
     +               LIND(I),(FPP(IP),PHPP(IP),IP=1,NPART)
          ELSE
            WRITE(ISCRF)IH,IK,IL,STHOL,FO(LND),SIGO(LND),FREER(LND),
     +               LIND(I),(FPP(IP),PHPP(IP),IP=1,NPART),
     +               HLA,HLB,HLC,HLD
          ENDIF
        ENDIF
        IF(.NOT.FREER_FLAG.AND.FPART_FLAG) THEN
          DO    IP=1,NPART
            IPOS = LND+(IP-1)*NOBS
            FPP(IP) = FPART(IPOS)
            PHPP(IP) = PHIP(IPOS)
          ENDDO
          IF(.NOT.MIR_FLAG) THEN    
            WRITE(ISCRF)IH,IK,IL,STHOL,FO(LND),SIGO(LND),
     +            LIND(I),(FPP(IP),PHPP(IP),IP=1,NPART)
          ELSE
            WRITE(ISCRF)IH,IK,IL,STHOL,FO(LND),SIGO(LND),
     +        LIND(I),(FPP(IP),PHPP(IP),IP=1,NPART),
     +        HLA,HLB,HLC,HLD
          ENDIF
        ENDIF
        IF(FREER_FLAG.AND. .NOT.FPART_FLAG) THEN
          IF(.NOT.MIR_FLAG) THEN
             WRITE(ISCRF)IH,IK,IL,STHOL,FO(LND),SIGO(LND),FREER(LND),
     +               LIND(I)
          ELSE
             WRITE(ISCRF)IH,IK,IL,STHOL,FO(LND),SIGO(LND),FREER(LND),
     +               LIND(I),HLA,HLB,HLC,HLD
          ENDIF
        ENDIF
        IF(.NOT.FREER_FLAG.AND. .NOT.FPART_FLAG) THEN
          IF(.NOT.MIR_FLAG) THEN
            WRITE(ISCRF)IH,IK,IL,STHOL,FO(LND),SIGO(LND),
     +               LIND(I)
          ELSE
            WRITE(ISCRF)IH,IK,IL,STHOL,FO(LND),SIGO(LND),
     +               LIND(I),HLA,HLB,HLC,HLD
          ENDIF
        ENDIF
      ENDDO
C
C---Close file for writing and open for reading.
      REWIND(ISCRF)
cd      CLOSE(UNIT = ISCRF)
      IF(MIR_FLAG) CALL EXPCOS_TABLE
      NPARTALL = NPART
      NPART    = NSCPART
      NOBS = NREF + 1
      RETURN
      END
C
      SUBROUTINE DEFINE_BINS_FOR_ML(NO,NIND,FO,SIGO,FREER)
      IMPLICIT NONE
C
C---Defines resolution bins for ML parameters estimation.
C---Number of reflections necessary for estimation of ML
C---parameters (NMIN_REF_BINS) has been defined before this routine
C---
      INCLUDE 'weights.fh'
      INCLUDE 'refi_flags.fh'
      INCLUDE 'agreem.fh'
      INTEGER NO
      INTEGER NIND(*)
      REAL FO(*),FREER(*),SIGO(*)
C
C----Local variables
      REAL STL_C,STLMN_FO,STLMX_FO,RSQ,BINSIZE_ML_DELTA
      INTEGER NREF_ALL
      INTEGER I,IREF,I_START,ICASE,IB,NMIN_REF_IN_BINS
      CHARACTER LINE*256
      LOGICAL FREERCHK
      STLMIN_ML = STLMIN*2.0
      STLMAX_ML = STLMAX*2.0
C
C---Find actual resolution range for observed amplitudes.
C---Resoluiton used for map calculation might be different from
C---this value
      STLMX_FO  = -1.0E32
      STLMN_FO  = 1.0E32
      DO   IREF = 1,NO
         IF(SIGO(IREF).GT.0.0.AND.FO(IREF).GT.0.0) THEN
           CALL INDTORS(NIND(IREF),RSQ)
           STL_C = SQRT(RSQ)
           STLMN_FO = AMIN1(STLMN_FO,STL_C)
           STLMX_FO = AMAX1(STLMX_FO,STL_C)
         ENDIF
      ENDDO
      STLMIN_ML = AMAX1(STLMN_FO,STLMIN_ML)
      STLMAX_ML = AMIN1(STLMX_FO,STLMAX_ML)
C
C---BINSIZE has been defined before this routine.
C---Start defining resolution bins. 

C
C---Now find number of bins. Start with largest possible and then decide.
C
      IF(MLUSEWORK) THEN
        NMIN_REF_IN_BINS = 100
      ELSE
        NMIN_REF_IN_BINS =  50
      ENDIF
C
 1    continue
      BINSIZE_ML = 0.0005
      NBIN_ML = MAX(1,MIN(MAXBIN,
     &     INT(((STLMAX_ML**2-STLMIN_ML**2)/BINSIZE_ML)) 
     &               + 1))
      NBIN_ML = MAX(1,MIN(30,NBIN_ML))
       BINSIZE_ML = 
     &         ((STLMAX_ML**2-STLMIN_ML**2)/NBIN_ML)
cd      BINSIZE_ML = ((STLMAX_ML**2-STLMIN_ML**2)/MAXBIN)
      BINSIZE_ML_DELTA = BINSIZE_ML/5.0
C
      NBIN_ML = MAXBIN
 9    CONTINUE
      SMINB_ML(1) = STLMIN_ML
      DO   I=2,NBIN_ML
        SMINB_ML(I) = (SMINB_ML(I-1)**2 + BINSIZE_ML)**(1.0/2.0)
        SMAXB_ML(I-1) = SMINB_ML(I)
      ENDDO
      SMAXB_ML(NBIN_ML) = STLMAX_ML
C
C---  Now check if there are enough reflections in each bin
C

C
C----Find number of reflections in the resolution bins
      DO   I=1,NBIN_ML
        NREF_ML(I) = 0
      ENDDO
      NREF_ALL = 0
      DO   IREF=1,NO
        FREERCHK = .FALSE.
        IF(FREER_FLAG )THEN 
          IF((.NOT.MLUSEWORK)  .AND.
     +    (ABS(FREER(IREF)-LFreeRexcludeVal).LT.0.1))FREERCHK = .TRUE.
          IF(       MLUSEWORK   .AND. 
     +    (ABS(FREER(IREF)-LFreeRexcludeVal).GT.0.1))FREERCHK = .TRUE.
        END IF
        IF(((.NOT.FREER_FLAG).OR.FREERCHK).AND.SIGO(IREF).GT.0.0) THEN
          CALL INDTORS(NIND(IREF),RSQ)
          STL_C = SQRT(RSQ)
          DO   I=1,NBIN_ML
            IF(STL_C.LE.SMAXB_ML(I).AND.STL_C.GE.SMINB_ML(I)) THEN
              NREF_ML(I) = NREF_ML(I) + 1
              NREF_ALL   = NREF_ALL + 1
            ENDIF
          ENDDO
        ENDIF
      ENDDO
C
C----Check if there are enough reflection in each bin. 
      IF(NBIN_ML.EQ.1.AND..NOT.MLUSEWORK.AND.
     &              NREF_ALL.LE.NMIN_REF_IN_BINS.AND.
     &                                       FREER_FLAG) THEN
        CALL ERRWRT(0,'Not enough reflections for ML parameters')
        WRITE(LINE,'(A,I6)')
     &                    'Number of reflections for ML = ',NREF_ML(1)
        CALL ERRWRT(0,LINE)
        CALL ERRWRT(0,'Switching to option "SCALE MLSCALE WORK"')
        CALL ERRWRT(0,'I.e. use working reflection for ML estimation')
        MLUSEWORK = .TRUE.
        NMIN_REF_IN_BINS = 100
        GOTO 1
      ELSEIF(NBIN_ML.EQ.1) THEN 
       GOTO 100
      ELSE
        DO  IB=1,NBIN_ML
          IF(NREF_ML(IB).LT.NMIN_REF_IN_BINS) THEN
C
C---  Increase the bin size
            BINSIZE_ML = BINSIZE_ML + BINSIZE_ML_DELTA           
            NBIN_ML = MAX(1,MIN(NBIN_ML-1,
     &       INT(((STLMAX_ML**2-STLMIN_ML**2)/BINSIZE_ML)) 
     &               + 1))
            BINSIZE_ML = 
     &         ((STLMAX_ML**2-STLMIN_ML**2)/NBIN_ML)
cd            WRITE(*,*)BINSIZE_ML,NBIN_ML
            GOTO 9
          ENDIF
        ENDDO

      ENDIF
C
 100  CONTINUE
      KERNEL_G = (SMAXB_ML(1)**2-SMINB_ML(1)**2)/2.0
      KERNEL_G_RAD = KERNEL_G
      NBIN_ML1 = NBIN_ML+1
      DELTA_S_TABLE = 0.0005
      N_POINTS_TABLE_S = INT((STLMAX_ML**2-STLMIN_ML**2)/DELTA_S_TABLE)
      N_POINTS_TABLE_S = MAX(20,MIN(2000,N_POINTS_TABLE_S))
      DELTA_S_TABLE = (STLMAX_ML**2-STLMIN_ML**2)/N_POINTS_TABLE_S
cd      WRITE(*,*)'tables ',N_POINTS_TABLE_S,DELTA_S_TABLE
      SMEANB_ML(1) = SMINB_ML(1)
      SMEANB_RAD(1) = SMINB_ML(1)**2
      IF(NBIN_ML.GT.1) THEN
        DO   I=2,NBIN_ML
          SMEANB_RAD(I) = SMINB_ML(I)**2
          SMEANB_ML(I) = (SMINB_ML(I)+SMAXB_ML(I)*2.0)/3.0
        ENDDO
      ENDIF
      SMEANB_ML(NBIN_ML1) = SMAXB_ML(NBIN_ML)
      SMEANB_RAD(NBIN_ML1) = SMAXB_ML(NBIN_ML)**2
c
C---  Define style for sigma and some other estimations
      if(1.0/SMAXB_ML(nbin_ml).GT.2.45.OR.NREF_ALL.LE.300) THEN
         SIGMA_REFINE_STYLE = 'BINS'
      else
         SIGMA_REFINE_STYLE = 'EXPS'
      endif
C
C---If MLUSEWORK is .false. then define different bins for sec.der.
C
      NBIN_RAD = NBIN_ML
      IF(.NOT.MLUSEWORK) THEN
        NMIN_REF_IN_BINS = 100
 101    continue
        BINSIZE_ML = 0.0005
        NBIN_RAD = MAX(1,MIN(MAXBIN,
     &     INT(((STLMAX_ML**2-STLMIN_ML**2)/BINSIZE_ML)) 
     &               + 1))
        NBIN_RAD = MAX(1,MIN(30,NBIN_RAD))
        BINSIZE_ML = 
     &         ((STLMAX_ML**2-STLMIN_ML**2)/NBIN_RAD)
        BINSIZE_ML_DELTA = BINSIZE_ML/5.0
C
 109    CONTINUE
        SMEANB_RAD(1) = STLMIN_ML
        DO   I=2,NBIN_RAD
          SMEANB_RAD(I) = (SMEANB_RAD(I-1)**2 + BINSIZE_ML)**(1.0/2.0)
        ENDDO
        SMEANB_RAD(NBIN_RAD+1) = STLMAX_ML
C
C---  Now check if there are enough reflections in each bin
C

C
C----Find number of reflections in the resolution bins
        DO   I=1,NBIN_RAD
          NREF_ML(I) = 0
        ENDDO
        NREF_ALL = 0
        DO   IREF=1,NO
          FREERCHK = .FALSE.
          IF(FREER_FLAG )THEN 
            IF( 
     +      (ABS(FREER(IREF)-LFreeRexcludeVal).GT.0.1))FREERCHK = .TRUE.
          END IF
          IF(((.NOT.FREER_FLAG).OR.FREERCHK).AND.SIGO(IREF).GT.0.0) THEN
            CALL INDTORS(NIND(IREF),RSQ)
            STL_C = SQRT(RSQ)
            DO   I=1,NBIN_RAD
              IF(STL_C.LE.SMEANB_RAD(I+1).AND.
     &           STL_C.GE.SMEANB_RAD(I)) THEN
                NREF_ML(I) = NREF_ML(I) + 1
                NREF_ALL   = NREF_ALL + 1
              ENDIF
            ENDDO
          ENDIF
        ENDDO
C
C----Check if there are enough reflection in each bin. 
        IF(NBIN_RAD.EQ.1) THEN 
         GOTO 200
        ELSE
          DO  IB=1,NBIN_RAD
            IF(NREF_ML(IB).LT.NMIN_REF_IN_BINS) THEN
C
C---  Increase the bin size
C
              BINSIZE_ML = BINSIZE_ML + BINSIZE_ML_DELTA           
              NBIN_RAD = MAX(1,MIN(NBIN_RAD-1,
     &         INT(((STLMAX_ML**2-STLMIN_ML**2)/BINSIZE_ML)) 
     &               + 1))
              BINSIZE_ML = 
     &         ((STLMAX_ML**2-STLMIN_ML**2)/NBIN_RAD)
cd            WRITE(*,*)BINSIZE_ML,NBIN_ML
              GOTO 109
            ENDIF
          ENDDO
        ENDIF
C
 200    CONTINUE
        DO   I=1,NBIN_RAD+1
          SMEANB_RAD(I) = SMEANB_RAD(I)**2
        ENDDO
      ENDIF
      KERNEL_G_RAD = (SMEANB_RAD(2)-SMEANB_RAD(1))/2.0
c
      RETURN
      END
C
      SUBROUTINE DEFINE_OVERALL_B(NREF,NIND,FO,SIGO)
      IMPLICIT NONE
      INCLUDE 'const.fh'
      INCLUDE 'weights.fh'
C
C---  Find overall B value using Patterson origin peak. It meant to be
C---  more reliable. 
      INTEGER NREF
      INTEGER NIND(*)
      REAL FO(*),SIGO(*)

      INTEGER I,IREF,N_PATT_POINTS,ISYSAB,ICENT
      INTEGER IHH(3)
      REAL DIST,RSQ,STL_C,SS,RHO,XX0,FO2,EPSI,DELTA_X,XX1,XX2
      INTEGER MAX_PATT_POINTS
      PARAMETER (MAX_PATT_POINTS = 100)
      REAL XX(MAX_PATT_POINTS),PATT(MAX_PATT_POINTS)
      REAL PATT_RES(MAX_PATT_POINTS)
      REAL LSTLSQ
      EXTERNAL LSTLSQ,UNPACK

      N_PATT_POINTS = 61
      DELTA_X       = 0.1
      DO   I=1,N_PATT_POINTS
        PATT(I) = 0.0
        XX(I)   = DELTA_X*FLOAT(I-1)
        XX0     = TWOPI*XX(I)*STLMAX_ML
        IF(I.EQ.1) THEN
          PATT_RES(1) = 1.0
        ELSE
          PATT_RES(I) = 3*(SIN(XX0)-XX0*COS(XX0))/XX0**3
        ENDIF
      ENDDO
C
      DO  IREF = 1,NREF
        IF(SIGO(IREF).GT.0.0) THEN
          CALL UNPACK(NIND(IREF),IHH(1),IHH(2),IHH(3))
          RSQ = 4.0*LSTLSQ(1,IHH(1),IHH(2),IHH(3))
          STL_C = SQRT(RSQ)
          CALL CENTR(IHH,ICENT)
          CALL EPSLON(IHH,EPSI,ISYSAB)

          FO2 = FO(IREF)**2/(FLOAT(ICENT+1)*EPSI)
          SS = TWOPI*STL_C
          PATT(1) = PATT(1) + FO2
          DO   I=2,N_PATT_POINTS
            XX0 = SS*XX(I)
            PATT(I) = PATT(I) + FO2*SIN(XX0)/XX0
          ENDDO
        ENDIF
      ENDDO
C
C---Now analyse
C
      OPEN(68,file='68.dat')
      DO   I=2,N_PATT_POINTS
        IF(PATT(I).LE.0.0.OR.PATT_RES(I).LE.0.0) GOTO 100
        XX0 = -PISQ8/2.0*XX(I)**2/(ALOG(PATT(I))-ALOG(PATT(1)))
        XX1 = -PISQ8/2.0*XX(I)**2/(ALOG(PATT_RES(I)-ALOG(PATT_RES(1))))
        xx2 = (xx0-xx1)/2.0
        WRITE(68,*)XX(I)**2,PATT(I)/PATT(1),PATT_RES(I)/PATT_RES(1),
     &                        XX0,XX1,XX2
      ENDDO
 100  CONTINUE
      STOP
      RETURN
      END
C
      SUBROUTINE MTZWRITE(NREF,LIND,NIND,FO,SIGO,FC,PHASE,FREER)
      IMPLICIT NONe
C
C---Mtz writer
      INTEGER MCOLS
      PARAMETER (MCOLS = 200)
      INTEGER MSETS
      PARAMETER (MSETS=MCOLS)

      INCLUDE 'agreem.fh'
      INCLUDE 'celsym.fh'
      INCLUDE 'refi_flags.fh'
      INCLUDE 'weights.fh'
      INCLUDE 'monitor.fh'
      INCLUDE 'const.fh'
      INCLUDE 'map_params.fh'
      include 'restr_files.fh'
      INTEGER NREF
      REAL FO(*),SIGO(*),FC(*),PHASE(*),FREER(*)
      INTEGER NIND(*),LIND(*)
      EXTERNAL UNPACK
C
C--Mtz things
      INTEGER LOOKUP(MCOLS)
      REAL BDATA(20)
      INTEGER IHH(3)
      LOGICAL TESTFREE1,TESTFREE2
C
      INTEGER NLPRGI,NLPRGO
      COMMON /MTZRD/NLPRGI,NLPRGO,LOOKUP
      CHARACTER LSPRGO(16)*30,CTPRGO(16)*1
      COMMON /MTZRDC/LSPRGO,CTPRGO
      REAL   COSC,SINC,COSAA,SINAA,COS2A,SIN2A,COSC2,SINC2
      COMMON /HKL_COMM/ COSC,SINC,COSAA,SINAA,COS2A,SIN2A,COSC2,SINC2
C
      INTEGER ISET,NDATASETS
      REAL DATCELL,DATWAVE
      CHARACTER*64 PNAME,XNAME,DNAME,PNAME_OUT,XNAME_OUT,DNAME_OUT
      COMMON /MTZSET/ NDATASETS,PNAME(MSETS),XNAME(MSETS),DNAME(MSETS),
     +         PNAME_OUT(MCOLS),XNAME_OUT(MCOLS),DNAME_OUT(MCOLS),
     +         DATCELL(6,MSETS),DATWAVE(MSETS)
C
      INTEGER I,NPART1,MTZOUT,IAPPND,ICELL,ICENT,ISYSAB,IR,IRR,I_INTER,
     &        IOUT
      REAL A_CALCS(NMAXPART),B_CALCS(NMAXPART),HH(3),A_ALL,B_ALL,
     &     SCALE_NOW,SCALE_P,SIGMA_IN,SIGMA,EPSI,WT1,DFDA,DFDB,DFDAA,
     &     DFDBB,DFDAB,FOM,FVALUE,FCC0,PHCC,PHCC0,RHO,STL_C,RSQ,PHSIGN,
     &     PHCOMB,A0,B0,A1,B1,F0,F1,PH0,PH1,YO,A_ALL1,B_ALL1,
     &     DET2,A11,A12,A22
      real a_allls,b_allls,s_local
      real auser,buser
      real w_h
      real fo_wt
c
      integer ifomap_unit,ifail,ll
C
C----Read old sorting order
      NPART1 = NPART + 1
C
c
c--Read FP_MAP if defined and replace FO with these
c
      if(fomap_flag) then
         ifail = -1
         ll = 0
         ifomap_unit = 0
         call ccpdpn(ifomap_unit,fomap_file,'UNKNOWN','U',ll,ifail)
         do i=1,nref
            read(ifomap_unit)fo(i),sigo(i),fo_wt
         enddo
         close(ifomap_unit)
         call applyscales_map(nref,nind,fo,sigo)
      endif
c
      CALL RDSORT(LIND)
C
      MTZOUT = 2
      IAPPND = 0
      CALL LWOPEN(MTZOUT,'HKLOUT')
      CALL LWTITL(MTZOUT,'  Output mtz file from refmac',1)
      DO    ICELL=4,6
        IF(CELL(4).LE.5.0.AND.CELL(5).LE.5.0.AND.CELL(6).LE.5.0) THEN
          CELL(4) = CELL(4)*RTODEG
          CELL(5) = CELL(5)*RTODEG
          CELL(6) = CELL(6)*RTODEG
        ENDIF
      ENDDO
      CALL LWCELL(MTZOUT,CELL)
      CALL LWSORT(MTZOUT,ISORT)
C
      NumPrimSymm = NumSymmetry/NSMULT
C            ******************************
      CALL LWSYMM(MTZOUT,
     +                NumSymmetry,
     +                 NumPrimSymm,
     +                  RealSymmMatrx,
     +                   Ltype,
     +                    NumSpaceGroup,
     +                     SpaceGroupName,
     +                      PointGroupName)
      CALL LWASSN(MTZOUT,LSPRGO,NLPRGO,CTPRGO,IAPPND)
C Store the project name and dataset name in the mtz header:
      IF (NDATASETS.GT.0) THEN
        DO ISET = 1,NDATASETS
CMDW-4.2          CALL LWID(MTZOUT,PNAME(ISET),DNAME(ISET))
          CALL LWIDX(MTZOUT,PNAME(ISET),XNAME(ISET),DNAME(ISET),
     +                      DATCELL(1,ISET),DATWAVE(ISET))
        ENDDO
CMDW-4.2        CALL LWIDAS(MTZOUT,NLPRGO,PNAME_OUT,DNAME_OUT,IAPPND)
        CALL LWIDASX(MTZOUT,NLPRGO,XNAME_OUT,DNAME_OUT,IAPPND)
      ENDIF
C

cd      CALL COPY_LSML2DPAR
      I_INTER = -1
      DO    IRR = 1,NREF
        IR      = LIND(IRR)
        IF(LIND(IRR).LT.0)IR = -IR
        PHSIGN = 1.0
        IF(LIND(IRR).LT.0) PHSIGN = -1.0
C            *******************************
        CALL EQUAL_MAGIC(MTZOUT,BDATA,20)
C            *******************************
C---Use LIND to find old sorting order
        CALL UNPACK(NIND(IR),IHH(1),IHH(2),IHH(3))
cd        write(*,*)IRR,LIND(IRR),NREF,FO(IR),SIGO(IR)
cd        WRITE(*,*)IHH

        CALL INDTORS(NIND(IR),RSQ)
        STL_C = SQRT(RSQ)
        RHO   = STL_C/2.0

        IF(STL_C.LT.SMINB_ML(1).OR.STL_C.GT.SMAXB_ML(NBIN_ML)) GOTO 100
        CALL CENTR(IHH,ICENT)
        CALL EPSLON(IHH,EPSI,ISYSAB)
C 
        BDATA(1) = PHSIGN*IHH(1)
        BDATA(2) = PHSIGN*IHH(2)
        BDATA(3) = PHSIGN*IHH(3)
        FOM      = 0.0
C
C ejd - I think FC(..) has already had Fobs B factor applied in subag sr propi?
        FCC0   = FC(IR+NPART*NOBS)
        PHCC0  = PHASE(IR+NPART*NOBS)
        IF(REFS.EQ.'LSQF') THEN
C
C----Write str.factors for case lsq with magnitudes
C----First write observed str.factors in "absolute" scale. Replace unobserved
C----and "free" reflections by calculated ones.
          IF(SIGO(IR).GT.0.0) THEN
            BDATA(4) = FO(IR)
            BDATA(5) = SIGO(IR)
          ENDIF
          IOUT = 6
          IF(FREER_FLAG) THEN
            BDATA(IOUT) = ABS(FREER(IR))
            IOUT = IOUT + 1
          ENDIF
C
C---write scaled and summed FC-s. 
          BDATA(IOUT) = FC(IR+NPART*NOBS)
          IOUT = IOUT + 1
          BDATA(IOUT) = PHSIGN*RTODEG*PHASE(IR+NPART*NOBS)
          IOUT = IOUT + 1
        ELSEIF(REFS.EQ.'MLKF') THEN
C
c---First extract partial As and Bs from scrambled phase and FC
          CALL EXTRACT_ABS(IR,FC,PHASE,A_CALCS,B_CALCS)
c---Now find D multiplied A_all and B_all
          WT1   = REAL(1+ICENT)*EPSI
          IF(SIGMA_REFINE_STYLE.EQ.'BINS') THEN
            A_ALL = 0.0
            B_ALL = 0.0
            a_allls = 0.0
            b_allls = 0.0
            IF(NPART.GT.0) THEN
              DO  I=1,NPART
                CALL LINTER_VALUE2(NBIN_ML,SMEANB_ML,SCALE_ML(1,I),
     &                               STL_C,
     &                              I_INTER,SCALE_NOW)
                A_ALL = A_ALL + A_CALCS(I)*SCALE_NOW
                B_ALL = B_ALL + B_CALCS(I)*SCALE_NOW
                s_local = scale_ls_part(i)/scale_ls_over*
     &               exp(-rsq*b_ls_part(i))
                a_allls = a_allls + a_calcs(i)*s_local
                b_allls = b_allls + b_calcs(i)*s_local
              ENDDO
            ENDIF
            CALL LINTER_VALUE2(NBIN_ML,SMEANB_ML,SCALE_ML(1,NPART1),
     &                              STL_C,
     &                              I_INTER,SCALE_P)
            A_ALL = A_ALL + A_CALCS(NPART1)*SCALE_P
            B_ALL = B_ALL + B_CALCS(NPART1)*SCALE_P
            a_allls = a_allls + a_calcs(npart1)
            b_allls = b_allls + b_calcs(npart1)
C
c---Extract Sigma
            CALL  LINTER_VALUE2(NBIN_ML,SMEANB_ML,SIGMA_ML,STL_C,
     &                              I_INTER,SIGMA_IN)  
          ELSE
            CALL CALC_ASANDBS_MLGAUSS(RSQ,A_ALL,B_ALL,A_CALCS(NPART1),
     &                  B_CALCS(NPART1),A_CALCS,B_CALCS)
            CALL CALC_SCALE_P(RSQ,SCALE_P)

            SIGMA_IN  = 0.0
            SIGMA_IN  = SIGMA_IN + SIGMA_ML_SCALE_OVER-
     &                                SIGMA_ML_B_OVER*RSQ/4.0
     &                              + SIGMA_ML_B1_OVER*RSQ*RSQ/16.0
            SIGMA_IN = SIGMA_IN    + SIGMA_ML_B2_OVER*RSQ*RSQ*RSQ/64.0
            SIGMA_IN  = EXP(AMAX1(-30.0,AMIN1(59.0,SIGMA_IN)))
          ENDIF             
          SIGMA_IN = SIGMA_IN*WT1
          YO       = FO(IR)
          CALL SIGCALC_ML(ICENT,SIGO(IR),SIGMA_IN,SIGMA)
C
c---Call to calculate phase combination and coefficents for 
C---gradient
          CALL DFUNCDAB_ML(ICENT,SIGMA,YO,A_ALL,B_ALL,IR,PHASE,DFDA,
     &                     DFDB,DFDAA,DFDAB,DFDBB,FVALUE,FOM)

cd          DET2 = DFDAA*DFDBB-DFDAB**2
cd          A11  = DFDBB/DET2
cd          A12  = -DFDAB/DET2
cd          A22  = DFDAA/DET2
cd          FOM  = SQRT(COSAA**2+SINAA**2)
cd          WRITE(*,*)YO,1.0-YO**2/SIGMA*(1-FOM**2),1.0/STL_C
C
C---Write Fo and Fc unnormalized and scaled to FC1
C
cd         CALL INTEGRATE_INFO(icent,sigma,yo,a_all,b_all,ir,phase,w_h)
cd        w_h = amax1(0.4,2.0*w_h)
         IF(SIGO(IR).GT.0.0) THEN
           BDATA(4) = FO(IR)
           BDATA(5) = SIGO(IR)
         END IF
         IOUT = 6
         IF(FREER_FLAG) THEN
           BDATA(IOUT) = ABS(FREER(IR))
           IOUT        = IOUT + 1
         ENDIF
C---write scaled FC-s. It can be scaled by other programs. Bulk solvent
C---etc have not been applied
c         FCC0 = SQRT(A_ALLl**2+B_ALLl**2)
c         PHCC0 = 0.0
c         if(FCC0.gt.0.0) PHCC0 = atan2(B_ALLl,A_ALLl)
         BDATA(IOUT) = FCC0
         IOUT        = IOUT + 1

         BDATA(IOUT) = PHSIGN*RTODEG*PHCC0
         IF(BDATA(IOUT).LT.0.0) BDATA(IOUT) = BDATA(IOUT) + 360.0
         IOUT        = IOUT + 1
         TESTFREE1   = .FALSE.
         TESTFREE2   = .TRUE.
         IF(SIGO(IR).GT.0.0) TESTFREE1 = .TRUE.
         IF(FREER_FLAG) THEN
           IF (ABS(FREER(IR) - LFreeRexcludeVal) .LT.0.1 )
     +       TESTFREE2 = .FALSE.
         END IF
         IF(TESTFREE1  .AND. (TESTFREE2.OR.FREE_FOR_MAP.EQ.'I')) THEN
C---Now write coefficients for 2mfo-dfc and mfo-dfc. Think about centric 
C---refections
cd             IF(ICENT.EQ.0) THEN
cd            A0          = FO(IR)*COSAA/AMAX1(0.0001,SCALE_P) - 
cd     &                              A_CALCS(NPART1)
cd            B0          = FO(IR)*SINAA/AMAX1(0.0001,SCALE_P) - 
cd     &                              B_CALCS(NPART1)
cd            IF(DET2.GT.0.0) THEN
              A0          = (FO(IR)*COSAA - A_ALL)
              B0          = (FO(IR)*SINAA - B_ALL)
cd            ELSE
cd              A0 = 0.0
cd              B0 = 0.0
cd            ENDIF
C
cd            A0  = -(DFDA*A11+DFDB*A12)
cd            B0  = -(DFDA*A12+DFDB*A22)
C
cd             ELSE
cd               A0          = 0.0
cd               B0          = 0.0
cd             ENDIF
            F0          = SQRT(A0*A0+B0*B0)
            PH0         = 0.0
            IF(F0.NE.0.0) PH0 = PHSIGN*ATAN2(B0,A0)*RTODEG
            IF(PH0.LT.0.0) PH0 = PH0 + 360.0
            A1          = FO(IR)*COSAA + A0
            B1          = FO(IR)*SINAA + B0
            F1          = SQRT(A1*A1+B1*B1)
            PH1         = 0.0
            IF(F1.NE.0.0) PH1 = PHSIGN*ATAN2(B1,A1)*RTODEG
            IF(PH1.LT.0.0) PH1 = PH1 + 360.0
            BDATA(IOUT) = F1*exp(b_sharp_map*rsq/4.0)
            IOUT = IOUT + 1
            BDATA(IOUT) = PH1
            IOUT = IOUT + 1
            BDATA(IOUT) = F0*exp(b_sharp_map*rsq/4.0)
            IOUT = IOUT + 1
            BDATA(IOUT) = PH0
            IOUT = IOUT + 1
            BDATA(IOUT) = FOM
            IOUT = IOUT + 1
            IF(MIR_FLAG.OR.PHASE_FLAG) THEN
              PHCOMB = 0.0
              IF(SINAA*SINAA+COSAA*COSAA.GT.0.0) 
     +               PHCOMB=PHSIGN*ATAN2(SINAA,COSAA)*RTODEG
              IF(PHCOMB.LT.0.0)PHCOMB = PHCOMB + 360.0
              BDATA(IOUT) = PHCOMB
              IOUT = IOUT + 1
            ENDIF
            if(scale_map_obs.gt.0.0.or.scale_map_calc.gt.0.0) then
              AUSER       = scale_map_obs*FO(IR)*COSAA - 
     &                              scale_map_calc*A_ALL
              BUSER       = scale_map_obs*FO(IR)*SINAA - 
     &                              scale_map_calc*B_ALL
              BDATA(iout) = sqrt(auser**2+buser**2)*
     &                   exp(b_sharp_map*rsq/4.0)
              iout = iout + 1
              bdata(iout) = 0.0
              if(bdata(iout-1).gt.0.0) then
                bdata(iout) = PHSIGN*ATAN2(buser,auser)*RTODEG
                if(bdata(iout).lt.0.0) bdata(iout) = bdata(iout) +360.0
              endif
              iout = iout + 1
            endif

         ELSE IF(.NOT.TESTFREE1.OR.FREE_FOR_MAP.EQ.'R') THEN
C
C---Non measured reflection. Assume that <FO> = sumDFC. Then difference
C---map will have zero coefficient and 2fo-fc will have sumDFC
             BDATA(IOUT) = SQRT(A_ALL*A_ALL+B_ALL*B_ALL)
             PHCC        = 0.0
             IF(BDATA(IOUT).GT.0.0) PHCC = ATAN2(B_ALL,A_ALL)
             IOUT        = IOUT + 1
             BDATA(IOUT) = PHSIGN*PHCC*RTODEG
             IF(BDATA(IOUT).LT.0.0) BDATA(IOUT) = BDATA(IOUT) + 360.0
             IOUT        = IOUT + 1
             BDATA(IOUT) = 0.0
             IOUT        = IOUT + 1
             BDATA(IOUT) = 0.0
             IOUT        = IOUT + 1
             BDATA(IOUT) = 0.0
             IOUT        = IOUT + 1
             IF(MIR_FLAG.OR.PHASE_FLAG) THEN
               BDATA(IOUT) =  PHSIGN*PHCC*RTODEG
               IF(BDATA(IOUT).LT.0.0) BDATA(IOUT) = BDATA(IOUT) + 360.0
               IOUT        = IOUT + 1
             ENDIF
             if(scale_map_obs.gt.0.0.or.scale_map_calc.gt.0.0) then
               bdata(iout) = 0.0
               iout = iout + 1
               bdata(iout) = 0.0
               iout = iout + 1
             endif
           ENDIF
         ENDIF
         CALL LWREFL(MTZOUT,BDATA)
100      CONTINUE
       ENDDO
C
C--Careful. Check it
C
cd       NOBS = NREF
       CALL LWCLOS(MTZOUT,0)
       RETURN
       END
C

C
cd      SUBROUTINE BIAS_CALCULATE(NREF,NIND,FO,SIGO,FC,SCALE_BIAS,B_BIAS)
cd      IMPLICIT NONE
C
cd      INTEGER NREF
cd      INTEGER NIND(*)
cd      REAL FO(*),FC(*),SIGO(*)
cd      REAL SCALE_BIAS,B_BIAS
C
C---  local variables
cd      INTEGER IR,ISYSAB,ICENT
cd      INTEGER IHH(3)
cd      REAL RSQ,STL_C,EPSI,WT1
cfut      
cfut      SCALE_BIAS = 1.0
cfut      B_BIAS     = 0.0
C
cfut      DO IR=1,NREF
C       
cfut        IF(SIGO(IR).GT.0.0) THEN
cfut          CALL UNPACK(NIND(IR),IHH(1),IHH(2),IHH(3))
cfut          CALL INDTORS(NIND(IR),RSQ)
cfut          STL_C = SQRT(RSQ)
cfut          CALL CENTR(IHH,ICENT)
cfut          CALL EPSLON(IHH,EPSI,ISYSAB)
cfut          WT1 = DBLE(ICENT+1)*DBLE(EPSI)
cfut          CALL CALC_TCHEB_APPROX_CLENSHW(N_COEFS,SCURRENT,TCH_COEFS,
cfut     &                 SIGMA_IN)
cfut          SIGMA_IN  = SIGMA_IN + SIGMA_ML_SCALE_OVER-
cfut     &                                 SIGMA_ML_B_OVER*RSQ
cfut          SIGMA_IN  = EXP(AMAX1(1.0,AMIN1(30.0,SIGMA_IN)))*WT1
cfut          CALL SIGCALC_ML(ICENT,SIGO(IR),SIGMA_IN,SIGMA)
cfut          CALL EXTRACT_ABS(IR,FC,PHASE,A_CALCS,B_CALCS)
c---Now find D multiplied A_all and B_all
cfut          CALL CALC_ASANDBS_MLGAUSS(RSQ,A_ALL,B_ALL,A_CALCS(NPART1),
cfut     &                  B_CALCS(NPART1),A_CALCS,B_CALCS)
cfut          CALL CALC_SCALE_P(RSQ,SCALE_P)
c---Call to calculate phase combination and coefficents for 
C---gradient
cfut          CALL DFUNCDAB_ML(ICENT,SIGMA,YO,A_ALL,B_ALL,IR,PHASE,DFDA,
cfut     &                     DFDB,DFDAA,DFDAB,DFDBB,FVALUE,FOM)
cfut              A0          = (FO(IR)*COSAA - A_ALL)
cfut              B0          = (FO(IR)*SINAA - B_ALL)
cfut              B(1) = 
cfut              B(2) =
cfut              A(1,1) = 
cfut              A(1,2) = 
cfut              A(2,2) = 
cfut              FVALUE = 
cfut        ENDIF
cfut      ENDDO
C
C---Solve equation and apply shifts
cfut      CALL DEIGEN
C
C---Line minimiser

cfut      write(*,*)scale_bias,b_bias

cfut      RETURN
cfut      END
C
       SUBROUTINE FOMPHASE2AB(ICENT,FOM,PHASE,HLA,HLB)
C
C--Calculates Hendrickson and Lattman A and B from FOM and PHIbest
C
       INCLUDE 'const.fh'
       INCLUDE 'expcost.fh'
       REAL HLA,HLB
C
       IF(FOM.GT.0.9999) FOM = 0.9999
       IF(FOM.EQ.0.0) THEN
          XX = 0.0
       ELSEIF(FOM.LE.0.9999) THEN
         IF(ICENT.NE.0) THEN
          XX = LOG((1+FOM)/(1-FOM))*0.5
         ELSE
          DO  J=2,19
            IF(ABTAB(J).GT.FOM) GOTO 40
          ENDDO
40        XX = ((FOM-ABTAB(J-1))/ (ABTAB(J)-ABTAB(J-1))+REAL(J-2))/3.0
         ENDIF
       ELSE
         XX = 250.0
       ENDIF
       HLA = COS(DEGTOR*PHASE)*XX
       HLB = SIN(DEGTOR*PHASE)*XX
       RETURN
       END
C
       SUBROUTINE BESSTAB
       INCLUDE 'expcost.fh'
C
       DO     J=1,20
          XX = REAL(J-1)/3.0
          ABTAB(J) = (XX+0.4807)*XX/ ((XX+0.8636)*XX+1.3943)
       ENDDO
       RETURN
       END
C
      subroutine prepare_excl_refi
      implicit none
C
C---prepares atoms to be excluded from various options (in ideal world)
C---current version converts occupancy of atoms to be excluded to 0
C---
      include 'atom_com.fh'
      include 'refi_flags.fh'
C
      integer ia,iexcl
      integer ires_num_loc
      character chnid_loc*4
C
      if(excl_refi_num.gt.0) then
        do   ia=1,n_atom
           call get_chain_namepdb(chnid_loc,i_resid(ia))
c           chnid_loc = res_num_pdb(i_resid(ia))(1:1)
           read(res_num_pdb(i_resid(ia))(3:6),*)ires_num_loc 
           do   iexcl=1,excl_refi_num
             if(excl_refi_begin(iexcl).le.ires_num_loc.and.
     &          excl_refi_end(iexcl).ge.ires_num_loc.and.
     &          excl_refi_chn(iexcl).eq.chnid_loc) then
               occup(ia) = 0.0
             endif
           enddo
         enddo
       endif
       return
       end
